
/* Copyright (C) 2003-2008, Free Software Foundation, Inc.
   Contributed by Andy Vaught

  This file is part of g95.

  G95 is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2, or (at your option)
  any later version.

  G95 is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with g95; see the file COPYING.  If not, write to
  the Free Software Foundation, 59 Temple Place - Suite 330,
  Boston, MA 02111-1307, USA.

  In addition to the permissions in the GNU General Public License, the
  Free Software Foundation gives you unlimited permission to link the
  compiled version of this file into combinations with other programs,
  and to distribute those combinations without any restriction coming
  from the use of this file.  (The General Public License restrictions
  do apply in other respects; for example, they cover modification of
  the file, and distribution when not linked into a combined executable.)
*/

/* Miscellaneous intrinsics */

#include <math.h>
#include "runtime.h"


#define aimag_4 prefix(aimag_4)

float aimag_4(z4 *z) {

  return z->c;
}


#define aimag_8 prefix(aimag_8)

float aimag_8(z8 *z) {

  return z->c;
}


#define amod_i4 prefix(amod_i4)

G95_INT4 amod_i4(G95_INT4 *a, G95_INT4 *p) {

  return *a - (*a / *p)*(*p);
}


#define amod_i2 prefix(amod_i2)

G95_INT2 amod_i2(G95_INT2 *a, G95_INT2 *p) {

  return *a - (*a / *p)*(*p);
}

#define amod_i1 prefix(amod_i1)

char amod_i1(char *a, char *p) {

  return *a - (*a / *p)*(*p);
}

#ifdef G95_INT8
#define amod_i8 prefix(amod_i8)

G95_INT8 amod_i8(G95_INT8 *a, G95_INT8 *p) {

  return *a - (*a / *p)*(*p);
}
#endif

#ifdef G95_INT16
#define amod_i16 prefix(amod_i16)

G95_INT16 amod_i16(G95_INT16 *a, G95_INT16 *p) {

  return *a - (*a / *p)*(*p);
}
#endif


#define amod_r4 prefix(amod_r4)

float amod_r4(float *a, float *p) {

  return *a - truncf(*a / *p) * (*p);
}


#define amod_r8 prefix(amod_r8)

double amod_r8(double *a, double *p) {

  return *a - trunc(*a / *p) * (*p);
}


#define conjg_4 prefix(conjg_4)

void conjg_4(z4 *r, z4 *z) {

  r->r = z->r;
  r->c = -z->c;
}


#define conjg_8 prefix(conjg_8)

void conjg_8(z8 *r, z8 *z) {

  r->r = z->r;
  r->c = -z->c;
}


#define dim_i1 prefix(dim_i1)

G95_INT1 dim_i1(G95_INT1 *x, G95_INT1 *y) {
signed char r;

  r = *x - *y;
  if (r < 0) r = 0;

  return r;
}


#define dim_i2 prefix(dim_i2)

G95_INT2 dim_i2(G95_INT2 *x, G95_INT2 *y) {
G95_INT2 r;

  r = *x - *y;
  if (r < 0) r = 0;

  return r;
}


#define dim_i4 prefix(dim_i4)

G95_INT4 dim_i4(G95_INT4 *x, G95_INT4 *y) {
G95_INT4 r;

  r = *x - *y;
  if (r < 0) r = 0;

  return r;
}


#ifdef G95_INT8
#define dim_i8 prefix(dim_i8)

G95_INT8 dim_i8(G95_INT8 *x, G95_INT8 *y) {
G95_INT8 r;

  r = *x - *y;
  if (r < 0) r = 0;

  return r;
}

#endif


#ifdef G95_INT16
#define dim_i16 prefix(dim_i16)

G95_INT16 dim_i16(G95_INT16 *x, G95_INT16 *y) {
G95_INT16 r;

  r = *x - *y;
  if (r < 0) r = 0;

  return r;
}

#endif


#define dim_r4 prefix(dim_r4)

float dim_r4(float *x, float *y) {
float r;

  r = *x - *y;
  if (r < 0.0) r = 0.0;

  return r;
}


#define dim_r8 prefix(dim_r8)

double dim_r8(double *x, double *y) {
double r;

  r = *x - *y;
  if (r < 0.0) r = 0.0;

  return r;
}


#define dprod prefix(dprod)

double dprod(float *x, float *y) {

  return ((double) *x) * ((double) *y);
}


#define sign_i1 prefix(sign_i1)

G95_INT1 sign_i1(signed G95_INT1 *a, signed G95_INT1 *b) {
signed char v;

  v = *a;
  if (v < 0)
    v = -v;

  if (*b < 0)
    v = -v;

  return v;
}


#define sign_i2 prefix(sign_i2)

G95_INT2 sign_i2(G95_INT2 *a, G95_INT2 *b) {
G95_INT2 v;

  v = *a;
  if (v < 0)
    v = -v;

  if (*b < 0)
    v = -v;

  return v;
}


#define sign_i4 prefix(sign_i4)

G95_INT4 sign_i4(G95_INT4 *a, G95_INT4 *b) {
G95_INT4 v;

  v = *a;
  if (v < 0)
    v = -v;

  if (*b < 0)
    v = -v;

  return v;
}


#ifdef G95_INT8
#define sign_i8 prefix(sign_i8)

G95_INT8 sign_i8(G95_INT8 *a, G95_INT8 *b) {
G95_INT8 v;

  v = *a;
  if (v < 0)
    v = -v;

  if (*b < 0)
    v = -v;

  return v;
}
#endif


#ifdef G95_INT16
#define sign_i16 prefix(sign_i16)

G95_INT16 sign_i16(G95_INT16 *a, G95_INT16 *b) {
G95_INT16 v;

  v = *a;
  if (v < 0)
    v = -v;

  if (*b < 0)
    v = -v;

  return v;
}
#endif
