#include <gtk/gtk.h>
#include <stdio.h>
#include <stdlib.h>
#include <regex.h>
#include <unistd.h>
#include <pwd.h>
#include <string.h>
#include <wordexp.h>
#include <limits.h>
#include "eggtrayicon.h"
#include "ftmenu.h"

EggTrayIcon *tray_icon;

GtkWidget *img = NULL,				// image used on the tray 
			 *menu[MAX_MENU_DEPTH];	// array of commands to execute

regex_t	reg_file,					// checking of the menu file path 
			reg_begin,					// checking of the begin of menu file [begin]
			reg_exec,					// checking of executable items [exec]
			reg_submenu,				// checking of start of submenus
			reg_paren,					// checking of "(name)" expressions
			reg_icon,					// checking of "<name>" expressions
			reg_end,						// checking of submenus end [end]
			reg_command;				// checking of "{name}" expressions 

gchar *iconfile;						// icon to put on the tray
gchar *commands[MAX_COMMANDS];	// commands to execute
int	menu_depth		= 0,			// current menu depth
		command_index	= 0;			// index of the command array

/**
 * About dialog
 */
static void menu_about(void){
	GtkWidget *about = NULL;
	about = gtk_about_dialog_new();
	gtk_about_dialog_set_name		(GTK_ABOUT_DIALOG(about),APP_NAME);
	gtk_about_dialog_set_version	(GTK_ABOUT_DIALOG(about),APP_VERSION);
	gtk_about_dialog_set_copyright(GTK_ABOUT_DIALOG(about),APP_AUTHOR);
	gtk_about_dialog_set_comments (GTK_ABOUT_DIALOG(about),APP_DESCRIPTION);
	gtk_about_dialog_set_license  (GTK_ABOUT_DIALOG(about),APP_LICENSE);
	gtk_about_dialog_set_website  (GTK_ABOUT_DIALOG(about),APP_WEBSITE);
	gtk_widget_show(about);
}

/**
 * Pop ups the main menu, when clicked with left button, and
 * the About dialog box when clicked with the right button
 */
static void menu_popup(GtkWidget *widget, GdkEventButton *event, gpointer data){
	if(event->button==1)
		gtk_menu_popup(GTK_MENU(menu[0]),NULL,NULL,NULL,NULL,event->button,event->time);
	else	
		menu_about();
}

/**
 *	Execute the selected command
 */
static void execute(char *s){
	g_spawn_command_line_async(s,0);
}

/**
 * Execute the fbrun utility
 */
static void fbrun(){
	execute("fbrun");
}

/**
 * Extracts a substring (why the hell people does not make a standard function to
 * make this?)
 */
char* substring(char *dest,char *source,int start,int end){
	int istr, isub;
	for(istr=start,isub=0;istr<end;istr++,isub++)
		dest[isub]=source[istr];
	dest[isub]=0;
	return dest;
}

/**
 * Makes the menu title
 */
char* maketitle(char *dest,char *source,regmatch_t t[]){
	return substring(dest,source,t[0].rm_so+1,t[0].rm_eo-1);
}

/**
 * Creates a submenu
 */
void makesubmenu(char *source,regmatch_t t[]){
	GtkWidget *submenuitem;
	gchar label[strlen(source)], icon[strlen(source)];
	substring(label,source,t[0].rm_so+1,t[0].rm_eo-1);
	menu_depth++;								// increase the menu depth
	menu[menu_depth] = gtk_menu_new();	// creates a submenu
	
	// check if there is an icon there
	if(regexec(&reg_icon,source,5,t,0)==0){
		substring(icon,source,t[0].rm_so+1,t[0].rm_eo-1);
		submenuitem = gtk_image_menu_item_new_with_label(label);
		gtk_image_menu_item_set_image(GTK_IMAGE_MENU_ITEM(submenuitem),gtk_image_new_from_file(icon));
	}else	
		submenuitem = gtk_menu_item_new_with_label(label);		// sets the submenu label
	gtk_menu_item_set_submenu(GTK_MENU_ITEM(submenuitem),menu[menu_depth]);
	gtk_menu_shell_append(GTK_MENU_SHELL(menu[menu_depth-1]), submenuitem);
}

/**
 * Make a new menu item, on the current menu 
 */
void makemenuitem(char* source,regmatch_t t[]){
	GtkWidget *menuitem;
	gchar label[strlen(source)], icon[strlen(source)], command[strlen(source)];

	// finds the menu label	
	substring(label,source,t[0].rm_so+1,t[0].rm_eo-1);
	
	// check if there is an icon there
	if(regexec(&reg_icon,source,5,t,0)==0){
		substring(icon,source,t[0].rm_so+1,t[0].rm_eo-1);
		menuitem = gtk_image_menu_item_new_with_label(label);
		gtk_image_menu_item_set_image(GTK_IMAGE_MENU_ITEM(menuitem),gtk_image_new_from_file(icon));
	}else
		menuitem = gtk_menu_item_new_with_label(label);
	gtk_menu_shell_append(GTK_MENU_SHELL(menu[menu_depth]), menuitem);

	// check the command
	if(regexec(&reg_command,source,5,t,0)==0 &&
		command_index < MAX_COMMANDS){
		substring(command,source,t[0].rm_so+1,t[0].rm_eo-1);
		commands[command_index] = g_malloc(strlen(command)+1);
		strcpy(commands[command_index],command);
		g_signal_connect_swapped(G_OBJECT(menuitem),"button-press-event",G_CALLBACK(execute),commands[command_index]);
		command_index++;
	}
}	

/**
 * Creates menu and menu items
 */
static void menu_create(void){
	GtkWidget *menuitem;
	FILE *file = NULL;
	size_t line_len = MAX_LINE_LENGTH;
	wordexp_t exp_result;
	gchar menufile[PATH_MAX], menutitle[1024];
	gchar *line = NULL;
	int nchars;
	regmatch_t exp_match[5];

	// find the Fluxbox init file
	wordexp("~",&exp_result,0);
	file = fopen(strncat(exp_result.we_wordv[0],"/.fluxbox/init",PATH_MAX-1),"r");
	if(!file){
		g_print("nao achei o arquivo");
		return;
	}

	// alloc memory for reading from files
	line = g_malloc(MAX_LINE_LENGTH);
	if(line==NULL){
		g_print("nao aloquei memoria");
		return;
	}

	// creates the regexp's
	regcomp(&reg_file		,"^session\\.menuFile",0);
	regcomp(&reg_begin	,"^.*\\[begin"		,0);
	regcomp(&reg_exec		,"^.*\\[exec"		,0);
	regcomp(&reg_submenu	,"^.*\\[submenu"	,0);
	regcomp(&reg_end   	,"^.*\\[end"	   ,0);
	regcomp(&reg_paren   ,"(.*)"           ,0);
	regcomp(&reg_icon    ,"<.*>"           ,0);
	regcomp(&reg_command ,"{.*}"           ,0);

	// find the menu file	
	while((nchars=getline(&line,&line_len,file))>0){
		if(regexec(&reg_file,line,0,NULL,0)==0){
			g_strstrip(line);
			line = strchr(line,':');		// break into tokens
			line++;								// go to the next token
			wordexp(line,&exp_result,WRDE_REUSE);
			strcpy(menufile,exp_result.we_wordv[0]);
		}
	}
	fclose(file);
	wordfree(&exp_result);

	// creates the menu
	menu[0] = gtk_menu_new();

	// read the menu file
	file = fopen(menufile,"r");
	while((nchars=getline(&line,&line_len,file))>0){
		// finds the menu title
		if(regexec(&reg_begin,line,0,NULL,0)==0){
			if(regexec(&reg_paren,line,(size_t) 1,exp_match,0)==0){
				maketitle(menutitle,line,exp_match);				
				menuitem = gtk_menu_item_new_with_label(menutitle);
				gtk_menu_shell_append(GTK_MENU_SHELL(menu[0]), menuitem);
				gtk_menu_shell_append(GTK_MENU_SHELL(menu[0]), gtk_separator_menu_item_new());

				// check the icon here
				if(regexec(&reg_icon,line,(size_t)5,exp_match,0)==0){
					iconfile = g_malloc(strlen(line));
					if(!iconfile)
						g_print("Error allocating memory for icon path");
					substring(iconfile,line,exp_match[0].rm_so+1,exp_match[0].rm_eo-1);
				}
			}
		// menu item ([exec])
		}else if(regexec(&reg_exec,line,(size_t)0,NULL,0)==0){
			if(regexec(&reg_paren,line,(size_t)5,exp_match,0)==0)
				makemenuitem(line,exp_match);
		// submenu ([submenu])	
		}else if(regexec(&reg_submenu,line,(size_t)5,exp_match,0)==0){
			if(regexec(&reg_paren,line,(size_t)5,exp_match,0)==0)
				makesubmenu(line,exp_match);
		// end ([end])
		}
		else if(regexec(&reg_end,line,(size_t)5,exp_match,0)==0)
			menu_depth--;		
	}
	fclose(file);
	g_free(&line);

	regfree(&reg_file);
	regfree(&reg_begin);
	regfree(&reg_exec);
	regfree(&reg_submenu);
	regfree(&reg_end);
	regfree(&reg_paren);
	regfree(&reg_icon);
	regfree(&reg_command);

	gtk_menu_shell_append(GTK_MENU_SHELL(menu[0]), gtk_separator_menu_item_new());

	menuitem = gtk_menu_item_new_with_label("Execute");
	gtk_menu_shell_append(GTK_MENU_SHELL(menu[0]), menuitem);
	g_signal_connect(G_OBJECT(menuitem),"activate",G_CALLBACK(fbrun),0);
	
	menuitem = gtk_menu_item_new_with_label("About");
	gtk_menu_shell_append(GTK_MENU_SHELL(menu[0]), menuitem);
	g_signal_connect(G_OBJECT(menuitem),"activate",G_CALLBACK(menu_about),0);
	
	menuitem = gtk_menu_item_new_with_label("Exit");
	gtk_menu_shell_append(GTK_MENU_SHELL(menu[0]), menuitem);
	g_signal_connect(G_OBJECT(menuitem),"activate",G_CALLBACK(gtk_main_quit),0);
	
	gtk_widget_show_all(menu[0]);
}

/**
 * Creates the tray icon
 */
static void tray_create(void){
	GtkWidget *box;

	if(!menu[0])
		menu_create();
	
	// cria o trayicon aqui	
	tray_icon = egg_tray_icon_new("Fluxbox_tray_menu");
	if(!tray_icon)
		g_error("Could not create the icon!");
	img = gtk_image_new_from_file(iconfile);

	// cria a box
	box = gtk_event_box_new();

	gtk_container_add(GTK_CONTAINER(box),img);
	gtk_container_add(GTK_CONTAINER(tray_icon),box);
	gtk_widget_show_all(GTK_WIDGET(tray_icon));
	g_signal_connect(G_OBJECT(box),"button-press-event",G_CALLBACK(menu_popup),NULL);
}

/**
 * Destroy the tray icon
 */
static void tray_destroy(void){ 
	int i;
	for(i=command_index;i<=0;i--)
		g_free(commands[i]);
	g_free(iconfile);
	gtk_widget_destroy(GTK_WIDGET(img));
	gtk_widget_destroy(GTK_WIDGET(tray_icon));
}

/**
 * Main
 */
int main(int argc,char *argv[]){
	gtk_init(&argc,&argv);
	tray_create();
	gtk_main();
	tray_destroy();
	return 0;
}
