typedef enum {
    V4L,  /* video4linux */
} FwksPaletteNameSpace;

typedef enum {
    /* See video4linux and video4linux2 docs for more info. */
    FWKS_PALETTE_GREY,
    FWKS_PALETTE_RGB555,
    FWKS_PALETTE_RGB565,
    FWKS_PALETTE_RGB24,
    FWKS_PALETTE_BGR24,
    FWKS_PALETTE_RGB32,
    FWKS_PALETTE_BGR32,
    FWKS_PALETTE_YUV422,
    FWKS_PALETTE_YUYV,
    FWKS_PALETTE_UYVY,
    FWKS_PALETTE_YUV420,
    FWKS_PALETTE_YUV411,
    FWKS_PALETTE_YUV422P,  /* P always means planar (vs. "packed") */
    FWKS_PALETTE_YUV411P,
    FWKS_PALETTE_YUV420P,
    FWKS_PALETTE_YUV410P,
} FwksPalette;

struct RawBuf {
    gint height;  /* dimensions in pixels */
    gint width;
    gfloat bpp;  /* bytes per pixel */
    FwksPalette format;
    guint8 * data;
};

FwksPalette
colorspace_palette(FwksPaletteNameSpace ns, gint palette);
gfloat
colorspace_bytes_per_pixel(FwksPalette palette);

void
colorspace_rawbuf_to_rgb24(struct RawBuf *rawbuf,
                           guint8 *rawrgb24,
                           gint rowstride);
