/* functions to take care of an Animation struct, save a series of
 * frames to disk, currently just keeps everything on disk, no cache
 * in memory (doesn't the os handle that? ...seems to).
 */

#include "common.h"

GString * filename(struct Animation *animation, gint num);

GString * filename(struct Animation *animation, gint num)
{
    GString *file;

    file = g_string_new("");
    g_string_printf(file, "%s_%04d.png", animation->base_filename->str, num);
    if (animation->path != NULL) {
        g_string_prepend(file, "/");
        g_string_prepend(file, animation->path->str);
    }
    return file;
}

void frameworks_animation_initialize(struct Animation *animation)
{
	animation->current_frame = 1;
        animation->last_frame = 0;
	animation->base_filename = g_string_new("frame");
	animation->path = NULL;
}

void frameworks_animation_increment(struct Animation *animation)
{
        if (animation->current_frame > animation->last_frame)
            animation->last_frame = animation->current_frame;
        animation->current_frame++;
}

void frameworks_animation_decrement(struct Animation *animation)
{
    animation->current_frame--;
}

int frameworks_animation_get_current_frame(struct Animation *animation)
{
    return animation->current_frame;
}

void frameworks_animation_set_current_frame(struct Animation *animation, int value)
{
    animation->current_frame = value;
}

gint frameworks_animation_get_last_frame(struct Animation *animation)
{
    return animation->last_frame;
}

void frameworks_animation_set_filename(struct Animation *animation, GString *filename)
{
    gchar *base;
    gchar *path;

    if (animation->base_filename != NULL)
        g_string_free(animation->base_filename, TRUE);
    if (animation->path != NULL)
        g_string_free(animation->path, TRUE);

    base = g_path_get_basename(filename->str);
    path = g_path_get_dirname(filename->str);
    animation->base_filename = g_string_new(base);
    animation->path = g_string_new(path);
    g_free(base);
    g_free(path);
}

int frameworks_animation_put(struct Animation *animation, GdkPixbuf * pixbuf)
{
    int value;
    GString *file;

    file = filename(animation, animation->current_frame);
    value = gdk_pixbuf_save(pixbuf, file->str, "png", NULL, NULL);
    g_string_free(file, TRUE);

    frameworks_animation_increment(animation);
    return value;
}

/* delete a frame, moving all other frames up one notch */
void frameworks_animation_delete(struct Animation *animation, gint num)
{
    GString *file;
    GString *src, *dest;

    file = filename(animation, num);
    
    g_string_free(file, TRUE);
}

GdkPixbuf * frameworks_animation_get_pixbuf(struct Animation *animation, gint num)
{
    GString *file;
    GdkPixbuf *frame;
    
    if (num <= animation->last_frame && num >= 1) {
        file = g_string_new("");
        g_string_printf(file, "%s_%04d.png", animation->base_filename->str, num);
        if (animation->path != NULL) {
            g_string_prepend(file, "/");
            g_string_prepend(file, animation->path->str);
        }

        frame = gdk_pixbuf_new_from_file(file->str, NULL);
        return frame;
    } else
        return NULL;
}
    
        
