/*****************************************************************
 * tga2fbm.c: FBM Release 1.0 25-Feb-90 Michael Mauldin
 *
 * Copyright (C) 1989,1990 by Michael Mauldin.  Permission is granted
 * to use this file in whole or in part for any purpose, educational,
 * recreational or commercial, provided that this copyright notice
 * is retained unchanged.  This software is available to all free of
 * charge by anonymous FTP and in the UUNET archives.
 *
 * tga2fbm.c: convert a bitmap to Targa format
 *
 * USAGE
 *	% tga2fbm [ image ] > image.tga
 *
 * EDITLOG
 *	LastEditDate = Mon Jun 25 00:23:06 1990 - Michael Mauldin
 *	LastFileName = /usr2/mlm/src/misc/fbm/tga2fbm.c
 *
 * HISTORY
 * 25-Jun-90  Michael Mauldin (mlm@cs.cmu.edu) Carnegie Mellon
 *	Package for Release 1.0
 *
 * 03-May-89  Michael Mauldin (mlm) at Carnegie Mellon University
 *	Beta release (version 0.93) mlm@cs.cmu.edu
 *****************************************************************/

# include <stdio.h>
# include <math.h>
# include "fbm.h"

# define USAGE\
"Usage: tga2fbm [ image ] > image.tga"

#ifndef lint
static char *fbmid =
"$FBM tga2fbm.c <1.0> 25-Jun-90  (C) 1989,1990 by Michael Mauldin, source \
code available free from MLM@CS.CMU.EDU and from UUNET archives$";
#endif

main (argc, argv)
int argc;
char *argv[];
{ FBM image;

  /* Clear pointers */
  image.cm = image.bm = (unsigned char *) NULL;

  /* Open input if given */
  if (argc > 1)
  { if (freopen (argv[1], "r", stdin) != stdin)
    { perror (argv[1]);
      exit(1);
    }
  }

  if (read_tga (&image, stdin, "", 0) &&
       write_fbm (&image, stdout))
  { exit(0); }
  else
  { exit (1); }
}

