## Contributing to *erdtree*

Thank you for taking an interest in *erdtree*! If you'd like to play a part in the development of *erdtree*, the following forms of participation are acceptable:
  * New issues: feature requests, bug reports, questions, ideas, etc..
  * Pull requests: documentation improvements, bug fixes, code improvements, new features, etc..

The following are the general rules for contributing code:
  * Every function, struct, traits, etc. no matter how trivial, should be documented in `cargo doc` fashion.
  * When adding or amending a new feature and if warranted, the `usage` as well as the `documentation` section of the README should be updated appropriately.
  * Integration is usually required when adding or amending a feature that alters the output.
  * All existing tests must pass.
  * Unit testing is encouraged but not required.

**Note**: Before you take the time to open a pull request, please open an issue first to open the floor for discussion.
