/* eLectrix - a pdf viewer
 * Copyright (C) 2010 Martin Linder <mali2297@users.sf.net>
 * 
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program. If not, see <http://www.gnu.org/licenses/gpl-2.0.html>.
 */
#pragma once
#ifndef __E6X_WINDOW_H__
#define __E6X_WINDOW_H__

#include <gtk/gtk.h>
#include "e6x-document.h"

#define E6X_TYPE_WINDOW \
  (e6x_window_get_type ())
#define E6X_WINDOW(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST ((obj), E6X_TYPE_WINDOW, E6xWindow))
#define E6X_WINDOW_CLASS(obj) \
  (G_TYPE_CHECK_CLASS_CAST ((obj), E6X_TYPE_WINDOW,  E6xWindowClass))
#define E6X_IS_WINDOW(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE ((obj), E6X_TYPE_WINDOW))
#define E6X_IS_WINDOW_CLASS(obj) \
  (G_TYPE_CHECK_CLASS_TYPE ((obj), E6X_TYPE_WINDOW))
#define E6X_WINDOW_GET_CLASS(obj) \
  (G_TYPE_INSTANCE_GET_CLASS ((obj), E6X_TYPE_WINDOW, E6xWindowClass))

typedef struct _E6xWindow E6xWindow;
typedef struct _E6xWindowClass E6xWindowClass;
typedef struct _E6xWindowPrivate E6xWindowPrivate;

struct _E6xWindow
{
  GtkWindow parent;
  E6xWindowPrivate *priv;
};

struct _E6xWindowClass
{
  GtkWindowClass parent_class;
};

GType e6x_window_get_type ();
GtkWidget *e6x_window_new ();
void e6x_window_add_document (E6xWindow *win, 
                              E6xDocument *doc);
void e6x_window_set_document (E6xWindow *win, 
                              E6xDocument *doc);

#endif /* __E6X_WINDOW_H__ */
