/* Copyright (C) 2010, 2011 Martin Linder <mali2297@users.sf.net>
 * 
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program. If not, see <http://www.gnu.org/licenses/gpl-2.0.html>.
 */
#pragma once
#ifndef __E6X_UTIL_H__
#define __E6X_UTIL_H__

#include <gio/gio.h>
#include "e6x-document.h"

E6xDocument *e6x_util_open_document (const gchar *arg, 
                                     const gchar *passwd,
                                     GError **error);
gboolean e6x_util_launch_app (GAppInfo *appinfo,
                              const gchar *path,
                              GError **error);
gboolean e6x_util_launch_cmd (const gchar *cmd,
                              const gchar *path,
                              GError **error);
gboolean e6x_util_open_uri (const gchar *url,
                            const gchar *cmd,
                            GError **error);
gchar *e6x_util_get_content_type (const gchar *path, 
                                  GError **error);
gchar *e6x_util_get_mime_type (const gchar *path, 
                               GError **error);
gchar *e6x_util_dattostr (time_t t);

typedef enum
{
  E6X_FILE_ERROR_ENCRYPTED = 1,
} E6xFileError;

#endif /* __E6X_UTIL_H__ */
