CREATE TABLE users (
  id INTEGER PRIMARY KEY AUTO_INCREMENT,
  name TEXT NOT NULL,
  hair_color TEXT
) CHARACTER SET utf8mb4;

CREATE TABLE posts (
  id INTEGER PRIMARY KEY AUTO_INCREMENT,
  user_id INTEGER NOT NULL,
  title VARCHAR(200) NOT NULL,
  body TEXT
) CHARACTER SET utf8mb4;

CREATE TABLE comments (
  id INTEGER PRIMARY KEY AUTO_INCREMENT,
  post_id INTEGER NOT NULL,
  text TEXT NOT NULL
) CHARACTER SET utf8mb4;

CREATE TABLE special_posts (
  id INTEGER PRIMARY KEY AUTO_INCREMENT,
  user_id INTEGER NOT NULL,
  title TEXT NOT NULL
) CHARACTER SET utf8mb4;

CREATE TABLE special_comments (
  id INTEGER PRIMARY KEY AUTO_INCREMENT,
  special_post_id INTEGER NOT NULL
) CHARACTER SET utf8mb4;

CREATE TABLE followings (
  user_id INTEGER NOT NULL,
  post_id INTEGER NOT NULL,
  email_notifications TINYINT(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (user_id, post_id)
);
