/**
 * @file enums.h
 *
 * Various global enumerators.
 */

DEVILUTION_BEGIN_NAMESPACE

typedef enum _sfx_id {
	PS_WALK1,
	PS_WALK2,
	PS_WALK3,
	PS_WALK4,
	PS_BFIRE,
	PS_FMAG,
	PS_TMAG,
	PS_LGHIT,
	PS_LGHIT1,
	PS_SWING,
	PS_SWING2,
	PS_DEAD,
	IS_STING1,
	IS_FBALLBOW,
	IS_QUESTDN,
	IS_ARMRFKD,
	IS_BARLFIRE,
	IS_BARREL,
	IS_POPPOP8,
	IS_POPPOP5,
	IS_POPPOP3,
	IS_POPPOP2,
	IS_BHIT,
	IS_BHIT1,
	IS_CHEST,
	IS_DOORCLOS,
	IS_DOOROPEN,
	IS_FANVL,
	IS_FAXE,
	IS_FBLST,
	IS_FBODY,
	IS_FBOOK,
	IS_FBOW,
	IS_FCAP,
	IS_FHARM,
	IS_FLARM,
	IS_FMAG,
	IS_FMAG1,
	IS_FMUSH,
	IS_FPOT,
	IS_FRING,
	IS_FROCK,
	IS_FSCRL,
	IS_FSHLD,
	IS_FSIGN,
	IS_FSTAF,
	IS_FSWOR,
	IS_GOLD,
	IS_HLMTFKD,
	IS_IANVL,
	IS_IAXE,
	IS_IBLST,
	IS_IBODY,
	IS_IBOOK,
	IS_IBOW,
	IS_ICAP,
	IS_IGRAB,
	IS_IHARM,
	IS_ILARM,
	IS_IMUSH,
	IS_IPOT,
	IS_IRING,
	IS_IROCK,
	IS_ISCROL,
	IS_ISHIEL,
	IS_ISIGN,
	IS_ISTAF,
	IS_ISWORD,
	IS_LEVER,
	IS_MAGIC,
	IS_MAGIC1,
	IS_RBOOK,
	IS_SARC,
	IS_SHLDFKD,
	IS_SWRDFKD,
	IS_TITLEMOV,
	IS_TITLSLCT,
	SFX_SILENCE,
	IS_TRAP,
	IS_CAST1,
	IS_CAST10,
	IS_CAST12,
	IS_CAST2,
	IS_CAST3,
	IS_CAST4,
	IS_CAST5,
	IS_CAST6,
	IS_CAST7,
	IS_CAST8,
	IS_CAST9,
	LS_HEALING,
	IS_REPAIR,
	LS_ACID,
	LS_ACIDS,
	LS_APOC,
	LS_ARROWALL,
	LS_BLODBOIL,
	LS_BLODSTAR,
	LS_BLSIMPT,
	LS_BONESP,
	LS_BSIMPCT,
	LS_CALDRON,
	LS_CBOLT,
	LS_CHLTNING,
	LS_DSERP,
	LS_ELECIMP1,
	LS_ELEMENTL,
	LS_ETHEREAL,
	LS_FBALL,
	LS_FBOLT1,
	LS_FBOLT2,
	LS_FIRIMP1,
	LS_FIRIMP2,
	LS_FLAMWAVE,
	LS_FLASH,
	LS_FOUNTAIN,
	LS_GOLUM,
	LS_GOLUMDED,
	LS_GSHRINE,
	LS_GUARD,
	LS_GUARDLAN,
	LS_HOLYBOLT,
	LS_HYPER,
	LS_INFRAVIS,
	LS_INVISIBL,
	LS_INVPOT,
	LS_LNING1,
	LS_LTNING,
	LS_MSHIELD,
	LS_NESTXPLD,
	LS_NOVA,
	LS_PORTAL,
	LS_PUDDLE,
	LS_RESUR,
	LS_SCURSE,
	LS_SCURIMP,
	LS_SENTINEL,
	LS_SHATTER,
	LS_SOULFIRE,
	LS_SPOUTLOP,
	LS_SPOUTSTR,
	LS_STORM,
	LS_TRAPDIS,
	LS_TELEPORT,
	LS_VTHEFT,
	LS_WALLLOOP,
	LS_WALLSTRT,
	LS_LMAG,
	TSFX_BMAID1,
	TSFX_BMAID2,
	TSFX_BMAID3,
	TSFX_BMAID4,
	TSFX_BMAID5,
	TSFX_BMAID6,
	TSFX_BMAID7,
	TSFX_BMAID8,
	TSFX_BMAID9,
	TSFX_BMAID10,
	TSFX_BMAID11,
	TSFX_BMAID12,
	TSFX_BMAID13,
	TSFX_BMAID14,
	TSFX_BMAID15,
	TSFX_BMAID16,
	TSFX_BMAID17,
	TSFX_BMAID18,
	TSFX_BMAID19,
	TSFX_BMAID20,
	TSFX_BMAID21,
	TSFX_BMAID22,
	TSFX_BMAID23,
	TSFX_BMAID24,
	TSFX_BMAID25,
	TSFX_BMAID26,
	TSFX_BMAID27,
	TSFX_BMAID28,
	TSFX_BMAID29,
	TSFX_BMAID30,
	TSFX_BMAID31,
	TSFX_BMAID32,
	TSFX_BMAID33,
	TSFX_BMAID34,
	TSFX_BMAID35,
	TSFX_BMAID36,
	TSFX_BMAID37,
	TSFX_BMAID38,
	TSFX_BMAID39,
	TSFX_BMAID40,
	TSFX_SMITH1,
	TSFX_SMITH2,
	TSFX_SMITH3,
	TSFX_SMITH4,
	TSFX_SMITH5,
	TSFX_SMITH6,
	TSFX_SMITH7,
	TSFX_SMITH8,
	TSFX_SMITH9,
	TSFX_SMITH10,
	TSFX_SMITH11,
	TSFX_SMITH12,
	TSFX_SMITH13,
	TSFX_SMITH14,
	TSFX_SMITH15,
	TSFX_SMITH16,
	TSFX_SMITH17,
	TSFX_SMITH18,
	TSFX_SMITH19,
	TSFX_SMITH20,
	TSFX_SMITH21,
	TSFX_SMITH22,
	TSFX_SMITH23,
	TSFX_SMITH24,
	TSFX_SMITH25,
	TSFX_SMITH26,
	TSFX_SMITH27,
	TSFX_SMITH28,
	TSFX_SMITH29,
	TSFX_SMITH30,
	TSFX_SMITH31,
	TSFX_SMITH32,
	TSFX_SMITH33,
	TSFX_SMITH34,
	TSFX_SMITH35,
	TSFX_SMITH36,
	TSFX_SMITH37,
	TSFX_SMITH38,
	TSFX_SMITH39,
	TSFX_SMITH40,
	TSFX_SMITH41,
	TSFX_SMITH42,
	TSFX_SMITH43,
	TSFX_SMITH44,
	TSFX_SMITH45,
	TSFX_SMITH46,
	TSFX_SMITH47,
	TSFX_SMITH48,
	TSFX_SMITH49,
	TSFX_SMITH50,
	TSFX_SMITH51,
	TSFX_SMITH52,
	TSFX_SMITH53,
	TSFX_SMITH54,
	TSFX_SMITH55,
	TSFX_SMITH56,
	TSFX_COW1,
	TSFX_COW2,
/*
	TSFX_COW3,
	TSFX_COW4,
	TSFX_COW5,
	TSFX_COW6,
*/
	TSFX_COW7,
	TSFX_COW8,
	TSFX_DEADGUY,
	TSFX_DRUNK1,
	TSFX_DRUNK2,
	TSFX_DRUNK3,
	TSFX_DRUNK4,
	TSFX_DRUNK5,
	TSFX_DRUNK6,
	TSFX_DRUNK7,
	TSFX_DRUNK8,
	TSFX_DRUNK9,
	TSFX_DRUNK10,
	TSFX_DRUNK11,
	TSFX_DRUNK12,
	TSFX_DRUNK13,
	TSFX_DRUNK14,
	TSFX_DRUNK15,
	TSFX_DRUNK16,
	TSFX_DRUNK17,
	TSFX_DRUNK18,
	TSFX_DRUNK19,
	TSFX_DRUNK20,
	TSFX_DRUNK21,
	TSFX_DRUNK22,
	TSFX_DRUNK23,
	TSFX_DRUNK24,
	TSFX_DRUNK25,
	TSFX_DRUNK26,
	TSFX_DRUNK27,
	TSFX_DRUNK28,
	TSFX_DRUNK29,
	TSFX_DRUNK30,
	TSFX_DRUNK31,
	TSFX_DRUNK32,
	TSFX_DRUNK33,
	TSFX_DRUNK34,
	TSFX_DRUNK35,
	TSFX_HEALER1,
	TSFX_HEALER2,
	TSFX_HEALER3,
	TSFX_HEALER4,
	TSFX_HEALER5,
	TSFX_HEALER6,
	TSFX_HEALER7,
	TSFX_HEALER8,
	TSFX_HEALER9,
	TSFX_HEALER10,
	TSFX_HEALER11,
	TSFX_HEALER12,
	TSFX_HEALER13,
	TSFX_HEALER14,
	TSFX_HEALER15,
	TSFX_HEALER16,
	TSFX_HEALER17,
	TSFX_HEALER18,
	TSFX_HEALER19,
	TSFX_HEALER20,
	TSFX_HEALER21,
	TSFX_HEALER22,
	TSFX_HEALER23,
	TSFX_HEALER24,
	TSFX_HEALER25,
	TSFX_HEALER26,
	TSFX_HEALER27,
	TSFX_HEALER28,
	TSFX_HEALER29,
	TSFX_HEALER30,
	TSFX_HEALER31,
	TSFX_HEALER32,
	TSFX_HEALER33,
	TSFX_HEALER34,
	TSFX_HEALER35,
	TSFX_HEALER36,
	TSFX_HEALER37,
	TSFX_HEALER38,
	TSFX_HEALER39,
	TSFX_HEALER40,
	TSFX_HEALER41,
	TSFX_HEALER42,
	TSFX_HEALER43,
	TSFX_HEALER44,
	TSFX_HEALER45,
	TSFX_HEALER46,
	TSFX_HEALER47,
	TSFX_PEGBOY1,
	TSFX_PEGBOY2,
	TSFX_PEGBOY3,
	TSFX_PEGBOY4,
	TSFX_PEGBOY5,
	TSFX_PEGBOY6,
	TSFX_PEGBOY7,
	TSFX_PEGBOY8,
	TSFX_PEGBOY9,
	TSFX_PEGBOY10,
	TSFX_PEGBOY11,
	TSFX_PEGBOY12,
	TSFX_PEGBOY13,
	TSFX_PEGBOY14,
	TSFX_PEGBOY15,
	TSFX_PEGBOY16,
	TSFX_PEGBOY17,
	TSFX_PEGBOY18,
	TSFX_PEGBOY19,
	TSFX_PEGBOY20,
	TSFX_PEGBOY21,
	TSFX_PEGBOY22,
	TSFX_PEGBOY23,
	TSFX_PEGBOY24,
	TSFX_PEGBOY25,
	TSFX_PEGBOY26,
	TSFX_PEGBOY27,
	TSFX_PEGBOY28,
	TSFX_PEGBOY29,
	TSFX_PEGBOY30,
	TSFX_PEGBOY31,
	TSFX_PEGBOY32,
	TSFX_PEGBOY33,
	TSFX_PEGBOY34,
	TSFX_PEGBOY35,
	TSFX_PEGBOY36,
	TSFX_PEGBOY37,
	TSFX_PEGBOY38,
	TSFX_PEGBOY39,
	TSFX_PEGBOY40,
	TSFX_PEGBOY41,
	TSFX_PEGBOY42,
	TSFX_PEGBOY43,
	TSFX_PRIEST0,
	TSFX_PRIEST1,
	TSFX_PRIEST2,
	TSFX_PRIEST3,
	TSFX_PRIEST4,
	TSFX_PRIEST5,
	TSFX_PRIEST6,
	TSFX_PRIEST7,
	TSFX_STORY0,
	TSFX_STORY1,
	TSFX_STORY2,
	TSFX_STORY3,
	TSFX_STORY4,
	TSFX_STORY5,
	TSFX_STORY6,
	TSFX_STORY7,
	TSFX_STORY8,
	TSFX_STORY9,
	TSFX_STORY10,
	TSFX_STORY11,
	TSFX_STORY12,
	TSFX_STORY13,
	TSFX_STORY14,
	TSFX_STORY15,
	TSFX_STORY16,
	TSFX_STORY17,
	TSFX_STORY18,
	TSFX_STORY19,
	TSFX_STORY20,
	TSFX_STORY21,
	TSFX_STORY22,
	TSFX_STORY23,
	TSFX_STORY24,
	TSFX_STORY25,
	TSFX_STORY26,
	TSFX_STORY27,
	TSFX_STORY28,
	TSFX_STORY29,
	TSFX_STORY30,
	TSFX_STORY31,
	TSFX_STORY32,
	TSFX_STORY33,
	TSFX_STORY34,
	TSFX_STORY35,
	TSFX_STORY36,
	TSFX_STORY37,
	TSFX_STORY38,
	TSFX_TAVERN0,
	TSFX_TAVERN1,
	TSFX_TAVERN2,
	TSFX_TAVERN3,
	TSFX_TAVERN4,
	TSFX_TAVERN5,
	TSFX_TAVERN6,
	TSFX_TAVERN7,
	TSFX_TAVERN8,
	TSFX_TAVERN9,
	TSFX_TAVERN10,
	TSFX_TAVERN11,
	TSFX_TAVERN12,
	TSFX_TAVERN13,
	TSFX_TAVERN14,
	TSFX_TAVERN15,
	TSFX_TAVERN16,
	TSFX_TAVERN17,
	TSFX_TAVERN18,
	TSFX_TAVERN19,
	TSFX_TAVERN20,
	TSFX_TAVERN21,
	TSFX_TAVERN22,
	TSFX_TAVERN23,
	TSFX_TAVERN24,
	TSFX_TAVERN25,
	TSFX_TAVERN26,
	TSFX_TAVERN27,
	TSFX_TAVERN28,
	TSFX_TAVERN29,
	TSFX_TAVERN30,
	TSFX_TAVERN31,
	TSFX_TAVERN32,
	TSFX_TAVERN33,
	TSFX_TAVERN34,
	TSFX_TAVERN35,
	TSFX_TAVERN36,
	TSFX_TAVERN37,
	TSFX_TAVERN38,
	TSFX_TAVERN39,
	TSFX_TAVERN40,
	TSFX_TAVERN41,
	TSFX_TAVERN42,
	TSFX_TAVERN43,
	TSFX_TAVERN44,
	TSFX_TAVERN45,
	TSFX_WITCH1,
	TSFX_WITCH2,
	TSFX_WITCH3,
	TSFX_WITCH4,
	TSFX_WITCH5,
	TSFX_WITCH6,
	TSFX_WITCH7,
	TSFX_WITCH8,
	TSFX_WITCH9,
	TSFX_WITCH10,
	TSFX_WITCH11,
	TSFX_WITCH12,
	TSFX_WITCH13,
	TSFX_WITCH14,
	TSFX_WITCH15,
	TSFX_WITCH16,
	TSFX_WITCH17,
	TSFX_WITCH18,
	TSFX_WITCH19,
	TSFX_WITCH20,
	TSFX_WITCH21,
	TSFX_WITCH22,
	TSFX_WITCH23,
	TSFX_WITCH24,
	TSFX_WITCH25,
	TSFX_WITCH26,
	TSFX_WITCH27,
	TSFX_WITCH28,
	TSFX_WITCH29,
	TSFX_WITCH30,
	TSFX_WITCH31,
	TSFX_WITCH32,
	TSFX_WITCH33,
	TSFX_WITCH34,
	TSFX_WITCH35,
	TSFX_WITCH36,
	TSFX_WITCH37,
	TSFX_WITCH38,
	TSFX_WITCH39,
	TSFX_WITCH40,
	TSFX_WITCH41,
	TSFX_WITCH42,
	TSFX_WITCH43,
	TSFX_WITCH44,
	TSFX_WITCH45,
	TSFX_WITCH46,
	TSFX_WITCH47,
	TSFX_WITCH48,
	TSFX_WITCH49,
	TSFX_WITCH50,
	TSFX_WOUND,
	PS_MAGE1,
	PS_MAGE2,
	PS_MAGE3,
	PS_MAGE4,
	PS_MAGE5,
	PS_MAGE6,
	PS_MAGE7,
	PS_MAGE8,
	PS_MAGE9,
	PS_MAGE10,
	PS_MAGE11,
	PS_MAGE12,
	PS_MAGE13,
	PS_MAGE14,
	PS_MAGE15,
	PS_MAGE16,
	PS_MAGE17,
	PS_MAGE18,
	PS_MAGE19,
	PS_MAGE20,
	PS_MAGE21,
	PS_MAGE22,
	PS_MAGE23,
	PS_MAGE24,
	PS_MAGE25,
	PS_MAGE26,
	PS_MAGE27,
	PS_MAGE28,
	PS_MAGE29,
	PS_MAGE30,
	PS_MAGE31,
	PS_MAGE32,
	PS_MAGE33,
	PS_MAGE34,
	PS_MAGE35,
	PS_MAGE36,
	PS_MAGE37,
	PS_MAGE38,
	PS_MAGE39,
	PS_MAGE40,
	PS_MAGE41,
	PS_MAGE42,
	PS_MAGE43,
	PS_MAGE44,
	PS_MAGE45,
	PS_MAGE46,
	PS_MAGE47,
	PS_MAGE48,
	PS_MAGE49,
	PS_MAGE50,
	PS_MAGE51,
	PS_MAGE52,
	PS_MAGE53,
	PS_MAGE54,
	PS_MAGE55,
	PS_MAGE56,
	PS_MAGE57,
	PS_MAGE58,
	PS_MAGE59,
	PS_MAGE60,
	PS_MAGE61,
	PS_MAGE62,
	PS_MAGE63,
	PS_MAGE64,
	PS_MAGE65,
	PS_MAGE66,
	PS_MAGE67,
	PS_MAGE68,
	PS_MAGE69,
	PS_MAGE69B,
	PS_MAGE70,
	PS_MAGE71,
	PS_MAGE72,
	PS_MAGE73,
	PS_MAGE74,
	PS_MAGE75,
	PS_MAGE76,
	PS_MAGE77,
	PS_MAGE78,
	PS_MAGE79,
	PS_MAGE80,
	PS_MAGE81,
	PS_MAGE82,
	PS_MAGE83,
	PS_MAGE84,
	PS_MAGE85,
	PS_MAGE86,
	PS_MAGE87,
	PS_MAGE88,
	PS_MAGE89,
	PS_MAGE90,
	PS_MAGE91,
	PS_MAGE92,
	PS_MAGE93,
	PS_MAGE94,
	PS_MAGE95,
	PS_MAGE96,
	PS_MAGE97,
	PS_MAGE98,
	PS_MAGE99,
	PS_MAGE100,
	PS_MAGE101,
	PS_MAGE102,
	PS_ROGUE1,
	PS_ROGUE2,
	PS_ROGUE3,
	PS_ROGUE4,
	PS_ROGUE5,
	PS_ROGUE6,
	PS_ROGUE7,
	PS_ROGUE8,
	PS_ROGUE9,
	PS_ROGUE10,
	PS_ROGUE11,
	PS_ROGUE12,
	PS_ROGUE13,
	PS_ROGUE14,
	PS_ROGUE15,
	PS_ROGUE16,
	PS_ROGUE17,
	PS_ROGUE18,
	PS_ROGUE19,
	PS_ROGUE20,
	PS_ROGUE21,
	PS_ROGUE22,
	PS_ROGUE23,
	PS_ROGUE24,
	PS_ROGUE25,
	PS_ROGUE26,
	PS_ROGUE27,
	PS_ROGUE28,
	PS_ROGUE29,
	PS_ROGUE30,
	PS_ROGUE31,
	PS_ROGUE32,
	PS_ROGUE33,
	PS_ROGUE34,
	PS_ROGUE35,
	PS_ROGUE36,
	PS_ROGUE37,
	PS_ROGUE38,
	PS_ROGUE39,
	PS_ROGUE40,
	PS_ROGUE41,
	PS_ROGUE42,
	PS_ROGUE43,
	PS_ROGUE44,
	PS_ROGUE45,
	PS_ROGUE46,
	PS_ROGUE47,
	PS_ROGUE48,
	PS_ROGUE49,
	PS_ROGUE50,
	PS_ROGUE51,
	PS_ROGUE52,
	PS_ROGUE53,
	PS_ROGUE54,
	PS_ROGUE55,
	PS_ROGUE56,
	PS_ROGUE57,
	PS_ROGUE58,
	PS_ROGUE59,
	PS_ROGUE60,
	PS_ROGUE61,
	PS_ROGUE62,
	PS_ROGUE63,
	PS_ROGUE64,
	PS_ROGUE65,
	PS_ROGUE66,
	PS_ROGUE67,
	PS_ROGUE68,
	PS_ROGUE69,
	PS_ROGUE69B,
	PS_ROGUE70,
	PS_ROGUE71,
	PS_ROGUE72,
	PS_ROGUE73,
	PS_ROGUE74,
	PS_ROGUE75,
	PS_ROGUE76,
	PS_ROGUE77,
	PS_ROGUE78,
	PS_ROGUE79,
	PS_ROGUE80,
	PS_ROGUE81,
	PS_ROGUE82,
	PS_ROGUE83,
	PS_ROGUE84,
	PS_ROGUE85,
	PS_ROGUE86,
	PS_ROGUE87,
	PS_ROGUE88,
	PS_ROGUE89,
	PS_ROGUE90,
	PS_ROGUE91,
	PS_ROGUE92,
	PS_ROGUE93,
	PS_ROGUE94,
	PS_ROGUE95,
	PS_ROGUE96,
	PS_ROGUE97,
	PS_ROGUE98,
	PS_ROGUE99,
	PS_ROGUE100,
	PS_ROGUE101,
	PS_ROGUE102,
	PS_WARR1,
	PS_WARR2,
	PS_WARR3,
	PS_WARR4,
	PS_WARR5,
	PS_WARR6,
	PS_WARR7,
	PS_WARR8,
	PS_WARR9,
	PS_WARR10,
	PS_WARR11,
	PS_WARR12,
	PS_WARR13,
	PS_WARR14,
	PS_WARR14B,
	PS_WARR14C,
	PS_WARR15,
	PS_WARR15B,
	PS_WARR15C,
	PS_WARR16,
	PS_WARR16B,
	PS_WARR16C,
	PS_WARR17,
	PS_WARR18,
	PS_WARR19,
	PS_WARR20,
	PS_WARR21,
	PS_WARR22,
	PS_WARR23,
	PS_WARR24,
	PS_WARR25,
	PS_WARR26,
	PS_WARR27,
	PS_WARR28,
	PS_WARR29,
	PS_WARR30,
	PS_WARR31,
	PS_WARR32,
	PS_WARR33,
	PS_WARR34,
	PS_WARR35,
	PS_WARR36,
	PS_WARR37,
	PS_WARR38,
	PS_WARR39,
	PS_WARR40,
	PS_WARR41,
	PS_WARR42,
	PS_WARR43,
	PS_WARR44,
	PS_WARR45,
	PS_WARR46,
	PS_WARR47,
	PS_WARR48,
	PS_WARR49,
	PS_WARR50,
	PS_WARR51,
	PS_WARR52,
	PS_WARR53,
	PS_WARR54,
	PS_WARR55,
	PS_WARR56,
	PS_WARR57,
	PS_WARR58,
	PS_WARR59,
	PS_WARR60,
	PS_WARR61,
	PS_WARR62,
	PS_WARR63,
	PS_WARR64,
	PS_WARR65,
	PS_WARR66,
	PS_WARR67,
	PS_WARR68,
	PS_WARR69,
	PS_WARR69B,
	PS_WARR70,
	PS_WARR71,
	PS_WARR72,
	PS_WARR73,
	PS_WARR74,
	PS_WARR75,
	PS_WARR76,
	PS_WARR77,
	PS_WARR78,
	PS_WARR79,
	PS_WARR80,
	PS_WARR81,
	PS_WARR82,
	PS_WARR83,
	PS_WARR84,
	PS_WARR85,
	PS_WARR86,
	PS_WARR87,
	PS_WARR88,
	PS_WARR89,
	PS_WARR90,
	PS_WARR91,
	PS_WARR92,
	PS_WARR93,
	PS_WARR94,
	PS_WARR95,
	PS_WARR95B,
	PS_WARR95C,
	PS_WARR95D,
	PS_WARR95E,
	PS_WARR95F,
	PS_WARR96B,
	PS_WARR97,
	PS_WARR98,
	PS_WARR99,
	PS_WARR100,
	PS_WARR101,
	PS_WARR102,
	PS_MONK1,
	PS_MONK2,
	PS_MONK3,
	PS_MONK4,
	PS_MONK5,
	PS_MONK6,
	PS_MONK7,
	PS_MONK8,
	PS_MONK9,
	PS_MONK10,
	PS_MONK11,
	PS_MONK12,
	PS_MONK13,
	PS_MONK14,
	PS_MONK15,
	PS_MONK16,
	PS_MONK17,
	PS_MONK18,
	PS_MONK19,
	PS_MONK20,
	PS_MONK21,
	PS_MONK22,
	PS_MONK23,
	PS_MONK24,
	PS_MONK25,
	PS_MONK26,
	PS_MONK27,
	PS_MONK28,
	PS_MONK29,
	PS_MONK30,
	PS_MONK31,
	PS_MONK32,
	PS_MONK33,
	PS_MONK34,
	PS_MONK35,
	PS_MONK36,
	PS_MONK37,
	PS_MONK38,
	PS_MONK39,
	PS_MONK40,
	PS_MONK41,
	PS_MONK42,
	PS_MONK43,
	PS_MONK44,
	PS_MONK45,
	PS_MONK46,
	PS_MONK47,
	PS_MONK48,
	PS_MONK49,
	PS_MONK50,
	PS_MONK51,
	PS_MONK52,
	PS_MONK53,
	PS_MONK54,
	PS_MONK55,
	PS_MONK56,
	PS_MONK57,
	PS_MONK58,
	PS_MONK59,
	PS_MONK60,
	PS_MONK61,
	PS_MONK62,
	PS_MONK63,
	PS_MONK64,
	PS_MONK65,
	PS_MONK66,
	PS_MONK67,
	PS_MONK68,
	PS_MONK69,
	PS_MONK69B,
	PS_MONK70,
	PS_MONK71,
	PS_MONK72,
	PS_MONK73,
	PS_MONK74,
	PS_MONK75,
	PS_MONK76,
	PS_MONK77,
	PS_MONK78,
	PS_MONK79,
	PS_MONK80,
	PS_MONK81,
	PS_MONK82,
	PS_MONK83,
	PS_MONK84,
	PS_MONK85,
	PS_MONK86,
	PS_MONK87,
	PS_MONK88,
	PS_MONK89,
	PS_MONK90,
	PS_MONK91,
	PS_MONK92,
	PS_MONK93,
	PS_MONK94,
	PS_MONK95,
	PS_MONK96,
	PS_MONK97,
	PS_MONK98,
	PS_MONK99,
	PS_MONK100,
	PS_MONK101,
	PS_MONK102,
	PS_NAR1,
	PS_NAR2,
	PS_NAR3,
	PS_NAR4,
	PS_NAR5,
	PS_NAR6,
	PS_NAR7,
	PS_NAR8,
	PS_NAR9,
	PS_DIABLVLINT,
	USFX_CLEAVER,
	USFX_GARBUD1,
	USFX_GARBUD2,
	USFX_GARBUD3,
	USFX_GARBUD4,
	USFX_IZUAL1,
	USFX_LACH1,
	USFX_LACH2,
	USFX_LACH3,
	USFX_LAZ1,
	USFX_LAZ2,
	USFX_SKING1,
	USFX_SNOT1,
	USFX_SNOT2,
	USFX_SNOT3,
	USFX_WARLRD1,
	USFX_WLOCK1,
	USFX_ZHAR1,
	USFX_ZHAR2,
	USFX_DIABLOD,
	TSFX_FARMER1,
	TSFX_FARMER2,
	TSFX_FARMER2A,
	TSFX_FARMER3,
	TSFX_FARMER4,
	TSFX_FARMER5,
	TSFX_FARMER6,
	TSFX_FARMER7,
	TSFX_FARMER8,
	TSFX_FARMER9,
	TSFX_TEDDYBR1,
	TSFX_TEDDYBR2,
	TSFX_TEDDYBR3,
	TSFX_TEDDYBR4,
	USFX_DEFILER1,
	USFX_DEFILER2,
	USFX_DEFILER3,
	USFX_DEFILER4,
	USFX_DEFILER8,
	USFX_DEFILER6,
	USFX_DEFILER7,
	USFX_NAKRUL1,
	USFX_NAKRUL2,
	USFX_NAKRUL3,
	USFX_NAKRUL4,
	USFX_NAKRUL5,
	USFX_NAKRUL6,
	PS_NARATR3,
	TSFX_COWSUT1,
	TSFX_COWSUT2,
	TSFX_COWSUT3,
	TSFX_COWSUT4,
	TSFX_COWSUT4A,
	TSFX_COWSUT5,
	TSFX_COWSUT6,
	TSFX_COWSUT7,
	TSFX_COWSUT8,
	TSFX_COWSUT9,
	TSFX_COWSUT10,
	TSFX_COWSUT11,
	TSFX_COWSUT12,
	USFX_SKLJRN1,
	PS_NARATR6,
	PS_NARATR7,
	PS_NARATR8,
	PS_NARATR5,
	PS_NARATR9,
	PS_NARATR4,
	TSFX_TRADER1,
	IS_CROPEN,
	IS_CRCLOS,
} _sfx_id;

typedef enum sfx_flag {
	sfx_STREAM   = 0x01,
	sfx_MISC     = 0x02,
	sfx_UI       = 0x04,
	sfx_MONK     = 0x08,
	sfx_ROGUE    = 0x10,
	sfx_WARRIOR  = 0x20,
	sfx_SORCERER = 0x40,
	sfx_HELLFIRE = 0x80,
} sfx_flag;

typedef enum missile_id {
	MIS_ARROW         = 0x0,
	MIS_FIREBOLT      = 0x1,
	MIS_GUARDIAN      = 0x2,
	MIS_RNDTELEPORT   = 0x3,
	MIS_LIGHTBALL     = 0x4,
	MIS_FIREWALL      = 0x5,
	MIS_FIREBALL      = 0x6,
	MIS_LIGHTCTRL     = 0x7,
	MIS_LIGHTNING     = 0x8,
	MIS_MISEXP        = 0x9,
	MIS_TOWN          = 0xA,
	MIS_FLASH         = 0xB,
	MIS_FLASH2        = 0xC,
	MIS_MANASHIELD    = 0xD,
	MIS_FIREMOVE      = 0xE,
	MIS_CHAIN         = 0xF,
	MIS_SENTINAL      = 0x10, // TODO: Check beta
	MIS_BLODSTAR      = 0x11, // TODO: Check beta
	MIS_BONE          = 0x12, // TODO: Check beta
	MIS_METLHIT       = 0x13, // TODO: Check beta
	MIS_RHINO         = 0x14,
	MIS_MAGMABALL     = 0x15,
	MIS_LIGHTCTRL2    = 0x16,
	MIS_LIGHTNING2    = 0x17,
	MIS_FLARE         = 0x18,
	MIS_MISEXP2       = 0x19,
	MIS_TELEPORT      = 0x1A,
	MIS_FARROW        = 0x1B,
	MIS_DOOMSERP      = 0x1C,
	MIS_FIREWALLA     = 0x1D, // TODO: Check beta
	MIS_STONE         = 0x1E,
	MIS_NULL_1F       = 0x1F,
	MIS_INVISIBL      = 0x20,
	MIS_GOLEM         = 0x21,
	MIS_ETHEREALIZE   = 0x22,
	MIS_BLODBUR       = 0x23, // TODO: Check beta
	MIS_BOOM          = 0x24,
	MIS_HEAL          = 0x25,
	MIS_FIREWALLC     = 0x26,
	MIS_INFRA         = 0x27,
	MIS_IDENTIFY      = 0x28,
	MIS_WAVE          = 0x29,
	MIS_NOVA          = 0x2A,
	MIS_BLODBOIL      = 0x2B,
	MIS_APOCA         = 0x2C,
	MIS_REPAIR        = 0x2D,
	MIS_RECHARGE      = 0x2E,
	MIS_DISARM        = 0x2F,
	MIS_FLAME         = 0x30,
	MIS_FLAMEC        = 0x31,
	MIS_FIREMAN       = 0x32, // TODO: Check beta
	MIS_KRULL         = 0x33, // TODO: Check beta
	MIS_CBOLT         = 0x34,
	MIS_HBOLT         = 0x35,
	MIS_RESURRECT     = 0x36,
	MIS_TELEKINESIS   = 0x37,
	MIS_LARROW        = 0x38,
	MIS_ACID          = 0x39,
	MIS_MISEXP3       = 0x3A,
	MIS_ACIDPUD       = 0x3B,
	MIS_HEALOTHER     = 0x3C,
	MIS_ELEMENT       = 0x3D,
	MIS_RESURRECTBEAM = 0x3E,
	MIS_BONESPIRIT    = 0x3F,
	MIS_WEAPEXP       = 0x40,
	MIS_RPORTAL       = 0x41,
	MIS_BOOM2         = 0x42,
	MIS_DIABAPOCA     = 0x43,
	MIS_MANA          = 0x44,
	MIS_MAGI          = 0x45,
	MIS_LIGHTWALL     = 0x46,
	MIS_LIGHTNINGWALL = 0x47,
	MIS_IMMOLATION    = 0x48,
	MIS_SPECARROW     = 0x49,
	MIS_FIRENOVA      = 0x4A,
	MIS_LIGHTARROW    = 0x4B,
	MIS_CBOLTARROW    = 0x4C,
	MIS_HBOLTARROW    = 0x4D,
	MIS_WARP          = 0x4E,
	MIS_REFLECT       = 0x4F,
	MIS_BERSERK       = 0x50,
	MIS_FIRERING      = 0x51,
	MIS_STEALPOTS     = 0x52,
	MIS_MANATRAP      = 0x53,
	MIS_LIGHTRING     = 0x54,
	MIS_SEARCH        = 0x55,
	MIS_FLASHFR       = 0x56,
	MIS_FLASHBK       = 0x57,
	MIS_IMMOLATION2   = 0x58,
	MIS_RUNEFIRE      = 0x59,
	MIS_RUNELIGHT     = 0x5A,
	MIS_RUNENOVA      = 0x5B,
	MIS_RUNEIMMOLAT   = 0x5C,
	MIS_RUNESTONE     = 0x5D,
	MIS_HIVEEXP       = 0x5E,
	MIS_HORKDMN       = 0x5F,
	MIS_JESTER        = 0x60,
	MIS_HIVEEXP2      = 0x61,
	MIS_LICH          = 0x62,
	MIS_PSYCHORB      = 0x63,
	MIS_NECROMORB     = 0x64,
	MIS_ARCHLICH      = 0x65,
	MIS_BONEDEMON     = 0x66,
	MIS_EXYEL2        = 0x67,
	MIS_EXRED3        = 0x68,
	MIS_EXBL2         = 0x69,
	MIS_EXBL3         = 0x6A,
	MIS_EXORA1        = 0x6B,
} missile_id;

typedef enum missile_graphic_id {
	MFILE_ARROWS,
	MFILE_FIREBA,
	MFILE_GUARD,
	MFILE_LGHNING,
	MFILE_FIREWAL,
	MFILE_MAGBLOS,
	MFILE_PORTAL,
	MFILE_BLUEXFR,
	MFILE_BLUEXBK,
	MFILE_MANASHLD,
	MFILE_BLOOD,
	MFILE_BONE,
	MFILE_METLHIT,
	MFILE_FARROW,
	MFILE_DOOM,
	MFILE_0F,
	MFILE_BLODBUR,
	MFILE_NEWEXP,
	MFILE_SHATTER1,
	MFILE_BIGEXP,
	MFILE_INFERNO,
	MFILE_THINLGHT,
	MFILE_FLARE,
	MFILE_FLAREEXP,
	MFILE_MAGBALL,
	MFILE_KRULL,
	MFILE_MINILTNG,
	MFILE_HOLY,
	MFILE_HOLYEXPL,
	MFILE_LARROW,
	MFILE_FIRARWEX,
	MFILE_ACIDBF,
	MFILE_ACIDSPLA,
	MFILE_ACIDPUD,
	MFILE_ETHRSHLD,
	MFILE_FIRERUN,
	MFILE_RESSUR1,
	MFILE_SKLBALL,
	MFILE_RPORTAL,
	MFILE_FIREPLAR,
	MFILE_SCUBMISB,
	MFILE_SCBSEXPB,
	MFILE_SCUBMISC,
	MFILE_SCBSEXPC,
	MFILE_SCUBMISD,
	MFILE_SCBSEXPD,
	MFILE_SPAWNS,
	MFILE_REFLECT,
	MFILE_LICH,
	MFILE_MSBLA,
	MFILE_NECROMORB,
	MFILE_ARCHLICH,
	MFILE_RUNE,
	MFILE_EXYEL2,
	MFILE_EXBL2,
	MFILE_EXRED3,
	MFILE_BONEDEMON,
	MFILE_EXORA1,
	MFILE_EXBL3,
	MFILE_NONE, // BUGFIX: should be `MFILE_NONE = MFILE_SCBSEXPD+1`, i.e. MFILE_NULL, since there would otherwise be an out-of-bounds in SetMissAnim when accessing misfiledata for any of the missiles that have MFILE_NONE as mFileNum in missiledata. (fixed)
} missile_graphic_id;

typedef enum FILE_SYSTEM {
	FS_PC = 0,
	FS_CD = 1,
} FILE_SYSTEM;

typedef enum _artfonts {
	AF_SMALL     = 0,
	AF_SMALLGRAY = 1,
	AF_MED       = 2,
	AF_MEDGRAY   = 3,
	AF_BIG       = 4,
	AF_BIGGRAY   = 5,
	AF_HUGE      = 6,
	AF_HUGEGRAY  = 7,
} _artfonts;

// this enum contains indexes from UniqMonst array for special unique monsters (usually quest related)
typedef enum {
	UMT_GARBUD    = 0,
	UMT_SKELKING  = 1,
	UMT_ZHAR      = 2,
	UMT_SNOTSPIL  = 3,
	UMT_LAZURUS   = 4,
	UMT_RED_VEX   = 5,
	UMT_BLACKJADE = 6,
	UMT_LACHDAN   = 7,
	UMT_WARLORD   = 8,
	UMT_BUTCHER   = 9,
	UMT_HORKDMN   = 10,
	UMT_DEFILER   = 11,
	UMT_NAKRUL    = 12,
} _uniq_monsterid;

typedef enum monster_flag {
	MFLAG_HIDDEN          = 0x01,
	MFLAG_LOCK_ANIMATION  = 0x02,
	MFLAG_ALLOW_SPECIAL   = 0x04,
	MFLAG_NOHEAL          = 0x08,
	MFLAG_TARGETS_MONSTER = 0x10,
	MFLAG_GOLEM           = 0x20,
	MFLAG_QUEST_COMPLETE  = 0x40,
	MFLAG_KNOCKBACK       = 0x80,
	MFLAG_SEARCH          = 0x100,
	MFLAG_CAN_OPEN_DOOR   = 0x200,
	MFLAG_NO_ENEMY        = 0x400,
	MFLAG_BERSERK         = 0x800,
	MFLAG_NOLIFESTEAL     = 0x1000
} monster_flag;

typedef enum monster_goal {
	MGOAL_NORMAL    = 1,
	MGOAL_RETREAT   = 2,
	MGOAL_HEALING   = 3,
	MGOAL_MOVE      = 4,
	MGOAL_ATTACK2   = 5,
	MGOAL_INQUIRING = 6,
	MGOAL_TALKING   = 7,
} monster_goal;

typedef enum missile_resistance {
	MISR_NONE      = 0,
	MISR_FIRE      = 1,
	MISR_LIGHTNING = 2,
	MISR_MAGIC     = 3,
	MISR_ACID      = 4,
} missile_resistance;

typedef enum _speech_id {
	TEXT_KING1,
	TEXT_KING2,
	TEXT_KING3,
	TEXT_KING4,
	TEXT_KING5,
	TEXT_KING6,
	TEXT_KING7,
	TEXT_KING8,
	TEXT_KING9,
	TEXT_KING10,
	TEXT_KING11,
	TEXT_BANNER1,
	TEXT_BANNER2,
	TEXT_BANNER3,
	TEXT_BANNER4,
	TEXT_BANNER5,
	TEXT_BANNER6,
	TEXT_BANNER7,
	TEXT_BANNER8,
	TEXT_BANNER9,
	TEXT_BANNER10,
	TEXT_BANNER11,
	TEXT_BANNER12,
	TEXT_VILE1,
	TEXT_VILE2,
	TEXT_VILE3,
	TEXT_VILE4,
	TEXT_VILE5,
	TEXT_VILE6,
	TEXT_VILE7,
	TEXT_VILE8,
	TEXT_VILE9,
	TEXT_VILE10,
	TEXT_VILE11,
	TEXT_VILE12,
	TEXT_VILE13,
	TEXT_VILE14,
	TEXT_POISON1,
	TEXT_POISON2,
	TEXT_POISON3,
	TEXT_POISON4,
	TEXT_POISON5,
	TEXT_POISON6,
	TEXT_POISON7,
	TEXT_POISON8,
	TEXT_POISON9,
	TEXT_POISON10,
	TEXT_BONE1,
	TEXT_BONE2,
	TEXT_BONE3,
	TEXT_BONE4,
	TEXT_BONE5,
	TEXT_BONE6,
	TEXT_BONE7,
	TEXT_BONE8,
	TEXT_BUTCH1,
	TEXT_BUTCH2,
	TEXT_BUTCH3,
	TEXT_BUTCH4,
	TEXT_BUTCH5,
	TEXT_BUTCH6,
	TEXT_BUTCH7,
	TEXT_BUTCH8,
	TEXT_BUTCH9,
	TEXT_BUTCH10,
	TEXT_BLIND1,
	TEXT_BLIND2,
	TEXT_BLIND3,
	TEXT_BLIND4,
	TEXT_BLIND5,
	TEXT_BLIND6,
	TEXT_BLIND7,
	TEXT_BLIND8,
	TEXT_VEIL1,
	TEXT_VEIL2,
	TEXT_VEIL3,
	TEXT_VEIL4,
	TEXT_VEIL5,
	TEXT_VEIL6,
	TEXT_VEIL7,
	TEXT_VEIL8,
	TEXT_VEIL9,
	TEXT_VEIL10,
	TEXT_VEIL11,
	TEXT_ANVIL1,
	TEXT_ANVIL2,
	TEXT_ANVIL3,
	TEXT_ANVIL4,
	TEXT_ANVIL5,
	TEXT_ANVIL6,
	TEXT_ANVIL7,
	TEXT_ANVIL8,
	TEXT_ANVIL9,
	TEXT_ANVIL10,
	TEXT_BLOOD1,
	TEXT_BLOOD2,
	TEXT_BLOOD3,
	TEXT_BLOOD4,
	TEXT_BLOOD5,
	TEXT_BLOOD6,
	TEXT_BLOOD7,
	TEXT_BLOOD8,
	TEXT_WARLRD1,
	TEXT_WARLRD2,
	TEXT_WARLRD3,
	TEXT_WARLRD4,
	TEXT_WARLRD5,
	TEXT_WARLRD6,
	TEXT_WARLRD7,
	TEXT_WARLRD8,
	TEXT_WARLRD9,
	TEXT_INFRA1,
	TEXT_INFRA2,
	TEXT_INFRA3,
	TEXT_INFRA4,
	TEXT_INFRA5,
	TEXT_INFRA6,
	TEXT_INFRA7,
	TEXT_INFRA8,
	TEXT_INFRA9,
	TEXT_INFRA10,
	TEXT_MUSH1,
	TEXT_MUSH2,
	TEXT_MUSH3,
	TEXT_MUSH4,
	TEXT_MUSH5,
	TEXT_MUSH6,
	TEXT_MUSH7,
	TEXT_MUSH8,
	TEXT_MUSH9,
	TEXT_MUSH10,
	TEXT_MUSH11,
	TEXT_MUSH12,
	TEXT_MUSH13,
	TEXT_DOOM1,
	TEXT_DOOM2,
	TEXT_DOOM3,
	TEXT_DOOM4,
	TEXT_DOOM5,
	TEXT_DOOM6,
	TEXT_DOOM7,
	TEXT_DOOM8,
	TEXT_DOOM9,
	TEXT_DOOM10,
	TEXT_GARBUD1,
	TEXT_GARBUD2,
	TEXT_GARBUD3,
	TEXT_GARBUD4,
	TEXT_ZHAR1,
	TEXT_ZHAR2,
	TEXT_STORY1,
	TEXT_STORY2,
	TEXT_STORY3,
	TEXT_STORY4,
	TEXT_STORY5,
	TEXT_STORY6,
	TEXT_STORY7,
	TEXT_STORY9,
	TEXT_STORY10,
	TEXT_STORY11,
	TEXT_OGDEN1,
	TEXT_OGDEN2,
	TEXT_OGDEN3,
	TEXT_OGDEN4,
	TEXT_OGDEN5,
	TEXT_OGDEN6,
	TEXT_OGDEN8,
	TEXT_OGDEN9,
	TEXT_OGDEN10,
	TEXT_PEPIN1,
	TEXT_PEPIN2,
	TEXT_PEPIN3,
	TEXT_PEPIN4,
	TEXT_PEPIN5,
	TEXT_PEPIN6,
	TEXT_PEPIN7,
	TEXT_PEPIN9,
	TEXT_PEPIN10,
	TEXT_PEPIN11,
	TEXT_GILLIAN1,
	TEXT_GILLIAN2,
	TEXT_GILLIAN3,
	TEXT_GILLIAN4,
	TEXT_GILLIAN5,
	TEXT_GILLIAN6,
	TEXT_GILLIAN7,
	TEXT_GILLIAN9,
	TEXT_GILLIAN10,
	TEXT_GRISWOLD1,
	TEXT_GRISWOLD2,
	TEXT_GRISWOLD3,
	TEXT_GRISWOLD4,
	TEXT_GRISWOLD5,
	TEXT_GRISWOLD6,
	TEXT_GRISWOLD7,
	TEXT_GRISWOLD8,
	TEXT_GRISWOLD9,
	TEXT_GRISWOLD10,
	TEXT_GRISWOLD12,
	TEXT_GRISWOLD13,
	TEXT_FARNHAM1,
	TEXT_FARNHAM2,
	TEXT_FARNHAM3,
	TEXT_FARNHAM4,
	TEXT_FARNHAM5,
	TEXT_FARNHAM6,
	TEXT_FARNHAM8,
	TEXT_FARNHAM9,
	TEXT_FARNHAM10,
	TEXT_FARNHAM11,
	TEXT_FARNHAM12,
	TEXT_FARNHAM13,
	TEXT_ADRIA1,
	TEXT_ADRIA2,
	TEXT_ADRIA3,
	TEXT_ADRIA4,
	TEXT_ADRIA5,
	TEXT_ADRIA6,
	TEXT_ADRIA7,
	TEXT_ADRIA8,
	TEXT_ADRIA9,
	TEXT_ADRIA10,
	TEXT_ADRIA12,
	TEXT_ADRIA13,
	TEXT_WIRT1,
	TEXT_WIRT2,
	TEXT_WIRT3,
	TEXT_WIRT4,
	TEXT_WIRT5,
	TEXT_WIRT6,
	TEXT_WIRT7,
	TEXT_WIRT8,
	TEXT_WIRT9,
	TEXT_WIRT11,
	TEXT_WIRT12,
	TEXT_BONER,
	TEXT_BLOODY,
	TEXT_BLINDING,
	TEXT_BLOODWAR,
	TEXT_MBONER,
	TEXT_MBLOODY,
	TEXT_MBLINDING,
	TEXT_MBLOODWAR,
	TEXT_RBONER,
	TEXT_RBLOODY,
	TEXT_RBLINDING,
	TEXT_RBLOODWAR,
	TEXT_COW1,
	TEXT_COW2,
	TEXT_BOOK11,
	TEXT_BOOK12,
	TEXT_BOOK13,
	TEXT_BOOK21,
	TEXT_BOOK22,
	TEXT_BOOK23,
	TEXT_BOOK31,
	TEXT_BOOK32,
	TEXT_BOOK33,
	TEXT_INTRO,
	TEXT_HBONER,
	TEXT_HBLOODY,
	TEXT_HBLINDING,
	TEXT_HBLOODWAR,
	TEXT_BBONER,
	TEXT_BBLOODY,
	TEXT_BBLINDING,
	TEXT_BBLOODWAR,
	TEXT_GRAVE1,
	TEXT_GRAVE2,
	TEXT_GRAVE3,
	TEXT_GRAVE4,
	TEXT_GRAVE5,
	TEXT_GRAVE6,
	TEXT_GRAVE7,
	TEXT_GRAVE8,
	TEXT_GRAVE9,
	TEXT_GRAVE10,
	TEXT_FARMER1,
	TEXT_FARMER2,
	TEXT_FARMER3,
	TEXT_FARMER4,
	TEXT_FARMER5,
	TEXT_GIRL1,
	TEXT_GIRL2,
	TEXT_GIRL3,
	TEXT_GIRL4,
	TEXT_DEFILER1,
	TEXT_DEFILER2,
	TEXT_DEFILER3,
	TEXT_DEFILER4,
	TEXT_DEFILER5,
	TEXT_NAKRUL1,
	TEXT_NAKRUL2,
	TEXT_NAKRUL3,
	TEXT_NAKRUL4,
	TEXT_NAKRUL5,
	TEXT_CORNSTN,
	TEXT_JERSEY1,
	TEXT_JERSEY2,
	TEXT_JERSEY3,
	TEXT_JERSEY4,
	TEXT_JERSEY5,
	TEXT_JERSEY6,
	TEXT_JERSEY7,
	TEXT_JERSEY8,
	TEXT_JERSEY9,
	TEXT_TRADER,
	TEXT_FARMER6,
	TEXT_FARMER7,
	TEXT_FARMER8,
	TEXT_FARMER9,
	TEXT_FARMER10,
	TEXT_JERSEY10,
	TEXT_JERSEY11,
	TEXT_JERSEY12,
	TEXT_JERSEY13,
	TEXT_SKLJRN,
	TEXT_BOOK4,
	TEXT_BOOK5,
	TEXT_BOOK6,
	TEXT_BOOK7,
	TEXT_BOOK8,
	TEXT_BOOK9,
	TEXT_BOOKA,
	TEXT_BOOKB,
	TEXT_BOOKC,
	TEXT_OBOOKA,
	TEXT_OBOOKB,
	TEXT_OBOOKC,
	TEXT_MBOOKA,
	TEXT_MBOOKB,
	TEXT_MBOOKC,
	TEXT_RBOOKA,
	TEXT_RBOOKB,
	TEXT_RBOOKC,
	TEXT_BBOOKA,
	TEXT_BBOOKB,
	TEXT_BBOOKC,
/*
	TEXT_DEADGUY,
	TEXT_FARNHAM14,
	TEXT_FARNHAM15,
	TEXT_FARNHAM16,
	TEXT_FARNHAM17,
	TEXT_FARNHAM18,
	TEXT_FARNHAM19,
	TEXT_FARNHAM20,
	TEXT_FARNHAM21,
	TEXT_FARNHAM22,
	TEXT_GILLIAN11,
	TEXT_GILLIAN12,
	TEXT_GILLIAN13,
	TEXT_GILLIAN14,
	TEXT_GILLIAN15,
	TEXT_GILLIAN16,
	TEXT_GILLIAN17,
    TEXT_GILLIAN18,
    TEXT_GILLIAN19,
    TEXT_GILLIAN20,
    TEXT_GILLIAN21,
    TEXT_GILLIAN22,
    TEXT_GILLIAN23,
    TEXT_GILLIAN24,
    TEXT_GILLIAN25,
	TEXT_GILLIAN26,
*/
	TEXT_NONE = -1,
} _speech_id;

typedef enum object_graphic_id {
	OFILE_L1BRAZ   = 0x0,
	OFILE_L1DOORS  = 0x1,
	OFILE_LEVER    = 0x2,
	OFILE_CHEST1   = 0x3,
	OFILE_CHEST2   = 0x4,
	OFILE_BANNER   = 0x5,
	OFILE_SKULPILE = 0x6,
	OFILE_SKULFIRE = 0x7,
	OFILE_SKULSTIK = 0x8,
	OFILE_CRUXSK1  = 0x9,
	OFILE_CRUXSK2  = 0xA,
	OFILE_CRUXSK3  = 0xB,
	OFILE_BOOK1    = 0xC,
	OFILE_BOOK2    = 0xD,
	OFILE_ROCKSTAN = 0xE,
	OFILE_ANGEL    = 0xF,
	OFILE_CHEST3   = 0x10,
	OFILE_BURNCROS = 0x11,
	OFILE_CANDLE2  = 0x12,
	OFILE_NUDE2    = 0x13,
	OFILE_SWITCH4  = 0x14,
	OFILE_TNUDEM   = 0x15,
	OFILE_TNUDEW   = 0x16,
	OFILE_TSOUL    = 0x17,
	OFILE_L2DOORS  = 0x18,
	OFILE_WTORCH4  = 0x19,
	OFILE_WTORCH3  = 0x1A,
	OFILE_SARC     = 0x1B,
	OFILE_FLAME1   = 0x1C,
	OFILE_PRSRPLT1 = 0x1D,
	OFILE_TRAPHOLE = 0x1E,
	OFILE_MINIWATR = 0x1F,
	OFILE_WTORCH2  = 0x20,
	OFILE_WTORCH1  = 0x21,
	OFILE_BCASE    = 0x22,
	OFILE_BSHELF   = 0x23,
	OFILE_WEAPSTND = 0x24,
	OFILE_BARREL   = 0x25,
	OFILE_BARRELEX = 0x26,
	OFILE_LSHRINEG = 0x27,
	OFILE_RSHRINEG = 0x28,
	OFILE_BLOODFNT = 0x29,
	OFILE_DECAP    = 0x2A,
	OFILE_PEDISTL  = 0x2B,
	OFILE_L3DOORS  = 0x2C,
	OFILE_PFOUNTN  = 0x2D,
	OFILE_ARMSTAND = 0x2E,
	OFILE_GOATSHRN = 0x2F,
	OFILE_CAULDREN = 0x30,
	OFILE_MFOUNTN  = 0x31,
	OFILE_TFOUNTN  = 0x32,
	OFILE_ALTBOY   = 0x33,
	OFILE_MCIRL    = 0x34,
	OFILE_BKSLBRNT = 0x35,
	OFILE_MUSHPTCH = 0x36,
	OFILE_LZSTAND  = 0x37,
} object_graphic_id;

typedef enum dungeon_type {
	DTYPE_TOWN      = 0x0,
	DTYPE_CATHEDRAL = 0x1,
	DTYPE_CATACOMBS = 0x2,
	DTYPE_CAVES     = 0x3,
	DTYPE_HELL      = 0x4,
	DTYPE_NEST      = 0x5,
	DTYPE_CRYPT     = 0x6,
	DTYPE_NONE      = 0xFF,
} dungeon_type;

typedef enum dflag {
	BFLAG_MISSILE     = 0x01,
	BFLAG_VISIBLE     = 0x02,
	BFLAG_DEAD_PLAYER = 0x04,
	BFLAG_POPULATED   = 0x08,
	BFLAG_MONSTLR     = 0x10,
	BFLAG_PLAYERLR    = 0x20,
	BFLAG_LIT         = 0x40,
	BFLAG_EXPLORED    = 0x80,
} dflag;

typedef enum clicktype {
	CLICK_NONE  = 0,
	CLICK_LEFT  = 1,
	CLICK_RIGHT = 2,
} clicktype;

typedef enum placeflag {
	PLACE_SCATTER = 1,
	PLACE_SPECIAL = 2,
	PLACE_UNIQUE  = 4,
} placeflag;

typedef enum mienemy_type {
	TARGET_MONSTERS = 0,
	TARGET_PLAYERS  = 1,
	TARGET_BOTH     = 2,
} mienemy_type;

typedef enum dungeon_message {
	DMSG_CATHEDRAL = 1 << 0,
	DMSG_CATACOMBS = 1 << 1,
	DMSG_CAVES     = 1 << 2,
	DMSG_HELL      = 1 << 3,
	DMSG_DIABLO    = 1 << 4,
} dungeon_message;

typedef enum diablo_message {
	EMSG_NONE                   = 0,
	EMSG_NO_AUTOMAP_IN_TOWN     = 1,
	EMSG_NO_MULTIPLAYER_IN_DEMO = 2,
	EMSG_DIRECT_SOUND_FAILED    = 3,
	EMSG_NOT_IN_SHAREWARE       = 4,
	EMSG_NO_SPACE_TO_SAVE       = 5,
	EMSG_NO_PAUSE_IN_TOWN       = 6,
	EMSG_COPY_TO_HDD            = 7,
	EMSG_DESYNC                 = 8,
	EMSG_NO_PAUSE_IN_MP         = 9,
	EMSG_LOADING                = 10,
	EMSG_SAVING                 = 11,
	EMSG_SHRINE_MYSTERIOUS      = 12,
	EMSG_SHRINE_HIDDEN          = 13,
	EMSG_SHRINE_GLOOMY          = 14,
	EMSG_SHRINE_WEIRD           = 15,
	EMSG_SHRINE_MAGICAL         = 16,
	EMSG_SHRINE_STONE           = 17,
	EMSG_SHRINE_RELIGIOUS       = 18,
	EMSG_SHRINE_ENCHANTED       = 19,
	EMSG_SHRINE_THAUMATURGIC    = 20,
	EMSG_SHRINE_FASCINATING     = 21,
	EMSG_SHRINE_CRYPTIC         = 22,
	EMSG_SHRINE_UNUSED          = 23,
	EMSG_SHRINE_ELDRITCH        = 24,
	EMSG_SHRINE_EERIE           = 25,
	EMSG_SHRINE_DIVINE          = 26,
	EMSG_SHRINE_HOLY            = 27,
	EMSG_SHRINE_SACRED          = 28,
	EMSG_SHRINE_SPIRITUAL       = 29,
	EMSG_SHRINE_SPOOKY1         = 30,
	EMSG_SHRINE_SPOOKY2         = 31,
	EMSG_SHRINE_ABANDONED       = 32,
	EMSG_SHRINE_CREEPY          = 33,
	EMSG_SHRINE_QUIET           = 34,
	EMSG_SHRINE_SECLUDED        = 35,
	EMSG_SHRINE_ORNATE          = 36,
	EMSG_SHRINE_GLIMMERING      = 37,
	EMSG_SHRINE_TAINTED1        = 38,
	EMSG_SHRINE_TAINTED2        = 39,
	EMSG_REQUIRES_LVL_8         = 40,
	EMSG_REQUIRES_LVL_13        = 41,
	EMSG_REQUIRES_LVL_17        = 42,
	EMSG_BONECHAMB              = 43,
	EMSG_SHRINE_OILY            = 44,
	EMSG_SHRINE_GLOWING         = 45,
	EMSG_SHRINE_MENDICANT       = 46,
	EMSG_SHRINE_SPARKLING       = 47,
	EMSG_SHRINE_TOWN            = 48,
	EMSG_SHRINE_SHIMMERING      = 49,
	EMSG_SHRINE_SOLAR1          = 50,
	EMSG_SHRINE_SOLAR2          = 51,
	EMSG_SHRINE_SOLAR3          = 52,
	EMSG_SHRINE_SOLAR4          = 53,
	EMSG_SHRINE_MURPHYS         = 54,
} diablo_message;

typedef enum magic_type {
	STYPE_FIRE      = 0x0,
	STYPE_LIGHTNING = 0x1,
	STYPE_MAGIC     = 0x2,
} magic_type;

typedef enum theme_id {
	THEME_BARREL            = 0x0,
	THEME_SHRINE            = 0x1,
	THEME_MONSTPIT          = 0x2,
	THEME_SKELROOM          = 0x3,
	THEME_TREASURE          = 0x4,
	THEME_LIBRARY           = 0x5,
	THEME_TORTURE           = 0x6,
	THEME_BLOODFOUNTAIN     = 0x7,
	THEME_DECAPITATED       = 0x8,
	THEME_PURIFYINGFOUNTAIN = 0x9,
	THEME_ARMORSTAND        = 0xA,
	THEME_GOATSHRINE        = 0xB,
	THEME_CAULDRON          = 0xC,
	THEME_MURKYFOUNTAIN     = 0xD,
	THEME_TEARFOUNTAIN      = 0xE,
	THEME_BRNCROSS          = 0xF,
	THEME_WEAPONRACK        = 0x10,
	THEME_NONE              = -1,
} theme_id;

typedef enum event_type {
	EVENT_TYPE_PLAYER_CREATE_GAME = 1,
	EVENT_TYPE_2                  = 2,
	EVENT_TYPE_PLAYER_LEAVE_GAME  = 3,
	EVENT_TYPE_PLAYER_MESSAGE     = 4,
	EVENT_TYPE_5                  = 5,
	EVENT_TYPE_6                  = 6,
	EVENT_TYPE_7                  = 7,
	EVENT_TYPE_8                  = 8,
	EVENT_TYPE_9                  = 9,
	EVENT_TYPE_10                 = 10,
	EVENT_TYPE_11                 = 11,
	EVENT_TYPE_12                 = 12,
	EVENT_TYPE_13                 = 13,
	EVENT_TYPE_14                 = 14,
	EVENT_TYPE_15                 = 15,
} event_type;

typedef enum _difficulty {
	DIFF_NORMAL      = 0x0,
	DIFF_NIGHTMARE   = 0x1,
	DIFF_HELL        = 0x2,
	NUM_DIFFICULTIES = 0x3,
} _difficulty;

typedef enum MON_ANIM {
	MA_STAND   = 0,
	MA_WALK    = 1,
	MA_ATTACK  = 2,
	MA_GOTHIT  = 3,
	MA_DEATH   = 4,
	MA_SPECIAL = 5,
} MON_ANIM;

typedef enum spell_type {
	RSPLTYPE_SKILL   = 0x0,
	RSPLTYPE_SPELL   = 0x1,
	RSPLTYPE_SCROLL  = 0x2,
	RSPLTYPE_CHARGES = 0x3,
	RSPLTYPE_INVALID = 0x4,
} spell_type;

typedef enum cursor_id {
	CURSOR_NONE        = 0x0,
	CURSOR_HAND        = 0x1,
	CURSOR_IDENTIFY    = 0x2,
	CURSOR_REPAIR      = 0x3,
	CURSOR_RECHARGE    = 0x4,
	CURSOR_DISARM      = 0x5,
	CURSOR_OIL         = 0x6,
	CURSOR_TELEKINESIS = 0x7,
	CURSOR_RESURRECT   = 0x8,
	CURSOR_TELEPORT    = 0x9,
	CURSOR_HEALOTHER   = 0xA,
	CURSOR_HOURGLASS   = 0xB,
	CURSOR_FIRSTITEM   = 0xC,
} cursor_id;

typedef enum direction {
	DIR_S    = 0x0,
	DIR_SW   = 0x1,
	DIR_W    = 0x2,
	DIR_NW   = 0x3,
	DIR_N    = 0x4,
	DIR_NE   = 0x5,
	DIR_E    = 0x6,
	DIR_SE   = 0x7,
	DIR_OMNI = 0x8,
} direction;

typedef enum _scroll_direction {
	SDIR_NONE = 0x0,
	SDIR_N    = 0x1,
	SDIR_NE   = 0x2,
	SDIR_E    = 0x3,
	SDIR_SE   = 0x4,
	SDIR_S    = 0x5,
	SDIR_SW   = 0x6,
	SDIR_W    = 0x7,
	SDIR_NW   = 0x8,
} _scroll_direction;

typedef enum interface_mode {
	WM_DIABNEXTLVL  = 0x402, // WM_USER+2
	WM_DIABPREVLVL  = 0x403,
	WM_DIABRTNLVL   = 0x404,
	WM_DIABSETLVL   = 0x405,
	WM_DIABWARPLVL  = 0x406,
	WM_DIABTOWNWARP = 0x407,
	WM_DIABTWARPUP  = 0x408,
	WM_DIABRETOWN   = 0x409,
	WM_DIABNEWGAME  = 0x40A,
	WM_DIABLOADGAME = 0x40B
	// WM_LEIGHSKIP = 0x40C, // psx only
	// WM_DIAVNEWLVL = 0x40D, // psx only
} interface_mode;

typedef enum lvl_entry {
	ENTRY_MAIN    = 0,
	ENTRY_PREV    = 1,
	ENTRY_SETLVL  = 2,
	ENTRY_RTNLVL  = 3,
	ENTRY_LOAD    = 4,
	ENTRY_WARPLVL = 5,
	ENTRY_TWARPDN = 6,
	ENTRY_TWARPUP = 7,
} lvl_entry;

typedef enum game_info {
	GAMEINFO_NAME         = 1,
	GAMEINFO_PASSWORD     = 2,
	GAMEINFO_STATS        = 3,
	GAMEINFO_MODEFLAG     = 4,
	GAMEINFO_GAMETEMPLATE = 5,
	GAMEINFO_PLAYERS      = 6,
} game_info;

typedef enum spell_id {
	SPL_NULL        = 0x0,
	SPL_FIREBOLT    = 0x1,
	SPL_HEAL        = 0x2,
	SPL_LIGHTNING   = 0x3,
	SPL_FLASH       = 0x4,
	SPL_IDENTIFY    = 0x5,
	SPL_FIREWALL    = 0x6,
	SPL_TOWN        = 0x7,
	SPL_STONE       = 0x8,
	SPL_INFRA       = 0x9,
	SPL_RNDTELEPORT = 0xA,
	SPL_MANASHIELD  = 0xB,
	SPL_FIREBALL    = 0xC,
	SPL_GUARDIAN    = 0xD,
	SPL_CHAIN       = 0xE,
	SPL_WAVE        = 0xF,
	SPL_DOOMSERP    = 0x10,
	SPL_BLODRIT     = 0x11,
	SPL_NOVA        = 0x12,
	SPL_INVISIBIL   = 0x13,
	SPL_FLAME       = 0x14,
	SPL_GOLEM       = 0x15,
	SPL_BLODBOIL    = 0x16,
	SPL_TELEPORT    = 0x17,
	SPL_APOCA       = 0x18,
	SPL_ETHEREALIZE = 0x19,
	SPL_REPAIR      = 0x1A,
	SPL_RECHARGE    = 0x1B,
	SPL_DISARM      = 0x1C,
	SPL_ELEMENT     = 0x1D,
	SPL_CBOLT       = 0x1E,
	SPL_HBOLT       = 0x1F,
	SPL_RESURRECT   = 0x20,
	SPL_TELEKINESIS = 0x21,
	SPL_HEALOTHER   = 0x22,
	SPL_FLARE       = 0x23,
	SPL_BONESPIRIT  = 0x24,
	SPL_LASTDIABLO  = SPL_BONESPIRIT,
	SPL_MANA        = 0x25,
	SPL_MAGI        = 0x26,
	SPL_JESTER      = 0x27,
	SPL_LIGHTWALL   = 0x28,
	SPL_IMMOLAT     = 0x29,
	SPL_WARP        = 0x2A,
	SPL_REFLECT     = 0x2B,
	SPL_BERSERK     = 0x2C,
	SPL_FIRERING    = 0x2D,
	SPL_SEARCH      = 0x2E,
	SPL_RUNEFIRE    = 0x2F,
	SPL_RUNELIGHT   = 0x30,
	SPL_RUNENOVA    = 0x31,
	SPL_RUNEIMMOLAT = 0x32,
	SPL_RUNESTONE   = 0x33,
	SPL_INVALID     = -1,
} spell_id;

typedef enum _cmd_id {
	CMD_STAND,
	CMD_WALKXY,
	CMD_ACK_PLRINFO,
	CMD_ADDSTR,
	CMD_ADDMAG,
	CMD_ADDDEX,
	CMD_ADDVIT,
	CMD_SBSPELL,
	CMD_GETITEM,
	CMD_AGETITEM,
	CMD_PUTITEM,
	CMD_RESPAWNITEM,
	CMD_ATTACKXY,
	CMD_RATTACKXY,
	CMD_SPELLXY,
	CMD_TSPELLXY,
	CMD_OPOBJXY,
	CMD_DISARMXY,
	CMD_ATTACKID,
	CMD_ATTACKPID,
	CMD_RATTACKID,
	CMD_RATTACKPID,
	CMD_SPELLID,
	CMD_SPELLPID,
	CMD_TSPELLID,
	CMD_TSPELLPID,
	CMD_RESURRECT,
	CMD_OPOBJT,
	CMD_KNOCKBACK,
	CMD_TALKXY,
	CMD_NEWLVL,
	CMD_WARP,
	CMD_CHEAT_EXPERIENCE,
	CMD_CHEAT_SPELL_LEVEL,
	CMD_DEBUG,
	CMD_SYNCDATA,
	CMD_MONSTDEATH,
	CMD_MONSTDAMAGE,
	CMD_PLRDEAD,
	CMD_REQUESTGITEM,
	CMD_REQUESTAGITEM,
	CMD_GOTOGETITEM,
	CMD_GOTOAGETITEM,
	CMD_OPENDOOR,
	CMD_CLOSEDOOR,
	CMD_OPERATEOBJ,
	CMD_PLROPOBJ,
	CMD_BREAKOBJ,
	CMD_CHANGEPLRITEMS,
	CMD_DELPLRITEMS,
	CMD_PLRDAMAGE,
	CMD_PLRLEVEL,
	CMD_DROPITEM,
	CMD_PLAYER_JOINLEVEL,
	CMD_SEND_PLRINFO,
	CMD_SATTACKXY,
	CMD_ACTIVATEPORTAL,
	CMD_DEACTIVATEPORTAL,
	CMD_DLEVEL_0,
	CMD_DLEVEL_1,
	CMD_DLEVEL_2,
	CMD_DLEVEL_3,
	CMD_DLEVEL_4,
	CMD_DLEVEL_5,
	CMD_DLEVEL_6,
	CMD_DLEVEL_7,
	CMD_DLEVEL_8,
	CMD_DLEVEL_9,
	CMD_DLEVEL_10,
	CMD_DLEVEL_11,
	CMD_DLEVEL_12,
	CMD_DLEVEL_13,
	CMD_DLEVEL_14,
	CMD_DLEVEL_15,
	CMD_DLEVEL_16,
	CMD_DLEVEL_17,
	CMD_DLEVEL_18,
	CMD_DLEVEL_19,
	CMD_DLEVEL_20,
	CMD_DLEVEL_21,
	CMD_DLEVEL_22,
	CMD_DLEVEL_23,
	CMD_DLEVEL_24,
	CMD_DLEVEL_JUNK,
	CMD_DLEVEL_END,
	CMD_HEALOTHER,
	CMD_STRING,
	CMD_SETSTR,
	CMD_SETMAG,
	CMD_SETDEX,
	CMD_SETVIT,
	CMD_RETOWN,
	CMD_SPELLXYD,
	CMD_ITEMEXTRA,
	CMD_SYNCPUTITEM,
	CMD_KILLGOLEM,
	CMD_SYNCQUEST,
	CMD_ENDSHIELD,
	CMD_AWAKEGOLEM,
	CMD_NOVA,
	CMD_SETSHIELD,
	CMD_REMSHIELD,
	CMD_REFLECT,
	CMD_NAKRUL,
	CMD_OPENHIVE,
	CMD_OPENCRYPT,
	FAKE_CMD_SETID,
	FAKE_CMD_DROPID,
	NUM_CMDS,
} _cmd_id;

typedef enum _music_id {
	TMUSIC_TOWN,
	TMUSIC_L1,
	TMUSIC_L2,
	TMUSIC_L3,
	TMUSIC_L4,
	TMUSIC_L5,
	TMUSIC_L6,
	TMUSIC_INTRO,
	NUM_MUSIC,
} _music_id;

typedef enum _mainmenu_selections {
	MAINMENU_SINGLE_PLAYER = 1,
	MAINMENU_MULTIPLAYER,
	MAINMENU_REPLAY_INTRO,
	MAINMENU_SHOW_SUPPORT,
	MAINMENU_SHOW_CREDITS,
	MAINMENU_EXIT_DIABLO,
	MAINMENU_ATTRACT_MODE,
} _mainmenu_selections;

typedef enum _selhero_selections {
	SELHERO_NEW_DUNGEON = 1,
	SELHERO_CONTINUE    = 2,
	SELHERO_CONNECT     = 3,
	SELHERO_PREVIOUS    = 4
} _selhero_selections;

typedef enum panel_button_id {
	PANBTN_CHARINFO  = 0,
	PANBTN_QLOG      = 1,
	PANBTN_AUTOMAP   = 2,
	PANBTN_MAINMENU  = 3,
	PANBTN_INVENTORY = 4,
	PANBTN_SPELLBOOK = 5,
	PANBTN_SENDMSG   = 6,
	PANBTN_FRIENDLY  = 7,
} panel_button_id;

typedef enum attribute_id {
	ATTRIB_STR = 0,
	ATTRIB_MAG = 1,
	ATTRIB_DEX = 2,
	ATTRIB_VIT = 3,
} attribute_id;

typedef enum _object_id {
	OBJ_L1LIGHT      = 0x0,
	OBJ_L1LDOOR      = 0x1,
	OBJ_L1RDOOR      = 0x2,
	OBJ_SKFIRE       = 0x3,
	OBJ_LEVER        = 0x4,
	OBJ_CHEST1       = 0x5,
	OBJ_CHEST2       = 0x6,
	OBJ_CHEST3       = 0x7,
	OBJ_CANDLE1      = 0x8,
	OBJ_CANDLE2      = 0x9,
	OBJ_CANDLEO      = 0xA,
	OBJ_BANNERL      = 0xB,
	OBJ_BANNERM      = 0xC,
	OBJ_BANNERR      = 0xD,
	OBJ_SKPILE       = 0xE,
	OBJ_SKSTICK1     = 0xF,
	OBJ_SKSTICK2     = 0x10,
	OBJ_SKSTICK3     = 0x11,
	OBJ_SKSTICK4     = 0x12,
	OBJ_SKSTICK5     = 0x13,
	OBJ_CRUX1        = 0x14,
	OBJ_CRUX2        = 0x15,
	OBJ_CRUX3        = 0x16,
	OBJ_STAND        = 0x17,
	OBJ_ANGEL        = 0x18,
	OBJ_BOOK2L       = 0x19,
	OBJ_BCROSS       = 0x1A,
	OBJ_NUDEW2R      = 0x1B,
	OBJ_SWITCHSKL    = 0x1C,
	OBJ_TNUDEM1      = 0x1D,
	OBJ_TNUDEM2      = 0x1E,
	OBJ_TNUDEM3      = 0x1F,
	OBJ_TNUDEM4      = 0x20,
	OBJ_TNUDEW1      = 0x21,
	OBJ_TNUDEW2      = 0x22,
	OBJ_TNUDEW3      = 0x23,
	OBJ_TORTURE1     = 0x24,
	OBJ_TORTURE2     = 0x25,
	OBJ_TORTURE3     = 0x26,
	OBJ_TORTURE4     = 0x27,
	OBJ_TORTURE5     = 0x28,
	OBJ_BOOK2R       = 0x29,
	OBJ_L2LDOOR      = 0x2A,
	OBJ_L2RDOOR      = 0x2B,
	OBJ_TORCHL       = 0x2C,
	OBJ_TORCHR       = 0x2D,
	OBJ_TORCHL2      = 0x2E,
	OBJ_TORCHR2      = 0x2F,
	OBJ_SARC         = 0x30,
	OBJ_FLAMEHOLE    = 0x31,
	OBJ_FLAMELVR     = 0x32,
	OBJ_WATER        = 0x33,
	OBJ_BOOKLVR      = 0x34,
	OBJ_TRAPL        = 0x35,
	OBJ_TRAPR        = 0x36,
	OBJ_BOOKSHELF    = 0x37,
	OBJ_WEAPRACK     = 0x38,
	OBJ_BARREL       = 0x39,
	OBJ_BARRELEX     = 0x3A,
	OBJ_SHRINEL      = 0x3B,
	OBJ_SHRINER      = 0x3C,
	OBJ_SKELBOOK     = 0x3D,
	OBJ_BOOKCASEL    = 0x3E,
	OBJ_BOOKCASER    = 0x3F,
	OBJ_BOOKSTAND    = 0x40,
	OBJ_BOOKCANDLE   = 0x41,
	OBJ_BLOODFTN     = 0x42,
	OBJ_DECAP        = 0x43,
	OBJ_TCHEST1      = 0x44,
	OBJ_TCHEST2      = 0x45,
	OBJ_TCHEST3      = 0x46,
	OBJ_BLINDBOOK    = 0x47,
	OBJ_BLOODBOOK    = 0x48,
	OBJ_PEDISTAL     = 0x49,
	OBJ_L3LDOOR      = 0x4A,
	OBJ_L3RDOOR      = 0x4B,
	OBJ_PURIFYINGFTN = 0x4C,
	OBJ_ARMORSTAND   = 0x4D,
	OBJ_ARMORSTANDN  = 0x4E,
	OBJ_GOATSHRINE   = 0x4F,
	OBJ_CAULDRON     = 0x50,
	OBJ_MURKYFTN     = 0x51,
	OBJ_TEARFTN      = 0x52,
	OBJ_ALTBOY       = 0x53,
	OBJ_MCIRCLE1     = 0x54,
	OBJ_MCIRCLE2     = 0x55,
	OBJ_STORYBOOK    = 0x56,
	OBJ_STORYCANDLE  = 0x57,
	OBJ_STEELTOME    = 0x58,
	OBJ_WARARMOR     = 0x59,
	OBJ_WARWEAP      = 0x5A,
	OBJ_TBCROSS      = 0x5B,
	OBJ_WEAPONRACK   = 0x5C,
	OBJ_WEAPONRACKN  = 0x5D,
	OBJ_MUSHPATCH    = 0x5E,
	OBJ_LAZSTAND     = 0x5F,
	OBJ_SLAINHERO    = 0x60,
	OBJ_SIGNCHEST    = 0x61,
	OBJ_BOOKSHELFR   = 0x62,
} _object_id;

typedef enum _item_indexes {
	IDI_GOLD,
	IDI_WARRIOR,
	IDI_WARRSHLD,
	IDI_WARRCLUB,
	IDI_ROGUE,
	IDI_SORCERER,
	IDI_CLEAVER,
	IDI_FIRSTQUEST = IDI_CLEAVER,
	IDI_SKCROWN,
	IDI_INFRARING,
	IDI_ROCK,
	IDI_OPTAMULET,
	IDI_TRING,
	IDI_BANNER,
	IDI_HARCREST,
	IDI_STEELVEIL,
	IDI_GLDNELIX,
	IDI_ANVIL,
	IDI_MUSHROOM,
	IDI_BRAIN,
	IDI_FUNGALTM,
	IDI_SPECELIX,
	IDI_BLDSTONE,
	IDI_MAPOFDOOM,
	IDI_LASTQUEST = IDI_MAPOFDOOM,
	IDI_EAR,
	IDI_HEAL,
	IDI_MANA,
	IDI_IDENTIFY,
	IDI_PORTAL,
	IDI_ARMOFVAL,
	IDI_FULLHEAL,
	IDI_FULLMANA,
	IDI_GRISWOLD,
	IDI_LGTFORGE,
	IDI_LAZSTAFF,
	IDI_RESURRECT,
	IDI_OIL,
	IDI_SHORTSTAFF,
	IDI_BARDSWORD,
	IDI_BARDDAGGER,
	IDI_RUNEBOMB,
	IDI_THEODORE,
	IDI_AURIC,
	IDI_NOTE1,
	IDI_NOTE2,
	IDI_NOTE3,
	IDI_FULLNOTE,
	IDI_BROWNSUIT,
	IDI_GREYSUIT,
} _item_indexes;

typedef enum _setlevels {
	//SL_BUTCHCHAMB = 0x0,
	SL_SKELKING     = 0x1,
	SL_BONECHAMB    = 0x2,
	SL_MAZE         = 0x3,
	SL_POISONWATER  = 0x4,
	SL_VILEBETRAYER = 0x5,
} _setlevels;

typedef enum quest_id {
	Q_ROCK     = 0x00,
	Q_MUSHROOM = 0x01,
	Q_GARBUD   = 0x02,
	Q_ZHAR     = 0x03,
	Q_VEIL     = 0x04,
	Q_DIABLO   = 0x05,
	Q_BUTCHER  = 0x06,
	Q_LTBANNER = 0x07,
	Q_BLIND    = 0x08,
	Q_BLOOD    = 0x09,
	Q_ANVIL    = 0x0A,
	Q_WARLORD  = 0x0B,
	Q_SKELKING = 0x0C,
	Q_PWATER   = 0x0D,
	Q_SCHAMB   = 0x0E,
	Q_BETRAYER = 0x0F,
	Q_GRAVE    = 0x10,
	Q_FARMER   = 0x11,
	Q_GIRL     = 0x12,
	Q_TRADER   = 0x13,
	Q_DEFILER  = 0x14,
	Q_NAKRUL   = 0x15,
	Q_CORNSTN  = 0x16,
	Q_JERSEY   = 0x17,
	Q_INVALID  = -1,
} quest_id;

typedef enum quest_state {
	QUEST_NOTAVAIL = 0, // quest did not spawn this game
	QUEST_INIT     = 1, // quest has spawned, waiting to trigger
	QUEST_ACTIVE   = 2, // quest is currently in progress
	QUEST_DONE     = 3  // quest log closed and finished
} quest_state;

typedef enum quest_gametype {
	QUEST_SINGLE = 0,
	QUEST_ANY    = 1,
	QUEST_MULTI  = 2,
} quest_gametype;

typedef enum quest_mush_state {
	QS_INIT         = 0,
	QS_TOMESPAWNED  = 1,
	QS_TOMEGIVEN    = 2,
	QS_MUSHSPAWNED  = 3,
	QS_MUSHPICKED   = 4,
	QS_MUSHGIVEN    = 5,
	QS_BRAINSPAWNED = 6,
	QS_BRAINGIVEN   = 7,
} quest_mush_state;

typedef enum _unique_items {
	UITEM_CLEAVER      = 0x0,
	UITEM_SKCROWN      = 0x1,
	UITEM_INFRARING    = 0x2,
	UITEM_OPTAMULET    = 0x3,
	UITEM_TRING        = 0x4,
	UITEM_HARCREST     = 0x5,
	UITEM_STEELVEIL    = 0x6,
	UITEM_ARMOFVAL     = 0x7,
	UITEM_GRISWOLD     = 0x8,
	UITEM_BOVINE       = 0x9,
	UITEM_RIFTBOW      = 0xA,
	UITEM_NEEDLER      = 0xB,
	UITEM_CELESTBOW    = 0xC,
	UITEM_DEADLYHUNT   = 0xD,
	UITEM_BOWOFDEAD    = 0xE,
	UITEM_BLKOAKBOW    = 0xF,
	UITEM_FLAMEDART    = 0x10,
	UITEM_FLESHSTING   = 0x11,
	UITEM_WINDFORCE    = 0x12,
	UITEM_EAGLEHORN    = 0x13,
	UITEM_GONNAGALDIRK = 0x14,
	UITEM_DEFENDER     = 0x15,
	UITEM_GRYPHONCLAW  = 0x16,
	UITEM_BLACKRAZOR   = 0x17,
	UITEM_GIBBOUSMOON  = 0x18,
	UITEM_ICESHANK     = 0x19,
	UITEM_EXECUTIONER  = 0x1A,
	UITEM_BONESAW      = 0x1B,
	UITEM_SHADHAWK     = 0x1C,
	UITEM_WIZSPIKE     = 0x1D,
	UITEM_LGTSABRE     = 0x1E,
	UITEM_FALCONTALON  = 0x1F,
	UITEM_INFERNO      = 0x20,
	UITEM_DOOMBRINGER  = 0x21,
	UITEM_GRIZZLY      = 0x22,
	UITEM_GRANDFATHER  = 0x23,
	UITEM_MANGLER      = 0x24,
	UITEM_SHARPBEAK    = 0x25,
	UITEM_BLOODLSLAYER = 0x26,
	UITEM_CELESTAXE    = 0x27,
	UITEM_WICKEDAXE    = 0x28,
	UITEM_STONECLEAV   = 0x29,
	UITEM_AGUHATCHET   = 0x2A,
	UITEM_HELLSLAYER   = 0x2B,
	UITEM_MESSERREAVER = 0x2C,
	UITEM_CRACKRUST    = 0x2D,
	UITEM_JHOLMHAMM    = 0x2E,
	UITEM_CIVERBS      = 0x2F,
	UITEM_CELESTSTAR   = 0x30,
	UITEM_BARANSTAR    = 0x31,
	UITEM_GNARLROOT    = 0x32,
	UITEM_CRANBASH     = 0x33,
	UITEM_SCHAEFHAMM   = 0x34,
	UITEM_DREAMFLANGE  = 0x35,
	UITEM_STAFFOFSHAD  = 0x36,
	UITEM_IMMOLATOR    = 0x37,
	UITEM_STORMSPIRE   = 0x38,
	UITEM_GLEAMSONG    = 0x39,
	UITEM_THUNDERCALL  = 0x3A,
	UITEM_PROTECTOR    = 0x3B,
	UITEM_NAJPUZZLE    = 0x3C,
	UITEM_MINDCRY      = 0x3D,
	UITEM_RODOFONAN    = 0x3E,
	UITEM_SPIRITSHELM  = 0x3F,
	UITEM_THINKINGCAP  = 0x40,
	UITEM_OVERLORDHELM = 0x41,
	UITEM_FOOLSCREST   = 0x42,
	UITEM_GOTTERDAM    = 0x43,
	UITEM_ROYCIRCLET   = 0x44,
	UITEM_TORNFLESH    = 0x45,
	UITEM_GLADBANE     = 0x46,
	UITEM_RAINCLOAK    = 0x47,
	UITEM_LEATHAUT     = 0x48,
	UITEM_WISDWRAP     = 0x49,
	UITEM_SPARKMAIL    = 0x4A,
	UITEM_SCAVCARAP    = 0x4B,
	UITEM_NIGHTSCAPE   = 0x4C,
	UITEM_NAJPLATE     = 0x4D,
	UITEM_DEMONSPIKE   = 0x4E,
	UITEM_DEFLECTOR    = 0x4F,
	UITEM_SKULLSHLD    = 0x50,
	UITEM_DRAGONBRCH   = 0x51,
	UITEM_BLKOAKSHLD   = 0x52,
	UITEM_HOLYDEF      = 0x53,
	UITEM_STORMSHLD    = 0x54,
	UITEM_BRAMBLE      = 0x55,
	UITEM_REGHA        = 0x56,
	UITEM_BLEEDER      = 0x57,
	UITEM_CONSTRICT    = 0x58,
	UITEM_ENGAGE       = 0x59,
	UITEM_INVALID      = 0x5A,
} _unique_items;

typedef enum plr_class {
	PC_WARRIOR,
	PC_ROGUE,
	PC_SORCERER,
	PC_MONK,
	PC_BARD,
	PC_BARBARIAN,
	NUM_CLASSES
} plr_class;

typedef enum _walk_path {
	WALK_NE   = 0x1,
	WALK_NW   = 0x2,
	WALK_SE   = 0x3,
	WALK_SW   = 0x4,
	WALK_N    = 0x5,
	WALK_E    = 0x6,
	WALK_S    = 0x7,
	WALK_W    = 0x8,
	WALK_NONE = -1,
} _walk_path;

// Logical equipment locations
typedef enum inv_body_loc {
	INVLOC_HEAD       = 0,
	INVLOC_RING_LEFT  = 1,
	INVLOC_RING_RIGHT = 2,
	INVLOC_AMULET     = 3,
	INVLOC_HAND_LEFT  = 4,
	INVLOC_HAND_RIGHT = 5,
	INVLOC_CHEST      = 6,
	NUM_INVLOC,
} inv_body_loc;

typedef enum inv_item {
	INVITEM_HEAD       = 0,
	INVITEM_RING_LEFT  = 1,
	INVITEM_RING_RIGHT = 2,
	INVITEM_AMULET     = 3,
	INVITEM_HAND_LEFT  = 4,
	INVITEM_HAND_RIGHT = 5,
	INVITEM_CHEST      = 6,
	INVITEM_INV_FIRST  = 7,
	INVITEM_INV_LAST   = 46,
	INVITEM_BELT_FIRST = 47,
	INVITEM_BELT_LAST  = 54,
	NUM_INVELEM
} inv_item;

// identifiers for each of the inventory squares
// see https://github.com/sanctuary/graphics/blob/master/inventory.png
typedef enum inv_xy_slot {
	SLOTXY_HEAD_FIRST       = 0,
	SLOTXY_HEAD_LAST        = 3,
	SLOTXY_RING_LEFT        = 4,
	SLOTXY_RING_RIGHT       = 5,
	SLOTXY_AMULET           = 6,
	SLOTXY_HAND_LEFT_FIRST  = 7,
	SLOTXY_HAND_LEFT_LAST   = 12,
	SLOTXY_HAND_RIGHT_FIRST = 13,
	SLOTXY_HAND_RIGHT_LAST  = 18,
	SLOTXY_CHEST_FIRST      = 19,
	SLOTXY_CHEST_LAST       = 24,

	// regular inventory
	SLOTXY_INV_FIRST = 25,
	SLOTXY_INV_LAST  = 64,

	// belt items
	SLOTXY_BELT_FIRST = 65,
	SLOTXY_BELT_LAST  = 72,
	NUM_XY_SLOTS      = 73
} inv_xy_slot;

typedef enum player_graphic {
	PFILE_STAND     = 1 << 0,
	PFILE_WALK      = 1 << 1,
	PFILE_ATTACK    = 1 << 2,
	PFILE_HIT       = 1 << 3,
	PFILE_LIGHTNING = 1 << 4,
	PFILE_FIRE      = 1 << 5,
	PFILE_MAGIC     = 1 << 6,
	PFILE_DEATH     = 1 << 7,
	PFILE_BLOCK     = 1 << 8,
	// everything except PFILE_DEATH
	// 0b1_0111_1111
	PFILE_NONDEATH = 0x17F
} player_graphic;

typedef enum anim_weapon_id {
	ANIM_ID_UNARMED        = 0x00,
	ANIM_ID_UNARMED_SHIELD = 0x01,
	ANIM_ID_SWORD          = 0x02,
	ANIM_ID_SWORD_SHIELD   = 0x03,
	ANIM_ID_BOW            = 0x04,
	ANIM_ID_AXE            = 0x05,
	ANIM_ID_MACE           = 0x06,
	ANIM_ID_MACE_SHIELD    = 0x07,
	ANIM_ID_STAFF          = 0x08
} anim_weapon_id;

typedef enum anim_armor_id {
	ANIM_ID_LIGHT_ARMOR  = 0x00,
	ANIM_ID_MEDIUM_ARMOR = 0x10,
	ANIM_ID_HEAVY_ARMOR  = 0x20
} anim_armor_id;

typedef enum shrine_gametype {
	SHRINETYPE_ANY    = 0,
	SHRINETYPE_SINGLE = 1,
	SHRINETYPE_MULTI  = 2,
} shrine_gametype;

typedef enum shrine_type {
	SHRINE_MYSTERIOUS   = 0,
	SHRINE_HIDDEN       = 1,
	SHRINE_GLOOMY       = 2,
	SHRINE_WEIRD        = 3,
	SHRINE_MAGICAL      = 4,
	SHRINE_STONE        = 5,
	SHRINE_RELIGIOUS    = 6,
	SHRINE_ENCHANTED    = 7,
	SHRINE_THAUMATURGIC = 8,
	SHRINE_FASCINATING  = 9,
	SHRINE_CRYPTIC      = 10,
	SHRINE_MAGICAL2     = 11,
	SHRINE_ELDRITCH     = 12,
	SHRINE_EERIE        = 13,
	SHRINE_DIVINE       = 14,
	SHRINE_HOLY         = 15,
	SHRINE_SACRED       = 16,
	SHRINE_SPIRITUAL    = 17,
	SHRINE_SPOOKY       = 18,
	SHRINE_ABANDONED    = 19,
	SHRINE_CREEPY       = 20,
	SHRINE_QUIET        = 21,
	SHRINE_SECLUDED     = 22,
	SHRINE_ORNATE       = 23,
	SHRINE_GLIMMERING   = 24,
	SHRINE_TAINTED      = 25,
	SHRINE_OILY         = 26,
	SHRINE_GLOWING      = 27,
	SHRINE_MENDICANT    = 28,
	SHRINE_SPARKLING    = 29,
	SHRINE_TOWN         = 30,
	SHRINE_SHIMMERING   = 31,
	SHRINE_SOLAR        = 32,
	SHRINE_MURPHYS      = 33,
	NUM_SHRINETYPE
} shrine_type;

typedef enum dlrg_flag {
	DLRG_HDOOR     = 0x01,
	DLRG_VDOOR     = 0x02,
	DLRG_CHAMBER   = 0x40,
	DLRG_PROTECTED = 0x80,
} dlrg_flag;

typedef enum conn_type {
	SELCONN_TCP,
	SELCONN_UDP,
	SELCONN_LOOPBACK,
} conn_type;

DEVILUTION_END_NAMESPACE
