/**
 * @file monstdat.cpp
 *
 * Implementation of all monster data.
 */
#include "all.h"

DEVILUTION_BEGIN_NAMESPACE

/** Contains the data related to each monster ID. */
const MonsterData monsterdata[] = {
	// clang-format off
	// width, mImage, GraphicType,                        has_special, sndfile,                             snd_special, has_trans, TransFile,                         Frames[6],                  Rate[6],              mName,               mMinDLvl, mMaxDLvl, mLevel, mMinHP, mMaxHP, mAi,          mFlags                                                             , mInt, mHit, mAFNum, mMinDamage, mMaxDamage, mHit2, mAFNum2, mMinDamage2, mMaxDamage2, mArmorClass, mMonstClass, mMagicRes                                                    , mMagicRes2                                                   , mTreasure, mSelFlag,  mExp
	{    128,    799, "Monsters\\Zombie\\Zombie%c.CL2",   FALSE,       "Monsters\\Zombie\\Zombie%c%i.WAV",  FALSE,       FALSE,     NULL,                              { 11, 24, 12,  6, 16,  0 }, { 4, 0, 0, 0, 0, 0 }, "Zombie",                   1,        3,      1,      4,      7, AI_ZOMBIE,    0                                                                  ,    0,   10,      8,          2,          5,     0,       0,           0,           0,           5, MC_UNDEAD,   IMMUNE_MAGIC  |                                  IMMUNE_NULL_40, IMMUNE_MAGIC  |                                  IMMUNE_NULL_40,         0,        3,    54 },
	{    128,    799, "Monsters\\Zombie\\Zombie%c.CL2",   FALSE,       "Monsters\\Zombie\\Zombie%c%i.WAV",  FALSE,       TRUE,      "Monsters\\Zombie\\Bluered.TRN",   { 11, 24, 12,  6, 16,  0 }, { 4, 0, 0, 0, 0, 0 }, "Ghoul",                    2,        4,      2,      7,     11, AI_ZOMBIE,    0                                                                  ,    1,   10,      8,          3,         10,     0,       0,           0,           0,          10, MC_UNDEAD,   IMMUNE_MAGIC  |                                  IMMUNE_NULL_40, IMMUNE_MAGIC  |                                  IMMUNE_NULL_40,         0,        3,    58 },
	{    128,    799, "Monsters\\Zombie\\Zombie%c.CL2",   FALSE,       "Monsters\\Zombie\\Zombie%c%i.WAV",  FALSE,       TRUE,      "Monsters\\Zombie\\Grey.TRN",      { 11, 24, 12,  6, 16,  0 }, { 4, 0, 0, 0, 0, 0 }, "Rotting Carcass",          2,        6,      4,     15,     25, AI_ZOMBIE,    0                                                                  ,    2,   25,      8,          5,         15,     0,       0,           0,           0,          15, MC_UNDEAD,   IMMUNE_MAGIC  |                                  IMMUNE_NULL_40, IMMUNE_MAGIC  | RESIST_FIRE |                    IMMUNE_NULL_40,         0,        3,   136 },
	{    128,    799, "Monsters\\Zombie\\Zombie%c.CL2",   FALSE,       "Monsters\\Zombie\\Zombie%c%i.WAV",  FALSE,       TRUE,      "Monsters\\Zombie\\Yellow.TRN",    { 11, 24, 12,  6, 16,  0 }, { 4, 0, 0, 0, 0, 0 }, "Black Death",              4,        8,      6,     25,     40, AI_ZOMBIE,    0                                                                  ,    3,   30,      8,          6,         22,     0,       0,           0,           0,          20, MC_UNDEAD,   IMMUNE_MAGIC  |                                  IMMUNE_NULL_40, IMMUNE_MAGIC  |               RESIST_LIGHTNING | IMMUNE_NULL_40,         0,        3,   240 },
	{    128,    543, "Monsters\\FalSpear\\Phall%c.CL2",  TRUE,        "Monsters\\FalSpear\\Phall%c%i.WAV", TRUE,        TRUE,      "Monsters\\FalSpear\\FallenT.TRN", { 11, 11, 13, 11, 18, 13 }, { 3, 0, 0, 0, 0, 0 }, "Fallen One",               1,        3,      1,      1,      4, AI_FALLEN,    0                                                                  ,    0,   15,      7,          1,          3,     0,       5,           0,           0,           0, MC_ANIMAL,   0                                                            , 0                                                            ,         0,        3,    46 },
	{    128,    543, "Monsters\\FalSpear\\Phall%c.CL2",  TRUE,        "Monsters\\FalSpear\\Phall%c%i.WAV", TRUE,        TRUE,      "Monsters\\FalSpear\\Dark.TRN",    { 11, 11, 13, 11, 18, 13 }, { 3, 0, 0, 0, 0, 0 }, "Carver",                   2,        5,      3,      4,      8, AI_FALLEN,    0                                                                  ,    2,   20,      7,          2,          5,     0,       5,           0,           0,           5, MC_ANIMAL,   0                                                            , 0                                                            ,         0,        3,    80 },
	{    128,    543, "Monsters\\FalSpear\\Phall%c.CL2",  TRUE,        "Monsters\\FalSpear\\Phall%c%i.WAV", TRUE,        FALSE,     NULL,                              { 11, 11, 13, 11, 18, 13 }, { 3, 0, 0, 0, 0, 0 }, "Devil Kin",                3,        7,      5,     12,     24, AI_FALLEN,    0                                                                  ,    2,   25,      7,          3,          7,     0,       5,           0,           0,          10, MC_ANIMAL,   0                                                            ,                RESIST_FIRE                                   ,         0,        3,   155 },
	{    128,    543, "Monsters\\FalSpear\\Phall%c.CL2",  TRUE,        "Monsters\\FalSpear\\Phall%c%i.WAV", TRUE,        TRUE,      "Monsters\\FalSpear\\Blue.TRN",    { 11, 11, 13, 11, 18, 13 }, { 3, 0, 0, 0, 0, 0 }, "Dark One",                 5,        9,      7,     20,     36, AI_FALLEN,    0                                                                  ,    3,   30,      7,          4,          8,     0,       5,           0,           0,          15, MC_ANIMAL,                                                   IMMUNE_NULL_40,                              RESIST_LIGHTNING | IMMUNE_NULL_40,         0,        3,   255 },
	{    128,    553, "Monsters\\SkelAxe\\SklAx%c.CL2",   TRUE,        "Monsters\\SkelAxe\\SklAx%c%i.WAV",  FALSE,       TRUE,      "Monsters\\SkelAxe\\White.TRN",    { 12,  8, 13,  6, 17, 16 }, { 5, 0, 0, 0, 0, 0 }, "Skeleton",                 1,        3,      1,      2,      4, AI_SKELSD,    0                                                                  ,    0,   20,      8,          1,          4,     0,       0,           0,           0,           0, MC_UNDEAD,   IMMUNE_MAGIC  |                                  IMMUNE_NULL_40, IMMUNE_MAGIC  |                                  IMMUNE_NULL_40,         0,        3,    64 },
	{    128,    553, "Monsters\\SkelAxe\\SklAx%c.CL2",   TRUE,        "Monsters\\SkelAxe\\SklAx%c%i.WAV",  FALSE,       TRUE,      "Monsters\\SkelAxe\\Skelt.TRN",    { 12,  8, 13,  6, 17, 16 }, { 4, 0, 0, 0, 0, 0 }, "Corpse Axe",               2,        5,      2,      4,      7, AI_SKELSD,    0                                                                  ,    1,   25,      8,          3,          5,     0,       0,           0,           0,           0, MC_UNDEAD,   IMMUNE_MAGIC  |                                  IMMUNE_NULL_40, IMMUNE_MAGIC  |                                  IMMUNE_NULL_40,         0,        3,    68 },
	{    128,    553, "Monsters\\SkelAxe\\SklAx%c.CL2",   TRUE,        "Monsters\\SkelAxe\\SklAx%c%i.WAV",  FALSE,       FALSE,     NULL,                              { 12,  8, 13,  6, 17, 16 }, { 2, 0, 0, 0, 0, 0 }, "Burning Dead",             2,        6,      4,      8,     12, AI_SKELSD,    0                                                                  ,    2,   30,      8,          3,          7,     0,       0,           0,           0,           5, MC_UNDEAD,   IMMUNE_MAGIC  | RESIST_FIRE |                    IMMUNE_NULL_40, IMMUNE_MAGIC  | IMMUNE_FIRE  |                    IMMUNE_NULL_40,         0,        3,   154 },
	{    128,    553, "Monsters\\SkelAxe\\SklAx%c.CL2",   TRUE,        "Monsters\\SkelAxe\\SklAx%c%i.WAV",  FALSE,       TRUE,      "Monsters\\SkelAxe\\Black.TRN",    { 12,  8, 13,  6, 17, 16 }, { 3, 0, 0, 0, 0, 0 }, "Horror",                   4,        8,      6,     12,     20, AI_SKELSD,    0                                                                  ,    3,   35,      8,          4,          9,     0,       0,           0,           0,          15, MC_UNDEAD,   IMMUNE_MAGIC  |               RESIST_LIGHTNING | IMMUNE_NULL_40, IMMUNE_MAGIC  |               RESIST_LIGHTNING | IMMUNE_NULL_40,         0,        3,   264 },
	{    128,    623, "Monsters\\FalSword\\Fall%c.CL2",   TRUE,        "Monsters\\FalSword\\Fall%c%i.WAV",  TRUE,        TRUE,      "Monsters\\FalSword\\FallenT.TRN", { 12, 12, 13, 11, 14, 15 }, { 3, 0, 0, 0, 0, 0 }, "Fallen One",               1,        3,      1,      2,      5, AI_FALLEN,    0                                                                  ,    0,   15,      8,          1,          4,     0,       5,           0,           0,          10, MC_ANIMAL,   0                                                            , 0                                                            ,         0,        3,    52 },
	{    128,    623, "Monsters\\FalSword\\Fall%c.CL2",   TRUE,        "Monsters\\FalSword\\Fall%c%i.WAV",  TRUE,        TRUE,      "Monsters\\FalSword\\Dark.TRN",    { 12, 12, 13, 11, 14, 15 }, { 3, 0, 0, 0, 0, 0 }, "Carver",                   2,        5,      3,      5,      9, AI_FALLEN,    0                                                                  ,    1,   20,      8,          2,          7,     0,       5,           0,           0,          15, MC_ANIMAL,   0                                                            , 0                                                            ,         0,        3,    90 },
	{    128,    623, "Monsters\\FalSword\\Fall%c.CL2",   TRUE,        "Monsters\\FalSword\\Fall%c%i.WAV",  TRUE,        FALSE,     NULL,                              { 12, 12, 13, 11, 14, 15 }, { 3, 0, 0, 0, 0, 0 }, "Devil Kin",                3,        7,      5,     16,     24, AI_FALLEN,    0                                                                  ,    2,   25,      8,          4,         10,     0,       5,           0,           0,          20, MC_ANIMAL,   0                                                            ,                RESIST_FIRE                                   ,         0,        3,   180 },
	{    128,    623, "Monsters\\FalSword\\Fall%c.CL2",   TRUE,        "Monsters\\FalSword\\Fall%c%i.WAV",  TRUE,        TRUE,      "Monsters\\FalSword\\Blue.TRN",    { 12, 12, 13, 11, 14, 15 }, { 3, 0, 0, 0, 0, 0 }, "Dark One",                 5,        9,      7,     24,     36, AI_FALLEN,    0                                                                  ,    3,   30,      8,          4,         12,     0,       5,           0,           0,          25, MC_ANIMAL,                                                   IMMUNE_NULL_40,                              RESIST_LIGHTNING | IMMUNE_NULL_40,         0,        3,   280 },
	{    128,    410, "Monsters\\Scav\\Scav%c.CL2",       TRUE,        "Monsters\\Scav\\Scav%c%i.WAV",      FALSE,       FALSE,     NULL,                              { 12,  8, 12,  6, 20, 11 }, { 2, 0, 0, 0, 0, 0 }, "Scavenger",                1,        4,      2,      3,      6, AI_SCAV,      0                                                                  ,    0,   20,      7,          1,          5,     0,       0,           0,           0,          10, MC_ANIMAL,   0                                                            ,                RESIST_FIRE                                   ,         0,        3,    80 },
	{    128,    410, "Monsters\\Scav\\Scav%c.CL2",       TRUE,        "Monsters\\Scav\\Scav%c%i.WAV",      FALSE,       TRUE,      "Monsters\\Scav\\ScavBr.TRN",      { 12,  8, 12,  6, 20, 11 }, { 2, 0, 0, 0, 0, 0 }, "Plague Eater",             3,        6,      4,     12,     24, AI_SCAV,      0                                                                  ,    1,   30,      7,          1,          8,     0,       0,           0,           0,          20, MC_ANIMAL,   0                                                            ,                              RESIST_LIGHTNING                ,         0,        3,   188 },
	{    128,    410, "Monsters\\Scav\\Scav%c.CL2",       TRUE,        "Monsters\\Scav\\Scav%c%i.WAV",      FALSE,       TRUE,      "Monsters\\Scav\\ScavBe.TRN",      { 12,  8, 12,  6, 20, 11 }, { 2, 0, 0, 0, 0, 0 }, "Shadow Beast",             4,        8,      6,     24,     36, AI_SCAV,      0                                                                  ,    2,   35,      7,          3,         12,     0,       0,           0,           0,          25, MC_ANIMAL,                                                   IMMUNE_NULL_40,                RESIST_FIRE |                    IMMUNE_NULL_40,         0,        3,   375 },
	{    128,    410, "Monsters\\Scav\\Scav%c.CL2",       TRUE,        "Monsters\\Scav\\Scav%c%i.WAV",      FALSE,       TRUE,      "Monsters\\Scav\\ScavW.TRN",       { 12,  8, 12,  6, 20, 11 }, { 2, 0, 0, 0, 0, 0 }, "Bone Gasher",              6,       10,      8,     28,     40, AI_SCAV,      0                                                                  ,    3,   35,      7,          5,         15,     0,       0,           0,           0,          30, MC_ANIMAL,   RESIST_MAGIC |                                  IMMUNE_NULL_40,                              RESIST_LIGHTNING | IMMUNE_NULL_40,         0,        3,   552 },
	{    128,    567, "Monsters\\SkelBow\\SklBw%c.CL2",   TRUE,        "Monsters\\SkelBow\\SklBw%c%i.WAV",  FALSE,       TRUE,      "Monsters\\SkelBow\\White.TRN",    {  9,  8, 16,  5, 16, 16 }, { 4, 0, 0, 0, 0, 0 }, "Skeleton",                 2,        5,      3,      2,      4, AI_SKELBOW,   0                                                                  ,    0,   15,     12,          1,          2,     0,       0,           0,           0,           0, MC_UNDEAD,   IMMUNE_MAGIC  |                                  IMMUNE_NULL_40, IMMUNE_MAGIC  |                                  IMMUNE_NULL_40,         0,        3,   110 },
	{    128,    567, "Monsters\\SkelBow\\SklBw%c.CL2",   TRUE,        "Monsters\\SkelBow\\SklBw%c%i.WAV",  FALSE,       TRUE,      "Monsters\\SkelBow\\Skelt.TRN",    {  9,  8, 16,  5, 16, 16 }, { 4, 0, 0, 0, 0, 0 }, "Corpse Bow",               3,        7,      5,      8,     16, AI_SKELBOW,   0                                                                  ,    1,   25,     12,          1,          4,     0,       0,           0,           0,           0, MC_UNDEAD,   IMMUNE_MAGIC  |                                  IMMUNE_NULL_40, IMMUNE_MAGIC  |                                  IMMUNE_NULL_40,         0,        3,   210 },
	{    128,    567, "Monsters\\SkelBow\\SklBw%c.CL2",   TRUE,        "Monsters\\SkelBow\\SklBw%c%i.WAV",  FALSE,       FALSE,     NULL,                              {  9,  8, 16,  5, 16, 16 }, { 2, 0, 0, 0, 0, 0 }, "Burning Dead",             5,        9,      7,     10,     24, AI_SKELBOW,   0                                                                  ,    2,   30,     12,          1,          6,     0,       0,           0,           0,           5, MC_UNDEAD,   IMMUNE_MAGIC  | RESIST_FIRE |                    IMMUNE_NULL_40, IMMUNE_MAGIC  | IMMUNE_FIRE  |                    IMMUNE_NULL_40,         0,        3,   364 },
	{    128,    567, "Monsters\\SkelBow\\SklBw%c.CL2",   TRUE,        "Monsters\\SkelBow\\SklBw%c%i.WAV",  FALSE,       TRUE,      "Monsters\\SkelBow\\Black.TRN",    {  9,  8, 16,  5, 16, 16 }, { 3, 0, 0, 0, 0, 0 }, "Horror",                   7,       11,      9,     15,     45, AI_SKELBOW,   0                                                                  ,    3,   35,     12,          2,          9,     0,       0,           0,           0,          15, MC_UNDEAD,   IMMUNE_MAGIC  |               RESIST_LIGHTNING | IMMUNE_NULL_40, IMMUNE_MAGIC  |               RESIST_LIGHTNING | IMMUNE_NULL_40,         0,        3,   594 },
	{    128,    575, "Monsters\\SkelSd\\SklSr%c.CL2",    TRUE,        "Monsters\\SkelSd\\SklSr%c%i.WAV",   TRUE,        TRUE,      "Monsters\\SkelSd\\White.TRN",     { 13,  8, 12,  7, 15, 16 }, { 4, 0, 0, 0, 0, 0 }, "Skeleton Captain",         1,        4,      2,      3,      6, AI_SKELSD,    0                                                                  ,    0,   20,      8,          2,          7,     0,       0,           0,           0,          10, MC_UNDEAD,   IMMUNE_MAGIC  |                                  IMMUNE_NULL_40, IMMUNE_MAGIC  |                                  IMMUNE_NULL_40,         0,        3,    90 },
	{    128,    575, "Monsters\\SkelSd\\SklSr%c.CL2",    TRUE,        "Monsters\\SkelSd\\SklSr%c%i.WAV",   FALSE,       TRUE,      "Monsters\\SkelSd\\Skelt.TRN",     { 13,  8, 12,  7, 15, 16 }, { 4, 0, 0, 0, 0, 0 }, "Corpse Captain",           2,        6,      4,     12,     20, AI_SKELSD,    0                                                                  ,    1,   30,      8,          3,          9,     0,       0,           0,           0,           5, MC_UNDEAD,   IMMUNE_MAGIC  |                                  IMMUNE_NULL_40, IMMUNE_MAGIC  |                                  IMMUNE_NULL_40,         0,        3,   200 },
	{    128,    575, "Monsters\\SkelSd\\SklSr%c.CL2",    TRUE,        "Monsters\\SkelSd\\SklSr%c%i.WAV",   FALSE,       FALSE,     NULL,                              { 13,  8, 12,  7, 15, 16 }, { 4, 0, 0, 0, 0, 0 }, "Burning Dead Captain",     4,        8,      6,     16,     30, AI_SKELSD,    0                                                                  ,    2,   35,      8,          4,         10,     0,       0,           0,           0,          15, MC_UNDEAD,   IMMUNE_MAGIC  | RESIST_FIRE |                    IMMUNE_NULL_40, IMMUNE_MAGIC  | IMMUNE_FIRE  |                    IMMUNE_NULL_40,         0,        3,   393 },
	{    128,    575, "Monsters\\SkelSd\\SklSr%c.CL2",    TRUE,        "Monsters\\SkelSd\\SklSr%c%i.WAV",   FALSE,       TRUE,      "Monsters\\SkelSd\\Black.TRN",     { 13,  8, 12,  7, 15, 16 }, { 4, 0, 0, 0, 0, 0 }, "Horror Captain",           6,       10,      8,     35,     50, AI_SKELSD,                                     MFLAG_SEARCH                      ,    3,   40,      8,          5,         14,     0,       0,           0,           0,          30, MC_UNDEAD,   IMMUNE_MAGIC  |               RESIST_LIGHTNING | IMMUNE_NULL_40, IMMUNE_MAGIC  |               RESIST_LIGHTNING | IMMUNE_NULL_40,         0,        3,   604 },
	{    128,    800, "Monsters\\TSneak\\TSneak%c.CL2",   FALSE,       "Monsters\\TSneak\\Sneakl%c%i.WAV",  FALSE,       FALSE,     NULL,                              { 13, 13, 15, 11, 16,  0 }, { 2, 0, 0, 0, 0, 0 }, "Invisible Lord",          36,       39,     14,    278,    278, AI_SKELSD,                                     MFLAG_SEARCH | MFLAG_CAN_OPEN_DOOR,    3,   65,      8,         16,         30,     0,       0,           0,           0,          60, MC_DEMON,    RESIST_MAGIC | RESIST_FIRE | RESIST_LIGHTNING | IMMUNE_NULL_40, RESIST_MAGIC | RESIST_FIRE | RESIST_LIGHTNING | IMMUNE_NULL_40,         0,        3,  2000 },
	{    128,    992, "Monsters\\Sneak\\Sneak%c.CL2",     TRUE,        "Monsters\\Sneak\\Sneak%c%i.WAV",    FALSE,       FALSE,     NULL,                              { 16,  8, 12,  8, 24, 15 }, { 2, 0, 0, 0, 0, 0 }, "Hidden",                   3,        8,      5,      8,     24, AI_SNEAK,     MFLAG_HIDDEN                                                       ,    0,   35,      8,          3,          6,     0,       0,           0,           0,          25, MC_DEMON,    0                                                            ,                                                 IMMUNE_NULL_40,         0,        3,   278 },
	{    128,    992, "Monsters\\Sneak\\Sneak%c.CL2",     TRUE,        "Monsters\\Sneak\\Sneak%c%i.WAV",    FALSE,       TRUE,      "Monsters\\Sneak\\Sneakv2.TRN",    { 16,  8, 12,  8, 24, 15 }, { 2, 0, 0, 0, 0, 0 }, "Stalker",                  8,       12,      9,     30,     45, AI_SNEAK,     MFLAG_HIDDEN |                   MFLAG_SEARCH                      ,    1,   40,      8,          8,         16,     0,       0,           0,           0,          30, MC_DEMON,    0                                                            ,                                                 IMMUNE_NULL_40,         0,        3,   630 },
	{    128,    992, "Monsters\\Sneak\\Sneak%c.CL2",     TRUE,        "Monsters\\Sneak\\Sneak%c%i.WAV",    FALSE,       TRUE,      "Monsters\\Sneak\\Sneakv3.TRN",    { 16,  8, 12,  8, 24, 15 }, { 2, 0, 0, 0, 0, 0 }, "Unseen",                  10,       14,     11,     35,     50, AI_SNEAK,     MFLAG_HIDDEN |                   MFLAG_SEARCH                      ,    2,   45,      8,         12,         20,     0,       0,           0,           0,          30, MC_DEMON,    RESIST_MAGIC |                                  IMMUNE_NULL_40, IMMUNE_MAGIC  |                                  IMMUNE_NULL_40,         0,        3,   935 },
	{    128,    992, "Monsters\\Sneak\\Sneak%c.CL2",     TRUE,        "Monsters\\Sneak\\Sneak%c%i.WAV",    FALSE,       TRUE,      "Monsters\\Sneak\\Sneakv1.TRN",    { 16,  8, 12,  8, 24, 15 }, { 2, 0, 0, 0, 0, 0 }, "Illusion Weaver",         14,       18,     13,     40,     60, AI_SNEAK,     MFLAG_HIDDEN |                   MFLAG_SEARCH                      ,    3,   60,      8,         16,         24,     0,       0,           0,           0,          30, MC_DEMON,    RESIST_MAGIC | RESIST_FIRE                                   , IMMUNE_MAGIC  | RESIST_FIRE |                    IMMUNE_NULL_40,         0,        3,  1500 },
	{    160,    800, "Monsters\\GoatLord\\GoatL%c.CL2",  FALSE,       "Monsters\\newsfx\\Satyr%c%i.WAV",   FALSE,       FALSE,     NULL,                              { 13, 13, 14,  9, 16,  0 }, { 2, 0, 0, 0, 0, 0 }, "Satyr Lord",              40,       43,     28,    160,    200, AI_SKELSD,                                     MFLAG_SEARCH                      ,    3,   90,      8,         20,         30,     0,       0,           0,           0,          70, MC_ANIMAL,                  RESIST_FIRE | RESIST_LIGHTNING                , RESIST_MAGIC | IMMUNE_FIRE  | IMMUNE_LIGHTNING                 ,         0,        3,  2800 },
	{    128,   1030, "Monsters\\GoatMace\\Goat%c.CL2",   TRUE,        "Monsters\\GoatMace\\Goat%c%i.WAV",  FALSE,       FALSE,     NULL,                              { 12,  8, 12,  6, 20, 12 }, { 2, 0, 0, 0, 1, 0 }, "Flesh Clan",               6,       10,      8,     30,     45, AI_GOATMC,                                     MFLAG_SEARCH | MFLAG_CAN_OPEN_DOOR,    0,   50,      8,          4,         10,     0,       0,           0,           0,          40, MC_DEMON,    0                                                            , 0                                                            ,         0,        3,   460 },
	{    128,   1030, "Monsters\\GoatMace\\Goat%c.CL2",   TRUE,        "Monsters\\GoatMace\\Goat%c%i.WAV",  FALSE,       TRUE,      "Monsters\\GoatMace\\Beige.TRN",   { 12,  8, 12,  6, 20, 12 }, { 2, 0, 0, 0, 1, 0 }, "Stone Clan",               8,       12,     10,     40,     55, AI_GOATMC,                                     MFLAG_SEARCH | MFLAG_CAN_OPEN_DOOR,    1,   60,      8,          6,         12,     0,       0,           0,           0,          40, MC_DEMON,    RESIST_MAGIC |                                  IMMUNE_NULL_40, IMMUNE_MAGIC  |                                  IMMUNE_NULL_40,         0,        3,   685 },
	{    128,   1030, "Monsters\\GoatMace\\Goat%c.CL2",   TRUE,        "Monsters\\GoatMace\\Goat%c%i.WAV",  FALSE,       TRUE,      "Monsters\\GoatMace\\Red.TRN",     { 12,  8, 12,  6, 20, 12 }, { 2, 0, 0, 0, 1, 0 }, "Fire Clan",               10,       14,     12,     50,     65, AI_GOATMC,                                     MFLAG_SEARCH | MFLAG_CAN_OPEN_DOOR,    2,   70,      8,          8,         16,     0,       0,           0,           0,          45, MC_DEMON,                   RESIST_FIRE                                   ,                IMMUNE_FIRE                                    ,         0,        3,   906 },
	{    128,   1030, "Monsters\\GoatMace\\Goat%c.CL2",   TRUE,        "Monsters\\GoatMace\\Goat%c%i.WAV",  FALSE,       TRUE,      "Monsters\\GoatMace\\Gray.TRN",    { 12,  8, 12,  6, 20, 12 }, { 2, 0, 0, 0, 1, 0 }, "Night Clan",              12,       16,     14,     55,     70, AI_GOATMC,                                     MFLAG_SEARCH | MFLAG_CAN_OPEN_DOOR,    3,   80,      8,         10,         20,    15,       0,          30,          30,          50, MC_DEMON,    RESIST_MAGIC |                                  IMMUNE_NULL_40, IMMUNE_MAGIC  |                                  IMMUNE_NULL_40,         0,        3,  1190 },
	{     96,    364, "Monsters\\Bat\\Bat%c.CL2",         FALSE,       "Monsters\\Bat\\Bat%c%i.WAV",        FALSE,       TRUE,      "Monsters\\Bat\\red.trn",          {  9, 13, 10,  9, 13,  0 }, { 0, 0, 0, 0, 0, 0 }, "Fiend",                    2,        5,      3,      3,      6, AI_BAT,       0                                                                  ,    0,   35,      5,          1,          6,     0,       0,           0,           0,           0, MC_ANIMAL,   0                                                            , 0                                                            ,    0x4000,        6,   102 },
	{     96,    364, "Monsters\\Bat\\Bat%c.CL2",         FALSE,       "Monsters\\Bat\\Bat%c%i.WAV",        FALSE,       FALSE,     NULL,                              {  9, 13, 10,  9, 13,  0 }, { 0, 0, 0, 0, 0, 0 }, "Blink",                    5,        9,      7,     12,     28, AI_BAT,       0                                                                  ,    1,   45,      5,          1,          8,     0,       0,           0,           0,          15, MC_ANIMAL,   0                                                            , 0                                                            ,    0x4000,        6,   340 },
	{     96,    364, "Monsters\\Bat\\Bat%c.CL2",         FALSE,       "Monsters\\Bat\\Bat%c%i.WAV",        FALSE,       TRUE,      "Monsters\\Bat\\grey.trn",         {  9, 13, 10,  9, 13,  0 }, { 0, 0, 0, 0, 0, 0 }, "Gloom",                    7,       11,      9,     28,     36, AI_BAT,                                        MFLAG_SEARCH                      ,    2,   70,      5,          4,         12,     0,       0,           0,           0,          35, MC_ANIMAL,   RESIST_MAGIC                                                 , RESIST_MAGIC |                                  IMMUNE_NULL_40,    0x4000,        6,   509 },
	{     96,    364, "Monsters\\Bat\\Bat%c.CL2",         FALSE,       "Monsters\\Bat\\Bat%c%i.WAV",        FALSE,       TRUE,      "Monsters\\Bat\\orange.trn",       {  9, 13, 10,  9, 13,  0 }, { 0, 0, 0, 0, 0, 0 }, "Familiar",                11,       15,     13,     20,     35, AI_BAT,                                        MFLAG_SEARCH                      ,    3,   50,      5,          4,         16,     0,       0,           0,           0,          35, MC_DEMON,    RESIST_MAGIC |               IMMUNE_LIGHTNING                 , RESIST_MAGIC |               IMMUNE_LIGHTNING  | IMMUNE_NULL_40,    0x4000,        6,   448 },
	{    128,   1040, "Monsters\\GoatBow\\GoatB%c.CL2",   FALSE,       "Monsters\\GoatBow\\GoatB%c%i.WAV",  FALSE,       FALSE,     NULL,                              { 12,  8, 16,  6, 20,  0 }, { 3, 0, 0, 0, 0, 0 }, "Flesh Clan",               6,       10,      8,     20,     35, AI_GOATBOW,                                                   MFLAG_CAN_OPEN_DOOR,    0,   35,     13,          1,          7,     0,       0,           0,           0,          35, MC_DEMON,    0                                                            , 0                                                            ,         0,        3,   448 },
	{    128,   1040, "Monsters\\GoatBow\\GoatB%c.CL2",   FALSE,       "Monsters\\GoatBow\\GoatB%c%i.WAV",  FALSE,       TRUE,      "Monsters\\GoatBow\\Beige.TRN",    { 12,  8, 16,  6, 20,  0 }, { 3, 0, 0, 0, 0, 0 }, "Stone Clan",               8,       12,     10,     30,     40, AI_GOATBOW,                                                   MFLAG_CAN_OPEN_DOOR,    1,   40,     13,          2,          9,     0,       0,           0,           0,          35, MC_DEMON,    RESIST_MAGIC |                                  IMMUNE_NULL_40, IMMUNE_MAGIC  |                                  IMMUNE_NULL_40,         0,        3,   645 },
	{    128,   1040, "Monsters\\GoatBow\\GoatB%c.CL2",   FALSE,       "Monsters\\GoatBow\\GoatB%c%i.WAV",  FALSE,       TRUE,      "Monsters\\GoatBow\\Red.TRN",      { 12,  8, 16,  6, 20,  0 }, { 3, 0, 0, 0, 0, 0 }, "Fire Clan",               10,       14,     12,     40,     50, AI_GOATBOW,                                    MFLAG_SEARCH | MFLAG_CAN_OPEN_DOOR,    2,   45,     13,          3,         11,     0,       0,           0,           0,          35, MC_DEMON,                   RESIST_FIRE                                   ,                IMMUNE_FIRE                                    ,         0,        3,   822 },
	{    128,   1040, "Monsters\\GoatBow\\GoatB%c.CL2",   FALSE,       "Monsters\\GoatBow\\GoatB%c%i.WAV",  FALSE,       TRUE,      "Monsters\\GoatBow\\Gray.TRN",     { 12,  8, 16,  6, 20,  0 }, { 3, 0, 0, 0, 0, 0 }, "Night Clan",              12,       16,     14,     50,     65, AI_GOATBOW,                                    MFLAG_SEARCH | MFLAG_CAN_OPEN_DOOR,    3,   50,     13,          4,         13,    15,       0,           0,           0,          40, MC_DEMON,    RESIST_MAGIC |                                  IMMUNE_NULL_40, IMMUNE_MAGIC  |                                  IMMUNE_NULL_40,         0,        3,  1092 },
	{    128,    716, "Monsters\\Acid\\Acid%c.CL2",       TRUE,        "Monsters\\Acid\\Acid%c%i.WAV",      TRUE,        FALSE,     NULL,                              { 13,  8, 12,  8, 16, 12 }, { 0, 0, 0, 0, 0, 0 }, "Acid Beast",              10,       14,     11,     40,     66, AI_ACID,      0                                                                  ,    0,   40,      8,          4,         12,    25,       8,           0,           0,          30, MC_ANIMAL,                                                   IMMUNE_ACID   , IMMUNE_MAGIC  |                                  IMMUNE_ACID   ,         0,        3,   846 },
	{    128,    716, "Monsters\\Acid\\Acid%c.CL2",       TRUE,        "Monsters\\Acid\\Acid%c%i.WAV",      TRUE,        TRUE,      "Monsters\\Acid\\AcidBlk.TRN",     { 13,  8, 12,  8, 16, 12 }, { 0, 0, 0, 0, 0, 0 }, "Poison Spitter",          14,       18,     15,     60,     85, AI_ACID,      0                                                                  ,    1,   45,      8,          4,         16,    25,       8,           0,           0,          30, MC_ANIMAL,                                                   IMMUNE_ACID   , IMMUNE_MAGIC  |                                  IMMUNE_ACID   ,         0,        3,  1248 },
	{    128,    716, "Monsters\\Acid\\Acid%c.CL2",       TRUE,        "Monsters\\Acid\\Acid%c%i.WAV",      TRUE,        TRUE,      "Monsters\\Acid\\AcidB.TRN",       { 13,  8, 12,  8, 16, 12 }, { 0, 0, 0, 0, 0, 0 }, "Pit Beast",               18,       22,     21,     80,    110, AI_ACID,      0                                                                  ,    2,   55,      8,          8,         18,    35,       8,           0,           0,          35, MC_ANIMAL,   RESIST_MAGIC |                                  IMMUNE_ACID   , IMMUNE_MAGIC  |               RESIST_LIGHTNING | IMMUNE_ACID   ,         0,        3,  2060 },
	{    128,    716, "Monsters\\Acid\\Acid%c.CL2",       TRUE,        "Monsters\\Acid\\Acid%c%i.WAV",      TRUE,        TRUE,      "Monsters\\Acid\\AcidR.TRN",       { 13,  8, 12,  8, 16, 12 }, { 0, 0, 0, 0, 0, 0 }, "Lava Maw",                22,       27,     25,    100,    150, AI_ACID,      0                                                                  ,    3,   65,      8,         10,         20,    40,       8,           0,           0,          35, MC_ANIMAL,   RESIST_MAGIC | IMMUNE_FIRE  |                    IMMUNE_ACID   , IMMUNE_MAGIC  | IMMUNE_FIRE  |                    IMMUNE_ACID   ,         0,        3,  2940 },
	{    160,   1010, "Monsters\\SKing\\SKing%c.CL2",     TRUE,        "Monsters\\SKing\\SKing%c%i.WAV",    TRUE,        TRUE,      "Monsters\\SkelAxe\\White.TRN",    {  8,  6, 16,  6, 16,  6 }, { 2, 0, 0, 0, 0, 2 }, "Skeleton King",            6,        6,      9,    140,    140, AI_SKELKING,                                   MFLAG_SEARCH | MFLAG_CAN_OPEN_DOOR,    3,   60,      8,          6,         16,     0,       0,           0,           0,          70, MC_UNDEAD,   IMMUNE_MAGIC  | RESIST_FIRE | RESIST_LIGHTNING | IMMUNE_NULL_40, IMMUNE_MAGIC  | IMMUNE_FIRE  | IMMUNE_LIGHTNING  | IMMUNE_NULL_40,    0x8001,        7,   570 },
	{    128,    980, "Monsters\\FatC\\FatC%c.CL2",       FALSE,       "Monsters\\FatC\\FatC%c%i.WAV",      FALSE,       FALSE,     NULL,                              { 10,  8, 12,  6, 16,  0 }, { 1, 0, 0, 0, 0, 0 }, "The Butcher",              0,        0,      1,    320,    320, AI_CLEAVER,   0                                                                  ,    3,   50,      8,          6,         12,     0,       0,           0,           0,          50, MC_DEMON,                   RESIST_FIRE | RESIST_LIGHTNING                , RESIST_MAGIC | IMMUNE_FIRE  | IMMUNE_LIGHTNING                 ,    0x8000,        3,   710 },
	{    128,   1130, "Monsters\\Fat\\Fat%c.CL2",         TRUE,        "Monsters\\Fat\\Fat%c%i.WAV",        FALSE,       FALSE,     NULL,                              {  8, 10, 15,  6, 16, 10 }, { 4, 0, 0, 0, 0, 0 }, "Overlord",                 8,       12,     10,     60,     80, AI_FAT,       0                                                                  ,    0,   55,      8,          6,         12,     0,       0,           0,           0,          55, MC_DEMON,    0                                                            ,                RESIST_FIRE                                   ,         0,        3,   635 },
	{    128,   1130, "Monsters\\Fat\\Fat%c.CL2",         TRUE,        "Monsters\\Fat\\Fat%c%i.WAV",        FALSE,       TRUE,      "Monsters\\Fat\\Blue.TRN",         {  8, 10, 15,  6, 16, 10 }, { 4, 0, 0, 0, 0, 0 }, "Mud Man",                 13,       17,     14,    100,    125, AI_FAT,                                        MFLAG_SEARCH                      ,    1,   60,      8,          8,         16,     0,       0,           0,           0,          60, MC_DEMON,    0                                                            ,                              IMMUNE_LIGHTNING                 ,         0,        3,  1165 },
	{    128,   1130, "Monsters\\Fat\\Fat%c.CL2",         TRUE,        "Monsters\\Fat\\Fat%c%i.WAV",        FALSE,       TRUE,      "Monsters\\Fat\\FatB.TRN",         {  8, 10, 15,  6, 16, 10 }, { 4, 0, 0, 0, 0, 0 }, "Toad Demon",              15,       19,     16,    135,    160, AI_FAT,                                        MFLAG_SEARCH                      ,    2,   70,      8,          8,         16,    40,       0,           8,          20,          65, MC_DEMON,    IMMUNE_MAGIC                                                  , IMMUNE_MAGIC  |               RESIST_LIGHTNING                ,         0,        3,  1380 },
	{    128,   1130, "Monsters\\Fat\\Fat%c.CL2",         TRUE,        "Monsters\\Fat\\Fat%c%i.WAV",        FALSE,       TRUE,      "Monsters\\Fat\\FatF.TRN",         {  8, 10, 15,  6, 16, 10 }, { 4, 0, 0, 0, 0, 0 }, "Flayed One",              19,       23,     20,    160,    200, AI_FAT,                                        MFLAG_SEARCH                      ,    3,   85,      8,         10,         20,     0,       0,           0,           0,          70, MC_DEMON,    RESIST_MAGIC | IMMUNE_FIRE                                    , IMMUNE_MAGIC  | IMMUNE_FIRE                                    ,         0,        3,  2058 },
	{    160,   2420, "Monsters\\Worm\\Worm%c.CL2",       FALSE,       "Monsters\\Fat\\Fat%c%i.WAV",        FALSE,       FALSE,     NULL,                              { 13, 13, 13, 11, 19,  0 }, { 0, 0, 0, 0, 0, 0 }, "Wyrm",                     9,       13,     11,     60,     90, AI_SKELSD,    0                                                                  ,    0,   40,      8,          4,         10,     0,       0,           0,           0,          25, MC_ANIMAL,   RESIST_MAGIC                                                 , RESIST_MAGIC                                                 ,         0,        3,   660 },
	{    160,   2420, "Monsters\\Worm\\Worm%c.CL2",       FALSE,       "Monsters\\Fat\\Fat%c%i.WAV",        FALSE,       FALSE,     NULL,                              { 13, 13, 13, 11, 19,  0 }, { 0, 0, 0, 0, 0, 0 }, "Cave Slug",               11,       15,     13,     75,    110, AI_SKELSD,    0                                                                  ,    1,   50,      8,          6,         13,     0,       0,           0,           0,          30, MC_ANIMAL,   RESIST_MAGIC                                                 , RESIST_MAGIC                                                 ,         0,        3,   994 },
	{    160,   2420, "Monsters\\Worm\\Worm%c.CL2",       FALSE,       "Monsters\\Fat\\Fat%c%i.WAV",        FALSE,       FALSE,     NULL,                              { 13, 13, 13, 11, 19,  0 }, { 0, 0, 0, 0, 0, 0 }, "Devil Wyrm",              13,       17,     15,    100,    140, AI_SKELSD,    0                                                                  ,    2,   55,      8,          8,         16,     0,       0,           0,           0,          30, MC_ANIMAL,   RESIST_MAGIC | RESIST_FIRE                                   , RESIST_MAGIC | RESIST_FIRE                                   ,         0,        3,  1320 },
	{    160,   2420, "Monsters\\Worm\\Worm%c.CL2",       FALSE,       "Monsters\\Fat\\Fat%c%i.WAV",        FALSE,       FALSE,     NULL,                              { 13, 13, 13, 11, 19,  0 }, { 0, 0, 0, 0, 0, 0 }, "Devourer",                15,       19,     17,    125,    200, AI_SKELSD,    0                                                                  ,    3,   60,      8,         10,         20,     0,       0,           0,           0,          35, MC_ANIMAL,   RESIST_MAGIC | RESIST_FIRE |                    IMMUNE_NULL_40, RESIST_MAGIC | RESIST_FIRE |                    IMMUNE_NULL_40,         0,        3,  1827 },
	{    128,   1680, "Monsters\\Magma\\Magma%c.CL2",     TRUE,        "Monsters\\Magma\\Magma%c%i.WAV",    TRUE,        FALSE,     NULL,                              {  8, 10, 14,  7, 18, 18 }, { 2, 0, 0, 0, 1, 0 }, "Magma Demon",             14,       17,     13,     50,     70, AI_MAGMA,                                      MFLAG_SEARCH | MFLAG_CAN_OPEN_DOOR,    0,   45,      4,          2,         10,    50,      13,           0,           0,          45, MC_DEMON,    IMMUNE_MAGIC  | RESIST_FIRE                                   , IMMUNE_MAGIC  | IMMUNE_FIRE                                    ,         0,        7,  1076 },
	{    128,   1680, "Monsters\\Magma\\Magma%c.CL2",     TRUE,        "Monsters\\Magma\\Magma%c%i.WAV",    TRUE,        TRUE,      "Monsters\\Magma\\Yellow.TRN",     {  8, 10, 14,  7, 18, 18 }, { 2, 0, 0, 0, 1, 0 }, "Blood Stone",             15,       19,     14,     55,     75, AI_MAGMA,                                      MFLAG_SEARCH | MFLAG_CAN_OPEN_DOOR,    1,   50,      4,          2,         12,    50,      14,           0,           0,          45, MC_DEMON,    IMMUNE_MAGIC  | IMMUNE_FIRE                                    , IMMUNE_MAGIC  | IMMUNE_FIRE                                    ,         0,        7,  1309 },
	{    128,   1680, "Monsters\\Magma\\Magma%c.CL2",     TRUE,        "Monsters\\Magma\\Magma%c%i.WAV",    TRUE,        TRUE,      "Monsters\\Magma\\Blue.TRN",       {  8, 10, 14,  7, 18, 18 }, { 2, 0, 0, 0, 1, 0 }, "Hell Stone",              16,       20,     16,     60,     80, AI_MAGMA,                                      MFLAG_SEARCH | MFLAG_CAN_OPEN_DOOR,    2,   60,      4,          2,         20,    60,      14,           0,           0,          50, MC_DEMON,    IMMUNE_MAGIC  | IMMUNE_FIRE                                    , IMMUNE_MAGIC  | IMMUNE_FIRE                                    ,         0,        7,  1680 },
	{    128,   1680, "Monsters\\Magma\\Magma%c.CL2",     TRUE,        "Monsters\\Magma\\Magma%c%i.WAV",    TRUE,        TRUE,      "Monsters\\Magma\\Wierd.TRN",      {  8, 10, 14,  7, 18, 18 }, { 2, 0, 0, 0, 1, 0 }, "Lava Lord",               17,       21,     18,     70,     85, AI_MAGMA,                                      MFLAG_SEARCH | MFLAG_CAN_OPEN_DOOR,    3,   75,      4,          4,         24,    60,      14,           0,           0,          60, MC_DEMON,    IMMUNE_MAGIC  | IMMUNE_FIRE                                    , IMMUNE_MAGIC  | IMMUNE_FIRE                                    ,         0,        7,  2124 },
	{    160,   1630, "Monsters\\Rhino\\Rhino%c.CL2",     TRUE,        "Monsters\\Rhino\\Rhino%c%i.WAV",    TRUE,        FALSE,     NULL,                              {  8,  8, 14,  6, 16,  6 }, { 2, 0, 0, 0, 0, 0 }, "Horned Demon",            12,       16,     13,     40,     80, AI_RHINO,                                      MFLAG_SEARCH | MFLAG_CAN_OPEN_DOOR,    0,   60,      7,          2,         16,   100,       0,           5,          32,          40, MC_ANIMAL,   0                                                            ,                RESIST_FIRE                                   ,         0,        7,  1172 },
	{    160,   1630, "Monsters\\Rhino\\Rhino%c.CL2",     TRUE,        "Monsters\\Rhino\\Rhino%c%i.WAV",    TRUE,        TRUE,      "Monsters\\Rhino\\Orange.TRN",     {  8,  8, 14,  6, 16,  6 }, { 2, 0, 0, 0, 0, 0 }, "Mud Runner",              14,       18,     15,     50,     90, AI_RHINO,                                      MFLAG_SEARCH | MFLAG_CAN_OPEN_DOOR,    1,   70,      7,          6,         18,   100,       0,          12,          36,          45, MC_ANIMAL,   0                                                            ,                RESIST_FIRE                                   ,         0,        7,  1404 },
	{    160,   1630, "Monsters\\Rhino\\Rhino%c.CL2",     TRUE,        "Monsters\\Rhino\\Rhino%c%i.WAV",    TRUE,        TRUE,      "Monsters\\Rhino\\Blue.TRN",       {  8,  8, 14,  6, 16,  6 }, { 2, 0, 0, 0, 0, 0 }, "Frost Charger",           16,       20,     17,     60,    100, AI_RHINO,                                      MFLAG_SEARCH | MFLAG_CAN_OPEN_DOOR,    2,   80,      7,          8,         20,   100,       0,          20,          40,          50, MC_ANIMAL,   IMMUNE_MAGIC  |               RESIST_LIGHTNING                , IMMUNE_MAGIC  |               RESIST_LIGHTNING                ,         0,        7,  1720 },
	{    160,   1630, "Monsters\\Rhino\\Rhino%c.CL2",     TRUE,        "Monsters\\Rhino\\Rhino%c%i.WAV",    TRUE,        TRUE,      "Monsters\\Rhino\\RhinoB.TRN",     {  8,  8, 14,  6, 16,  6 }, { 2, 0, 0, 0, 0, 0 }, "Obsidian Lord",           18,       22,     19,     70,    110, AI_RHINO,                                      MFLAG_SEARCH | MFLAG_CAN_OPEN_DOOR,    3,   90,      7,         10,         22,   100,       0,          20,          50,          55, MC_ANIMAL,   IMMUNE_MAGIC  |               RESIST_LIGHTNING                , IMMUNE_MAGIC  | IMMUNE_FIRE  | IMMUNE_LIGHTNING                 ,         0,        7,  1809 },
	{    128,   1740, "Monsters\\Demskel\\Demskl%c.CL2",  TRUE,        "Monsters\\Thin\\Thin%c%i.WAV",      TRUE,        FALSE,     "Monsters\\Thin\\Thinv3.TRN",      { 10,  8, 20,  6, 24, 16 }, { 3, 0, 0, 0, 0, 0 }, "oldboned",                46,       47,     12,     70,     70, AI_STORM,     0                                                                  ,    0,   60,      8,          6,         14,    12,       0,           0,           0,          50, MC_DEMON,    IMMUNE_MAGIC  |                                  IMMUNE_NULL_40, IMMUNE_MAGIC  |                                  IMMUNE_NULL_40,         0,        7,  1344 },
	{    160,   1740, "Monsters\\Thin\\Thin%c.CL2",       TRUE,        "Monsters\\Thin\\Thin%c%i.WAV",      TRUE,        TRUE,      "Monsters\\Thin\\Thinv3.TRN",      {  8,  8, 18,  4, 17, 14 }, { 3, 0, 0, 0, 0, 0 }, "Red Death",               14,       18,     16,     96,     96, AI_STORM,     0                                                                  ,    1,   75,      5,         10,         20,     0,       0,           0,           0,          60, MC_DEMON,    IMMUNE_MAGIC  | IMMUNE_FIRE                                    , IMMUNE_MAGIC  | IMMUNE_FIRE                                    ,         0,        7,  2168 },
	{    160,   1740, "Monsters\\Thin\\Thin%c.CL2",       TRUE,        "Monsters\\Thin\\Thin%c%i.WAV",      TRUE,        TRUE,      "Monsters\\Thin\\Thinv3.TRN",      {  8,  8, 18,  4, 17, 14 }, { 3, 0, 0, 0, 0, 0 }, "Litch Demon",             16,       20,     18,    110,    110, AI_STORM,     0                                                                  ,    2,   80,      5,         10,         24,     0,       0,           0,           0,          45, MC_DEMON,    IMMUNE_MAGIC  |               IMMUNE_LIGHTNING  | IMMUNE_NULL_40, IMMUNE_MAGIC  |               IMMUNE_LIGHTNING  | IMMUNE_NULL_40,         0,        7,  2736 },
	{    160,   1740, "Monsters\\Thin\\Thin%c.CL2",       TRUE,        "Monsters\\Thin\\Thin%c%i.WAV",      TRUE,        TRUE,      "Monsters\\Thin\\Thinv3.TRN",      {  8,  8, 18,  4, 17, 14 }, { 3, 0, 0, 0, 0, 0 }, "Undead Balrog",           20,       24,     22,    130,    130, AI_STORM,     0                                                                  ,    3,   85,      5,         12,         30,     0,       0,           0,           0,          65, MC_DEMON,    IMMUNE_MAGIC  | RESIST_FIRE | RESIST_LIGHTNING | IMMUNE_NULL_40, IMMUNE_MAGIC  | RESIST_FIRE | RESIST_LIGHTNING | IMMUNE_NULL_40,         0,        7,  3575 },
	{    128,   1460, "Monsters\\Fireman\\FireM%c.CL2",   TRUE,        "Monsters\\Acid\\Acid%c%i.WAV",      FALSE,       FALSE,     NULL,                              { 14, 19, 20,  8, 14, 23 }, { 0, 0, 0, 0, 0, 0 }, "Incinerator",             40,       43,     16,     30,     45, AI_FIREMAN,   0                                                                  ,    0,   75,      8,          8,         16,     0,       0,           0,           0,          25, MC_DEMON,    IMMUNE_MAGIC  | IMMUNE_FIRE                                    , IMMUNE_MAGIC  | IMMUNE_FIRE                                    ,         0,        3,  1888 },
	{    128,   1460, "Monsters\\Fireman\\FireM%c.CL2",   TRUE,        "Monsters\\Acid\\Acid%c%i.WAV",      FALSE,       FALSE,     NULL,                              { 14, 19, 20,  8, 14, 23 }, { 0, 0, 0, 0, 0, 0 }, "Flame Lord",              42,       45,     18,     40,     55, AI_FIREMAN,   0                                                                  ,    1,   75,      8,         10,         20,     0,       0,           0,           0,          25, MC_DEMON,    IMMUNE_MAGIC  | IMMUNE_FIRE                                    , IMMUNE_MAGIC  | IMMUNE_FIRE                                    ,         0,        3,  2250 },
	{    128,   1460, "Monsters\\Fireman\\FireM%c.CL2",   TRUE,        "Monsters\\Acid\\Acid%c%i.WAV",      FALSE,       FALSE,     NULL,                              { 14, 19, 20,  8, 14, 23 }, { 0, 0, 0, 0, 0, 0 }, "Doom Fire",               44,       47,     20,     50,     65, AI_FIREMAN,   0                                                                  ,    2,   80,      8,         12,         24,     0,       0,           0,           0,          30, MC_DEMON,    IMMUNE_MAGIC  | IMMUNE_FIRE  | RESIST_LIGHTNING                , IMMUNE_MAGIC  | IMMUNE_FIRE  | RESIST_LIGHTNING                ,         0,        3,  2740 },
	{    128,   1460, "Monsters\\Fireman\\FireM%c.CL2",   TRUE,        "Monsters\\Acid\\Acid%c%i.WAV",      FALSE,       FALSE,     NULL,                              { 14, 19, 20,  8, 14, 23 }, { 0, 0, 0, 0, 0, 0 }, "Hell Burner",             46,       47,     22,     60,     80, AI_FIREMAN,   0                                                                  ,    3,   85,      8,         15,         30,     0,       0,           0,           0,          30, MC_DEMON,    IMMUNE_MAGIC  | IMMUNE_FIRE  | RESIST_LIGHTNING                , IMMUNE_MAGIC  | IMMUNE_FIRE  | RESIST_LIGHTNING                ,         0,        3,  3355 },
	{    160,   1740, "Monsters\\Thin\\Thin%c.CL2",       TRUE,        "Monsters\\Thin\\Thin%c%i.WAV",      TRUE,        TRUE,      "Monsters\\Thin\\Thinv3.TRN",      {  8,  8, 18,  4, 17, 14 }, { 3, 0, 0, 0, 0, 0 }, "Red Storm",               17,       21,     18,     55,    110, AI_STORM,                                      MFLAG_SEARCH | MFLAG_CAN_OPEN_DOOR,    0,   80,      5,          8,         18,    75,       8,           4,          16,          30, MC_DEMON,    IMMUNE_MAGIC  |               RESIST_LIGHTNING                , IMMUNE_MAGIC  |               IMMUNE_LIGHTNING                 ,         0,        7,  2160 },
	{    160,   1740, "Monsters\\Thin\\Thin%c.CL2",       TRUE,        "Monsters\\Thin\\Thin%c%i.WAV",      TRUE,        FALSE,     NULL,                              {  8,  8, 18,  4, 17, 14 }, { 3, 0, 0, 0, 0, 0 }, "Storm Rider",             19,       23,     20,     60,    120, AI_STORM,                                      MFLAG_SEARCH | MFLAG_CAN_OPEN_DOOR,    1,   80,      5,          8,         18,    80,       8,           4,          16,          30, MC_DEMON,    RESIST_MAGIC |               IMMUNE_LIGHTNING                 , IMMUNE_MAGIC  |               IMMUNE_LIGHTNING                 ,         0,        7,  2391 },
	{    160,   1740, "Monsters\\Thin\\Thin%c.CL2",       TRUE,        "Monsters\\Thin\\Thin%c%i.WAV",      TRUE,        TRUE,      "Monsters\\Thin\\Thinv2.TRN",      {  8,  8, 18,  4, 17, 14 }, { 3, 0, 0, 0, 0, 0 }, "Storm Lord",              21,       25,     22,     75,    135, AI_STORM,                                      MFLAG_SEARCH | MFLAG_CAN_OPEN_DOOR,    2,   85,      5,         12,         24,    75,       8,           4,          16,          35, MC_DEMON,    RESIST_MAGIC |               IMMUNE_LIGHTNING                 , IMMUNE_MAGIC  |               IMMUNE_LIGHTNING                 ,         0,        7,  2775 },
	{    160,   1740, "Monsters\\Thin\\Thin%c.CL2",       TRUE,        "Monsters\\Thin\\Thin%c%i.WAV",      TRUE,        TRUE,      "Monsters\\Thin\\Thinv1.TRN",      {  8,  8, 18,  4, 17, 14 }, { 3, 0, 0, 0, 0, 0 }, "Maelstorm",               23,       27,     24,     90,    150, AI_STORM,                                      MFLAG_SEARCH | MFLAG_CAN_OPEN_DOOR,    3,   90,      5,         12,         28,    75,       8,           4,          16,          40, MC_DEMON,    RESIST_MAGIC |               IMMUNE_LIGHTNING  | IMMUNE_NULL_40, IMMUNE_MAGIC  |               IMMUNE_LIGHTNING  | IMMUNE_NULL_40,         0,        7,  3177 },
	{    128,    800, "Monsters\\BigFall\\Fallg%c.CL2",   TRUE,        "Monsters\\newsfx\\KBrute%c%i.WAV",  FALSE,       FALSE,     NULL,                              { 10,  8, 11,  8, 17,  0 }, { 0, 0, 0, 0, 2, 2 }, "Devil Kin Brute",         40,       43,     27,    120,    160, AI_SKELSD,                                     MFLAG_SEARCH | MFLAG_CAN_OPEN_DOOR,    3,  100,      6,         18,         24,     0,       0,           0,           0,          70, MC_ANIMAL,                  RESIST_FIRE | RESIST_LIGHTNING                , RESIST_MAGIC | RESIST_FIRE | RESIST_LIGHTNING                ,         0,        3,  2400 },
	{    160,   1650, "Monsters\\Gargoyle\\Gargo%c.CL2",  TRUE,        "Monsters\\Gargoyle\\Gargo%c%i.WAV", FALSE,       FALSE,     NULL,                              { 14, 14, 14, 10, 18, 14 }, { 0, 0, 0, 0, 0, 2 }, "Winged-Demon",             8,       12,      9,     45,     60, AI_GARG,                                                      MFLAG_CAN_OPEN_DOOR,    0,   50,      7,         10,         16,     0,       0,           0,           0,          45, MC_DEMON,    IMMUNE_MAGIC  | RESIST_FIRE |                    IMMUNE_NULL_40, IMMUNE_MAGIC  | IMMUNE_FIRE  |                    IMMUNE_NULL_40,         0,        6,   662 },
	{    160,   1650, "Monsters\\Gargoyle\\Gargo%c.CL2",  TRUE,        "Monsters\\Gargoyle\\Gargo%c%i.WAV", FALSE,       TRUE,      "Monsters\\Gargoyle\\GarE.TRN",    { 14, 14, 14, 10, 18, 14 }, { 0, 0, 0, 0, 0, 2 }, "Gargoyle",                12,       16,     13,     60,     90, AI_GARG,                                                      MFLAG_CAN_OPEN_DOOR,    1,   65,      7,         10,         16,     0,       0,           0,           0,          45, MC_DEMON,    IMMUNE_MAGIC  |               RESIST_LIGHTNING | IMMUNE_NULL_40, IMMUNE_MAGIC  |               IMMUNE_LIGHTNING  | IMMUNE_NULL_40,         0,        6,  1205 },
	{    160,   1650, "Monsters\\Gargoyle\\Gargo%c.CL2",  TRUE,        "Monsters\\Gargoyle\\Gargo%c%i.WAV", FALSE,       TRUE,      "Monsters\\Gargoyle\\GargBr.TRN",  { 14, 14, 14, 10, 18, 14 }, { 0, 0, 0, 0, 0, 0 }, "Blood Claw",              16,       20,     19,     75,    125, AI_GARG,                                                      MFLAG_CAN_OPEN_DOOR,    2,   80,      7,         14,         22,     0,       0,           0,           0,          50, MC_DEMON,    IMMUNE_MAGIC  | IMMUNE_FIRE  |                    IMMUNE_NULL_40, IMMUNE_MAGIC  | IMMUNE_FIRE  | RESIST_LIGHTNING | IMMUNE_NULL_40,         0,        6,  1873 },
	{    160,   1650, "Monsters\\Gargoyle\\Gargo%c.CL2",  TRUE,        "Monsters\\Gargoyle\\Gargo%c%i.WAV", FALSE,       TRUE,      "Monsters\\Gargoyle\\GargB.TRN",   { 14, 14, 14, 10, 18, 14 }, { 0, 0, 0, 0, 0, 0 }, "Death Wing",              18,       22,     23,     90,    150, AI_GARG,                                                      MFLAG_CAN_OPEN_DOOR,    3,   95,      7,         16,         28,     0,       0,           0,           0,          60, MC_DEMON,    IMMUNE_MAGIC  |               IMMUNE_LIGHTNING  | IMMUNE_NULL_40, IMMUNE_MAGIC  | RESIST_FIRE | IMMUNE_LIGHTNING  | IMMUNE_NULL_40,         0,        6,  2278 },
	{    160,   2220, "Monsters\\Mega\\Mega%c.CL2",       TRUE,        "Monsters\\Mega\\Mega%c%i.WAV",      TRUE,        FALSE,     NULL,                              {  6,  7, 14,  1, 24,  5 }, { 3, 0, 0, 0, 2, 0 }, "Slayer",                  19,       23,     20,    120,    140, AI_MEGA,                                       MFLAG_SEARCH | MFLAG_CAN_OPEN_DOOR,    0,  100,      8,         12,         20,     0,       3,           0,           0,          60, MC_DEMON,    RESIST_MAGIC | IMMUNE_FIRE                                    , RESIST_MAGIC | IMMUNE_FIRE                                    ,         0,        7,  2300 },
	{    160,   2220, "Monsters\\Mega\\Mega%c.CL2",       TRUE,        "Monsters\\Mega\\Mega%c%i.WAV",      TRUE,        TRUE,      "Monsters\\Mega\\Guard.TRN",       {  6,  7, 14,  1, 24,  5 }, { 3, 0, 0, 0, 2, 0 }, "Guardian",                21,       25,     22,    140,    160, AI_MEGA,                                       MFLAG_SEARCH | MFLAG_CAN_OPEN_DOOR,    1,  110,      8,         14,         22,     0,       3,           0,           0,          65, MC_DEMON,    RESIST_MAGIC | IMMUNE_FIRE                                    , RESIST_MAGIC | IMMUNE_FIRE                                    ,         0,        7,  2714 },
	{    160,   2220, "Monsters\\Mega\\Mega%c.CL2",       TRUE,        "Monsters\\Mega\\Mega%c%i.WAV",      TRUE,        TRUE,      "Monsters\\Mega\\Vtexl.TRN",       {  6,  7, 14,  1, 24,  5 }, { 3, 0, 0, 0, 2, 0 }, "Vortex Lord",             23,       26,     24,    160,    180, AI_MEGA,                                       MFLAG_SEARCH | MFLAG_CAN_OPEN_DOOR,    2,  120,      8,         18,         24,     0,       3,           0,           0,          70, MC_DEMON,    RESIST_MAGIC | IMMUNE_FIRE  |                    IMMUNE_NULL_40, RESIST_MAGIC | IMMUNE_FIRE  | RESIST_LIGHTNING | IMMUNE_NULL_40,         0,        7,  3252 },
	{    160,   2220, "Monsters\\Mega\\Mega%c.CL2",       TRUE,        "Monsters\\Mega\\Mega%c%i.WAV",      TRUE,        TRUE,      "Monsters\\Mega\\Balr.TRN",        {  6,  7, 14,  1, 24,  5 }, { 3, 0, 0, 0, 2, 0 }, "Balrog",                  25,       29,     26,    180,    200, AI_MEGA,                                       MFLAG_SEARCH | MFLAG_CAN_OPEN_DOOR,    3,  130,      8,         22,         30,     0,       3,           0,           0,          75, MC_DEMON,    RESIST_MAGIC | IMMUNE_FIRE  |                    IMMUNE_NULL_40, RESIST_MAGIC | IMMUNE_FIRE  | RESIST_LIGHTNING | IMMUNE_NULL_40,         0,        7,  3643 },
	{    160,   1270, "Monsters\\Snake\\Snake%c.CL2",     FALSE,       "Monsters\\Snake\\Snake%c%i.WAV",    FALSE,       FALSE,     NULL,                              { 12, 11, 13,  5, 18,  0 }, { 2, 0, 0, 0, 1, 0 }, "Cave Viper",              20,       24,     21,    100,    150, AI_SNAKE,                                      MFLAG_SEARCH                      ,    0,   90,      8,          8,         20,     0,       0,           0,           0,          60, MC_DEMON,    IMMUNE_MAGIC                                                  , IMMUNE_MAGIC                                                  ,         0,        7,  2725 },
	{    160,   1270, "Monsters\\Snake\\Snake%c.CL2",     FALSE,       "Monsters\\Snake\\Snake%c%i.WAV",    FALSE,       TRUE,      "Monsters\\Snake\\SnakR.TRN",      { 12, 11, 13,  5, 18,  0 }, { 2, 0, 0, 0, 1, 0 }, "Fire Drake",              22,       26,     23,    120,    170, AI_SNAKE,                                      MFLAG_SEARCH                      ,    1,  105,      8,         12,         24,     0,       0,           0,           0,          65, MC_DEMON,    IMMUNE_MAGIC  | RESIST_FIRE                                   , IMMUNE_MAGIC  | IMMUNE_FIRE                                    ,         0,        7,  3139 },
	{    160,   1270, "Monsters\\Snake\\Snake%c.CL2",     FALSE,       "Monsters\\Snake\\Snake%c%i.WAV",    FALSE,       TRUE,      "Monsters\\Snake\\Snakg.TRN",      { 12, 11, 13,  5, 18,  0 }, { 2, 0, 0, 0, 1, 0 }, "Gold Viper",              24,       27,     25,    140,    180, AI_SNAKE,                                      MFLAG_SEARCH                      ,    2,  120,      8,         15,         26,     0,       0,           0,           0,          70, MC_DEMON,    IMMUNE_MAGIC  |               RESIST_LIGHTNING                , IMMUNE_MAGIC  |               RESIST_LIGHTNING                ,         0,        7,  3540 },
	{    160,   1270, "Monsters\\Snake\\Snake%c.CL2",     FALSE,       "Monsters\\Snake\\Snake%c%i.WAV",    FALSE,       TRUE,      "Monsters\\Snake\\Snakb.TRN",      { 12, 11, 13,  5, 18,  0 }, { 2, 0, 0, 0, 1, 0 }, "Azure Drake",             28,       30,     27,    160,    200, AI_SNAKE,                                      MFLAG_SEARCH                      ,    3,  130,      8,         18,         30,     0,       0,           0,           0,          75, MC_DEMON,                   RESIST_FIRE | RESIST_LIGHTNING                , IMMUNE_MAGIC  | RESIST_FIRE | IMMUNE_LIGHTNING                 ,         0,        7,  3791 },
	{    160,   2120, "Monsters\\Black\\Black%c.CL2",     FALSE,       "Monsters\\Black\\Black%c%i.WAV",    FALSE,       FALSE,     NULL,                              {  8,  8, 16,  4, 24,  0 }, { 2, 0, 0, 0, 0, 0 }, "Black Knight",            23,       27,     24,    150,    150, AI_SKELSD,                                     MFLAG_SEARCH                      ,    0,  110,      8,         15,         20,     0,       0,           0,           0,          75, MC_DEMON,    RESIST_MAGIC |               RESIST_LIGHTNING | IMMUNE_NULL_40, RESIST_MAGIC |               IMMUNE_LIGHTNING  | IMMUNE_NULL_40,         0,        7,  3360 },
	{    160,   2120, "Monsters\\Black\\Black%c.CL2",     FALSE,       "Monsters\\Black\\Black%c%i.WAV",    FALSE,       TRUE,      "Monsters\\Black\\BlkKntRT.TRN",   {  8,  8, 16,  4, 24,  0 }, { 2, 0, 0, 0, 0, 0 }, "Doom Guard",              25,       29,     26,    165,    165, AI_SKELSD,                                     MFLAG_SEARCH                      ,    0,  130,      8,         18,         25,     0,       0,           0,           0,          75, MC_DEMON,    RESIST_MAGIC | RESIST_FIRE |                    IMMUNE_NULL_40, RESIST_MAGIC | IMMUNE_FIRE  |                    IMMUNE_NULL_40,         0,        7,  3650 },
	{    160,   2120, "Monsters\\Black\\Black%c.CL2",     FALSE,       "Monsters\\Black\\Black%c%i.WAV",    FALSE,       TRUE,      "Monsters\\Black\\BlkKntBT.TRN",   {  8,  8, 16,  4, 24,  0 }, { 2, 0, 0, 0, 0, 0 }, "Steel Lord",              27,       30,     28,    180,    180, AI_SKELSD,                                     MFLAG_SEARCH                      ,    1,  120,      8,         20,         30,     0,       0,           0,           0,          80, MC_DEMON,    RESIST_MAGIC | IMMUNE_FIRE  | RESIST_LIGHTNING | IMMUNE_NULL_40, IMMUNE_MAGIC  | IMMUNE_FIRE  | RESIST_LIGHTNING | IMMUNE_NULL_40,         0,        7,  4252 },
	{    160,   2120, "Monsters\\Black\\Black%c.CL2",     FALSE,       "Monsters\\Black\\Black%c%i.WAV",    FALSE,       TRUE,      "Monsters\\Black\\BlkKntBe.TRN",   {  8,  8, 16,  4, 24,  0 }, { 2, 0, 0, 0, 0, 0 }, "Blood Knight",            24,       26,     30,    200,    200, AI_SKELSD,                                     MFLAG_SEARCH                      ,    1,  130,      8,         25,         35,     0,       0,           0,           0,          85, MC_DEMON,    IMMUNE_MAGIC  | RESIST_FIRE | IMMUNE_LIGHTNING  | IMMUNE_NULL_40, IMMUNE_MAGIC  | RESIST_FIRE | IMMUNE_LIGHTNING  | IMMUNE_NULL_40,         0,        7,  5130 },
	{     96,    484, "Monsters\\Unrav\\Unrav%c.CL2",     FALSE,       "Monsters\\newsfx\\Shred%c%i.WAV",   FALSE,       FALSE,     NULL,                              { 10, 10, 12,  5, 16,  0 }, { 0, 0, 0, 0, 0, 0 }, "The Shredded",            32,       35,     23,     70,     90, AI_SKELSD,    0                                                                  ,    0,   75,      7,          4,         12,     0,       0,           0,           0,          65, MC_UNDEAD,                  RESIST_FIRE | RESIST_LIGHTNING | IMMUNE_NULL_40,                RESIST_FIRE | RESIST_LIGHTNING | IMMUNE_NULL_40,         0,        3,   900 },
	{     96,    484, "Monsters\\Unrav\\Unrav%c.CL2",     FALSE,       "Monsters\\Acid\\Acid%c%i.WAV",      FALSE,       FALSE,     NULL,                              { 10, 10, 12,  5, 16,  0 }, { 0, 0, 0, 0, 0, 0 }, "Hollow One",              34,       37,     27,    135,    240, AI_SKELSD,    0                                                                  ,    1,   75,      7,         12,         24,     0,       0,           0,           0,          75, MC_UNDEAD,   IMMUNE_MAGIC  | IMMUNE_FIRE  | RESIST_LIGHTNING | IMMUNE_NULL_40, IMMUNE_MAGIC  | IMMUNE_FIRE  | RESIST_LIGHTNING | IMMUNE_NULL_40,         0,        3,  4374 },
	{     96,    484, "Monsters\\Unrav\\Unrav%c.CL2",     FALSE,       "Monsters\\Acid\\Acid%c%i.WAV",      FALSE,       FALSE,     NULL,                              { 10, 10, 12,  5, 16,  0 }, { 0, 0, 0, 0, 0, 0 }, "Pain Master",             36,       39,     29,    110,    200, AI_SKELSD,    0                                                                  ,    2,   80,      7,         16,         30,     0,       0,           0,           0,          80, MC_UNDEAD,   IMMUNE_MAGIC  | IMMUNE_FIRE  | RESIST_LIGHTNING | IMMUNE_NULL_40, IMMUNE_MAGIC  | IMMUNE_FIRE  | RESIST_LIGHTNING | IMMUNE_NULL_40,         0,        3,  5147 },
	{     96,    484, "Monsters\\Unrav\\Unrav%c.CL2",     FALSE,       "Monsters\\Acid\\Acid%c%i.WAV",      FALSE,       FALSE,     NULL,                              { 10, 10, 12,  5, 16,  0 }, { 0, 0, 0, 0, 0, 0 }, "Reality Weaver",          38,       39,     30,    135,    240, AI_SKELSD,    0                                                                  ,    3,   85,      7,         20,         35,     0,       0,           0,           0,          85, MC_UNDEAD,   RESIST_MAGIC | IMMUNE_FIRE  | IMMUNE_LIGHTNING  | IMMUNE_NULL_40, RESIST_MAGIC | IMMUNE_FIRE  | IMMUNE_LIGHTNING  | IMMUNE_NULL_40,         0,        3,  5925 },
	{    128,    980, "Monsters\\Succ\\Scbs%c.CL2",       FALSE,       "Monsters\\Succ\\Scbs%c%i.WAV",      FALSE,       FALSE,     NULL,                              { 14,  8, 16,  7, 24,  0 }, { 0, 0, 0, 0, 0, 0 }, "Succubus",                22,       26,     24,    120,    150, AI_SUCC,                                                      MFLAG_CAN_OPEN_DOOR,    0,  100,     10,          1,         20,     0,       0,           0,           0,          60, MC_DEMON,    RESIST_MAGIC                                                 , IMMUNE_MAGIC  | RESIST_FIRE                                   ,         0,        3,  3696 },
	{    128,    980, "Monsters\\Succ\\Scbs%c.CL2",       FALSE,       "Monsters\\Succ\\Scbs%c%i.WAV",      FALSE,       TRUE,      "Monsters\\Succ\\Succb.TRN",       { 14,  8, 16,  7, 24,  0 }, { 0, 0, 0, 0, 0, 0 }, "Snow Witch",              25,       28,     26,    135,    175, AI_SUCC,                                                      MFLAG_CAN_OPEN_DOOR,    1,  110,     10,          1,         24,     0,       0,           0,           0,          65, MC_DEMON,                                 RESIST_LIGHTNING | IMMUNE_NULL_40, IMMUNE_MAGIC  |               RESIST_LIGHTNING | IMMUNE_NULL_40,         0,        3,  4084 },
	{    128,    980, "Monsters\\Succ\\Scbs%c.CL2",       FALSE,       "Monsters\\Succ\\Scbs%c%i.WAV",      FALSE,       TRUE,      "Monsters\\Succ\\Succrw.TRN",      { 14,  8, 16,  7, 24,  0 }, { 0, 0, 0, 0, 0, 0 }, "Hell Spawn",              27,       30,     28,    150,    200, AI_SUCC,                                       MFLAG_SEARCH | MFLAG_CAN_OPEN_DOOR,    2,  115,     10,          1,         30,     0,       0,           0,           0,          75, MC_DEMON,    RESIST_MAGIC |               IMMUNE_LIGHTNING                 , IMMUNE_MAGIC  | IMMUNE_FIRE  | RESIST_LIGHTNING                ,         0,        3,  4480 },
	{    128,    980, "Monsters\\Succ\\Scbs%c.CL2",       FALSE,       "Monsters\\Succ\\Scbs%c%i.WAV",      FALSE,       TRUE,      "Monsters\\Succ\\Succbw.TRN",      { 14,  8, 16,  7, 24,  0 }, { 0, 0, 0, 0, 0, 0 }, "Soul Burner",             28,       30,     30,    140,    225, AI_SUCC,                                       MFLAG_SEARCH | MFLAG_CAN_OPEN_DOOR,    3,  120,     10,          1,         35,     0,       0,           0,           0,          85, MC_DEMON,    RESIST_MAGIC | IMMUNE_FIRE  | RESIST_LIGHTNING                , IMMUNE_MAGIC  | IMMUNE_FIRE  | IMMUNE_LIGHTNING                 ,         0,        3,  4644 },
	{    128,   2000, "Monsters\\Mage\\Mage%c.CL2",       TRUE,        "Monsters\\Mage\\Mage%c%i.WAV",      FALSE,       FALSE,     NULL,                              { 12,  1, 20,  8, 28, 20 }, { 0, 0, 0, 0, 0, 0 }, "Counselor",               24,       26,     25,     70,     70, AI_COUNSLR,                                                   MFLAG_CAN_OPEN_DOOR,    0,   90,      8,          8,         20,     0,       0,           0,           0,           0, MC_DEMON,    RESIST_MAGIC | RESIST_FIRE | RESIST_LIGHTNING                , RESIST_MAGIC | RESIST_FIRE | RESIST_LIGHTNING                ,         0,        7,  4070 },
	{    128,   2000, "Monsters\\Mage\\Mage%c.CL2",       TRUE,        "Monsters\\Mage\\Mage%c%i.WAV",      FALSE,       TRUE,      "Monsters\\Mage\\Cnselg.TRN",      { 12,  1, 20,  8, 28, 20 }, { 0, 0, 0, 0, 0, 0 }, "Magistrate",              26,       28,     27,     85,     85, AI_COUNSLR,                                                   MFLAG_CAN_OPEN_DOOR,    1,  100,      8,         10,         24,     0,       0,           0,           0,           0, MC_DEMON,    RESIST_MAGIC | IMMUNE_FIRE  | RESIST_LIGHTNING | IMMUNE_NULL_40, IMMUNE_MAGIC  | IMMUNE_FIRE  | RESIST_LIGHTNING | IMMUNE_NULL_40,         0,        7,  4478 },
	{    128,   2000, "Monsters\\Mage\\Mage%c.CL2",       TRUE,        "Monsters\\Mage\\Mage%c%i.WAV",      FALSE,       TRUE,      "Monsters\\Mage\\Cnselgd.TRN",     { 12,  1, 20,  8, 28, 20 }, { 0, 0, 0, 0, 0, 0 }, "Cabalist",                28,       30,     29,    120,    120, AI_COUNSLR,                                                   MFLAG_CAN_OPEN_DOOR,    2,  110,      8,         14,         30,     0,       0,           0,           0,           0, MC_DEMON,    RESIST_MAGIC | RESIST_FIRE | IMMUNE_LIGHTNING  | IMMUNE_NULL_40, IMMUNE_MAGIC  | RESIST_FIRE | IMMUNE_LIGHTNING  | IMMUNE_NULL_40,         0,        7,  4929 },
	{    128,   2000, "Monsters\\Mage\\Mage%c.CL2",       TRUE,        "Monsters\\Mage\\Mage%c%i.WAV",      FALSE,       TRUE,      "Monsters\\Mage\\Cnselbk.TRN",     { 12,  1, 20,  8, 28, 20 }, { 0, 0, 0, 0, 0, 0 }, "Advocate",                30,       30,     30,    145,    145, AI_COUNSLR,                                                   MFLAG_CAN_OPEN_DOOR,    3,  120,      8,         15,         25,     0,       0,           0,           0,           0, MC_DEMON,    IMMUNE_MAGIC  | RESIST_FIRE | IMMUNE_LIGHTNING  | IMMUNE_NULL_40, IMMUNE_MAGIC  | IMMUNE_FIRE  | IMMUNE_LIGHTNING  | IMMUNE_NULL_40,         0,        7,  4968 },
	{     96,    386, "Monsters\\Golem\\Golem%c.CL2",     TRUE,        "Monsters\\Golem\\Golm%c%i.WAV",     FALSE,       FALSE,     NULL,                              {  0, 16, 12,  0, 12, 20 }, { 0, 0, 0, 0, 0, 0 }, "Golem",                    0,        0,     12,      1,      1, AI_GOLUM,                                                     MFLAG_CAN_OPEN_DOOR,    0,    0,      7,          1,          1,     0,       0,           0,           0,           1, MC_DEMON,    0                                                            , 0                                                            ,         0,        0,     0 },
	{    160,   2000, "Monsters\\Diablo\\Diablo%c.CL2",   TRUE,        "Monsters\\Diablo\\Diablo%c%i.WAV",  TRUE,        FALSE,     NULL,                              { 16,  6, 16,  6, 16, 16 }, { 0, 0, 0, 0, 0, 0 }, "The Dark Lord",           50,       50,     45,   3333,   3333, AI_DIABLO,                   MFLAG_KNOCKBACK | MFLAG_SEARCH | MFLAG_CAN_OPEN_DOOR,    3,  220,      4,         30,         60,     0,      11,           0,           0,          90, MC_DEMON,    IMMUNE_MAGIC  | RESIST_FIRE | RESIST_LIGHTNING | IMMUNE_NULL_40, IMMUNE_MAGIC  | RESIST_FIRE | RESIST_LIGHTNING | IMMUNE_NULL_40,         0,        7,  31666 },
	{    128,   1060, "Monsters\\DarkMage\\Dmage%c.CL2",  TRUE,        "Monsters\\DarkMage\\Dmag%c%i.WAV",  FALSE,       FALSE,     NULL,                              {  6,  1, 21,  6, 23, 18 }, { 0, 0, 0, 0, 0, 0 }, "The Arch-Litch Malignus", 40,       41,     30,    160,    160, AI_COUNSLR,                                                   MFLAG_CAN_OPEN_DOOR,    3,  120,      8,         20,         40,     0,       0,           0,           0,          70, MC_DEMON,    RESIST_MAGIC | RESIST_FIRE | RESIST_LIGHTNING | IMMUNE_NULL_40, IMMUNE_MAGIC  | IMMUNE_FIRE  | IMMUNE_LIGHTNING  | IMMUNE_NULL_40,         0,        7,  4968 },
	{    188,    800, "Monsters\\Fork\\Fork%c.CL2",       FALSE,       "Monsters\\newsfx\\HBoar%c%i.WAV",   FALSE,       FALSE,     NULL,                              { 10, 10, 15,  6, 16,  0 }, { 2, 0, 0, 0, 0, 0 }, "Hellboar",                32,       35,     23,     80,    100, AI_SKELSD,                   MFLAG_KNOCKBACK | MFLAG_SEARCH                      ,    2,   70,      7,         16,         24,     0,       0,           0,           0,          60, MC_DEMON,    0                                                            ,                RESIST_FIRE | RESIST_LIGHTNING                ,         0,        3,   750 },
	{     64,    305, "Monsters\\Scorp\\Scorp%c.CL2",     FALSE,       "Monsters\\newsfx\\Stingr%c%i.WAV",  FALSE,       FALSE,     NULL,                              { 10, 10, 12,  6, 15,  0 }, { 2, 0, 0, 0, 0, 0 }, "Stinger",                 32,       35,     22,     30,     40, AI_SKELSD,    0                                                                  ,    3,   85,      8,          1,         20,     0,       0,           0,           0,          50, MC_ANIMAL,   0                                                            ,                              RESIST_LIGHTNING                ,         0,        1,   500 },
	{    156,    800, "Monsters\\Eye\\Eye%c.CL2",         FALSE,       "Monsters\\newsfx\\psyco%c%i.WAV",   FALSE,       FALSE,     NULL,                              { 12, 13, 13,  7, 21,  0 }, { 2, 0, 0, 0, 0, 0 }, "Psychorb",                32,       35,     22,     20,     30, AI_PSYCHORB,  0                                                                  ,    3,   80,      8,         10,         10,     0,       0,           0,           0,          40, MC_ANIMAL,   0                                                            ,                RESIST_FIRE                                   ,         0,        6,   450 },
	{    148,    800, "Monsters\\Spider\\Spider%c.CL2",   FALSE,       "Monsters\\newsfx\\SLord%c%i.WAV",   FALSE,       FALSE,     NULL,                              { 12, 10, 15,  6, 20,  0 }, { 2, 0, 0, 0, 0, 0 }, "Arachnon",                32,       35,     22,     60,     80, AI_SKELSD,                                     MFLAG_SEARCH                      ,    3,   50,      8,          5,         15,     0,       0,           0,           0,          50, MC_ANIMAL,   0                                                            ,                              RESIST_LIGHTNING                ,         0,        7,   500 },
	{    128,    800, "Monsters\\TSneak\\TSneak%c.CL2",   FALSE,       "Monsters\\newsfx\\FTwin%c%i.WAV",   FALSE,       FALSE,     NULL,                              { 13, 13, 15, 11, 16,  0 }, { 2, 0, 0, 0, 0, 0 }, "Felltwin",                32,       35,     22,     50,     70, AI_SKELSD,                                     MFLAG_SEARCH | MFLAG_CAN_OPEN_DOOR,    3,   70,      8,         10,         18,     0,       0,           0,           0,          50, MC_DEMON,                                                    IMMUNE_NULL_40,                RESIST_FIRE | RESIST_LIGHTNING | IMMUNE_NULL_40,         0,        3,   600 },
	{    164,    520, "Monsters\\Spawn\\Spawn%c.CL2",     FALSE,       "Monsters\\newsfx\\HSpawn%c%i.WAV",  TRUE,        FALSE,     NULL,                              { 15, 12, 14, 11, 14,  0 }, { 0, 0, 0, 0, 0, 0 }, "Hork Spawn",              34,       37,     22,     30,     30, AI_SKELSD,    0                                                                  ,    3,   60,      8,         10,         25,     0,       0,           0,           0,          25, MC_DEMON,    RESIST_MAGIC                                                 , RESIST_MAGIC                                                 ,         0,        3,   250 },
	{     86,    305, "Monsters\\WScorp\\WScorp%c.CL2",   FALSE,       "Monsters\\newsfx\\Stingr%c%i.WAV",  FALSE,       FALSE,     NULL,                              { 10, 10, 12,  6, 15,  0 }, { 2, 0, 0, 0, 0, 0 }, "Venomtail",               36,       39,     24,     40,     50, AI_SKELSD,    0                                                                  ,    3,   85,      8,          1,         30,     0,       0,           0,           0,          60, MC_ANIMAL,                                RESIST_LIGHTNING                ,                              IMMUNE_LIGHTNING                 ,         0,        1,  1000 },
	{    140,    800, "Monsters\\Eye2\\Eye2%c.CL2",       FALSE,       "Monsters\\newsfx\\Psyco%c%i.WAV",   FALSE,       FALSE,     NULL,                              { 12, 13, 13,  7, 21,  0 }, { 2, 0, 0, 0, 0, 0 }, "Necromorb",               36,       39,     24,     30,     40, AI_NECROMORB, 0                                                                  ,    3,   80,      8,         20,         20,     0,       0,           0,           0,          50, MC_ANIMAL,                  RESIST_FIRE                                   ,                IMMUNE_FIRE  | RESIST_LIGHTNING                ,         0,        6,  1100 },
	{    148,    800, "Monsters\\bSpidr\\bSpidr%c.CL2",   TRUE,        "Monsters\\newsfx\\SLord%c%i.WAV",   TRUE,        FALSE,     NULL,                              { 12, 10, 15,  6, 20, 10 }, { 2, 0, 0, 0, 0, 0 }, "Spider Lord",             36,       39,     24,     80,    100, AI_ACID,                                       MFLAG_SEARCH                      ,    3,   60,      8,          8,         20,    75,       8,          10,          10,          60, MC_ANIMAL,                                RESIST_LIGHTNING                ,                RESIST_FIRE | IMMUNE_LIGHTNING                 ,         0,        7,  1250 },
	{    176,    800, "Monsters\\Clasp\\Clasp%c.CL2",     FALSE,       "Monsters\\newsfx\\Lworm%c%i.WAV",   FALSE,       FALSE,     NULL,                              { 10, 12, 15,  6, 16,  0 }, { 0, 0, 0, 0, 0, 0 }, "Lashworm",                36,       39,     20,     30,     30, AI_SKELSD,    0                                                                  ,    3,   90,      8,         12,         20,     0,       0,           0,           0,          50, MC_ANIMAL,   0                                                            ,                RESIST_FIRE                                   ,         0,        3,   600 },
	{    192,    800, "Monsters\\AntWorm\\Worm%c.CL2",    FALSE,       "Monsters\\newsfx\\TchAnt%c%i.WAV",  FALSE,       FALSE,     NULL,                              { 14, 12, 12,  6, 20,  0 }, { 2, 0, 0, 0, 0, 0 }, "Torchant",                36,       39,     22,     60,     80, AI_TORCHANT,  0                                                                  ,    3,   75,      8,         20,         30,     0,       0,           0,           0,          70, MC_ANIMAL,                  IMMUNE_FIRE                                    , RESIST_MAGIC | IMMUNE_FIRE  | RESIST_LIGHTNING                ,         0,        7,  1250 },
	{    138,    800, "Monsters\\HorkD\\HorkD%c.CL2",     TRUE,        "Monsters\\newsfx\\HDemon%c%i.WAV",  TRUE,        FALSE,     NULL,                              { 15,  8, 16,  6, 16,  9 }, { 2, 0, 0, 0, 0, 2 }, "Hork Demon",              36,       37,     27,    120,    160, AI_SKELSD,    0                                                                  ,    3,   60,      8,         20,         35,    80,       8,           0,           0,          80, MC_DEMON,                                 RESIST_LIGHTNING                , RESIST_MAGIC |               IMMUNE_LIGHTNING                 ,         0,        7,  2000 },
	{    198,    800, "Monsters\\Hellbug\\Hellbg%c.CL2",  TRUE,        "Monsters\\newsfx\\Defile%c%i.WAV",  TRUE,        FALSE,     NULL,                              {  8,  8, 14,  6, 14, 12 }, { 0, 0, 0, 0, 0, 0 }, "Hell Bug",                38,       39,     30,    240,    240, AI_SKELSD,                                     MFLAG_SEARCH                      ,    3,  110,      8,         20,         30,    90,       8,          50,          60,          80, MC_DEMON,    RESIST_MAGIC | RESIST_FIRE | IMMUNE_LIGHTNING                 , RESIST_MAGIC | IMMUNE_FIRE  | IMMUNE_LIGHTNING                 ,         0,        7,  5000 },
	{    124,    800, "Monsters\\Gravdg\\Gravdg%c.CL2",   TRUE,        "Monsters\\newsfx\\GDiggr%c%i.WAV",  TRUE,        FALSE,     NULL,                              { 24, 24, 12,  6, 16, 16 }, { 2, 0, 0, 0, 0, 0 }, "Gravedigger",             40,       41,     26,    120,    240, AI_SCAV,                                                      MFLAG_CAN_OPEN_DOOR,    3,   80,      6,          2,         12,     0,       0,           0,           0,          20, MC_UNDEAD,                                IMMUNE_LIGHTNING  | IMMUNE_NULL_40, RESIST_MAGIC | RESIST_FIRE | IMMUNE_LIGHTNING  | IMMUNE_NULL_40,         0,        3,  2000 },
	{    104,    550, "Monsters\\Rat\\Rat%c.CL2",         FALSE,       "Monsters\\newsfx\\TmbRat%c%i.WAV",  FALSE,       FALSE,     NULL,                              { 11,  8, 12,  6, 20,  0 }, { 2, 0, 0, 0, 0, 0 }, "Tomb Rat",                40,       43,     24,     80,    120, AI_SKELSD,    0                                                                  ,    3,  120,      8,         12,         25,     0,       0,           0,           0,          30, MC_ANIMAL,   0                                                            ,                RESIST_FIRE | RESIST_LIGHTNING                ,         0,        3,  1800 },
	{     96,    550, "Monsters\\Hellbat\\Helbat%c.CL2",  FALSE,       "Monsters\\newsfx\\HelBat%c%i.WAV",  FALSE,       FALSE,     NULL,                              { 18, 16, 14,  6, 18, 11 }, { 2, 0, 0, 0, 0, 0 }, "Firebat",                 40,       43,     24,     60,     80, AI_FIREBAT,   0                                                                  ,    3,  100,      8,         15,         20,     0,       0,           0,           0,          70, MC_ANIMAL,                  IMMUNE_FIRE                                    , RESIST_MAGIC | IMMUNE_FIRE  | RESIST_LIGHTNING                ,         0,        7,  2400 },
	{    128,   1740, "Monsters\\Demskel\\Demskl%c.CL2",  TRUE,        "Monsters\\newsfx\\SWing%c%i.WAV",   FALSE,       FALSE,     "Monsters\\Thin\\Thinv3.TRN",      { 10,  8, 20,  6, 24, 16 }, { 3, 0, 0, 0, 0, 0 }, "Skullwing",               40,       43,     27,     70,     70, AI_SKELSD,    0                                                                  ,    0,   75,      7,         15,         20,    75,       9,          15,          20,          80, MC_UNDEAD,                  RESIST_FIRE | RESIST_LIGHTNING | IMMUNE_NULL_40,                RESIST_FIRE | RESIST_LIGHTNING | IMMUNE_NULL_40,         0,        7,  3000 },
	{     96,    800, "Monsters\\Lich\\Lich%c.CL2",       FALSE,       "Monsters\\newsfx\\Lich%c%i.WAV",    TRUE,        FALSE,     NULL,                              { 12, 10, 10,  7, 21,  0 }, { 2, 0, 0, 0, 2, 0 }, "Lich",                    40,       43,     25,     80,    100, AI_LICH,      0                                                                  ,    3,  100,      8,         15,         20,     0,       0,           0,           0,          60, MC_UNDEAD,                                RESIST_LIGHTNING | IMMUNE_NULL_40, RESIST_MAGIC | RESIST_FIRE | IMMUNE_LIGHTNING  | IMMUNE_NULL_40,         0,        3,  3000 },
	{    154,    800, "Monsters\\Bubba\\Bubba%c.CL2",     FALSE,       "Monsters\\newsfx\\Crypt%c%i.WAV",   TRUE,        FALSE,     NULL,                              {  8, 18, 12,  8, 21,  0 }, { 3, 0, 0, 0, 0, 0 }, "Crypt Demon",             42,       45,     28,    200,    240, AI_SKELSD,    0                                                                  ,    3,  100,      8,         20,         40,     0,       0,           0,           0,          85, MC_DEMON,    IMMUNE_MAGIC  | RESIST_FIRE | RESIST_LIGHTNING                , IMMUNE_MAGIC  | IMMUNE_FIRE  | RESIST_LIGHTNING                ,         0,        3,  3200 },
	{     96,    550, "Monsters\\Hellbat2\\bhelbt%c.CL2", TRUE,        "Monsters\\newsfx\\HelBat%c%i.WAV",  FALSE,       FALSE,     NULL,                              { 18, 16, 14,  6, 18, 11 }, { 2, 0, 0, 0, 0, 0 }, "Hellbat",                 44,       47,     29,    100,    140, AI_TORCHANT,  0                                                                  ,    3,  110,      8,         30,         30,     0,       0,           0,           0,          80, MC_DEMON,    RESIST_MAGIC | IMMUNE_FIRE  | RESIST_LIGHTNING                , RESIST_MAGIC | IMMUNE_FIRE  | IMMUNE_LIGHTNING                 ,         0,        7,  3600 },
	{    128,   1740, "Monsters\\Demskel\\Demskl%c.CL2",  TRUE,        "Monsters\\newsfx\\SWing%c%i.WAV",   TRUE,        FALSE,     "Monsters\\Thin\\Thinv3.TRN",      { 10,  8, 20,  6, 24, 16 }, { 3, 0, 0, 0, 0, 0 }, "Bone Demon",              44,       47,     30,    240,    280, AI_BONEDEMON, 0                                                                  ,    0,  100,      8,         40,         50,   160,      12,          50,          50,          50, MC_UNDEAD,                  IMMUNE_FIRE  | IMMUNE_LIGHTNING  | IMMUNE_NULL_40,                IMMUNE_FIRE  | IMMUNE_LIGHTNING  | IMMUNE_NULL_40,         0,        7,  5000 },
	{    136,    800, "Monsters\\Lich2\\Lich2%c.CL2",     FALSE,       "Monsters\\newsfx\\Lich%c%i.WAV",    TRUE,        FALSE,     NULL,                              { 12, 10, 10,  7, 21,  0 }, { 2, 0, 0, 0, 2, 0 }, "Arch Lich",               44,       47,     30,    180,    200, AI_ARCHLICH,  0                                                                  ,    3,  120,      8,         30,         30,     0,       0,           0,           0,          75, MC_UNDEAD,   RESIST_MAGIC | RESIST_FIRE | IMMUNE_LIGHTNING  | IMMUNE_NULL_40, IMMUNE_MAGIC  | IMMUNE_FIRE  | IMMUNE_LIGHTNING  | IMMUNE_NULL_40,         0,        3,  4000 },
	{    180,    800, "Monsters\\Byclps\\Byclps%c.CL2",   FALSE,       "Monsters\\newsfx\\Biclop%c%i.WAV",  FALSE,       FALSE,     NULL,                              { 10, 11, 16,  6, 16,  0 }, { 2, 0, 0, 0, 2, 0 }, "Biclops",                 44,       47,     30,    200,    240, AI_SKELSD,                   MFLAG_KNOCKBACK |                MFLAG_CAN_OPEN_DOOR,    3,   90,      8,         40,         50,     0,       0,           0,           0,          80, MC_DEMON,                                 RESIST_LIGHTNING                ,                RESIST_FIRE | RESIST_LIGHTNING                ,         0,        3,  4000 },
	{    164,    800, "Monsters\\Flesh\\Flesh%c.CL2",     FALSE,       "Monsters\\newsfx\\FleshT%c%i.WAV",  TRUE,        FALSE,     NULL,                              { 15, 24, 15,  6, 16,  0 }, { 0, 0, 0, 0, 0, 0 }, "Flesh Thing",             44,       47,     28,    300,    400, AI_SKELSD,    0                                                                  ,    3,  150,      8,         12,         18,     0,       0,           0,           0,          70, MC_DEMON,    RESIST_MAGIC | RESIST_FIRE | RESIST_LIGHTNING                , RESIST_MAGIC | RESIST_FIRE | RESIST_LIGHTNING                ,         0,        3,  4000 },
	{    180,    800, "Monsters\\Reaper\\Reap%c.CL2",     FALSE,       "Monsters\\newsfx\\Reaper%c%i.WAV",  FALSE,       FALSE,     NULL,                              { 12, 10, 14,  6, 16,  0 }, { 2, 0, 0, 0, 0, 0 }, "Reaper",                  44,       47,     30,    260,    300, AI_SKELSD,    0                                                                  ,    3,  120,      8,         30,         35,     0,       0,           0,           0,          90, MC_DEMON,    IMMUNE_MAGIC  | IMMUNE_FIRE  | RESIST_LIGHTNING                , IMMUNE_MAGIC  | IMMUNE_FIRE  | IMMUNE_LIGHTNING                 ,         0,        3,  6000 },
	{    226,   1200, "Monsters\\Nkr\\Nkr%c.CL2",         TRUE,        "Monsters\\newsfx\\Nakrul%c%i.WAV",  TRUE,        FALSE,     NULL,                              {  2,  6, 16,  3, 16, 16 }, { 0, 0, 0, 0, 0, 0 }, "Na-Krul",                 60,       60,     40,   1332,   1332, AI_SKELSD,                   MFLAG_KNOCKBACK | MFLAG_SEARCH | MFLAG_CAN_OPEN_DOOR,    3,  150,      7,         40,         50,   150,      10,          40,          50,         125, MC_DEMON,    IMMUNE_MAGIC  | IMMUNE_FIRE  | RESIST_LIGHTNING | IMMUNE_NULL_40, IMMUNE_MAGIC  | IMMUNE_FIRE  | IMMUNE_LIGHTNING  | IMMUNE_NULL_40,         0,        7, 13333 },
	// clang-format on
};

/**
 * Map between .DUN file value and monster type enum
 */
const _monster_id MonstConvTbl[] = {
	MT_NZOMBIE,
	MT_BZOMBIE,
	MT_GZOMBIE,
	MT_YZOMBIE,
	MT_RFALLSP,
	MT_DFALLSP,
	MT_YFALLSP,
	MT_BFALLSP,
	MT_WSKELAX,
	MT_TSKELAX,
	MT_RSKELAX,
	MT_XSKELAX,
	MT_RFALLSD,
	MT_DFALLSD,
	MT_YFALLSD,
	MT_BFALLSD,
	MT_NSCAV,
	MT_BSCAV,
	MT_WSCAV,
	MT_YSCAV,
	MT_WSKELBW,
	MT_TSKELBW,
	MT_RSKELBW,
	MT_XSKELBW,
	MT_WSKELSD,
	MT_TSKELSD,
	MT_RSKELSD,
	MT_XSKELSD,
	MT_SNEAK,
	MT_STALKER,
	MT_UNSEEN,
	MT_ILLWEAV,
	MT_NGOATMC,
	MT_BGOATMC,
	MT_RGOATMC,
	MT_GGOATMC,
	MT_FIEND,
	MT_GLOOM,
	MT_BLINK,
	MT_FAMILIAR,
	MT_NGOATBW,
	MT_BGOATBW,
	MT_RGOATBW,
	MT_GGOATBW,
	MT_NACID,
	MT_RACID,
	MT_BACID,
	MT_XACID,
	MT_SKING,
	MT_FAT,
	MT_MUDMAN,
	MT_TOAD,
	MT_FLAYED,
	MT_WYRM,
	MT_CAVSLUG,
	MT_DEVOUR,
	MT_DVLWYRM,
	MT_NMAGMA,
	MT_YMAGMA,
	MT_BMAGMA,
	MT_WMAGMA,
	MT_HORNED,
	MT_MUDRUN,
	MT_FROSTC,
	MT_OBLORD,
	MT_BONEDMN,
	MT_REDDTH,
	MT_LTCHDMN,
	MT_UDEDBLRG,
	MT_INVALID,
	MT_INVALID,
	MT_INVALID,
	MT_INVALID,
	MT_INCIN,
	MT_FLAMLRD,
	MT_DOOMFIRE,
	MT_HELLBURN,
	MT_INVALID,
	MT_INVALID,
	MT_INVALID,
	MT_INVALID,
	MT_RSTORM,
	MT_STORM,
	MT_STORML,
	MT_MAEL,
	MT_WINGED,
	MT_GARGOYLE,
	MT_BLOODCLW,
	MT_DEATHW,
	MT_MEGA,
	MT_GUARD,
	MT_VTEXLRD,
	MT_BALROG,
	MT_NSNAKE,
	MT_RSNAKE,
	MT_GSNAKE,
	MT_BSNAKE,
	MT_NBLACK,
	MT_RTBLACK,
	MT_BTBLACK,
	MT_RBLACK,
	MT_UNRAV,
	MT_HOLOWONE,
	MT_PAINMSTR,
	MT_REALWEAV,
	MT_SUCCUBUS,
	MT_SNOWWICH,
	MT_HLSPWN,
	MT_SOLBRNR,
	MT_COUNSLR,
	MT_MAGISTR,
	MT_CABALIST,
	MT_ADVOCATE,
	MT_INVALID,
	MT_DIABLO,
	MT_INVALID,
	MT_GOLEM,
	MT_INVALID,
	MT_INVALID,
	MT_INVALID, // Monster from blood1.dun and blood2.dun
	MT_INVALID,
	MT_INVALID,
	MT_INVALID,
	MT_INVALID, // Snotspill from banner2.dun
	MT_INVALID,
	MT_INVALID,
	MT_BIGFALL,
	MT_DARKMAGE,
	MT_HELLBOAR,
	MT_STINGER,
	MT_PSYCHORB,
	MT_ARACHNON,
	MT_FELLTWIN,
	MT_HORKSPWN,
	MT_STINGER,
	MT_PSYCHORB,
	MT_ARACHNON,
	MT_LASHWORM,
	MT_TORCHANT,
	MT_HORKDMN,
	MT_DEFILER,
	MT_GRAVEDIG,
	MT_TOMBRAT,
	MT_FIREBAT,
	MT_SKLWING,
	MT_LICH,
	MT_CRYPTDMN,
	MT_FIREBAT,
	MT_SKLWING,
	MT_LICH,
	MT_BICLOPS,
	MT_FLESTHNG,
	MT_REAPER,
	MT_NAKRUL,
	MT_CLEAVER,
	MT_INVILORD,
	MT_LRDSAYTR,
};

/**
 * Define what version a monster type is available in
 */
const char MonstAvailTbl[] = {
	MAT_ALWAYS, // Zombie
	MAT_ALWAYS, // Ghoul
	MAT_ALWAYS, // Rotting Carcass
	MAT_ALWAYS, // Black Death
	MAT_ALWAYS, // Fallen One
	MAT_ALWAYS, // Carver
	MAT_ALWAYS, // Devil Kin
	MAT_ALWAYS, // Dark One
	MAT_ALWAYS, // Skeleton
	MAT_ALWAYS, // Corpse Axe
	MAT_ALWAYS, // Burning Dead
	MAT_ALWAYS, // Horror
	MAT_ALWAYS, // Fallen One
	MAT_ALWAYS, // Carver
	MAT_ALWAYS, // Devil Kin
	MAT_ALWAYS, // Dark One
	MAT_ALWAYS, // Scavenger
	MAT_ALWAYS, // Plague Eater
	MAT_ALWAYS, // Shadow Beast
	MAT_ALWAYS, // Bone Gasher
	MAT_ALWAYS, // Skeleton
	MAT_ALWAYS, // Corpse Bow
	MAT_ALWAYS, // Burning Dead
	MAT_ALWAYS, // Horror
	MAT_ALWAYS, // Skeleton Captain
	MAT_ALWAYS, // Corpse Captain
	MAT_ALWAYS, // Burning Dead Captain
	MAT_ALWAYS, // Horror Captain
	MAT_NEVER,  // Invisible Lord
	MAT_RETAIL, // Hidden
	MAT_RETAIL, // Stalker
	MAT_RETAIL, // Unseen
	MAT_RETAIL, // Illusion Weaver
	MAT_RETAIL, // Satyr Lord
	MAT_RETAIL, // Flesh Clan
	MAT_RETAIL, // Stone Clan
	MAT_RETAIL, // Fire Clan
	MAT_RETAIL, // Night Clan
	MAT_ALWAYS, // Fiend
	MAT_ALWAYS, // Blink
	MAT_ALWAYS, // Gloom
	MAT_ALWAYS, // Familiar
	MAT_RETAIL, // Flesh Clan
	MAT_RETAIL, // Stone Clan
	MAT_RETAIL, // Fire Clan
	MAT_RETAIL, // Night Clan
	MAT_RETAIL, // Acid Beast
	MAT_RETAIL, // Poison Spitter
	MAT_RETAIL, // Pit Beast
	MAT_RETAIL, // Lava Maw
	MAT_NEVER,  // Skeleton King
	MAT_NEVER,  // The Butcher
	MAT_RETAIL, // Overlord
	MAT_RETAIL, // Mud Man
	MAT_RETAIL, // Toad Demon
	MAT_RETAIL, // Flayed One
	MAT_NEVER,  // Wyrm
	MAT_NEVER,  // Cave Slug
	MAT_NEVER,  // Devil Wyrm
	MAT_NEVER,  // Devourer
	MAT_RETAIL, // Magma Demon
	MAT_RETAIL, // Blood Stone
	MAT_RETAIL, // Hell Stone
	MAT_RETAIL, // Lava Lord
	MAT_RETAIL, // Horned Demon
	MAT_RETAIL, // Mud Runner
	MAT_RETAIL, // Frost Charger
	MAT_RETAIL, // Obsidian Lord
	MAT_NEVER,  // Bone Demon (oldboned in Hellfire)
	MAT_NEVER,  // Red Death
	MAT_NEVER,  // Litch Demon
	MAT_NEVER,  // Undead Balrog
	MAT_NEVER,  // Incinerator
	MAT_NEVER,  // Flame Lord
	MAT_NEVER,  // Doom Fire
	MAT_NEVER,  // Hell Burner
	MAT_RETAIL, // Red Storm
	MAT_RETAIL, // Storm Rider
	MAT_RETAIL, // Storm Lord
	MAT_RETAIL, // Maelstorm
	MAT_RETAIL, // Devil Kin Brute
	MAT_RETAIL, // Winged-Demon
	MAT_RETAIL, // Gargoyle
	MAT_RETAIL, // Blood Claw
	MAT_RETAIL, // Death Wing
	MAT_RETAIL, // Slayer
	MAT_RETAIL, // Guardian
	MAT_RETAIL, // Vortex Lord
	MAT_RETAIL, // Balrog
	MAT_RETAIL, // Cave Viper
	MAT_RETAIL, // Fire Drake
	MAT_RETAIL, // Gold Viper
	MAT_RETAIL, // Azure Drake
	MAT_RETAIL, // Black Knight
	MAT_RETAIL, // Doom Guard
	MAT_RETAIL, // Steel Lord
	MAT_RETAIL, // Blood Knight
	MAT_RETAIL, // The Shredded
	MAT_NEVER,  // Hollow One
	MAT_NEVER,  // Pain Master
	MAT_NEVER,  // Reality Weaver
	MAT_RETAIL, // Succubus
	MAT_RETAIL, // Snow Witch
	MAT_RETAIL, // Hell Spawn
	MAT_RETAIL, // Soul Burner
	MAT_RETAIL, // Counselor
	MAT_RETAIL, // Magistrate
	MAT_RETAIL, // Cabalist
	MAT_RETAIL, // Advocate
	MAT_NEVER,  // Golem
	MAT_NEVER,  // The Dark Lord
	MAT_NEVER,  // The Arch-Litch Malignus
	MAT_RETAIL, // Hellboar
	MAT_RETAIL, // Stinger
	MAT_RETAIL, // Psychorb
	MAT_RETAIL, // Arachnon
	MAT_RETAIL, // Felltwin
	MAT_RETAIL, // Hork Spawn
	MAT_RETAIL, // Venomtail
	MAT_RETAIL, // Necromorb
	MAT_RETAIL, // Spider Lord
	MAT_RETAIL, // Lashworm
	MAT_RETAIL, // Torchant
	MAT_NEVER,  // Hork Demon
	MAT_NEVER,  // Hell Bug
	MAT_RETAIL, // Gravedigger
	MAT_RETAIL, // Tomb Rat
	MAT_RETAIL, // Firebat
	MAT_RETAIL, // Skullwing
	MAT_RETAIL, // Lich
	MAT_RETAIL, // Crypt Demon
	MAT_RETAIL, // Hellbat
	MAT_RETAIL, // Bone Demon
	MAT_RETAIL, // Arch Lich
	MAT_RETAIL, // Biclops
	MAT_RETAIL, // Flesh Thing
	MAT_RETAIL, // Reaper
	MAT_NEVER,  // Na-Krul
};
/** Contains the data related to each unique monster ID. */
const UniqMonstStruct UniqMonst[] = {
	// clang-format off
	// mtype,       mName,                      mTrnName,    mlevel, mmaxhp, mAi,      mint, mMinDamage, mMaxDamage, mMagicRes,                                                     mUnqAttr, mUnqVar1, mUnqVar2, mtalkmsg
	{  MT_NGOATMC,  "Gharbad the Weak",         "BSDB",        4,    120, AI_GARBUD,   3,          8,         16,                              IMMUNE_LIGHTNING | IMMUNE_NULL_40,        0,        0,        0, TEXT_GARBUD1   },
	{  MT_SKING,    "Skeleton King",            "GENRL",       0,    240, AI_SKELKING, 3,          6,         16, IMMUNE_MAGIC | RESIST_FIRE | RESIST_LIGHTNING | IMMUNE_NULL_40,        1,        0,        0, 0              },
	{  MT_COUNSLR,  "Zhar the Mad",             "GENERAL",     8,    360, AI_ZHAR,     3,         16,         40, IMMUNE_MAGIC | RESIST_FIRE | RESIST_LIGHTNING                 ,        0,        0,        0, TEXT_ZHAR1     },
	{  MT_BFALLSP,  "Snotspill",                "BNG",         4,    220, AI_SNOTSPIL, 3,         10,         18,                              RESIST_LIGHTNING                 ,        0,        0,        0, TEXT_BANNER10  },
	{  MT_ADVOCATE, "Arch-Bishop Lazarus",      "GENERAL",     0,    600, AI_LAZURUS,  3,         30,         50, IMMUNE_MAGIC | RESIST_FIRE | RESIST_LIGHTNING | IMMUNE_NULL_40,        0,        0,        0, TEXT_VILE13    },
	{  MT_HLSPWN,   "Red Vex",                  "REDV",        0,    400, AI_LAZHELP,  3,         30,         50, IMMUNE_MAGIC | RESIST_FIRE |                    IMMUNE_NULL_40,        0,        0,        0, TEXT_VILE13    },
	{  MT_HLSPWN,   "BlackJade",                "BLKJD",       0,    400, AI_LAZHELP,  3,         30,         50, IMMUNE_MAGIC |               RESIST_LIGHTNING | IMMUNE_NULL_40,        0,        0,        0, TEXT_VILE13    },
	{  MT_RBLACK,   "Lachdanan",                "BHKA",       14,    500, AI_LACHDAN,  3,          0,          0, 0                                                             ,        0,        0,        0, TEXT_VEIL9     },
	{  MT_BTBLACK,  "Warlord of Blood",         "GENERAL",    13,    850, AI_WARLORD,  3,         35,         50, IMMUNE_MAGIC | IMMUNE_FIRE | IMMUNE_LIGHTNING | IMMUNE_NULL_40,        0,        0,        0, TEXT_WARLRD9   },
	{  MT_CLEAVER,  "The Butcher",              "GENRL",       0,    220, AI_CLEAVER,  3,          6,         12,                RESIST_FIRE | RESIST_LIGHTNING | IMMUNE_NULL_40,        0,        0,        0, 0              },
	{  MT_HORKDMN,  "Hork Demon",               "GENRL",      19,    300, AI_HORKDMN,  3,         20,         35,                              RESIST_LIGHTNING                 ,        0,        0,        0, 0              },
	{  MT_DEFILER,  "The Defiler",              "GENRL",      20,    480, AI_SKELSD,   3,         30,         40, RESIST_MAGIC | RESIST_FIRE | IMMUNE_LIGHTNING                 ,        0,        0,        0, 0              },
	{  MT_NAKRUL,   "Na-Krul",                  "GENRL",       0,   1332, AI_SKELSD,   3,         40,         50, IMMUNE_MAGIC | IMMUNE_FIRE | IMMUNE_LIGHTNING | IMMUNE_NULL_40,        3,        0,        0, 0              },
	{  MT_TSKELAX,  "Bonehead Keenaxe",         "BHKA",        2,     91, AI_SKELSD,   2,          4,         10, IMMUNE_MAGIC |                                  IMMUNE_NULL_40,        7,      100,        0, 0              },
	{  MT_RFALLSD,  "Bladeskin the Slasher",    "BSTS",        2,     51, AI_FALLEN,   0,          6,         18,                RESIST_FIRE                                    ,       11,       45,        0, 0              },
	{  MT_NZOMBIE,  "Soulpus",                  "GENERAL",     2,    133, AI_ZOMBIE,   0,          4,          8,                RESIST_FIRE | RESIST_LIGHTNING                 ,        0,        0,        0, 0              },
	{  MT_RFALLSP,  "Pukerat the Unclean",      "PTU",         2,     77, AI_FALLEN,   3,          1,          5,                RESIST_FIRE                                    ,        0,        0,        0, 0              },
	{  MT_WSKELAX,  "Boneripper",               "BR",          2,     54, AI_BAT,      0,          6,         15, IMMUNE_MAGIC | IMMUNE_FIRE |                    IMMUNE_NULL_40,        3,        0,        0, 0              },
	{  MT_NZOMBIE,  "Rotfeast the Hungry",      "ETH",         2,     85, AI_SKELSD,   3,          4,         12, IMMUNE_MAGIC |                                  IMMUNE_NULL_40,        3,        0,        0, 0              },
	{  MT_DFALLSD,  "Gutshank the Quick",       "GTQ",         3,     66, AI_BAT,      2,          6,         16,                RESIST_FIRE                                    ,        3,        0,        0, 0              },
	{  MT_TSKELSD,  "Brokenhead Bangshield",    "BHBS",        3,    108, AI_SKELSD,   3,         12,         20, IMMUNE_MAGIC |               RESIST_LIGHTNING | IMMUNE_NULL_40,        3,        0,        0, 0              },
	{  MT_YFALLSP,  "Bongo",                    "BNG",         3,    178, AI_FALLEN,   3,          9,         21, 0                                                             ,        3,        0,        0, 0              },
	{  MT_BZOMBIE,  "Rotcarnage",               "RCRN",        3,    102, AI_ZOMBIE,   3,          9,         24, IMMUNE_MAGIC |               RESIST_LIGHTNING | IMMUNE_NULL_40,       11,       45,        0, 0              },
	{  MT_NSCAV,    "Shadowbite",               "SHBT",        2,     60, AI_SKELSD,   3,          3,         20,                IMMUNE_FIRE                                    ,        3,        0,        0, 0              },
	{  MT_WSKELBW,  "Deadeye",                  "DE",          2,     49, AI_GOATBOW,  0,          6,          9, IMMUNE_MAGIC | RESIST_FIRE |                    IMMUNE_NULL_40,        0,        0,        0, 0              },
	{  MT_RSKELAX,  "Madeye the Dead",          "MTD",         4,     75, AI_BAT,      0,          9,         21, IMMUNE_MAGIC | IMMUNE_FIRE                                    ,       11,       30,        0, 0              },
	{  MT_BSCAV,    "El Chupacabras",           "GENERAL",     3,    120, AI_GOATMC,   0,         10,         18,                RESIST_FIRE                                    ,        3,       30,        0, 0              },
	{  MT_TSKELBW,  "Skullfire",                "SKFR",        3,    125, AI_GOATBOW,  1,          6,         10,                IMMUNE_FIRE                                    ,        0,      100,        0, 0              },
	{  MT_SNEAK,    "Warpskull",                "TSPO",        3,    117, AI_SNEAK,    2,          6,         18,                RESIST_FIRE | RESIST_LIGHTNING                 ,        3,        0,        0, 0              },
	{  MT_GZOMBIE,  "Goretongue",               "PMR",         3,    156, AI_SKELSD,   1,         15,         30, IMMUNE_MAGIC |                                  IMMUNE_NULL_40,        0,        0,        0, 0              },
	{  MT_WSCAV,    "Pulsecrawler",             "BHKA",        4,    150, AI_SCAV,     0,         16,         20,                IMMUNE_FIRE | RESIST_LIGHTNING                 ,       11,       45,        0, 0              },
	{  MT_BLINK,    "Moonbender",               "GENERAL",     4,    135, AI_BAT,      0,          9,         27,                IMMUNE_FIRE                                    ,        3,        0,        0, 0              },
	{  MT_BLINK,    "Wrathraven",               "GENERAL",     5,    135, AI_BAT,      2,          9,         22,                IMMUNE_FIRE                                    ,        3,        0,        0, 0              },
	{  MT_YSCAV,    "Spineeater",               "GENERAL",     4,    180, AI_SCAV,     1,         18,         25,                              IMMUNE_LIGHTNING | IMMUNE_NULL_40,        3,        0,        0, 0              },
	{  MT_RSKELBW,  "Blackash the Burning",     "BASHTB",      4,    120, AI_GOATBOW,  0,          6,         16, IMMUNE_MAGIC | IMMUNE_FIRE                                    ,        3,        0,        0, 0              },
	{  MT_BFALLSD,  "Shadowcrow",               "GENERAL",     5,    270, AI_SNEAK,    2,         12,         25, 0                                                             ,        3,        0,        0, 0              },
	{  MT_LRDSAYTR, "Blightstone the Weak",     "BHKA",        4,    360, AI_SKELSD,   0,          4,         12, IMMUNE_MAGIC |               RESIST_LIGHTNING                 ,        7,       70,        0, 0              },
	{  MT_FAT,      "Bilefroth the Pit Master", "BFTP",        6,    210, AI_BAT,      1,         16,         23, IMMUNE_MAGIC | IMMUNE_FIRE | RESIST_LIGHTNING                 ,        3,        0,        0, 0              },
	{  MT_NGOATBW,  "Bloodskin Darkbow",        "BSDB",        5,    207, AI_GOATBOW,  0,          3,         16,                RESIST_FIRE | RESIST_LIGHTNING                 ,       11,       55,        0, 0              },
	{  MT_GLOOM,    "Foulwing",                 "DB",          5,    246, AI_RHINO,    3,         12,         28,                RESIST_FIRE                                    ,        3,        0,        0, 0              },
	{  MT_XSKELSD,  "Shadowdrinker",            "SHDR",        5,    300, AI_SNEAK,    1,         18,         26, IMMUNE_MAGIC | RESIST_FIRE | RESIST_LIGHTNING | IMMUNE_NULL_40,        8,       45,        0, 0              },
	{  MT_UNSEEN,   "Hazeshifter",              "BHKA",        5,    285, AI_SNEAK,    3,         18,         30,                              IMMUNE_LIGHTNING | IMMUNE_NULL_40,        3,        0,        0, 0              },
	{  MT_NACID,    "Deathspit",                "BFDS",        6,    303, AI_ACIDUNIQ, 0,         12,         32,                RESIST_FIRE | RESIST_LIGHTNING                 ,        3,        0,        0, 0              },
	{  MT_RGOATMC,  "Bloodgutter",              "BGBL",        6,    315, AI_BAT,      1,         24,         34,                IMMUNE_FIRE                                    ,        3,        0,        0, 0              },
	{  MT_BGOATMC,  "Deathshade Fleshmaul",     "DSFM",        6,    276, AI_RHINO,    0,         12,         24, IMMUNE_MAGIC | RESIST_FIRE                                    ,        8,       65,        0, 0              },
	{  MT_WYRM,     "Warmaggot the Mad",        "GENERAL",     6,    246, AI_BAT,      3,         15,         30,                              RESIST_LIGHTNING                 ,        3,        0,        0, 0              },
	{  MT_STORM,    "Glasskull the Jagged",     "BHKA",        7,    354, AI_STORM,    0,         18,         30, IMMUNE_MAGIC | IMMUNE_FIRE |                    IMMUNE_NULL_40,        3,        0,        0, 0              },
	{  MT_RGOATBW,  "Blightfire",               "BLF",         7,    321, AI_SUCC,     2,         13,         21,                IMMUNE_FIRE                                    ,        3,        0,        0, 0              },
	{  MT_GARGOYLE, "Nightwing the Cold",       "GENERAL",     7,    342, AI_BAT,      1,         18,         26, IMMUNE_MAGIC |               RESIST_LIGHTNING | IMMUNE_NULL_40,        3,        0,        0, 0              },
	{  MT_GGOATBW,  "Gorestone",                "GENERAL",     7,    303, AI_GOATBOW,  1,         15,         28,                              RESIST_LIGHTNING | IMMUNE_NULL_40,        7,       70,        0, 0              },
	{  MT_BMAGMA,   "Bronzefist Firestone",     "GENERAL",     8,    360, AI_MAGMA,    0,         30,         36, IMMUNE_MAGIC | RESIST_FIRE                                    ,        3,        0,        0, 0              },
	{  MT_INCIN,    "Wrathfire the Doomed",     "WFTD",        8,    270, AI_SKELSD,   2,         20,         30, IMMUNE_MAGIC | RESIST_FIRE |  RESIST_LIGHTNING                ,        3,        0,        0, 0              },
	{  MT_NMAGMA,   "Firewound the Grim",       "BHKA",        8,    303, AI_MAGMA,    0,         18,         22, IMMUNE_MAGIC | RESIST_FIRE                                    ,        3,        0,        0, 0              },
	{  MT_MUDMAN,   "Baron Sludge",             "BSM",         8,    315, AI_SNEAK,    3,         25,         34, IMMUNE_MAGIC | RESIST_FIRE | RESIST_LIGHTNING | IMMUNE_NULL_40,       11,       75,        0, 0              },
	{  MT_GGOATMC,  "Blighthorn Steelmace",     "BHSM",        7,    250, AI_RHINO,    0,         20,         28,                              RESIST_LIGHTNING                 ,       11,       45,        0, 0              },
	{  MT_RACID,    "Chaoshowler",              "GENERAL",     8,    240, AI_ACIDUNIQ, 0,         12,         20, 0                                                             ,        3,        0,        0, 0              },
	{  MT_REDDTH,   "Doomgrin the Rotting",     "GENERAL",     8,    405, AI_STORM,    3,         25,         50, IMMUNE_MAGIC | RESIST_FIRE | RESIST_LIGHTNING | IMMUNE_NULL_40,        3,        0,        0, 0              },
	{  MT_FLAMLRD,  "Madburner",                "GENERAL",     9,    270, AI_STORM,    0,         20,         40, IMMUNE_MAGIC | IMMUNE_FIRE | IMMUNE_LIGHTNING                 ,        3,        0,        0, 0              },
	{  MT_LTCHDMN,  "Bonesaw the Litch",        "GENERAL",     9,    495, AI_STORM,    2,         30,         55, IMMUNE_MAGIC | RESIST_FIRE | RESIST_LIGHTNING | IMMUNE_NULL_40,        3,        0,        0, 0              },
	{  MT_MUDRUN,   "Breakspine",               "GENERAL",     9,    351, AI_RHINO,    0,         25,         34,                RESIST_FIRE                                    ,        3,        0,        0, 0              },
	{  MT_REDDTH,   "Devilskull Sharpbone",     "GENERAL",     9,    444, AI_STORM,    1,         25,         40,                IMMUNE_FIRE                                    ,        3,        0,        0, 0              },
	{  MT_STORM,    "Brokenstorm",              "GENERAL",     9,    411, AI_STORM,    2,         25,         36,                              IMMUNE_LIGHTNING                 ,        3,        0,        0, 0              },
	{  MT_RSTORM,   "Stormbane",                "GENERAL",     9,    555, AI_STORM,    3,         30,         30,                              IMMUNE_LIGHTNING                 ,        3,        0,        0, 0              },
	{  MT_TOAD,     "Oozedrool",                "GENERAL",     9,    483, AI_FAT,      3,         25,         30,                              RESIST_LIGHTNING                 ,        3,        0,        0, 0              },
	{  MT_BLOODCLW, "Goldblight of the Flame",  "GENERAL",    10,    405, AI_GARG,     0,         15,         35, IMMUNE_MAGIC | IMMUNE_FIRE                                    ,       11,       80,        0, 0              },
	{  MT_OBLORD,   "Blackstorm",               "GENERAL",    10,    525, AI_RHINO,    3,         20,         40, IMMUNE_MAGIC |               IMMUNE_LIGHTNING                 ,       11,       90,        0, 0              },
	{  MT_RACID,    "Plaguewrath",              "GENERAL",    10,    450, AI_ACIDUNIQ, 2,         20,         30, IMMUNE_MAGIC | RESIST_FIRE |                    IMMUNE_NULL_40,        3,        0,        0, 0              },
	{  MT_RSTORM,   "The Flayer",               "GENERAL",    10,    501, AI_STORM,    1,         20,         35, RESIST_MAGIC | RESIST_FIRE | IMMUNE_LIGHTNING | IMMUNE_NULL_40,        3,        0,        0, 0              },
	{  MT_FROSTC,   "Bluehorn",                 "GENERAL",    11,    477, AI_RHINO,    1,         25,         30, IMMUNE_MAGIC | RESIST_FIRE                                    ,       11,       90,        0, 0              },
	{  MT_HELLBURN, "Warpfire Hellspawn",       "GENERAL",    11,    525, AI_FIREMAN,  3,         10,         40, RESIST_MAGIC | IMMUNE_FIRE                                    ,        3,        0,        0, 0              },
	{  MT_NSNAKE,   "Fangspeir",                "GENERAL",    11,    444, AI_SKELSD,   1,         15,         32,                IMMUNE_FIRE |                    IMMUNE_NULL_40,        3,        0,        0, 0              },
	{  MT_UDEDBLRG, "Festerskull",              "GENERAL",    11,    600, AI_STORM,    2,         15,         30, IMMUNE_MAGIC |                                  IMMUNE_NULL_40,        3,        0,        0, 0              },
	{  MT_NBLACK,   "Lionskull the Bent",       "GENERAL",    12,    525, AI_SKELSD,   2,         25,         25, IMMUNE_MAGIC | IMMUNE_FIRE | IMMUNE_LIGHTNING | IMMUNE_NULL_40,        3,        0,        0, 0              },
	{  MT_COUNSLR,  "Blacktongue",              "GENERAL",    12,    360, AI_COUNSLR,  3,         15,         30,                RESIST_FIRE |                    IMMUNE_NULL_40,        3,        0,        0, 0              },
	{  MT_DEATHW,   "Viletouch",                "GENERAL",    12,    525, AI_GARG,     3,         20,         40,                              IMMUNE_LIGHTNING | IMMUNE_NULL_40,        3,        0,        0, 0              },
	{  MT_RSNAKE,   "Viperflame",               "GENERAL",    12,    570, AI_SKELSD,   1,         25,         35,               IMMUNE_FIRE  | RESIST_LIGHTNING                 ,        3,        0,        0, 0              },
	{  MT_BSNAKE,   "Fangskin",                 "BHKA",       14,    681, AI_SKELSD,   2,         15,         50, IMMUNE_MAGIC |               RESIST_LIGHTNING                 ,        3,        0,        0, 0              },
	{  MT_SUCCUBUS, "Witchfire the Unholy",     "GENERAL",    12,    444, AI_SUCC,     3,         10,         20, IMMUNE_MAGIC | IMMUNE_FIRE | RESIST_LIGHTNING                 ,        3,        0,        0, 0              },
	{  MT_BALROG,   "Blackskull",               "BHKA",       13,    750, AI_SKELSD,   3,         25,         40, IMMUNE_MAGIC |               RESIST_LIGHTNING                 ,        3,        0,        0, 0              },
	{  MT_UNRAV,    "Soulslash",                "GENERAL",    12,    450, AI_SKELSD,   0,         25,         25, IMMUNE_MAGIC |                                  IMMUNE_NULL_40,        3,        0,        0, 0              },
	{  MT_VTEXLRD,  "Windspawn",                "GENERAL",    12,    711, AI_SKELSD,   1,         35,         40, IMMUNE_MAGIC | IMMUNE_FIRE                                    ,        3,        0,        0, 0              },
	{  MT_GSNAKE,   "Lord of the Pit",          "GENERAL",    13,    762, AI_SKELSD,   2,         25,         42,                RESIST_FIRE |                    IMMUNE_NULL_40,        3,        0,        0, 0              },
	{  MT_RTBLACK,  "Rustweaver",               "GENERAL",    13,    400, AI_SKELSD,   3,          1,         60, IMMUNE_MAGIC | IMMUNE_FIRE | IMMUNE_LIGHTNING | IMMUNE_NULL_40,        0,        0,        0, 0              },
	{  MT_HOLOWONE, "Howlingire the Shade",     "GENERAL",    13,    450, AI_SKELSD,   2,         40,         75,                RESIST_FIRE | RESIST_LIGHTNING                 ,        3,        0,        0, 0              },
	{  MT_MAEL,     "Doomcloud",                "GENERAL",    13,    612, AI_STORM,    1,          1,         60,                RESIST_FIRE | IMMUNE_LIGHTNING                 ,        0,        0,        0, 0              },
	{  MT_PAINMSTR, "Bloodmoon Soulfire",       "GENERAL",    13,    684, AI_SKELSD,   1,         15,         40, IMMUNE_MAGIC | RESIST_FIRE | RESIST_LIGHTNING                 ,        3,        0,        0, 0              },
	{  MT_SNOWWICH, "Witchmoon",                "GENERAL",    13,    310, AI_SUCC,     3,         30,         40,                              RESIST_LIGHTNING                 ,        0,        0,        0, 0              },
	{  MT_VTEXLRD,  "Gorefeast",                "GENERAL",    13,    771, AI_SKELSD,   3,         20,         55,                RESIST_FIRE |                    IMMUNE_NULL_40,        0,        0,        0, 0              },
	{  MT_RTBLACK,  "Graywar the Slayer",       "GENERAL",    14,    672, AI_SKELSD,   1,         30,         50,                              RESIST_LIGHTNING | IMMUNE_NULL_40,        0,        0,        0, 0              },
	{  MT_MAGISTR,  "Dreadjudge",               "GENERAL",    14,    540, AI_COUNSLR,  1,         30,         40, IMMUNE_MAGIC | RESIST_FIRE | RESIST_LIGHTNING                 ,        3,        0,        0, 0              },
	{  MT_HLSPWN,   "Stareye the Witch",        "GENERAL",    14,    726, AI_SUCC,     2,         30,         50,                IMMUNE_FIRE                                    ,        0,        0,        0, 0              },
	{  MT_BTBLACK,  "Steelskull the Hunter",    "GENERAL",    14,    831, AI_SKELSD,   3,         40,         50,                              RESIST_LIGHTNING | IMMUNE_NULL_40,        0,        0,        0, 0              },
	{  MT_RBLACK,   "Sir Gorash",               "GENERAL",    16,   1050, AI_SKELSD,   1,         20,         60,                                                 IMMUNE_NULL_40,        0,        0,        0, 0              },
	{  MT_CABALIST, "The Vizier",               "GENERAL",    15,    850, AI_COUNSLR,  2,         25,         40,                IMMUNE_FIRE                                    ,        3,        0,        0, 0              },
	{  MT_REALWEAV, "Zamphir",                  "GENERAL",    15,    891, AI_SKELSD,   2,         30,         50, IMMUNE_MAGIC | RESIST_FIRE | RESIST_LIGHTNING | IMMUNE_NULL_40,        3,        0,        0, 0              },
	{  MT_HLSPWN,   "Bloodlust",                "GENERAL",    15,    825, AI_SUCC,     1,         20,         55, IMMUNE_MAGIC |               IMMUNE_LIGHTNING | IMMUNE_NULL_40,        0,        0,        0, 0              },
	{  MT_HLSPWN,   "Webwidow",                 "GENERAL",    16,    774, AI_SUCC,     1,         20,         50, IMMUNE_MAGIC | IMMUNE_FIRE |                    IMMUNE_NULL_40,        0,        0,        0, 0              },
	{  MT_SOLBRNR,  "Fleshdancer",              "GENERAL",    16,    999, AI_SUCC,     3,         30,         50, IMMUNE_MAGIC | RESIST_FIRE |                    IMMUNE_NULL_40,        0,        0,        0, 0              },
	{  MT_OBLORD,   "Grimspike",                "GENERAL",    19,    534, AI_SNEAK,    1,         25,         40, IMMUNE_MAGIC | RESIST_FIRE |                    IMMUNE_NULL_40,        3,        0,        0, 0              },
	{  MT_STORML,   "Doomlock",                 "GENERAL",    28,    534, AI_SNEAK,    1,         35,         55, IMMUNE_MAGIC | RESIST_FIRE | RESIST_LIGHTNING | IMMUNE_NULL_40,        3,        0,        0, 0              },
	{  MT_INVALID,  NULL,                       NULL,          0,      0, AI_INVALID,  0,          0,          0, 0                                                             ,        0,        0,        0, 0              },
	// clang-format on
};

DEVILUTION_END_NAMESPACE
