/**
 * @file itemdat.cpp
 *
 * Implementation of all item data.
 */
#include "all.h"

DEVILUTION_BEGIN_NAMESPACE

/** Contains the data related to each item ID. */
ItemDataStruct AllItemsList[] = {
	// clang-format off
//_item_indexes        iRnd,          iClass,        iLoc,             iCurs,                             itype,        iItemId,            iName,                         iSName, iMinMLvl, iDurability, iMinDam, iMaxDam, iMinAC, iMaxAC, iMinStr, iMinMag, iMinDex, iFlags,            iMiscId,         iSpell,          iUsable, iValue, iMaxValue
/*IDI_GOLD       */ {  IDROP_REGULAR, ICLASS_GOLD,   ILOC_UNEQUIPABLE, ICURS_GOLD,                        ITYPE_GOLD,   UITYPE_NONE,        "Gold",                        NULL,          1,           0,       0,       0,      0,      0,       0,       0,       0, ISPL_NONE,         IMISC_NONE,      SPL_NULL,        TRUE,         0,         0 },
/*IDI_WARRIOR    */ {  IDROP_NEVER,   ICLASS_WEAPON, ILOC_ONEHAND,     ICURS_SHORT_SWORD,                 ITYPE_SWORD,  UITYPE_NONE,        "Short Sword",                 NULL,          2,          20,       2,       6,      0,      0,      18,       0,       0, ISPL_NONE,         IMISC_NONE,      SPL_NULL,        FALSE,       50,        50 },
/*IDI_WARRSHLD   */ {  IDROP_NEVER,   ICLASS_ARMOR,  ILOC_ONEHAND,     ICURS_BUCKLER,                     ITYPE_SHIELD, UITYPE_NONE,        "Buckler",                     NULL,          2,          10,       0,       0,      3,      3,       0,       0,       0, ISPL_NONE,         IMISC_NONE,      SPL_NULL,        FALSE,       50,        50 },
/*IDI_WARRCLUB   */ {  IDROP_NEVER,   ICLASS_WEAPON, ILOC_ONEHAND,     ICURS_CLUB,                        ITYPE_MACE,   UITYPE_SPIKCLUB,    "Club",                        NULL,          1,          20,       1,       6,      0,      0,       0,       0,       0, ISPL_NONE,         IMISC_NONE,      SPL_NULL,        FALSE,       20,        20 },
/*IDI_ROGUE      */ {  IDROP_NEVER,   ICLASS_WEAPON, ILOC_TWOHAND,     ICURS_SHORT_BOW,                   ITYPE_BOW,    UITYPE_NONE,        "Short Bow",                   NULL,          1,          30,       1,       4,      0,      0,       0,       0,       0, ISPL_NONE,         IMISC_NONE,      SPL_NULL,        FALSE,      100,       100 },
/*IDI_SORCERER   */ {  IDROP_NEVER,   ICLASS_WEAPON, ILOC_TWOHAND,     ICURS_SHORT_STAFF,                 ITYPE_STAFF,  UITYPE_NONE,        "Short Staff of Mana",         NULL,          1,          25,       2,       4,      0,      0,       0,      20,       0, ISPL_NONE,         IMISC_STAFF,     SPL_MANA,        FALSE,      520,       520 },
/*IDI_CLEAVER    */ {  IDROP_NEVER,   ICLASS_WEAPON, ILOC_TWOHAND,     ICURS_CLEAVER,                     ITYPE_AXE,    UITYPE_CLEAVER,     "Cleaver",                     NULL,         10,          10,       4,      24,      0,      0,       0,       0,       0, ISPL_NONE,         IMISC_UNIQUE,    SPL_NULL,        FALSE,     2000,      2000 },
/*IDI_SKCROWN    */ {  IDROP_NEVER,   ICLASS_ARMOR,  ILOC_HELM,        ICURS_THE_UNDEAD_CROWN,            ITYPE_HELM,   UITYPE_SKCROWN,     "The Undead Crown",            NULL,          0,          50,       0,       0,     15,     15,       0,       0,       0, ISPL_RNDSTEALLIFE, IMISC_UNIQUE,    SPL_NULL,        FALSE,    10000,     10000 },
/*IDI_INFRARING  */ {  IDROP_NEVER,   ICLASS_MISC,   ILOC_RING,        ICURS_EMPYREAN_BAND,               ITYPE_RING,   UITYPE_INFRARING,   "Empyrean Band",               NULL,          0,           0,       0,       0,      0,      0,       0,       0,       0, ISPL_NONE,         IMISC_UNIQUE,    SPL_NULL,        FALSE,     8000,      8000 },
/*IDI_ROCK       */ {  IDROP_NEVER,   ICLASS_QUEST,  ILOC_UNEQUIPABLE, ICURS_MAGIC_ROCK,                  ITYPE_MISC,   UITYPE_NONE,        "Magic Rock",                  NULL,          0,           0,       0,       0,      0,      0,       0,       0,       0, ISPL_NONE,         IMISC_NONE,      SPL_NULL,        FALSE,        0,         0 },
/*IDI_OPTAMULET  */ {  IDROP_NEVER,   ICLASS_MISC,   ILOC_AMULET,      ICURS_OPTIC_AMULET,                ITYPE_AMULET, UITYPE_OPTAMULET,   "Optic Amulet",                NULL,          0,           0,       0,       0,      0,      0,       0,       0,       0, ISPL_NONE,         IMISC_UNIQUE,    SPL_NULL,        FALSE,     5000,      5000 },
/*IDI_TRING      */ {  IDROP_NEVER,   ICLASS_MISC,   ILOC_RING,        ICURS_RING_OF_TRUTH,               ITYPE_RING,   UITYPE_TRING,       "Ring of Truth",               NULL,          0,           0,       0,       0,      0,      0,       0,       0,       0, ISPL_NONE,         IMISC_UNIQUE,    SPL_NULL,        FALSE,     1000,      1000 },
/*IDI_BANNER     */ {  IDROP_NEVER,   ICLASS_QUEST,  ILOC_UNEQUIPABLE, ICURS_TAVERN_SIGN,                 ITYPE_MISC,   UITYPE_NONE,        "Tavern Sign",                 NULL,          0,           0,       0,       0,      0,      0,       0,       0,       0, ISPL_NONE,         IMISC_NONE,      SPL_NULL,        FALSE,        0,         0 },
/*IDI_HARCREST   */ {  IDROP_NEVER,   ICLASS_ARMOR,  ILOC_HELM,        ICURS_HARLEQUIN_CREST,             ITYPE_HELM,   UITYPE_HARCREST,    "Harlequin Crest",             NULL,          0,          15,       0,       0,      0,      0,       0,       0,       0, ISPL_NONE,         IMISC_UNIQUE,    SPL_NULL,        FALSE,       15,        20 },
/*IDI_STEELVEIL  */ {  IDROP_NEVER,   ICLASS_ARMOR,  ILOC_HELM,        ICURS_VIEL_OF_STEEL,               ITYPE_HELM,   UITYPE_STEELVEIL,   "Veil of Steel",               NULL,          0,          60,       0,       0,     18,     18,       0,       0,       0, ISPL_NONE,         IMISC_UNIQUE,    SPL_NULL,        FALSE,        0,         0 },
/*IDI_GLDNELIX   */ {  IDROP_NEVER,   ICLASS_MISC,   ILOC_UNEQUIPABLE, ICURS_GOLDEN_ELIXIR,               ITYPE_MISC,   UITYPE_ELIXIR,      "Golden Elixir",               NULL,         15,           0,       0,       0,      0,      0,       0,       0,       0, ISPL_NONE,         IMISC_NONE,      SPL_NULL,        FALSE,        0,         0 },
/*IDI_ANVIL      */ {  IDROP_NEVER,   ICLASS_QUEST,  ILOC_UNEQUIPABLE, ICURS_ANVIL_OF_FURY,               ITYPE_MISC,   UITYPE_NONE,        "Anvil of Fury",               NULL,          0,           0,       0,       0,      0,      0,       0,       0,       0, ISPL_NONE,         IMISC_NONE,      SPL_NULL,        FALSE,        0,         0 },
/*IDI_MUSHROOM   */ {  IDROP_NEVER,   ICLASS_QUEST,  ILOC_UNEQUIPABLE, ICURS_BLACK_MUSHROOM,              ITYPE_MISC,   UITYPE_NONE,        "Black Mushroom",              NULL,          0,           0,       0,       0,      0,      0,       0,       0,       0, ISPL_NONE,         IMISC_NONE,      SPL_NULL,        FALSE,        0,         0 },
/*IDI_BRAIN      */ {  IDROP_NEVER,   ICLASS_QUEST,  ILOC_UNEQUIPABLE, ICURS_BRAIN,                       ITYPE_MISC,   UITYPE_NONE,        "Brain",                       NULL,          0,           0,       0,       0,      0,      0,       0,       0,       0, ISPL_NONE,         IMISC_NONE,      SPL_NULL,        FALSE,        0,         0 },
/*IDI_FUNGALTM   */ {  IDROP_NEVER,   ICLASS_QUEST,  ILOC_UNEQUIPABLE, ICURS_FUNGAL_TOME,                 ITYPE_MISC,   UITYPE_NONE,        "Fungal Tome",                 NULL,          0,           0,       0,       0,      0,      0,       0,       0,       0, ISPL_NONE,         IMISC_NONE,      SPL_NULL,        FALSE,        0,         0 },
/*IDI_SPECELIX   */ {  IDROP_NEVER,   ICLASS_MISC,   ILOC_UNEQUIPABLE, ICURS_SPECTRAL_ELIXIR,             ITYPE_MISC,   UITYPE_ELIXIR,      "Spectral Elixir",             NULL,         15,           0,       0,       0,      0,      0,       0,       0,       0, ISPL_NONE,         IMISC_SPECELIX,  SPL_NULL,        FALSE,        0,         0 },
/*IDI_BLDSTONE   */ {  IDROP_NEVER,   ICLASS_QUEST,  ILOC_UNEQUIPABLE, ICURS_BLOOD_STONE,                 ITYPE_MISC,   UITYPE_NONE,        "Blood Stone",                 NULL,          0,           0,       0,       0,      0,      0,       0,       0,       0, ISPL_NONE,         IMISC_NONE,      SPL_NULL,        FALSE,        0,         0 },
/*IDI_MAPOFDOOM  */ {  IDROP_NEVER,   ICLASS_QUEST,  ILOC_UNEQUIPABLE, ICURS_MAP_OF_THE_STARS,            ITYPE_MISC,   UITYPE_MAPOFDOOM,   "Cathedral Map",               NULL,          0,           0,       0,       0,      0,      0,       0,       0,       0, ISPL_NONE,         IMISC_MAPOFDOOM, SPL_NULL,        TRUE,         0,         0 },
/*IDI_EAR        */ {  IDROP_NEVER,   ICLASS_QUEST,  ILOC_UNEQUIPABLE, ICURS_EAR_SORCERER,                ITYPE_MISC,   UITYPE_NONE,        "Heart",                       NULL,          0,           0,       0,       0,      0,      0,       0,       0,       0, ISPL_NONE,         IMISC_EAR,       SPL_NULL,        FALSE,        0,         0 },
/*IDI_HEAL       */ {  IDROP_NEVER,   ICLASS_MISC,   ILOC_UNEQUIPABLE, ICURS_POTION_OF_HEALING,           ITYPE_MISC,   UITYPE_NONE,        "Potion of Healing",           NULL,          0,           0,       0,       0,      0,      0,       0,       0,       0, ISPL_NONE,         IMISC_HEAL,      SPL_NULL,        TRUE,        50,        50 },
/*IDI_MANA       */ {  IDROP_NEVER,   ICLASS_MISC,   ILOC_UNEQUIPABLE, ICURS_POTION_OF_MANA,              ITYPE_MISC,   UITYPE_NONE,        "Potion of Mana",              NULL,          0,           0,       0,       0,      0,      0,       0,       0,       0, ISPL_NONE,         IMISC_MANA,      SPL_NULL,        TRUE,        50,        50 },
/*IDI_IDENTIFY   */ {  IDROP_NEVER,   ICLASS_MISC,   ILOC_UNEQUIPABLE, ICURS_SCROLL_OF,                   ITYPE_MISC,   UITYPE_NONE,        "Scroll of Identify",          NULL,          1,           0,       0,       0,      0,      0,       0,       0,       0, ISPL_NONE,         IMISC_SCROLL,    SPL_IDENTIFY,    TRUE,       200,       200 },
/*IDI_PORTAL     */ {  IDROP_NEVER,   ICLASS_MISC,   ILOC_UNEQUIPABLE, ICURS_SCROLL_OF,                   ITYPE_MISC,   UITYPE_NONE,        "Scroll of Town Portal",       NULL,          4,           0,       0,       0,      0,      0,       0,       0,       0, ISPL_NONE,         IMISC_SCROLL,    SPL_TOWN,        TRUE,       200,       200 },
/*IDI_ARMOFVAL   */ {  IDROP_NEVER,   ICLASS_ARMOR,  ILOC_ARMOR,       ICURS_ARKAINES_VALOR,              ITYPE_MARMOR, UITYPE_ARMOFVAL,    "Arkaine's Valor",             NULL,          0,          40,       0,       0,      0,      0,       0,       0,       0, ISPL_NONE,         IMISC_UNIQUE,    SPL_NULL,        FALSE,        0,         0 },
/*IDI_FULLHEAL   */ {  IDROP_NEVER,   ICLASS_MISC,   ILOC_UNEQUIPABLE, ICURS_POTION_OF_FULL_HEALING,      ITYPE_MISC,   UITYPE_NONE,        "Potion of Full Healing",      NULL,          1,           0,       0,       0,      0,      0,       0,       0,       0, ISPL_NONE,         IMISC_FULLHEAL,  SPL_NULL,        TRUE,       150,       150 },
/*IDI_FULLMANA   */ {  IDROP_NEVER,   ICLASS_MISC,   ILOC_UNEQUIPABLE, ICURS_POTION_OF_FULL_MANA,         ITYPE_MISC,   UITYPE_NONE,        "Potion of Full Mana",         NULL,          1,           0,       0,       0,      0,      0,       0,       0,       0, ISPL_NONE,         IMISC_FULLMANA,  SPL_NULL,        TRUE,       150,       150 },
/*IDI_GRISWOLD   */ {  IDROP_NEVER,   ICLASS_WEAPON, ILOC_ONEHAND,     ICURS_BROAD_SWORD,                 ITYPE_SWORD,  UITYPE_GRISWOLD,    "Griswold's Edge",             NULL,          8,          50,       4,      12,      0,      0,      40,       0,       0, ISPL_NONE,         IMISC_UNIQUE,    SPL_NULL,        FALSE,      750,       750 },
/*IDI_LGTFORGE   */ {  IDROP_NEVER,   ICLASS_ARMOR,  ILOC_ARMOR,       ICURS_BOVINE,                      ITYPE_HARMOR, UITYPE_BOVINE,      "Bovine Plate",                NULL,          0,          40,       0,       0,      0,      0,      50,       0,       0, ISPL_NONE,         IMISC_UNIQUE,    SPL_NULL,        FALSE,        0,         0 },
/*IDI_LAZSTAFF   */ {  IDROP_NEVER,   ICLASS_MISC,   ILOC_UNEQUIPABLE, ICURS_STAFF_OF_LAZARUS,            ITYPE_MISC,   UITYPE_LAZSTAFF,    "Staff of Lazarus",            NULL,          0,           0,       0,       0,      0,      0,       0,       0,       0, ISPL_NONE,         IMISC_NONE,      SPL_NULL,        FALSE,        0,         0 },
/*IDI_RESURRECT  */ {  IDROP_NEVER,   ICLASS_MISC,   ILOC_UNEQUIPABLE, ICURS_SCROLL_OF,                   ITYPE_MISC,   UITYPE_NONE,        "Scroll of Resurrect",         NULL,          1,           0,       0,       0,      0,      0,       0,       0,       0, ISPL_NONE,         IMISC_SCROLLT,   SPL_RESURRECT,   TRUE,       250,       250 },
/*IDI_OIL        */ {  IDROP_NEVER,   ICLASS_MISC,   ILOC_UNEQUIPABLE, ICURS_OIL,                         ITYPE_MISC,   UITYPE_NONE,        "Blacksmith Oil",              NULL,          1,           0,       0,       0,      0,      0,       0,       0,       0, ISPL_NONE,         IMISC_OILBSMTH,  SPL_NULL,        TRUE,       100,       100 },
/*IDI_SHORTSTAFF */ {  IDROP_NEVER,   ICLASS_WEAPON, ILOC_TWOHAND,     ICURS_SHORT_STAFF,                 ITYPE_STAFF,  UITYPE_NONE,        "Short Staff",                 NULL,          1,          25,       2,       4,      0,      0,       0,       0,       0, ISPL_NONE,         IMISC_NONE,      SPL_NULL,        FALSE,       20,        20 },
/*IDI_BARDSWORD  */ {  IDROP_NEVER,   ICLASS_WEAPON, ILOC_ONEHAND,     ICURS_SHORT_SWORD,                 ITYPE_SWORD,  UITYPE_NONE,        "Sword",                       NULL,          2,           8,       1,       5,      0,      0,      15,       0,      20, ISPL_NONE,         IMISC_NONE,      SPL_NULL,        FALSE,       20,        20 },
/*IDI_BARDDAGGER */ {  IDROP_NEVER,   ICLASS_WEAPON, ILOC_ONEHAND,     ICURS_DAGGER,                      ITYPE_SWORD,  UITYPE_NONE,        "Dagger",                      NULL,          1,          16,       1,       4,      0,      0,       0,       0,       0, ISPL_NONE,         IMISC_NONE,      SPL_NULL,        FALSE,       20,        20 },
/*IDI_RUNEBOMB   */ {  IDROP_NEVER,   ICLASS_QUEST,  ILOC_UNEQUIPABLE, ICURS_RUNE_BOMB,                   ITYPE_MISC,   UITYPE_NONE,        "Rune Bomb",                   NULL,          0,           0,       0,       0,      0,      0,       0,       0,       0, ISPL_NONE,         IMISC_NONE,      SPL_NULL,        FALSE,        0,         0 },
/*IDI_THEODORE   */ {  IDROP_NEVER,   ICLASS_QUEST,  ILOC_UNEQUIPABLE, ICURS_THEODORE,                    ITYPE_MISC,   UITYPE_NONE,        "Theodore",                    NULL,          0,           0,       0,       0,      0,      0,       0,       0,       0, ISPL_NONE,         IMISC_NONE,      SPL_NULL,        FALSE,        0,         0 },
/*IDI_AURIC      */ {  IDROP_NEVER,   ICLASS_MISC,   ILOC_AMULET,      ICURS_AURIC_AMULET,                ITYPE_MISC,   UITYPE_NONE,        "Auric Amulet",                NULL,          0,           0,       0,       0,      0,      0,       0,       0,       0, ISPL_NONE,         IMISC_AURIC,     SPL_NULL,        FALSE,      100,       100 },
/*IDI_NOTE1      */ {  IDROP_NEVER,   ICLASS_QUEST,  ILOC_UNEQUIPABLE, ICURS_TORN_NOTE_1,                 ITYPE_MISC,   UITYPE_NONE,        "Torn Note 1",                 NULL,          0,           0,       0,       0,      0,      0,       0,       0,       0, ISPL_NONE,         IMISC_NONE,      SPL_NULL,        FALSE,        0,         0 },
/*IDI_NOTE2      */ {  IDROP_NEVER,   ICLASS_QUEST,  ILOC_UNEQUIPABLE, ICURS_TORN_NOTE_2,                 ITYPE_MISC,   UITYPE_NONE,        "Torn Note 2",                 NULL,          0,           0,       0,       0,      0,      0,       0,       0,       0, ISPL_NONE,         IMISC_NONE,      SPL_NULL,        FALSE,        0,         0 },
/*IDI_NOTE3      */ {  IDROP_NEVER,   ICLASS_QUEST,  ILOC_UNEQUIPABLE, ICURS_TORN_NOTE_3,                 ITYPE_MISC,   UITYPE_NONE,        "Torn Note 3",                 NULL,          0,           0,       0,       0,      0,      0,       0,       0,       0, ISPL_NONE,         IMISC_NONE,      SPL_NULL,        FALSE,        0,         0 },
/*IDI_FULLNOTE   */ {  IDROP_NEVER,   ICLASS_QUEST,  ILOC_UNEQUIPABLE, ICURS_RECONSTRUCTED_NOTE,          ITYPE_MISC,   UITYPE_NONE,        "Reconstructed Note",          NULL,          0,           0,       0,       0,      0,      0,       0,       0,       0, ISPL_NONE,         IMISC_NOTE,      SPL_NULL,        TRUE,         0,         0 },
/*IDI_BROWNSUIT  */ {  IDROP_NEVER,   ICLASS_QUEST,  ILOC_UNEQUIPABLE, ICURS_BROWN_SUIT,                  ITYPE_MISC,   UITYPE_NONE,        "Brown Suit",                  NULL,          0,           0,       0,       0,      0,      0,       0,       0,       0, ISPL_NONE,         IMISC_NONE,      SPL_NULL,        FALSE,        0,         0 },
/*IDI_GREYSUIT   */ {  IDROP_NEVER,   ICLASS_QUEST,  ILOC_UNEQUIPABLE, ICURS_GREY_SUIT,                   ITYPE_MISC,   UITYPE_NONE,        "Grey Suit",                   NULL,          0,           0,       0,       0,      0,      0,       0,       0,       0, ISPL_NONE,         IMISC_NONE,      SPL_NULL,        FALSE,        0,         0 },
/*               */ {  IDROP_REGULAR, ICLASS_ARMOR,  ILOC_HELM,        ICURS_CAP,                         ITYPE_HELM,   UITYPE_NONE,        "Cap",                         "Cap",         1,          15,       0,       0,      1,      3,       0,       0,       0, ISPL_NONE,         IMISC_NONE,      SPL_NULL,        FALSE,       15,        20 },
/*               */ {  IDROP_REGULAR, ICLASS_ARMOR,  ILOC_HELM,        ICURS_SKULL_CAP,                   ITYPE_HELM,   UITYPE_SKULLCAP,    "Skull Cap",                   "Cap",         4,          20,       0,       0,      2,      4,       0,       0,       0, ISPL_NONE,         IMISC_NONE,      SPL_NULL,        FALSE,       25,        30 },
/*               */ {  IDROP_REGULAR, ICLASS_ARMOR,  ILOC_HELM,        ICURS_HELM,                        ITYPE_HELM,   UITYPE_HELM,        "Helm",                        "Helm",        8,          30,       0,       0,      4,      6,      25,       0,       0, ISPL_NONE,         IMISC_NONE,      SPL_NULL,        FALSE,       40,        70 },
/*               */ {  IDROP_REGULAR, ICLASS_ARMOR,  ILOC_HELM,        ICURS_FULL_HELM,                   ITYPE_HELM,   UITYPE_NONE,        "Full Helm",                   "Helm",       12,          35,       0,       0,      6,      8,      35,       0,       0, ISPL_NONE,         IMISC_NONE,      SPL_NULL,        FALSE,       90,       130 },
/*               */ {  IDROP_REGULAR, ICLASS_ARMOR,  ILOC_HELM,        ICURS_CROWN,                       ITYPE_HELM,   UITYPE_CROWN,       "Crown",                       "Crown",      16,          40,       0,       0,      8,     12,       0,       0,       0, ISPL_NONE,         IMISC_NONE,      SPL_NULL,        FALSE,      200,       300 },
/*               */ {  IDROP_REGULAR, ICLASS_ARMOR,  ILOC_HELM,        ICURS_GREAT_HELM,                  ITYPE_HELM,   UITYPE_GREATHELM,   "Great Helm",                  "Helm",       20,          60,       0,       0,     10,     15,      50,       0,       0, ISPL_NONE,         IMISC_NONE,      SPL_NULL,        FALSE,      400,       500 },
/*               */ {  IDROP_REGULAR, ICLASS_ARMOR,  ILOC_ARMOR,       ICURS_CAPE,                        ITYPE_LARMOR, UITYPE_CAPE,        "Cape",                        "Cape",        1,          12,       0,       0,      1,      5,       0,       0,       0, ISPL_NONE,         IMISC_NONE,      SPL_NULL,        FALSE,       10,        50 },
/*               */ {  IDROP_REGULAR, ICLASS_ARMOR,  ILOC_ARMOR,       ICURS_RAGS,                        ITYPE_LARMOR, UITYPE_RAGS,        "Rags",                        "Rags",        1,           6,       0,       0,      2,      6,       0,       0,       0, ISPL_NONE,         IMISC_NONE,      SPL_NULL,        FALSE,        5,        25 },
/*               */ {  IDROP_REGULAR, ICLASS_ARMOR,  ILOC_ARMOR,       ICURS_CLOAK,                       ITYPE_LARMOR, UITYPE_CLOAK,       "Cloak",                       "Cloak",       2,          18,       0,       0,      3,      7,       0,       0,       0, ISPL_NONE,         IMISC_NONE,      SPL_NULL,        FALSE,       40,        70 },
/*               */ {  IDROP_REGULAR, ICLASS_ARMOR,  ILOC_ARMOR,       ICURS_ROBE,                        ITYPE_LARMOR, UITYPE_ROBE,        "Robe",                        "Robe",        3,          24,       0,       0,      4,      7,       0,       0,       0, ISPL_NONE,         IMISC_NONE,      SPL_NULL,        FALSE,       75,       125 },
/*               */ {  IDROP_REGULAR, ICLASS_ARMOR,  ILOC_ARMOR,       ICURS_QUILTED_ARMOR,               ITYPE_LARMOR, UITYPE_NONE,        "Quilted Armor",               "Armor",       4,          30,       0,       0,      7,     10,       0,       0,       0, ISPL_NONE,         IMISC_NONE,      SPL_NULL,        FALSE,      200,       300 },
/*               */ {  IDROP_REGULAR, ICLASS_ARMOR,  ILOC_ARMOR,       ICURS_LEATHER_ARMOR,               ITYPE_LARMOR, UITYPE_LEATHARMOR,  "Leather Armor",               "Armor",       6,          35,       0,       0,     10,     13,       0,       0,       0, ISPL_NONE,         IMISC_NONE,      SPL_NULL,        FALSE,      300,       400 },
/*               */ {  IDROP_REGULAR, ICLASS_ARMOR,  ILOC_ARMOR,       ICURS_HARD_LEATHER_ARMOR,          ITYPE_LARMOR, UITYPE_NONE,        "Hard Leather Armor",          "Armor",       7,          40,       0,       0,     11,     14,       0,       0,       0, ISPL_NONE,         IMISC_NONE,      SPL_NULL,        FALSE,      450,       550 },
/*               */ {  IDROP_REGULAR, ICLASS_ARMOR,  ILOC_ARMOR,       ICURS_STUDDED_LEATHER_ARMOR,       ITYPE_LARMOR, UITYPE_STUDARMOR,   "Studded Leather Armor",       "Armor",       9,          45,       0,       0,     15,     17,      20,       0,       0, ISPL_NONE,         IMISC_NONE,      SPL_NULL,        FALSE,      700,       800 },
/*               */ {  IDROP_REGULAR, ICLASS_ARMOR,  ILOC_ARMOR,       ICURS_RING_MAIL,                   ITYPE_MARMOR, UITYPE_NONE,        "Ring Mail",                   "Mail",       11,          50,       0,       0,     17,     20,      25,       0,       0, ISPL_NONE,         IMISC_NONE,      SPL_NULL,        FALSE,      900,      1100 },
/*               */ {  IDROP_REGULAR, ICLASS_ARMOR,  ILOC_ARMOR,       ICURS_CHAIN_MAIL,                  ITYPE_MARMOR, UITYPE_CHAINMAIL,   "Chain Mail",                  "Mail",       13,          55,       0,       0,     18,     22,      30,       0,       0, ISPL_NONE,         IMISC_NONE,      SPL_NULL,        FALSE,     1250,      1750 },
/*               */ {  IDROP_REGULAR, ICLASS_ARMOR,  ILOC_ARMOR,       ICURS_SCALE_MAIL,                  ITYPE_MARMOR, UITYPE_NONE,        "Scale Mail",                  "Mail",       15,          60,       0,       0,     23,     28,      35,       0,       0, ISPL_NONE,         IMISC_NONE,      SPL_NULL,        FALSE,     2300,      2800 },
/*               */ {  IDROP_REGULAR, ICLASS_ARMOR,  ILOC_ARMOR,       ICURS_BREAST_PLATE,                ITYPE_HARMOR, UITYPE_BREASTPLATE, "Breast Plate",                "Plate",      16,          80,       0,       0,     20,     24,      40,       0,       0, ISPL_NONE,         IMISC_NONE,      SPL_NULL,        FALSE,     2800,      3200 },
/*               */ {  IDROP_REGULAR, ICLASS_ARMOR,  ILOC_ARMOR,       ICURS_SPLINT_MAIL,                 ITYPE_MARMOR, UITYPE_NONE,        "Splint Mail",                 "Mail",       17,          65,       0,       0,     30,     35,      40,       0,       0, ISPL_NONE,         IMISC_NONE,      SPL_NULL,        FALSE,     3250,      3750 },
/*               */ {  IDROP_REGULAR, ICLASS_ARMOR,  ILOC_ARMOR,       ICURS_FIELD_PLATE,                 ITYPE_HARMOR, UITYPE_PLATEMAIL,   "Plate Mail",                  "Plate",      19,          75,       0,       0,     42,     50,      60,       0,       0, ISPL_NONE,         IMISC_NONE,      SPL_NULL,        FALSE,     4600,      5400 },
/*               */ {  IDROP_REGULAR, ICLASS_ARMOR,  ILOC_ARMOR,       ICURS_FIELD_PLATE,                 ITYPE_HARMOR, UITYPE_NONE,        "Field Plate",                 "Plate",      21,          80,       0,       0,     40,     45,      65,       0,       0, ISPL_NONE,         IMISC_NONE,      SPL_NULL,        FALSE,     5800,      6200 },
/*               */ {  IDROP_REGULAR, ICLASS_ARMOR,  ILOC_ARMOR,       ICURS_GOTHIC_PLATE,                ITYPE_HARMOR, UITYPE_NONE,        "Gothic Plate",                "Plate",      23,         100,       0,       0,     50,     60,      80,       0,       0, ISPL_NONE,         IMISC_NONE,      SPL_NULL,        FALSE,     8000,     10000 },
/*               */ {  IDROP_REGULAR, ICLASS_ARMOR,  ILOC_ARMOR,       ICURS_FULL_PLATE_MAIL,             ITYPE_HARMOR, UITYPE_FULLPLATE,   "Full Plate Mail",             "Plate",      25,          90,       0,       0,     60,     75,      90,       0,       0, ISPL_NONE,         IMISC_NONE,      SPL_NULL,        FALSE,     6500,      8000 },
/*               */ {  IDROP_REGULAR, ICLASS_ARMOR,  ILOC_ONEHAND,     ICURS_BUCKLER,                     ITYPE_SHIELD, UITYPE_BUCKLER,     "Buckler",                     "Shield",      1,          16,       0,       0,      1,      5,       0,       0,       0, ISPL_NONE,         IMISC_NONE,      SPL_NULL,        FALSE,       30,        70 },
/*               */ {  IDROP_REGULAR, ICLASS_ARMOR,  ILOC_ONEHAND,     ICURS_SMALL_SHIELD,                ITYPE_SHIELD, UITYPE_SMALLSHIELD, "Small Shield",                "Shield",      5,          24,       0,       0,      3,      8,      25,       0,       0, ISPL_NONE,         IMISC_NONE,      SPL_NULL,        FALSE,       90,       130 },
/*               */ {  IDROP_REGULAR, ICLASS_ARMOR,  ILOC_ONEHAND,     ICURS_LARGE_SHIELD,                ITYPE_SHIELD, UITYPE_LARGESHIELD, "Large Shield",                "Shield",      9,          32,       0,       0,      5,     10,      40,       0,       0, ISPL_NONE,         IMISC_NONE,      SPL_NULL,        FALSE,      200,       300 },
/*               */ {  IDROP_REGULAR, ICLASS_ARMOR,  ILOC_ONEHAND,     ICURS_KITE_SHIELD,                 ITYPE_SHIELD, UITYPE_KITESHIELD,  "Kite Shield",                 "Shield",     14,          40,       0,       0,      8,     15,      50,       0,       0, ISPL_NONE,         IMISC_NONE,      SPL_NULL,        FALSE,      400,       700 },
/*               */ {  IDROP_REGULAR, ICLASS_ARMOR,  ILOC_ONEHAND,     ICURS_TOWER_SHIELD,                ITYPE_SHIELD, UITYPE_GOTHSHIELD,  "Tower Shield",                "Shield",     20,          50,       0,       0,     12,     20,      60,       0,       0, ISPL_NONE,         IMISC_NONE,      SPL_NULL,        FALSE,      850,      1200 },
/*               */ {  IDROP_REGULAR, ICLASS_ARMOR,  ILOC_ONEHAND,     ICURS_GOTHIC_SHIELD,               ITYPE_SHIELD, UITYPE_GOTHSHIELD,  "Gothic Shield",               "Shield",     23,          60,       0,       0,     14,     18,      80,       0,       0, ISPL_NONE,         IMISC_NONE,      SPL_NULL,        FALSE,     2300,      2700 },
/*               */ {  IDROP_REGULAR, ICLASS_MISC,   ILOC_UNEQUIPABLE, ICURS_POTION_OF_HEALING,           ITYPE_MISC,   UITYPE_NONE,        "Potion of Healing",           NULL,          1,           0,       0,       0,      0,      0,       0,       0,       0, ISPL_NONE,         IMISC_HEAL,      SPL_NULL,        TRUE,        50,        50 },
/*               */ {  IDROP_REGULAR, ICLASS_MISC,   ILOC_UNEQUIPABLE, ICURS_POTION_OF_FULL_HEALING,      ITYPE_MISC,   UITYPE_NONE,        "Potion of Full Healing",      NULL,          1,           0,       0,       0,      0,      0,       0,       0,       0, ISPL_NONE,         IMISC_FULLHEAL,  SPL_NULL,        TRUE,       150,       150 },
/*               */ {  IDROP_REGULAR, ICLASS_MISC,   ILOC_UNEQUIPABLE, ICURS_POTION_OF_MANA,              ITYPE_MISC,   UITYPE_NONE,        "Potion of Mana",              NULL,          1,           0,       0,       0,      0,      0,       0,       0,       0, ISPL_NONE,         IMISC_MANA,      SPL_NULL,        TRUE,        50,        50 },
/*               */ {  IDROP_REGULAR, ICLASS_MISC,   ILOC_UNEQUIPABLE, ICURS_POTION_OF_FULL_MANA,         ITYPE_MISC,   UITYPE_NONE,        "Potion of Full Mana",         NULL,          1,           0,       0,       0,      0,      0,       0,       0,       0, ISPL_NONE,         IMISC_FULLMANA,  SPL_NULL,        TRUE,       150,       150 },
/*               */ {  IDROP_REGULAR, ICLASS_MISC,   ILOC_UNEQUIPABLE, ICURS_POTION_OF_REJUVENATION,      ITYPE_MISC,   UITYPE_NONE,        "Potion of Rejuvenation",      NULL,          3,           0,       0,       0,      0,      0,       0,       0,       0, ISPL_NONE,         IMISC_REJUV,     SPL_NULL,        TRUE,       120,       120 },
/*               */ {  IDROP_REGULAR, ICLASS_MISC,   ILOC_UNEQUIPABLE, ICURS_POTION_OF_FULL_REJUVENATION, ITYPE_MISC,   UITYPE_NONE,        "Potion of Full Rejuvenation", NULL,          7,           0,       0,       0,      0,      0,       0,       0,       0, ISPL_NONE,         IMISC_FULLREJUV, SPL_NULL,        TRUE,       600,       600 },
/*               */ {  IDROP_REGULAR, ICLASS_MISC,   ILOC_UNEQUIPABLE, ICURS_OIL,                         ITYPE_MISC,   UITYPE_NONE,        "Blacksmith Oil",              NULL,          1,           0,       0,       0,      0,      0,       0,       0,       0, ISPL_NONE,         IMISC_OILBSMTH,  SPL_NULL,        TRUE,       100,       100 },
/*               */ {  IDROP_REGULAR, ICLASS_MISC,   ILOC_UNEQUIPABLE, ICURS_OIL,                         ITYPE_MISC,   UITYPE_NONE,        "Oil of Accuracy",             NULL,          1,           0,       0,       0,      0,      0,       0,       0,       0, ISPL_NONE,         IMISC_OILACC,    SPL_NULL,        TRUE,       500,       500 },
/*               */ {  IDROP_REGULAR, ICLASS_MISC,   ILOC_UNEQUIPABLE, ICURS_OIL,                         ITYPE_MISC,   UITYPE_NONE,        "Oil of Sharpness",            NULL,          1,           0,       0,       0,      0,      0,       0,       0,       0, ISPL_NONE,         IMISC_OILSHARP,  SPL_NULL,        TRUE,       500,       500 },
/*               */ {  IDROP_REGULAR, ICLASS_MISC,   ILOC_UNEQUIPABLE, ICURS_OIL,                         ITYPE_MISC,   UITYPE_NONE,        "Oil",                         NULL,          10,          0,       0,       0,      0,      0,       0,       0,       0, ISPL_NONE,         IMISC_OILOF,     SPL_NULL,        TRUE,         0,         0 },
/*               */ {  IDROP_REGULAR, ICLASS_MISC,   ILOC_UNEQUIPABLE, ICURS_ELIXIR_OF_STRENGTH,          ITYPE_MISC,   UITYPE_NONE,        "Elixir of Strength",          NULL,         15,           0,       0,       0,      0,      0,       0,       0,       0, ISPL_NONE,         IMISC_ELIXSTR,   SPL_NULL,        TRUE,      5000,      5000 },
/*               */ {  IDROP_REGULAR, ICLASS_MISC,   ILOC_UNEQUIPABLE, ICURS_ELIXIR_OF_MAGIC,             ITYPE_MISC,   UITYPE_NONE,        "Elixir of Magic",             NULL,         15,           0,       0,       0,      0,      0,       0,       0,       0, ISPL_NONE,         IMISC_ELIXMAG,   SPL_NULL,        TRUE,      5000,      5000 },
/*               */ {  IDROP_REGULAR, ICLASS_MISC,   ILOC_UNEQUIPABLE, ICURS_ELIXIR_OF_DEXTERITY,         ITYPE_MISC,   UITYPE_NONE,        "Elixir of Dexterity",         NULL,         15,           0,       0,       0,      0,      0,       0,       0,       0, ISPL_NONE,         IMISC_ELIXDEX,   SPL_NULL,        TRUE,      5000,      5000 },
/*               */ {  IDROP_REGULAR, ICLASS_MISC,   ILOC_UNEQUIPABLE, ICURS_ELIXIR_OF_VITALITY,          ITYPE_MISC,   UITYPE_NONE,        "Elixir of Vitality",          NULL,         20,           0,       0,       0,      0,      0,       0,       0,       0, ISPL_NONE,         IMISC_ELIXVIT,   SPL_NULL,        TRUE,      5000,      5000 },
/*               */ {  IDROP_REGULAR, ICLASS_MISC,   ILOC_UNEQUIPABLE, ICURS_SCROLL_OF,                   ITYPE_MISC,   UITYPE_NONE,        "Scroll of Healing",           NULL,          1,           0,       0,       0,      0,      0,       0,       0,       0, ISPL_NONE,         IMISC_SCROLL,    SPL_HEAL,        TRUE,        50,        50 },
/*               */ {  IDROP_REGULAR, ICLASS_MISC,   ILOC_UNEQUIPABLE, ICURS_SCROLL_OF,                   ITYPE_MISC,   UITYPE_NONE,        "Scroll of Search",            NULL,          1,           0,       0,       0,      0,      0,       0,       0,       0, ISPL_NONE,         IMISC_SCROLL,    SPL_SEARCH,      TRUE,        50,        50 },
/*               */ {  IDROP_REGULAR, ICLASS_MISC,   ILOC_UNEQUIPABLE, ICURS_SCROLL_OF,                   ITYPE_MISC,   UITYPE_NONE,        "Scroll of Lightning",         NULL,          4,           0,       0,       0,      0,      0,       0,       0,       0, ISPL_NONE,         IMISC_SCROLLT,   SPL_LIGHTNING,   TRUE,       150,       150 },
/*               */ {  IDROP_REGULAR, ICLASS_MISC,   ILOC_UNEQUIPABLE, ICURS_SCROLL_OF,                   ITYPE_MISC,   UITYPE_NONE,        "Scroll of Identify",          NULL,          1,           0,       0,       0,      0,      0,       0,       0,       0, ISPL_NONE,         IMISC_SCROLL,    SPL_IDENTIFY,    TRUE,       100,       100 },
/*               */ {  IDROP_REGULAR, ICLASS_MISC,   ILOC_UNEQUIPABLE, ICURS_SCROLL_OF,                   ITYPE_MISC,   UITYPE_NONE,        "Scroll of Resurrect",         NULL,          1,           0,       0,       0,      0,      0,       0,       0,       0, ISPL_NONE,         IMISC_SCROLLT,   SPL_RESURRECT,   TRUE,       250,       250 },
/*               */ {  IDROP_REGULAR, ICLASS_MISC,   ILOC_UNEQUIPABLE, ICURS_SCROLL_OF,                   ITYPE_MISC,   UITYPE_NONE,        "Scroll of Fire Wall",         NULL,          4,           0,       0,       0,      0,      0,       0,      17,       0, ISPL_NONE,         IMISC_SCROLLT,   SPL_FIREWALL,    TRUE,       400,       400 },
/*               */ {  IDROP_REGULAR, ICLASS_MISC,   ILOC_UNEQUIPABLE, ICURS_SCROLL_OF,                   ITYPE_MISC,   UITYPE_NONE,        "Scroll of Inferno",           NULL,          1,           0,       0,       0,      0,      0,       0,      19,       0, ISPL_NONE,         IMISC_SCROLLT,   SPL_FLAME,       TRUE,       100,       100 },
/*               */ {  IDROP_REGULAR, ICLASS_MISC,   ILOC_UNEQUIPABLE, ICURS_SCROLL_OF,                   ITYPE_MISC,   UITYPE_NONE,        "Scroll of Town Portal",       NULL,          4,           0,       0,       0,      0,      0,       0,       0,       0, ISPL_NONE,         IMISC_SCROLL,    SPL_TOWN,        TRUE,       200,       200 },
/*               */ {  IDROP_REGULAR, ICLASS_MISC,   ILOC_UNEQUIPABLE, ICURS_SCROLL_OF,                   ITYPE_MISC,   UITYPE_NONE,        "Scroll of Flash",             NULL,          6,           0,       0,       0,      0,      0,       0,      21,       0, ISPL_NONE,         IMISC_SCROLLT,   SPL_FLASH,       TRUE,       500,       500 },
/*               */ {  IDROP_REGULAR, ICLASS_MISC,   ILOC_UNEQUIPABLE, ICURS_SCROLL_OF,                   ITYPE_MISC,   UITYPE_NONE,        "Scroll of Infravision",       NULL,          8,           0,       0,       0,      0,      0,       0,      23,       0, ISPL_NONE,         IMISC_SCROLL,    SPL_INFRA,       TRUE,       600,       600 },
/*               */ {  IDROP_REGULAR, ICLASS_MISC,   ILOC_UNEQUIPABLE, ICURS_SCROLL_OF,                   ITYPE_MISC,   UITYPE_NONE,        "Scroll of Phasing",           NULL,          6,           0,       0,       0,      0,      0,       0,      25,       0, ISPL_NONE,         IMISC_SCROLL,    SPL_RNDTELEPORT, TRUE,       200,       200 },
/*               */ {  IDROP_REGULAR, ICLASS_MISC,   ILOC_UNEQUIPABLE, ICURS_SCROLL_OF,                   ITYPE_MISC,   UITYPE_NONE,        "Scroll of Mana Shield",       NULL,          8,           0,       0,       0,      0,      0,       0,       0,       0, ISPL_NONE,         IMISC_SCROLL,    SPL_MANASHIELD,  TRUE,      1200,      1200 },
/*               */ {  IDROP_REGULAR, ICLASS_MISC,   ILOC_UNEQUIPABLE, ICURS_SCROLL_OF,                   ITYPE_MISC,   UITYPE_NONE,        "Scroll of Flame Wave",        NULL,         10,           0,       0,       0,      0,      0,       0,      29,       0, ISPL_NONE,         IMISC_SCROLLT,   SPL_WAVE,        TRUE,       650,       650 },
/*               */ {  IDROP_REGULAR, ICLASS_MISC,   ILOC_UNEQUIPABLE, ICURS_SCROLL_OF,                   ITYPE_MISC,   UITYPE_NONE,        "Scroll of Fireball",          NULL,          8,           0,       0,       0,      0,      0,       0,      31,       0, ISPL_NONE,         IMISC_SCROLLT,   SPL_FIREBALL,    TRUE,       300,       300 },
/*               */ {  IDROP_REGULAR, ICLASS_MISC,   ILOC_UNEQUIPABLE, ICURS_SCROLL_OF,                   ITYPE_MISC,   UITYPE_NONE,        "Scroll of Stone Curse",       NULL,          6,           0,       0,       0,      0,      0,       0,      33,       0, ISPL_NONE,         IMISC_SCROLLT,   SPL_STONE,       TRUE,       800,       800 },
/*               */ {  IDROP_REGULAR, ICLASS_MISC,   ILOC_UNEQUIPABLE, ICURS_SCROLL_OF,                   ITYPE_MISC,   UITYPE_NONE,        "Scroll of Chain Lightning",   NULL,         10,           0,       0,       0,      0,      0,       0,      35,       0, ISPL_NONE,         IMISC_SCROLLT,   SPL_CHAIN,       TRUE,       750,       750 },
/*               */ {  IDROP_REGULAR, ICLASS_MISC,   ILOC_UNEQUIPABLE, ICURS_SCROLL_OF,                   ITYPE_MISC,   UITYPE_NONE,        "Scroll of Guardian",          NULL,         12,           0,       0,       0,      0,      0,       0,      47,       0, ISPL_NONE,         IMISC_SCROLLT,   SPL_GUARDIAN,    TRUE,       950,       950 },
/*               */ {  IDROP_NEVER,   ICLASS_MISC,   ILOC_UNEQUIPABLE, ICURS_SCROLL_OF,                   ITYPE_MISC,   UITYPE_NONE,        "Non Item",                    NULL,          0,           0,       0,       0,      0,      0,       0,       0,       0, ISPL_NONE,         IMISC_NONE,      SPL_NULL,        FALSE,        0,         0 },
/*               */ {  IDROP_REGULAR, ICLASS_MISC,   ILOC_UNEQUIPABLE, ICURS_SCROLL_OF,                   ITYPE_MISC,   UITYPE_NONE,        "Scroll of Nova",              NULL,         14,           0,       0,       0,      0,      0,       0,      57,       0, ISPL_NONE,         IMISC_SCROLL,    SPL_NOVA,        TRUE,      1300,      1300 },
/*               */ {  IDROP_REGULAR, ICLASS_MISC,   ILOC_UNEQUIPABLE, ICURS_SCROLL_OF,                   ITYPE_MISC,   UITYPE_NONE,        "Scroll of Golem",             NULL,         10,           0,       0,       0,      0,      0,       0,      51,       0, ISPL_NONE,         IMISC_SCROLLT,   SPL_GOLEM,       TRUE,      1100,      1100 },
/*               */ {  IDROP_NEVER,   ICLASS_MISC,   ILOC_UNEQUIPABLE, ICURS_SCROLL_OF,                   ITYPE_MISC,   UITYPE_NONE,        "Scroll of None",              NULL,         99,           0,       0,       0,      0,      0,       0,      61,       0, ISPL_NONE,         IMISC_SCROLLT,   SPL_NULL,        TRUE,      1000,      1000 },
/*               */ {  IDROP_REGULAR, ICLASS_MISC,   ILOC_UNEQUIPABLE, ICURS_SCROLL_OF,                   ITYPE_MISC,   UITYPE_NONE,        "Scroll of Teleport",          NULL,         14,           0,       0,       0,      0,      0,       0,      81,       0, ISPL_NONE,         IMISC_SCROLL,    SPL_TELEPORT,    TRUE,      3000,      3000 },
/*               */ {  IDROP_REGULAR, ICLASS_MISC,   ILOC_UNEQUIPABLE, ICURS_SCROLL_OF,                   ITYPE_MISC,   UITYPE_NONE,        "Scroll of Apocalypse",        NULL,         22,           0,       0,       0,      0,      0,       0,     117,       0, ISPL_NONE,         IMISC_SCROLL,    SPL_APOCA,       TRUE,      2000,      2000 },
/*               */ {  IDROP_REGULAR, ICLASS_MISC,   ILOC_UNEQUIPABLE, ICURS_BOOK_BLUE,                   ITYPE_MISC,   UITYPE_NONE,        "Book of ",                    NULL,          2,           0,       0,       0,      0,      0,       0,       0,       0, ISPL_NONE,         IMISC_BOOK,      SPL_NULL,        TRUE,         0,         0 },
/*               */ {  IDROP_REGULAR, ICLASS_MISC,   ILOC_UNEQUIPABLE, ICURS_BOOK_BLUE,                   ITYPE_MISC,   UITYPE_NONE,        "Book of ",                    NULL,          8,           0,       0,       0,      0,      0,       0,       0,       0, ISPL_NONE,         IMISC_BOOK,      SPL_NULL,        TRUE,         0,         0 },
/*               */ {  IDROP_REGULAR, ICLASS_MISC,   ILOC_UNEQUIPABLE, ICURS_BOOK_BLUE,                   ITYPE_MISC,   UITYPE_NONE,        "Book of ",                    NULL,         14,           0,       0,       0,      0,      0,       0,       0,       0, ISPL_NONE,         IMISC_BOOK,      SPL_NULL,        TRUE,         0,         0 },
/*               */ {  IDROP_REGULAR, ICLASS_MISC,   ILOC_UNEQUIPABLE, ICURS_BOOK_BLUE,                   ITYPE_MISC,   UITYPE_NONE,        "Book of ",                    NULL,         20,           0,       0,       0,      0,      0,       0,       0,       0, ISPL_NONE,         IMISC_BOOK,      SPL_NULL,        TRUE,         0,         0 },
/*               */ {  IDROP_REGULAR, ICLASS_WEAPON, ILOC_ONEHAND,     ICURS_DAGGER,                      ITYPE_SWORD,  UITYPE_DAGGER,      "Dagger",                      "Dagger",      1,          16,       1,       4,      0,      0,       0,       0,       0, ISPL_NONE,         IMISC_NONE,      SPL_NULL,        FALSE,       60,        60 },
/*               */ {  IDROP_REGULAR, ICLASS_WEAPON, ILOC_ONEHAND,     ICURS_SHORT_SWORD,                 ITYPE_SWORD,  UITYPE_NONE,        "Short Sword",                 "Sword",       1,          24,       2,       6,      0,      0,      18,       0,       0, ISPL_NONE,         IMISC_NONE,      SPL_NULL,        FALSE,      120,       120 },
/*               */ {  IDROP_REGULAR, ICLASS_WEAPON, ILOC_ONEHAND,     ICURS_FALCHION,                    ITYPE_SWORD,  UITYPE_FALCHION,    "Falchion",                    "Sword",       2,          20,       4,       8,      0,      0,      30,       0,       0, ISPL_NONE,         IMISC_NONE,      SPL_NULL,        FALSE,      250,       250 },
/*               */ {  IDROP_REGULAR, ICLASS_WEAPON, ILOC_ONEHAND,     ICURS_SCIMITAR,                    ITYPE_SWORD,  UITYPE_SCIMITAR,    "Scimitar",                    "Sword",       4,          28,       3,       7,      0,      0,      23,       0,      23, ISPL_NONE,         IMISC_NONE,      SPL_NULL,        FALSE,      200,       200 },
/*               */ {  IDROP_REGULAR, ICLASS_WEAPON, ILOC_ONEHAND,     ICURS_CLAYMORE,                    ITYPE_SWORD,  UITYPE_CLAYMORE,    "Claymore",                    "Sword",       5,          36,       1,      12,      0,      0,      35,       0,       0, ISPL_NONE,         IMISC_NONE,      SPL_NULL,        FALSE,      450,       450 },
/*               */ {  IDROP_REGULAR, ICLASS_WEAPON, ILOC_ONEHAND,     ICURS_BLADE,                       ITYPE_SWORD,  UITYPE_NONE,        "Blade",                       "Blade",       4,          30,       3,       8,      0,      0,      25,       0,      30, ISPL_NONE,         IMISC_NONE,      SPL_NULL,        FALSE,      280,       280 },
/*               */ {  IDROP_REGULAR, ICLASS_WEAPON, ILOC_ONEHAND,     ICURS_SABRE,                       ITYPE_SWORD,  UITYPE_SABRE,       "Sabre",                       "Sabre",       1,          45,       1,       8,      0,      0,      17,       0,       0, ISPL_NONE,         IMISC_NONE,      SPL_NULL,        FALSE,      170,       170 },
/*               */ {  IDROP_REGULAR, ICLASS_WEAPON, ILOC_ONEHAND,     ICURS_LONG_SWORD,                  ITYPE_SWORD,  UITYPE_LONGSWR,     "Long Sword",                  "Sword",       6,          40,       2,      10,      0,      0,      30,       0,      30, ISPL_NONE,         IMISC_NONE,      SPL_NULL,        FALSE,      350,       350 },
/*               */ {  IDROP_REGULAR, ICLASS_WEAPON, ILOC_ONEHAND,     ICURS_BROAD_SWORD,                 ITYPE_SWORD,  UITYPE_BROADSWR,    "Broad Sword",                 "Sword",       8,          50,       4,      12,      0,      0,      40,       0,       0, ISPL_NONE,         IMISC_NONE,      SPL_NULL,        FALSE,      750,       750 },
/*               */ {  IDROP_REGULAR, ICLASS_WEAPON, ILOC_ONEHAND,     ICURS_BASTARD_SWORD,               ITYPE_SWORD,  UITYPE_BASTARDSWR,  "Bastard Sword",               "Sword",      10,          60,       6,      15,      0,      0,      50,       0,       0, ISPL_NONE,         IMISC_NONE,      SPL_NULL,        FALSE,     1000,      1000 },
/*               */ {  IDROP_REGULAR, ICLASS_WEAPON, ILOC_TWOHAND,     ICURS_TWO_HANDED_SWORD,            ITYPE_SWORD,  UITYPE_TWOHANDSWR,  "Two-Handed Sword",            "Sword",      14,          75,       8,      16,      0,      0,      65,       0,       0, ISPL_NONE,         IMISC_NONE,      SPL_NULL,        FALSE,     1800,      1800 },
/*               */ {  IDROP_REGULAR, ICLASS_WEAPON, ILOC_TWOHAND,     ICURS_GREAT_SWORD,                 ITYPE_SWORD,  UITYPE_GREATSWR,    "Great Sword",                 "Sword",      17,         100,      10,      20,      0,      0,      75,       0,       0, ISPL_NONE,         IMISC_NONE,      SPL_NULL,        FALSE,     3000,      3000 },
/*               */ {  IDROP_REGULAR, ICLASS_WEAPON, ILOC_TWOHAND,     ICURS_SMALL_AXE,                   ITYPE_AXE,    UITYPE_SMALLAXE,    "Small Axe",                   "Axe",         2,          24,       2,      10,      0,      0,       0,       0,       0, ISPL_NONE,         IMISC_NONE,      SPL_NULL,        FALSE,      150,       150 },
/*               */ {  IDROP_REGULAR, ICLASS_WEAPON, ILOC_TWOHAND,     ICURS_AXE,                         ITYPE_AXE,    UITYPE_NONE,        "Axe",                         "Axe",         4,          32,       4,      12,      0,      0,      22,       0,       0, ISPL_NONE,         IMISC_NONE,      SPL_NULL,        FALSE,      450,       450 },
/*               */ {  IDROP_REGULAR, ICLASS_WEAPON, ILOC_TWOHAND,     ICURS_LARGE_AXE,                   ITYPE_AXE,    UITYPE_LARGEAXE,    "Large Axe",                   "Axe",         6,          40,       6,      16,      0,      0,      30,       0,       0, ISPL_NONE,         IMISC_NONE,      SPL_NULL,        FALSE,      750,       750 },
/*               */ {  IDROP_REGULAR, ICLASS_WEAPON, ILOC_TWOHAND,     ICURS_BROAD_AXE,                   ITYPE_AXE,    UITYPE_BROADAXE,    "Broad Axe",                   "Axe",         8,          50,       8,      20,      0,      0,      50,       0,       0, ISPL_NONE,         IMISC_NONE,      SPL_NULL,        FALSE,     1000,      1000 },
/*               */ {  IDROP_REGULAR, ICLASS_WEAPON, ILOC_TWOHAND,     ICURS_BATTLE_AXE,                  ITYPE_AXE,    UITYPE_BATTLEAXE,   "Battle Axe",                  "Axe",        10,          60,      10,      25,      0,      0,      65,       0,       0, ISPL_NONE,         IMISC_NONE,      SPL_NULL,        FALSE,     1500,      1500 },
/*               */ {  IDROP_REGULAR, ICLASS_WEAPON, ILOC_TWOHAND,     ICURS_GREAT_AXE,                   ITYPE_AXE,    UITYPE_GREATAXE,    "Great Axe",                   "Axe",        12,          75,      12,      30,      0,      0,      80,       0,       0, ISPL_NONE,         IMISC_NONE,      SPL_NULL,        FALSE,     2500,      2500 },
/*               */ {  IDROP_REGULAR, ICLASS_WEAPON, ILOC_ONEHAND,     ICURS_MACE,                        ITYPE_MACE,   UITYPE_MACE,        "Mace",                        "Mace",        2,          32,       1,       8,      0,      0,      16,       0,       0, ISPL_NONE,         IMISC_NONE,      SPL_NULL,        FALSE,      200,       200 },
/*               */ {  IDROP_REGULAR, ICLASS_WEAPON, ILOC_ONEHAND,     ICURS_MORNING_STAR,                ITYPE_MACE,   UITYPE_MORNSTAR,    "Morning Star",                "Mace",        3,          40,       1,      10,      0,      0,      26,       0,       0, ISPL_NONE,         IMISC_NONE,      SPL_NULL,        FALSE,      300,       300 },
/*               */ {  IDROP_REGULAR, ICLASS_WEAPON, ILOC_ONEHAND,     ICURS_WAR_HAMMER,                  ITYPE_MACE,   UITYPE_WARHAMMER,   "War Hammer",                  "Hammer",      5,          50,       5,       9,      0,      0,      40,       0,       0, ISPL_NONE,         IMISC_NONE,      SPL_NULL,        FALSE,      600,       600 },
/*               */ {  IDROP_REGULAR, ICLASS_WEAPON, ILOC_ONEHAND,     ICURS_SPIKED_CLUB,                 ITYPE_MACE,   UITYPE_SPIKCLUB,    "Spiked Club",                 "Club",        4,          20,       3,       6,      0,      0,      18,       0,       0, ISPL_NONE,         IMISC_NONE,      SPL_NULL,        FALSE,      225,       225 },
/*               */ {  IDROP_REGULAR, ICLASS_WEAPON, ILOC_ONEHAND,     ICURS_CLUB,                        ITYPE_MACE,   UITYPE_SPIKCLUB,    "Club",                        "Club",        1,          20,       1,       6,      0,      0,       0,       0,       0, ISPL_NONE,         IMISC_NONE,      SPL_NULL,        FALSE,       20,        20 },
/*               */ {  IDROP_REGULAR, ICLASS_WEAPON, ILOC_ONEHAND,     ICURS_FLAIL,                       ITYPE_MACE,   UITYPE_FLAIL,       "Flail",                       "Flail",       7,          36,       2,      12,      0,      0,      30,       0,       0, ISPL_NONE,         IMISC_NONE,      SPL_NULL,        FALSE,      500,       500 },
/*               */ {  IDROP_REGULAR, ICLASS_WEAPON, ILOC_TWOHAND,     ICURS_MAUL,                        ITYPE_MACE,   UITYPE_MAUL,        "Maul",                        "Maul",       10,          50,       6,      20,      0,      0,      55,       0,       0, ISPL_NONE,         IMISC_NONE,      SPL_NULL,        FALSE,      900,       900 },
/*               */ {  IDROP_DOUBLE,  ICLASS_WEAPON, ILOC_TWOHAND,     ICURS_SHORT_BOW,                   ITYPE_BOW,    UITYPE_SHORTBOW,    "Short Bow",                   "Bow",         1,          30,       1,       4,      0,      0,       0,       0,       0, ISPL_NONE,         IMISC_NONE,      SPL_NULL,        FALSE,      100,       100 },
/*               */ {  IDROP_DOUBLE,  ICLASS_WEAPON, ILOC_TWOHAND,     ICURS_HUNTERS_BOW,                 ITYPE_BOW,    UITYPE_HUNTBOW,     "Hunter's Bow",                "Bow",         3,          40,       2,       5,      0,      0,      20,       0,      35, ISPL_NONE,         IMISC_NONE,      SPL_NULL,        FALSE,      350,       350 },
/*               */ {  IDROP_DOUBLE,  ICLASS_WEAPON, ILOC_TWOHAND,     ICURS_HUNTERS_BOW,                 ITYPE_BOW,    UITYPE_LONGBOW,     "Long Bow",                    "Bow",         5,          35,       1,       6,      0,      0,      25,       0,      30, ISPL_NONE,         IMISC_NONE,      SPL_NULL,        FALSE,      250,       250 },
/*               */ {  IDROP_DOUBLE,  ICLASS_WEAPON, ILOC_TWOHAND,     ICURS_COMPOSITE_BOW,               ITYPE_BOW,    UITYPE_COMPBOW,     "Composite Bow",               "Bow",         7,          45,       3,       6,      0,      0,      25,       0,      40, ISPL_NONE,         IMISC_NONE,      SPL_NULL,        FALSE,      600,       600 },
/*               */ {  IDROP_DOUBLE,  ICLASS_WEAPON, ILOC_TWOHAND,     ICURS_SHORT_BATTLE_BOW,            ITYPE_BOW,    UITYPE_NONE,        "Short Battle Bow",            "Bow",         9,          45,       3,       7,      0,      0,      30,       0,      50, ISPL_NONE,         IMISC_NONE,      SPL_NULL,        FALSE,      750,       750 },
/*               */ {  IDROP_DOUBLE,  ICLASS_WEAPON, ILOC_TWOHAND,     ICURS_LONG_WAR_BOW,                ITYPE_BOW,    UITYPE_BATTLEBOW,   "Long Battle Bow",             "Bow",        11,          50,       1,      10,      0,      0,      30,       0,      60, ISPL_NONE,         IMISC_NONE,      SPL_NULL,        FALSE,     1000,      1000 },
/*               */ {  IDROP_DOUBLE,  ICLASS_WEAPON, ILOC_TWOHAND,     ICURS_SHORT_WAR_BOW,               ITYPE_BOW,    UITYPE_NONE,        "Short War Bow",               "Bow",        15,          55,       4,       8,      0,      0,      35,       0,      70, ISPL_NONE,         IMISC_NONE,      SPL_NULL,        FALSE,     1500,      1500 },
/*               */ {  IDROP_DOUBLE,  ICLASS_WEAPON, ILOC_TWOHAND,     ICURS_LONG_WAR_BOW,                ITYPE_BOW,    UITYPE_WARBOW,      "Long War Bow",                "Bow",        19,          60,       1,      14,      0,      0,      45,       0,      80, ISPL_NONE,         IMISC_NONE,      SPL_NULL,        FALSE,     2000,      2000 },
/*               */ {  IDROP_REGULAR, ICLASS_WEAPON, ILOC_TWOHAND,     ICURS_SHORT_STAFF,                 ITYPE_STAFF,  UITYPE_SHORTSTAFF,  "Short Staff",                 "Staff",       1,          25,       2,       4,      0,      0,       0,       0,       0, ISPL_NONE,         IMISC_STAFF,     SPL_NULL,        FALSE,       30,        30 },
/*               */ {  IDROP_REGULAR, ICLASS_WEAPON, ILOC_TWOHAND,     ICURS_LONG_STAFF,                  ITYPE_STAFF,  UITYPE_LONGSTAFF,   "Long Staff",                  "Staff",       4,          35,       4,       8,      0,      0,       0,       0,       0, ISPL_NONE,         IMISC_STAFF,     SPL_NULL,        FALSE,      100,       100 },
/*               */ {  IDROP_REGULAR, ICLASS_WEAPON, ILOC_TWOHAND,     ICURS_COMPOSITE_STAFF,             ITYPE_STAFF,  UITYPE_COMPSTAFF,   "Composite Staff",             "Staff",       6,          45,       5,      10,      0,      0,       0,       0,       0, ISPL_NONE,         IMISC_STAFF,     SPL_NULL,        FALSE,      500,       500 },
/*               */ {  IDROP_REGULAR, ICLASS_WEAPON, ILOC_TWOHAND,     ICURS_SHORT_STAFF,                 ITYPE_STAFF,  UITYPE_QUARSTAFF,   "Quarter Staff",               "Staff",       9,          55,       6,      12,      0,      0,      20,       0,       0, ISPL_NONE,         IMISC_STAFF,     SPL_NULL,        FALSE,     1000,      1000 },
/*               */ {  IDROP_REGULAR, ICLASS_WEAPON, ILOC_TWOHAND,     ICURS_WAR_STAFF,                   ITYPE_STAFF,  UITYPE_WARSTAFF,    "War Staff",                   "Staff",      12,          75,       8,      16,      0,      0,      30,       0,       0, ISPL_NONE,         IMISC_STAFF,     SPL_NULL,        FALSE,     1500,      1500 },
/*               */ {  IDROP_REGULAR, ICLASS_MISC,   ILOC_RING,        ICURS_RING,                        ITYPE_RING,   UITYPE_RING,        "Ring",                        "Ring",        5,           0,       0,       0,      0,      0,       0,       0,       0, ISPL_NONE,         IMISC_RING,      SPL_NULL,        FALSE,     1000,      1000 },
/*               */ {  IDROP_REGULAR, ICLASS_MISC,   ILOC_RING,        ICURS_RING,                        ITYPE_RING,   UITYPE_RING,        "Ring",                        "Ring",       10,           0,       0,       0,      0,      0,       0,       0,       0, ISPL_NONE,         IMISC_RING,      SPL_NULL,        FALSE,     1000,      1000 },
/*               */ {  IDROP_REGULAR, ICLASS_MISC,   ILOC_RING,        ICURS_RING,                        ITYPE_RING,   UITYPE_RING,        "Ring",                        "Ring",       15,           0,       0,       0,      0,      0,       0,       0,       0, ISPL_NONE,         IMISC_RING,      SPL_NULL,        FALSE,     1000,      1000 },
/*               */ {  IDROP_REGULAR, ICLASS_MISC,   ILOC_AMULET,      ICURS_AMULET,                      ITYPE_AMULET, UITYPE_AMULET,      "Amulet",                      "Amulet",      8,           0,       0,       0,      0,      0,       0,       0,       0, ISPL_NONE,         IMISC_AMULET,    SPL_NULL,        FALSE,     1200,      1200 },
/*               */ {  IDROP_REGULAR, ICLASS_MISC,   ILOC_AMULET,      ICURS_AMULET,                      ITYPE_AMULET, UITYPE_AMULET,      "Amulet",                      "Amulet",     16,           0,       0,       0,      0,      0,       0,       0,       0, ISPL_NONE,         IMISC_AMULET,    SPL_NULL,        FALSE,     1200,      1200 },
/*               */ {  IDROP_REGULAR, ICLASS_MISC,   ILOC_UNEQUIPABLE, ICURS_RUNE_OF_FIRE,                ITYPE_MISC,   UITYPE_NONE,        "Rune of Fire",                "Rune",        1,           0,       0,       0,      0,      0,       0,       0,       0, ISPL_NONE,         IMISC_RUNEF,     SPL_NULL,         TRUE,      100,       100 },
/*               */ {  IDROP_REGULAR, ICLASS_MISC,   ILOC_UNEQUIPABLE, ICURS_RUNE_OF_LIGHTNING,           ITYPE_MISC,   UITYPE_NONE,        "Rune of Lightning",           "Rune",        3,           0,       0,       0,      0,      0,       0,      13,       0, ISPL_NONE,         IMISC_RUNEL,     SPL_NULL,         TRUE,      200,       200 },
/*               */ {  IDROP_REGULAR, ICLASS_MISC,   ILOC_UNEQUIPABLE, ICURS_GREATER_RUNE_OF_FIRE,        ITYPE_MISC,   UITYPE_NONE,        "Greater Rune of Fire",        "Rune",        7,           0,       0,       0,      0,      0,       0,      42,       0, ISPL_NONE,         IMISC_GR_RUNEF,  SPL_NULL,         TRUE,      400,       400 },
/*               */ {  IDROP_REGULAR, ICLASS_MISC,   ILOC_UNEQUIPABLE, ICURS_GREATER_RUNE_OF_LIGHTNING,   ITYPE_MISC,   UITYPE_NONE,        "Greater Rune of Lightning",   "Rune",        7,           0,       0,       0,      0,      0,       0,      42,       0, ISPL_NONE,         IMISC_GR_RUNEL,  SPL_NULL,         TRUE,      500,       500 },
/*               */ {  IDROP_REGULAR, ICLASS_MISC,   ILOC_UNEQUIPABLE, ICURS_RUNE_OF_STONE,               ITYPE_MISC,   UITYPE_NONE,        "Rune of Stone",               "Rune",        7,           0,       0,       0,      0,      0,       0,      25,       0, ISPL_NONE,         IMISC_RUNES,     SPL_NULL,         TRUE,      300,       300 },
/*IDI_SORCERER   */ {  IDROP_NEVER,   ICLASS_WEAPON, ILOC_TWOHAND,     ICURS_SHORT_STAFF,                 ITYPE_STAFF,  UITYPE_NONE,        "Short Staff of Charged Bolt", NULL,          1,          25,       2,       4,      0,      0,       0,      20,       0, ISPL_NONE,         IMISC_STAFF,     SPL_CBOLT,       FALSE,      520,       520 },
/*               */ {  IDROP_NEVER,   ICLASS_NONE,   ILOC_INVALID,     ICURS_POTION_OF_FULL_MANA,         ITYPE_MISC,   UITYPE_NONE,        NULL,                          NULL,          0,           0,       0,       0,      0,      0,       0,       0,       0, ISPL_NONE,         IMISC_NONE,      SPL_NULL,        FALSE,        0,         0 },
	// clang-format on
};

/** Contains the data related to each item prefix. */
const PLStruct PL_Prefix[] = {
	// clang-format off
	// PLName,          PLPower,         PLParam1, PLParam2, PLMinLvl, PLIType,                                                          PLGOE,    PLDouble, PLOk,  PLMinVal, PLMaxVal, PLMultVal
	{ "Tin",            IPL_TOHIT_CURSE,        6,       10,        3,                       PLT_WEAP |             PLT_BOW | PLT_MISC,  GOE_ANY,  TRUE,     FALSE,        0,        0,        -3 },
	{ "Brass",          IPL_TOHIT_CURSE,        1,        5,        1,                       PLT_WEAP |             PLT_BOW | PLT_MISC,  GOE_ANY,  TRUE,     FALSE,        0,        0,        -2 },
	{ "Bronze",         IPL_TOHIT,              1,        5,        1,                       PLT_WEAP |             PLT_BOW | PLT_MISC,  GOE_ANY,  TRUE,     TRUE,       100,      500,         2 },
	{ "Iron",           IPL_TOHIT,              6,       10,        4,                       PLT_WEAP |             PLT_BOW | PLT_MISC,  GOE_ANY,  TRUE,     TRUE,       600,     1000,         3 },
	{ "Steel",          IPL_TOHIT,             11,       15,        6,                       PLT_WEAP |             PLT_BOW | PLT_MISC,  GOE_ANY,  TRUE,     TRUE,      1100,     1500,         5 },
	{ "Silver",         IPL_TOHIT,             16,       20,        9,                       PLT_WEAP |             PLT_BOW | PLT_MISC,  GOE_GOOD, TRUE,     TRUE,      1600,     2000,         7 },
	{ "Gold",           IPL_TOHIT,             21,       30,       12,                       PLT_WEAP |             PLT_BOW | PLT_MISC,  GOE_GOOD, TRUE,     TRUE,      2100,     3000,         9 },
	{ "Platinum",       IPL_TOHIT,             31,       40,       16,                       PLT_WEAP |             PLT_BOW           ,  GOE_GOOD, TRUE,     TRUE,      3100,     4000,        11 },
	{ "Mithril",        IPL_TOHIT,             41,       60,       20,                       PLT_WEAP |             PLT_BOW           ,  GOE_GOOD, TRUE,     TRUE,      4100,     6000,        13 },
	{ "Meteoric",       IPL_TOHIT,             61,       80,       23,                       PLT_WEAP |             PLT_BOW           ,  GOE_ANY,  TRUE,     TRUE,      6100,    10000,        15 },
	{ "Weird",          IPL_TOHIT,             81,      100,       35,                       PLT_WEAP |             PLT_BOW           ,  GOE_ANY,  TRUE,     TRUE,     10100,    14000,        17 },
	{ "Strange",        IPL_TOHIT,            101,      150,       60,                       PLT_WEAP |             PLT_BOW           ,  GOE_ANY,  TRUE,     TRUE,     14100,    20000,        20 },
	{ "Useless",        IPL_DAMP_CURSE,       100,      100,        5,                       PLT_WEAP | PLT_STAFF | PLT_BOW           ,  GOE_ANY,  TRUE,     FALSE,        0,        0,        -8 },
	{ "Bent",           IPL_DAMP_CURSE,        50,       75,        3,                       PLT_WEAP | PLT_STAFF | PLT_BOW           ,  GOE_ANY,  TRUE,     FALSE,        0,        0,        -4 },
	{ "Weak",           IPL_DAMP_CURSE,        25,       45,        1,                       PLT_WEAP | PLT_STAFF | PLT_BOW           ,  GOE_ANY,  TRUE,     FALSE,        0,        0,        -3 },
	{ "Jagged",         IPL_DAMP,              20,       35,        4,                       PLT_WEAP | PLT_STAFF | PLT_BOW           ,  GOE_ANY,  TRUE,     TRUE,       250,      450,         3 },
	{ "Deadly",         IPL_DAMP,              36,       50,        6,                       PLT_WEAP | PLT_STAFF | PLT_BOW           ,  GOE_ANY,  TRUE,     TRUE,       500,      700,         4 },
	{ "Heavy",          IPL_DAMP,              51,       65,        9,                       PLT_WEAP | PLT_STAFF | PLT_BOW           ,  GOE_ANY,  TRUE,     TRUE,       750,      950,         5 },
	{ "Vicious",        IPL_DAMP,              66,       80,       12,                       PLT_WEAP | PLT_STAFF | PLT_BOW           ,  GOE_EVIL, TRUE,     TRUE,      1000,     1450,         8 },
	{ "Brutal",         IPL_DAMP,              81,       95,       16,                       PLT_WEAP | PLT_STAFF | PLT_BOW           ,  GOE_ANY,  TRUE,     TRUE,      1500,     1950,        10 },
	{ "Massive",        IPL_DAMP,              96,      110,       20,                       PLT_WEAP | PLT_STAFF | PLT_BOW           ,  GOE_ANY,  TRUE,     TRUE,      2000,     2450,        13 },
	{ "Savage",         IPL_DAMP,             111,      125,       23,                       PLT_WEAP |             PLT_BOW           ,  GOE_ANY,  TRUE,     TRUE,      2500,     3000,        15 },
	{ "Ruthless",       IPL_DAMP,             126,      150,       35,                       PLT_WEAP |             PLT_BOW           ,  GOE_ANY,  TRUE,     TRUE,     10100,    15000,        17 },
	{ "Merciless",      IPL_DAMP,             151,      175,       60,                       PLT_WEAP |             PLT_BOW           ,  GOE_ANY,  TRUE,     TRUE,     15000,    20000,        20 },
	{ "Clumsy",         IPL_TOHIT_DAMP_CURSE,  50,       75,        5,                       PLT_WEAP | PLT_STAFF | PLT_BOW           ,  GOE_ANY,  TRUE,     FALSE,        0,        0,        -7 },
	{ "Dull",           IPL_TOHIT_DAMP_CURSE,  25,       45,        1,                       PLT_WEAP | PLT_STAFF | PLT_BOW           ,  GOE_ANY,  TRUE,     FALSE,        0,        0,        -5 },
	{ "Sharp",          IPL_TOHIT_DAMP,        20,       35,        1,                       PLT_WEAP | PLT_STAFF | PLT_BOW           ,  GOE_ANY,  TRUE,     FALSE,      350,      950,         5 },
	{ "Fine",           IPL_TOHIT_DAMP,        36,       50,        6,                       PLT_WEAP | PLT_STAFF | PLT_BOW           ,  GOE_ANY,  TRUE,     TRUE,      1100,     1700,         7 },
	{ "Warrior's",      IPL_TOHIT_DAMP,        51,       65,       10,                       PLT_WEAP | PLT_STAFF | PLT_BOW           ,  GOE_ANY,  TRUE,     TRUE,      1850,     2450,        13 },
	{ "Soldier's",      IPL_TOHIT_DAMP,        66,       80,       15,                       PLT_WEAP | PLT_STAFF                     ,  GOE_ANY,  TRUE,     TRUE,      2600,     3950,        17 },
	{ "Lord's",         IPL_TOHIT_DAMP,        81,       95,       19,                       PLT_WEAP | PLT_STAFF                     ,  GOE_ANY,  TRUE,     TRUE,      4100,     5950,        21 },
	{ "Knight's",       IPL_TOHIT_DAMP,        96,      110,       23,                       PLT_WEAP | PLT_STAFF                     ,  GOE_ANY,  TRUE,     TRUE,      6100,     8450,        26 },
	{ "Master's",       IPL_TOHIT_DAMP,       111,      125,       28,                       PLT_WEAP | PLT_STAFF                     ,  GOE_ANY,  TRUE,     TRUE,      8600,    13000,        30 },
	{ "Champion's",     IPL_TOHIT_DAMP,       126,      150,       40,                       PLT_WEAP | PLT_STAFF                     ,  GOE_ANY,  TRUE,     TRUE,     15200,    24000,        33 },
	{ "King's",         IPL_TOHIT_DAMP,       151,      175,       28,                       PLT_WEAP | PLT_STAFF                     ,  GOE_ANY,  TRUE,     TRUE,     24100,    35000,        38 },
	{ "Vulnerable",     IPL_ACP_CURSE,         51,      100,        3, PLT_ARMO | PLT_SHLD                                            ,  GOE_ANY,  TRUE,     FALSE,        0,        0,        -3 },
	{ "Rusted",         IPL_ACP_CURSE,         25,       50,        1, PLT_ARMO | PLT_SHLD                                            ,  GOE_ANY,  TRUE,     FALSE,        0,        0,        -2 },
	{ "Fine",           IPL_ACP,               20,       30,        1, PLT_ARMO | PLT_SHLD                                            ,  GOE_ANY,  TRUE,     TRUE,        20,      100,         2 },
	{ "Strong",         IPL_ACP,               31,       40,        3, PLT_ARMO | PLT_SHLD                                            ,  GOE_ANY,  TRUE,     TRUE,       120,      200,         3 },
	{ "Grand",          IPL_ACP,               41,       55,        6, PLT_ARMO | PLT_SHLD                                            ,  GOE_ANY,  TRUE,     TRUE,       220,      300,         5 },
	{ "Valiant",        IPL_ACP,               56,       70,       10, PLT_ARMO | PLT_SHLD                                            ,  GOE_ANY,  TRUE,     TRUE,       320,      400,         7 },
	{ "Glorious",       IPL_ACP,               71,       90,       14, PLT_ARMO | PLT_SHLD                                            ,  GOE_GOOD, TRUE,     TRUE,       420,      600,         9 },
	{ "Blessed",        IPL_ACP,               91,      110,       19, PLT_ARMO | PLT_SHLD                                            ,  GOE_GOOD, TRUE,     TRUE,       620,      800,        11 },
	{ "Saintly",        IPL_ACP,              111,      130,       24, PLT_ARMO | PLT_SHLD                                            ,  GOE_GOOD, TRUE,     TRUE,       820,     1200,        13 },
	{ "Awesome",        IPL_ACP,              131,      150,       28, PLT_ARMO | PLT_SHLD                                            ,  GOE_GOOD, TRUE,     TRUE,      1220,     2000,        15 },
	{ "Holy",           IPL_ACP,              151,      170,       35, PLT_ARMO | PLT_SHLD                                            ,  GOE_GOOD, TRUE,     TRUE,      5200,     6000,        17 },
	{ "Godly",          IPL_ACP,              171,      200,       60, PLT_ARMO | PLT_SHLD                                            ,  GOE_GOOD, TRUE,     TRUE,      6200,     7000,        20 },
	{ "Red",            IPL_FIRERES,           10,       20,        4, PLT_ARMO | PLT_SHLD | PLT_WEAP | PLT_STAFF | PLT_BOW | PLT_MISC,  GOE_ANY,  FALSE,    TRUE,       500,     1500,         2 },
	{ "Crimson",        IPL_FIRERES,           21,       30,       10, PLT_ARMO | PLT_SHLD | PLT_WEAP | PLT_STAFF | PLT_BOW | PLT_MISC,  GOE_ANY,  FALSE,    TRUE,      2100,     3000,         2 },
	{ "Crimson",        IPL_FIRERES,           31,       40,       16, PLT_ARMO | PLT_SHLD | PLT_WEAP | PLT_STAFF | PLT_BOW | PLT_MISC,  GOE_ANY,  FALSE,    TRUE,      3100,     4000,         2 },
	{ "Garnet",         IPL_FIRERES,           41,       50,       20, PLT_ARMO | PLT_SHLD | PLT_WEAP | PLT_STAFF | PLT_BOW | PLT_MISC,  GOE_ANY,  FALSE,    TRUE,      8200,    12000,         3 },
	{ "Ruby",           IPL_FIRERES,           51,       60,       26, PLT_ARMO | PLT_SHLD | PLT_WEAP | PLT_STAFF | PLT_BOW | PLT_MISC,  GOE_ANY,  FALSE,    TRUE,     17100,    20000,         5 },
	{ "Blue",           IPL_LIGHTRES,          10,       20,        4, PLT_ARMO | PLT_SHLD | PLT_WEAP | PLT_STAFF | PLT_BOW | PLT_MISC,  GOE_ANY,  FALSE,    TRUE,       500,     1500,         2 },
	{ "Azure",          IPL_LIGHTRES,          21,       30,       10, PLT_ARMO | PLT_SHLD | PLT_WEAP | PLT_STAFF | PLT_BOW | PLT_MISC,  GOE_ANY,  FALSE,    TRUE,      2100,     3000,         2 },
	{ "Lapis",          IPL_LIGHTRES,          31,       40,       16, PLT_ARMO | PLT_SHLD | PLT_WEAP | PLT_STAFF | PLT_BOW | PLT_MISC,  GOE_ANY,  FALSE,    TRUE,      3100,     4000,         2 },
	{ "Cobalt",         IPL_LIGHTRES,          41,       50,       20, PLT_ARMO | PLT_SHLD | PLT_WEAP | PLT_STAFF | PLT_BOW | PLT_MISC,  GOE_ANY,  FALSE,    TRUE,      8200,    12000,         3 },
	{ "Sapphire",       IPL_LIGHTRES,          51,       60,       26, PLT_ARMO | PLT_SHLD | PLT_WEAP | PLT_STAFF | PLT_BOW | PLT_MISC,  GOE_ANY,  FALSE,    TRUE,     17100,    20000,         5 },
	{ "White",          IPL_MAGICRES,          10,       20,        4, PLT_ARMO | PLT_SHLD | PLT_WEAP | PLT_STAFF | PLT_BOW | PLT_MISC,  GOE_ANY,  FALSE,    TRUE,       500,     1500,         2 },
	{ "Pearl",          IPL_MAGICRES,          21,       30,       10, PLT_ARMO | PLT_SHLD | PLT_WEAP | PLT_STAFF | PLT_BOW | PLT_MISC,  GOE_ANY,  FALSE,    TRUE,      2100,     3000,         2 },
	{ "Ivory",          IPL_MAGICRES,          31,       40,       16, PLT_ARMO | PLT_SHLD | PLT_WEAP | PLT_STAFF | PLT_BOW | PLT_MISC,  GOE_ANY,  FALSE,    TRUE,      3100,     4000,         2 },
	{ "Crystal",        IPL_MAGICRES,          41,       50,       20, PLT_ARMO | PLT_SHLD | PLT_WEAP | PLT_STAFF | PLT_BOW | PLT_MISC,  GOE_ANY,  FALSE,    TRUE,      8200,    12000,         3 },
	{ "Diamond",        IPL_MAGICRES,          51,       60,       26, PLT_ARMO | PLT_SHLD | PLT_WEAP | PLT_STAFF | PLT_BOW | PLT_MISC,  GOE_ANY,  FALSE,    TRUE,     17100,    20000,         5 },
	{ "Topaz",          IPL_ALLRES,            10,       15,        8, PLT_ARMO | PLT_SHLD | PLT_WEAP | PLT_STAFF | PLT_BOW | PLT_MISC,  GOE_ANY,  FALSE,    TRUE,      2000,     5000,         3 },
	{ "Amber",          IPL_ALLRES,            16,       20,       12, PLT_ARMO | PLT_SHLD | PLT_WEAP | PLT_STAFF | PLT_BOW | PLT_MISC,  GOE_ANY,  FALSE,    TRUE,      7400,    10000,         3 },
	{ "Jade",           IPL_ALLRES,            21,       30,       18, PLT_ARMO | PLT_SHLD | PLT_WEAP | PLT_STAFF | PLT_BOW | PLT_MISC,  GOE_ANY,  FALSE,    TRUE,     11000,    15000,         3 },
	{ "Obsidian",       IPL_ALLRES,            31,       40,       24, PLT_ARMO | PLT_SHLD | PLT_WEAP | PLT_STAFF | PLT_BOW | PLT_MISC,  GOE_ANY,  FALSE,    TRUE,     24000,    40000,         4 },
	{ "Emerald",        IPL_ALLRES,            41,       50,       31,            PLT_SHLD | PLT_WEAP | PLT_STAFF | PLT_BOW           ,  GOE_ANY,  FALSE,    TRUE,     61000,    75000,         7 },
	{ "Hyena's",        IPL_MANA_CURSE,        11,       25,        4,                                  PLT_STAFF |           PLT_MISC,  GOE_ANY,  FALSE,    FALSE,      100,     1000,        -2 },
	{ "Frog's",         IPL_MANA_CURSE,         1,       10,        1,                                  PLT_STAFF |           PLT_MISC,  GOE_EVIL, FALSE,    FALSE,        0,        0,        -2 },
	{ "Spider's",       IPL_MANA,              10,       15,        1,                                  PLT_STAFF |           PLT_MISC,  GOE_EVIL, FALSE,    TRUE,       500,     1000,         2 },
	{ "Raven's",        IPL_MANA,              15,       20,        5,                                  PLT_STAFF |           PLT_MISC,  GOE_ANY,  FALSE,    TRUE,      1100,     2000,         3 },
	{ "Snake's",        IPL_MANA,              21,       30,        9,                                  PLT_STAFF |           PLT_MISC,  GOE_ANY,  FALSE,    TRUE,      2100,     4000,         5 },
	{ "Serpent's",      IPL_MANA,              30,       40,       15,                                  PLT_STAFF |           PLT_MISC,  GOE_ANY,  FALSE,    TRUE,      4100,     6000,         7 },
	{ "Drake's",        IPL_MANA,              41,       50,       21,                                  PLT_STAFF |           PLT_MISC,  GOE_ANY,  FALSE,    TRUE,      6100,    10000,         9 },
	{ "Dragon's",       IPL_MANA,              51,       60,       27,                                  PLT_STAFF |           PLT_MISC,  GOE_ANY,  FALSE,    TRUE,     10100,    15000,        11 },
	{ "Wyrm's",         IPL_MANA,              61,       80,       35,                                  PLT_STAFF                     ,  GOE_ANY,  FALSE,    TRUE,     15100,    19000,        12 },
	{ "Hydra's",        IPL_MANA,              81,      100,       60,                                  PLT_STAFF                     ,  GOE_ANY,  FALSE,    TRUE,     19100,    30000,        13 },
	{ "Angel's",        IPL_SPLLVLADD,          1,        1,       15,                                  PLT_STAFF                     ,  GOE_GOOD, FALSE,    TRUE,     25000,    25000,         2 },
	{ "Arch-Angel's",   IPL_SPLLVLADD,          2,        2,       25,                                  PLT_STAFF                     ,  GOE_GOOD, FALSE,    TRUE,     50000,    50000,         3 },
	{ "Plentiful",      IPL_CHARGES,            2,        2,        4,                                  PLT_STAFF                     ,  GOE_ANY,  FALSE,    TRUE,      2000,     2000,         2 },
	{ "Bountiful",      IPL_CHARGES,            3,        3,        9,                                  PLT_STAFF                     ,  GOE_ANY,  FALSE,    TRUE,      3000,     3000,         3 },
	{ "Flaming",        IPL_FIREDAM,            1,       10,        7,                       PLT_WEAP | PLT_STAFF                     ,  GOE_ANY,  FALSE,    TRUE,      5000,     5000,         2 },
	{ "Lightning",      IPL_LIGHTDAM,           2,       20,       18,                       PLT_WEAP | PLT_STAFF                     ,  GOE_ANY,  FALSE,    TRUE,     10000,    10000,         2 },
	{ "Jester's",       IPL_JESTERS,            1,        1,        7,                       PLT_WEAP                                 ,  GOE_ANY,  FALSE,    TRUE,      1200,     1200,         3 },
	{ "Crystalline",    IPL_CRYSTALLINE,       30,       70,        5,                       PLT_WEAP                                 ,  GOE_ANY,  FALSE,    TRUE,      1000,     3000,         3 },
	{ "Doppelganger's", IPL_DOPPELGANGER,      81,       95,       11,                       PLT_WEAP | PLT_STAFF                     ,  GOE_ANY,  FALSE,    TRUE,      2000,     2400,        10 },
	{ "",               IPL_INVALID,            0,        0,        0, 0                                                              ,  GOE_ANY,  FALSE,    FALSE,        0,        0,         0 },
	// clang-format on
};

/** Contains the data related to each item suffix. */
const PLStruct PL_Suffix[] = {
	// clang-format off
	// PLName,          PLPower,       PLParam1, PLParam2, PLMinLvl, PLIType,                                                             PLGOE,    PLDouble, PLOk,  PLMinVal, PLMaxVal, PLMultVal
	{  "quality",       IPL_DAMMOD,           1,        2,        2,                       PLT_WEAP | PLT_STAFF | PLT_BOW           ,     GOE_ANY,  FALSE,    TRUE,       100,      200,         2 },
	{  "maiming",       IPL_DAMMOD,           3,        5,        7,                       PLT_WEAP | PLT_STAFF | PLT_BOW           ,     GOE_ANY,  FALSE,    TRUE,      1300,     1500,         3 },
	{  "slaying",       IPL_DAMMOD,           6,        8,       15,                       PLT_WEAP                                 ,     GOE_ANY,  FALSE,    TRUE,      2600,     3000,         5 },
	{  "gore",          IPL_DAMMOD,           9,       12,       25,                       PLT_WEAP                                 ,     GOE_ANY,  FALSE,    TRUE,      4100,     5000,         8 },
	{  "carnage",       IPL_DAMMOD,          13,       16,       35,                       PLT_WEAP                                 ,     GOE_ANY,  FALSE,    TRUE,      5100,    10000,        10 },
	{  "slaughter",     IPL_DAMMOD,          17,       20,       60,                       PLT_WEAP                                 ,     GOE_ANY,  FALSE,    TRUE,     10100,    15000,        13 },
	{  "pain",          IPL_GETHIT_CURSE,     2,        4,        4, PLT_ARMO | PLT_SHLD |                                  PLT_MISC,     GOE_EVIL, FALSE,    FALSE,        0,        0,        -4 },
	{  "tears",         IPL_GETHIT_CURSE,     1,        1,        2, PLT_ARMO | PLT_SHLD |                                  PLT_MISC,     GOE_EVIL, FALSE,    FALSE,        0,        0,        -2 },
	{  "health",        IPL_GETHIT,           1,        1,        2, PLT_ARMO | PLT_SHLD |                                  PLT_MISC,     GOE_GOOD, FALSE,    TRUE,       200,      200,         2 },
	{  "protection",    IPL_GETHIT,           2,        2,        6, PLT_ARMO | PLT_SHLD                                            ,     GOE_GOOD, FALSE,    TRUE,       400,      800,         4 },
	{  "absorption",    IPL_GETHIT,           3,        3,       12, PLT_ARMO | PLT_SHLD                                            ,     GOE_GOOD, FALSE,    TRUE,      1001,     2500,        10 },
	{  "deflection",    IPL_GETHIT,           4,        4,       20, PLT_ARMO                                                       ,     GOE_GOOD, FALSE,    TRUE,      2500,     6500,        15 },
	{  "osmosis",       IPL_GETHIT,           5,        6,       50, PLT_ARMO                                                       ,     GOE_GOOD, FALSE,    TRUE,      7500,    10000,        20 },
	{  "frailty",       IPL_STR_CURSE,        6,       10,        3, PLT_ARMO | PLT_SHLD | PLT_WEAP |             PLT_BOW | PLT_MISC,     GOE_EVIL, FALSE,    FALSE,        0,        0,        -3 },
	{  "weakness",      IPL_STR_CURSE,        1,        5,        1, PLT_ARMO | PLT_SHLD | PLT_WEAP | PLT_STAFF | PLT_BOW | PLT_MISC,     GOE_EVIL, FALSE,    FALSE,        0,        0,        -2 },
	{  "strength",      IPL_STR,              1,        5,        1, PLT_ARMO | PLT_SHLD | PLT_WEAP | PLT_STAFF | PLT_BOW | PLT_MISC,     GOE_ANY,  FALSE,    TRUE,       200,     1000,         2 },
	{  "might",         IPL_STR,              6,       10,        5, PLT_ARMO | PLT_SHLD | PLT_WEAP |             PLT_BOW | PLT_MISC,     GOE_ANY,  FALSE,    TRUE,      1200,     2000,         3 },
	{  "power",         IPL_STR,             11,       15,       11, PLT_ARMO | PLT_SHLD | PLT_WEAP |             PLT_BOW | PLT_MISC,     GOE_ANY,  FALSE,    TRUE,      2200,     3000,         4 },
	{  "giants",        IPL_STR,             16,       20,       17, PLT_ARMO |            PLT_WEAP |             PLT_BOW | PLT_MISC,     GOE_ANY,  FALSE,    TRUE,      3200,     5000,         7 },
	{  "titans",        IPL_STR,             21,       30,       23,                       PLT_WEAP |                       PLT_MISC,     GOE_ANY,  FALSE,    TRUE,      5200,    10000,        10 },
	{  "paralysis",     IPL_DEX_CURSE,        6,       10,        3, PLT_ARMO | PLT_SHLD | PLT_WEAP |             PLT_BOW | PLT_MISC,     GOE_EVIL, FALSE,    FALSE,        0,        0,        -3 },
	{  "atrophy",       IPL_DEX_CURSE,        1,        5,        1, PLT_ARMO | PLT_SHLD | PLT_WEAP | PLT_STAFF | PLT_BOW | PLT_MISC,     GOE_EVIL, FALSE,    FALSE,        0,        0,        -2 },
	{  "dexterity",     IPL_DEX,              1,        5,        1, PLT_ARMO | PLT_SHLD | PLT_WEAP | PLT_STAFF | PLT_BOW | PLT_MISC,     GOE_ANY,  FALSE,    TRUE,       200,     1000,         2 },
	{  "skill",         IPL_DEX,              6,       10,        5, PLT_ARMO | PLT_SHLD | PLT_WEAP |             PLT_BOW | PLT_MISC,     GOE_ANY,  FALSE,    TRUE,      1200,     2000,         3 },
	{  "accuracy",      IPL_DEX,             11,       15,       11, PLT_ARMO | PLT_SHLD | PLT_WEAP |             PLT_BOW | PLT_MISC,     GOE_ANY,  FALSE,    TRUE,      2200,     3000,         4 },
	{  "precision",     IPL_DEX,             16,       20,       17, PLT_ARMO |            PLT_WEAP |             PLT_BOW | PLT_MISC,     GOE_ANY,  FALSE,    TRUE,      3200,     5000,         7 },
	{  "perfection",    IPL_DEX,             21,       30,       23,                                              PLT_BOW | PLT_MISC,     GOE_ANY,  FALSE,    TRUE,      5200,    10000,        10 },
	{  "the fool",      IPL_MAG_CURSE,        6,       10,        3, PLT_ARMO | PLT_SHLD | PLT_WEAP | PLT_STAFF | PLT_BOW | PLT_MISC,     GOE_EVIL, FALSE,    FALSE,        0,        0,        -3 },
	{  "dyslexia",      IPL_MAG_CURSE,        1,        5,        1, PLT_ARMO | PLT_SHLD | PLT_WEAP | PLT_STAFF | PLT_BOW | PLT_MISC,     GOE_EVIL, FALSE,    FALSE,        0,        0,        -2 },
	{  "magic",         IPL_MAG,              1,        5,        1, PLT_ARMO | PLT_SHLD | PLT_WEAP | PLT_STAFF | PLT_BOW | PLT_MISC,     GOE_ANY,  FALSE,    TRUE,       200,     1000,         2 },
	{  "the mind",      IPL_MAG,              6,       10,        5, PLT_ARMO | PLT_SHLD | PLT_WEAP | PLT_STAFF | PLT_BOW | PLT_MISC,     GOE_ANY,  FALSE,    TRUE,      1200,     2000,         3 },
	{  "brilliance",    IPL_MAG,             11,       15,       11, PLT_ARMO | PLT_SHLD | PLT_WEAP | PLT_STAFF | PLT_BOW | PLT_MISC,     GOE_ANY,  FALSE,    TRUE,      2200,     3000,         4 },
	{  "sorcery",       IPL_MAG,             16,       20,       17, PLT_ARMO |            PLT_WEAP | PLT_STAFF | PLT_BOW | PLT_MISC,     GOE_ANY,  FALSE,    TRUE,      3200,     5000,         7 },
	{  "wizardry",      IPL_MAG,             21,       30,       23,                                  PLT_STAFF |           PLT_MISC,     GOE_ANY,  FALSE,    TRUE,      5200,    10000,        10 },
	{  "illness",       IPL_VIT_CURSE,        6,       10,        3, PLT_ARMO | PLT_SHLD | PLT_WEAP | PLT_STAFF | PLT_BOW | PLT_MISC,     GOE_EVIL, FALSE,    FALSE,        0,        0,        -3 },
	{  "disease",       IPL_VIT_CURSE,        1,        5,        1, PLT_ARMO | PLT_SHLD | PLT_WEAP | PLT_STAFF | PLT_BOW | PLT_MISC,     GOE_EVIL, FALSE,    FALSE,        0,        0,        -2 },
	{  "vitality",      IPL_VIT,              1,        5,        1, PLT_ARMO | PLT_SHLD | PLT_WEAP | PLT_STAFF | PLT_BOW | PLT_MISC,     GOE_GOOD, FALSE,    TRUE,       200,     1000,         2 },
	{  "zest",          IPL_VIT,              6,       10,        5, PLT_ARMO | PLT_SHLD | PLT_WEAP |             PLT_BOW | PLT_MISC,     GOE_GOOD, FALSE,    TRUE,      1200,     2000,         3 },
	{  "vim",           IPL_VIT,             11,       15,       11, PLT_ARMO | PLT_SHLD | PLT_WEAP |             PLT_BOW | PLT_MISC,     GOE_GOOD, FALSE,    TRUE,      2200,     3000,         4 },
	{  "vigor",         IPL_VIT,             16,       20,       17, PLT_ARMO | PLT_WEAP |                        PLT_BOW | PLT_MISC,     GOE_GOOD, FALSE,    TRUE,      3200,     5000,         7 },
	{  "life",          IPL_VIT,             21,       30,       23,                                                        PLT_MISC,     GOE_GOOD, FALSE,    TRUE,      5200,    10000,        10 },
	{  "trouble",       IPL_ATTRIBS_CURSE,    6,       10,       12, PLT_ARMO | PLT_SHLD | PLT_WEAP | PLT_STAFF | PLT_BOW | PLT_MISC,     GOE_EVIL, FALSE,    FALSE,        0,        0,       -10 },
	{  "the pit",       IPL_ATTRIBS_CURSE,    1,        5,        5, PLT_ARMO | PLT_SHLD | PLT_WEAP | PLT_STAFF | PLT_BOW | PLT_MISC,     GOE_EVIL, FALSE,    FALSE,        0,        0,        -5 },
	{  "the sky",       IPL_ATTRIBS,          1,        3,        5, PLT_ARMO | PLT_SHLD | PLT_WEAP | PLT_STAFF | PLT_BOW | PLT_MISC,     GOE_ANY,  FALSE,    TRUE,       800,     4000,         5 },
	{  "the moon",      IPL_ATTRIBS,          4,        7,       11, PLT_ARMO | PLT_SHLD | PLT_WEAP | PLT_STAFF | PLT_BOW | PLT_MISC,     GOE_ANY,  FALSE,    TRUE,      4800,     8000,        10 },
	{  "the stars",     IPL_ATTRIBS,          8,       11,       17, PLT_ARMO |            PLT_WEAP |             PLT_BOW | PLT_MISC,     GOE_ANY,  FALSE,    TRUE,      8800,    12000,        15 },
	{  "the heavens",   IPL_ATTRIBS,         12,       15,       25,                       PLT_WEAP |             PLT_BOW | PLT_MISC,     GOE_ANY,  FALSE,    TRUE,     12800,    20000,        20 },
	{  "the zodiac",    IPL_ATTRIBS,         16,       20,       30,                                                        PLT_MISC,     GOE_ANY,  FALSE,    TRUE,     20800,    40000,        30 },
	{  "the vulture",   IPL_LIFE_CURSE,      11,       25,        4, PLT_ARMO | PLT_SHLD |                                  PLT_MISC,     GOE_EVIL, FALSE,    FALSE,        0,        0,        -4 },
	{  "the jackal",    IPL_LIFE_CURSE,       1,       10,        1, PLT_ARMO | PLT_SHLD |                                  PLT_MISC,     GOE_EVIL, FALSE,    FALSE,        0,        0,        -2 },
	{  "the fox",       IPL_LIFE,            10,       15,        1, PLT_ARMO | PLT_SHLD |                                  PLT_MISC,     GOE_ANY,  FALSE,    TRUE,       100,     1000,         2 },
	{  "the jaguar",    IPL_LIFE,            16,       20,        5, PLT_ARMO | PLT_SHLD |                                  PLT_MISC,     GOE_ANY,  FALSE,    TRUE,      1100,     2000,         3 },
	{  "the eagle",     IPL_LIFE,            21,       30,        9, PLT_ARMO | PLT_SHLD |                                  PLT_MISC,     GOE_ANY,  FALSE,    TRUE,      2100,     4000,         5 },
	{  "the wolf",      IPL_LIFE,            30,       40,       15, PLT_ARMO | PLT_SHLD |                                  PLT_MISC,     GOE_ANY,  FALSE,    TRUE,      4100,     6000,         7 },
	{  "the tiger",     IPL_LIFE,            41,       50,       21, PLT_ARMO | PLT_SHLD |                                  PLT_MISC,     GOE_ANY,  FALSE,    TRUE,      6100,    10000,         9 },
	{  "the lion",      IPL_LIFE,            51,       60,       27, PLT_ARMO |                                             PLT_MISC,     GOE_ANY,  FALSE,    TRUE,     10100,    15000,        11 },
	{  "the mammoth",   IPL_LIFE,            61,       80,       35, PLT_ARMO                                                       ,     GOE_ANY,  FALSE,    TRUE,     15100,    19000,        12 },
	{  "the whale",     IPL_LIFE,            81,      100,       60, PLT_ARMO                                                       ,     GOE_ANY,  FALSE,    TRUE,     19100,    30000,        13 },
	{  "fragility",     IPL_DUR_CURSE,      100,      100,        3, PLT_ARMO | PLT_SHLD | PLT_WEAP                                 ,     GOE_EVIL, FALSE,    FALSE,        0,        0,        -4 },
	{  "brittleness",   IPL_DUR_CURSE,       26,       75,        1, PLT_ARMO | PLT_SHLD | PLT_WEAP                                 ,     GOE_EVIL, FALSE,    FALSE,        0,        0,        -2 },
	{  "sturdiness",    IPL_DUR,             26,       75,        1, PLT_ARMO | PLT_SHLD | PLT_WEAP | PLT_STAFF                     ,     GOE_ANY,  FALSE,    TRUE,       100,      100,         2 },
	{  "craftsmanship", IPL_DUR,             51,      100,        6, PLT_ARMO | PLT_SHLD | PLT_WEAP | PLT_STAFF                     ,     GOE_ANY,  FALSE,    TRUE,       200,      200,         2 },
	{  "structure",     IPL_DUR,            101,      200,       12, PLT_ARMO | PLT_SHLD | PLT_WEAP | PLT_STAFF                     ,     GOE_ANY,  FALSE,    TRUE,       300,      300,         2 },
	{  "the ages",      IPL_INDESTRUCTIBLE,   0,        0,       25, PLT_ARMO | PLT_SHLD | PLT_WEAP | PLT_STAFF                     ,     GOE_ANY,  FALSE,    TRUE,       600,      600,         5 },
	{  "the dark",      IPL_LIGHT_CURSE,      4,        4,        6, PLT_ARMO |            PLT_WEAP |                       PLT_MISC,     GOE_EVIL, FALSE,    FALSE,        0,        0,        -3 },
	{  "the night",     IPL_LIGHT_CURSE,      2,        2,        3, PLT_ARMO |            PLT_WEAP |                       PLT_MISC,     GOE_EVIL, FALSE,    FALSE,        0,        0,        -2 },
	{  "light",         IPL_LIGHT,            2,        2,        4, PLT_ARMO |            PLT_WEAP |                       PLT_MISC,     GOE_GOOD, FALSE,    TRUE,       750,      750,         2 },
	{  "radiance",      IPL_LIGHT,            4,        4,        8, PLT_ARMO |            PLT_WEAP |                       PLT_MISC,     GOE_GOOD, FALSE,    TRUE,      1500,     1500,         3 },
	{  "flame",         IPL_FIRE_ARROWS,      1,        3,        1,                                              PLT_BOW           ,     GOE_ANY,  FALSE,    TRUE,      2000,     2000,         2 },
	{  "fire",          IPL_FIRE_ARROWS,      1,        6,       11,                                              PLT_BOW           ,     GOE_ANY,  FALSE,    TRUE,      4000,     4000,         4 },
	{  "burning",       IPL_FIRE_ARROWS,      1,       16,       35,                                              PLT_BOW           ,     GOE_ANY,  FALSE,    TRUE,      6000,     6000,         6 },
	{  "shock",         IPL_LIGHT_ARROWS,     1,        6,       13,                                              PLT_BOW           ,     GOE_ANY,  FALSE,    TRUE,      6000,     6000,         2 },
	{  "lightning",     IPL_LIGHT_ARROWS,     1,       10,       21,                                              PLT_BOW           ,     GOE_ANY,  FALSE,    TRUE,      8000,     8000,         4 },
	{  "thunder",       IPL_LIGHT_ARROWS,     1,       20,       60,                                              PLT_BOW           ,     GOE_ANY,  FALSE,    TRUE,     12000,    12000,         6 },
	{  "many",          IPL_DUR,            100,      100,        3,                                              PLT_BOW           ,     GOE_ANY,  FALSE,    TRUE,       750,      750,         2 },
	{  "plenty",        IPL_DUR,            200,      200,        7,                                              PLT_BOW           ,     GOE_ANY,  FALSE,    TRUE,      1500,     1500,         3 },
	{  "thorns",        IPL_THORNS,           1,        3,        1, PLT_ARMO | PLT_SHLD                                            ,     GOE_ANY,  FALSE,    TRUE,       500,      500,         2 },
	{  "corruption",    IPL_NOMANA,           0,        0,        5, PLT_ARMO | PLT_SHLD | PLT_WEAP                                 ,     GOE_EVIL, FALSE,    FALSE,    -1000,    -1000,         2 },
	{  "thieves",       IPL_ABSHALFTRAP,      0,        0,       11, PLT_ARMO | PLT_SHLD |                                  PLT_MISC,     GOE_ANY,  FALSE,    TRUE,      1500,     1500,         2 },
	{  "the bear",      IPL_KNOCKBACK,        0,        0,        5,                       PLT_WEAP | PLT_STAFF | PLT_BOW           ,     GOE_EVIL, FALSE,    TRUE,       750,      750,         2 },
	{  "the bat",       IPL_STEALMANA,        3,        3,        8,                       PLT_WEAP                                 ,     GOE_ANY,  FALSE,    TRUE,      7500,     7500,         3 },
	{  "vampires",      IPL_STEALMANA,        5,        5,       19,                       PLT_WEAP                                 ,     GOE_ANY,  FALSE,    TRUE,     15000,    15000,         3 },
	{  "the leech",     IPL_STEALLIFE,        3,        3,        8,                       PLT_WEAP                                 ,     GOE_ANY,  FALSE,    TRUE,      7500,     7500,         3 },
	{  "blood",         IPL_STEALLIFE,        5,        5,       19,                       PLT_WEAP                                 ,     GOE_ANY,  FALSE,    TRUE,     15000,    15000,         3 },
	{  "piercing",      IPL_TARGAC,           1,        1,        1,                       PLT_WEAP |             PLT_BOW           ,     GOE_ANY,  FALSE,    TRUE,      1000,     1000,         3 },
	{  "puncturing",    IPL_TARGAC,           2,        2,        9,                       PLT_WEAP |             PLT_BOW           ,     GOE_ANY,  FALSE,    TRUE,      2000,     2000,         6 },
	{  "bashing",       IPL_TARGAC,           3,        3,       17,                       PLT_WEAP                                 ,     GOE_ANY,  FALSE,    TRUE,      4000,     4000,        12 },
	{  "readiness",     IPL_FASTATTACK,       1,        1,        1,                       PLT_WEAP | PLT_STAFF | PLT_BOW           ,     GOE_ANY,  FALSE,    TRUE,      2000,     2000,         2 },
	{  "swiftness",     IPL_FASTATTACK,       2,        2,       10,                       PLT_WEAP | PLT_STAFF | PLT_BOW           ,     GOE_ANY,  FALSE,    TRUE,      4000,     4000,         4 },
	{  "speed",         IPL_FASTATTACK,       3,        3,       19,                       PLT_WEAP | PLT_STAFF                     ,     GOE_ANY,  FALSE,    TRUE,      8000,     8000,         8 },
	{  "haste",         IPL_FASTATTACK,       4,        4,       27,                       PLT_WEAP | PLT_STAFF                     ,     GOE_ANY,  FALSE,    TRUE,     16000,    16000,        16 },
	{  "balance",       IPL_FASTRECOVER,      1,        1,        1, PLT_ARMO |                                             PLT_MISC,     GOE_ANY,  FALSE,    TRUE,      2000,     2000,         2 },
	{  "stability",     IPL_FASTRECOVER,      2,        2,       10, PLT_ARMO |                                             PLT_MISC,     GOE_ANY,  FALSE,    TRUE,      4000,     4000,         4 },
	{  "harmony",       IPL_FASTRECOVER,      3,        3,       20, PLT_ARMO |                                             PLT_MISC,     GOE_ANY,  FALSE,    TRUE,      8000,     8000,         8 },
	{  "blocking",      IPL_FASTBLOCK,        1,        1,        5,            PLT_SHLD                                            ,     GOE_ANY,  FALSE,    TRUE,      4000,     4000,         4 },
	{  "devastation",   IPL_DEVASTATION,      1,        1,        1,                       PLT_WEAP | PLT_STAFF | PLT_BOW           ,     GOE_ANY,  FALSE,    TRUE,      1200,     1200,         3 },
	{  "decay",         IPL_DECAY,          150,      250,        1,                       PLT_WEAP | PLT_STAFF | PLT_BOW           ,     GOE_ANY,  FALSE,    TRUE,       200,      200,         2 },
	{  "peril",         IPL_PERIL,            1,        1,        5,                       PLT_WEAP | PLT_STAFF | PLT_BOW           ,     GOE_ANY,  FALSE,    TRUE,       500,      500,         1 },
	{  "",              IPL_INVALID,          0,        0,        0, 0                                                              ,     GOE_ANY,  FALSE,    FALSE,        0,        0,         0 },
	// clang-format on
};

/** Contains the data related to each unique item ID. */
const UItemStruct UniqueItemList[] = {
	// clang-format off
	// UIName,                    UIItemId,     UIMinLvl, UINumPL, UIValue, UIPower1,     UIParam1, UIParam2, UIPower2,      UIParam3, UIParam4, UIPower3,      UIParam5, UIParam6, UIPower4,      UIParam7, UIParam8, UIPower5,      UIParam9, UIParam10, UIPower6,      UIParam11, UIParam12
	{  "The Butcher's Cleaver",   UITYPE_CLEAVER,      1,       3,    3650, IPL_STR,            10,       10, IPL_SETDAM,           4,       24, IPL_SETDUR,          10,       10, IPL_TOHIT,            0,        0, IPL_TOHIT,            0,         0, IPL_TOHIT,             0,         0 },
	{  "The Undead Crown",        UITYPE_SKCROWN,      1,       3,   16650, IPL_RNDSTEALLIFE,    0,        0, IPL_SETAC,            8,        8, IPL_INVCURS,         77,        0, IPL_TOHIT,            0,        0, IPL_TOHIT,            0,         0, IPL_TOHIT,             0,         0 },
	{  "Empyrean Band",           UITYPE_INFRARING,    1,       4,    8000, IPL_ATTRIBS,         2,        2, IPL_LIGHT,            2,        2, IPL_FASTRECOVER,      1,        1, IPL_ABSHALFTRAP,      0,        0, IPL_TOHIT,            0,         0, IPL_TOHIT,             0,         0 },
	{  "Optic Amulet",            UITYPE_OPTAMULET,    1,       5,    9750, IPL_LIGHT,           2,        2, IPL_LIGHTRES,        20,       20, IPL_GETHIT,           1,        1, IPL_MAG,              5,        5, IPL_INVCURS,         44,         0, IPL_TOHIT,             0,         0 },
	{  "Ring of Truth",           UITYPE_TRING,        1,       4,    9100, IPL_LIFE,           10,       10, IPL_GETHIT,           1,        1, IPL_ALLRES,          10,       10, IPL_INVCURS,         10,        0, IPL_TOHIT,            0,         0, IPL_TOHIT,             0,         0 },
	{  "Harlequin Crest",         UITYPE_HARCREST,     1,       6,    4000, IPL_AC_CURSE,        3,        3, IPL_GETHIT,           1,        1, IPL_ATTRIBS,          2,        2, IPL_LIFE,             7,        7, IPL_MANA,             7,         7, IPL_INVCURS,          81,         0 },
	{  "Veil of Steel",           UITYPE_STEELVEIL,    1,       6,   63800, IPL_ALLRES,         50,       50, IPL_LIGHT_CURSE,      2,        2, IPL_ACP,             60,       60, IPL_MANA_CURSE,      30,       30, IPL_STR,             15,        15, IPL_VIT,              15,        15 },
	{  "Arkaine's Valor",         UITYPE_ARMOFVAL,     1,       4,   42000, IPL_SETAC,          25,       25, IPL_VIT,             10,       10, IPL_GETHIT,           3,        3, IPL_FASTRECOVER,      3,        3, IPL_TOHIT,            0,         0, IPL_TOHIT,             0,         0 },
	{  "Griswold's Edge",         UITYPE_GRISWOLD,     1,       6,   42000, IPL_FIREDAM,         1,       10, IPL_TOHIT,           25,       25, IPL_FASTATTACK,       2,        2, IPL_KNOCKBACK,        0,        0, IPL_MANA,            20,        20, IPL_LIFE_CURSE,       20,        20 },
	{  "Bovine Plate",            UITYPE_BOVINE,       1,       6,     400, IPL_SETAC,         150,      150, IPL_INDESTRUCTIBLE,   0,        0, IPL_LIGHT,            5,        5, IPL_ALLRES,          30,       30, IPL_MANA_CURSE,      50,        50, IPL_SPLLVLADD,        -2,        -2 },
	{  "The Rift Bow",            UITYPE_SHORTBOW,     1,       3,    1800, IPL_RNDARROWVEL,     0,        0, IPL_DAMMOD,           2,        2, IPL_DEX_CURSE,        3,        3, IPL_TOHIT,            0,        0, IPL_TOHIT,            0,         0, IPL_TOHIT,             0,         0 },
	{  "The Needler",             UITYPE_SHORTBOW,     2,       4,    8900, IPL_TOHIT,          50,       50, IPL_SETDAM,           1,        3, IPL_FASTATTACK,       2,        2, IPL_INVCURS,        158,        0, IPL_TOHIT,            0,         0, IPL_TOHIT,             0,         0 },
	{  "The Celestial Bow",       UITYPE_LONGBOW,      2,       4,    1200, IPL_NOMINSTR,        0,        0, IPL_DAMMOD,           2,        2, IPL_SETAC,            5,        5, IPL_INVCURS,        133,        0, IPL_TOHIT,            0,         0, IPL_TOHIT,             0,         0 },
	{  "Deadly Hunter",           UITYPE_COMPBOW,      3,       4,    8750, IPL_3XDAMVDEM,      10,       10, IPL_TOHIT,           20,       20, IPL_MAG_CURSE,        5,        5, IPL_INVCURS,        108,        0, IPL_TOHIT,            0,         0, IPL_TOHIT,             0,         0 },
	{  "Bow of the Dead",         UITYPE_COMPBOW,      5,       6,    2500, IPL_TOHIT,          10,       10, IPL_DEX,              4,        4, IPL_VIT_CURSE,        3,        3, IPL_LIGHT_CURSE,      2,        2, IPL_SETDUR,          30,        30, IPL_INVCURS,         108,         0 },
	{  "The Blackoak Bow",        UITYPE_LONGBOW,      5,       4,    2500, IPL_DEX,            10,       10, IPL_VIT_CURSE,       10,       10, IPL_DAMP,            50,       50, IPL_LIGHT_CURSE,      1,        1, IPL_TOHIT,            0,         0, IPL_TOHIT,             0,         0 },
	{  "Flamedart",               UITYPE_HUNTBOW,     10,       4,   14250, IPL_FIRE_ARROWS,     0,        0, IPL_FIREDAM,          1,        6, IPL_TOHIT,           20,       20, IPL_FIRERES,         40,       40, IPL_TOHIT,            0,         0, IPL_TOHIT,             0,         0 },
	{  "Fleshstinger",            UITYPE_LONGBOW,     13,       4,   16500, IPL_DEX,            15,       15, IPL_TOHIT,           40,       40, IPL_DAMP,            80,       80, IPL_DUR,              6,        6, IPL_TOHIT,            0,         0, IPL_TOHIT,             0,         0 },
	{  "Windforce",               UITYPE_WARBOW,      17,       4,   37750, IPL_STR,             5,        5, IPL_DAMP,           200,      200, IPL_KNOCKBACK,        0,        0, IPL_INVCURS,        164,        0, IPL_TOHIT,            0,         0, IPL_TOHIT,             0,         0 },
	{  "Eaglehorn",               UITYPE_BATTLEBOW,   26,       5,   42500, IPL_DEX,            20,       20, IPL_TOHIT,           50,       50, IPL_DAMP,           100,      100, IPL_INDESTRUCTIBLE,   0,        0, IPL_INVCURS,        108,         0, IPL_TOHIT,             0,         0 },
	{  "Gonnagal's Dirk",         UITYPE_DAGGER,       1,       5,    7040, IPL_DEX_CURSE,       5,        5, IPL_DAMMOD,           4,        4, IPL_FASTATTACK,       2,        2, IPL_FIRERES,         25,       25, IPL_INVCURS,         54,         0, IPL_TOHIT,             0,         0 },
	{  "The Defender",            UITYPE_SABRE,        1,       3,    2000, IPL_SETAC,           5,        5, IPL_VIT,              5,        5, IPL_TOHIT_CURSE,      5,        5, IPL_TOHIT,            0,        0, IPL_TOHIT,            0,         0, IPL_TOHIT,             0,         0 },
	{  "Gryphons Claw",           UITYPE_FALCHION,     1,       4,    1000, IPL_DAMP,          100,      100, IPL_MAG_CURSE,        2,        2, IPL_DEX_CURSE,        5,        5, IPL_INVCURS,         68,        0, IPL_TOHIT,            0,         0, IPL_TOHIT,             0,         0 },
	{  "Black Razor",             UITYPE_DAGGER,       1,       4,    2000, IPL_DAMP,          150,      150, IPL_VIT,              2,        2, IPL_SETDUR,           5,        5, IPL_INVCURS,         53,        0, IPL_TOHIT,            0,         0, IPL_TOHIT,             0,         0 },
	{  "Gibbous Moon",            UITYPE_BROADSWR,     2,       4,    6660, IPL_ATTRIBS,         2,        2, IPL_DAMP,            25,       25, IPL_MANA,            15,       15, IPL_LIGHT_CURSE,      3,        3, IPL_TOHIT,            0,         0, IPL_TOHIT,             0,         0 },
	{  "Ice Shank",               UITYPE_LONGSWR,      3,       3,    5250, IPL_FIRERES,        40,       40, IPL_SETDUR,          15,       15, IPL_STR,              5,       10, IPL_TOHIT,            0,        0, IPL_TOHIT,            0,         0, IPL_TOHIT,             0,         0 },
	{  "The Executioner's Blade", UITYPE_FALCHION,     3,       5,    7080, IPL_DAMP,          150,      150, IPL_LIFE_CURSE,      10,       10, IPL_LIGHT_CURSE,      1,        1, IPL_DUR,            200,      200, IPL_INVCURS,         58,         0, IPL_TOHIT,             0,         0 },
	{  "The Bonesaw",             UITYPE_CLAYMORE,     6,       6,    4400, IPL_DAMMOD,         10,       10, IPL_STR,             10,       10, IPL_MAG_CURSE,        5,        5, IPL_DEX_CURSE,        5,        5, IPL_LIFE,            10,        10, IPL_MANA_CURSE,       10,        10 },
	{  "Shadowhawk",              UITYPE_BROADSWR,     8,       4,   13750, IPL_LIGHT_CURSE,     2,        2, IPL_STEALLIFE,        5,        5, IPL_TOHIT,           15,       15, IPL_ALLRES,           5,        5, IPL_TOHIT,            0,         0, IPL_TOHIT,             0,         0 },
	{  "Wizardspike",             UITYPE_DAGGER,      11,       5,   12920, IPL_MAG,            15,       15, IPL_MANA,            35,       35, IPL_TOHIT,           25,       25, IPL_ALLRES,          15,       15, IPL_INVCURS,         50,         0, IPL_TOHIT,             0,         0 },
	{  "Lightsabre",              UITYPE_SABRE,       13,       4,   19150, IPL_LIGHT,           2,        2, IPL_LIGHTDAM,         1,       10, IPL_TOHIT,           20,       20, IPL_LIGHTRES,        50,       50, IPL_TOHIT,            0,         0, IPL_TOHIT,             0,         0 },
	{  "The Falcon's Talon",      UITYPE_SCIMITAR,    15,       5,    7867, IPL_FASTATTACK,      4,        4, IPL_TOHIT,           20,       20, IPL_DAMP_CURSE,      33,       33, IPL_DEX,             10,       10, IPL_INVCURS,         68,         0, IPL_TOHIT,             0,         0 },
	{  "Inferno",                 UITYPE_LONGSWR,     17,       4,   34600, IPL_FIREDAM,         2,       12, IPL_LIGHT,            3,        3, IPL_MANA,            20,       20, IPL_FIRERES,         80,       80, IPL_TOHIT,            0,         0, IPL_TOHIT,             0,         0 },
	{  "Doombringer",             UITYPE_BASTARDSWR,  19,       5,   18250, IPL_TOHIT,          25,       25, IPL_DAMP,           250,      250, IPL_ATTRIBS_CURSE,    5,        5, IPL_LIFE_CURSE,      25,       25, IPL_LIGHT_CURSE,      2,         2, IPL_TOHIT,             0,         0 },
	{  "The Grizzly",             UITYPE_TWOHANDSWR,  23,       6,   50000, IPL_STR,            20,       20, IPL_VIT_CURSE,        5,        5, IPL_DAMP,           200,      200, IPL_KNOCKBACK,        0,        0, IPL_DUR,            100,       100, IPL_INVCURS,         160,         0 },
	{  "The Grandfather",         UITYPE_GREATSWR,    27,       6,  119800, IPL_ONEHAND,         0,        0, IPL_ATTRIBS,          5,        5, IPL_TOHIT,           20,       20, IPL_DAMP,            70,       70, IPL_LIFE,            20,        20, IPL_INVCURS,         161,         0 },
	{  "The Mangler",             UITYPE_LARGEAXE,     2,       5,    2850, IPL_DAMP,          200,      200, IPL_DEX_CURSE,        5,        5, IPL_MAG_CURSE,        5,        5, IPL_MANA_CURSE,      10,       10, IPL_INVCURS,        144,         0, IPL_TOHIT,             0,         0 },
	{  "Sharp Beak",              UITYPE_LARGEAXE,     2,       4,    2850, IPL_LIFE,           20,       20, IPL_MAG_CURSE,       10,       10, IPL_MANA_CURSE,      10,       10, IPL_INVCURS,        143,        0, IPL_TOHIT,            0,         0, IPL_TOHIT,             0,         0 },
	{  "BloodSlayer",             UITYPE_BROADAXE,     3,       5,    2500, IPL_DAMP,          100,      100, IPL_3XDAMVDEM,       50,       50, IPL_ATTRIBS_CURSE,    5,        5, IPL_SPLLVLADD,       -1,       -1, IPL_INVCURS,        144,         0, IPL_TOHIT,             0,         0 },
	{  "The Celestial Axe",       UITYPE_BATTLEAXE,    4,       4,   14100, IPL_NOMINSTR,        0,        0, IPL_TOHIT,           15,       15, IPL_LIFE,            15,       15, IPL_STR_CURSE,       15,       15, IPL_TOHIT,            0,         0, IPL_TOHIT,             0,         0 },
	{  "Wicked Axe",              UITYPE_LARGEAXE,     5,       6,   31150, IPL_TOHIT,          30,       30, IPL_DEX,             10,       10, IPL_VIT_CURSE,       10,       10, IPL_GETHIT,           1,        6, IPL_INDESTRUCTIBLE,   0,         0, IPL_INVCURS,         143,         0 },
	{  "Stonecleaver",            UITYPE_BROADAXE,     7,       5,   23900, IPL_LIFE,           30,       30, IPL_TOHIT,           20,       20, IPL_DAMP,            50,       50, IPL_LIGHTRES,        40,       40, IPL_INVCURS,        104,         0, IPL_TOHIT,             0,         0 },
	{  "Aguinara's Hatchet",      UITYPE_SMALLAXE,    12,       3,   24800, IPL_SPLLVLADD,       1,        1, IPL_MAG,             10,       10, IPL_MAGICRES,        80,       80, IPL_TOHIT,            0,        0, IPL_TOHIT,            0,         0, IPL_TOHIT,             0,         0 },
	{  "Hellslayer",              UITYPE_BATTLEAXE,   15,       5,   26200, IPL_STR,             8,        8, IPL_VIT,              8,        8, IPL_DAMP,           100,      100, IPL_LIFE,            25,       25, IPL_MANA_CURSE,      25,        25, IPL_TOHIT,             0,         0 },
	{  "Messerschmidt's Reaver",  UITYPE_GREATAXE,    25,       6,   58000, IPL_DAMP,          200,      200, IPL_DAMMOD,          15,       15, IPL_ATTRIBS,          5,        5, IPL_LIFE_CURSE,      50,       50, IPL_FIREDAM,          2,        12, IPL_INVCURS,         163,         0 },
	{  "Crackrust",               UITYPE_MACE,         1,       5,   11375, IPL_ATTRIBS,         2,        2, IPL_INDESTRUCTIBLE,   0,        0, IPL_ALLRES,          15,       15, IPL_DAMP,            50,       50, IPL_SPLLVLADD,       -1,        -1, IPL_TOHIT,             0,         0 },
	{  "Hammer of Jholm",         UITYPE_MAUL,         1,       4,    8700, IPL_DAMP,            4,       10, IPL_INDESTRUCTIBLE,   0,        0, IPL_STR,              3,        3, IPL_TOHIT,           15,       15, IPL_TOHIT,            0,         0, IPL_TOHIT,             0,         0 },
	{  "Civerb's Cudgel",         UITYPE_MACE,         1,       3,    2000, IPL_3XDAMVDEM,      35,       35, IPL_DEX_CURSE,        5,        5, IPL_MAG_CURSE,        2,        2, IPL_TOHIT,            0,        0, IPL_TOHIT,            0,         0, IPL_TOHIT,             0,         0 },
	{  "The Celestial Star",      UITYPE_FLAIL,        2,       5,    7810, IPL_NOMINSTR,        0,        0, IPL_LIGHT,            2,        2, IPL_DAMMOD,          10,       10, IPL_AC_CURSE,         8,        8, IPL_INVCURS,        131,         0, IPL_TOHIT,             0,         0 },
	{  "Baranar's Star",          UITYPE_MORNSTAR,     5,       6,    6850, IPL_TOHIT,          12,       12, IPL_DAMP,            80,       80, IPL_FASTATTACK,       1,        1, IPL_VIT,              4,        4, IPL_DEX_CURSE,        4,         4, IPL_SETDUR,           60,        60 },
	{  "Gnarled Root",            UITYPE_SPIKCLUB,     9,       6,    9820, IPL_TOHIT,          20,       20, IPL_DAMP,           300,      300, IPL_DEX,             10,       10, IPL_MAG,              5,        5, IPL_ALLRES,          10,        10, IPL_AC_CURSE,         10,        10 },
	{  "The Cranium Basher",      UITYPE_MAUL,        12,       6,   36500, IPL_DAMMOD,         20,       20, IPL_STR,             15,       15, IPL_INDESTRUCTIBLE,   0,        0, IPL_MANA_CURSE,     150,      150, IPL_ALLRES,           5,         5, IPL_INVCURS,         122,         0 },
	{  "Schaefer's Hammer",       UITYPE_WARHAMMER,   16,       6,   56125, IPL_DAMP_CURSE,    100,      100, IPL_LIGHTDAM,         1,       50, IPL_LIFE,            50,       50, IPL_TOHIT,           30,       30, IPL_LIGHTRES,        80,        80, IPL_LIGHT,             1,         1 },
	{  "Dreamflange",             UITYPE_MACE,        26,       5,   26450, IPL_MAG,            30,       30, IPL_MANA,            50,       50, IPL_MAGICRES,        50,       50, IPL_LIGHT,            2,        2, IPL_SPLLVLADD,        1,         1, IPL_TOHIT,             0,         0 },
	{  "Staff of Shadows",        UITYPE_LONGSTAFF,    2,       5,    1250, IPL_MAG_CURSE,      10,       10, IPL_TOHIT,           10,       10, IPL_DAMP,            60,       60, IPL_LIGHT_CURSE,      2,        2, IPL_FASTATTACK,       1,         1, IPL_TOHIT,             0,         0 },
	{  "Immolator",               UITYPE_LONGSTAFF,    4,       4,    3900, IPL_FIRERES,        20,       20, IPL_FIREDAM,          4,        4, IPL_MANA,            10,       10, IPL_VIT_CURSE,        5,        5, IPL_TOHIT,            0,         0, IPL_TOHIT,             0,         0 },
	{  "Storm Spire",             UITYPE_WARSTAFF,     8,       4,   22500, IPL_LIGHTRES,       50,       50, IPL_LIGHTDAM,         2,        8, IPL_STR,             10,       10, IPL_MAG_CURSE,       10,       10, IPL_TOHIT,            0,         0, IPL_TOHIT,             0,         0 },
	{  "Gleamsong",               UITYPE_SHORTSTAFF,   8,       4,    6520, IPL_MANA,           25,       25, IPL_STR_CURSE,        3,        3, IPL_VIT_CURSE,        3,        3, IPL_SPELL,           10,       76, IPL_TOHIT,            0,         0, IPL_TOHIT,             0,         0 },
	{  "Thundercall",             UITYPE_COMPSTAFF,   14,       5,   22250, IPL_TOHIT,          35,       35, IPL_LIGHTDAM,         1,       10, IPL_SPELL,            3,       76, IPL_LIGHTRES,        30,       30, IPL_LIGHT,            2,         2, IPL_TOHIT,             0,         0 },
	{  "The Protector",           UITYPE_SHORTSTAFF,  16,       6,   17240, IPL_VIT,             5,        5, IPL_GETHIT,           5,        5, IPL_SETAC,           40,       40, IPL_SPELL,            2,       86, IPL_THORNS,           1,         3, IPL_INVCURS,         162,         0 },
	{  "Naj's Puzzler",           UITYPE_LONGSTAFF,   18,       5,   34000, IPL_MAG,            20,       20, IPL_DEX,             10,       10, IPL_ALLRES,          20,       20, IPL_SPELL,           23,       57, IPL_LIFE_CURSE,      25,        25, IPL_TOHIT,             0,         0 },
	{  "Mindcry",                 UITYPE_QUARSTAFF,   20,       4,   41500, IPL_MAG,            15,       15, IPL_SPELL,           13,       69, IPL_ALLRES,          15,       15, IPL_SPLLVLADD,        1,        1, IPL_TOHIT,            0,         0, IPL_TOHIT,             0,         0 },
	{  "Rod of Onan",             UITYPE_WARSTAFF,    22,       3,   44167, IPL_SPELL,          21,       50, IPL_DAMP,           100,      100, IPL_ATTRIBS,          5,        5, IPL_TOHIT,            0,        0, IPL_TOHIT,            0,         0, IPL_TOHIT,             0,         0 },
	{  "Helm of Sprits",          UITYPE_HELM,         1,       2,    7525, IPL_STEALLIFE,       5,        5, IPL_INVCURS,         77,        0, IPL_TOHIT,            0,        0, IPL_TOHIT,            0,        0, IPL_TOHIT,            0,         0, IPL_TOHIT,             0,         0 },
	{  "Thinking Cap",            UITYPE_SKULLCAP,     6,       5,    2020, IPL_MANA,           30,       30, IPL_SPLLVLADD,        2,        2, IPL_ALLRES,          20,       20, IPL_SETDUR,           1,        1, IPL_INVCURS,         93,         0, IPL_TOHIT,             0,         0 },
	{  "OverLord's Helm",         UITYPE_HELM,         7,       6,   12500, IPL_STR,            20,       20, IPL_DEX,             15,       15, IPL_VIT,              5,        5, IPL_MAG_CURSE,       20,       20, IPL_SETDUR,          15,        15, IPL_INVCURS,          99,         0 },
	{  "Fool's Crest",            UITYPE_HELM,        12,       5,   10150, IPL_ATTRIBS_CURSE,   4,        4, IPL_LIFE,           100,      100, IPL_GETHIT_CURSE,     1,        6, IPL_THORNS,           1,        3, IPL_INVCURS,         80,         0, IPL_TOHIT,             0,         0 },
	{  "Gotterdamerung",          UITYPE_GREATHELM,   21,       6,   54900, IPL_ATTRIBS,        20,       20, IPL_SETAC,           60,       60, IPL_GETHIT,           4,        4, IPL_ALLRESZERO,       0,        0, IPL_LIGHT_CURSE,      4,         4, IPL_INVCURS,          85,         0 },
	{  "Royal Circlet",           UITYPE_CROWN,       27,       5,   24875, IPL_ATTRIBS,        10,       10, IPL_MANA,            40,       40, IPL_SETAC,           40,       40, IPL_LIGHT,            1,        1, IPL_INVCURS,         79,         0, IPL_TOHIT,             0,         0 },
	{  "Torn Flesh of Souls",     UITYPE_RAGS,         2,       5,    4825, IPL_SETAC,           8,        8, IPL_VIT,             10,       10, IPL_GETHIT,           1,        1, IPL_INDESTRUCTIBLE,   0,        0, IPL_INVCURS,         92,         0, IPL_TOHIT,             0,         0 },
	{  "The Gladiator's Bane",    UITYPE_STUDARMOR,    6,       4,    3450, IPL_SETAC,          25,       25, IPL_GETHIT,           2,        2, IPL_DUR,            200,      200, IPL_ATTRIBS_CURSE,    3,        3, IPL_TOHIT,            0,         0, IPL_TOHIT,             0,         0 },
	{  "The Rainbow Cloak",       UITYPE_CLOAK,        2,       6,    4900, IPL_SETAC,          10,       10, IPL_ATTRIBS,          1,        1, IPL_ALLRES,          10,       10, IPL_LIFE,             5,        5, IPL_DUR,             50,        50, IPL_INVCURS,         138,         0 },
	{  "Leather of Aut",          UITYPE_LEATHARMOR,   4,       5,   10550, IPL_SETAC,          15,       15, IPL_STR,              5,        5, IPL_MAG_CURSE,        5,        5, IPL_DEX,              5,        5, IPL_INDESTRUCTIBLE,   0,         0, IPL_TOHIT,             0,         0 },
	{  "Wisdom's Wrap",           UITYPE_ROBE,         5,       6,    6200, IPL_MAG,             5,        5, IPL_MANA,            10,       10, IPL_LIGHTRES,        25,       25, IPL_SETAC,           15,       15, IPL_GETHIT,           1,         1, IPL_INVCURS,         138,         0 },
	{  "Sparking Mail",           UITYPE_CHAINMAIL,    9,       2,   15750, IPL_SETAC,          30,       30, IPL_LIGHTDAM,         1,       10, IPL_TOHIT,            0,        0, IPL_TOHIT,            0,        0, IPL_TOHIT,            0,         0, IPL_TOHIT,             0,         0 },
	{  "Scavenger Carapace",      UITYPE_BREASTPLATE, 13,       4,   14000, IPL_GETHIT,         15,       15, IPL_AC_CURSE,        30,       30, IPL_DEX,              5,        5, IPL_LIGHTRES,        40,       40, IPL_TOHIT,            0,         0, IPL_TOHIT,             0,         0 },
	{  "Nightscape",              UITYPE_CAPE,        16,       6,   11600, IPL_FASTRECOVER,     2,        2, IPL_LIGHT_CURSE,      4,        4, IPL_SETAC,           15,       15, IPL_DEX,              3,        3, IPL_ALLRES,          20,        20, IPL_INVCURS,         138,         0 },
	{  "Naj's Light Plate",       UITYPE_PLATEMAIL,   19,       6,   78700, IPL_NOMINSTR,        0,        0, IPL_MAG,              5,        5, IPL_MANA,            20,       20, IPL_ALLRES,          20,       20, IPL_SPLLVLADD,        1,         1, IPL_INVCURS,         159,         0 },
	{  "Demonspike Coat",         UITYPE_FULLPLATE,   25,       5,  251175, IPL_SETAC,         100,      100, IPL_GETHIT,           6,        6, IPL_STR,             10,       10, IPL_INDESTRUCTIBLE,   0,        0, IPL_FIRERES,         50,        50, IPL_TOHIT,             0,         0 },
	{  "The Deflector",           UITYPE_BUCKLER,      1,       5,    1500, IPL_SETAC,           7,        7, IPL_ALLRES,          10,       10, IPL_DAMP_CURSE,      20,       20, IPL_TOHIT_CURSE,      5,        5, IPL_INVCURS,         83,         0, IPL_TOHIT,             0,         0 },
	{  "Split Skull Shield",      UITYPE_BUCKLER,      1,       6,    2025, IPL_SETAC,          10,       10, IPL_LIFE,            10,       10, IPL_STR,              2,        2, IPL_LIGHT_CURSE,      1,        1, IPL_SETDUR,          15,        15, IPL_INVCURS,         116,         0 },
	{  "Dragon's Breach",         UITYPE_KITESHIELD,   2,       6,   19200, IPL_FIRERES,        25,       25, IPL_STR,              5,        5, IPL_SETAC,           20,       20, IPL_MAG_CURSE,        5,        5, IPL_INDESTRUCTIBLE,   0,         0, IPL_INVCURS,         117,         0 },
	{  "Blackoak Shield",         UITYPE_SMALLSHIELD,  4,       6,    5725, IPL_DEX,            10,       10, IPL_VIT_CURSE,       10,       10, IPL_SETAC,           18,       18, IPL_LIGHT_CURSE,      1,        1, IPL_DUR,            150,       150, IPL_INVCURS,         146,         0 },
	{  "Holy Defender",           UITYPE_LARGESHIELD, 10,       6,   13800, IPL_SETAC,          15,       15, IPL_GETHIT,           2,        2, IPL_FIRERES,         20,       20, IPL_DUR,            200,      200, IPL_FASTBLOCK,        1,         1, IPL_INVCURS,         146,         0 },
	{  "Stormshield",             UITYPE_GOTHSHIELD,  24,       6,   49000, IPL_SETAC,          40,       40, IPL_GETHIT_CURSE,     4,        4, IPL_STR,             10,       10, IPL_INDESTRUCTIBLE,   0,        0, IPL_FASTBLOCK,        1,         1, IPL_INVCURS,         148,         0 },
	{  "Bramble",                 UITYPE_RING,         1,       4,    1000, IPL_ATTRIBS_CURSE,   2,        2, IPL_DAMMOD,           3,        3, IPL_MANA,            10,       10, IPL_INVCURS,          9,        0, IPL_TOHIT,            0,         0, IPL_TOHIT,             0,         0 },
	{  "Ring of Regha",           UITYPE_RING,         1,       6,    4175, IPL_MAG,            10,       10, IPL_MAGICRES,        10,       10, IPL_LIGHT,            1,        1, IPL_STR_CURSE,        3,        3, IPL_DEX_CURSE,        3,         3, IPL_INVCURS,          11,         0 },
	{  "The Bleeder",             UITYPE_RING,         2,       4,    8500, IPL_MAGICRES,       20,       20, IPL_MANA,            30,       30, IPL_LIFE_CURSE,      10,       10, IPL_INVCURS,          8,        0, IPL_TOHIT,            0,         0, IPL_TOHIT,             0,         0 },
	{  "Constricting Ring",       UITYPE_RING,         5,       3,   62000, IPL_ALLRES,         75,       75, IPL_DRAINLIFE,        0,        0, IPL_INVCURS,         14,        0, IPL_TOHIT,            0,        0, IPL_TOHIT,            0,         0, IPL_TOHIT,             0,         0 },
	{  "Ring of Engagement",      UITYPE_RING,        11,       5,   12476, IPL_GETHIT,          1,        2, IPL_THORNS,           1,        3, IPL_SETAC,            5,        5, IPL_TARGAC,           4,       12, IPL_INVCURS,         13,         0, IPL_TOHIT,             0,         0 },
	{  "Giant's Knuckle",         UITYPE_RING,         8,       3,    8000, IPL_STR,            60,       60, IPL_DEX_CURSE,       30,       30, IPL_INVCURS,        179,        0, IPL_TOHIT,            0,        0, IPL_TOHIT,            0,         0, IPL_TOHIT,             0,         0 },
	{  "Mercurial Ring",          UITYPE_RING,         8,       3,    8000, IPL_DEX,            60,       60, IPL_STR_CURSE,       30,       30, IPL_INVCURS,        176,        0, IPL_TOHIT,            0,        0, IPL_TOHIT,            0,         0, IPL_TOHIT,             0,         0 },
	{  "Xorine's Ring",           UITYPE_RING,         8,       3,    8000, IPL_MAG,            60,       60, IPL_STR_CURSE,       30,       30, IPL_INVCURS,        168,        0, IPL_TOHIT,            0,        0, IPL_TOHIT,            0,         0, IPL_TOHIT,             0,         0 },
	{  "Karik's Ring",            UITYPE_RING,         8,       3,    8000, IPL_VIT,            60,       60, IPL_MAG_CURSE,       30,       30, IPL_INVCURS,        173,        0, IPL_TOHIT,            0,        0, IPL_TOHIT,            0,         0, IPL_TOHIT,             0,         0 },
	{  "Ring of Magma",           UITYPE_RING,         8,       4,    8000, IPL_FIRERES,        60,       60, IPL_LIGHTRES_CURSE,  30,       30, IPL_MAGICRES_CURSE,  30,       30, IPL_INVCURS,        184,        0, IPL_TOHIT,            0,         0, IPL_TOHIT,             0,         0 },
	{  "Ring of the Mystics",     UITYPE_RING,         8,       4,    8000, IPL_MAGICRES,       60,       60, IPL_FIRERES_CURSE,   30,       30, IPL_LIGHTRES_CURSE,  30,       30, IPL_INVCURS,        181,        0, IPL_TOHIT,            0,         0, IPL_TOHIT,             0,         0 },
	{  "Ring of Thunder",         UITYPE_RING,         8,       4,    8000, IPL_LIGHTRES,       60,       60, IPL_FIRERES_CURSE,   30,       30, IPL_MAGICRES_CURSE,  30,       30, IPL_INVCURS,        177,        0, IPL_TOHIT,            0,         0, IPL_TOHIT,             0,         0 },
	{  "Amulet of Warding",       UITYPE_AMULET,      12,       3,   30000, IPL_ALLRES,         40,       40, IPL_LIFE_CURSE,     100,      100, IPL_INVCURS,        170,        0, IPL_TOHIT,            0,        0, IPL_TOHIT,            0,         0, IPL_TOHIT,             0,         0 },
	{  "Gnat Sting",              UITYPE_HUNTBOW,     15,       5,   30000, IPL_MULT_ARROWS,     3,        3, IPL_SETDAM,           1,        2, IPL_FASTATTACK,       1,        1, IPL_INDESTRUCTIBLE,   0,        0, IPL_INVCURS,        210,         0, IPL_TOHIT,             0,         0 },
	{  "Flambeau",                UITYPE_COMPBOW,     11,       4,   30000, IPL_FIREBALL,       15,       20, IPL_SETDAM,           0,        0, IPL_INDESTRUCTIBLE,   0,        0, IPL_INVCURS,        209,        0, IPL_TOHIT,            0,         0, IPL_TOHIT,             0,         0 },
	{  "Armor of Gloom",          UITYPE_FULLPLATE,   25,       5,  200000, IPL_NOMINSTR,        0,        0, IPL_SETAC,          225,      225, IPL_ALLRESZERO,       0,        0, IPL_LIGHT_CURSE,      2,        2, IPL_INVCURS,        203,         0, IPL_TOHIT,             0,         0 },
	{  "Blitzen",                 UITYPE_COMPBOW,     13,       4,   30000, IPL_ADDACLIFE,      10,       15, IPL_SETDAM,           0,        0, IPL_INDESTRUCTIBLE,   0,        0, IPL_INVCURS,        219,        0, IPL_TOHIT,            0,         0, IPL_TOHIT,             0,         0 },
	{  "Thunderclap",             UITYPE_WARHAMMER,   13,       6,   30000, IPL_ADDMANAAC,       3,        6, IPL_STR,             20,       20, IPL_LIGHTRES,        30,       30, IPL_LIGHT,            2,        2, IPL_INDESTRUCTIBLE,   0,         0, IPL_INVCURS,         205,         0 },
	{  "Shirotachi",              UITYPE_GREATSWR,    21,       4,   36000, IPL_ONEHAND,         0,        0, IPL_FASTATTACK,       4,        4, IPL_TARGAC,           2,        2, IPL_LIGHTDAM,         6,        6, IPL_TOHIT,            0,         0, IPL_TOHIT,             0,         0 },
	{  "Eater of Souls",          UITYPE_TWOHANDSWR,  23,       6,   42000, IPL_INDESTRUCTIBLE,  0,        0, IPL_LIFE,            50,       50, IPL_STEALLIFE,        5,        5, IPL_STEALMANA,        5,        5, IPL_DRAINLIFE,        0,         0, IPL_INVCURS,         200,         0 },
	{  "Diamondedge",             UITYPE_LONGSWR,     17,       6,   42000, IPL_SETDUR,         10,       10, IPL_TOHIT,           50,       50, IPL_DAMP,           100,      100, IPL_LIGHTRES,        50,       50, IPL_SETAC,           10,        10, IPL_INVCURS,         206,         0 },
	{  "Bone Chain Armor",        UITYPE_CHAINMAIL,   13,       3,   36000, IPL_SETAC,          40,       40, IPL_ACUNDEAD,         0,        0, IPL_INVCURS,        204,        0, IPL_TOHIT,            0,        0, IPL_TOHIT,            0,         0, IPL_TOHIT,             0,         0 },
	{  "Demon Plate Armor",       UITYPE_FULLPLATE,   25,       3,   80000, IPL_SETAC,          80,       80, IPL_ACDEMON,          0,        0, IPL_INVCURS,        225,        0, IPL_TOHIT,            0,        0, IPL_TOHIT,            0,         0, IPL_TOHIT,             0,         0 },
	{  "Acolyte's Amulet",        UITYPE_AMULET,      10,       2,   10000, IPL_MANATOLIFE,     50,       50, IPL_INVCURS,        183,        0, IPL_TOHIT,            0,        0, IPL_TOHIT,            0,        0, IPL_TOHIT,            0,         0, IPL_TOHIT,             0,         0 },
	{  "Gladiator's Ring",        UITYPE_RING,        10,       2,   10000, IPL_LIFETOMANA,     40,       40, IPL_INVCURS,        186,        0, IPL_TOHIT,            0,        0, IPL_TOHIT,            0,        0, IPL_TOHIT,            0,         0, IPL_TOHIT,             0,         0 },
	{  "",                        UITYPE_INVALID,      0,       0,       0, IPL_TOHIT,           0,        0, IPL_TOHIT,            0,        0, IPL_TOHIT,            0,        0, IPL_TOHIT,            0,        0, IPL_TOHIT,            0,         0, IPL_TOHIT,             0,         0 },
	// clang-format on
};

DEVILUTION_END_NAMESPACE
