/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 1.3u-20010622-2330 (Alpha 5)
 * 
 * This file is not intended to be easily readable and contains a number of 
 * coding conventions designed to improve portability and efficiency. Do not make
 * changes to this file unless you know what you are doing--modify the SWIG 
 * interface file instead. 
 * ----------------------------------------------------------------------------- */

#define SWIGPYTHON
/***********************************************************************
 * common.swg
 *
 *     This file contains generic SWIG runtime support for pointer
 *     type checking as well as a few commonly used macros to control
 *     external linkage.
 *
 * Author : David Beazley (beazley@cs.uchicago.edu)
 *
 * Copyright (c) 1999-2000, The University of Chicago
 * 
 * This file may be freely redistributed without license or fee provided
 * this copyright message remains intact.
 ************************************************************************/

#include <string.h>

#if defined(_WIN32) || defined(__WIN32__)
#       if defined(_MSC_VER)
#               if defined(STATIC_LINKED)
#                       define SWIGEXPORT(a) a
#               else
#                       define SWIGEXPORT(a) __declspec(dllexport) a
#               endif
#       else
#               if defined(__BORLANDC__)
#                       define SWIGEXPORT(a) a _export
#               else
#                       define SWIGEXPORT(a) a
#       endif
#endif
#else
#       define SWIGEXPORT(a) a
#endif

#ifdef SWIG_GLOBAL
#define SWIGRUNTIME(a) SWIGEXPORT(a)
#else
#define SWIGRUNTIME(a) static a
#endif

#ifdef __cplusplus
extern "C" {
#endif

typedef struct swig_type_info {
  char  *name;                 
  void *(*converter)(void *);
  char  *str;
  struct swig_type_info  *next;
  struct swig_type_info  *prev;
} swig_type_info;

#ifdef SWIG_NOINCLUDE
SWIGEXPORT(swig_type_info *) SWIG_TypeRegister(swig_type_info *);
SWIGEXPORT(swig_type_info *) SWIG_TypeCheck(char *c, swig_type_info *);
SWIGEXPORT(void *) SWIG_TypeCast(swig_type_info *, void *);
#else

static swig_type_info *swig_type_list = 0;

/* Register a type mapping with the type-checking */
SWIGRUNTIME(swig_type_info *)
SWIG_TypeRegister(swig_type_info *ti)
{
  swig_type_info *tc, *head, *ret, *next;
  /* Check to see if this type has already been registered */
  tc = swig_type_list;
  while (tc) {
    if (strcmp(tc->name, ti->name) == 0) {
      /* Already exists in the table.  Just add additional types to the list */
      head = tc;
      next = tc->next;
      goto l1;
    }
    tc = tc->prev;
  }
  head = ti;
  next = 0;

  /* Place in list */
  ti->prev = swig_type_list;
  swig_type_list = ti;

  /* Build linked lists */
 l1:
  ret = head;
  tc = ti + 1;
  /* Patch up the rest of the links */
  while (tc->name) {
    head->next = tc;
    tc->prev = head;
    head = tc;
    tc++;
  }
  head->next = next;
  return ret;
}

/* Check the typename */
SWIGRUNTIME(swig_type_info *) 
SWIG_TypeCheck(char *c, swig_type_info *ty)
{
  swig_type_info *s;
  if (!ty) return 0;        /* Void pointer */
  s = ty->next;             /* First element always just a name */
  while (s) {
    if (strcmp(s->name,c) == 0) {
      if (s == ty->next) return s;
      /* Move s to the top of the linked list */
      s->prev->next = s->next;
      if (s->next) {
	s->next->prev = s->prev;
      }
      /* Insert s as second element in the list */
      s->next = ty->next;
      if (ty->next) ty->next->prev = s;
      ty->next = s;
      return s;
    }
    s = s->next;
  }
  return 0;
}

/* Cast a pointer (needed for C++ inheritance */
SWIGRUNTIME(void *) 
SWIG_TypeCast(swig_type_info *ty, void *ptr) 
{
  if ((!ty) || (!ty->converter)) return ptr;
  return (*ty->converter)(ptr);
}

/* Search for a swig_type_info structure */
SWIGRUNTIME(void *)
SWIG_TypeQuery(const char *name) {
  swig_type_info *ty = swig_type_list;
  while (ty) {
    if (ty->str && (strcmp(name,ty->str) == 0)) return ty;
    if (ty->name && (strcmp(name,ty->name) == 0)) return ty;
    ty = ty->prev;
  }
  return 0;
}

#endif

#ifdef __cplusplus
}
#endif



/***********************************************************************
 * python.swg
 *
 *     This file contains the runtime support for Python modules
 *     and includes code for managing global variables and pointer
 *     type checking.
 *
 * Author : David Beazley (beazley@cs.uchicago.edu)
 ************************************************************************/

#include <stdlib.h>
#include "Python.h"

#ifdef __cplusplus
extern "C" {
#endif

#define SWIG_PY_INT     1
#define SWIG_PY_FLOAT   2
#define SWIG_PY_STRING  3
#define SWIG_PY_POINTER 4

/* Constant information structure */
typedef struct swig_const_info {
    int type;
    char *name;
    long lvalue;
    double dvalue;
    void   *pvalue;
    swig_type_info **ptype;
} swig_const_info;

#ifdef SWIG_NOINCLUDE

SWIGEXPORT(PyObject *)        SWIG_newvarlink();
SWIGEXPORT(void)              SWIG_addvarlink(PyObject *, char *, PyObject *(*)(void), int (*)(PyObject *));
SWIGEXPORT(int)               SWIG_ConvertPtr(PyObject *, void **, swig_type_info *, int);
SWIGEXPORT(void)              SWIG_MakePtr(char *c, void *, swig_type_info *);
SWIGEXPORT(PyObject *)        SWIG_NewPointerObj(void *, swig_type_info *);
SWIGEXPORT(void)              SWIG_InstallConstants(PyObject *d, swig_const_info constants[]);

#else

/* -----------------------------------------------------------------------------
 * global variable support code.
 * ----------------------------------------------------------------------------- */

typedef struct swig_globalvar {   
  char       *name;                  /* Name of global variable */
  PyObject *(*get_attr)(void);       /* Return the current value */
  int       (*set_attr)(PyObject *); /* Set the value */
  struct swig_globalvar *next;
} swig_globalvar;

typedef struct swig_varlinkobject {
  PyObject_HEAD
  swig_globalvar *vars;
} swig_varlinkobject;

static PyObject *
swig_varlink_repr(swig_varlinkobject *v) {
  v = v;
  return PyString_FromString("<Global variables>");
}

static int
swig_varlink_print(swig_varlinkobject *v, FILE *fp, int flags) {
  swig_globalvar  *var;
  flags = flags;
  fprintf(fp,"Global variables { ");
  for (var = v->vars; var; var=var->next) {
    fprintf(fp,"%s", var->name);
    if (var->next) fprintf(fp,", ");
  }
  fprintf(fp," }\n");
  return 0;
}

static PyObject *
swig_varlink_getattr(swig_varlinkobject *v, char *n) {
  swig_globalvar *var = v->vars;
  while (var) {
    if (strcmp(var->name,n) == 0) {
      return (*var->get_attr)();
    }
    var = var->next;
  }
  PyErr_SetString(PyExc_NameError,"Unknown C global variable");
  return NULL;
}

static int
swig_varlink_setattr(swig_varlinkobject *v, char *n, PyObject *p) {
  swig_globalvar *var = v->vars;
  while (var) {
    if (strcmp(var->name,n) == 0) {
      return (*var->set_attr)(p);
    }
    var = var->next;
  }
  PyErr_SetString(PyExc_NameError,"Unknown C global variable");
  return 1;
}

statichere PyTypeObject varlinktype = {
  PyObject_HEAD_INIT(0)              
  0,
  "swigvarlink",                      /* Type name    */
  sizeof(swig_varlinkobject),         /* Basic size   */
  0,                                  /* Itemsize     */
  0,                                  /* Deallocator  */ 
  (printfunc) swig_varlink_print,     /* Print        */
  (getattrfunc) swig_varlink_getattr, /* get attr     */
  (setattrfunc) swig_varlink_setattr, /* Set attr     */
  0,                                  /* tp_compare   */
  (reprfunc) swig_varlink_repr,       /* tp_repr      */    
  0,                                  /* tp_as_number */
  0,                                  /* tp_as_mapping*/
  0,                                  /* tp_hash      */
};

/* Create a variable linking object for use later */
SWIGRUNTIME(PyObject *)
SWIG_newvarlink(void) {
  swig_varlinkobject *result = 0;
  result = PyMem_NEW(swig_varlinkobject,1);
  varlinktype.ob_type = &PyType_Type;    /* Patch varlinktype into a PyType */
  result->ob_type = &varlinktype;
  result->vars = 0;
  result->ob_refcnt = 0;
  Py_XINCREF((PyObject *) result);
  return ((PyObject*) result);
}

SWIGRUNTIME(void)
SWIG_addvarlink(PyObject *p, char *name,
	   PyObject *(*get_attr)(void), int (*set_attr)(PyObject *p)) {
  swig_varlinkobject *v;
  swig_globalvar *gv;
  v= (swig_varlinkobject *) p;
  gv = (swig_globalvar *) malloc(sizeof(swig_globalvar));
  gv->name = (char *) malloc(strlen(name)+1);
  strcpy(gv->name,name);
  gv->get_attr = get_attr;
  gv->set_attr = set_attr;
  gv->next = v->vars;
  v->vars = gv;
}
/* Convert a pointer value */
SWIGRUNTIME(int)
SWIG_ConvertPtr(PyObject *obj, void **ptr, swig_type_info *ty, int flags) {
  unsigned long p;
  register int d;
  swig_type_info *tc;
  char  *c;
  static PyObject *SWIG_this = 0;
  int    newref = 0;

  if (!obj || (obj == Py_None)) {
    *ptr = 0;
    return 0;
  }
#ifdef SWIG_COBJECT_TYPES
  if (!(PyCObject_Check(obj))) {
    if (!SWIG_this)
      SWIG_this = PyString_InternFromString("this");
    obj = PyObject_GetAttr(obj,SWIG_this);
    newref = 1;
    if (!obj) goto type_error;
    if (!PyCObject_Check(obj)) {
      Py_DECREF(obj);
      goto type_error;
    }
  } 
  *ptr = PyCObject_AsVoidPtr(obj);
  c = (char *) PyCObject_GetDesc(obj);
  if (newref) Py_DECREF(obj);
  goto cobject;
#else
  if (!(PyString_Check(obj))) {
    if (!SWIG_this)
      SWIG_this = PyString_InternFromString("this");
    obj = PyObject_GetAttr(obj,SWIG_this);
    newref = 1;
    if (!obj) goto type_error;
    if (!PyString_Check(obj)) {
      Py_DECREF(obj);
      goto type_error;
    }
  } 
  c = PyString_AsString(obj);
  p = 0;
  /* Pointer values must start with leading underscore */
  if (*c != '_') {
    *ptr = (void *) 0;
    if (strcmp(c,"NULL") == 0) {
      if (newref) Py_DECREF(obj);
      return 0;
    } else {
      if (newref) Py_DECREF(obj);
      goto type_error;
    }
  }
  c++;
  /* Extract hex value from pointer */
  while ((d = *c)) {
    if ((d >= '0') && (d <= '9'))
      p = (p << 4) + (d - '0');
    else if ((d >= 'a') && (d <= 'f'))
      p = (p << 4) + (d - ('a'-10));
    else
      break; 
    c++;
  }
  *ptr = (void *) p;
  if (newref) Py_DECREF(obj);
#endif

#ifdef SWIG_COBJECT_TYPES
cobject:
#endif

  if (ty) {
    tc = SWIG_TypeCheck(c,ty);
    if (!tc) goto type_error;
    *ptr = SWIG_TypeCast(tc,(void*)p);
  }
  return 0;

type_error:

  if (flags) {
    if (ty) {
      char *temp = (char *) malloc(64+strlen(ty->name));
      sprintf(temp,"Type error. Expected %s", ty->name);
      PyErr_SetString(PyExc_TypeError, temp);
      free((char *) temp);
    } else {
      PyErr_SetString(PyExc_TypeError,"Expected a pointer");
    }
  }
  return -1;
}

/* Take a pointer and convert it to a string */
SWIGRUNTIME(void) 
SWIG_MakePtr(char *c, void *ptr, swig_type_info *ty) {
  static char hex[17] = "0123456789abcdef";
  unsigned long p, s;
  char result[32], *r; 
  r = result;
  p = (unsigned long) ptr;
  if (p > 0) {
    while (p > 0) {
      s = p & 0xf;
      *(r++) = hex[s];
      p = p >> 4;
    }
    *r = '_';
    while (r >= result)
      *(c++) = *(r--);
    strcpy (c, ty->name);
  } else {
    strcpy (c, "NULL");
  }
}

/* Create a new pointer object */
SWIGRUNTIME(PyObject *)
SWIG_NewPointerObj(void *ptr, swig_type_info *type) {
  char result[512];
  PyObject *robj;
  if (!ptr) {
    Py_INCREF(Py_None);
    return Py_None;
  }
#ifdef SWIG_COBJECT_TYPES
  robj = PyCObject_FromVoidPtrAndDesc((void *) ptr, type->name, NULL);
#else
  SWIG_MakePtr(result,ptr,type);
  robj = PyString_FromString(result);
#endif
  return robj;
}

/* Install Constants */
SWIGRUNTIME(void)
SWIG_InstallConstants(PyObject *d, swig_const_info constants[]) {
  int i;
  PyObject *obj;
  for (i = 0; constants[i].type; i++) {
    switch(constants[i].type) {
    case SWIG_PY_INT:
      obj = PyInt_FromLong(constants[i].lvalue);
      break;
    case SWIG_PY_FLOAT:
      obj = PyFloat_FromDouble(constants[i].dvalue);
      break;
    case SWIG_PY_STRING:
      obj = PyString_FromString((char *) constants[i].pvalue);
      break;
    case SWIG_PY_POINTER:
      obj = SWIG_NewPointerObj(constants[i].pvalue, *(constants[i]).ptype);
      break;
    default:
      obj = 0;
      break;
    }
    if (obj) {
      PyDict_SetItemString(d,constants[i].name,obj);
      Py_DECREF(obj);
    }
  }
}

#endif

#ifdef __cplusplus
}
#endif



/* -------- TYPES TABLE (BEGIN) -------- */

#define  SWIGTYPE_p_EC_KEYPAIR swig_types[0] 
#define  SWIGTYPE_p_double swig_types[1] 
#define  SWIGTYPE_p_unsigned_long swig_types[2] 
#define  SWIGTYPE_p_float swig_types[3] 
#define  SWIGTYPE_p_safeString swig_types[4] 
#define  SWIGTYPE_p_void swig_types[5] 
#define  SWIGTYPE_p_short swig_types[6] 
#define  SWIGTYPE_p_p_char swig_types[7] 
#define  SWIGTYPE_p_char swig_types[8] 
#define  SWIGTYPE_p_SIGNATURE swig_types[9] 
#define  SWIGTYPE_p_EC_PARAMETER swig_types[10] 
#define  SWIGTYPE_p_long swig_types[11] 
#define  SWIGTYPE_p_POINT swig_types[12] 
#define  SWIGTYPE_p_int swig_types[13] 
#define  SWIGTYPE_p_FIELD2N swig_types[14] 
#define  SWIGTYPE_p_CURVE swig_types[15] 
static swig_type_info *swig_types[17];

/* -------- TYPES TABLE (END) -------- */


/*-----------------------------------------------
              @(target):= ellipticc.so
  ------------------------------------------------*/
#define SWIG_init    initellipticc

#define SWIG_name    "ellipticc"

#include <ctype.h>

/* Types used by the library */
static swig_type_info *SWIG_POINTER_int_p = 0;
static swig_type_info *SWIG_POINTER_short_p =0;
static swig_type_info *SWIG_POINTER_long_p = 0;
static swig_type_info *SWIG_POINTER_float_p = 0;
static swig_type_info *SWIG_POINTER_double_p = 0;
static swig_type_info *SWIG_POINTER_char_p = 0;
static swig_type_info *SWIG_POINTER_char_pp = 0;


/*------------------------------------------------------------------
  ptrvalue(ptr,type = 0)

  Attempts to dereference a pointer value.  If type is given, it 
  will try to use that type.  Otherwise, this function will attempt
  to "guess" the proper datatype by checking against all of the 
  builtin C datatypes. 
  ------------------------------------------------------------------ */

static PyObject *ptrvalue(PyObject *_PTRVALUE, int index, char *type) {
  void     *ptr;
  char     *s;
  PyObject *obj;

  if (SWIG_ConvertPtr(_PTRVALUE,&ptr,0,0)) {
    PyErr_SetString(PyExc_TypeError,"Type error in ptrvalue. Argument is not a valid pointer value.");
    return NULL;
  }

  /* If no datatype was passed, try a few common datatypes first */
  if (!type) {
    /* No datatype was passed.   Type to figure out if it's a common one */
    if (!SWIG_ConvertPtr(_PTRVALUE,&ptr,SWIG_POINTER_int_p,0)) {
      type = "int";
    } else if (!SWIG_ConvertPtr(_PTRVALUE,&ptr,SWIG_POINTER_double_p,0)) {
      type = "double";
    } else if (!SWIG_ConvertPtr(_PTRVALUE,&ptr,SWIG_POINTER_short_p,0)) {
      type = "short";
    } else if (!SWIG_ConvertPtr(_PTRVALUE,&ptr,SWIG_POINTER_long_p,0)) {
      type = "long";
    } else if (!SWIG_ConvertPtr(_PTRVALUE,&ptr,SWIG_POINTER_float_p,0)) {
      type = "float";
    } else if (!SWIG_ConvertPtr(_PTRVALUE,&ptr,SWIG_POINTER_char_p,0)) {
      type = "char";
    } else if (!SWIG_ConvertPtr(_PTRVALUE,&ptr,SWIG_POINTER_char_pp,0)) {
      type = "char *";
    } else {
      type = "unknown";
    }
  }
  if (!ptr) {
    PyErr_SetString(PyExc_TypeError,"Unable to dereference NULL pointer.");
    return NULL;
  }
  /* Now we have a datatype.  Try to figure out what to do about it */
  if (strcmp(type,"int") == 0) {
    obj = PyInt_FromLong((long) *(((int *) ptr) + index));
  } else if (strcmp(type,"double") == 0) {
    obj = PyFloat_FromDouble((double) *(((double *) ptr)+index));
  } else if (strcmp(type,"short") == 0) {
    obj = PyInt_FromLong((long) *(((short *) ptr)+index));
  } else if (strcmp(type,"long") == 0) {
    obj = PyInt_FromLong((long) *(((long *) ptr)+index));
  } else if (strcmp(type,"float") == 0) {
    obj = PyFloat_FromDouble((double) *(((float *) ptr)+index));
  } else if (strcmp(type,"char") == 0) {
    obj = PyString_FromString(((char *) ptr)+index);
  } else if (strcmp(type,"char *") == 0) {
    char *c = *(((char **) ptr)+index);
    if (c) obj = PyString_FromString(c);
    else obj = PyString_FromString("NULL");
  } else {
    PyErr_SetString(PyExc_TypeError,"Unable to dereference unsupported datatype.");
    return NULL;
  }
  return obj;
}

/*------------------------------------------------------------------
  ptrcreate(type,value = 0,numelements = 1)

  Attempts to create a new object of given type.  Type must be
  a basic C datatype.  Will not create complex objects.
  ------------------------------------------------------------------ */

static PyObject *ptrcreate(char *type, PyObject *_PYVALUE, int numelements) {
  void     *ptr;
  PyObject *obj;
  int       sz;
  swig_type_info *cast;
  char      temp[40];

  /* Check the type string against a variety of possibilities */

  if (strcmp(type,"int") == 0) {
    sz = sizeof(int)*numelements;
    cast = SWIG_POINTER_int_p;
  } else if (strcmp(type,"short") == 0) {
    sz = sizeof(short)*numelements;
    cast = SWIG_POINTER_short_p;
  } else if (strcmp(type,"long") == 0) {
    sz = sizeof(long)*numelements;
    cast = SWIG_POINTER_long_p;
  } else if (strcmp(type,"double") == 0) {
    sz = sizeof(double)*numelements;
    cast = SWIG_POINTER_double_p;
  } else if (strcmp(type,"float") == 0) {
    sz = sizeof(float)*numelements;
    cast = SWIG_POINTER_float_p;
  } else if (strcmp(type,"char") == 0) {
    sz = sizeof(char)*numelements;
    cast = SWIG_POINTER_char_p;
  } else if (strcmp(type,"char *") == 0) {
    sz = sizeof(char *)*(numelements+1);
    cast = SWIG_POINTER_char_pp;
  } else {
    PyErr_SetString(PyExc_TypeError,"Unable to create unknown datatype."); 
    return NULL;
  }
   
  /* Create the new object */
  
  ptr = (void *) malloc(sz);
  if (!ptr) {
    PyErr_SetString(PyExc_MemoryError,"Out of memory in swig_create."); 
    return NULL;
  }

  /* Now try to set its default value */

  if (_PYVALUE) {
    if (strcmp(type,"int") == 0) {
      int *ip,i,ivalue;
      ivalue = (int) PyInt_AsLong(_PYVALUE);
      ip = (int *) ptr;
      for (i = 0; i < numelements; i++)
	ip[i] = ivalue;
    } else if (strcmp(type,"short") == 0) {
      short *ip,ivalue;
      int i;
      ivalue = (short) PyInt_AsLong(_PYVALUE);
      ip = (short *) ptr;
      for (i = 0; i < numelements; i++)
	ip[i] = ivalue;
    } else if (strcmp(type,"long") == 0) {
      long *ip,ivalue;
      int i;
      ivalue = (long) PyInt_AsLong(_PYVALUE);
      ip = (long *) ptr;
      for (i = 0; i < numelements; i++)
	ip[i] = ivalue;
    } else if (strcmp(type,"double") == 0) {
      double *ip,ivalue;
      int i;
      ivalue = (double) PyFloat_AsDouble(_PYVALUE);
      ip = (double *) ptr;
      for (i = 0; i < numelements; i++)
	ip[i] = ivalue;
    } else if (strcmp(type,"float") == 0) {
      float *ip,ivalue;
      int i;
      ivalue = (float) PyFloat_AsDouble(_PYVALUE);
      ip = (float *) ptr;
      for (i = 0; i < numelements; i++)
	ip[i] = ivalue;
    } else if (strcmp(type,"char") == 0) {
      char *ip,*ivalue;
      ivalue = (char *) PyString_AsString(_PYVALUE);
      ip = (char *) ptr;
      strncpy(ip,ivalue,numelements-1);
    } else if (strcmp(type,"char *") == 0) {
      char **ip, *ivalue;
      int  i;
      ivalue = (char *) PyString_AsString(_PYVALUE);
      ip = (char **) ptr;
      for (i = 0; i < numelements; i++) {
	if (ivalue) {
	  ip[i] = (char *) malloc(strlen(ivalue)+1);
	  strcpy(ip[i],ivalue);
	} else {
	  ip[i] = 0;
	}
      }
      ip[numelements] = 0;
    }
  } 
  /* Create the pointer value */
  
  obj = SWIG_NewPointerObj(ptr,cast);
  return obj;
}


/*------------------------------------------------------------------
  ptrset(ptr,value,index = 0,type = 0)

  Attempts to set the value of a pointer variable.  If type is
  given, we will use that type.  Otherwise, we'll guess the datatype.
  ------------------------------------------------------------------ */

static PyObject *ptrset(PyObject *_PTRVALUE, PyObject *_PYVALUE, int index, char *type) {
  void     *ptr;
  PyObject *obj;

  if (SWIG_ConvertPtr(_PTRVALUE,&ptr,0,0)) {
    PyErr_SetString(PyExc_TypeError,"Type error in ptrset. Argument is not a valid pointer value.");
    return NULL;
  }

  /* If no datatype was passed, try a few common datatypes first */
  if (!type) {
    /* No datatype was passed.   Type to figure out if it's a common one */
    if (!SWIG_ConvertPtr(_PTRVALUE,&ptr,SWIG_POINTER_int_p,0)) {
      type = "int";
    } else if (!SWIG_ConvertPtr(_PTRVALUE,&ptr,SWIG_POINTER_double_p,0)) {
      type = "double";
    } else if (!SWIG_ConvertPtr(_PTRVALUE,&ptr,SWIG_POINTER_short_p,0)) {
      type = "short";
    } else if (!SWIG_ConvertPtr(_PTRVALUE,&ptr,SWIG_POINTER_long_p,0)) {
      type = "long";
    } else if (!SWIG_ConvertPtr(_PTRVALUE,&ptr,SWIG_POINTER_float_p,0)) {
      type = "float";
    } else if (!SWIG_ConvertPtr(_PTRVALUE,&ptr,SWIG_POINTER_char_p,0)) {
      type = "char";
    } else if (!SWIG_ConvertPtr(_PTRVALUE,&ptr,SWIG_POINTER_char_pp,0)) {
      type = "char *";
    } else {
      type = "unknown";
    }
  }
  if (!ptr) {
    PyErr_SetString(PyExc_TypeError,"Unable to set NULL pointer.");
    return NULL;
  }
  
  /* Now we have a datatype.  Try to figure out what to do about it */
  if (strcmp(type,"int") == 0) {
    *(((int *) ptr)+index) = (int) PyInt_AsLong(_PYVALUE);
  } else if (strcmp(type,"double") == 0) {
    *(((double *) ptr)+index) = (double) PyFloat_AsDouble(_PYVALUE);
  } else if (strcmp(type,"short") == 0) {
    *(((short *) ptr)+index) = (short) PyInt_AsLong(_PYVALUE);
  } else if (strcmp(type,"long") == 0) {
    *(((long *) ptr)+index) = (long) PyInt_AsLong(_PYVALUE);
  } else if (strcmp(type,"float") == 0) {
    *(((float *) ptr)+index) = (float) PyFloat_AsDouble(_PYVALUE);
  } else if (strcmp(type,"char") == 0) {
    char *c = PyString_AsString(_PYVALUE);
    strcpy(((char *) ptr)+index, c);
  } else if (strcmp(type,"char *") == 0) {
    char *c = PyString_AsString(_PYVALUE);
    char **ca = (char **) ptr;
    if (ca[index]) free(ca[index]);
    if (strcmp(c,"NULL") == 0) {
      ca[index] = 0;
    } else {
      ca[index] = (char *) malloc(strlen(c)+1);
      strcpy(ca[index],c);
    }
  } else {
    PyErr_SetString(PyExc_TypeError,"Unable to set unsupported datatype.");
    return NULL;
  }
  Py_INCREF(Py_None);
  return Py_None;
}

/*------------------------------------------------------------------
  ptradd(ptr,offset)

  Adds a value to an existing pointer value.  Will do a type-dependent
  add for basic datatypes.  For other datatypes, will do a byte-add.
  ------------------------------------------------------------------ */

static PyObject *ptradd(PyObject *_PTRVALUE, int offset) {

  char *r;
  void *ptr,*junk;
  PyObject *obj;
  swig_type_info *type;

  /* Check to see what kind of object _PTRVALUE is */
  
  /* Try to handle a few common datatypes first */
  if (!SWIG_ConvertPtr(_PTRVALUE,&ptr,SWIG_POINTER_int_p,0)) {
    ptr = (void *) (((int *) ptr) + offset);
    type = SWIG_POINTER_int_p;
  } else if (!SWIG_ConvertPtr(_PTRVALUE,&ptr,SWIG_POINTER_double_p,0)) {
    ptr = (void *) (((double *) ptr) + offset);
    type = SWIG_POINTER_double_p;
  } else if (!SWIG_ConvertPtr(_PTRVALUE,&ptr,SWIG_POINTER_short_p,0)) {
    ptr = (void *) (((short *) ptr) + offset);
    type = SWIG_POINTER_short_p;
  } else if (!SWIG_ConvertPtr(_PTRVALUE,&ptr,SWIG_POINTER_long_p,0)) {
    ptr = (void *) (((long *) ptr) + offset);
    type = SWIG_POINTER_long_p;
  } else if (!SWIG_ConvertPtr(_PTRVALUE,&ptr,SWIG_POINTER_float_p,0)) {
    ptr = (void *) (((float *) ptr) + offset);
    type = SWIG_POINTER_float_p;
  } else if (!SWIG_ConvertPtr(_PTRVALUE,&ptr,SWIG_POINTER_char_p,0)) {
    ptr = (void *) (((char *) ptr) + offset);
    type = SWIG_POINTER_char_p;
  } else if (!SWIG_ConvertPtr(_PTRVALUE,&ptr,SWIG_POINTER_char_pp,0)) {
    ptr = (void *) (((char *) ptr) + offset);
    type = SWIG_POINTER_char_pp;
  } else {
    PyErr_SetString(PyExc_TypeError,"Type error in ptradd. Argument is not a valid pointer value.");
    return NULL;
  }
  obj = SWIG_NewPointerObj(ptr, type);
  return obj;
}

/*------------------------------------------------------------------
  ptrfree(ptr)

  Destroys a pointer value
  ------------------------------------------------------------------ */

PyObject *ptrfree(PyObject *_PTRVALUE) {
  void *ptr, *junk;

  if (SWIG_ConvertPtr(_PTRVALUE,&ptr,0,0)) {
    PyErr_SetString(PyExc_TypeError,"Type error in ptrfree. Argument is not a valid pointer value.");
    return NULL;
  }
  
  /* Check to see if this pointer is a char ** */
  if (!SWIG_ConvertPtr(_PTRVALUE,&junk,SWIG_POINTER_char_pp,0)) {
    char **c = (char **) ptr;
    if (c) {
      int i = 0;
      while (c[i]) {
	free(c[i]);
	i++;
      }
    }
  }
  if (ptr)
    free((char *) ptr);

  Py_INCREF(Py_None);
  return Py_None;
}


#include "bigint.h"
#include "eliptic.h"
#include "protocols.h"

#define WORDSIZE	(sizeof(int)*8)
#define NUMBITS		113
#define	NUMWORD		(NUMBITS/WORDSIZE)
#define MAXLONG		(NUMWORD+1)
extern unsigned long random_seed;
extern void makeSecretKey(EC_PARAMETER *,EC_KEYPAIR *);
extern void makeKeypair(EC_PARAMETER *,EC_KEYPAIR *);
extern void makeBaseCurve(EC_PARAMETER *);
extern void init();
extern safeString *field2bin(FIELD2N *);
extern FIELD2N *bin2field(char *);
extern void DH_gen(EC_PARAMETER *,EC_KEYPAIR *);
extern void DH_recv(EC_PARAMETER *,EC_KEYPAIR *,POINT *,FIELD2N *);
extern void NR_Signature(char *,unsigned long ,EC_PARAMETER *,FIELD2N *,SIGNATURE *);
extern int NR_Verify(char *,unsigned long ,EC_PARAMETER *,POINT *,SIGNATURE *);
#ifdef __cplusplus
extern "C" {
#endif
static PyObject *_wrap_ptrvalue(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    PyObject *arg0 ;
    int arg1 = 0 ;
    char *arg2 = 0 ;
    PyObject * obj0  = 0 ;
    PyObject *result ;
    
    if(!PyArg_ParseTuple(args,"O|is:ptrvalue",&obj0,&arg1,&arg2)) return NULL;
    {
        arg0 = obj0;
    }
    result = (PyObject *)ptrvalue(arg0,arg1,arg2);
    {
        resultobj = result;
    }
    return resultobj;
}


static PyObject *_wrap_ptrset(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    PyObject *arg0 ;
    PyObject *arg1 ;
    int arg2 = 0 ;
    char *arg3 = 0 ;
    PyObject * obj0  = 0 ;
    PyObject * obj1  = 0 ;
    PyObject *result ;
    
    if(!PyArg_ParseTuple(args,"OO|is:ptrset",&obj0,&obj1,&arg2,&arg3)) return NULL;
    {
        arg0 = obj0;
    }
    {
        arg1 = obj1;
    }
    result = (PyObject *)ptrset(arg0,arg1,arg2,arg3);
    {
        resultobj = result;
    }
    return resultobj;
}


static PyObject *_wrap_ptrcreate(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    char *arg0 ;
    PyObject *arg1 = 0 ;
    int arg2 = 1 ;
    PyObject * obj1  = 0 ;
    PyObject *result ;
    
    if(!PyArg_ParseTuple(args,"s|Oi:ptrcreate",&arg0,&obj1,&arg2)) return NULL;
    if (obj1)
    {
        arg1 = obj1;
    }
    result = (PyObject *)ptrcreate(arg0,arg1,arg2);
    {
        resultobj = result;
    }
    return resultobj;
}


static PyObject *_wrap_ptrfree(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    PyObject *arg0 ;
    PyObject * obj0  = 0 ;
    PyObject *result ;
    
    if(!PyArg_ParseTuple(args,"O:ptrfree",&obj0)) return NULL;
    {
        arg0 = obj0;
    }
    result = (PyObject *)ptrfree(arg0);
    {
        resultobj = result;
    }
    return resultobj;
}


static PyObject *_wrap_ptradd(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    PyObject *arg0 ;
    int arg1 ;
    PyObject * obj0  = 0 ;
    PyObject *result ;
    
    if(!PyArg_ParseTuple(args,"Oi:ptradd",&obj0,&arg1)) return NULL;
    {
        arg0 = obj0;
    }
    result = (PyObject *)ptradd(arg0,arg1);
    {
        resultobj = result;
    }
    return resultobj;
}


static int _wrap_random_seed_set(PyObject *val) {
    unsigned long  tval ;
    
    tval = (unsigned long ) PyInt_AsLong(val);
    if (PyErr_Occurred()) {
        PyErr_SetString(PyExc_TypeError,"C variable 'random_seed'(unsigned long )");
        return 1; 
    }
    random_seed = tval;
    return 0;
}


static PyObject *_wrap_random_seed_get() {
    PyObject *pyobj;
    
    pyobj = PyInt_FromLong((long) random_seed);
    return pyobj;
}


static PyObject *_wrap_makeSecretKey(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    EC_PARAMETER *arg0 ;
    EC_KEYPAIR *arg1 ;
    PyObject * argo0 =0 ;
    PyObject * argo1 =0 ;
    
    if(!PyArg_ParseTuple(args,"OO:makeSecretKey",&argo0,&argo1)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_EC_PARAMETER,1)) == -1) return NULL;
    if ((SWIG_ConvertPtr(argo1,(void **) &arg1,SWIGTYPE_p_EC_KEYPAIR,1)) == -1) return NULL;
    makeSecretKey(arg0,arg1);
    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_makeKeypair(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    EC_PARAMETER *arg0 ;
    EC_KEYPAIR *arg1 ;
    PyObject * argo0 =0 ;
    PyObject * argo1 =0 ;
    
    if(!PyArg_ParseTuple(args,"OO:makeKeypair",&argo0,&argo1)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_EC_PARAMETER,1)) == -1) return NULL;
    if ((SWIG_ConvertPtr(argo1,(void **) &arg1,SWIGTYPE_p_EC_KEYPAIR,1)) == -1) return NULL;
    makeKeypair(arg0,arg1);
    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_makeBaseCurve(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    EC_PARAMETER *arg0 ;
    PyObject * argo0 =0 ;
    
    if(!PyArg_ParseTuple(args,"O:makeBaseCurve",&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_EC_PARAMETER,1)) == -1) return NULL;
    makeBaseCurve(arg0);
    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_init(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    
    if(!PyArg_ParseTuple(args,":init")) return NULL;
    init();
    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_field2bin(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    FIELD2N *arg0 ;
    PyObject * argo0 =0 ;
    safeString *result ;
    
    if(!PyArg_ParseTuple(args,"O:field2bin",&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_FIELD2N,1)) == -1) return NULL;
    result = (safeString *)field2bin(arg0);
    {
        if ( result != NULL ) {
            resultobj = PyString_FromStringAndSize(result->bytes, result->sz);
            free(result->bytes);
            free(result);
        }
        else {
            PyErr_SetString(PyExc_RuntimeError,"cipher or key error");
            return NULL;
        }
    }
    return resultobj;
}


static PyObject *_wrap_bin2field(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    char *arg0 ;
    PyObject * obj0  = 0 ;
    FIELD2N *result ;
    
    if(!PyArg_ParseTuple(args,"O:bin2field",&obj0)) return NULL;
    {
        if ( !PyString_Check(obj0) ) {
            PyErr_SetString(PyExc_TypeError,"not a string, man.");
            return NULL;
        }
        arg0 = PyString_AsString(obj0);
    }
    result = (FIELD2N *)bin2field(arg0);
    resultobj = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_FIELD2N);
    return resultobj;
}


static PyObject *_wrap_DH_gen(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    EC_PARAMETER *arg0 ;
    EC_KEYPAIR *arg1 ;
    PyObject * argo0 =0 ;
    PyObject * argo1 =0 ;
    
    if(!PyArg_ParseTuple(args,"OO:DH_gen",&argo0,&argo1)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_EC_PARAMETER,1)) == -1) return NULL;
    if ((SWIG_ConvertPtr(argo1,(void **) &arg1,SWIGTYPE_p_EC_KEYPAIR,1)) == -1) return NULL;
    DH_gen(arg0,arg1);
    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_DH_recv(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    EC_PARAMETER *arg0 ;
    EC_KEYPAIR *arg1 ;
    POINT *arg2 ;
    FIELD2N *arg3 ;
    PyObject * argo0 =0 ;
    PyObject * argo1 =0 ;
    PyObject * argo2 =0 ;
    PyObject * argo3 =0 ;
    
    if(!PyArg_ParseTuple(args,"OOOO:DH_recv",&argo0,&argo1,&argo2,&argo3)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_EC_PARAMETER,1)) == -1) return NULL;
    if ((SWIG_ConvertPtr(argo1,(void **) &arg1,SWIGTYPE_p_EC_KEYPAIR,1)) == -1) return NULL;
    if ((SWIG_ConvertPtr(argo2,(void **) &arg2,SWIGTYPE_p_POINT,1)) == -1) return NULL;
    if ((SWIG_ConvertPtr(argo3,(void **) &arg3,SWIGTYPE_p_FIELD2N,1)) == -1) return NULL;
    DH_recv(arg0,arg1,arg2,arg3);
    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_NR_Signature(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    char *arg0 ;
    unsigned long arg1 ;
    EC_PARAMETER *arg2 ;
    FIELD2N *arg3 ;
    SIGNATURE *arg4 ;
    PyObject * obj0  = 0 ;
    PyObject * argo2 =0 ;
    PyObject * argo3 =0 ;
    PyObject * argo4 =0 ;
    
    if(!PyArg_ParseTuple(args,"OlOOO:NR_Signature",&obj0,&arg1,&argo2,&argo3,&argo4)) return NULL;
    {
        if ( !PyString_Check(obj0) ) {
            PyErr_SetString(PyExc_TypeError,"not a string, man.");
            return NULL;
        }
        arg0 = PyString_AsString(obj0);
    }
    if ((SWIG_ConvertPtr(argo2,(void **) &arg2,SWIGTYPE_p_EC_PARAMETER,1)) == -1) return NULL;
    if ((SWIG_ConvertPtr(argo3,(void **) &arg3,SWIGTYPE_p_FIELD2N,1)) == -1) return NULL;
    if ((SWIG_ConvertPtr(argo4,(void **) &arg4,SWIGTYPE_p_SIGNATURE,1)) == -1) return NULL;
    NR_Signature(arg0,arg1,arg2,arg3,arg4);
    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_NR_Verify(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    char *arg0 ;
    unsigned long arg1 ;
    EC_PARAMETER *arg2 ;
    POINT *arg3 ;
    SIGNATURE *arg4 ;
    PyObject * obj0  = 0 ;
    PyObject * argo2 =0 ;
    PyObject * argo3 =0 ;
    PyObject * argo4 =0 ;
    int result ;
    
    if(!PyArg_ParseTuple(args,"OlOOO:NR_Verify",&obj0,&arg1,&argo2,&argo3,&argo4)) return NULL;
    {
        if ( !PyString_Check(obj0) ) {
            PyErr_SetString(PyExc_TypeError,"not a string, man.");
            return NULL;
        }
        arg0 = PyString_AsString(obj0);
    }
    if ((SWIG_ConvertPtr(argo2,(void **) &arg2,SWIGTYPE_p_EC_PARAMETER,1)) == -1) return NULL;
    if ((SWIG_ConvertPtr(argo3,(void **) &arg3,SWIGTYPE_p_POINT,1)) == -1) return NULL;
    if ((SWIG_ConvertPtr(argo4,(void **) &arg4,SWIGTYPE_p_SIGNATURE,1)) == -1) return NULL;
    result = (int )NR_Verify(arg0,arg1,arg2,arg3,arg4);
    resultobj = PyInt_FromLong((long)result);
    return resultobj;
}


static PyObject *_wrap_new_FIELD2N(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    FIELD2N *result ;
    
    if(!PyArg_ParseTuple(args,":new_FIELD2N")) return NULL;
    result = (FIELD2N *)(FIELD2N *) calloc(1, sizeof(FIELD2N));
    resultobj = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_FIELD2N);
    return resultobj;
}


static PyObject *_wrap_delete_FIELD2N(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    FIELD2N *arg0 ;
    PyObject * argo0 =0 ;
    
    if(!PyArg_ParseTuple(args,"O:delete_FIELD2N",&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_FIELD2N,1)) == -1) return NULL;
    free((char *) arg0);
    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_FIELD2N_e_get(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    FIELD2N *arg0 ;
    PyObject * argo0 =0 ;
    unsigned long *result ;
    
    if(!PyArg_ParseTuple(args,"O:FIELD2N_e_get",&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_FIELD2N,1)) == -1) return NULL;
    result = (unsigned long *)(unsigned long *) (arg0->e);
    resultobj = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_unsigned_long);
    return resultobj;
}


static PyObject *_wrap_new_EC_PARAMETER(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    EC_PARAMETER *result ;
    
    if(!PyArg_ParseTuple(args,":new_EC_PARAMETER")) return NULL;
    result = (EC_PARAMETER *)(EC_PARAMETER *) calloc(1, sizeof(EC_PARAMETER));
    resultobj = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_EC_PARAMETER);
    return resultobj;
}


static PyObject *_wrap_delete_EC_PARAMETER(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    EC_PARAMETER *arg0 ;
    PyObject * argo0 =0 ;
    
    if(!PyArg_ParseTuple(args,"O:delete_EC_PARAMETER",&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_EC_PARAMETER,1)) == -1) return NULL;
    free((char *) arg0);
    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_EC_PARAMETER_crv_set(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    EC_PARAMETER *arg0 ;
    CURVE *arg1 ;
    PyObject * argo0 =0 ;
    PyObject * argo1 =0 ;
    
    if(!PyArg_ParseTuple(args,"OO:EC_PARAMETER_crv_set",&argo0,&argo1)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_EC_PARAMETER,1)) == -1) return NULL;
    if ((SWIG_ConvertPtr(argo1,(void **) &arg1,SWIGTYPE_p_CURVE,1)) == -1) return NULL;
    arg0->crv = *arg1;
    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_EC_PARAMETER_crv_get(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    EC_PARAMETER *arg0 ;
    PyObject * argo0 =0 ;
    CURVE *result ;
    
    if(!PyArg_ParseTuple(args,"O:EC_PARAMETER_crv_get",&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_EC_PARAMETER,1)) == -1) return NULL;
    result = (CURVE *)& (arg0->crv);
    resultobj = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_CURVE);
    return resultobj;
}


static PyObject *_wrap_EC_PARAMETER_pnt_set(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    EC_PARAMETER *arg0 ;
    POINT *arg1 ;
    PyObject * argo0 =0 ;
    PyObject * argo1 =0 ;
    
    if(!PyArg_ParseTuple(args,"OO:EC_PARAMETER_pnt_set",&argo0,&argo1)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_EC_PARAMETER,1)) == -1) return NULL;
    if ((SWIG_ConvertPtr(argo1,(void **) &arg1,SWIGTYPE_p_POINT,1)) == -1) return NULL;
    arg0->pnt = *arg1;
    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_EC_PARAMETER_pnt_get(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    EC_PARAMETER *arg0 ;
    PyObject * argo0 =0 ;
    POINT *result ;
    
    if(!PyArg_ParseTuple(args,"O:EC_PARAMETER_pnt_get",&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_EC_PARAMETER,1)) == -1) return NULL;
    result = (POINT *)& (arg0->pnt);
    resultobj = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_POINT);
    return resultobj;
}


static PyObject *_wrap_EC_PARAMETER_pnt_order_set(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    EC_PARAMETER *arg0 ;
    FIELD2N *arg1 ;
    PyObject * argo0 =0 ;
    PyObject * argo1 =0 ;
    
    if(!PyArg_ParseTuple(args,"OO:EC_PARAMETER_pnt_order_set",&argo0,&argo1)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_EC_PARAMETER,1)) == -1) return NULL;
    if ((SWIG_ConvertPtr(argo1,(void **) &arg1,SWIGTYPE_p_FIELD2N,1)) == -1) return NULL;
    arg0->pnt_order = *arg1;
    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_EC_PARAMETER_pnt_order_get(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    EC_PARAMETER *arg0 ;
    PyObject * argo0 =0 ;
    FIELD2N *result ;
    
    if(!PyArg_ParseTuple(args,"O:EC_PARAMETER_pnt_order_get",&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_EC_PARAMETER,1)) == -1) return NULL;
    result = (FIELD2N *)& (arg0->pnt_order);
    resultobj = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_FIELD2N);
    return resultobj;
}


static PyObject *_wrap_EC_PARAMETER_cofactor_set(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    EC_PARAMETER *arg0 ;
    FIELD2N *arg1 ;
    PyObject * argo0 =0 ;
    PyObject * argo1 =0 ;
    
    if(!PyArg_ParseTuple(args,"OO:EC_PARAMETER_cofactor_set",&argo0,&argo1)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_EC_PARAMETER,1)) == -1) return NULL;
    if ((SWIG_ConvertPtr(argo1,(void **) &arg1,SWIGTYPE_p_FIELD2N,1)) == -1) return NULL;
    arg0->cofactor = *arg1;
    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_EC_PARAMETER_cofactor_get(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    EC_PARAMETER *arg0 ;
    PyObject * argo0 =0 ;
    FIELD2N *result ;
    
    if(!PyArg_ParseTuple(args,"O:EC_PARAMETER_cofactor_get",&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_EC_PARAMETER,1)) == -1) return NULL;
    result = (FIELD2N *)& (arg0->cofactor);
    resultobj = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_FIELD2N);
    return resultobj;
}


static PyObject *_wrap_new_EC_KEYPAIR(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    EC_KEYPAIR *result ;
    
    if(!PyArg_ParseTuple(args,":new_EC_KEYPAIR")) return NULL;
    result = (EC_KEYPAIR *)(EC_KEYPAIR *) calloc(1, sizeof(EC_KEYPAIR));
    resultobj = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_EC_KEYPAIR);
    return resultobj;
}


static PyObject *_wrap_delete_EC_KEYPAIR(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    EC_KEYPAIR *arg0 ;
    PyObject * argo0 =0 ;
    
    if(!PyArg_ParseTuple(args,"O:delete_EC_KEYPAIR",&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_EC_KEYPAIR,1)) == -1) return NULL;
    free((char *) arg0);
    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_EC_KEYPAIR_prvt_key_set(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    EC_KEYPAIR *arg0 ;
    FIELD2N *arg1 ;
    PyObject * argo0 =0 ;
    PyObject * argo1 =0 ;
    
    if(!PyArg_ParseTuple(args,"OO:EC_KEYPAIR_prvt_key_set",&argo0,&argo1)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_EC_KEYPAIR,1)) == -1) return NULL;
    if ((SWIG_ConvertPtr(argo1,(void **) &arg1,SWIGTYPE_p_FIELD2N,1)) == -1) return NULL;
    arg0->prvt_key = *arg1;
    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_EC_KEYPAIR_prvt_key_get(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    EC_KEYPAIR *arg0 ;
    PyObject * argo0 =0 ;
    FIELD2N *result ;
    
    if(!PyArg_ParseTuple(args,"O:EC_KEYPAIR_prvt_key_get",&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_EC_KEYPAIR,1)) == -1) return NULL;
    result = (FIELD2N *)& (arg0->prvt_key);
    resultobj = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_FIELD2N);
    return resultobj;
}


static PyObject *_wrap_EC_KEYPAIR_pblc_key_set(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    EC_KEYPAIR *arg0 ;
    POINT *arg1 ;
    PyObject * argo0 =0 ;
    PyObject * argo1 =0 ;
    
    if(!PyArg_ParseTuple(args,"OO:EC_KEYPAIR_pblc_key_set",&argo0,&argo1)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_EC_KEYPAIR,1)) == -1) return NULL;
    if ((SWIG_ConvertPtr(argo1,(void **) &arg1,SWIGTYPE_p_POINT,1)) == -1) return NULL;
    arg0->pblc_key = *arg1;
    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_EC_KEYPAIR_pblc_key_get(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    EC_KEYPAIR *arg0 ;
    PyObject * argo0 =0 ;
    POINT *result ;
    
    if(!PyArg_ParseTuple(args,"O:EC_KEYPAIR_pblc_key_get",&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_EC_KEYPAIR,1)) == -1) return NULL;
    result = (POINT *)& (arg0->pblc_key);
    resultobj = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_POINT);
    return resultobj;
}


static PyObject *_wrap_new_SIGNATURE(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    SIGNATURE *result ;
    
    if(!PyArg_ParseTuple(args,":new_SIGNATURE")) return NULL;
    result = (SIGNATURE *)(SIGNATURE *) calloc(1, sizeof(SIGNATURE));
    resultobj = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_SIGNATURE);
    return resultobj;
}


static PyObject *_wrap_delete_SIGNATURE(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    SIGNATURE *arg0 ;
    PyObject * argo0 =0 ;
    
    if(!PyArg_ParseTuple(args,"O:delete_SIGNATURE",&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_SIGNATURE,1)) == -1) return NULL;
    free((char *) arg0);
    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_SIGNATURE_c_set(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    SIGNATURE *arg0 ;
    FIELD2N *arg1 ;
    PyObject * argo0 =0 ;
    PyObject * argo1 =0 ;
    
    if(!PyArg_ParseTuple(args,"OO:SIGNATURE_c_set",&argo0,&argo1)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_SIGNATURE,1)) == -1) return NULL;
    if ((SWIG_ConvertPtr(argo1,(void **) &arg1,SWIGTYPE_p_FIELD2N,1)) == -1) return NULL;
    arg0->c = *arg1;
    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_SIGNATURE_c_get(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    SIGNATURE *arg0 ;
    PyObject * argo0 =0 ;
    FIELD2N *result ;
    
    if(!PyArg_ParseTuple(args,"O:SIGNATURE_c_get",&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_SIGNATURE,1)) == -1) return NULL;
    result = (FIELD2N *)& (arg0->c);
    resultobj = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_FIELD2N);
    return resultobj;
}


static PyObject *_wrap_SIGNATURE_d_set(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    SIGNATURE *arg0 ;
    FIELD2N *arg1 ;
    PyObject * argo0 =0 ;
    PyObject * argo1 =0 ;
    
    if(!PyArg_ParseTuple(args,"OO:SIGNATURE_d_set",&argo0,&argo1)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_SIGNATURE,1)) == -1) return NULL;
    if ((SWIG_ConvertPtr(argo1,(void **) &arg1,SWIGTYPE_p_FIELD2N,1)) == -1) return NULL;
    arg0->d = *arg1;
    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_SIGNATURE_d_get(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    SIGNATURE *arg0 ;
    PyObject * argo0 =0 ;
    FIELD2N *result ;
    
    if(!PyArg_ParseTuple(args,"O:SIGNATURE_d_get",&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_SIGNATURE,1)) == -1) return NULL;
    result = (FIELD2N *)& (arg0->d);
    resultobj = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_FIELD2N);
    return resultobj;
}


static PyObject *_wrap_new_POINT(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    POINT *result ;
    
    if(!PyArg_ParseTuple(args,":new_POINT")) return NULL;
    result = (POINT *)(POINT *) calloc(1, sizeof(POINT));
    resultobj = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_POINT);
    return resultobj;
}


static PyObject *_wrap_delete_POINT(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    POINT *arg0 ;
    PyObject * argo0 =0 ;
    
    if(!PyArg_ParseTuple(args,"O:delete_POINT",&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_POINT,1)) == -1) return NULL;
    free((char *) arg0);
    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_POINT_x_set(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    POINT *arg0 ;
    FIELD2N *arg1 ;
    PyObject * argo0 =0 ;
    PyObject * argo1 =0 ;
    
    if(!PyArg_ParseTuple(args,"OO:POINT_x_set",&argo0,&argo1)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_POINT,1)) == -1) return NULL;
    if ((SWIG_ConvertPtr(argo1,(void **) &arg1,SWIGTYPE_p_FIELD2N,1)) == -1) return NULL;
    arg0->x = *arg1;
    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_POINT_x_get(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    POINT *arg0 ;
    PyObject * argo0 =0 ;
    FIELD2N *result ;
    
    if(!PyArg_ParseTuple(args,"O:POINT_x_get",&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_POINT,1)) == -1) return NULL;
    result = (FIELD2N *)& (arg0->x);
    resultobj = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_FIELD2N);
    return resultobj;
}


static PyObject *_wrap_POINT_y_set(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    POINT *arg0 ;
    FIELD2N *arg1 ;
    PyObject * argo0 =0 ;
    PyObject * argo1 =0 ;
    
    if(!PyArg_ParseTuple(args,"OO:POINT_y_set",&argo0,&argo1)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_POINT,1)) == -1) return NULL;
    if ((SWIG_ConvertPtr(argo1,(void **) &arg1,SWIGTYPE_p_FIELD2N,1)) == -1) return NULL;
    arg0->y = *arg1;
    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_POINT_y_get(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    POINT *arg0 ;
    PyObject * argo0 =0 ;
    FIELD2N *result ;
    
    if(!PyArg_ParseTuple(args,"O:POINT_y_get",&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_POINT,1)) == -1) return NULL;
    result = (FIELD2N *)& (arg0->y);
    resultobj = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_FIELD2N);
    return resultobj;
}


static PyObject *_wrap_safeString_sz_set(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    safeString *arg0 ;
    int arg1 ;
    PyObject * argo0 =0 ;
    
    if(!PyArg_ParseTuple(args,"Oi:safeString_sz_set",&argo0,&arg1)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_safeString,1)) == -1) return NULL;
    arg0->sz = arg1;
    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_safeString_sz_get(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    safeString *arg0 ;
    PyObject * argo0 =0 ;
    int result ;
    
    if(!PyArg_ParseTuple(args,"O:safeString_sz_get",&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_safeString,1)) == -1) return NULL;
    result = (int ) (arg0->sz);
    resultobj = PyInt_FromLong((long)result);
    return resultobj;
}


static PyObject *_wrap_safeString_bytes_set(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    safeString *arg0 ;
    char *arg1 ;
    PyObject * argo0 =0 ;
    PyObject * obj1  = 0 ;
    
    if(!PyArg_ParseTuple(args,"OO:safeString_bytes_set",&argo0,&obj1)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_safeString,1)) == -1) return NULL;
    {
        if ( !PyString_Check(obj1) ) {
            PyErr_SetString(PyExc_TypeError,"not a string, man.");
            return NULL;
        }
        arg1 = PyString_AsString(obj1);
    }
    arg0->bytes = arg1;
    Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_safeString_bytes_get(PyObject *self, PyObject *args) {
    PyObject *resultobj;
    safeString *arg0 ;
    PyObject * argo0 =0 ;
    char *result ;
    
    if(!PyArg_ParseTuple(args,"O:safeString_bytes_get",&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_safeString,1)) == -1) return NULL;
    result = (char *) (arg0->bytes);
    resultobj = PyString_FromString(result);
    return resultobj;
}


static PyMethodDef ellipticcMethods[] = {
	 { "ptrvalue", _wrap_ptrvalue, METH_VARARGS },
	 { "ptrset", _wrap_ptrset, METH_VARARGS },
	 { "ptrcreate", _wrap_ptrcreate, METH_VARARGS },
	 { "ptrfree", _wrap_ptrfree, METH_VARARGS },
	 { "ptradd", _wrap_ptradd, METH_VARARGS },
	 { "makeSecretKey", _wrap_makeSecretKey, METH_VARARGS },
	 { "makeKeypair", _wrap_makeKeypair, METH_VARARGS },
	 { "makeBaseCurve", _wrap_makeBaseCurve, METH_VARARGS },
	 { "init", _wrap_init, METH_VARARGS },
	 { "field2bin", _wrap_field2bin, METH_VARARGS },
	 { "bin2field", _wrap_bin2field, METH_VARARGS },
	 { "DH_gen", _wrap_DH_gen, METH_VARARGS },
	 { "DH_recv", _wrap_DH_recv, METH_VARARGS },
	 { "NR_Signature", _wrap_NR_Signature, METH_VARARGS },
	 { "NR_Verify", _wrap_NR_Verify, METH_VARARGS },
	 { "new_FIELD2N", _wrap_new_FIELD2N, METH_VARARGS },
	 { "delete_FIELD2N", _wrap_delete_FIELD2N, METH_VARARGS },
	 { "FIELD2N_e_get", _wrap_FIELD2N_e_get, METH_VARARGS },
	 { "new_EC_PARAMETER", _wrap_new_EC_PARAMETER, METH_VARARGS },
	 { "delete_EC_PARAMETER", _wrap_delete_EC_PARAMETER, METH_VARARGS },
	 { "EC_PARAMETER_crv_set", _wrap_EC_PARAMETER_crv_set, METH_VARARGS },
	 { "EC_PARAMETER_crv_get", _wrap_EC_PARAMETER_crv_get, METH_VARARGS },
	 { "EC_PARAMETER_pnt_set", _wrap_EC_PARAMETER_pnt_set, METH_VARARGS },
	 { "EC_PARAMETER_pnt_get", _wrap_EC_PARAMETER_pnt_get, METH_VARARGS },
	 { "EC_PARAMETER_pnt_order_set", _wrap_EC_PARAMETER_pnt_order_set, METH_VARARGS },
	 { "EC_PARAMETER_pnt_order_get", _wrap_EC_PARAMETER_pnt_order_get, METH_VARARGS },
	 { "EC_PARAMETER_cofactor_set", _wrap_EC_PARAMETER_cofactor_set, METH_VARARGS },
	 { "EC_PARAMETER_cofactor_get", _wrap_EC_PARAMETER_cofactor_get, METH_VARARGS },
	 { "new_EC_KEYPAIR", _wrap_new_EC_KEYPAIR, METH_VARARGS },
	 { "delete_EC_KEYPAIR", _wrap_delete_EC_KEYPAIR, METH_VARARGS },
	 { "EC_KEYPAIR_prvt_key_set", _wrap_EC_KEYPAIR_prvt_key_set, METH_VARARGS },
	 { "EC_KEYPAIR_prvt_key_get", _wrap_EC_KEYPAIR_prvt_key_get, METH_VARARGS },
	 { "EC_KEYPAIR_pblc_key_set", _wrap_EC_KEYPAIR_pblc_key_set, METH_VARARGS },
	 { "EC_KEYPAIR_pblc_key_get", _wrap_EC_KEYPAIR_pblc_key_get, METH_VARARGS },
	 { "new_SIGNATURE", _wrap_new_SIGNATURE, METH_VARARGS },
	 { "delete_SIGNATURE", _wrap_delete_SIGNATURE, METH_VARARGS },
	 { "SIGNATURE_c_set", _wrap_SIGNATURE_c_set, METH_VARARGS },
	 { "SIGNATURE_c_get", _wrap_SIGNATURE_c_get, METH_VARARGS },
	 { "SIGNATURE_d_set", _wrap_SIGNATURE_d_set, METH_VARARGS },
	 { "SIGNATURE_d_get", _wrap_SIGNATURE_d_get, METH_VARARGS },
	 { "new_POINT", _wrap_new_POINT, METH_VARARGS },
	 { "delete_POINT", _wrap_delete_POINT, METH_VARARGS },
	 { "POINT_x_set", _wrap_POINT_x_set, METH_VARARGS },
	 { "POINT_x_get", _wrap_POINT_x_get, METH_VARARGS },
	 { "POINT_y_set", _wrap_POINT_y_set, METH_VARARGS },
	 { "POINT_y_get", _wrap_POINT_y_get, METH_VARARGS },
	 { "safeString_sz_set", _wrap_safeString_sz_set, METH_VARARGS },
	 { "safeString_sz_get", _wrap_safeString_sz_get, METH_VARARGS },
	 { "safeString_bytes_set", _wrap_safeString_bytes_set, METH_VARARGS },
	 { "safeString_bytes_get", _wrap_safeString_bytes_get, METH_VARARGS },
	 { NULL, NULL }
};

#ifdef __cplusplus
}
#endif

/* -------- TYPE CONVERSION AND EQUIVALENCE RULES (BEGIN) -------- */

static swig_type_info _swigt__p_EC_KEYPAIR[] = {{"_p_EC_KEYPAIR", 0, "EC_KEYPAIR *"},{"_p_EC_KEYPAIR"},{0}};
static swig_type_info _swigt__p_double[] = {{"_p_double", 0, "double *"},{"_p_double"},{0}};
static swig_type_info _swigt__p_unsigned_long[] = {{"_p_unsigned_long", 0, "unsigned long *"},{"_p_unsigned_long"},{0}};
static swig_type_info _swigt__p_float[] = {{"_p_float", 0, "float *"},{"_p_float"},{0}};
static swig_type_info _swigt__p_safeString[] = {{"_p_safeString", 0, "safeString *"},{"_p_safeString"},{0}};
static swig_type_info _swigt__p_void[] = {{"_p_void", 0, "void *"},{"_p_void"},{0}};
static swig_type_info _swigt__p_short[] = {{"_p_short", 0, "short *"},{"_p_short"},{0}};
static swig_type_info _swigt__p_p_char[] = {{"_p_p_char", 0, "char **"},{"_p_p_char"},{0}};
static swig_type_info _swigt__p_char[] = {{"_p_char", 0, "char *"},{"_p_char"},{0}};
static swig_type_info _swigt__p_SIGNATURE[] = {{"_p_SIGNATURE", 0, "SIGNATURE *"},{"_p_SIGNATURE"},{0}};
static swig_type_info _swigt__p_EC_PARAMETER[] = {{"_p_EC_PARAMETER", 0, "EC_PARAMETER *"},{"_p_EC_PARAMETER"},{0}};
static swig_type_info _swigt__p_long[] = {{"_p_long", 0, "long *"},{"_p_long"},{0}};
static swig_type_info _swigt__p_POINT[] = {{"_p_POINT", 0, "POINT *"},{"_p_POINT"},{0}};
static swig_type_info _swigt__p_int[] = {{"_p_int", 0, "int *"},{"_p_int"},{0}};
static swig_type_info _swigt__p_FIELD2N[] = {{"_p_FIELD2N", 0, "FIELD2N *"},{"_p_FIELD2N"},{0}};
static swig_type_info _swigt__p_CURVE[] = {{"_p_CURVE", 0, "CURVE *"},{"_p_CURVE"},{0}};

static swig_type_info *swig_types_initial[] = {
_swigt__p_EC_KEYPAIR, 
_swigt__p_double, 
_swigt__p_unsigned_long, 
_swigt__p_float, 
_swigt__p_safeString, 
_swigt__p_void, 
_swigt__p_short, 
_swigt__p_p_char, 
_swigt__p_char, 
_swigt__p_SIGNATURE, 
_swigt__p_EC_PARAMETER, 
_swigt__p_long, 
_swigt__p_POINT, 
_swigt__p_int, 
_swigt__p_FIELD2N, 
_swigt__p_CURVE, 
0
};


/* -------- TYPE CONVERSION AND EQUIVALENCE RULES (END) -------- */

static swig_const_info swig_const_table[] = {
{0}};

static PyObject *SWIG_globals;
#ifdef __cplusplus
extern "C" 
#endif
SWIGEXPORT(void) initellipticc(void) {
    PyObject *m, *d;
    int i;
    SWIG_globals = SWIG_newvarlink();
    m = Py_InitModule("ellipticc", ellipticcMethods);
    d = PyModule_GetDict(m);
    for (i = 0; swig_types_initial[i]; i++) {
        swig_types[i] = SWIG_TypeRegister(swig_types_initial[i]);
    }
    
    SWIG_POINTER_int_p = SWIG_TypeQuery("int *");
    SWIG_POINTER_short_p = SWIG_TypeQuery("short *");
    SWIG_POINTER_long_p = SWIG_TypeQuery("long *");
    SWIG_POINTER_float_p = SWIG_TypeQuery("float *");
    SWIG_POINTER_double_p = SWIG_TypeQuery("double *");
    SWIG_POINTER_char_p = SWIG_TypeQuery("char *");
    SWIG_POINTER_char_pp = SWIG_TypeQuery("char **");
    PyDict_SetItemString(d,"cvar", SWIG_globals);
    SWIG_addvarlink(SWIG_globals,"random_seed",_wrap_random_seed_get, _wrap_random_seed_set);
    SWIG_InstallConstants(d,swig_const_table);
}

