#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#ifdef STDC_HEADERS
# include <string.h>
#else
# ifndef HAVE_STRCHR
#  define strchr index
#  define strrchr rindex
# endif
char *strchr(), *strrchr();
# ifndef HAVE_MEMCPY
#  define memcpy(d, s, n) bcopy ((s), (d), (n))
#  define memmove(d, s, n) bcopy ((s), (d), (n))
# endif
#endif

#ifdef HAVE_UNISTD_H
# include <sys/types.h>
# include <unistd.h>
#endif

#ifdef STAT_MACROS_BROKEN
# include "posixstat.h"
#endif

#if STDC_HEADERS
# include <stdlib.h>
#endif

#if defined(HAVE_LIBIBERTY_H) && !defined(NEED_XMALLOC)
#include <libiberty.h>		/* Part of libiberty.a that comes with binutils */
#else
extern void *xmalloc(size_t);
extern void *xrealloc(void *ptr, size_t size);
#endif

#ifndef NULL
# ifdef __STDC__
#   define NULL ((void *)0)
# else
#   define NULL (0x0)
# endif
#endif

#ifndef HAVE_GETCWD
# ifdef HAVE_GETWD
#   define getcwd(a, b) getwd(a)
# else
#   error "You either need getcwd(3) or getwd(3)"
# endif
#endif

/*
     SET_BINARY (STDIN_FILENO);
     SET_BINARY (STDOUT_FILENO);

     MS-DOS and similar non-Posix systems have some peculiarities:
    - they distinguish between binary and text files;
    - they use both `/' and `\\' as directory separator in file names;
    - they can have a drive letter X: prepended to a file name;
    - they have a separate root directory on each drive;
    - their filesystems are case-insensitive;
    - directories in environment variables (like PATH) are separated
        by `;' rather than `:';
    - text files can have their lines ended either with \n or with \r\n pairs;
   These are all parameterized here except.  */
#ifndef O_BINARY
# include <fcntl.h>
# ifdef _O_BINARY
#  define O_BINARY _O_BINARY
#else
#  define O_BINARY 0
# endif
#endif /* O_BINARY */

#ifndef __GW32__
#if O_BINARY 
# include <io.h>
# ifdef __CYGWIN__
#  define PATH_SEP                          ':'
#  define DIR_SEP                                 '/'
# else  /* O_BINARY && !__CYGWIN__ */
#  define PATH_SEP                          ';'
#  ifdef __DJGPP__
#   define DIR_SEP                                '/'
#  else
#   define DIR_SEP                                '\\'
#  endif
# endif /* O_BINARY && !__CYGWIN__ */
# if defined __MSDOS__ || defined _WIN32
#  ifndef HAVE_LC_MESSAGES
#   define LC_MESSAGES (-1)
#  endif
#  define GET_PROGRAM_NAME(progname, name)  \
   do {                                     \
     char *p, *my_program_name;             \
                                            \
     p = strrchr((name), DIR_SEP);              \
     if (p == NULL)                         \
       p = (name);                          \
     else                                   \
       p++;                                 \
                                            \
     my_program_name = strdup(p);           \
     p = strrchr(my_program_name, '.');     \
     if (p != NULL)                         \
       *p = '\0';                           \
                                            \
     progname = my_program_name;            \
   } while (0)
# else   /* O_BINARY && !__MSDOS__ */
#  define setmode(f,m)                      _setmode(f,m)
# endif  /* O_BINARY && !__MSDOS__ */
  /* Back to any O_BINARY system.  */
# define HAVE_DRIVE(n)                      ((n)[0] && (n)[1] == ':')
# define IS_SLASH(c)                        ((c) == '/' || (c) == '\\')
# define IS_ABSOLUTE(n)                     (IS_SLASH((n)[0]) || ((n)[0] && (n)[1] == ':'))
# define SET_BINARY(f)                      do {if (!isatty(f)) setmode(f,O_BINARY);} while (0)
# ifndef GET_PROGRAM_NAME
#  define GET_PROGRAM_NAME(progname, name)  do {(progname) = (name);} while (0)
# endif
#else  /* not O_BINARY, i.e., Unix */
# define SET_BINARY(f)                      (void)0
# define IS_SLASH(c)                        ((c) == '/')
# define HAVE_DRIVE(n)                      (0)
# define IS_ABSOLUTE(n)                     ((n)[0] == '/')
# define PATH_SEP                           ':'
# define DIR_SEP                            '/'
# define GET_PROGRAM_NAME(progname, name)   do {(progname) = (name);} while (0)
#endif /* not O_BINARY */
#endif /* __GW32__ */
