#!/bin/sh

set -e

# Determine available docker binary
_docker=$(command -v 'podman') || \
_docker=$(command -v 'docker') || \
{ echo 'docker not found'; exit 1; }

BUILD='codeberg.org/gruf/go-ffmpreg'
$_docker build --file=build/build.dockerfile \
               --build-arg=RELEASE=1 \
               --tag="${BUILD}:latest"

id=$($_docker run --detach --rm "${BUILD}:latest" tail -f /dev/null)
$_docker cp "${id}:/build/ffmpreg.gz" 'embed/ffmpreg.wasm.gz'
$_docker kill "$id"
