use miette::{Context, IntoDiagnostic};
use std::path::PathBuf;

pub fn berg_data_dir() -> miette::Result<PathBuf> {
    let dir = dirs::data_dir().context("Couldn't find data directory for saving the token.")?;

    let data_dir = dir.join("berg-cli");

    // TODO: remove in a future version, added in 0.4.x
    //
    // This moves pre-existing data directories into the new "left" directory
    let legacy_data_dir = dir.join(".berg-cli");
    if legacy_data_dir.exists() {
        std::fs::rename(legacy_data_dir, data_dir.as_path())
            .into_diagnostic()
            .context("Failed to migrate config!")?;
    }

    Ok(data_dir)
}

pub fn berg_config_dir() -> miette::Result<PathBuf> {
    let config_dir = dirs::config_dir()
        .context("Couldn't find config directory for saving global config")
        .map(|dir| dir.join("berg-cli"))?;

    // TODO: remove in a future version, added in 0.4.x
    //
    // This moves pre-existing configs into the new "left" directory
    dirs::data_dir()
        .into_iter()
        .flat_map(|data_dir| [data_dir.join("berg-cli"), data_dir.join(".berg-cli")])
        .for_each(|dir| {
            let file = dir.join("berg.toml");
            _ = std::fs::create_dir_all(config_dir.as_path());
            _ = std::fs::rename(file, config_dir.join("berg.toml"));
        });

    Ok(config_dir)
}

/// Tokens are saved per forgejo instance = per base url to allow users to use multiple instances
/// smoothly without logging out inbetween
pub fn token_path(instance: impl AsRef<str>) -> miette::Result<PathBuf> {
    berg_data_dir()
        .map(|token_dir| token_dir.join(instance.as_ref()).join("TOKEN"))
        .context("token path not found")
}

pub fn config_path() -> miette::Result<PathBuf> {
    berg_config_dir()
        .map(|dir| dir.join("berg.toml"))
        .context("config path not found")
}
