pub mod info;

use clap::Subcommand;

use super::GlobalArgs;

/// User subcommands
#[derive(Subcommand, Debug)]
pub enum UserArgs {
    Info(info::UserInfoArgs),
}

impl UserArgs {
    pub async fn run(self, global_args: GlobalArgs) -> miette::Result<()> {
        match self {
            UserArgs::Info(args) => args.run(global_args).await,
        }
    }
}
