use crate::actions::GlobalArgs;
use crate::types::context::BergContext;
use crate::types::git::OwnerRepo;

use clap::Parser;
use miette::IntoDiagnostic;

/// Delete a branch
#[derive(Parser, Debug)]
pub struct RepoBranchDeleteArgs {
    /// Branch name to delete
    #[arg(value_name = "BRANCH")]
    pub branch: String,
}

impl RepoBranchDeleteArgs {
    pub async fn run(self, global_args: GlobalArgs) -> miette::Result<()> {
        let ctx = BergContext::new(self, global_args).await?;

        let OwnerRepo { repo, owner } = ctx.owner_repo()?;

        ctx.client
            .repo_delete_branch(owner.as_str(), repo.as_str(), ctx.args.branch.as_str())
            .await
            .into_diagnostic()?;

        println!("Branch '{}' deleted successfully", ctx.args.branch);

        Ok(())
    }
}
