use crate::render::option::option_display;

pub mod create;
pub mod edit;
pub mod list;
pub mod view;

use clap::Subcommand;

use super::GlobalArgs;

/// Milestone subcommands
#[derive(Subcommand, Debug)]
pub enum MilestoneArgs {
    List(list::ListMilestonesArgs),
    View(view::ViewMilestonesArgs),
    Create(create::CreateMilestoneArgs),
    Edit(edit::EditMilestoneArgs),
}

impl MilestoneArgs {
    pub async fn run(self, global_args: GlobalArgs) -> miette::Result<()> {
        match self {
            MilestoneArgs::List(args) => args.run(global_args).await,
            MilestoneArgs::View(args) => args.run(global_args).await,
            MilestoneArgs::Create(args) => args.run(global_args).await,
            MilestoneArgs::Edit(args) => args.run(global_args).await,
        }
    }
}

fn display_milestone(milestone: &forgejo_api::structs::Milestone) -> String {
    option_display(&milestone.title)
}
