mod gpg;
mod ssh;

use clap::Subcommand;

use super::GlobalArgs;

/// Key management subcommands
#[derive(Subcommand, Debug)]
pub enum KeysArgs {
    #[clap(subcommand)]
    Gpg(gpg::GpgArgs),
    #[clap(subcommand)]
    Ssh(ssh::SshArgs),
}

impl KeysArgs {
    pub async fn run(self, global_args: GlobalArgs) -> miette::Result<()> {
        match self {
            KeysArgs::Gpg(args) => args.run(global_args).await,
            KeysArgs::Ssh(args) => args.run(global_args).await,
        }
    }
}
