{ inputs, ... }:
{
  perSystem =
    {
      self',
      pkgs,
      lib,
      ...
    }:
    let
      testLib = inputs.self.testLib { inherit self' lib pkgs; };
    in
    {
      checks =
        {
          configInfo = {
            test = ''
              expected_config = {'base_url': 'forgejo:3000', 'protocol': 'http', 'fancy_tables': True, 'no_color': False, 'editor': 'nano', 'max_width': 80}
              print(expected_config)
              actual_config = ${testLib.berg_run_json { cmd = "config info"; }}
              printj(actual_config)
              assert expected_config == actual_config, f"config info returns expected config\nexpected:{expected_config}\ngot:{actual_config}"
            '';
          };
          configGenerateToml = {
            test = ''
              actual_config = ${testLib.berg_run { cmd = "config generate --location stdout"; }}

              expected_items = ["base_url", "protocol", "fancy_tables", "no_color", "editor", "max_width", "forgejo:3000", "nano"]
              for item in expected_items:
                assert item in actual_config, f"config info returns config with {item}\n{actual_config}"
            '';
          };
          configGenerateJson = {
            test = ''
              expected_config = {'base_url': 'forgejo:3000', 'protocol': 'http', 'fancy_tables': True, 'no_color': False, 'editor': 'nano', 'max_width': 80}
              print(expected_config)

              actual_config = ${testLib.berg_run_json { cmd = "config generate --location stdout"; }}
              printj(actual_config)

              assert expected_config == actual_config, f"config info returns expected config\nexpected:{expected_config}\ngot:{actual_config}"
            '';
          };
          configGenerateLocalTwice = {
            test = ''
              ${testLib.berg_run { cmd = "config generate --location local"; }}
              ${testLib.berg_run {
                cmd = "config generate --location local";
                success = false;
              }}
            '';
          };
          configGenerateGlobalTwice = {
            test = ''
              ${testLib.berg_run { cmd = "config generate --location global"; }}
              ${testLib.berg_run {
                cmd = "config generate --location global";
                success = false;
              }}
            '';
          };
        }
        |> testLib.embeddInFlake;
    };
}
