{ inputs, ... }:
{
  perSystem =
    {
      self',
      pkgs,
      lib,
      ...
    }:
    let
      testLib = inputs.self.testLib { inherit self' lib pkgs; };
    in
    {
      checks =
        {
          version = {
            withAuth = true;
            test = ''
              api_version = ${testLib.berg_run_json { cmd = "api version"; }}

              assert api_version["version"] == "${pkgs.forgejo.version}", f"api version was unexpected\n{api_version}"
            '';
          };
        }
        |> testLib.embeddInFlake;
    };
}
