{
  flake.sharedLib = rec {
    forgejo = {
      run = "su -- forgejo forgejo admin user --work-path /var/lib/forgejo";
      hostname = "forgejo";
      port = 3000;
      baseConfig =
        {
          self',
          pkgs,
          ...
        }:
        {
          environment = {
            systemPackages = [
              pkgs.forgejo
              pkgs.curl
              pkgs.git
              self'.packages.berg
            ];
            variables = {
              BERG_BASE_URL = "${forgejo.hostname}:${builtins.toString forgejo.port}";
              BERG_PROTOCOL = "http";
            };
          };

          programs = {
            git = {
              enable = true;
              config = {
                user = {
                  inherit email;
                  name = user;
                };
                credential.helper = "store";
              };
            };
          };

          services.forgejo = {
            enable = true;
            package = pkgs.forgejo;
            settings = {
              default = {
                RUN_MODE = "dev";
              };
              server = {
                ROOT_URL = "${forgejo.hostname}:${builtins.toString forgejo.port}";
              };
            };
          };

          system.stateVersion = "25.05";
        };
    };
    user = "userx";
    email = "userx@example.com";
    otherUser = "usery";
    otherEmail = "usery@example.com";
    pass = "pass";
    repo = "foo";
    otherRepo = "bar";
    main = "main";
    branch = "change";
    allScopes = [
      "activitypub"
      "issue"
      "notification"
      "organization"
      "package"
      "repository"
      "user"
    ];
  };
}
