{ inputs, ... }:
{
  perSystem =
    {
      self',
      lib,
      pkgs,
      ...
    }:
    let
      tapeTestLib = inputs.self.tapeTestLib { inherit self' lib pkgs; };
    in
    {
      checks = tapeTestLib.embeddInFlake {
        login = {
          exec = [
            ''Type "berg auth login --token TOKEN"''
            ''Sleep 500ms''
            ''Enter''
            ''Sleep 3s''
          ];
        };
        logout = {
          extraSetup = [
            "berg auth login --token TOKEN"
          ];
          exec = [
            ''Type "berg repo create"''
            ''Sleep 500ms''
            ''Enter''
            ''Sleep 1500ms''
            ''Ctrl+C''
            ''Type "berg auth logout"''
            ''Sleep 500ms''
            ''Enter''
            ''Sleep 1500ms''
            ''Type "y"''
            ''Sleep 500ms''
            ''Enter''
            ''Sleep 3s''
            ''Type "berg repo create"''
            ''Sleep 500ms''
            ''Enter''
            ''Sleep 3s''
          ];
        };
      };
    };
}
