use clap::ValueEnum;
use forgejo_api::structs::RepoListPullRequestsQuerySort;
use strum::{Display, EnumIter, EnumString};

#[derive(Debug, Clone, Copy, Default, PartialEq, Eq, Display, EnumString, ValueEnum, EnumIter)]
#[strum(serialize_all = "lowercase")]
pub enum PullRequestsQuerySort {
    Oldest,
    #[default]
    Recentupdate,
    Leastupdate,
    Mostcomment,
    Leastcomment,
    Priority,
}

impl PullRequestsQuerySort {
    pub fn into(self) -> RepoListPullRequestsQuerySort {
        match self {
            Self::Oldest => RepoListPullRequestsQuerySort::Oldest,
            Self::Recentupdate => RepoListPullRequestsQuerySort::Recentupdate,
            Self::Leastupdate => RepoListPullRequestsQuerySort::Leastupdate,
            Self::Mostcomment => RepoListPullRequestsQuerySort::Mostcomment,
            Self::Leastcomment => RepoListPullRequestsQuerySort::Leastcomment,
            Self::Priority => RepoListPullRequestsQuerySort::Priority,
        }
    }
}
