use crate::render::option::option_display;

pub mod comment;
pub mod create;
pub mod edit;
pub mod list;
pub mod view;

use clap::Subcommand;

use super::GeneralArgs;

/// Pull request subcommands
#[derive(Subcommand, Debug)]
pub enum PullRequestArgs {
    List(list::ListPullRequestArgs),
    Create(create::CreatePullRequestArgs),
    Edit(edit::EditPullRequestArgs),
    View(view::ViewPullRequestsArgs),
    Comment(comment::CommentPullRequestArgs),
}

impl PullRequestArgs {
    pub async fn run(self, general_args: GeneralArgs) -> anyhow::Result<()> {
        match self {
            PullRequestArgs::List(args) => args.run(general_args).await,
            PullRequestArgs::Create(args) => args.run(general_args).await,
            PullRequestArgs::Edit(args) => args.run(general_args).await,
            PullRequestArgs::View(args) => args.run(general_args).await,
            PullRequestArgs::Comment(args) => args.run(general_args).await,
        }
    }
}

fn display_pull_request(pull_request: &forgejo_api::structs::PullRequest) -> String {
    let nr = option_display(&pull_request.number);
    let title = option_display(&pull_request.title);
    format!("#{nr}:{title}")
}
