use crate::render::option::option_display;

pub mod create;
pub mod delete;
pub mod edit;
pub mod list;

use clap::Subcommand;

use super::GeneralArgs;

/// Label subcommands
#[derive(Subcommand, Debug)]
pub enum LabelArgs {
    List(list::ListLabelsArgs),
    Create(create::CreateLabelArgs),
    Delete(delete::DeleteLabelArgs),
    Edit(edit::EditLabelArgs),
}

impl LabelArgs {
    pub async fn run(self, general_args: GeneralArgs) -> anyhow::Result<()> {
        match self {
            LabelArgs::List(args) => args.run(general_args).await,
            LabelArgs::Create(args) => args.run(general_args).await,
            LabelArgs::Delete(args) => args.run(general_args).await,
            LabelArgs::Edit(args) => args.run(general_args).await,
        }
    }
}

fn display_label(label: &forgejo_api::structs::Label) -> String {
    option_display(&label.name)
}
