pub mod version;

use clap::Subcommand;

use super::GeneralArgs;

/// API subcommands
#[derive(Debug, Subcommand)]
pub enum ApiArgs {
    Version(version::ApiVersionArgs),
}

impl ApiArgs {
    pub async fn run(self, general_args: GeneralArgs) -> anyhow::Result<()> {
        match self {
            ApiArgs::Version(args) => args.run(general_args).await,
        }
    }
}
