{ inputs, ... }:
{
  perSystem =
    {
      self',
      pkgs,
      lib,
      ...
    }:
    let
      testLib = inputs.self.testLib { inherit self' lib pkgs; };
    in
    {
      checks =
        {
          user = {
            withAuth = true;
            test =
              # user info test
              ''
                user_resp = ${testLib.berg_run_json { cmd = "user info"; }}
                printj(user_resp)

                assert user_resp["login"] == "${testLib.user}", f"user login incorrect\ngot:{user_resp}"
                assert user_resp["email"] == "${testLib.email}", f"user email incorrect\ngot:{user_resp}"
              '';
          };
        }
        |> testLib.embeddInFlake;
    };
}
