{ inputs, ... }:
{
  perSystem =
    {
      self',
      pkgs,
      lib,
      ...
    }:
    let
      testLib = inputs.self.testLib { inherit self' lib pkgs; };
    in
    {
      checks =
        {
          issueCreate = {
            withRepoSetup = true;
            withAuth = true;
            test = ''
              issue = ${
                testLib.berg_run_json {
                  cmd = ''issue create --title "oh noes, me found a bug" --description "The bug is bad! 🐛"'';
                  withTestRepo = true;
                }
              }

              printj(issue)

              assert issue["title"] == "oh noes, me found a bug", f"issue title incorrect\ngot:{issue}"
              assert issue["user"]["login"] == "${testLib.user}", f"issue user incorrect\ngot:{issue}"
              assert issue["body"] == "The bug is bad! 🐛", f"issue description incorrect\ngot:{issue}"
              assert issue["state"] == "open", f"issue state incorrect\ngot:{issue}"
              assert issue["repository"]["full_name"] == "${testLib.user}/${testLib.testRepo}", f"issue repository incorrect\ngot:{issue}"
            '';
          };
          issueList = {
            withRepoSetup = true;
            withAuth = true;
            test = ''
              issue = ${
                testLib.berg_run_json {
                  cmd = ''issue create --title "oh noes, me found a bug" --description "The bug is bad! 🐛"'';
                  withTestRepo = true;
                }
              }

              printj(issue)

              issue_list = ${
                testLib.berg_run_json {
                  cmd = ''issue list'';
                  withTestRepo = true;
                }
              }

              printj(issue_list)

              assert len(issue_list) == 1, f"issue list item incorrect\ngot:{issue_list}"
              assert issue_list[0] == issue, f"issue list item incorrect\ngot:{issue_list}"
            '';
          };
          issueComment = {
            withRepoSetup = true;
            withAuth = true;
            test = ''
              issue = ${
                testLib.berg_run_json {
                  cmd = ''issue create --title "oh noes, me found a bug" --description "The bug is bad! 🐛"'';
                  withTestRepo = true;
                }
              }

              printj(issue)

              comment = ${
                testLib.berg_run_json {
                  cmd = ''issue comment --id 1 --body "Hello, Comment World!"'';
                  withTestRepo = true;
                }
              }

              printj(comment)

              assert comment["body"] == "Hello, Comment World!", f"issue comment incorrect\ngot:{comment}"
              assert comment["id"] == 1, f"issue comment id incorrect\ngot:{comment}"
              assert comment["user"]["login"] == "${testLib.user}", f"issue commenter incorrect\ngot:{comment}"
              assert comment["issue_url"].endswith("/1"), f"issue comment number incorrect\ngot:{comment}"

              comment = ${
                testLib.berg_run_json {
                  cmd = ''issue comment --id 1 --body "Hello, Comment World again!"'';
                  withTestRepo = true;
                }
              }

              printj(comment)

              assert comment["body"] == "Hello, Comment World again!", f"issue comment incorrect\ngot:{comment}"
              assert comment["id"] == 2, f"issue comment id incorrect\ngot:{comment}"
              assert comment["user"]["login"] == "${testLib.user}", f"issue commenter incorrect\ngot:{comment}"
              assert comment["issue_url"].endswith("/1"), f"issue comment number incorrect\ngot:{comment}"
            '';
          };
        }
        |> testLib.embeddInFlake;
    };
}
