/* Rename mp3 files */
/* Warning, can "anally ream" your filenames */
/*              ^--- The internal version used the word fuck */
/*                      ^--- but that kind of language is not appropriate */

/*
    Run without any piped input for usage information.

    What it does:
    Removes all non alpha numeric characters from the name
    Captializes all descernable parts of title
    Strips off "_20" that can be inserted when saving from http
    lowercases .mp3 extention if present
    Replaces & with N
    Replaces , with -
    Replaces ({[]}) sequences with a - at beginning and end
    If first section is a one digit number and '-' it will make the digits take
        width of two. For track numbers.
    Pipe in from find(1) safe

    Resulting names only have capitalized words and '-' as separator
*/

/*
    Thanks to Laszlo "GCS" Boszormenyi <gcs@linuxfan.com> for spaceit 
    bug fixes and with recognizing accents in filenames.
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>              /* for isalnum, toupper, isdigit */
#include <unistd.h>             /* for isatty */

#define BUF_SZ 1024             /* Longest length for any line */

/* Prototype for function at bottom */
void usage();

int main(int argc, char **argv)
{
    char name[BUF_SZ],          /* Original name of song */
         newname[BUF_SZ],       /* Soon to be name of song */
         *beginning,            /* Beginning of actual name */
         *loc,                  /* name of song with dir location stripped */
         *locbegin,             /* Beginning of stripped name */
         *newloc,               /* Actual soon to be name of song */
         *ext,                  /* Extention of song, needs to be saved */
         *oname,                /* Orignial input, mv this to new */
         *minus = NULL,         /* Sequence to subtract from name */
         wordbreak,             /* Bool: capitalize next word? */
         move = 0,              /* Bool: go ahead with the mv command? */
         spaceit = 0;           /* Bool: space between words? */

    char extra[] = "";     /* National characters */

    /* Understand the command */
    if (argc == 1)
        move = 1;
    else {
        if (argv[1][0] != '-')
            move = 0;
        else {
            move = 1;
            minus = argv[1] + 1;
            if (argc > 2)
                move = 0;
        }
    }

    /* Check if there is a pipe in. Print usage and quit if not */
    if (isatty(fileno(stdin))) {
        usage();
    }

#ifdef SPACEIT
    spaceit = 1;
#endif /* SPACEIT */

    while (fgets(name, BUF_SZ, stdin) != NULL) {
        name[strlen(name) - 1] = '\0';          /* chomp */

        /* Skip if only "." is read (find) */
        if (!strcmp(name, "."))
            continue;

        /* Save original string */
        oname = (char *) strdup(name);

        /* strip directory location off string, only work on title */
        ext = (char *) strrchr(name, '/');
        if (ext == NULL) {
            loc = name;
            beginning = newname;
        } else {
            loc = ext + 1;
            *ext = '\0';
            sprintf(newname, "%s/", name);
            beginning = newname + strlen(newname);
        }
        
        newloc = beginning;
        locbegin = loc;

        /* Remove minus string from title if present */
        if (minus != NULL) {
            char *locat;

            locat = (char*) strstr(loc, minus);
            if (locat != NULL) {
                memmove(locat,
                        locat + strlen(minus),
                        strlen(locat + strlen(minus)) + 1);
            }
        }

        /* Save extention verbatim */
        ext = (char *) strrchr(loc, '.');
        if (ext != NULL) {
            *ext = '\0';
            ext += 1;
        }

        /* Go through the whole title */
        for (wordbreak = 1; *loc != '\0'; loc += 1) {

            if ((*loc == '(') ||
                (*loc == '[') ||
                (*loc == '{') ||
                (*loc == '<') ||
                (*loc == '-'))
            {
                wordbreak = 1;
                if ((newloc != beginning) && (*(newloc-1) != '-')) {
                    if (spaceit) {
                        *newloc = ' ';
                        newloc += 1;
                    }
                    *newloc = '-';
                    newloc += 1;
                    if (spaceit) {
                        *newloc = ' ';
                        newloc += 1;
                    }
                }
                continue;
            }

            if ((*loc == ')') ||
                (*loc == ']') ||
                (*loc == '}') ||
                (*loc == '>'))
            {
                if ((*(loc+1) != '\0') && (*(newloc-1) != '-')) {
                    *newloc = '-';
                    newloc += 1;
                }
                continue;
            }

            /* Only save character if it's alphanumeric,
                capitalize if new word
            */
            if ((isalnum(*loc)) || (strchr(extra, *loc) != NULL)) {
                if (wordbreak) {
                    if (spaceit && loc!=locbegin && *(newloc-1)!=' ') {
                        *newloc = ' ';
                        newloc += 1;
                    }
                    *newloc = toupper(*loc);
                    wordbreak = 0;
                }
                else
                    *newloc = *loc;
                newloc += 1;
                continue;
            }

            /* remove "_20" from all names */
            if ((*loc == '_') &&
                (*(loc+1) == '2') &&
                (*(loc+2) == '0'))
            {
                wordbreak = 1;
                loc += 2;
                continue;
            }

            /* Replace '&' with 'N' */
            if (*loc == '&') {
                wordbreak = 1;
                *newloc = 'N';
                newloc += 1;
                continue;
            }
            
            /* Add a '-' for commas */
            if (*loc == ',') {
                wordbreak = 1;
                *newloc = '-';
                newloc += 1;
                continue;
            }

            /* Make sure next word is capitalized, unless it's an '\'' */
            if (*loc != '\'')
                wordbreak = 1;
        }

        /* New title will NOT begin or end with a '-' */
        while (*(newloc-1) == '-')
            newloc -= 1;
        *newloc = '\0';

        /* Restore extention, lowercase mp3 if it is the extention */
        if (ext != NULL) {
            if (((*ext == 'm') || (*ext == 'M')) &&
                ((*(ext + 1) == 'p') || (*(ext + 1) == 'P')) &&
                (*(ext + 2) == '3'))
            {
                strcat(newname, ".mp3");
            }
            else
                sprintf(newname, "%s.%s", newname, ext);
        }

        /* Check if first part of title is track number, make width = 2 */
        newloc = strrchr(newname, '/');
        if (newloc == NULL)
            newloc = newname;
        else
            newloc += 1;
        /* Test if there is a number at the beginning */
        if ((isdigit(*newloc)) &&
            ((*(newloc+1) == '-') || (*(newloc+1) == ' '))) {
            memmove(newloc+2, newloc+1, strlen(newloc+1)+1);
            *(newloc+1) = *newloc;
            *newloc = '0';
        }

        /* Execute mv command */
        if (strcmp(oname, newname)) {
            char *cmd;

            cmd = malloc((2 * BUF_SZ + 10) * sizeof(char));
            sprintf(cmd, "mv \"%s\" \"%s\"", oname, newname);
            free(oname);
            printf("%s\n", cmd);
            if (move)
                system(cmd);
            free(cmd);
        }
    }
    return(0);
}

void usage()
{
    printf("rnmp3 %s:
    
Usage - pipe names into rnmp3. (\"find | rnmp3 args\")
    If first parameter starts with -, the following string will be removed
        from all names if they exist (enclose spaces with \"\")
    If any other commands are entered, commands will not be executed,
        just printed

    rnmp3                       Rename
    rnmp3 test                  Don't rename, just show changes
    rnmp3 -\"string\"             Rename after removing \"string\"
    rnmp3 -\"string\" test        Don't rename after removing \"string\"
    rnmp3 --test test           Rename after removing \"-test\"

    Before - \"1-This is my (file name) man.mp3\"
    After  - \"01-ThisIsMy-FileName-Man.mp3\"

Suggested uses:
    find . | rnmp3
    find . -type f | rnmp3\n", VERSION);

    exit(0);
}

/* EOF */
