#include "cmp3.h"
#include "cmp3id3.h"

#if !defined(CMP3_NO_NEED_VARS)
#include "cmp3vars.h"
#endif /* CMP3_NO_NEED_VARS */

/* cmp3curses.c */
extern void curs_init();
extern int dialogbox(char *message);
extern int inputbox(char *message, char *buffer, int bufflen);
extern int switchwin(int curwin);
extern void showhelp();
extern void refreshpad(int curwin);
extern void refreshpads();
extern void pads_clean();
extern void dialog_clean();
extern void after_list();
extern void after_dialog();
extern void after_down(int, int, int, int);
extern void after_up(int, int, int, int);
extern void after_npage(int, int, int, int, int);
extern void after_ppage(int, int, int, int, int);

/* cmp3general.c */
extern void enditall(int signum);
extern void initialize();
extern void shm_init();

/* cmp3llist.c */
extern void freeleft(void *node);
extern void freeright(void *node);
extern void printleft(void *thenode, int selected);
extern void printright(void *thenode, int selected);
extern void init_lists(char *directory, int leftnum, int rightnum);
extern void free_lists();

/* cmp3main.c */
extern void docmdline(int argc, char **argv);
extern void curs_init();
extern int *getcurline(void **thelist);

/* cmp3manager.c */
extern void manageit();
extern void dienow(int);
extern void listnext(int);

/* cmp3playlist.c */
extern char dolist();
extern void pl_addentry(char *name);
extern void pl_delentry(char *name);
extern void pl_dupfirst();
extern void pl_clear();
extern void pl_randomize(int start);

/* cmp3fileio.c */
extern int dirchange(char *directory, char *delta);
extern void newdir(char *dirname);
extern void recursdir(char *dirname, int depth);
extern int isdir(char* directory, char* name);

/* cmp3common.c */
extern Sigfunc *Signal(int signo, Sigfunc *func);
extern char *Strdup(const char *string);
extern int Strcmp(const char *str1, const char *str2);
extern int Strncmp(const char *str1, const char *str2, int num);
extern int getline(char *var, int  maxbuf, FILE *input);

extern void *Malloc(size_t size);

/* cmp3listfiles.c */
extern void writelist(char *filepath);
extern void readlist(char *filepath);
extern int  isPlaylist(char *filename);
extern void readass(FILE *infile);
extern void readm3u(FILE *infile);
extern void readpls(FILE *infile);

/* cmp3volume.c */
extern void initvol();
extern void endvol();
extern void volclean();
extern void volup();
extern void voldown();

/* cmp3id3.c */
extern int readid3(id3info_t *songinfo, char *songfilename);

/* EOF */