#ifndef _CMP3_H
#define _CMP3_H

#if defined(__FreeBSD__)
#include <ncurses.h>
#include <termios.h>
#else
#include <curses.h>
#endif


#ifndef NCURSES_VERSION
  #error "This program requires ncurses to function"
#endif

#include <signal.h>
#include <dirent.h>
#include <string.h>
#include <unistd.h>
#include <ctype.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <sys/ioctl.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <sys/shm.h>
#include <sys/ipc.h>
#include <time.h>
#include <form.h>

/* kr these changes needed so cmp3shdump will build */
#include "nevlib/llist.h"
#include "nevlib/inifile.h"

/* Constant Defines */
#define MAX_LIST 1024
#define MAX_WIDTH 512 
#define MAX_FULL 1024
#define PLAYLIST_SIZE 32000
#define RECURS_DEPTH 4
#define CMP3_LOGFILE "/tmp/cmp3log"
#define DEFAULT_ASSFILE "playlist.ass"
#define CMP3_COOLLINE "Your Sargent Soggymuffin"

#ifndef EXEC_PARAMS
#define EXEC_PARAMS ""
#endif

/* Which window is focused */
#define FOCUSED_NONE  0
#define FOCUSED_LEFT  1
#define FOCUSED_RIGHT 2
#define FOCUSED_LIST  3
#define FOCUSED_HELP  4

/* Colors for each window */
#define CCOLOR_STD       1
#define CCOLOR_LEFT      2
#define CCOLOR_RIGHT     3
#define CCOLOR_LIST      4
#define CCOLOR_HIGHLIGHT 5
#define CCOLOR_HELP      6
#define CCOLOR_DIALOG    7

/* You really should let me have this one part for myself */
#define TITLE " Pandama's Cmp3 Player "CMP3_VER" "

/* For Signal */
typedef void Sigfunc(int);

/* Structure that sits in shared memory */
typedef struct shmdata {
    int  pid;                            /* mpg123 process pid */
    int  managpid;                       /* manager process pid */
    char pause;                          /* is mpg123 paused */
    int  using;                          /* number of cmp3's using shm */
    int  listlen;                        /* number of entries in playlist */
    char repeat;                         /* boolean for "repeat mode" */
    char *pltail;
    char plhead[PLAYLIST_SIZE];         /* the brains of the operation */
} shmdata_t;

/* Types for nodes in the left and right lists */
typedef struct list_left_s {
    char *name;
} list_left_t;

typedef struct list_right_s {
    char *name;
} list_right_t;

/* Types for the left and right pads */
typedef struct info_left_s {
    char directory[MAX_FULL];
    int line;
} info_left_t;

typedef struct info_right_s {
    int line;
} info_right_t;

#endif /* _CMP3_H */

/* EOF */
