// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.7
// source: google/spanner/admin/database/v1/backup_schedule.proto

package databasepb

import (
	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Defines specifications of the backup schedule.
type BackupScheduleSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required.
	//
	// Types that are assignable to ScheduleSpec:
	//
	//	*BackupScheduleSpec_CronSpec
	ScheduleSpec isBackupScheduleSpec_ScheduleSpec `protobuf_oneof:"schedule_spec"`
}

func (x *BackupScheduleSpec) Reset() {
	*x = BackupScheduleSpec{}
	mi := &file_google_spanner_admin_database_v1_backup_schedule_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *BackupScheduleSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BackupScheduleSpec) ProtoMessage() {}

func (x *BackupScheduleSpec) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_admin_database_v1_backup_schedule_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BackupScheduleSpec.ProtoReflect.Descriptor instead.
func (*BackupScheduleSpec) Descriptor() ([]byte, []int) {
	return file_google_spanner_admin_database_v1_backup_schedule_proto_rawDescGZIP(), []int{0}
}

func (m *BackupScheduleSpec) GetScheduleSpec() isBackupScheduleSpec_ScheduleSpec {
	if m != nil {
		return m.ScheduleSpec
	}
	return nil
}

func (x *BackupScheduleSpec) GetCronSpec() *CrontabSpec {
	if x, ok := x.GetScheduleSpec().(*BackupScheduleSpec_CronSpec); ok {
		return x.CronSpec
	}
	return nil
}

type isBackupScheduleSpec_ScheduleSpec interface {
	isBackupScheduleSpec_ScheduleSpec()
}

type BackupScheduleSpec_CronSpec struct {
	// Cron style schedule specification.
	CronSpec *CrontabSpec `protobuf:"bytes,1,opt,name=cron_spec,json=cronSpec,proto3,oneof"`
}

func (*BackupScheduleSpec_CronSpec) isBackupScheduleSpec_ScheduleSpec() {}

// BackupSchedule expresses the automated backup creation specification for a
// Spanner database.
// Next ID: 10
type BackupSchedule struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Identifier. Output only for the
	// [CreateBackupSchedule][DatabaseAdmin.CreateBackupSchededule] operation.
	// Required for the
	// [UpdateBackupSchedule][google.spanner.admin.database.v1.DatabaseAdmin.UpdateBackupSchedule]
	// operation. A globally unique identifier for the backup schedule which
	// cannot be changed. Values are of the form
	// `projects/<project>/instances/<instance>/databases/<database>/backupSchedules/[a-z][a-z0-9_\-]*[a-z0-9]`
	// The final segment of the name must be between 2 and 60 characters in
	// length.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. The schedule specification based on which the backup creations
	// are triggered.
	Spec *BackupScheduleSpec `protobuf:"bytes,6,opt,name=spec,proto3" json:"spec,omitempty"`
	// Optional. The retention duration of a backup that must be at least 6 hours
	// and at most 366 days. The backup is eligible to be automatically deleted
	// once the retention period has elapsed.
	RetentionDuration *durationpb.Duration `protobuf:"bytes,3,opt,name=retention_duration,json=retentionDuration,proto3" json:"retention_duration,omitempty"`
	// Optional. The encryption configuration that will be used to encrypt the
	// backup. If this field is not specified, the backup will use the same
	// encryption configuration as the database.
	EncryptionConfig *CreateBackupEncryptionConfig `protobuf:"bytes,4,opt,name=encryption_config,json=encryptionConfig,proto3" json:"encryption_config,omitempty"`
	// Required. Backup type spec determines the type of backup that is created by
	// the backup schedule. Currently, only full backups are supported.
	//
	// Types that are assignable to BackupTypeSpec:
	//
	//	*BackupSchedule_FullBackupSpec
	//	*BackupSchedule_IncrementalBackupSpec
	BackupTypeSpec isBackupSchedule_BackupTypeSpec `protobuf_oneof:"backup_type_spec"`
	// Output only. The timestamp at which the schedule was last updated.
	// If the schedule has never been updated, this field contains the timestamp
	// when the schedule was first created.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,9,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
}

func (x *BackupSchedule) Reset() {
	*x = BackupSchedule{}
	mi := &file_google_spanner_admin_database_v1_backup_schedule_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *BackupSchedule) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BackupSchedule) ProtoMessage() {}

func (x *BackupSchedule) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_admin_database_v1_backup_schedule_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BackupSchedule.ProtoReflect.Descriptor instead.
func (*BackupSchedule) Descriptor() ([]byte, []int) {
	return file_google_spanner_admin_database_v1_backup_schedule_proto_rawDescGZIP(), []int{1}
}

func (x *BackupSchedule) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *BackupSchedule) GetSpec() *BackupScheduleSpec {
	if x != nil {
		return x.Spec
	}
	return nil
}

func (x *BackupSchedule) GetRetentionDuration() *durationpb.Duration {
	if x != nil {
		return x.RetentionDuration
	}
	return nil
}

func (x *BackupSchedule) GetEncryptionConfig() *CreateBackupEncryptionConfig {
	if x != nil {
		return x.EncryptionConfig
	}
	return nil
}

func (m *BackupSchedule) GetBackupTypeSpec() isBackupSchedule_BackupTypeSpec {
	if m != nil {
		return m.BackupTypeSpec
	}
	return nil
}

func (x *BackupSchedule) GetFullBackupSpec() *FullBackupSpec {
	if x, ok := x.GetBackupTypeSpec().(*BackupSchedule_FullBackupSpec); ok {
		return x.FullBackupSpec
	}
	return nil
}

func (x *BackupSchedule) GetIncrementalBackupSpec() *IncrementalBackupSpec {
	if x, ok := x.GetBackupTypeSpec().(*BackupSchedule_IncrementalBackupSpec); ok {
		return x.IncrementalBackupSpec
	}
	return nil
}

func (x *BackupSchedule) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

type isBackupSchedule_BackupTypeSpec interface {
	isBackupSchedule_BackupTypeSpec()
}

type BackupSchedule_FullBackupSpec struct {
	// The schedule creates only full backups.
	FullBackupSpec *FullBackupSpec `protobuf:"bytes,7,opt,name=full_backup_spec,json=fullBackupSpec,proto3,oneof"`
}

type BackupSchedule_IncrementalBackupSpec struct {
	// The schedule creates incremental backup chains.
	IncrementalBackupSpec *IncrementalBackupSpec `protobuf:"bytes,8,opt,name=incremental_backup_spec,json=incrementalBackupSpec,proto3,oneof"`
}

func (*BackupSchedule_FullBackupSpec) isBackupSchedule_BackupTypeSpec() {}

func (*BackupSchedule_IncrementalBackupSpec) isBackupSchedule_BackupTypeSpec() {}

// CrontabSpec can be used to specify the version time and frequency at
// which the backup should be created.
type CrontabSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Textual representation of the crontab. User can customize the
	// backup frequency and the backup version time using the cron
	// expression. The version time must be in UTC timezone.
	//
	// The backup will contain an externally consistent copy of the
	// database at the version time. Allowed frequencies are 12 hour, 1 day,
	// 1 week and 1 month. Examples of valid cron specifications:
	//   - `0 2/12 * * * ` : every 12 hours at (2, 14) hours past midnight in UTC.
	//   - `0 2,14 * * * ` : every 12 hours at (2,14) hours past midnight in UTC.
	//   - `0 2 * * * `    : once a day at 2 past midnight in UTC.
	//   - `0 2 * * 0 `    : once a week every Sunday at 2 past midnight in UTC.
	//   - `0 2 8 * * `    : once a month on 8th day at 2 past midnight in UTC.
	Text string `protobuf:"bytes,1,opt,name=text,proto3" json:"text,omitempty"`
	// Output only. The time zone of the times in `CrontabSpec.text`. Currently
	// only UTC is supported.
	TimeZone string `protobuf:"bytes,2,opt,name=time_zone,json=timeZone,proto3" json:"time_zone,omitempty"`
	// Output only. Schedule backups will contain an externally consistent copy
	// of the database at the version time specified in
	// `schedule_spec.cron_spec`. However, Spanner may not initiate the creation
	// of the scheduled backups at that version time. Spanner will initiate
	// the creation of scheduled backups within the time window bounded by the
	// version_time specified in `schedule_spec.cron_spec` and version_time +
	// `creation_window`.
	CreationWindow *durationpb.Duration `protobuf:"bytes,3,opt,name=creation_window,json=creationWindow,proto3" json:"creation_window,omitempty"`
}

func (x *CrontabSpec) Reset() {
	*x = CrontabSpec{}
	mi := &file_google_spanner_admin_database_v1_backup_schedule_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CrontabSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CrontabSpec) ProtoMessage() {}

func (x *CrontabSpec) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_admin_database_v1_backup_schedule_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CrontabSpec.ProtoReflect.Descriptor instead.
func (*CrontabSpec) Descriptor() ([]byte, []int) {
	return file_google_spanner_admin_database_v1_backup_schedule_proto_rawDescGZIP(), []int{2}
}

func (x *CrontabSpec) GetText() string {
	if x != nil {
		return x.Text
	}
	return ""
}

func (x *CrontabSpec) GetTimeZone() string {
	if x != nil {
		return x.TimeZone
	}
	return ""
}

func (x *CrontabSpec) GetCreationWindow() *durationpb.Duration {
	if x != nil {
		return x.CreationWindow
	}
	return nil
}

// The request for
// [CreateBackupSchedule][google.spanner.admin.database.v1.DatabaseAdmin.CreateBackupSchedule].
type CreateBackupScheduleRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the database that this backup schedule applies to.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The Id to use for the backup schedule. The `backup_schedule_id`
	// appended to `parent` forms the full backup schedule name of the form
	// `projects/<project>/instances/<instance>/databases/<database>/backupSchedules/<backup_schedule_id>`.
	BackupScheduleId string `protobuf:"bytes,2,opt,name=backup_schedule_id,json=backupScheduleId,proto3" json:"backup_schedule_id,omitempty"`
	// Required. The backup schedule to create.
	BackupSchedule *BackupSchedule `protobuf:"bytes,3,opt,name=backup_schedule,json=backupSchedule,proto3" json:"backup_schedule,omitempty"`
}

func (x *CreateBackupScheduleRequest) Reset() {
	*x = CreateBackupScheduleRequest{}
	mi := &file_google_spanner_admin_database_v1_backup_schedule_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateBackupScheduleRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateBackupScheduleRequest) ProtoMessage() {}

func (x *CreateBackupScheduleRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_admin_database_v1_backup_schedule_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateBackupScheduleRequest.ProtoReflect.Descriptor instead.
func (*CreateBackupScheduleRequest) Descriptor() ([]byte, []int) {
	return file_google_spanner_admin_database_v1_backup_schedule_proto_rawDescGZIP(), []int{3}
}

func (x *CreateBackupScheduleRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateBackupScheduleRequest) GetBackupScheduleId() string {
	if x != nil {
		return x.BackupScheduleId
	}
	return ""
}

func (x *CreateBackupScheduleRequest) GetBackupSchedule() *BackupSchedule {
	if x != nil {
		return x.BackupSchedule
	}
	return nil
}

// The request for
// [GetBackupSchedule][google.spanner.admin.database.v1.DatabaseAdmin.GetBackupSchedule].
type GetBackupScheduleRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the schedule to retrieve.
	// Values are of the form
	// `projects/<project>/instances/<instance>/databases/<database>/backupSchedules/<backup_schedule_id>`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetBackupScheduleRequest) Reset() {
	*x = GetBackupScheduleRequest{}
	mi := &file_google_spanner_admin_database_v1_backup_schedule_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetBackupScheduleRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetBackupScheduleRequest) ProtoMessage() {}

func (x *GetBackupScheduleRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_admin_database_v1_backup_schedule_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetBackupScheduleRequest.ProtoReflect.Descriptor instead.
func (*GetBackupScheduleRequest) Descriptor() ([]byte, []int) {
	return file_google_spanner_admin_database_v1_backup_schedule_proto_rawDescGZIP(), []int{4}
}

func (x *GetBackupScheduleRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The request for
// [DeleteBackupSchedule][google.spanner.admin.database.v1.DatabaseAdmin.DeleteBackupSchedule].
type DeleteBackupScheduleRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the schedule to delete.
	// Values are of the form
	// `projects/<project>/instances/<instance>/databases/<database>/backupSchedules/<backup_schedule_id>`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteBackupScheduleRequest) Reset() {
	*x = DeleteBackupScheduleRequest{}
	mi := &file_google_spanner_admin_database_v1_backup_schedule_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteBackupScheduleRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteBackupScheduleRequest) ProtoMessage() {}

func (x *DeleteBackupScheduleRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_admin_database_v1_backup_schedule_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteBackupScheduleRequest.ProtoReflect.Descriptor instead.
func (*DeleteBackupScheduleRequest) Descriptor() ([]byte, []int) {
	return file_google_spanner_admin_database_v1_backup_schedule_proto_rawDescGZIP(), []int{5}
}

func (x *DeleteBackupScheduleRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The request for
// [ListBackupSchedules][google.spanner.admin.database.v1.DatabaseAdmin.ListBackupSchedules].
type ListBackupSchedulesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Database is the parent resource whose backup schedules should be
	// listed. Values are of the form
	// projects/<project>/instances/<instance>/databases/<database>
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. Number of backup schedules to be returned in the response. If 0
	// or less, defaults to the server's maximum allowed page size.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. If non-empty, `page_token` should contain a
	// [next_page_token][google.spanner.admin.database.v1.ListBackupSchedulesResponse.next_page_token]
	// from a previous
	// [ListBackupSchedulesResponse][google.spanner.admin.database.v1.ListBackupSchedulesResponse]
	// to the same `parent`.
	PageToken string `protobuf:"bytes,4,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListBackupSchedulesRequest) Reset() {
	*x = ListBackupSchedulesRequest{}
	mi := &file_google_spanner_admin_database_v1_backup_schedule_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListBackupSchedulesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListBackupSchedulesRequest) ProtoMessage() {}

func (x *ListBackupSchedulesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_admin_database_v1_backup_schedule_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListBackupSchedulesRequest.ProtoReflect.Descriptor instead.
func (*ListBackupSchedulesRequest) Descriptor() ([]byte, []int) {
	return file_google_spanner_admin_database_v1_backup_schedule_proto_rawDescGZIP(), []int{6}
}

func (x *ListBackupSchedulesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListBackupSchedulesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListBackupSchedulesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// The response for
// [ListBackupSchedules][google.spanner.admin.database.v1.DatabaseAdmin.ListBackupSchedules].
type ListBackupSchedulesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of backup schedules for a database.
	BackupSchedules []*BackupSchedule `protobuf:"bytes,1,rep,name=backup_schedules,json=backupSchedules,proto3" json:"backup_schedules,omitempty"`
	// `next_page_token` can be sent in a subsequent
	// [ListBackupSchedules][google.spanner.admin.database.v1.DatabaseAdmin.ListBackupSchedules]
	// call to fetch more of the schedules.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListBackupSchedulesResponse) Reset() {
	*x = ListBackupSchedulesResponse{}
	mi := &file_google_spanner_admin_database_v1_backup_schedule_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListBackupSchedulesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListBackupSchedulesResponse) ProtoMessage() {}

func (x *ListBackupSchedulesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_admin_database_v1_backup_schedule_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListBackupSchedulesResponse.ProtoReflect.Descriptor instead.
func (*ListBackupSchedulesResponse) Descriptor() ([]byte, []int) {
	return file_google_spanner_admin_database_v1_backup_schedule_proto_rawDescGZIP(), []int{7}
}

func (x *ListBackupSchedulesResponse) GetBackupSchedules() []*BackupSchedule {
	if x != nil {
		return x.BackupSchedules
	}
	return nil
}

func (x *ListBackupSchedulesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// The request for
// [UpdateBackupScheduleRequest][google.spanner.admin.database.v1.DatabaseAdmin.UpdateBackupSchedule].
type UpdateBackupScheduleRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The backup schedule to update. `backup_schedule.name`, and the
	// fields to be updated as specified by `update_mask` are required. Other
	// fields are ignored.
	BackupSchedule *BackupSchedule `protobuf:"bytes,1,opt,name=backup_schedule,json=backupSchedule,proto3" json:"backup_schedule,omitempty"`
	// Required. A mask specifying which fields in the BackupSchedule resource
	// should be updated. This mask is relative to the BackupSchedule resource,
	// not to the request message. The field mask must always be
	// specified; this prevents any future fields from being erased
	// accidentally.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateBackupScheduleRequest) Reset() {
	*x = UpdateBackupScheduleRequest{}
	mi := &file_google_spanner_admin_database_v1_backup_schedule_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateBackupScheduleRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateBackupScheduleRequest) ProtoMessage() {}

func (x *UpdateBackupScheduleRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_admin_database_v1_backup_schedule_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateBackupScheduleRequest.ProtoReflect.Descriptor instead.
func (*UpdateBackupScheduleRequest) Descriptor() ([]byte, []int) {
	return file_google_spanner_admin_database_v1_backup_schedule_proto_rawDescGZIP(), []int{8}
}

func (x *UpdateBackupScheduleRequest) GetBackupSchedule() *BackupSchedule {
	if x != nil {
		return x.BackupSchedule
	}
	return nil
}

func (x *UpdateBackupScheduleRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

var File_google_spanner_admin_database_v1_backup_schedule_proto protoreflect.FileDescriptor

var file_google_spanner_admin_database_v1_backup_schedule_proto_rawDesc = []byte{
	0x0a, 0x36, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72,
	0x2f, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x2f,
	0x76, 0x31, 0x2f, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x5f, 0x73, 0x63, 0x68, 0x65, 0x64, 0x75,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x64,
	0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68,
	0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61,
	0x73, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2d, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2f, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2f,
	0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x2f, 0x76, 0x31, 0x2f, 0x62, 0x61, 0x63, 0x6b,
	0x75, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x73, 0x0a, 0x12, 0x42, 0x61, 0x63, 0x6b,
	0x75, 0x70, 0x53, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x53, 0x70, 0x65, 0x63, 0x12, 0x4c,
	0x0a, 0x09, 0x63, 0x72, 0x6f, 0x6e, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e,
	0x65, 0x72, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73,
	0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x6f, 0x6e, 0x74, 0x61, 0x62, 0x53, 0x70, 0x65, 0x63,
	0x48, 0x00, 0x52, 0x08, 0x63, 0x72, 0x6f, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x42, 0x0f, 0x0a, 0x0d,
	0x73, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x22, 0x88, 0x06,
	0x0a, 0x0e, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x53, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65,
	0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x08, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x4d, 0x0a, 0x04, 0x73, 0x70, 0x65,
	0x63, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x64,
	0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x61, 0x63, 0x6b, 0x75,
	0x70, 0x53, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x53, 0x70, 0x65, 0x63, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x04, 0x73, 0x70, 0x65, 0x63, 0x12, 0x4d, 0x0a, 0x12, 0x72, 0x65, 0x74, 0x65,
	0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x11, 0x72, 0x65, 0x74, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x44,
	0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x70, 0x0a, 0x11, 0x65, 0x6e, 0x63, 0x72, 0x79,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e,
	0x6e, 0x65, 0x72, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61,
	0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x42, 0x61, 0x63, 0x6b,
	0x75, 0x70, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x10, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x5c, 0x0a, 0x10, 0x66, 0x75, 0x6c,
	0x6c, 0x5f, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x18, 0x07, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61,
	0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x62,
	0x61, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x75, 0x6c, 0x6c, 0x42, 0x61, 0x63, 0x6b, 0x75,
	0x70, 0x53, 0x70, 0x65, 0x63, 0x48, 0x00, 0x52, 0x0e, 0x66, 0x75, 0x6c, 0x6c, 0x42, 0x61, 0x63,
	0x6b, 0x75, 0x70, 0x53, 0x70, 0x65, 0x63, 0x12, 0x71, 0x0a, 0x17, 0x69, 0x6e, 0x63, 0x72, 0x65,
	0x6d, 0x65, 0x6e, 0x74, 0x61, 0x6c, 0x5f, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x5f, 0x73, 0x70,
	0x65, 0x63, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e,
	0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x63, 0x72,
	0x65, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x6c, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x53, 0x70, 0x65,
	0x63, 0x48, 0x00, 0x52, 0x15, 0x69, 0x6e, 0x63, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x6c,
	0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x53, 0x70, 0x65, 0x63, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x3a, 0xa5, 0x01, 0xea,
	0x41, 0xa1, 0x01, 0x0a, 0x25, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x42, 0x61, 0x63, 0x6b,
	0x75, 0x70, 0x53, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x12, 0x57, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x69,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x2f, 0x7b, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x7d, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x73, 0x2f, 0x7b, 0x64,
	0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x7d, 0x2f, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x53,
	0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x73, 0x2f, 0x7b, 0x73, 0x63, 0x68, 0x65, 0x64, 0x75,
	0x6c, 0x65, 0x7d, 0x2a, 0x0f, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x53, 0x63, 0x68, 0x65, 0x64,
	0x75, 0x6c, 0x65, 0x73, 0x32, 0x0e, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x53, 0x63, 0x68, 0x65,
	0x64, 0x75, 0x6c, 0x65, 0x42, 0x12, 0x0a, 0x10, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x5f, 0x74,
	0x79, 0x70, 0x65, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x22, 0x91, 0x01, 0x0a, 0x0b, 0x43, 0x72, 0x6f,
	0x6e, 0x74, 0x61, 0x62, 0x53, 0x70, 0x65, 0x63, 0x12, 0x17, 0x0a, 0x04, 0x74, 0x65, 0x78, 0x74,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x74, 0x65, 0x78,
	0x74, 0x12, 0x20, 0x0a, 0x09, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x7a, 0x6f, 0x6e, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x08, 0x74, 0x69, 0x6d, 0x65, 0x5a,
	0x6f, 0x6e, 0x65, 0x12, 0x47, 0x0a, 0x0f, 0x63, 0x72, 0x65, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x77, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44,
	0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0e, 0x63, 0x72,
	0x65, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x57, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x22, 0xf1, 0x01, 0x0a,
	0x1b, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x53, 0x63, 0x68,
	0x65, 0x64, 0x75, 0x6c, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3f, 0x0a, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x27, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x21, 0x0a, 0x1f, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x61, 0x74,
	0x61, 0x62, 0x61, 0x73, 0x65, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x31, 0x0a,
	0x12, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x5f, 0x73, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65,
	0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x10,
	0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x53, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x49, 0x64,
	0x12, 0x5e, 0x0a, 0x0f, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x5f, 0x73, 0x63, 0x68, 0x65, 0x64,
	0x75, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e,
	0x2e, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x61, 0x63,
	0x6b, 0x75, 0x70, 0x53, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x0e, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x53, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65,
	0x22, 0x5d, 0x0a, 0x18, 0x47, 0x65, 0x74, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x53, 0x63, 0x68,
	0x65, 0x64, 0x75, 0x6c, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x41, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2d, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x27, 0x0a, 0x25, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x42, 0x61, 0x63, 0x6b, 0x75,
	0x70, 0x53, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22,
	0x60, 0x0a, 0x1b, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x53,
	0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x41,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2d, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x27, 0x0a, 0x25, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x42, 0x61, 0x63,
	0x6b, 0x75, 0x70, 0x53, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x22, 0xa3, 0x01, 0x0a, 0x1a, 0x4c, 0x69, 0x73, 0x74, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70,
	0x53, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x3f, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x27, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x21, 0x0a, 0x1f, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65,
	0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53,
	0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65,
	0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x70, 0x61,
	0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xa2, 0x01, 0x0a, 0x1b, 0x4c, 0x69, 0x73, 0x74,
	0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x53, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x5b, 0x0a, 0x10, 0x62, 0x61, 0x63, 0x6b, 0x75,
	0x70, 0x5f, 0x73, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e,
	0x65, 0x72, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73,
	0x65, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x53, 0x63, 0x68, 0x65, 0x64,
	0x75, 0x6c, 0x65, 0x52, 0x0f, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x53, 0x63, 0x68, 0x65, 0x64,
	0x75, 0x6c, 0x65, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67,
	0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e,
	0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xbf, 0x01, 0x0a,
	0x1b, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x53, 0x63, 0x68,
	0x65, 0x64, 0x75, 0x6c, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x5e, 0x0a, 0x0f,
	0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x5f, 0x73, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73,
	0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x64, 0x61, 0x74,
	0x61, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x53,
	0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0e, 0x62, 0x61,
	0x63, 0x6b, 0x75, 0x70, 0x53, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x12, 0x40, 0x0a, 0x0b,
	0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x85,
	0x02, 0x0a, 0x24, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70,
	0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x64, 0x61, 0x74, 0x61,
	0x62, 0x61, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x42, 0x13, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x53,
	0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x46,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x67, 0x6f, 0x2f, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2f, 0x61, 0x64, 0x6d, 0x69,
	0x6e, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31,
	0x2f, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x70, 0x62, 0x3b, 0x64, 0x61, 0x74, 0x61,
	0x62, 0x61, 0x73, 0x65, 0x70, 0x62, 0xaa, 0x02, 0x26, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x53, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x41, 0x64,
	0x6d, 0x69, 0x6e, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x56, 0x31, 0xca,
	0x02, 0x26, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x53,
	0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x5c, 0x41, 0x64, 0x6d, 0x69, 0x6e, 0x5c, 0x44, 0x61, 0x74,
	0x61, 0x62, 0x61, 0x73, 0x65, 0x5c, 0x56, 0x31, 0xea, 0x02, 0x2b, 0x47, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x53, 0x70, 0x61, 0x6e, 0x6e, 0x65,
	0x72, 0x3a, 0x3a, 0x41, 0x64, 0x6d, 0x69, 0x6e, 0x3a, 0x3a, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61,
	0x73, 0x65, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_spanner_admin_database_v1_backup_schedule_proto_rawDescOnce sync.Once
	file_google_spanner_admin_database_v1_backup_schedule_proto_rawDescData = file_google_spanner_admin_database_v1_backup_schedule_proto_rawDesc
)

func file_google_spanner_admin_database_v1_backup_schedule_proto_rawDescGZIP() []byte {
	file_google_spanner_admin_database_v1_backup_schedule_proto_rawDescOnce.Do(func() {
		file_google_spanner_admin_database_v1_backup_schedule_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_spanner_admin_database_v1_backup_schedule_proto_rawDescData)
	})
	return file_google_spanner_admin_database_v1_backup_schedule_proto_rawDescData
}

var file_google_spanner_admin_database_v1_backup_schedule_proto_msgTypes = make([]protoimpl.MessageInfo, 9)
var file_google_spanner_admin_database_v1_backup_schedule_proto_goTypes = []any{
	(*BackupScheduleSpec)(nil),           // 0: google.spanner.admin.database.v1.BackupScheduleSpec
	(*BackupSchedule)(nil),               // 1: google.spanner.admin.database.v1.BackupSchedule
	(*CrontabSpec)(nil),                  // 2: google.spanner.admin.database.v1.CrontabSpec
	(*CreateBackupScheduleRequest)(nil),  // 3: google.spanner.admin.database.v1.CreateBackupScheduleRequest
	(*GetBackupScheduleRequest)(nil),     // 4: google.spanner.admin.database.v1.GetBackupScheduleRequest
	(*DeleteBackupScheduleRequest)(nil),  // 5: google.spanner.admin.database.v1.DeleteBackupScheduleRequest
	(*ListBackupSchedulesRequest)(nil),   // 6: google.spanner.admin.database.v1.ListBackupSchedulesRequest
	(*ListBackupSchedulesResponse)(nil),  // 7: google.spanner.admin.database.v1.ListBackupSchedulesResponse
	(*UpdateBackupScheduleRequest)(nil),  // 8: google.spanner.admin.database.v1.UpdateBackupScheduleRequest
	(*durationpb.Duration)(nil),          // 9: google.protobuf.Duration
	(*CreateBackupEncryptionConfig)(nil), // 10: google.spanner.admin.database.v1.CreateBackupEncryptionConfig
	(*FullBackupSpec)(nil),               // 11: google.spanner.admin.database.v1.FullBackupSpec
	(*IncrementalBackupSpec)(nil),        // 12: google.spanner.admin.database.v1.IncrementalBackupSpec
	(*timestamppb.Timestamp)(nil),        // 13: google.protobuf.Timestamp
	(*fieldmaskpb.FieldMask)(nil),        // 14: google.protobuf.FieldMask
}
var file_google_spanner_admin_database_v1_backup_schedule_proto_depIdxs = []int32{
	2,  // 0: google.spanner.admin.database.v1.BackupScheduleSpec.cron_spec:type_name -> google.spanner.admin.database.v1.CrontabSpec
	0,  // 1: google.spanner.admin.database.v1.BackupSchedule.spec:type_name -> google.spanner.admin.database.v1.BackupScheduleSpec
	9,  // 2: google.spanner.admin.database.v1.BackupSchedule.retention_duration:type_name -> google.protobuf.Duration
	10, // 3: google.spanner.admin.database.v1.BackupSchedule.encryption_config:type_name -> google.spanner.admin.database.v1.CreateBackupEncryptionConfig
	11, // 4: google.spanner.admin.database.v1.BackupSchedule.full_backup_spec:type_name -> google.spanner.admin.database.v1.FullBackupSpec
	12, // 5: google.spanner.admin.database.v1.BackupSchedule.incremental_backup_spec:type_name -> google.spanner.admin.database.v1.IncrementalBackupSpec
	13, // 6: google.spanner.admin.database.v1.BackupSchedule.update_time:type_name -> google.protobuf.Timestamp
	9,  // 7: google.spanner.admin.database.v1.CrontabSpec.creation_window:type_name -> google.protobuf.Duration
	1,  // 8: google.spanner.admin.database.v1.CreateBackupScheduleRequest.backup_schedule:type_name -> google.spanner.admin.database.v1.BackupSchedule
	1,  // 9: google.spanner.admin.database.v1.ListBackupSchedulesResponse.backup_schedules:type_name -> google.spanner.admin.database.v1.BackupSchedule
	1,  // 10: google.spanner.admin.database.v1.UpdateBackupScheduleRequest.backup_schedule:type_name -> google.spanner.admin.database.v1.BackupSchedule
	14, // 11: google.spanner.admin.database.v1.UpdateBackupScheduleRequest.update_mask:type_name -> google.protobuf.FieldMask
	12, // [12:12] is the sub-list for method output_type
	12, // [12:12] is the sub-list for method input_type
	12, // [12:12] is the sub-list for extension type_name
	12, // [12:12] is the sub-list for extension extendee
	0,  // [0:12] is the sub-list for field type_name
}

func init() { file_google_spanner_admin_database_v1_backup_schedule_proto_init() }
func file_google_spanner_admin_database_v1_backup_schedule_proto_init() {
	if File_google_spanner_admin_database_v1_backup_schedule_proto != nil {
		return
	}
	file_google_spanner_admin_database_v1_backup_proto_init()
	file_google_spanner_admin_database_v1_backup_schedule_proto_msgTypes[0].OneofWrappers = []any{
		(*BackupScheduleSpec_CronSpec)(nil),
	}
	file_google_spanner_admin_database_v1_backup_schedule_proto_msgTypes[1].OneofWrappers = []any{
		(*BackupSchedule_FullBackupSpec)(nil),
		(*BackupSchedule_IncrementalBackupSpec)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_spanner_admin_database_v1_backup_schedule_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   9,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_spanner_admin_database_v1_backup_schedule_proto_goTypes,
		DependencyIndexes: file_google_spanner_admin_database_v1_backup_schedule_proto_depIdxs,
		MessageInfos:      file_google_spanner_admin_database_v1_backup_schedule_proto_msgTypes,
	}.Build()
	File_google_spanner_admin_database_v1_backup_schedule_proto = out.File
	file_google_spanner_admin_database_v1_backup_schedule_proto_rawDesc = nil
	file_google_spanner_admin_database_v1_backup_schedule_proto_goTypes = nil
	file_google_spanner_admin_database_v1_backup_schedule_proto_depIdxs = nil
}
