// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.21.5
// source: google/cloud/recaptchaenterprise/v1/recaptchaenterprise.proto

package recaptchaenterprisepb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Enum that represents the types of annotations.
type AnnotateAssessmentRequest_Annotation int32

const (
	// Default unspecified type.
	AnnotateAssessmentRequest_ANNOTATION_UNSPECIFIED AnnotateAssessmentRequest_Annotation = 0
	// Provides information that the event turned out to be legitimate.
	AnnotateAssessmentRequest_LEGITIMATE AnnotateAssessmentRequest_Annotation = 1
	// Provides information that the event turned out to be fraudulent.
	AnnotateAssessmentRequest_FRAUDULENT AnnotateAssessmentRequest_Annotation = 2
	// Provides information that the event was related to a login event in which
	// the user typed the correct password. Deprecated, prefer indicating
	// CORRECT_PASSWORD through the reasons field instead.
	//
	// Deprecated: Do not use.
	AnnotateAssessmentRequest_PASSWORD_CORRECT AnnotateAssessmentRequest_Annotation = 3
	// Provides information that the event was related to a login event in which
	// the user typed the incorrect password. Deprecated, prefer indicating
	// INCORRECT_PASSWORD through the reasons field instead.
	//
	// Deprecated: Do not use.
	AnnotateAssessmentRequest_PASSWORD_INCORRECT AnnotateAssessmentRequest_Annotation = 4
)

// Enum value maps for AnnotateAssessmentRequest_Annotation.
var (
	AnnotateAssessmentRequest_Annotation_name = map[int32]string{
		0: "ANNOTATION_UNSPECIFIED",
		1: "LEGITIMATE",
		2: "FRAUDULENT",
		3: "PASSWORD_CORRECT",
		4: "PASSWORD_INCORRECT",
	}
	AnnotateAssessmentRequest_Annotation_value = map[string]int32{
		"ANNOTATION_UNSPECIFIED": 0,
		"LEGITIMATE":             1,
		"FRAUDULENT":             2,
		"PASSWORD_CORRECT":       3,
		"PASSWORD_INCORRECT":     4,
	}
)

func (x AnnotateAssessmentRequest_Annotation) Enum() *AnnotateAssessmentRequest_Annotation {
	p := new(AnnotateAssessmentRequest_Annotation)
	*p = x
	return p
}

func (x AnnotateAssessmentRequest_Annotation) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AnnotateAssessmentRequest_Annotation) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_enumTypes[0].Descriptor()
}

func (AnnotateAssessmentRequest_Annotation) Type() protoreflect.EnumType {
	return &file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_enumTypes[0]
}

func (x AnnotateAssessmentRequest_Annotation) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AnnotateAssessmentRequest_Annotation.Descriptor instead.
func (AnnotateAssessmentRequest_Annotation) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_rawDescGZIP(), []int{1, 0}
}

// Enum that represents potential reasons for annotating an assessment.
type AnnotateAssessmentRequest_Reason int32

const (
	// Default unspecified reason.
	AnnotateAssessmentRequest_REASON_UNSPECIFIED AnnotateAssessmentRequest_Reason = 0
	// Indicates that the transaction had a chargeback issued with no other
	// details. When possible, specify the type by using CHARGEBACK_FRAUD or
	// CHARGEBACK_DISPUTE instead.
	AnnotateAssessmentRequest_CHARGEBACK AnnotateAssessmentRequest_Reason = 1
	// Indicates that the transaction had a chargeback issued related to an
	// alleged unauthorized transaction from the cardholder's perspective (for
	// example, the card number was stolen).
	AnnotateAssessmentRequest_CHARGEBACK_FRAUD AnnotateAssessmentRequest_Reason = 8
	// Indicates that the transaction had a chargeback issued related to the
	// cardholder having provided their card details but allegedly not being
	// satisfied with the purchase (for example, misrepresentation, attempted
	// cancellation).
	AnnotateAssessmentRequest_CHARGEBACK_DISPUTE AnnotateAssessmentRequest_Reason = 9
	// Indicates that the completed payment transaction was refunded by the
	// seller.
	AnnotateAssessmentRequest_REFUND AnnotateAssessmentRequest_Reason = 10
	// Indicates that the completed payment transaction was determined to be
	// fraudulent by the seller, and was cancelled and refunded as a result.
	AnnotateAssessmentRequest_REFUND_FRAUD AnnotateAssessmentRequest_Reason = 11
	// Indicates that the payment transaction was accepted, and the user was
	// charged.
	AnnotateAssessmentRequest_TRANSACTION_ACCEPTED AnnotateAssessmentRequest_Reason = 12
	// Indicates that the payment transaction was declined, for example due to
	// invalid card details.
	AnnotateAssessmentRequest_TRANSACTION_DECLINED AnnotateAssessmentRequest_Reason = 13
	// Indicates the transaction associated with the assessment is suspected of
	// being fraudulent based on the payment method, billing details, shipping
	// address or other transaction information.
	AnnotateAssessmentRequest_PAYMENT_HEURISTICS AnnotateAssessmentRequest_Reason = 2
	// Indicates that the user was served a 2FA challenge. An old assessment
	// with `ENUM_VALUES.INITIATED_TWO_FACTOR` reason that has not been
	// overwritten with `PASSED_TWO_FACTOR` is treated as an abandoned 2FA flow.
	// This is equivalent to `FAILED_TWO_FACTOR`.
	AnnotateAssessmentRequest_INITIATED_TWO_FACTOR AnnotateAssessmentRequest_Reason = 7
	// Indicates that the user passed a 2FA challenge.
	AnnotateAssessmentRequest_PASSED_TWO_FACTOR AnnotateAssessmentRequest_Reason = 3
	// Indicates that the user failed a 2FA challenge.
	AnnotateAssessmentRequest_FAILED_TWO_FACTOR AnnotateAssessmentRequest_Reason = 4
	// Indicates the user provided the correct password.
	AnnotateAssessmentRequest_CORRECT_PASSWORD AnnotateAssessmentRequest_Reason = 5
	// Indicates the user provided an incorrect password.
	AnnotateAssessmentRequest_INCORRECT_PASSWORD AnnotateAssessmentRequest_Reason = 6
	// Indicates that the user sent unwanted and abusive messages to other users
	// of the platform, such as spam, scams, phishing, or social engineering.
	AnnotateAssessmentRequest_SOCIAL_SPAM AnnotateAssessmentRequest_Reason = 14
)

// Enum value maps for AnnotateAssessmentRequest_Reason.
var (
	AnnotateAssessmentRequest_Reason_name = map[int32]string{
		0:  "REASON_UNSPECIFIED",
		1:  "CHARGEBACK",
		8:  "CHARGEBACK_FRAUD",
		9:  "CHARGEBACK_DISPUTE",
		10: "REFUND",
		11: "REFUND_FRAUD",
		12: "TRANSACTION_ACCEPTED",
		13: "TRANSACTION_DECLINED",
		2:  "PAYMENT_HEURISTICS",
		7:  "INITIATED_TWO_FACTOR",
		3:  "PASSED_TWO_FACTOR",
		4:  "FAILED_TWO_FACTOR",
		5:  "CORRECT_PASSWORD",
		6:  "INCORRECT_PASSWORD",
		14: "SOCIAL_SPAM",
	}
	AnnotateAssessmentRequest_Reason_value = map[string]int32{
		"REASON_UNSPECIFIED":   0,
		"CHARGEBACK":           1,
		"CHARGEBACK_FRAUD":     8,
		"CHARGEBACK_DISPUTE":   9,
		"REFUND":               10,
		"REFUND_FRAUD":         11,
		"TRANSACTION_ACCEPTED": 12,
		"TRANSACTION_DECLINED": 13,
		"PAYMENT_HEURISTICS":   2,
		"INITIATED_TWO_FACTOR": 7,
		"PASSED_TWO_FACTOR":    3,
		"FAILED_TWO_FACTOR":    4,
		"CORRECT_PASSWORD":     5,
		"INCORRECT_PASSWORD":   6,
		"SOCIAL_SPAM":          14,
	}
)

func (x AnnotateAssessmentRequest_Reason) Enum() *AnnotateAssessmentRequest_Reason {
	p := new(AnnotateAssessmentRequest_Reason)
	*p = x
	return p
}

func (x AnnotateAssessmentRequest_Reason) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AnnotateAssessmentRequest_Reason) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_enumTypes[1].Descriptor()
}

func (AnnotateAssessmentRequest_Reason) Type() protoreflect.EnumType {
	return &file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_enumTypes[1]
}

func (x AnnotateAssessmentRequest_Reason) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AnnotateAssessmentRequest_Reason.Descriptor instead.
func (AnnotateAssessmentRequest_Reason) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_rawDescGZIP(), []int{1, 1}
}

// Reasons contributing to the risk analysis verdict.
type RiskAnalysis_ClassificationReason int32

const (
	// Default unspecified type.
	RiskAnalysis_CLASSIFICATION_REASON_UNSPECIFIED RiskAnalysis_ClassificationReason = 0
	// Interactions matched the behavior of an automated agent.
	RiskAnalysis_AUTOMATION RiskAnalysis_ClassificationReason = 1
	// The event originated from an illegitimate environment.
	RiskAnalysis_UNEXPECTED_ENVIRONMENT RiskAnalysis_ClassificationReason = 2
	// Traffic volume from the event source is higher than normal.
	RiskAnalysis_TOO_MUCH_TRAFFIC RiskAnalysis_ClassificationReason = 3
	// Interactions with the site were significantly different than expected
	// patterns.
	RiskAnalysis_UNEXPECTED_USAGE_PATTERNS RiskAnalysis_ClassificationReason = 4
	// Too little traffic has been received from this site thus far to generate
	// quality risk analysis.
	RiskAnalysis_LOW_CONFIDENCE_SCORE RiskAnalysis_ClassificationReason = 5
)

// Enum value maps for RiskAnalysis_ClassificationReason.
var (
	RiskAnalysis_ClassificationReason_name = map[int32]string{
		0: "CLASSIFICATION_REASON_UNSPECIFIED",
		1: "AUTOMATION",
		2: "UNEXPECTED_ENVIRONMENT",
		3: "TOO_MUCH_TRAFFIC",
		4: "UNEXPECTED_USAGE_PATTERNS",
		5: "LOW_CONFIDENCE_SCORE",
	}
	RiskAnalysis_ClassificationReason_value = map[string]int32{
		"CLASSIFICATION_REASON_UNSPECIFIED": 0,
		"AUTOMATION":                        1,
		"UNEXPECTED_ENVIRONMENT":            2,
		"TOO_MUCH_TRAFFIC":                  3,
		"UNEXPECTED_USAGE_PATTERNS":         4,
		"LOW_CONFIDENCE_SCORE":              5,
	}
)

func (x RiskAnalysis_ClassificationReason) Enum() *RiskAnalysis_ClassificationReason {
	p := new(RiskAnalysis_ClassificationReason)
	*p = x
	return p
}

func (x RiskAnalysis_ClassificationReason) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (RiskAnalysis_ClassificationReason) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_enumTypes[2].Descriptor()
}

func (RiskAnalysis_ClassificationReason) Type() protoreflect.EnumType {
	return &file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_enumTypes[2]
}

func (x RiskAnalysis_ClassificationReason) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use RiskAnalysis_ClassificationReason.Descriptor instead.
func (RiskAnalysis_ClassificationReason) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_rawDescGZIP(), []int{6, 0}
}

// Enum that represents the types of invalid token reasons.
type TokenProperties_InvalidReason int32

const (
	// Default unspecified type.
	TokenProperties_INVALID_REASON_UNSPECIFIED TokenProperties_InvalidReason = 0
	// If the failure reason was not accounted for.
	TokenProperties_UNKNOWN_INVALID_REASON TokenProperties_InvalidReason = 1
	// The provided user verification token was malformed.
	TokenProperties_MALFORMED TokenProperties_InvalidReason = 2
	// The user verification token had expired.
	TokenProperties_EXPIRED TokenProperties_InvalidReason = 3
	// The user verification had already been seen.
	TokenProperties_DUPE TokenProperties_InvalidReason = 4
	// The user verification token was not present.
	TokenProperties_MISSING TokenProperties_InvalidReason = 5
	// A retriable error (such as network failure) occurred on the browser.
	// Could easily be simulated by an attacker.
	TokenProperties_BROWSER_ERROR TokenProperties_InvalidReason = 6
)

// Enum value maps for TokenProperties_InvalidReason.
var (
	TokenProperties_InvalidReason_name = map[int32]string{
		0: "INVALID_REASON_UNSPECIFIED",
		1: "UNKNOWN_INVALID_REASON",
		2: "MALFORMED",
		3: "EXPIRED",
		4: "DUPE",
		5: "MISSING",
		6: "BROWSER_ERROR",
	}
	TokenProperties_InvalidReason_value = map[string]int32{
		"INVALID_REASON_UNSPECIFIED": 0,
		"UNKNOWN_INVALID_REASON":     1,
		"MALFORMED":                  2,
		"EXPIRED":                    3,
		"DUPE":                       4,
		"MISSING":                    5,
		"BROWSER_ERROR":              6,
	}
)

func (x TokenProperties_InvalidReason) Enum() *TokenProperties_InvalidReason {
	p := new(TokenProperties_InvalidReason)
	*p = x
	return p
}

func (x TokenProperties_InvalidReason) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (TokenProperties_InvalidReason) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_enumTypes[3].Descriptor()
}

func (TokenProperties_InvalidReason) Type() protoreflect.EnumType {
	return &file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_enumTypes[3]
}

func (x TokenProperties_InvalidReason) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use TokenProperties_InvalidReason.Descriptor instead.
func (TokenProperties_InvalidReason) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_rawDescGZIP(), []int{7, 0}
}

// Labels returned by account defender for this request.
type AccountDefenderAssessment_AccountDefenderLabel int32

const (
	// Default unspecified type.
	AccountDefenderAssessment_ACCOUNT_DEFENDER_LABEL_UNSPECIFIED AccountDefenderAssessment_AccountDefenderLabel = 0
	// The request matches a known good profile for the user.
	AccountDefenderAssessment_PROFILE_MATCH AccountDefenderAssessment_AccountDefenderLabel = 1
	// The request is potentially a suspicious login event and must be further
	// verified either through multi-factor authentication or another system.
	AccountDefenderAssessment_SUSPICIOUS_LOGIN_ACTIVITY AccountDefenderAssessment_AccountDefenderLabel = 2
	// The request matched a profile that previously had suspicious account
	// creation behavior. This can mean that this is a fake account.
	AccountDefenderAssessment_SUSPICIOUS_ACCOUNT_CREATION AccountDefenderAssessment_AccountDefenderLabel = 3
	// The account in the request has a high number of related accounts. It does
	// not necessarily imply that the account is bad but can require further
	// investigation.
	AccountDefenderAssessment_RELATED_ACCOUNTS_NUMBER_HIGH AccountDefenderAssessment_AccountDefenderLabel = 4
)

// Enum value maps for AccountDefenderAssessment_AccountDefenderLabel.
var (
	AccountDefenderAssessment_AccountDefenderLabel_name = map[int32]string{
		0: "ACCOUNT_DEFENDER_LABEL_UNSPECIFIED",
		1: "PROFILE_MATCH",
		2: "SUSPICIOUS_LOGIN_ACTIVITY",
		3: "SUSPICIOUS_ACCOUNT_CREATION",
		4: "RELATED_ACCOUNTS_NUMBER_HIGH",
	}
	AccountDefenderAssessment_AccountDefenderLabel_value = map[string]int32{
		"ACCOUNT_DEFENDER_LABEL_UNSPECIFIED": 0,
		"PROFILE_MATCH":                      1,
		"SUSPICIOUS_LOGIN_ACTIVITY":          2,
		"SUSPICIOUS_ACCOUNT_CREATION":        3,
		"RELATED_ACCOUNTS_NUMBER_HIGH":       4,
	}
)

func (x AccountDefenderAssessment_AccountDefenderLabel) Enum() *AccountDefenderAssessment_AccountDefenderLabel {
	p := new(AccountDefenderAssessment_AccountDefenderLabel)
	*p = x
	return p
}

func (x AccountDefenderAssessment_AccountDefenderLabel) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AccountDefenderAssessment_AccountDefenderLabel) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_enumTypes[4].Descriptor()
}

func (AccountDefenderAssessment_AccountDefenderLabel) Type() protoreflect.EnumType {
	return &file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_enumTypes[4]
}

func (x AccountDefenderAssessment_AccountDefenderLabel) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AccountDefenderAssessment_AccountDefenderLabel.Descriptor instead.
func (AccountDefenderAssessment_AccountDefenderLabel) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_rawDescGZIP(), []int{8, 0}
}

// Enum that represents the challenge option for challenge-based (CHECKBOX,
// INVISIBLE) testing keys.
type TestingOptions_TestingChallenge int32

const (
	// Perform the normal risk analysis and return either nocaptcha or a
	// challenge depending on risk and trust factors.
	TestingOptions_TESTING_CHALLENGE_UNSPECIFIED TestingOptions_TestingChallenge = 0
	// Challenge requests for this key always return a nocaptcha, which
	// does not require a solution.
	TestingOptions_NOCAPTCHA TestingOptions_TestingChallenge = 1
	// Challenge requests for this key always return an unsolvable
	// challenge.
	TestingOptions_UNSOLVABLE_CHALLENGE TestingOptions_TestingChallenge = 2
)

// Enum value maps for TestingOptions_TestingChallenge.
var (
	TestingOptions_TestingChallenge_name = map[int32]string{
		0: "TESTING_CHALLENGE_UNSPECIFIED",
		1: "NOCAPTCHA",
		2: "UNSOLVABLE_CHALLENGE",
	}
	TestingOptions_TestingChallenge_value = map[string]int32{
		"TESTING_CHALLENGE_UNSPECIFIED": 0,
		"NOCAPTCHA":                     1,
		"UNSOLVABLE_CHALLENGE":          2,
	}
)

func (x TestingOptions_TestingChallenge) Enum() *TestingOptions_TestingChallenge {
	p := new(TestingOptions_TestingChallenge)
	*p = x
	return p
}

func (x TestingOptions_TestingChallenge) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (TestingOptions_TestingChallenge) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_enumTypes[5].Descriptor()
}

func (TestingOptions_TestingChallenge) Type() protoreflect.EnumType {
	return &file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_enumTypes[5]
}

func (x TestingOptions_TestingChallenge) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use TestingOptions_TestingChallenge.Descriptor instead.
func (TestingOptions_TestingChallenge) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_rawDescGZIP(), []int{21, 0}
}

// Enum that represents the integration types for web keys.
type WebKeySettings_IntegrationType int32

const (
	// Default type that indicates this enum hasn't been specified. This is not
	// a valid IntegrationType, one of the other types must be specified
	// instead.
	WebKeySettings_INTEGRATION_TYPE_UNSPECIFIED WebKeySettings_IntegrationType = 0
	// Only used to produce scores. It doesn't display the "I'm not a robot"
	// checkbox and never shows captcha challenges.
	WebKeySettings_SCORE WebKeySettings_IntegrationType = 1
	// Displays the "I'm not a robot" checkbox and may show captcha challenges
	// after it is checked.
	WebKeySettings_CHECKBOX WebKeySettings_IntegrationType = 2
	// Doesn't display the "I'm not a robot" checkbox, but may show captcha
	// challenges after risk analysis.
	WebKeySettings_INVISIBLE WebKeySettings_IntegrationType = 3
)

// Enum value maps for WebKeySettings_IntegrationType.
var (
	WebKeySettings_IntegrationType_name = map[int32]string{
		0: "INTEGRATION_TYPE_UNSPECIFIED",
		1: "SCORE",
		2: "CHECKBOX",
		3: "INVISIBLE",
	}
	WebKeySettings_IntegrationType_value = map[string]int32{
		"INTEGRATION_TYPE_UNSPECIFIED": 0,
		"SCORE":                        1,
		"CHECKBOX":                     2,
		"INVISIBLE":                    3,
	}
)

func (x WebKeySettings_IntegrationType) Enum() *WebKeySettings_IntegrationType {
	p := new(WebKeySettings_IntegrationType)
	*p = x
	return p
}

func (x WebKeySettings_IntegrationType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (WebKeySettings_IntegrationType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_enumTypes[6].Descriptor()
}

func (WebKeySettings_IntegrationType) Type() protoreflect.EnumType {
	return &file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_enumTypes[6]
}

func (x WebKeySettings_IntegrationType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use WebKeySettings_IntegrationType.Descriptor instead.
func (WebKeySettings_IntegrationType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_rawDescGZIP(), []int{22, 0}
}

// Enum that represents the possible challenge frequency and difficulty
// configurations for a web key.
type WebKeySettings_ChallengeSecurityPreference int32

const (
	// Default type that indicates this enum hasn't been specified.
	WebKeySettings_CHALLENGE_SECURITY_PREFERENCE_UNSPECIFIED WebKeySettings_ChallengeSecurityPreference = 0
	// Key tends to show fewer and easier challenges.
	WebKeySettings_USABILITY WebKeySettings_ChallengeSecurityPreference = 1
	// Key tends to show balanced (in amount and difficulty) challenges.
	WebKeySettings_BALANCE WebKeySettings_ChallengeSecurityPreference = 2
	// Key tends to show more and harder challenges.
	WebKeySettings_SECURITY WebKeySettings_ChallengeSecurityPreference = 3
)

// Enum value maps for WebKeySettings_ChallengeSecurityPreference.
var (
	WebKeySettings_ChallengeSecurityPreference_name = map[int32]string{
		0: "CHALLENGE_SECURITY_PREFERENCE_UNSPECIFIED",
		1: "USABILITY",
		2: "BALANCE",
		3: "SECURITY",
	}
	WebKeySettings_ChallengeSecurityPreference_value = map[string]int32{
		"CHALLENGE_SECURITY_PREFERENCE_UNSPECIFIED": 0,
		"USABILITY": 1,
		"BALANCE":   2,
		"SECURITY":  3,
	}
)

func (x WebKeySettings_ChallengeSecurityPreference) Enum() *WebKeySettings_ChallengeSecurityPreference {
	p := new(WebKeySettings_ChallengeSecurityPreference)
	*p = x
	return p
}

func (x WebKeySettings_ChallengeSecurityPreference) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (WebKeySettings_ChallengeSecurityPreference) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_enumTypes[7].Descriptor()
}

func (WebKeySettings_ChallengeSecurityPreference) Type() protoreflect.EnumType {
	return &file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_enumTypes[7]
}

func (x WebKeySettings_ChallengeSecurityPreference) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use WebKeySettings_ChallengeSecurityPreference.Descriptor instead.
func (WebKeySettings_ChallengeSecurityPreference) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_rawDescGZIP(), []int{22, 1}
}

// Supported WAF features. For more information, see
// https://cloud.google.com/recaptcha-enterprise/docs/usecase#comparison_of_features.
type WafSettings_WafFeature int32

const (
	// Undefined feature.
	WafSettings_WAF_FEATURE_UNSPECIFIED WafSettings_WafFeature = 0
	// Redirects suspicious traffic to reCAPTCHA.
	WafSettings_CHALLENGE_PAGE WafSettings_WafFeature = 1
	// Use reCAPTCHA session-tokens to protect the whole user session on the
	// site's domain.
	WafSettings_SESSION_TOKEN WafSettings_WafFeature = 2
	// Use reCAPTCHA action-tokens to protect user actions.
	WafSettings_ACTION_TOKEN WafSettings_WafFeature = 3
)

// Enum value maps for WafSettings_WafFeature.
var (
	WafSettings_WafFeature_name = map[int32]string{
		0: "WAF_FEATURE_UNSPECIFIED",
		1: "CHALLENGE_PAGE",
		2: "SESSION_TOKEN",
		3: "ACTION_TOKEN",
	}
	WafSettings_WafFeature_value = map[string]int32{
		"WAF_FEATURE_UNSPECIFIED": 0,
		"CHALLENGE_PAGE":          1,
		"SESSION_TOKEN":           2,
		"ACTION_TOKEN":            3,
	}
)

func (x WafSettings_WafFeature) Enum() *WafSettings_WafFeature {
	p := new(WafSettings_WafFeature)
	*p = x
	return p
}

func (x WafSettings_WafFeature) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (WafSettings_WafFeature) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_enumTypes[8].Descriptor()
}

func (WafSettings_WafFeature) Type() protoreflect.EnumType {
	return &file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_enumTypes[8]
}

func (x WafSettings_WafFeature) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use WafSettings_WafFeature.Descriptor instead.
func (WafSettings_WafFeature) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_rawDescGZIP(), []int{36, 0}
}

// Web Application Firewalls supported by reCAPTCHA Enterprise.
type WafSettings_WafService int32

const (
	// Undefined WAF
	WafSettings_WAF_SERVICE_UNSPECIFIED WafSettings_WafService = 0
	// Cloud Armor
	WafSettings_CA WafSettings_WafService = 1
)

// Enum value maps for WafSettings_WafService.
var (
	WafSettings_WafService_name = map[int32]string{
		0: "WAF_SERVICE_UNSPECIFIED",
		1: "CA",
	}
	WafSettings_WafService_value = map[string]int32{
		"WAF_SERVICE_UNSPECIFIED": 0,
		"CA":                      1,
	}
)

func (x WafSettings_WafService) Enum() *WafSettings_WafService {
	p := new(WafSettings_WafService)
	*p = x
	return p
}

func (x WafSettings_WafService) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (WafSettings_WafService) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_enumTypes[9].Descriptor()
}

func (WafSettings_WafService) Type() protoreflect.EnumType {
	return &file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_enumTypes[9]
}

func (x WafSettings_WafService) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use WafSettings_WafService.Descriptor instead.
func (WafSettings_WafService) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_rawDescGZIP(), []int{36, 1}
}

// The create assessment request message.
type CreateAssessmentRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the project in which the assessment will be created,
	// in the format "projects/{project}".
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The assessment details.
	Assessment *Assessment `protobuf:"bytes,2,opt,name=assessment,proto3" json:"assessment,omitempty"`
}

func (x *CreateAssessmentRequest) Reset() {
	*x = CreateAssessmentRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateAssessmentRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateAssessmentRequest) ProtoMessage() {}

func (x *CreateAssessmentRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateAssessmentRequest.ProtoReflect.Descriptor instead.
func (*CreateAssessmentRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_rawDescGZIP(), []int{0}
}

func (x *CreateAssessmentRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateAssessmentRequest) GetAssessment() *Assessment {
	if x != nil {
		return x.Assessment
	}
	return nil
}

// The request message to annotate an Assessment.
type AnnotateAssessmentRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the Assessment, in the format
	// "projects/{project}/assessments/{assessment}".
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. The annotation that will be assigned to the Event. This field can be left
	// empty to provide reasons that apply to an event without concluding whether
	// the event is legitimate or fraudulent.
	Annotation AnnotateAssessmentRequest_Annotation `protobuf:"varint,2,opt,name=annotation,proto3,enum=google.cloud.recaptchaenterprise.v1.AnnotateAssessmentRequest_Annotation" json:"annotation,omitempty"`
	// Optional. Optional reasons for the annotation that will be assigned to the Event.
	Reasons []AnnotateAssessmentRequest_Reason `protobuf:"varint,3,rep,packed,name=reasons,proto3,enum=google.cloud.recaptchaenterprise.v1.AnnotateAssessmentRequest_Reason" json:"reasons,omitempty"`
	// Optional. Unique stable hashed user identifier to apply to the assessment.
	// This is an alternative to setting the hashed_account_id in
	// CreateAssessment, for example when the account identifier is not yet known
	// in the initial request. It is recommended that the identifier is hashed
	// using hmac-sha256 with stable secret.
	HashedAccountId []byte `protobuf:"bytes,4,opt,name=hashed_account_id,json=hashedAccountId,proto3" json:"hashed_account_id,omitempty"`
}

func (x *AnnotateAssessmentRequest) Reset() {
	*x = AnnotateAssessmentRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AnnotateAssessmentRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AnnotateAssessmentRequest) ProtoMessage() {}

func (x *AnnotateAssessmentRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AnnotateAssessmentRequest.ProtoReflect.Descriptor instead.
func (*AnnotateAssessmentRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_rawDescGZIP(), []int{1}
}

func (x *AnnotateAssessmentRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *AnnotateAssessmentRequest) GetAnnotation() AnnotateAssessmentRequest_Annotation {
	if x != nil {
		return x.Annotation
	}
	return AnnotateAssessmentRequest_ANNOTATION_UNSPECIFIED
}

func (x *AnnotateAssessmentRequest) GetReasons() []AnnotateAssessmentRequest_Reason {
	if x != nil {
		return x.Reasons
	}
	return nil
}

func (x *AnnotateAssessmentRequest) GetHashedAccountId() []byte {
	if x != nil {
		return x.HashedAccountId
	}
	return nil
}

// Empty response for AnnotateAssessment.
type AnnotateAssessmentResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *AnnotateAssessmentResponse) Reset() {
	*x = AnnotateAssessmentResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AnnotateAssessmentResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AnnotateAssessmentResponse) ProtoMessage() {}

func (x *AnnotateAssessmentResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AnnotateAssessmentResponse.ProtoReflect.Descriptor instead.
func (*AnnotateAssessmentResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_rawDescGZIP(), []int{2}
}

// Private password leak verification info.
type PrivatePasswordLeakVerification struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Exactly 26-bit prefix of the SHA-256 hash of the canonicalized username. It
	// is used to look up password leaks associated with that hash prefix.
	LookupHashPrefix []byte `protobuf:"bytes,1,opt,name=lookup_hash_prefix,json=lookupHashPrefix,proto3" json:"lookup_hash_prefix,omitempty"`
	// Optional. Encrypted Scrypt hash of the canonicalized username+password. It is
	// re-encrypted by the server and returned through
	// `reencrypted_user_credentials_hash`.
	EncryptedUserCredentialsHash []byte `protobuf:"bytes,2,opt,name=encrypted_user_credentials_hash,json=encryptedUserCredentialsHash,proto3" json:"encrypted_user_credentials_hash,omitempty"`
	// Output only. List of prefixes of the encrypted potential password leaks that matched the
	// given parameters. They must be compared with the client-side decryption
	// prefix of `reencrypted_user_credentials_hash`
	EncryptedLeakMatchPrefixes [][]byte `protobuf:"bytes,3,rep,name=encrypted_leak_match_prefixes,json=encryptedLeakMatchPrefixes,proto3" json:"encrypted_leak_match_prefixes,omitempty"`
	// Output only. Corresponds to the re-encryption of the `encrypted_user_credentials_hash`
	// field. It is used to match potential password leaks within
	// `encrypted_leak_match_prefixes`.
	ReencryptedUserCredentialsHash []byte `protobuf:"bytes,4,opt,name=reencrypted_user_credentials_hash,json=reencryptedUserCredentialsHash,proto3" json:"reencrypted_user_credentials_hash,omitempty"`
}

func (x *PrivatePasswordLeakVerification) Reset() {
	*x = PrivatePasswordLeakVerification{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PrivatePasswordLeakVerification) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PrivatePasswordLeakVerification) ProtoMessage() {}

func (x *PrivatePasswordLeakVerification) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PrivatePasswordLeakVerification.ProtoReflect.Descriptor instead.
func (*PrivatePasswordLeakVerification) Descriptor() ([]byte, []int) {
	return file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_rawDescGZIP(), []int{3}
}

func (x *PrivatePasswordLeakVerification) GetLookupHashPrefix() []byte {
	if x != nil {
		return x.LookupHashPrefix
	}
	return nil
}

func (x *PrivatePasswordLeakVerification) GetEncryptedUserCredentialsHash() []byte {
	if x != nil {
		return x.EncryptedUserCredentialsHash
	}
	return nil
}

func (x *PrivatePasswordLeakVerification) GetEncryptedLeakMatchPrefixes() [][]byte {
	if x != nil {
		return x.EncryptedLeakMatchPrefixes
	}
	return nil
}

func (x *PrivatePasswordLeakVerification) GetReencryptedUserCredentialsHash() []byte {
	if x != nil {
		return x.ReencryptedUserCredentialsHash
	}
	return nil
}

// A recaptcha assessment resource.
type Assessment struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The resource name for the Assessment in the format
	// "projects/{project}/assessments/{assessment}".
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The event being assessed.
	Event *Event `protobuf:"bytes,2,opt,name=event,proto3" json:"event,omitempty"`
	// Output only. The risk analysis result for the event being assessed.
	RiskAnalysis *RiskAnalysis `protobuf:"bytes,3,opt,name=risk_analysis,json=riskAnalysis,proto3" json:"risk_analysis,omitempty"`
	// Output only. Properties of the provided event token.
	TokenProperties *TokenProperties `protobuf:"bytes,4,opt,name=token_properties,json=tokenProperties,proto3" json:"token_properties,omitempty"`
	// Assessment returned by account defender when a hashed_account_id is
	// provided.
	AccountDefenderAssessment *AccountDefenderAssessment `protobuf:"bytes,6,opt,name=account_defender_assessment,json=accountDefenderAssessment,proto3" json:"account_defender_assessment,omitempty"`
	// The private password leak verification field contains the parameters that
	// are used to to check for leaks privately without sharing user credentials.
	PrivatePasswordLeakVerification *PrivatePasswordLeakVerification `protobuf:"bytes,8,opt,name=private_password_leak_verification,json=privatePasswordLeakVerification,proto3" json:"private_password_leak_verification,omitempty"`
}

func (x *Assessment) Reset() {
	*x = Assessment{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Assessment) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Assessment) ProtoMessage() {}

func (x *Assessment) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Assessment.ProtoReflect.Descriptor instead.
func (*Assessment) Descriptor() ([]byte, []int) {
	return file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_rawDescGZIP(), []int{4}
}

func (x *Assessment) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Assessment) GetEvent() *Event {
	if x != nil {
		return x.Event
	}
	return nil
}

func (x *Assessment) GetRiskAnalysis() *RiskAnalysis {
	if x != nil {
		return x.RiskAnalysis
	}
	return nil
}

func (x *Assessment) GetTokenProperties() *TokenProperties {
	if x != nil {
		return x.TokenProperties
	}
	return nil
}

func (x *Assessment) GetAccountDefenderAssessment() *AccountDefenderAssessment {
	if x != nil {
		return x.AccountDefenderAssessment
	}
	return nil
}

func (x *Assessment) GetPrivatePasswordLeakVerification() *PrivatePasswordLeakVerification {
	if x != nil {
		return x.PrivatePasswordLeakVerification
	}
	return nil
}

type Event struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The user response token provided by the reCAPTCHA client-side integration
	// on your site.
	Token string `protobuf:"bytes,1,opt,name=token,proto3" json:"token,omitempty"`
	// Optional. The site key that was used to invoke reCAPTCHA on your site and generate
	// the token.
	SiteKey string `protobuf:"bytes,2,opt,name=site_key,json=siteKey,proto3" json:"site_key,omitempty"`
	// Optional. The user agent present in the request from the user's device related to
	// this event.
	UserAgent string `protobuf:"bytes,3,opt,name=user_agent,json=userAgent,proto3" json:"user_agent,omitempty"`
	// Optional. The IP address in the request from the user's device related to this event.
	UserIpAddress string `protobuf:"bytes,4,opt,name=user_ip_address,json=userIpAddress,proto3" json:"user_ip_address,omitempty"`
	// Optional. The expected action for this type of event. This should be the same action
	// provided at token generation time on client-side platforms already
	// integrated with recaptcha enterprise.
	ExpectedAction string `protobuf:"bytes,5,opt,name=expected_action,json=expectedAction,proto3" json:"expected_action,omitempty"`
	// Optional. Unique stable hashed user identifier for the request. The identifier must
	// be hashed using hmac-sha256 with stable secret.
	HashedAccountId []byte `protobuf:"bytes,6,opt,name=hashed_account_id,json=hashedAccountId,proto3" json:"hashed_account_id,omitempty"`
}

func (x *Event) Reset() {
	*x = Event{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Event) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Event) ProtoMessage() {}

func (x *Event) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Event.ProtoReflect.Descriptor instead.
func (*Event) Descriptor() ([]byte, []int) {
	return file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_rawDescGZIP(), []int{5}
}

func (x *Event) GetToken() string {
	if x != nil {
		return x.Token
	}
	return ""
}

func (x *Event) GetSiteKey() string {
	if x != nil {
		return x.SiteKey
	}
	return ""
}

func (x *Event) GetUserAgent() string {
	if x != nil {
		return x.UserAgent
	}
	return ""
}

func (x *Event) GetUserIpAddress() string {
	if x != nil {
		return x.UserIpAddress
	}
	return ""
}

func (x *Event) GetExpectedAction() string {
	if x != nil {
		return x.ExpectedAction
	}
	return ""
}

func (x *Event) GetHashedAccountId() []byte {
	if x != nil {
		return x.HashedAccountId
	}
	return nil
}

// Risk analysis result for an event.
type RiskAnalysis struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Legitimate event score from 0.0 to 1.0.
	// (1.0 means very likely legitimate traffic while 0.0 means very likely
	// non-legitimate traffic).
	Score float32 `protobuf:"fixed32,1,opt,name=score,proto3" json:"score,omitempty"`
	// Reasons contributing to the risk analysis verdict.
	Reasons []RiskAnalysis_ClassificationReason `protobuf:"varint,2,rep,packed,name=reasons,proto3,enum=google.cloud.recaptchaenterprise.v1.RiskAnalysis_ClassificationReason" json:"reasons,omitempty"`
}

func (x *RiskAnalysis) Reset() {
	*x = RiskAnalysis{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RiskAnalysis) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RiskAnalysis) ProtoMessage() {}

func (x *RiskAnalysis) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RiskAnalysis.ProtoReflect.Descriptor instead.
func (*RiskAnalysis) Descriptor() ([]byte, []int) {
	return file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_rawDescGZIP(), []int{6}
}

func (x *RiskAnalysis) GetScore() float32 {
	if x != nil {
		return x.Score
	}
	return 0
}

func (x *RiskAnalysis) GetReasons() []RiskAnalysis_ClassificationReason {
	if x != nil {
		return x.Reasons
	}
	return nil
}

type TokenProperties struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Whether the provided user response token is valid. When valid = false, the
	// reason could be specified in invalid_reason or it could also be due to
	// a user failing to solve a challenge or a sitekey mismatch (i.e the sitekey
	// used to generate the token was different than the one specified in the
	// assessment).
	Valid bool `protobuf:"varint,1,opt,name=valid,proto3" json:"valid,omitempty"`
	// Reason associated with the response when valid = false.
	InvalidReason TokenProperties_InvalidReason `protobuf:"varint,2,opt,name=invalid_reason,json=invalidReason,proto3,enum=google.cloud.recaptchaenterprise.v1.TokenProperties_InvalidReason" json:"invalid_reason,omitempty"`
	// The timestamp corresponding to the generation of the token.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// The hostname of the page on which the token was generated (Web keys only).
	Hostname string `protobuf:"bytes,4,opt,name=hostname,proto3" json:"hostname,omitempty"`
	// Action name provided at token generation.
	Action string `protobuf:"bytes,5,opt,name=action,proto3" json:"action,omitempty"`
}

func (x *TokenProperties) Reset() {
	*x = TokenProperties{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TokenProperties) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TokenProperties) ProtoMessage() {}

func (x *TokenProperties) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TokenProperties.ProtoReflect.Descriptor instead.
func (*TokenProperties) Descriptor() ([]byte, []int) {
	return file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_rawDescGZIP(), []int{7}
}

func (x *TokenProperties) GetValid() bool {
	if x != nil {
		return x.Valid
	}
	return false
}

func (x *TokenProperties) GetInvalidReason() TokenProperties_InvalidReason {
	if x != nil {
		return x.InvalidReason
	}
	return TokenProperties_INVALID_REASON_UNSPECIFIED
}

func (x *TokenProperties) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *TokenProperties) GetHostname() string {
	if x != nil {
		return x.Hostname
	}
	return ""
}

func (x *TokenProperties) GetAction() string {
	if x != nil {
		return x.Action
	}
	return ""
}

// Account defender risk assessment.
type AccountDefenderAssessment struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Labels for this request.
	Labels []AccountDefenderAssessment_AccountDefenderLabel `protobuf:"varint,1,rep,packed,name=labels,proto3,enum=google.cloud.recaptchaenterprise.v1.AccountDefenderAssessment_AccountDefenderLabel" json:"labels,omitempty"`
}

func (x *AccountDefenderAssessment) Reset() {
	*x = AccountDefenderAssessment{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AccountDefenderAssessment) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AccountDefenderAssessment) ProtoMessage() {}

func (x *AccountDefenderAssessment) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AccountDefenderAssessment.ProtoReflect.Descriptor instead.
func (*AccountDefenderAssessment) Descriptor() ([]byte, []int) {
	return file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_rawDescGZIP(), []int{8}
}

func (x *AccountDefenderAssessment) GetLabels() []AccountDefenderAssessment_AccountDefenderLabel {
	if x != nil {
		return x.Labels
	}
	return nil
}

// The create key request message.
type CreateKeyRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the project in which the key will be created, in the
	// format "projects/{project}".
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. Information to create a reCAPTCHA Enterprise key.
	Key *Key `protobuf:"bytes,2,opt,name=key,proto3" json:"key,omitempty"`
}

func (x *CreateKeyRequest) Reset() {
	*x = CreateKeyRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateKeyRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateKeyRequest) ProtoMessage() {}

func (x *CreateKeyRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateKeyRequest.ProtoReflect.Descriptor instead.
func (*CreateKeyRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_rawDescGZIP(), []int{9}
}

func (x *CreateKeyRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateKeyRequest) GetKey() *Key {
	if x != nil {
		return x.Key
	}
	return nil
}

// The list keys request message.
type ListKeysRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the project that contains the keys that will be
	// listed, in the format "projects/{project}".
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The maximum number of keys to return. Default is 10. Max limit is
	// 1000.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. The next_page_token value returned from a previous.
	// ListKeysRequest, if any.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListKeysRequest) Reset() {
	*x = ListKeysRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListKeysRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListKeysRequest) ProtoMessage() {}

func (x *ListKeysRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListKeysRequest.ProtoReflect.Descriptor instead.
func (*ListKeysRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_rawDescGZIP(), []int{10}
}

func (x *ListKeysRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListKeysRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListKeysRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response to request to list keys in a project.
type ListKeysResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Key details.
	Keys []*Key `protobuf:"bytes,1,rep,name=keys,proto3" json:"keys,omitempty"`
	// Token to retrieve the next page of results. It is set to empty if no keys
	// remain in results.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListKeysResponse) Reset() {
	*x = ListKeysResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListKeysResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListKeysResponse) ProtoMessage() {}

func (x *ListKeysResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListKeysResponse.ProtoReflect.Descriptor instead.
func (*ListKeysResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_rawDescGZIP(), []int{11}
}

func (x *ListKeysResponse) GetKeys() []*Key {
	if x != nil {
		return x.Keys
	}
	return nil
}

func (x *ListKeysResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// The retrieve legacy secret key request message.
type RetrieveLegacySecretKeyRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The public key name linked to the requested secret key in the format
	// "projects/{project}/keys/{key}".
	Key string `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
}

func (x *RetrieveLegacySecretKeyRequest) Reset() {
	*x = RetrieveLegacySecretKeyRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RetrieveLegacySecretKeyRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RetrieveLegacySecretKeyRequest) ProtoMessage() {}

func (x *RetrieveLegacySecretKeyRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RetrieveLegacySecretKeyRequest.ProtoReflect.Descriptor instead.
func (*RetrieveLegacySecretKeyRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_rawDescGZIP(), []int{12}
}

func (x *RetrieveLegacySecretKeyRequest) GetKey() string {
	if x != nil {
		return x.Key
	}
	return ""
}

// The get key request message.
type GetKeyRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the requested key, in the format
	// "projects/{project}/keys/{key}".
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetKeyRequest) Reset() {
	*x = GetKeyRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetKeyRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetKeyRequest) ProtoMessage() {}

func (x *GetKeyRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetKeyRequest.ProtoReflect.Descriptor instead.
func (*GetKeyRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_rawDescGZIP(), []int{13}
}

func (x *GetKeyRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The update key request message.
type UpdateKeyRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The key to update.
	Key *Key `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	// Optional. The mask to control which fields of the key get updated. If the mask is not
	// present, all fields will be updated.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateKeyRequest) Reset() {
	*x = UpdateKeyRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateKeyRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateKeyRequest) ProtoMessage() {}

func (x *UpdateKeyRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateKeyRequest.ProtoReflect.Descriptor instead.
func (*UpdateKeyRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_rawDescGZIP(), []int{14}
}

func (x *UpdateKeyRequest) GetKey() *Key {
	if x != nil {
		return x.Key
	}
	return nil
}

func (x *UpdateKeyRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// The delete key request message.
type DeleteKeyRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the key to be deleted, in the format
	// "projects/{project}/keys/{key}".
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteKeyRequest) Reset() {
	*x = DeleteKeyRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteKeyRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteKeyRequest) ProtoMessage() {}

func (x *DeleteKeyRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteKeyRequest.ProtoReflect.Descriptor instead.
func (*DeleteKeyRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_rawDescGZIP(), []int{15}
}

func (x *DeleteKeyRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The migrate key request message.
type MigrateKeyRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the key to be migrated, in the format
	// "projects/{project}/keys/{key}".
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *MigrateKeyRequest) Reset() {
	*x = MigrateKeyRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MigrateKeyRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MigrateKeyRequest) ProtoMessage() {}

func (x *MigrateKeyRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MigrateKeyRequest.ProtoReflect.Descriptor instead.
func (*MigrateKeyRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_rawDescGZIP(), []int{16}
}

func (x *MigrateKeyRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The get metrics request message.
type GetMetricsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the requested metrics, in the format
	// "projects/{project}/keys/{key}/metrics".
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetMetricsRequest) Reset() {
	*x = GetMetricsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetMetricsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetMetricsRequest) ProtoMessage() {}

func (x *GetMetricsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetMetricsRequest.ProtoReflect.Descriptor instead.
func (*GetMetricsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_rawDescGZIP(), []int{17}
}

func (x *GetMetricsRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Metrics for a single Key.
type Metrics struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The name of the metrics, in the format
	// "projects/{project}/keys/{key}/metrics".
	Name string `protobuf:"bytes,4,opt,name=name,proto3" json:"name,omitempty"`
	// Inclusive start time aligned to a day (UTC).
	StartTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// Metrics will be continuous and in order by dates, and in the granularity
	// of day. All Key types should have score-based data.
	ScoreMetrics []*ScoreMetrics `protobuf:"bytes,2,rep,name=score_metrics,json=scoreMetrics,proto3" json:"score_metrics,omitempty"`
	// Metrics will be continuous and in order by dates, and in the granularity
	// of day. Only challenge-based keys (CHECKBOX, INVISIBLE), will have
	// challenge-based data.
	ChallengeMetrics []*ChallengeMetrics `protobuf:"bytes,3,rep,name=challenge_metrics,json=challengeMetrics,proto3" json:"challenge_metrics,omitempty"`
}

func (x *Metrics) Reset() {
	*x = Metrics{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Metrics) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Metrics) ProtoMessage() {}

func (x *Metrics) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Metrics.ProtoReflect.Descriptor instead.
func (*Metrics) Descriptor() ([]byte, []int) {
	return file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_rawDescGZIP(), []int{18}
}

func (x *Metrics) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Metrics) GetStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StartTime
	}
	return nil
}

func (x *Metrics) GetScoreMetrics() []*ScoreMetrics {
	if x != nil {
		return x.ScoreMetrics
	}
	return nil
}

func (x *Metrics) GetChallengeMetrics() []*ChallengeMetrics {
	if x != nil {
		return x.ChallengeMetrics
	}
	return nil
}

// Secret key is used only in legacy reCAPTCHA. It must be used in a 3rd party
// integration with legacy reCAPTCHA.
type RetrieveLegacySecretKeyResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The secret key (also known as shared secret) authorizes communication
	// between your application backend and the reCAPTCHA Enterprise server to
	// create an assessment.
	// The secret key needs to be kept safe for security purposes.
	LegacySecretKey string `protobuf:"bytes,1,opt,name=legacy_secret_key,json=legacySecretKey,proto3" json:"legacy_secret_key,omitempty"`
}

func (x *RetrieveLegacySecretKeyResponse) Reset() {
	*x = RetrieveLegacySecretKeyResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RetrieveLegacySecretKeyResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RetrieveLegacySecretKeyResponse) ProtoMessage() {}

func (x *RetrieveLegacySecretKeyResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RetrieveLegacySecretKeyResponse.ProtoReflect.Descriptor instead.
func (*RetrieveLegacySecretKeyResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_rawDescGZIP(), []int{19}
}

func (x *RetrieveLegacySecretKeyResponse) GetLegacySecretKey() string {
	if x != nil {
		return x.LegacySecretKey
	}
	return ""
}

// A key used to identify and configure applications (web and/or mobile) that
// use reCAPTCHA Enterprise.
type Key struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource name for the Key in the format
	// "projects/{project}/keys/{key}".
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Human-readable display name of this key. Modifiable by user.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Platform specific settings for this key. The key can only be used on a
	// platform for which the settings are enabled.
	//
	// Types that are assignable to PlatformSettings:
	//
	//	*Key_WebSettings
	//	*Key_AndroidSettings
	//	*Key_IosSettings
	PlatformSettings isKey_PlatformSettings `protobuf_oneof:"platform_settings"`
	// See <a href="https://cloud.google.com/recaptcha-enterprise/docs/labels">
	// Creating and managing labels</a>.
	Labels map[string]string `protobuf:"bytes,6,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// The timestamp corresponding to the creation of this Key.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,7,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Options for user acceptance testing.
	TestingOptions *TestingOptions `protobuf:"bytes,9,opt,name=testing_options,json=testingOptions,proto3" json:"testing_options,omitempty"`
	// Settings for WAF
	WafSettings *WafSettings `protobuf:"bytes,10,opt,name=waf_settings,json=wafSettings,proto3" json:"waf_settings,omitempty"`
}

func (x *Key) Reset() {
	*x = Key{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Key) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Key) ProtoMessage() {}

func (x *Key) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Key.ProtoReflect.Descriptor instead.
func (*Key) Descriptor() ([]byte, []int) {
	return file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_rawDescGZIP(), []int{20}
}

func (x *Key) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Key) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (m *Key) GetPlatformSettings() isKey_PlatformSettings {
	if m != nil {
		return m.PlatformSettings
	}
	return nil
}

func (x *Key) GetWebSettings() *WebKeySettings {
	if x, ok := x.GetPlatformSettings().(*Key_WebSettings); ok {
		return x.WebSettings
	}
	return nil
}

func (x *Key) GetAndroidSettings() *AndroidKeySettings {
	if x, ok := x.GetPlatformSettings().(*Key_AndroidSettings); ok {
		return x.AndroidSettings
	}
	return nil
}

func (x *Key) GetIosSettings() *IOSKeySettings {
	if x, ok := x.GetPlatformSettings().(*Key_IosSettings); ok {
		return x.IosSettings
	}
	return nil
}

func (x *Key) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *Key) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Key) GetTestingOptions() *TestingOptions {
	if x != nil {
		return x.TestingOptions
	}
	return nil
}

func (x *Key) GetWafSettings() *WafSettings {
	if x != nil {
		return x.WafSettings
	}
	return nil
}

type isKey_PlatformSettings interface {
	isKey_PlatformSettings()
}

type Key_WebSettings struct {
	// Settings for keys that can be used by websites.
	WebSettings *WebKeySettings `protobuf:"bytes,3,opt,name=web_settings,json=webSettings,proto3,oneof"`
}

type Key_AndroidSettings struct {
	// Settings for keys that can be used by Android apps.
	AndroidSettings *AndroidKeySettings `protobuf:"bytes,4,opt,name=android_settings,json=androidSettings,proto3,oneof"`
}

type Key_IosSettings struct {
	// Settings for keys that can be used by iOS apps.
	IosSettings *IOSKeySettings `protobuf:"bytes,5,opt,name=ios_settings,json=iosSettings,proto3,oneof"`
}

func (*Key_WebSettings) isKey_PlatformSettings() {}

func (*Key_AndroidSettings) isKey_PlatformSettings() {}

func (*Key_IosSettings) isKey_PlatformSettings() {}

// Options for user acceptance testing.
type TestingOptions struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// All assessments for this Key will return this score. Must be between 0
	// (likely not legitimate) and 1 (likely legitimate) inclusive.
	TestingScore float32 `protobuf:"fixed32,1,opt,name=testing_score,json=testingScore,proto3" json:"testing_score,omitempty"`
	// For challenge-based keys only (CHECKBOX, INVISIBLE), all challenge requests
	// for this site will return nocaptcha if NOCAPTCHA, or an unsolvable
	// challenge if CHALLENGE.
	TestingChallenge TestingOptions_TestingChallenge `protobuf:"varint,2,opt,name=testing_challenge,json=testingChallenge,proto3,enum=google.cloud.recaptchaenterprise.v1.TestingOptions_TestingChallenge" json:"testing_challenge,omitempty"`
}

func (x *TestingOptions) Reset() {
	*x = TestingOptions{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TestingOptions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TestingOptions) ProtoMessage() {}

func (x *TestingOptions) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TestingOptions.ProtoReflect.Descriptor instead.
func (*TestingOptions) Descriptor() ([]byte, []int) {
	return file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_rawDescGZIP(), []int{21}
}

func (x *TestingOptions) GetTestingScore() float32 {
	if x != nil {
		return x.TestingScore
	}
	return 0
}

func (x *TestingOptions) GetTestingChallenge() TestingOptions_TestingChallenge {
	if x != nil {
		return x.TestingChallenge
	}
	return TestingOptions_TESTING_CHALLENGE_UNSPECIFIED
}

// Settings specific to keys that can be used by websites.
type WebKeySettings struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// If set to true, it means allowed_domains will not be enforced.
	AllowAllDomains bool `protobuf:"varint,3,opt,name=allow_all_domains,json=allowAllDomains,proto3" json:"allow_all_domains,omitempty"`
	// Domains or subdomains of websites allowed to use the key. All subdomains
	// of an allowed domain are automatically allowed. A valid domain requires a
	// host and must not include any path, port, query or fragment.
	// Examples: 'example.com' or 'subdomain.example.com'
	AllowedDomains []string `protobuf:"bytes,1,rep,name=allowed_domains,json=allowedDomains,proto3" json:"allowed_domains,omitempty"`
	// If set to true, the key can be used on AMP (Accelerated Mobile Pages)
	// websites. This is supported only for the SCORE integration type.
	AllowAmpTraffic bool `protobuf:"varint,2,opt,name=allow_amp_traffic,json=allowAmpTraffic,proto3" json:"allow_amp_traffic,omitempty"`
	// Required. Describes how this key is integrated with the website.
	IntegrationType WebKeySettings_IntegrationType `protobuf:"varint,4,opt,name=integration_type,json=integrationType,proto3,enum=google.cloud.recaptchaenterprise.v1.WebKeySettings_IntegrationType" json:"integration_type,omitempty"`
	// Settings for the frequency and difficulty at which this key triggers
	// captcha challenges. This should only be specified for IntegrationTypes
	// CHECKBOX and INVISIBLE.
	ChallengeSecurityPreference WebKeySettings_ChallengeSecurityPreference `protobuf:"varint,5,opt,name=challenge_security_preference,json=challengeSecurityPreference,proto3,enum=google.cloud.recaptchaenterprise.v1.WebKeySettings_ChallengeSecurityPreference" json:"challenge_security_preference,omitempty"`
}

func (x *WebKeySettings) Reset() {
	*x = WebKeySettings{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_msgTypes[22]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *WebKeySettings) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WebKeySettings) ProtoMessage() {}

func (x *WebKeySettings) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_msgTypes[22]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WebKeySettings.ProtoReflect.Descriptor instead.
func (*WebKeySettings) Descriptor() ([]byte, []int) {
	return file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_rawDescGZIP(), []int{22}
}

func (x *WebKeySettings) GetAllowAllDomains() bool {
	if x != nil {
		return x.AllowAllDomains
	}
	return false
}

func (x *WebKeySettings) GetAllowedDomains() []string {
	if x != nil {
		return x.AllowedDomains
	}
	return nil
}

func (x *WebKeySettings) GetAllowAmpTraffic() bool {
	if x != nil {
		return x.AllowAmpTraffic
	}
	return false
}

func (x *WebKeySettings) GetIntegrationType() WebKeySettings_IntegrationType {
	if x != nil {
		return x.IntegrationType
	}
	return WebKeySettings_INTEGRATION_TYPE_UNSPECIFIED
}

func (x *WebKeySettings) GetChallengeSecurityPreference() WebKeySettings_ChallengeSecurityPreference {
	if x != nil {
		return x.ChallengeSecurityPreference
	}
	return WebKeySettings_CHALLENGE_SECURITY_PREFERENCE_UNSPECIFIED
}

// Settings specific to keys that can be used by Android apps.
type AndroidKeySettings struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// If set to true, allowed_package_names are not enforced.
	AllowAllPackageNames bool `protobuf:"varint,2,opt,name=allow_all_package_names,json=allowAllPackageNames,proto3" json:"allow_all_package_names,omitempty"`
	// Android package names of apps allowed to use the key.
	// Example: 'com.companyname.appname'
	AllowedPackageNames []string `protobuf:"bytes,1,rep,name=allowed_package_names,json=allowedPackageNames,proto3" json:"allowed_package_names,omitempty"`
}

func (x *AndroidKeySettings) Reset() {
	*x = AndroidKeySettings{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_msgTypes[23]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AndroidKeySettings) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AndroidKeySettings) ProtoMessage() {}

func (x *AndroidKeySettings) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_msgTypes[23]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AndroidKeySettings.ProtoReflect.Descriptor instead.
func (*AndroidKeySettings) Descriptor() ([]byte, []int) {
	return file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_rawDescGZIP(), []int{23}
}

func (x *AndroidKeySettings) GetAllowAllPackageNames() bool {
	if x != nil {
		return x.AllowAllPackageNames
	}
	return false
}

func (x *AndroidKeySettings) GetAllowedPackageNames() []string {
	if x != nil {
		return x.AllowedPackageNames
	}
	return nil
}

// Settings specific to keys that can be used by iOS apps.
type IOSKeySettings struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// If set to true, allowed_bundle_ids are not enforced.
	AllowAllBundleIds bool `protobuf:"varint,2,opt,name=allow_all_bundle_ids,json=allowAllBundleIds,proto3" json:"allow_all_bundle_ids,omitempty"`
	// iOS bundle ids of apps allowed to use the key.
	// Example: 'com.companyname.productname.appname'
	AllowedBundleIds []string `protobuf:"bytes,1,rep,name=allowed_bundle_ids,json=allowedBundleIds,proto3" json:"allowed_bundle_ids,omitempty"`
}

func (x *IOSKeySettings) Reset() {
	*x = IOSKeySettings{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_msgTypes[24]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IOSKeySettings) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IOSKeySettings) ProtoMessage() {}

func (x *IOSKeySettings) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_msgTypes[24]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IOSKeySettings.ProtoReflect.Descriptor instead.
func (*IOSKeySettings) Descriptor() ([]byte, []int) {
	return file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_rawDescGZIP(), []int{24}
}

func (x *IOSKeySettings) GetAllowAllBundleIds() bool {
	if x != nil {
		return x.AllowAllBundleIds
	}
	return false
}

func (x *IOSKeySettings) GetAllowedBundleIds() []string {
	if x != nil {
		return x.AllowedBundleIds
	}
	return nil
}

// Score distribution.
type ScoreDistribution struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Map key is score value multiplied by 100. The scores are discrete values
	// between [0, 1]. The maximum number of buckets is on order of a few dozen,
	// but typically much lower (ie. 10).
	ScoreBuckets map[int32]int64 `protobuf:"bytes,1,rep,name=score_buckets,json=scoreBuckets,proto3" json:"score_buckets,omitempty" protobuf_key:"varint,1,opt,name=key,proto3" protobuf_val:"varint,2,opt,name=value,proto3"`
}

func (x *ScoreDistribution) Reset() {
	*x = ScoreDistribution{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_msgTypes[25]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ScoreDistribution) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ScoreDistribution) ProtoMessage() {}

func (x *ScoreDistribution) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_msgTypes[25]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ScoreDistribution.ProtoReflect.Descriptor instead.
func (*ScoreDistribution) Descriptor() ([]byte, []int) {
	return file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_rawDescGZIP(), []int{25}
}

func (x *ScoreDistribution) GetScoreBuckets() map[int32]int64 {
	if x != nil {
		return x.ScoreBuckets
	}
	return nil
}

// Metrics related to scoring.
type ScoreMetrics struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Aggregated score metrics for all traffic.
	OverallMetrics *ScoreDistribution `protobuf:"bytes,1,opt,name=overall_metrics,json=overallMetrics,proto3" json:"overall_metrics,omitempty"`
	// Action-based metrics. The map key is the action name which specified by the
	// site owners at time of the "execute" client-side call.
	// Populated only for SCORE keys.
	ActionMetrics map[string]*ScoreDistribution `protobuf:"bytes,2,rep,name=action_metrics,json=actionMetrics,proto3" json:"action_metrics,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *ScoreMetrics) Reset() {
	*x = ScoreMetrics{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_msgTypes[26]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ScoreMetrics) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ScoreMetrics) ProtoMessage() {}

func (x *ScoreMetrics) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_msgTypes[26]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ScoreMetrics.ProtoReflect.Descriptor instead.
func (*ScoreMetrics) Descriptor() ([]byte, []int) {
	return file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_rawDescGZIP(), []int{26}
}

func (x *ScoreMetrics) GetOverallMetrics() *ScoreDistribution {
	if x != nil {
		return x.OverallMetrics
	}
	return nil
}

func (x *ScoreMetrics) GetActionMetrics() map[string]*ScoreDistribution {
	if x != nil {
		return x.ActionMetrics
	}
	return nil
}

// Metrics related to challenges.
type ChallengeMetrics struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Count of reCAPTCHA checkboxes or badges rendered. This is mostly equivalent
	// to a count of pageloads for pages that include reCAPTCHA.
	PageloadCount int64 `protobuf:"varint,1,opt,name=pageload_count,json=pageloadCount,proto3" json:"pageload_count,omitempty"`
	// Count of nocaptchas (successful verification without a challenge) issued.
	NocaptchaCount int64 `protobuf:"varint,2,opt,name=nocaptcha_count,json=nocaptchaCount,proto3" json:"nocaptcha_count,omitempty"`
	// Count of submitted challenge solutions that were incorrect or otherwise
	// deemed suspicious such that a subsequent challenge was triggered.
	FailedCount int64 `protobuf:"varint,3,opt,name=failed_count,json=failedCount,proto3" json:"failed_count,omitempty"`
	// Count of nocaptchas (successful verification without a challenge) plus
	// submitted challenge solutions that were correct and resulted in
	// verification.
	PassedCount int64 `protobuf:"varint,4,opt,name=passed_count,json=passedCount,proto3" json:"passed_count,omitempty"`
}

func (x *ChallengeMetrics) Reset() {
	*x = ChallengeMetrics{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_msgTypes[27]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ChallengeMetrics) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ChallengeMetrics) ProtoMessage() {}

func (x *ChallengeMetrics) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_msgTypes[27]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ChallengeMetrics.ProtoReflect.Descriptor instead.
func (*ChallengeMetrics) Descriptor() ([]byte, []int) {
	return file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_rawDescGZIP(), []int{27}
}

func (x *ChallengeMetrics) GetPageloadCount() int64 {
	if x != nil {
		return x.PageloadCount
	}
	return 0
}

func (x *ChallengeMetrics) GetNocaptchaCount() int64 {
	if x != nil {
		return x.NocaptchaCount
	}
	return 0
}

func (x *ChallengeMetrics) GetFailedCount() int64 {
	if x != nil {
		return x.FailedCount
	}
	return 0
}

func (x *ChallengeMetrics) GetPassedCount() int64 {
	if x != nil {
		return x.PassedCount
	}
	return 0
}

// The request message to list memberships in a related account group.
type ListRelatedAccountGroupMembershipsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name for the related account group in the format
	// `projects/{project}/relatedaccountgroups/{relatedaccountgroup}`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The maximum number of accounts to return. The service might return fewer
	// than this value.
	// If unspecified, at most 50 accounts are returned.
	// The maximum value is 1000; values above 1000 are coerced to 1000.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. A page token, received from a previous `ListRelatedAccountGroupMemberships`
	// call.
	//
	// When paginating, all other parameters provided to
	// `ListRelatedAccountGroupMemberships` must match the call that provided the
	// page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListRelatedAccountGroupMembershipsRequest) Reset() {
	*x = ListRelatedAccountGroupMembershipsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_msgTypes[28]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListRelatedAccountGroupMembershipsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListRelatedAccountGroupMembershipsRequest) ProtoMessage() {}

func (x *ListRelatedAccountGroupMembershipsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_msgTypes[28]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListRelatedAccountGroupMembershipsRequest.ProtoReflect.Descriptor instead.
func (*ListRelatedAccountGroupMembershipsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_rawDescGZIP(), []int{28}
}

func (x *ListRelatedAccountGroupMembershipsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListRelatedAccountGroupMembershipsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListRelatedAccountGroupMembershipsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// The response to a `ListRelatedAccountGroupMemberships` call.
type ListRelatedAccountGroupMembershipsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The memberships listed by the query.
	RelatedAccountGroupMemberships []*RelatedAccountGroupMembership `protobuf:"bytes,1,rep,name=related_account_group_memberships,json=relatedAccountGroupMemberships,proto3" json:"related_account_group_memberships,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListRelatedAccountGroupMembershipsResponse) Reset() {
	*x = ListRelatedAccountGroupMembershipsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_msgTypes[29]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListRelatedAccountGroupMembershipsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListRelatedAccountGroupMembershipsResponse) ProtoMessage() {}

func (x *ListRelatedAccountGroupMembershipsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_msgTypes[29]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListRelatedAccountGroupMembershipsResponse.ProtoReflect.Descriptor instead.
func (*ListRelatedAccountGroupMembershipsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_rawDescGZIP(), []int{29}
}

func (x *ListRelatedAccountGroupMembershipsResponse) GetRelatedAccountGroupMemberships() []*RelatedAccountGroupMembership {
	if x != nil {
		return x.RelatedAccountGroupMemberships
	}
	return nil
}

func (x *ListRelatedAccountGroupMembershipsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// The request message to list related account groups.
type ListRelatedAccountGroupsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the project to list related account groups from, in the format
	// "projects/{project}".
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The maximum number of groups to return. The service might return fewer than
	// this value.
	// If unspecified, at most 50 groups are returned.
	// The maximum value is 1000; values above 1000 are coerced to 1000.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. A page token, received from a previous `ListRelatedAccountGroups` call.
	// Provide this to retrieve the subsequent page.
	//
	// When paginating, all other parameters provided to
	// `ListRelatedAccountGroups` must match the call that provided the page
	// token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListRelatedAccountGroupsRequest) Reset() {
	*x = ListRelatedAccountGroupsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_msgTypes[30]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListRelatedAccountGroupsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListRelatedAccountGroupsRequest) ProtoMessage() {}

func (x *ListRelatedAccountGroupsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_msgTypes[30]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListRelatedAccountGroupsRequest.ProtoReflect.Descriptor instead.
func (*ListRelatedAccountGroupsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_rawDescGZIP(), []int{30}
}

func (x *ListRelatedAccountGroupsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListRelatedAccountGroupsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListRelatedAccountGroupsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// The response to a `ListRelatedAccountGroups` call.
type ListRelatedAccountGroupsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The groups of related accounts listed by the query.
	RelatedAccountGroups []*RelatedAccountGroup `protobuf:"bytes,1,rep,name=related_account_groups,json=relatedAccountGroups,proto3" json:"related_account_groups,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListRelatedAccountGroupsResponse) Reset() {
	*x = ListRelatedAccountGroupsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_msgTypes[31]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListRelatedAccountGroupsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListRelatedAccountGroupsResponse) ProtoMessage() {}

func (x *ListRelatedAccountGroupsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_msgTypes[31]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListRelatedAccountGroupsResponse.ProtoReflect.Descriptor instead.
func (*ListRelatedAccountGroupsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_rawDescGZIP(), []int{31}
}

func (x *ListRelatedAccountGroupsResponse) GetRelatedAccountGroups() []*RelatedAccountGroup {
	if x != nil {
		return x.RelatedAccountGroups
	}
	return nil
}

func (x *ListRelatedAccountGroupsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// The request message to search related account group memberships.
type SearchRelatedAccountGroupMembershipsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the project to search related account group memberships from.
	// Specify the project name in the following format: "projects/{project}".
	Project string `protobuf:"bytes,1,opt,name=project,proto3" json:"project,omitempty"`
	// Optional. The unique stable hashed user identifier we should search connections to.
	// The identifier should correspond to a `hashed_account_id` provided in a
	// previous `CreateAssessment` or `AnnotateAssessment` call.
	HashedAccountId []byte `protobuf:"bytes,2,opt,name=hashed_account_id,json=hashedAccountId,proto3" json:"hashed_account_id,omitempty"`
	// Optional. The maximum number of groups to return. The service might return fewer than
	// this value.
	// If unspecified, at most 50 groups are returned.
	// The maximum value is 1000; values above 1000 are coerced to 1000.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. A page token, received from a previous
	// `SearchRelatedAccountGroupMemberships` call. Provide this to retrieve the
	// subsequent page.
	//
	// When paginating, all other parameters provided to
	// `SearchRelatedAccountGroupMemberships` must match the call that provided
	// the page token.
	PageToken string `protobuf:"bytes,4,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *SearchRelatedAccountGroupMembershipsRequest) Reset() {
	*x = SearchRelatedAccountGroupMembershipsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_msgTypes[32]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchRelatedAccountGroupMembershipsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchRelatedAccountGroupMembershipsRequest) ProtoMessage() {}

func (x *SearchRelatedAccountGroupMembershipsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_msgTypes[32]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchRelatedAccountGroupMembershipsRequest.ProtoReflect.Descriptor instead.
func (*SearchRelatedAccountGroupMembershipsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_rawDescGZIP(), []int{32}
}

func (x *SearchRelatedAccountGroupMembershipsRequest) GetProject() string {
	if x != nil {
		return x.Project
	}
	return ""
}

func (x *SearchRelatedAccountGroupMembershipsRequest) GetHashedAccountId() []byte {
	if x != nil {
		return x.HashedAccountId
	}
	return nil
}

func (x *SearchRelatedAccountGroupMembershipsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *SearchRelatedAccountGroupMembershipsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// The response to a `SearchRelatedAccountGroupMemberships` call.
type SearchRelatedAccountGroupMembershipsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The queried memberships.
	RelatedAccountGroupMemberships []*RelatedAccountGroupMembership `protobuf:"bytes,1,rep,name=related_account_group_memberships,json=relatedAccountGroupMemberships,proto3" json:"related_account_group_memberships,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *SearchRelatedAccountGroupMembershipsResponse) Reset() {
	*x = SearchRelatedAccountGroupMembershipsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_msgTypes[33]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchRelatedAccountGroupMembershipsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchRelatedAccountGroupMembershipsResponse) ProtoMessage() {}

func (x *SearchRelatedAccountGroupMembershipsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_msgTypes[33]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchRelatedAccountGroupMembershipsResponse.ProtoReflect.Descriptor instead.
func (*SearchRelatedAccountGroupMembershipsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_rawDescGZIP(), []int{33}
}

func (x *SearchRelatedAccountGroupMembershipsResponse) GetRelatedAccountGroupMemberships() []*RelatedAccountGroupMembership {
	if x != nil {
		return x.RelatedAccountGroupMemberships
	}
	return nil
}

func (x *SearchRelatedAccountGroupMembershipsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// A membership in a group of related accounts.
type RelatedAccountGroupMembership struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name for this membership in the format
	// `projects/{project}/relatedaccountgroups/{relatedaccountgroup}/memberships/{membership}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The unique stable hashed user identifier of the member. The identifier
	// corresponds to a `hashed_account_id` provided in a previous
	// `CreateAssessment` or `AnnotateAssessment` call.
	HashedAccountId []byte `protobuf:"bytes,2,opt,name=hashed_account_id,json=hashedAccountId,proto3" json:"hashed_account_id,omitempty"`
}

func (x *RelatedAccountGroupMembership) Reset() {
	*x = RelatedAccountGroupMembership{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_msgTypes[34]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RelatedAccountGroupMembership) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RelatedAccountGroupMembership) ProtoMessage() {}

func (x *RelatedAccountGroupMembership) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_msgTypes[34]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RelatedAccountGroupMembership.ProtoReflect.Descriptor instead.
func (*RelatedAccountGroupMembership) Descriptor() ([]byte, []int) {
	return file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_rawDescGZIP(), []int{34}
}

func (x *RelatedAccountGroupMembership) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *RelatedAccountGroupMembership) GetHashedAccountId() []byte {
	if x != nil {
		return x.HashedAccountId
	}
	return nil
}

// A group of related accounts.
type RelatedAccountGroup struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name for the related account group in the format
	// `projects/{project}/relatedaccountgroups/{related_account_group}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *RelatedAccountGroup) Reset() {
	*x = RelatedAccountGroup{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_msgTypes[35]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RelatedAccountGroup) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RelatedAccountGroup) ProtoMessage() {}

func (x *RelatedAccountGroup) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_msgTypes[35]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RelatedAccountGroup.ProtoReflect.Descriptor instead.
func (*RelatedAccountGroup) Descriptor() ([]byte, []int) {
	return file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_rawDescGZIP(), []int{35}
}

func (x *RelatedAccountGroup) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Settings specific to keys that can be used for WAF (Web Application
// Firewall).
type WafSettings struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The WAF service that uses this key.
	WafService WafSettings_WafService `protobuf:"varint,1,opt,name=waf_service,json=wafService,proto3,enum=google.cloud.recaptchaenterprise.v1.WafSettings_WafService" json:"waf_service,omitempty"`
	// Required. The WAF feature for which this key is enabled.
	WafFeature WafSettings_WafFeature `protobuf:"varint,2,opt,name=waf_feature,json=wafFeature,proto3,enum=google.cloud.recaptchaenterprise.v1.WafSettings_WafFeature" json:"waf_feature,omitempty"`
}

func (x *WafSettings) Reset() {
	*x = WafSettings{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_msgTypes[36]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *WafSettings) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WafSettings) ProtoMessage() {}

func (x *WafSettings) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_msgTypes[36]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WafSettings.ProtoReflect.Descriptor instead.
func (*WafSettings) Descriptor() ([]byte, []int) {
	return file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_rawDescGZIP(), []int{36}
}

func (x *WafSettings) GetWafService() WafSettings_WafService {
	if x != nil {
		return x.WafService
	}
	return WafSettings_WAF_SERVICE_UNSPECIFIED
}

func (x *WafSettings) GetWafFeature() WafSettings_WafFeature {
	if x != nil {
		return x.WafFeature
	}
	return WafSettings_WAF_FEATURE_UNSPECIFIED
}

var File_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto protoreflect.FileDescriptor

var file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_rawDesc = []byte{
	0x0a, 0x3d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x72,
	0x65, 0x63, 0x61, 0x70, 0x74, 0x63, 0x68, 0x61, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69,
	0x73, 0x65, 0x2f, 0x76, 0x31, 0x2f, 0x72, 0x65, 0x63, 0x61, 0x70, 0x74, 0x63, 0x68, 0x61, 0x65,
	0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12,
	0x23, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65,
	0x63, 0x61, 0x70, 0x74, 0x63, 0x68, 0x61, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73,
	0x65, 0x2e, 0x76, 0x31, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69,
	0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63,
	0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65,
	0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x65, 0x6d, 0x70, 0x74, 0x79, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xbc, 0x01, 0x0a, 0x17, 0x43, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x41, 0x73, 0x73, 0x65, 0x73, 0x73, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x4b, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x33, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2d, 0x0a, 0x2b, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65,
	0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x12, 0x54, 0x0a, 0x0a, 0x61, 0x73, 0x73, 0x65, 0x73, 0x73, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x63, 0x61, 0x70, 0x74, 0x63, 0x68, 0x61, 0x65, 0x6e, 0x74,
	0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x73, 0x73, 0x65, 0x73,
	0x73, 0x6d, 0x65, 0x6e, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x61, 0x73, 0x73, 0x65,
	0x73, 0x73, 0x6d, 0x65, 0x6e, 0x74, 0x22, 0xbf, 0x06, 0x0a, 0x19, 0x41, 0x6e, 0x6e, 0x6f, 0x74,
	0x61, 0x74, 0x65, 0x41, 0x73, 0x73, 0x65, 0x73, 0x73, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x49, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x35, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2f, 0x0a, 0x2d, 0x72, 0x65, 0x63, 0x61,
	0x70, 0x74, 0x63, 0x68, 0x61, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41,
	0x73, 0x73, 0x65, 0x73, 0x73, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12,
	0x6e, 0x0a, 0x0a, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x49, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x72, 0x65, 0x63, 0x61, 0x70, 0x74, 0x63, 0x68, 0x61, 0x65, 0x6e, 0x74, 0x65,
	0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61,
	0x74, 0x65, 0x41, 0x73, 0x73, 0x65, 0x73, 0x73, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x2e, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x0a, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x64, 0x0a, 0x07, 0x72, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0e,
	0x32, 0x45, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x72, 0x65, 0x63, 0x61, 0x70, 0x74, 0x63, 0x68, 0x61, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72,
	0x69, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x65, 0x41,
	0x73, 0x73, 0x65, 0x73, 0x73, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x2e, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x07, 0x72, 0x65,
	0x61, 0x73, 0x6f, 0x6e, 0x73, 0x12, 0x2f, 0x0a, 0x11, 0x68, 0x61, 0x73, 0x68, 0x65, 0x64, 0x5f,
	0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0c,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0f, 0x68, 0x61, 0x73, 0x68, 0x65, 0x64, 0x41, 0x63, 0x63,
	0x6f, 0x75, 0x6e, 0x74, 0x49, 0x64, 0x22, 0x7e, 0x0a, 0x0a, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1a, 0x0a, 0x16, 0x41, 0x4e, 0x4e, 0x4f, 0x54, 0x41, 0x54, 0x49,
	0x4f, 0x4e, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00,
	0x12, 0x0e, 0x0a, 0x0a, 0x4c, 0x45, 0x47, 0x49, 0x54, 0x49, 0x4d, 0x41, 0x54, 0x45, 0x10, 0x01,
	0x12, 0x0e, 0x0a, 0x0a, 0x46, 0x52, 0x41, 0x55, 0x44, 0x55, 0x4c, 0x45, 0x4e, 0x54, 0x10, 0x02,
	0x12, 0x18, 0x0a, 0x10, 0x50, 0x41, 0x53, 0x53, 0x57, 0x4f, 0x52, 0x44, 0x5f, 0x43, 0x4f, 0x52,
	0x52, 0x45, 0x43, 0x54, 0x10, 0x03, 0x1a, 0x02, 0x08, 0x01, 0x12, 0x1a, 0x0a, 0x12, 0x50, 0x41,
	0x53, 0x53, 0x57, 0x4f, 0x52, 0x44, 0x5f, 0x49, 0x4e, 0x43, 0x4f, 0x52, 0x52, 0x45, 0x43, 0x54,
	0x10, 0x04, 0x1a, 0x02, 0x08, 0x01, 0x22, 0xcf, 0x02, 0x0a, 0x06, 0x52, 0x65, 0x61, 0x73, 0x6f,
	0x6e, 0x12, 0x16, 0x0a, 0x12, 0x52, 0x45, 0x41, 0x53, 0x4f, 0x4e, 0x5f, 0x55, 0x4e, 0x53, 0x50,
	0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0e, 0x0a, 0x0a, 0x43, 0x48, 0x41,
	0x52, 0x47, 0x45, 0x42, 0x41, 0x43, 0x4b, 0x10, 0x01, 0x12, 0x14, 0x0a, 0x10, 0x43, 0x48, 0x41,
	0x52, 0x47, 0x45, 0x42, 0x41, 0x43, 0x4b, 0x5f, 0x46, 0x52, 0x41, 0x55, 0x44, 0x10, 0x08, 0x12,
	0x16, 0x0a, 0x12, 0x43, 0x48, 0x41, 0x52, 0x47, 0x45, 0x42, 0x41, 0x43, 0x4b, 0x5f, 0x44, 0x49,
	0x53, 0x50, 0x55, 0x54, 0x45, 0x10, 0x09, 0x12, 0x0a, 0x0a, 0x06, 0x52, 0x45, 0x46, 0x55, 0x4e,
	0x44, 0x10, 0x0a, 0x12, 0x10, 0x0a, 0x0c, 0x52, 0x45, 0x46, 0x55, 0x4e, 0x44, 0x5f, 0x46, 0x52,
	0x41, 0x55, 0x44, 0x10, 0x0b, 0x12, 0x18, 0x0a, 0x14, 0x54, 0x52, 0x41, 0x4e, 0x53, 0x41, 0x43,
	0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x41, 0x43, 0x43, 0x45, 0x50, 0x54, 0x45, 0x44, 0x10, 0x0c, 0x12,
	0x18, 0x0a, 0x14, 0x54, 0x52, 0x41, 0x4e, 0x53, 0x41, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x44,
	0x45, 0x43, 0x4c, 0x49, 0x4e, 0x45, 0x44, 0x10, 0x0d, 0x12, 0x16, 0x0a, 0x12, 0x50, 0x41, 0x59,
	0x4d, 0x45, 0x4e, 0x54, 0x5f, 0x48, 0x45, 0x55, 0x52, 0x49, 0x53, 0x54, 0x49, 0x43, 0x53, 0x10,
	0x02, 0x12, 0x18, 0x0a, 0x14, 0x49, 0x4e, 0x49, 0x54, 0x49, 0x41, 0x54, 0x45, 0x44, 0x5f, 0x54,
	0x57, 0x4f, 0x5f, 0x46, 0x41, 0x43, 0x54, 0x4f, 0x52, 0x10, 0x07, 0x12, 0x15, 0x0a, 0x11, 0x50,
	0x41, 0x53, 0x53, 0x45, 0x44, 0x5f, 0x54, 0x57, 0x4f, 0x5f, 0x46, 0x41, 0x43, 0x54, 0x4f, 0x52,
	0x10, 0x03, 0x12, 0x15, 0x0a, 0x11, 0x46, 0x41, 0x49, 0x4c, 0x45, 0x44, 0x5f, 0x54, 0x57, 0x4f,
	0x5f, 0x46, 0x41, 0x43, 0x54, 0x4f, 0x52, 0x10, 0x04, 0x12, 0x14, 0x0a, 0x10, 0x43, 0x4f, 0x52,
	0x52, 0x45, 0x43, 0x54, 0x5f, 0x50, 0x41, 0x53, 0x53, 0x57, 0x4f, 0x52, 0x44, 0x10, 0x05, 0x12,
	0x16, 0x0a, 0x12, 0x49, 0x4e, 0x43, 0x4f, 0x52, 0x52, 0x45, 0x43, 0x54, 0x5f, 0x50, 0x41, 0x53,
	0x53, 0x57, 0x4f, 0x52, 0x44, 0x10, 0x06, 0x12, 0x0f, 0x0a, 0x0b, 0x53, 0x4f, 0x43, 0x49, 0x41,
	0x4c, 0x5f, 0x53, 0x50, 0x41, 0x4d, 0x10, 0x0e, 0x22, 0x1c, 0x0a, 0x1a, 0x41, 0x6e, 0x6e, 0x6f,
	0x74, 0x61, 0x74, 0x65, 0x41, 0x73, 0x73, 0x65, 0x73, 0x73, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0xb8, 0x02, 0x0a, 0x1f, 0x50, 0x72, 0x69, 0x76, 0x61,
	0x74, 0x65, 0x50, 0x61, 0x73, 0x73, 0x77, 0x6f, 0x72, 0x64, 0x4c, 0x65, 0x61, 0x6b, 0x56, 0x65,
	0x72, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x31, 0x0a, 0x12, 0x6c, 0x6f,
	0x6f, 0x6b, 0x75, 0x70, 0x5f, 0x68, 0x61, 0x73, 0x68, 0x5f, 0x70, 0x72, 0x65, 0x66, 0x69, 0x78,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0c, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x10, 0x6c, 0x6f, 0x6f,
	0x6b, 0x75, 0x70, 0x48, 0x61, 0x73, 0x68, 0x50, 0x72, 0x65, 0x66, 0x69, 0x78, 0x12, 0x4a, 0x0a,
	0x1f, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x65, 0x64, 0x5f, 0x75, 0x73, 0x65, 0x72, 0x5f,
	0x63, 0x72, 0x65, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x73, 0x5f, 0x68, 0x61, 0x73, 0x68,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x1c, 0x65, 0x6e, 0x63,
	0x72, 0x79, 0x70, 0x74, 0x65, 0x64, 0x55, 0x73, 0x65, 0x72, 0x43, 0x72, 0x65, 0x64, 0x65, 0x6e,
	0x74, 0x69, 0x61, 0x6c, 0x73, 0x48, 0x61, 0x73, 0x68, 0x12, 0x46, 0x0a, 0x1d, 0x65, 0x6e, 0x63,
	0x72, 0x79, 0x70, 0x74, 0x65, 0x64, 0x5f, 0x6c, 0x65, 0x61, 0x6b, 0x5f, 0x6d, 0x61, 0x74, 0x63,
	0x68, 0x5f, 0x70, 0x72, 0x65, 0x66, 0x69, 0x78, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0c,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x1a, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x65, 0x64,
	0x4c, 0x65, 0x61, 0x6b, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x50, 0x72, 0x65, 0x66, 0x69, 0x78, 0x65,
	0x73, 0x12, 0x4e, 0x0a, 0x21, 0x72, 0x65, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x65, 0x64,
	0x5f, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x63, 0x72, 0x65, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c,
	0x73, 0x5f, 0x68, 0x61, 0x73, 0x68, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0c, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x1e, 0x72, 0x65, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x65, 0x64, 0x55, 0x73,
	0x65, 0x72, 0x43, 0x72, 0x65, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x73, 0x48, 0x61, 0x73,
	0x68, 0x22, 0x9f, 0x05, 0x0a, 0x0a, 0x41, 0x73, 0x73, 0x65, 0x73, 0x73, 0x6d, 0x65, 0x6e, 0x74,
	0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x05, 0x65, 0x76, 0x65,
	0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x63, 0x61, 0x70, 0x74, 0x63, 0x68,
	0x61, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x45,
	0x76, 0x65, 0x6e, 0x74, 0x52, 0x05, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x12, 0x5b, 0x0a, 0x0d, 0x72,
	0x69, 0x73, 0x6b, 0x5f, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x72, 0x65, 0x63, 0x61, 0x70, 0x74, 0x63, 0x68, 0x61, 0x65, 0x6e, 0x74, 0x65, 0x72,
	0x70, 0x72, 0x69, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x69, 0x73, 0x6b, 0x41, 0x6e, 0x61,
	0x6c, 0x79, 0x73, 0x69, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0c, 0x72, 0x69, 0x73, 0x6b,
	0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x12, 0x64, 0x0a, 0x10, 0x74, 0x6f, 0x6b, 0x65,
	0x6e, 0x5f, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x72, 0x65, 0x63, 0x61, 0x70, 0x74, 0x63, 0x68, 0x61, 0x65, 0x6e, 0x74, 0x65, 0x72,
	0x70, 0x72, 0x69, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x50, 0x72,
	0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0f, 0x74,
	0x6f, 0x6b, 0x65, 0x6e, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x12, 0x7e,
	0x0a, 0x1b, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x5f, 0x64, 0x65, 0x66, 0x65, 0x6e, 0x64,
	0x65, 0x72, 0x5f, 0x61, 0x73, 0x73, 0x65, 0x73, 0x73, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x06, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x72, 0x65, 0x63, 0x61, 0x70, 0x74, 0x63, 0x68, 0x61, 0x65, 0x6e, 0x74, 0x65,
	0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e,
	0x74, 0x44, 0x65, 0x66, 0x65, 0x6e, 0x64, 0x65, 0x72, 0x41, 0x73, 0x73, 0x65, 0x73, 0x73, 0x6d,
	0x65, 0x6e, 0x74, 0x52, 0x19, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x44, 0x65, 0x66, 0x65,
	0x6e, 0x64, 0x65, 0x72, 0x41, 0x73, 0x73, 0x65, 0x73, 0x73, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x91,
	0x01, 0x0a, 0x22, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x5f, 0x70, 0x61, 0x73, 0x73, 0x77,
	0x6f, 0x72, 0x64, 0x5f, 0x6c, 0x65, 0x61, 0x6b, 0x5f, 0x76, 0x65, 0x72, 0x69, 0x66, 0x69, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x44, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x63, 0x61, 0x70,
	0x74, 0x63, 0x68, 0x61, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x2e, 0x76,
	0x31, 0x2e, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x50, 0x61, 0x73, 0x73, 0x77, 0x6f, 0x72,
	0x64, 0x4c, 0x65, 0x61, 0x6b, 0x56, 0x65, 0x72, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x1f, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x50, 0x61, 0x73, 0x73, 0x77, 0x6f,
	0x72, 0x64, 0x4c, 0x65, 0x61, 0x6b, 0x56, 0x65, 0x72, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x3a, 0x5f, 0xea, 0x41, 0x5c, 0x0a, 0x2d, 0x72, 0x65, 0x63, 0x61, 0x70, 0x74, 0x63,
	0x68, 0x61, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x73, 0x73, 0x65,
	0x73, 0x73, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x2b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x61, 0x73, 0x73, 0x65, 0x73,
	0x73, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x7b, 0x61, 0x73, 0x73, 0x65, 0x73, 0x73, 0x6d, 0x65,
	0x6e, 0x74, 0x7d, 0x22, 0xf2, 0x01, 0x0a, 0x05, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x12, 0x19, 0x0a,
	0x05, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x05, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x1e, 0x0a, 0x08, 0x73, 0x69, 0x74, 0x65,
	0x5f, 0x6b, 0x65, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x07, 0x73, 0x69, 0x74, 0x65, 0x4b, 0x65, 0x79, 0x12, 0x22, 0x0a, 0x0a, 0x75, 0x73, 0x65, 0x72,
	0x5f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x09, 0x75, 0x73, 0x65, 0x72, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x12, 0x2b, 0x0a, 0x0f,
	0x75, 0x73, 0x65, 0x72, 0x5f, 0x69, 0x70, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0d, 0x75, 0x73, 0x65, 0x72,
	0x49, 0x70, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x12, 0x2c, 0x0a, 0x0f, 0x65, 0x78, 0x70,
	0x65, 0x63, 0x74, 0x65, 0x64, 0x5f, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0e, 0x65, 0x78, 0x70, 0x65, 0x63, 0x74, 0x65,
	0x64, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x2f, 0x0a, 0x11, 0x68, 0x61, 0x73, 0x68, 0x65,
	0x64, 0x5f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x06, 0x20, 0x01,
	0x28, 0x0c, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0f, 0x68, 0x61, 0x73, 0x68, 0x65, 0x64, 0x41,
	0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x49, 0x64, 0x22, 0xc1, 0x02, 0x0a, 0x0c, 0x52, 0x69, 0x73,
	0x6b, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x12, 0x14, 0x0a, 0x05, 0x73, 0x63, 0x6f,
	0x72, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x02, 0x52, 0x05, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x12,
	0x60, 0x0a, 0x07, 0x72, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0e,
	0x32, 0x46, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x72, 0x65, 0x63, 0x61, 0x70, 0x74, 0x63, 0x68, 0x61, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72,
	0x69, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x69, 0x73, 0x6b, 0x41, 0x6e, 0x61, 0x6c, 0x79,
	0x73, 0x69, 0x73, 0x2e, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x52, 0x07, 0x72, 0x65, 0x61, 0x73, 0x6f, 0x6e,
	0x73, 0x22, 0xb8, 0x01, 0x0a, 0x14, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x69, 0x66, 0x69, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x12, 0x25, 0x0a, 0x21, 0x43, 0x4c,
	0x41, 0x53, 0x53, 0x49, 0x46, 0x49, 0x43, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x52, 0x45, 0x41,
	0x53, 0x4f, 0x4e, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10,
	0x00, 0x12, 0x0e, 0x0a, 0x0a, 0x41, 0x55, 0x54, 0x4f, 0x4d, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x10,
	0x01, 0x12, 0x1a, 0x0a, 0x16, 0x55, 0x4e, 0x45, 0x58, 0x50, 0x45, 0x43, 0x54, 0x45, 0x44, 0x5f,
	0x45, 0x4e, 0x56, 0x49, 0x52, 0x4f, 0x4e, 0x4d, 0x45, 0x4e, 0x54, 0x10, 0x02, 0x12, 0x14, 0x0a,
	0x10, 0x54, 0x4f, 0x4f, 0x5f, 0x4d, 0x55, 0x43, 0x48, 0x5f, 0x54, 0x52, 0x41, 0x46, 0x46, 0x49,
	0x43, 0x10, 0x03, 0x12, 0x1d, 0x0a, 0x19, 0x55, 0x4e, 0x45, 0x58, 0x50, 0x45, 0x43, 0x54, 0x45,
	0x44, 0x5f, 0x55, 0x53, 0x41, 0x47, 0x45, 0x5f, 0x50, 0x41, 0x54, 0x54, 0x45, 0x52, 0x4e, 0x53,
	0x10, 0x04, 0x12, 0x18, 0x0a, 0x14, 0x4c, 0x4f, 0x57, 0x5f, 0x43, 0x4f, 0x4e, 0x46, 0x49, 0x44,
	0x45, 0x4e, 0x43, 0x45, 0x5f, 0x53, 0x43, 0x4f, 0x52, 0x45, 0x10, 0x05, 0x22, 0x97, 0x03, 0x0a,
	0x0f, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73,
	0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52,
	0x05, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x12, 0x69, 0x0a, 0x0e, 0x69, 0x6e, 0x76, 0x61, 0x6c, 0x69,
	0x64, 0x5f, 0x72, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x42,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65,
	0x63, 0x61, 0x70, 0x74, 0x63, 0x68, 0x61, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73,
	0x65, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72,
	0x74, 0x69, 0x65, 0x73, 0x2e, 0x49, 0x6e, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x52, 0x65, 0x61, 0x73,
	0x6f, 0x6e, 0x52, 0x0d, 0x69, 0x6e, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x52, 0x65, 0x61, 0x73, 0x6f,
	0x6e, 0x12, 0x3b, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x1a,
	0x0a, 0x08, 0x68, 0x6f, 0x73, 0x74, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x08, 0x68, 0x6f, 0x73, 0x74, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x61, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x61, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x22, 0x91, 0x01, 0x0a, 0x0d, 0x49, 0x6e, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x52, 0x65,
	0x61, 0x73, 0x6f, 0x6e, 0x12, 0x1e, 0x0a, 0x1a, 0x49, 0x4e, 0x56, 0x41, 0x4c, 0x49, 0x44, 0x5f,
	0x52, 0x45, 0x41, 0x53, 0x4f, 0x4e, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49,
	0x45, 0x44, 0x10, 0x00, 0x12, 0x1a, 0x0a, 0x16, 0x55, 0x4e, 0x4b, 0x4e, 0x4f, 0x57, 0x4e, 0x5f,
	0x49, 0x4e, 0x56, 0x41, 0x4c, 0x49, 0x44, 0x5f, 0x52, 0x45, 0x41, 0x53, 0x4f, 0x4e, 0x10, 0x01,
	0x12, 0x0d, 0x0a, 0x09, 0x4d, 0x41, 0x4c, 0x46, 0x4f, 0x52, 0x4d, 0x45, 0x44, 0x10, 0x02, 0x12,
	0x0b, 0x0a, 0x07, 0x45, 0x58, 0x50, 0x49, 0x52, 0x45, 0x44, 0x10, 0x03, 0x12, 0x08, 0x0a, 0x04,
	0x44, 0x55, 0x50, 0x45, 0x10, 0x04, 0x12, 0x0b, 0x0a, 0x07, 0x4d, 0x49, 0x53, 0x53, 0x49, 0x4e,
	0x47, 0x10, 0x05, 0x12, 0x11, 0x0a, 0x0d, 0x42, 0x52, 0x4f, 0x57, 0x53, 0x45, 0x52, 0x5f, 0x45,
	0x52, 0x52, 0x4f, 0x52, 0x10, 0x06, 0x22, 0xbe, 0x02, 0x0a, 0x19, 0x41, 0x63, 0x63, 0x6f, 0x75,
	0x6e, 0x74, 0x44, 0x65, 0x66, 0x65, 0x6e, 0x64, 0x65, 0x72, 0x41, 0x73, 0x73, 0x65, 0x73, 0x73,
	0x6d, 0x65, 0x6e, 0x74, 0x12, 0x6b, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x01,
	0x20, 0x03, 0x28, 0x0e, 0x32, 0x53, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x63, 0x61, 0x70, 0x74, 0x63, 0x68, 0x61, 0x65, 0x6e, 0x74,
	0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x63, 0x63, 0x6f, 0x75,
	0x6e, 0x74, 0x44, 0x65, 0x66, 0x65, 0x6e, 0x64, 0x65, 0x72, 0x41, 0x73, 0x73, 0x65, 0x73, 0x73,
	0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x44, 0x65, 0x66, 0x65,
	0x6e, 0x64, 0x65, 0x72, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c,
	0x73, 0x22, 0xb3, 0x01, 0x0a, 0x14, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x44, 0x65, 0x66,
	0x65, 0x6e, 0x64, 0x65, 0x72, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x12, 0x26, 0x0a, 0x22, 0x41, 0x43,
	0x43, 0x4f, 0x55, 0x4e, 0x54, 0x5f, 0x44, 0x45, 0x46, 0x45, 0x4e, 0x44, 0x45, 0x52, 0x5f, 0x4c,
	0x41, 0x42, 0x45, 0x4c, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44,
	0x10, 0x00, 0x12, 0x11, 0x0a, 0x0d, 0x50, 0x52, 0x4f, 0x46, 0x49, 0x4c, 0x45, 0x5f, 0x4d, 0x41,
	0x54, 0x43, 0x48, 0x10, 0x01, 0x12, 0x1d, 0x0a, 0x19, 0x53, 0x55, 0x53, 0x50, 0x49, 0x43, 0x49,
	0x4f, 0x55, 0x53, 0x5f, 0x4c, 0x4f, 0x47, 0x49, 0x4e, 0x5f, 0x41, 0x43, 0x54, 0x49, 0x56, 0x49,
	0x54, 0x59, 0x10, 0x02, 0x12, 0x1f, 0x0a, 0x1b, 0x53, 0x55, 0x53, 0x50, 0x49, 0x43, 0x49, 0x4f,
	0x55, 0x53, 0x5f, 0x41, 0x43, 0x43, 0x4f, 0x55, 0x4e, 0x54, 0x5f, 0x43, 0x52, 0x45, 0x41, 0x54,
	0x49, 0x4f, 0x4e, 0x10, 0x03, 0x12, 0x20, 0x0a, 0x1c, 0x52, 0x45, 0x4c, 0x41, 0x54, 0x45, 0x44,
	0x5f, 0x41, 0x43, 0x43, 0x4f, 0x55, 0x4e, 0x54, 0x53, 0x5f, 0x4e, 0x55, 0x4d, 0x42, 0x45, 0x52,
	0x5f, 0x48, 0x49, 0x47, 0x48, 0x10, 0x04, 0x22, 0xa0, 0x01, 0x0a, 0x10, 0x43, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x4b, 0x65, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4b, 0x0a, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x33, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x2d, 0x0a, 0x2b, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x72, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x3f, 0x0a, 0x03, 0x6b, 0x65, 0x79,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x63, 0x61, 0x70, 0x74, 0x63, 0x68, 0x61, 0x65,
	0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4b, 0x65, 0x79,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x22, 0xa4, 0x01, 0x0a, 0x0f, 0x4c,
	0x69, 0x73, 0x74, 0x4b, 0x65, 0x79, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4b,
	0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x33,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2d, 0x0a, 0x2b, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x72, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x20, 0x0a, 0x09, 0x70,
	0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a,
	0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65,
	0x6e, 0x22, 0x78, 0x0a, 0x10, 0x4c, 0x69, 0x73, 0x74, 0x4b, 0x65, 0x79, 0x73, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x3c, 0x0a, 0x04, 0x6b, 0x65, 0x79, 0x73, 0x18, 0x01, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x72, 0x65, 0x63, 0x61, 0x70, 0x74, 0x63, 0x68, 0x61, 0x65, 0x6e, 0x74, 0x65,
	0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4b, 0x65, 0x79, 0x52, 0x04, 0x6b,
	0x65, 0x79, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65,
	0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65,
	0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x62, 0x0a, 0x1e, 0x52,
	0x65, 0x74, 0x72, 0x69, 0x65, 0x76, 0x65, 0x4c, 0x65, 0x67, 0x61, 0x63, 0x79, 0x53, 0x65, 0x63,
	0x72, 0x65, 0x74, 0x4b, 0x65, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x40, 0x0a,
	0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2e, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x28, 0x0a, 0x26, 0x72, 0x65, 0x63, 0x61, 0x70, 0x74, 0x63, 0x68, 0x61, 0x65, 0x6e, 0x74,
	0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4b, 0x65, 0x79, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x22,
	0x53, 0x0a, 0x0d, 0x47, 0x65, 0x74, 0x4b, 0x65, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x42, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2e,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x28, 0x0a, 0x26, 0x72, 0x65, 0x63, 0x61, 0x70, 0x74, 0x63, 0x68,
	0x61, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4b, 0x65, 0x79, 0x52, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x22, 0x95, 0x01, 0x0a, 0x10, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4b,
	0x65, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3f, 0x0a, 0x03, 0x6b, 0x65, 0x79,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x63, 0x61, 0x70, 0x74, 0x63, 0x68, 0x61, 0x65,
	0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4b, 0x65, 0x79,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0x56, 0x0a, 0x10,
	0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x4b, 0x65, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x42, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2e,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x28, 0x0a, 0x26, 0x72, 0x65, 0x63, 0x61, 0x70, 0x74, 0x63, 0x68,
	0x61, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4b, 0x65, 0x79, 0x52, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x22, 0x57, 0x0a, 0x11, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x65, 0x4b,
	0x65, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x42, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2e, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x28, 0x0a,
	0x26, 0x72, 0x65, 0x63, 0x61, 0x70, 0x74, 0x63, 0x68, 0x61, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70,
	0x72, 0x69, 0x73, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x4b, 0x65, 0x79, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x5b, 0x0a,
	0x11, 0x47, 0x65, 0x74, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x46, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x32, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2c, 0x0a, 0x2a, 0x72, 0x65, 0x63, 0x61, 0x70, 0x74,
	0x63, 0x68, 0x61, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4d, 0x65, 0x74,
	0x72, 0x69, 0x63, 0x73, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xf1, 0x02, 0x0a, 0x07, 0x4d,
	0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12,
	0x39, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52,
	0x09, 0x73, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x56, 0x0a, 0x0d, 0x73, 0x63,
	0x6f, 0x72, 0x65, 0x5f, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x72, 0x65, 0x63, 0x61, 0x70, 0x74, 0x63, 0x68, 0x61, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70,
	0x72, 0x69, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x63, 0x6f, 0x72, 0x65, 0x4d, 0x65, 0x74,
	0x72, 0x69, 0x63, 0x73, 0x52, 0x0c, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x4d, 0x65, 0x74, 0x72, 0x69,
	0x63, 0x73, 0x12, 0x62, 0x0a, 0x11, 0x63, 0x68, 0x61, 0x6c, 0x6c, 0x65, 0x6e, 0x67, 0x65, 0x5f,
	0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x35, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x63,
	0x61, 0x70, 0x74, 0x63, 0x68, 0x61, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65,
	0x2e, 0x76, 0x31, 0x2e, 0x43, 0x68, 0x61, 0x6c, 0x6c, 0x65, 0x6e, 0x67, 0x65, 0x4d, 0x65, 0x74,
	0x72, 0x69, 0x63, 0x73, 0x52, 0x10, 0x63, 0x68, 0x61, 0x6c, 0x6c, 0x65, 0x6e, 0x67, 0x65, 0x4d,
	0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x3a, 0x56, 0xea, 0x41, 0x53, 0x0a, 0x2a, 0x72, 0x65, 0x63,
	0x61, 0x70, 0x74, 0x63, 0x68, 0x61, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x12, 0x25, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6b, 0x65, 0x79, 0x73,
	0x2f, 0x7b, 0x6b, 0x65, 0x79, 0x7d, 0x2f, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x22, 0x4d,
	0x0a, 0x1f, 0x52, 0x65, 0x74, 0x72, 0x69, 0x65, 0x76, 0x65, 0x4c, 0x65, 0x67, 0x61, 0x63, 0x79,
	0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x4b, 0x65, 0x79, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x12, 0x2a, 0x0a, 0x11, 0x6c, 0x65, 0x67, 0x61, 0x63, 0x79, 0x5f, 0x73, 0x65, 0x63, 0x72,
	0x65, 0x74, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0f, 0x6c, 0x65,
	0x67, 0x61, 0x63, 0x79, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x4b, 0x65, 0x79, 0x22, 0xb0, 0x06,
	0x0a, 0x03, 0x4b, 0x65, 0x79, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x21, 0x0a, 0x0c, 0x64, 0x69, 0x73,
	0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x58, 0x0a, 0x0c,
	0x77, 0x65, 0x62, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x72, 0x65, 0x63, 0x61, 0x70, 0x74, 0x63, 0x68, 0x61, 0x65, 0x6e, 0x74, 0x65, 0x72,
	0x70, 0x72, 0x69, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x57, 0x65, 0x62, 0x4b, 0x65, 0x79, 0x53,
	0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x48, 0x00, 0x52, 0x0b, 0x77, 0x65, 0x62, 0x53, 0x65,
	0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x64, 0x0a, 0x10, 0x61, 0x6e, 0x64, 0x72, 0x6f, 0x69,
	0x64, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x72, 0x65, 0x63, 0x61, 0x70, 0x74, 0x63, 0x68, 0x61, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72,
	0x69, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x6e, 0x64, 0x72, 0x6f, 0x69, 0x64, 0x4b, 0x65,
	0x79, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x48, 0x00, 0x52, 0x0f, 0x61, 0x6e, 0x64,
	0x72, 0x6f, 0x69, 0x64, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x58, 0x0a, 0x0c,
	0x69, 0x6f, 0x73, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x72, 0x65, 0x63, 0x61, 0x70, 0x74, 0x63, 0x68, 0x61, 0x65, 0x6e, 0x74, 0x65, 0x72,
	0x70, 0x72, 0x69, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x4f, 0x53, 0x4b, 0x65, 0x79, 0x53,
	0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x48, 0x00, 0x52, 0x0b, 0x69, 0x6f, 0x73, 0x53, 0x65,
	0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x4c, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73,
	0x18, 0x06, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x63, 0x61, 0x70, 0x74, 0x63, 0x68, 0x61, 0x65,
	0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4b, 0x65, 0x79,
	0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x06, 0x6c, 0x61,
	0x62, 0x65, 0x6c, 0x73, 0x12, 0x3b, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74,
	0x69, 0x6d, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d,
	0x65, 0x12, 0x5c, 0x0a, 0x0f, 0x74, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x5f, 0x6f, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x63, 0x61, 0x70, 0x74,
	0x63, 0x68, 0x61, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x2e, 0x76, 0x31,
	0x2e, 0x54, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52,
	0x0e, 0x74, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12,
	0x53, 0x0a, 0x0c, 0x77, 0x61, 0x66, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x18,
	0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x63, 0x61, 0x70, 0x74, 0x63, 0x68, 0x61, 0x65, 0x6e,
	0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x57, 0x61, 0x66, 0x53,
	0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x0b, 0x77, 0x61, 0x66, 0x53, 0x65, 0x74, 0x74,
	0x69, 0x6e, 0x67, 0x73, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x3a,
	0x4a, 0xea, 0x41, 0x47, 0x0a, 0x26, 0x72, 0x65, 0x63, 0x61, 0x70, 0x74, 0x63, 0x68, 0x61, 0x65,
	0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4b, 0x65, 0x79, 0x12, 0x1d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d,
	0x2f, 0x6b, 0x65, 0x79, 0x73, 0x2f, 0x7b, 0x6b, 0x65, 0x79, 0x7d, 0x42, 0x13, 0x0a, 0x11, 0x70,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73,
	0x22, 0x88, 0x02, 0x0a, 0x0e, 0x54, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x4f, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x12, 0x23, 0x0a, 0x0d, 0x74, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x5f, 0x73,
	0x63, 0x6f, 0x72, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x02, 0x52, 0x0c, 0x74, 0x65, 0x73, 0x74,
	0x69, 0x6e, 0x67, 0x53, 0x63, 0x6f, 0x72, 0x65, 0x12, 0x71, 0x0a, 0x11, 0x74, 0x65, 0x73, 0x74,
	0x69, 0x6e, 0x67, 0x5f, 0x63, 0x68, 0x61, 0x6c, 0x6c, 0x65, 0x6e, 0x67, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x44, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x72, 0x65, 0x63, 0x61, 0x70, 0x74, 0x63, 0x68, 0x61, 0x65, 0x6e, 0x74, 0x65,
	0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x65, 0x73, 0x74, 0x69, 0x6e,
	0x67, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x54, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x67,
	0x43, 0x68, 0x61, 0x6c, 0x6c, 0x65, 0x6e, 0x67, 0x65, 0x52, 0x10, 0x74, 0x65, 0x73, 0x74, 0x69,
	0x6e, 0x67, 0x43, 0x68, 0x61, 0x6c, 0x6c, 0x65, 0x6e, 0x67, 0x65, 0x22, 0x5e, 0x0a, 0x10, 0x54,
	0x65, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x43, 0x68, 0x61, 0x6c, 0x6c, 0x65, 0x6e, 0x67, 0x65, 0x12,
	0x21, 0x0a, 0x1d, 0x54, 0x45, 0x53, 0x54, 0x49, 0x4e, 0x47, 0x5f, 0x43, 0x48, 0x41, 0x4c, 0x4c,
	0x45, 0x4e, 0x47, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44,
	0x10, 0x00, 0x12, 0x0d, 0x0a, 0x09, 0x4e, 0x4f, 0x43, 0x41, 0x50, 0x54, 0x43, 0x48, 0x41, 0x10,
	0x01, 0x12, 0x18, 0x0a, 0x14, 0x55, 0x4e, 0x53, 0x4f, 0x4c, 0x56, 0x41, 0x42, 0x4c, 0x45, 0x5f,
	0x43, 0x48, 0x41, 0x4c, 0x4c, 0x45, 0x4e, 0x47, 0x45, 0x10, 0x02, 0x22, 0xf1, 0x04, 0x0a, 0x0e,
	0x57, 0x65, 0x62, 0x4b, 0x65, 0x79, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x2a,
	0x0a, 0x11, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x5f, 0x61, 0x6c, 0x6c, 0x5f, 0x64, 0x6f, 0x6d, 0x61,
	0x69, 0x6e, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0f, 0x61, 0x6c, 0x6c, 0x6f, 0x77,
	0x41, 0x6c, 0x6c, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x73, 0x12, 0x27, 0x0a, 0x0f, 0x61, 0x6c,
	0x6c, 0x6f, 0x77, 0x65, 0x64, 0x5f, 0x64, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x73, 0x18, 0x01, 0x20,
	0x03, 0x28, 0x09, 0x52, 0x0e, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x65, 0x64, 0x44, 0x6f, 0x6d, 0x61,
	0x69, 0x6e, 0x73, 0x12, 0x2a, 0x0a, 0x11, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x5f, 0x61, 0x6d, 0x70,
	0x5f, 0x74, 0x72, 0x61, 0x66, 0x66, 0x69, 0x63, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0f,
	0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x41, 0x6d, 0x70, 0x54, 0x72, 0x61, 0x66, 0x66, 0x69, 0x63, 0x12,
	0x73, 0x0a, 0x10, 0x69, 0x6e, 0x74, 0x65, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74,
	0x79, 0x70, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x43, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x63, 0x61, 0x70, 0x74, 0x63,
	0x68, 0x61, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e,
	0x57, 0x65, 0x62, 0x4b, 0x65, 0x79, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x49,
	0x6e, 0x74, 0x65, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x0f, 0x69, 0x6e, 0x74, 0x65, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x54, 0x79, 0x70, 0x65, 0x12, 0x93, 0x01, 0x0a, 0x1d, 0x63, 0x68, 0x61, 0x6c, 0x6c, 0x65, 0x6e,
	0x67, 0x65, 0x5f, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x5f, 0x70, 0x72, 0x65, 0x66,
	0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x4f, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x63, 0x61,
	0x70, 0x74, 0x63, 0x68, 0x61, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x2e,
	0x76, 0x31, 0x2e, 0x57, 0x65, 0x62, 0x4b, 0x65, 0x79, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67,
	0x73, 0x2e, 0x43, 0x68, 0x61, 0x6c, 0x6c, 0x65, 0x6e, 0x67, 0x65, 0x53, 0x65, 0x63, 0x75, 0x72,
	0x69, 0x74, 0x79, 0x50, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x52, 0x1b, 0x63,
	0x68, 0x61, 0x6c, 0x6c, 0x65, 0x6e, 0x67, 0x65, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79,
	0x50, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x22, 0x5b, 0x0a, 0x0f, 0x49, 0x6e,
	0x74, 0x65, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x12, 0x20, 0x0a,
	0x1c, 0x49, 0x4e, 0x54, 0x45, 0x47, 0x52, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x54, 0x59, 0x50,
	0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12,
	0x09, 0x0a, 0x05, 0x53, 0x43, 0x4f, 0x52, 0x45, 0x10, 0x01, 0x12, 0x0c, 0x0a, 0x08, 0x43, 0x48,
	0x45, 0x43, 0x4b, 0x42, 0x4f, 0x58, 0x10, 0x02, 0x12, 0x0d, 0x0a, 0x09, 0x49, 0x4e, 0x56, 0x49,
	0x53, 0x49, 0x42, 0x4c, 0x45, 0x10, 0x03, 0x22, 0x76, 0x0a, 0x1b, 0x43, 0x68, 0x61, 0x6c, 0x6c,
	0x65, 0x6e, 0x67, 0x65, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x50, 0x72, 0x65, 0x66,
	0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x12, 0x2d, 0x0a, 0x29, 0x43, 0x48, 0x41, 0x4c, 0x4c, 0x45,
	0x4e, 0x47, 0x45, 0x5f, 0x53, 0x45, 0x43, 0x55, 0x52, 0x49, 0x54, 0x59, 0x5f, 0x50, 0x52, 0x45,
	0x46, 0x45, 0x52, 0x45, 0x4e, 0x43, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46,
	0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0d, 0x0a, 0x09, 0x55, 0x53, 0x41, 0x42, 0x49, 0x4c, 0x49,
	0x54, 0x59, 0x10, 0x01, 0x12, 0x0b, 0x0a, 0x07, 0x42, 0x41, 0x4c, 0x41, 0x4e, 0x43, 0x45, 0x10,
	0x02, 0x12, 0x0c, 0x0a, 0x08, 0x53, 0x45, 0x43, 0x55, 0x52, 0x49, 0x54, 0x59, 0x10, 0x03, 0x22,
	0x7f, 0x0a, 0x12, 0x41, 0x6e, 0x64, 0x72, 0x6f, 0x69, 0x64, 0x4b, 0x65, 0x79, 0x53, 0x65, 0x74,
	0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x35, 0x0a, 0x17, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x5f, 0x61,
	0x6c, 0x6c, 0x5f, 0x70, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x73,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x14, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x41, 0x6c, 0x6c,
	0x50, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x73, 0x12, 0x32, 0x0a, 0x15,
	0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x65, 0x64, 0x5f, 0x70, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x5f,
	0x6e, 0x61, 0x6d, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x52, 0x13, 0x61, 0x6c, 0x6c,
	0x6f, 0x77, 0x65, 0x64, 0x50, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x73,
	0x22, 0x6f, 0x0a, 0x0e, 0x49, 0x4f, 0x53, 0x4b, 0x65, 0x79, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e,
	0x67, 0x73, 0x12, 0x2f, 0x0a, 0x14, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x5f, 0x61, 0x6c, 0x6c, 0x5f,
	0x62, 0x75, 0x6e, 0x64, 0x6c, 0x65, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08,
	0x52, 0x11, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x41, 0x6c, 0x6c, 0x42, 0x75, 0x6e, 0x64, 0x6c, 0x65,
	0x49, 0x64, 0x73, 0x12, 0x2c, 0x0a, 0x12, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x65, 0x64, 0x5f, 0x62,
	0x75, 0x6e, 0x64, 0x6c, 0x65, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x52,
	0x10, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x65, 0x64, 0x42, 0x75, 0x6e, 0x64, 0x6c, 0x65, 0x49, 0x64,
	0x73, 0x22, 0xc3, 0x01, 0x0a, 0x11, 0x53, 0x63, 0x6f, 0x72, 0x65, 0x44, 0x69, 0x73, 0x74, 0x72,
	0x69, 0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x6d, 0x0a, 0x0d, 0x73, 0x63, 0x6f, 0x72, 0x65,
	0x5f, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x48,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65,
	0x63, 0x61, 0x70, 0x74, 0x63, 0x68, 0x61, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73,
	0x65, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x63, 0x6f, 0x72, 0x65, 0x44, 0x69, 0x73, 0x74, 0x72, 0x69,
	0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x53, 0x63, 0x6f, 0x72, 0x65, 0x42, 0x75, 0x63, 0x6b,
	0x65, 0x74, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x0c, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x42,
	0x75, 0x63, 0x6b, 0x65, 0x74, 0x73, 0x1a, 0x3f, 0x0a, 0x11, 0x53, 0x63, 0x6f, 0x72, 0x65, 0x42,
	0x75, 0x63, 0x6b, 0x65, 0x74, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b,
	0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a,
	0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x05, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0xd6, 0x02, 0x0a, 0x0c, 0x53, 0x63, 0x6f, 0x72,
	0x65, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x12, 0x5f, 0x0a, 0x0f, 0x6f, 0x76, 0x65, 0x72,
	0x61, 0x6c, 0x6c, 0x5f, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x72, 0x65, 0x63, 0x61, 0x70, 0x74, 0x63, 0x68, 0x61, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70,
	0x72, 0x69, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x63, 0x6f, 0x72, 0x65, 0x44, 0x69, 0x73,
	0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0e, 0x6f, 0x76, 0x65, 0x72, 0x61,
	0x6c, 0x6c, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x12, 0x6b, 0x0a, 0x0e, 0x61, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x44, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x72, 0x65, 0x63, 0x61, 0x70, 0x74, 0x63, 0x68, 0x61, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70,
	0x72, 0x69, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x63, 0x6f, 0x72, 0x65, 0x4d, 0x65, 0x74,
	0x72, 0x69, 0x63, 0x73, 0x2e, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x72, 0x69,
	0x63, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x0d, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x4d,
	0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x1a, 0x78, 0x0a, 0x12, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03,
	0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x4c,
	0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x63,
	0x61, 0x70, 0x74, 0x63, 0x68, 0x61, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65,
	0x2e, 0x76, 0x31, 0x2e, 0x53, 0x63, 0x6f, 0x72, 0x65, 0x44, 0x69, 0x73, 0x74, 0x72, 0x69, 0x62,
	0x75, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01,
	0x22, 0xa8, 0x01, 0x0a, 0x10, 0x43, 0x68, 0x61, 0x6c, 0x6c, 0x65, 0x6e, 0x67, 0x65, 0x4d, 0x65,
	0x74, 0x72, 0x69, 0x63, 0x73, 0x12, 0x25, 0x0a, 0x0e, 0x70, 0x61, 0x67, 0x65, 0x6c, 0x6f, 0x61,
	0x64, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0d, 0x70,
	0x61, 0x67, 0x65, 0x6c, 0x6f, 0x61, 0x64, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x27, 0x0a, 0x0f,
	0x6e, 0x6f, 0x63, 0x61, 0x70, 0x74, 0x63, 0x68, 0x61, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0e, 0x6e, 0x6f, 0x63, 0x61, 0x70, 0x74, 0x63, 0x68, 0x61,
	0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x21, 0x0a, 0x0c, 0x66, 0x61, 0x69, 0x6c, 0x65, 0x64, 0x5f,
	0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0b, 0x66, 0x61, 0x69,
	0x6c, 0x65, 0x64, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x21, 0x0a, 0x0c, 0x70, 0x61, 0x73, 0x73,
	0x65, 0x64, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0b,
	0x70, 0x61, 0x73, 0x73, 0x65, 0x64, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x22, 0xd3, 0x01, 0x0a, 0x29,
	0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x6c, 0x61, 0x74, 0x65, 0x64, 0x41, 0x63, 0x63, 0x6f, 0x75,
	0x6e, 0x74, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x68, 0x69,
	0x70, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x60, 0x0a, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x48, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x42, 0x12, 0x40, 0x72, 0x65, 0x63, 0x61, 0x70, 0x74, 0x63, 0x68, 0x61, 0x65, 0x6e, 0x74, 0x65,
	0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x65, 0x6c, 0x61, 0x74, 0x65, 0x64, 0x41, 0x63, 0x63,
	0x6f, 0x75, 0x6e, 0x74, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73,
	0x68, 0x69, 0x70, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x20, 0x0a, 0x09, 0x70,
	0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a,
	0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65,
	0x6e, 0x22, 0xe4, 0x01, 0x0a, 0x2a, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x6c, 0x61, 0x74, 0x65,
	0x64, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x4d, 0x65, 0x6d,
	0x62, 0x65, 0x72, 0x73, 0x68, 0x69, 0x70, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x12, 0x8d, 0x01, 0x0a, 0x21, 0x72, 0x65, 0x6c, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x61, 0x63, 0x63,
	0x6f, 0x75, 0x6e, 0x74, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f, 0x6d, 0x65, 0x6d, 0x62, 0x65,
	0x72, 0x73, 0x68, 0x69, 0x70, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x42, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x63, 0x61,
	0x70, 0x74, 0x63, 0x68, 0x61, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x2e,
	0x76, 0x31, 0x2e, 0x52, 0x65, 0x6c, 0x61, 0x74, 0x65, 0x64, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e,
	0x74, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x68, 0x69, 0x70,
	0x52, 0x1e, 0x72, 0x65, 0x6c, 0x61, 0x74, 0x65, 0x64, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74,
	0x47, 0x72, 0x6f, 0x75, 0x70, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x68, 0x69, 0x70, 0x73,
	0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f,
	0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50,
	0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xbf, 0x01, 0x0a, 0x1f, 0x4c, 0x69, 0x73,
	0x74, 0x52, 0x65, 0x6c, 0x61, 0x74, 0x65, 0x64, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x47,
	0x72, 0x6f, 0x75, 0x70, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x56, 0x0a, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x3e, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x38, 0x12, 0x36, 0x72, 0x65, 0x63, 0x61, 0x70, 0x74, 0x63, 0x68, 0x61, 0x65,
	0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x65, 0x6c, 0x61, 0x74, 0x65, 0x64,
	0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x52, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x70, 0x61,
	0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74,
	0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xba, 0x01, 0x0a, 0x20, 0x4c,
	0x69, 0x73, 0x74, 0x52, 0x65, 0x6c, 0x61, 0x74, 0x65, 0x64, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e,
	0x74, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12,
	0x6e, 0x0a, 0x16, 0x72, 0x65, 0x6c, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x61, 0x63, 0x63, 0x6f, 0x75,
	0x6e, 0x74, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72,
	0x65, 0x63, 0x61, 0x70, 0x74, 0x63, 0x68, 0x61, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69,
	0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x6c, 0x61, 0x74, 0x65, 0x64, 0x41, 0x63, 0x63,
	0x6f, 0x75, 0x6e, 0x74, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x52, 0x14, 0x72, 0x65, 0x6c, 0x61, 0x74,
	0x65, 0x64, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x12,
	0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b,
	0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61,
	0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x88, 0x02, 0x0a, 0x2b, 0x53, 0x65, 0x61, 0x72,
	0x63, 0x68, 0x52, 0x65, 0x6c, 0x61, 0x74, 0x65, 0x64, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74,
	0x47, 0x72, 0x6f, 0x75, 0x70, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x68, 0x69, 0x70, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x62, 0x0a, 0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x48, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x42,
	0x12, 0x40, 0x72, 0x65, 0x63, 0x61, 0x70, 0x74, 0x63, 0x68, 0x61, 0x65, 0x6e, 0x74, 0x65, 0x72,
	0x70, 0x72, 0x69, 0x73, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x65, 0x6c, 0x61, 0x74, 0x65, 0x64, 0x41, 0x63, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x68,
	0x69, 0x70, 0x52, 0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x12, 0x2f, 0x0a, 0x11, 0x68,
	0x61, 0x73, 0x68, 0x65, 0x64, 0x5f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x5f, 0x69, 0x64,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0f, 0x68, 0x61, 0x73,
	0x68, 0x65, 0x64, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x49, 0x64, 0x12, 0x20, 0x0a, 0x09,
	0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x22,
	0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b,
	0x65, 0x6e, 0x22, 0xe6, 0x01, 0x0a, 0x2c, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x52, 0x65, 0x6c,
	0x61, 0x74, 0x65, 0x64, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x47, 0x72, 0x6f, 0x75, 0x70,
	0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x68, 0x69, 0x70, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x12, 0x8d, 0x01, 0x0a, 0x21, 0x72, 0x65, 0x6c, 0x61, 0x74, 0x65, 0x64, 0x5f,
	0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f, 0x6d, 0x65,
	0x6d, 0x62, 0x65, 0x72, 0x73, 0x68, 0x69, 0x70, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x42, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72,
	0x65, 0x63, 0x61, 0x70, 0x74, 0x63, 0x68, 0x61, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69,
	0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x6c, 0x61, 0x74, 0x65, 0x64, 0x41, 0x63, 0x63,
	0x6f, 0x75, 0x6e, 0x74, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73,
	0x68, 0x69, 0x70, 0x52, 0x1e, 0x72, 0x65, 0x6c, 0x61, 0x74, 0x65, 0x64, 0x41, 0x63, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x68,
	0x69, 0x70, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65,
	0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65,
	0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xca, 0x02, 0x0a, 0x1d,
	0x52, 0x65, 0x6c, 0x61, 0x74, 0x65, 0x64, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x47, 0x72,
	0x6f, 0x75, 0x70, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x68, 0x69, 0x70, 0x12, 0x5c, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x48, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x42, 0x0a, 0x40, 0x72, 0x65, 0x63, 0x61, 0x70, 0x74, 0x63, 0x68, 0x61, 0x65, 0x6e,
	0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x65, 0x6c, 0x61, 0x74, 0x65, 0x64, 0x41,
	0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x4d, 0x65, 0x6d, 0x62, 0x65,
	0x72, 0x73, 0x68, 0x69, 0x70, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x2a, 0x0a, 0x11, 0x68,
	0x61, 0x73, 0x68, 0x65, 0x64, 0x5f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x5f, 0x69, 0x64,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x0f, 0x68, 0x61, 0x73, 0x68, 0x65, 0x64, 0x41, 0x63,
	0x63, 0x6f, 0x75, 0x6e, 0x74, 0x49, 0x64, 0x3a, 0x9e, 0x01, 0xea, 0x41, 0x9a, 0x01, 0x0a, 0x40,
	0x72, 0x65, 0x63, 0x61, 0x70, 0x74, 0x63, 0x68, 0x61, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72,
	0x69, 0x73, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x52, 0x65, 0x6c, 0x61, 0x74, 0x65, 0x64, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e,
	0x74, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x68, 0x69, 0x70,
	0x12, 0x56, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x7d, 0x2f, 0x72, 0x65, 0x6c, 0x61, 0x74, 0x65, 0x64, 0x61, 0x63, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x2f, 0x7b, 0x72, 0x65, 0x6c, 0x61, 0x74,
	0x65, 0x64, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x7d, 0x2f,
	0x6d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x68, 0x69, 0x70, 0x73, 0x2f, 0x7b, 0x6d, 0x65, 0x6d,
	0x62, 0x65, 0x72, 0x73, 0x68, 0x69, 0x70, 0x7d, 0x22, 0xe5, 0x01, 0x0a, 0x13, 0x52, 0x65, 0x6c,
	0x61, 0x74, 0x65, 0x64, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x47, 0x72, 0x6f, 0x75, 0x70,
	0x12, 0x52, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x3e,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x38, 0x0a, 0x36, 0x72, 0x65, 0x63, 0x61, 0x70, 0x74, 0x63, 0x68,
	0x61, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x65, 0x6c, 0x61, 0x74,
	0x65, 0x64, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x52, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x3a, 0x7a, 0xea, 0x41, 0x77, 0x0a, 0x36, 0x72, 0x65, 0x63, 0x61, 0x70,
	0x74, 0x63, 0x68, 0x61, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x65,
	0x6c, 0x61, 0x74, 0x65, 0x64, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x47, 0x72, 0x6f, 0x75,
	0x70, 0x12, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x72, 0x65, 0x6c, 0x61, 0x74, 0x65, 0x64, 0x61, 0x63, 0x63,
	0x6f, 0x75, 0x6e, 0x74, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x2f, 0x7b, 0x72, 0x65, 0x6c, 0x61,
	0x74, 0x65, 0x64, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x7d,
	0x22, 0xea, 0x02, 0x0a, 0x0b, 0x57, 0x61, 0x66, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73,
	0x12, 0x61, 0x0a, 0x0b, 0x77, 0x61, 0x66, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x63, 0x61, 0x70, 0x74, 0x63, 0x68, 0x61, 0x65, 0x6e,
	0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x57, 0x61, 0x66, 0x53,
	0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x57, 0x61, 0x66, 0x53, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x77, 0x61, 0x66, 0x53, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x12, 0x61, 0x0a, 0x0b, 0x77, 0x61, 0x66, 0x5f, 0x66, 0x65, 0x61, 0x74, 0x75,
	0x72, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x63, 0x61, 0x70, 0x74, 0x63, 0x68,
	0x61, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x57,
	0x61, 0x66, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x57, 0x61, 0x66, 0x46, 0x65,
	0x61, 0x74, 0x75, 0x72, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x77, 0x61, 0x66, 0x46,
	0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x22, 0x62, 0x0a, 0x0a, 0x57, 0x61, 0x66, 0x46, 0x65, 0x61,
	0x74, 0x75, 0x72, 0x65, 0x12, 0x1b, 0x0a, 0x17, 0x57, 0x41, 0x46, 0x5f, 0x46, 0x45, 0x41, 0x54,
	0x55, 0x52, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10,
	0x00, 0x12, 0x12, 0x0a, 0x0e, 0x43, 0x48, 0x41, 0x4c, 0x4c, 0x45, 0x4e, 0x47, 0x45, 0x5f, 0x50,
	0x41, 0x47, 0x45, 0x10, 0x01, 0x12, 0x11, 0x0a, 0x0d, 0x53, 0x45, 0x53, 0x53, 0x49, 0x4f, 0x4e,
	0x5f, 0x54, 0x4f, 0x4b, 0x45, 0x4e, 0x10, 0x02, 0x12, 0x10, 0x0a, 0x0c, 0x41, 0x43, 0x54, 0x49,
	0x4f, 0x4e, 0x5f, 0x54, 0x4f, 0x4b, 0x45, 0x4e, 0x10, 0x03, 0x22, 0x31, 0x0a, 0x0a, 0x57, 0x61,
	0x66, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0x1b, 0x0a, 0x17, 0x57, 0x41, 0x46, 0x5f,
	0x53, 0x45, 0x52, 0x56, 0x49, 0x43, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46,
	0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x06, 0x0a, 0x02, 0x43, 0x41, 0x10, 0x01, 0x32, 0xfb, 0x14,
	0x0a, 0x1a, 0x52, 0x65, 0x63, 0x61, 0x70, 0x74, 0x63, 0x68, 0x61, 0x45, 0x6e, 0x74, 0x65, 0x72,
	0x70, 0x72, 0x69, 0x73, 0x65, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0xce, 0x01, 0x0a,
	0x10, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x41, 0x73, 0x73, 0x65, 0x73, 0x73, 0x6d, 0x65, 0x6e,
	0x74, 0x12, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x72, 0x65, 0x63, 0x61, 0x70, 0x74, 0x63, 0x68, 0x61, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70,
	0x72, 0x69, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x41, 0x73,
	0x73, 0x65, 0x73, 0x73, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72,
	0x65, 0x63, 0x61, 0x70, 0x74, 0x63, 0x68, 0x61, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69,
	0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x73, 0x73, 0x65, 0x73, 0x73, 0x6d, 0x65, 0x6e, 0x74,
	0x22, 0x4b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x31, 0x22, 0x23, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x7d, 0x2f, 0x61, 0x73, 0x73, 0x65, 0x73, 0x73, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x3a, 0x0a, 0x61,
	0x73, 0x73, 0x65, 0x73, 0x73, 0x6d, 0x65, 0x6e, 0x74, 0xda, 0x41, 0x11, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x2c, 0x61, 0x73, 0x73, 0x65, 0x73, 0x73, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0xe0, 0x01,
	0x0a, 0x12, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x65, 0x41, 0x73, 0x73, 0x65, 0x73, 0x73,
	0x6d, 0x65, 0x6e, 0x74, 0x12, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x63, 0x61, 0x70, 0x74, 0x63, 0x68, 0x61, 0x65, 0x6e, 0x74,
	0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x6e, 0x6e, 0x6f, 0x74,
	0x61, 0x74, 0x65, 0x41, 0x73, 0x73, 0x65, 0x73, 0x73, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x63, 0x61, 0x70, 0x74, 0x63, 0x68, 0x61, 0x65, 0x6e, 0x74,
	0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x6e, 0x6e, 0x6f, 0x74,
	0x61, 0x74, 0x65, 0x41, 0x73, 0x73, 0x65, 0x73, 0x73, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x49, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x31, 0x22, 0x2c, 0x2f,
	0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x73, 0x73, 0x65, 0x73, 0x73, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2f,
	0x2a, 0x7d, 0x3a, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x65, 0x3a, 0x01, 0x2a, 0xda, 0x41,
	0x0f, 0x6e, 0x61, 0x6d, 0x65, 0x2c, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x97, 0x01, 0x0a, 0x09, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4b, 0x65, 0x79, 0x12, 0x35,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65,
	0x63, 0x61, 0x70, 0x74, 0x63, 0x68, 0x61, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73,
	0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4b, 0x65, 0x79, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x63, 0x61, 0x70, 0x74, 0x63, 0x68, 0x61, 0x65, 0x6e,
	0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4b, 0x65, 0x79, 0x22,
	0x29, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x23, 0x22, 0x1c, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x7d,
	0x2f, 0x6b, 0x65, 0x79, 0x73, 0x3a, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x9d, 0x01, 0x0a, 0x08, 0x4c,
	0x69, 0x73, 0x74, 0x4b, 0x65, 0x79, 0x73, 0x12, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x63, 0x61, 0x70, 0x74, 0x63, 0x68, 0x61,
	0x65, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69,
	0x73, 0x74, 0x4b, 0x65, 0x79, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x35, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x63,
	0x61, 0x70, 0x74, 0x63, 0x68, 0x61, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65,
	0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x4b, 0x65, 0x79, 0x73, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x22, 0x24, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x1e, 0x12, 0x1c, 0x2f, 0x76,
	0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x6b, 0x65, 0x79, 0x73, 0x12, 0xe7, 0x01, 0x0a, 0x17, 0x52,
	0x65, 0x74, 0x72, 0x69, 0x65, 0x76, 0x65, 0x4c, 0x65, 0x67, 0x61, 0x63, 0x79, 0x53, 0x65, 0x63,
	0x72, 0x65, 0x74, 0x4b, 0x65, 0x79, 0x12, 0x43, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x63, 0x61, 0x70, 0x74, 0x63, 0x68, 0x61, 0x65,
	0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x74,
	0x72, 0x69, 0x65, 0x76, 0x65, 0x4c, 0x65, 0x67, 0x61, 0x63, 0x79, 0x53, 0x65, 0x63, 0x72, 0x65,
	0x74, 0x4b, 0x65, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x44, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x63, 0x61, 0x70,
	0x74, 0x63, 0x68, 0x61, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x2e, 0x76,
	0x31, 0x2e, 0x52, 0x65, 0x74, 0x72, 0x69, 0x65, 0x76, 0x65, 0x4c, 0x65, 0x67, 0x61, 0x63, 0x79,
	0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x4b, 0x65, 0x79, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x22, 0x41, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x35, 0x12, 0x33, 0x2f, 0x76, 0x31, 0x2f, 0x7b,
	0x6b, 0x65, 0x79, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6b,
	0x65, 0x79, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x72, 0x65, 0x74, 0x72, 0x69, 0x65, 0x76, 0x65, 0x4c,
	0x65, 0x67, 0x61, 0x63, 0x79, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x4b, 0x65, 0x79, 0xda, 0x41,
	0x03, 0x6b, 0x65, 0x79, 0x12, 0x8c, 0x01, 0x0a, 0x06, 0x47, 0x65, 0x74, 0x4b, 0x65, 0x79, 0x12,
	0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72,
	0x65, 0x63, 0x61, 0x70, 0x74, 0x63, 0x68, 0x61, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69,
	0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x4b, 0x65, 0x79, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x72, 0x65, 0x63, 0x61, 0x70, 0x74, 0x63, 0x68, 0x61, 0x65, 0x6e, 0x74, 0x65,
	0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4b, 0x65, 0x79, 0x22, 0x24, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x1e, 0x12, 0x1c, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65,
	0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6b, 0x65, 0x79, 0x73,
	0x2f, 0x2a, 0x7d, 0x12, 0x9b, 0x01, 0x0a, 0x09, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4b, 0x65,
	0x79, 0x12, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x72, 0x65, 0x63, 0x61, 0x70, 0x74, 0x63, 0x68, 0x61, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70,
	0x72, 0x69, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4b, 0x65,
	0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x63, 0x61, 0x70, 0x74, 0x63, 0x68,
	0x61, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4b,
	0x65, 0x79, 0x22, 0x2d, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x27, 0x32, 0x20, 0x2f, 0x76, 0x31, 0x2f,
	0x7b, 0x6b, 0x65, 0x79, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6b, 0x65, 0x79, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x03, 0x6b, 0x65,
	0x79, 0x12, 0x80, 0x01, 0x0a, 0x09, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x4b, 0x65, 0x79, 0x12,
	0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72,
	0x65, 0x63, 0x61, 0x70, 0x74, 0x63, 0x68, 0x61, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69,
	0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x4b, 0x65, 0x79, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x24,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x1e, 0x2a, 0x1c, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d,
	0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6b, 0x65, 0x79,
	0x73, 0x2f, 0x2a, 0x7d, 0x12, 0x9f, 0x01, 0x0a, 0x0a, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x65,
	0x4b, 0x65, 0x79, 0x12, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x72, 0x65, 0x63, 0x61, 0x70, 0x74, 0x63, 0x68, 0x61, 0x65, 0x6e, 0x74, 0x65,
	0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74,
	0x65, 0x4b, 0x65, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x28, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x63, 0x61, 0x70,
	0x74, 0x63, 0x68, 0x61, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x2e, 0x76,
	0x31, 0x2e, 0x4b, 0x65, 0x79, 0x22, 0x2f, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x29, 0x22, 0x24, 0x2f,
	0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x6b, 0x65, 0x79, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x6d, 0x69, 0x67, 0x72,
	0x61, 0x74, 0x65, 0x3a, 0x01, 0x2a, 0x12, 0xa7, 0x01, 0x0a, 0x0a, 0x47, 0x65, 0x74, 0x4d, 0x65,
	0x74, 0x72, 0x69, 0x63, 0x73, 0x12, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x63, 0x61, 0x70, 0x74, 0x63, 0x68, 0x61, 0x65, 0x6e,
	0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x4d,
	0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2c, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x63,
	0x61, 0x70, 0x74, 0x63, 0x68, 0x61, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65,
	0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x22, 0x33, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x26, 0x12, 0x24, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6b, 0x65, 0x79, 0x73, 0x2f, 0x2a,
	0x2f, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x12, 0xe6, 0x01, 0x0a, 0x18, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x6c, 0x61, 0x74, 0x65, 0x64,
	0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x12, 0x44, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x63,
	0x61, 0x70, 0x74, 0x63, 0x68, 0x61, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65,
	0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x6c, 0x61, 0x74, 0x65, 0x64, 0x41,
	0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x45, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x72, 0x65, 0x63, 0x61, 0x70, 0x74, 0x63, 0x68, 0x61, 0x65, 0x6e, 0x74, 0x65,
	0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65,
	0x6c, 0x61, 0x74, 0x65, 0x64, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x47, 0x72, 0x6f, 0x75,
	0x70, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x3d, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x2e, 0x12, 0x2c, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x72, 0x65, 0x6c, 0x61,
	0x74, 0x65, 0x64, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x73,
	0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x92, 0x02, 0x0a, 0x22, 0x4c, 0x69,
	0x73, 0x74, 0x52, 0x65, 0x6c, 0x61, 0x74, 0x65, 0x64, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74,
	0x47, 0x72, 0x6f, 0x75, 0x70, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x68, 0x69, 0x70, 0x73,
	0x12, 0x4e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x72, 0x65, 0x63, 0x61, 0x70, 0x74, 0x63, 0x68, 0x61, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72,
	0x69, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x6c, 0x61, 0x74,
	0x65, 0x64, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x4d, 0x65,
	0x6d, 0x62, 0x65, 0x72, 0x73, 0x68, 0x69, 0x70, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x4f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x72, 0x65, 0x63, 0x61, 0x70, 0x74, 0x63, 0x68, 0x61, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72,
	0x69, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x6c, 0x61, 0x74,
	0x65, 0x64, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x4d, 0x65,
	0x6d, 0x62, 0x65, 0x72, 0x73, 0x68, 0x69, 0x70, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x22, 0x4b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3c, 0x12, 0x3a, 0x2f, 0x76, 0x31, 0x2f, 0x7b,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x2a, 0x2f, 0x72, 0x65, 0x6c, 0x61, 0x74, 0x65, 0x64, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74,
	0x67, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x6d, 0x65, 0x6d, 0x62, 0x65, 0x72,
	0x73, 0x68, 0x69, 0x70, 0x73, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0xb2,
	0x02, 0x0a, 0x24, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x52, 0x65, 0x6c, 0x61, 0x74, 0x65, 0x64,
	0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x4d, 0x65, 0x6d, 0x62,
	0x65, 0x72, 0x73, 0x68, 0x69, 0x70, 0x73, 0x12, 0x50, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x63, 0x61, 0x70, 0x74, 0x63, 0x68, 0x61,
	0x65, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65,
	0x61, 0x72, 0x63, 0x68, 0x52, 0x65, 0x6c, 0x61, 0x74, 0x65, 0x64, 0x41, 0x63, 0x63, 0x6f, 0x75,
	0x6e, 0x74, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x68, 0x69,
	0x70, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x51, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x63, 0x61, 0x70, 0x74, 0x63,
	0x68, 0x61, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e,
	0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x52, 0x65, 0x6c, 0x61, 0x74, 0x65, 0x64, 0x41, 0x63, 0x63,
	0x6f, 0x75, 0x6e, 0x74, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73,
	0x68, 0x69, 0x70, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x65, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x43, 0x22, 0x3e, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x72,
	0x65, 0x6c, 0x61, 0x74, 0x65, 0x64, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x67, 0x72, 0x6f,
	0x75, 0x70, 0x6d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x68, 0x69, 0x70, 0x73, 0x3a, 0x73, 0x65,
	0x61, 0x72, 0x63, 0x68, 0x3a, 0x01, 0x2a, 0xda, 0x41, 0x19, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x2c, 0x68, 0x61, 0x73, 0x68, 0x65, 0x64, 0x5f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74,
	0x5f, 0x69, 0x64, 0x1a, 0x56, 0xca, 0x41, 0x22, 0x72, 0x65, 0x63, 0x61, 0x70, 0x74, 0x63, 0x68,
	0x61, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x2e, 0x68, 0x74, 0x74,
	0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x42, 0x93, 0x02, 0x0a, 0x21,
	0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x72, 0x65, 0x63, 0x61, 0x70,
	0x74, 0x63, 0x68, 0x61, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x2e, 0x76,
	0x31, 0x42, 0x18, 0x52, 0x65, 0x63, 0x61, 0x70, 0x74, 0x63, 0x68, 0x61, 0x45, 0x6e, 0x74, 0x65,
	0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x56, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67,
	0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x72, 0x65, 0x63, 0x61, 0x70,
	0x74, 0x63, 0x68, 0x61, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x2f, 0x76,
	0x31, 0x3b, 0x72, 0x65, 0x63, 0x61, 0x70, 0x74, 0x63, 0x68, 0x61, 0x65, 0x6e, 0x74, 0x65, 0x72,
	0x70, 0x72, 0x69, 0x73, 0x65, 0xa2, 0x02, 0x04, 0x47, 0x43, 0x52, 0x45, 0xaa, 0x02, 0x23, 0x47,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x52, 0x65, 0x63, 0x61,
	0x70, 0x74, 0x63, 0x68, 0x61, 0x45, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x2e,
	0x56, 0x31, 0xca, 0x02, 0x23, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75,
	0x64, 0x5c, 0x52, 0x65, 0x63, 0x61, 0x70, 0x74, 0x63, 0x68, 0x61, 0x45, 0x6e, 0x74, 0x65, 0x72,
	0x70, 0x72, 0x69, 0x73, 0x65, 0x5c, 0x56, 0x31, 0xea, 0x02, 0x26, 0x47, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x52, 0x65, 0x63, 0x61, 0x70, 0x74,
	0x63, 0x68, 0x61, 0x45, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x3a, 0x3a, 0x56,
	0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_rawDescOnce sync.Once
	file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_rawDescData = file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_rawDesc
)

func file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_rawDescGZIP() []byte {
	file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_rawDescOnce.Do(func() {
		file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_rawDescData)
	})
	return file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_rawDescData
}

var file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_enumTypes = make([]protoimpl.EnumInfo, 10)
var file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_msgTypes = make([]protoimpl.MessageInfo, 40)
var file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_goTypes = []interface{}{
	(AnnotateAssessmentRequest_Annotation)(0),            // 0: google.cloud.recaptchaenterprise.v1.AnnotateAssessmentRequest.Annotation
	(AnnotateAssessmentRequest_Reason)(0),                // 1: google.cloud.recaptchaenterprise.v1.AnnotateAssessmentRequest.Reason
	(RiskAnalysis_ClassificationReason)(0),               // 2: google.cloud.recaptchaenterprise.v1.RiskAnalysis.ClassificationReason
	(TokenProperties_InvalidReason)(0),                   // 3: google.cloud.recaptchaenterprise.v1.TokenProperties.InvalidReason
	(AccountDefenderAssessment_AccountDefenderLabel)(0),  // 4: google.cloud.recaptchaenterprise.v1.AccountDefenderAssessment.AccountDefenderLabel
	(TestingOptions_TestingChallenge)(0),                 // 5: google.cloud.recaptchaenterprise.v1.TestingOptions.TestingChallenge
	(WebKeySettings_IntegrationType)(0),                  // 6: google.cloud.recaptchaenterprise.v1.WebKeySettings.IntegrationType
	(WebKeySettings_ChallengeSecurityPreference)(0),      // 7: google.cloud.recaptchaenterprise.v1.WebKeySettings.ChallengeSecurityPreference
	(WafSettings_WafFeature)(0),                          // 8: google.cloud.recaptchaenterprise.v1.WafSettings.WafFeature
	(WafSettings_WafService)(0),                          // 9: google.cloud.recaptchaenterprise.v1.WafSettings.WafService
	(*CreateAssessmentRequest)(nil),                      // 10: google.cloud.recaptchaenterprise.v1.CreateAssessmentRequest
	(*AnnotateAssessmentRequest)(nil),                    // 11: google.cloud.recaptchaenterprise.v1.AnnotateAssessmentRequest
	(*AnnotateAssessmentResponse)(nil),                   // 12: google.cloud.recaptchaenterprise.v1.AnnotateAssessmentResponse
	(*PrivatePasswordLeakVerification)(nil),              // 13: google.cloud.recaptchaenterprise.v1.PrivatePasswordLeakVerification
	(*Assessment)(nil),                                   // 14: google.cloud.recaptchaenterprise.v1.Assessment
	(*Event)(nil),                                        // 15: google.cloud.recaptchaenterprise.v1.Event
	(*RiskAnalysis)(nil),                                 // 16: google.cloud.recaptchaenterprise.v1.RiskAnalysis
	(*TokenProperties)(nil),                              // 17: google.cloud.recaptchaenterprise.v1.TokenProperties
	(*AccountDefenderAssessment)(nil),                    // 18: google.cloud.recaptchaenterprise.v1.AccountDefenderAssessment
	(*CreateKeyRequest)(nil),                             // 19: google.cloud.recaptchaenterprise.v1.CreateKeyRequest
	(*ListKeysRequest)(nil),                              // 20: google.cloud.recaptchaenterprise.v1.ListKeysRequest
	(*ListKeysResponse)(nil),                             // 21: google.cloud.recaptchaenterprise.v1.ListKeysResponse
	(*RetrieveLegacySecretKeyRequest)(nil),               // 22: google.cloud.recaptchaenterprise.v1.RetrieveLegacySecretKeyRequest
	(*GetKeyRequest)(nil),                                // 23: google.cloud.recaptchaenterprise.v1.GetKeyRequest
	(*UpdateKeyRequest)(nil),                             // 24: google.cloud.recaptchaenterprise.v1.UpdateKeyRequest
	(*DeleteKeyRequest)(nil),                             // 25: google.cloud.recaptchaenterprise.v1.DeleteKeyRequest
	(*MigrateKeyRequest)(nil),                            // 26: google.cloud.recaptchaenterprise.v1.MigrateKeyRequest
	(*GetMetricsRequest)(nil),                            // 27: google.cloud.recaptchaenterprise.v1.GetMetricsRequest
	(*Metrics)(nil),                                      // 28: google.cloud.recaptchaenterprise.v1.Metrics
	(*RetrieveLegacySecretKeyResponse)(nil),              // 29: google.cloud.recaptchaenterprise.v1.RetrieveLegacySecretKeyResponse
	(*Key)(nil),                                          // 30: google.cloud.recaptchaenterprise.v1.Key
	(*TestingOptions)(nil),                               // 31: google.cloud.recaptchaenterprise.v1.TestingOptions
	(*WebKeySettings)(nil),                               // 32: google.cloud.recaptchaenterprise.v1.WebKeySettings
	(*AndroidKeySettings)(nil),                           // 33: google.cloud.recaptchaenterprise.v1.AndroidKeySettings
	(*IOSKeySettings)(nil),                               // 34: google.cloud.recaptchaenterprise.v1.IOSKeySettings
	(*ScoreDistribution)(nil),                            // 35: google.cloud.recaptchaenterprise.v1.ScoreDistribution
	(*ScoreMetrics)(nil),                                 // 36: google.cloud.recaptchaenterprise.v1.ScoreMetrics
	(*ChallengeMetrics)(nil),                             // 37: google.cloud.recaptchaenterprise.v1.ChallengeMetrics
	(*ListRelatedAccountGroupMembershipsRequest)(nil),    // 38: google.cloud.recaptchaenterprise.v1.ListRelatedAccountGroupMembershipsRequest
	(*ListRelatedAccountGroupMembershipsResponse)(nil),   // 39: google.cloud.recaptchaenterprise.v1.ListRelatedAccountGroupMembershipsResponse
	(*ListRelatedAccountGroupsRequest)(nil),              // 40: google.cloud.recaptchaenterprise.v1.ListRelatedAccountGroupsRequest
	(*ListRelatedAccountGroupsResponse)(nil),             // 41: google.cloud.recaptchaenterprise.v1.ListRelatedAccountGroupsResponse
	(*SearchRelatedAccountGroupMembershipsRequest)(nil),  // 42: google.cloud.recaptchaenterprise.v1.SearchRelatedAccountGroupMembershipsRequest
	(*SearchRelatedAccountGroupMembershipsResponse)(nil), // 43: google.cloud.recaptchaenterprise.v1.SearchRelatedAccountGroupMembershipsResponse
	(*RelatedAccountGroupMembership)(nil),                // 44: google.cloud.recaptchaenterprise.v1.RelatedAccountGroupMembership
	(*RelatedAccountGroup)(nil),                          // 45: google.cloud.recaptchaenterprise.v1.RelatedAccountGroup
	(*WafSettings)(nil),                                  // 46: google.cloud.recaptchaenterprise.v1.WafSettings
	nil,                                                  // 47: google.cloud.recaptchaenterprise.v1.Key.LabelsEntry
	nil,                                                  // 48: google.cloud.recaptchaenterprise.v1.ScoreDistribution.ScoreBucketsEntry
	nil,                                                  // 49: google.cloud.recaptchaenterprise.v1.ScoreMetrics.ActionMetricsEntry
	(*timestamppb.Timestamp)(nil),                        // 50: google.protobuf.Timestamp
	(*fieldmaskpb.FieldMask)(nil),                        // 51: google.protobuf.FieldMask
	(*emptypb.Empty)(nil),                                // 52: google.protobuf.Empty
}
var file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_depIdxs = []int32{
	14, // 0: google.cloud.recaptchaenterprise.v1.CreateAssessmentRequest.assessment:type_name -> google.cloud.recaptchaenterprise.v1.Assessment
	0,  // 1: google.cloud.recaptchaenterprise.v1.AnnotateAssessmentRequest.annotation:type_name -> google.cloud.recaptchaenterprise.v1.AnnotateAssessmentRequest.Annotation
	1,  // 2: google.cloud.recaptchaenterprise.v1.AnnotateAssessmentRequest.reasons:type_name -> google.cloud.recaptchaenterprise.v1.AnnotateAssessmentRequest.Reason
	15, // 3: google.cloud.recaptchaenterprise.v1.Assessment.event:type_name -> google.cloud.recaptchaenterprise.v1.Event
	16, // 4: google.cloud.recaptchaenterprise.v1.Assessment.risk_analysis:type_name -> google.cloud.recaptchaenterprise.v1.RiskAnalysis
	17, // 5: google.cloud.recaptchaenterprise.v1.Assessment.token_properties:type_name -> google.cloud.recaptchaenterprise.v1.TokenProperties
	18, // 6: google.cloud.recaptchaenterprise.v1.Assessment.account_defender_assessment:type_name -> google.cloud.recaptchaenterprise.v1.AccountDefenderAssessment
	13, // 7: google.cloud.recaptchaenterprise.v1.Assessment.private_password_leak_verification:type_name -> google.cloud.recaptchaenterprise.v1.PrivatePasswordLeakVerification
	2,  // 8: google.cloud.recaptchaenterprise.v1.RiskAnalysis.reasons:type_name -> google.cloud.recaptchaenterprise.v1.RiskAnalysis.ClassificationReason
	3,  // 9: google.cloud.recaptchaenterprise.v1.TokenProperties.invalid_reason:type_name -> google.cloud.recaptchaenterprise.v1.TokenProperties.InvalidReason
	50, // 10: google.cloud.recaptchaenterprise.v1.TokenProperties.create_time:type_name -> google.protobuf.Timestamp
	4,  // 11: google.cloud.recaptchaenterprise.v1.AccountDefenderAssessment.labels:type_name -> google.cloud.recaptchaenterprise.v1.AccountDefenderAssessment.AccountDefenderLabel
	30, // 12: google.cloud.recaptchaenterprise.v1.CreateKeyRequest.key:type_name -> google.cloud.recaptchaenterprise.v1.Key
	30, // 13: google.cloud.recaptchaenterprise.v1.ListKeysResponse.keys:type_name -> google.cloud.recaptchaenterprise.v1.Key
	30, // 14: google.cloud.recaptchaenterprise.v1.UpdateKeyRequest.key:type_name -> google.cloud.recaptchaenterprise.v1.Key
	51, // 15: google.cloud.recaptchaenterprise.v1.UpdateKeyRequest.update_mask:type_name -> google.protobuf.FieldMask
	50, // 16: google.cloud.recaptchaenterprise.v1.Metrics.start_time:type_name -> google.protobuf.Timestamp
	36, // 17: google.cloud.recaptchaenterprise.v1.Metrics.score_metrics:type_name -> google.cloud.recaptchaenterprise.v1.ScoreMetrics
	37, // 18: google.cloud.recaptchaenterprise.v1.Metrics.challenge_metrics:type_name -> google.cloud.recaptchaenterprise.v1.ChallengeMetrics
	32, // 19: google.cloud.recaptchaenterprise.v1.Key.web_settings:type_name -> google.cloud.recaptchaenterprise.v1.WebKeySettings
	33, // 20: google.cloud.recaptchaenterprise.v1.Key.android_settings:type_name -> google.cloud.recaptchaenterprise.v1.AndroidKeySettings
	34, // 21: google.cloud.recaptchaenterprise.v1.Key.ios_settings:type_name -> google.cloud.recaptchaenterprise.v1.IOSKeySettings
	47, // 22: google.cloud.recaptchaenterprise.v1.Key.labels:type_name -> google.cloud.recaptchaenterprise.v1.Key.LabelsEntry
	50, // 23: google.cloud.recaptchaenterprise.v1.Key.create_time:type_name -> google.protobuf.Timestamp
	31, // 24: google.cloud.recaptchaenterprise.v1.Key.testing_options:type_name -> google.cloud.recaptchaenterprise.v1.TestingOptions
	46, // 25: google.cloud.recaptchaenterprise.v1.Key.waf_settings:type_name -> google.cloud.recaptchaenterprise.v1.WafSettings
	5,  // 26: google.cloud.recaptchaenterprise.v1.TestingOptions.testing_challenge:type_name -> google.cloud.recaptchaenterprise.v1.TestingOptions.TestingChallenge
	6,  // 27: google.cloud.recaptchaenterprise.v1.WebKeySettings.integration_type:type_name -> google.cloud.recaptchaenterprise.v1.WebKeySettings.IntegrationType
	7,  // 28: google.cloud.recaptchaenterprise.v1.WebKeySettings.challenge_security_preference:type_name -> google.cloud.recaptchaenterprise.v1.WebKeySettings.ChallengeSecurityPreference
	48, // 29: google.cloud.recaptchaenterprise.v1.ScoreDistribution.score_buckets:type_name -> google.cloud.recaptchaenterprise.v1.ScoreDistribution.ScoreBucketsEntry
	35, // 30: google.cloud.recaptchaenterprise.v1.ScoreMetrics.overall_metrics:type_name -> google.cloud.recaptchaenterprise.v1.ScoreDistribution
	49, // 31: google.cloud.recaptchaenterprise.v1.ScoreMetrics.action_metrics:type_name -> google.cloud.recaptchaenterprise.v1.ScoreMetrics.ActionMetricsEntry
	44, // 32: google.cloud.recaptchaenterprise.v1.ListRelatedAccountGroupMembershipsResponse.related_account_group_memberships:type_name -> google.cloud.recaptchaenterprise.v1.RelatedAccountGroupMembership
	45, // 33: google.cloud.recaptchaenterprise.v1.ListRelatedAccountGroupsResponse.related_account_groups:type_name -> google.cloud.recaptchaenterprise.v1.RelatedAccountGroup
	44, // 34: google.cloud.recaptchaenterprise.v1.SearchRelatedAccountGroupMembershipsResponse.related_account_group_memberships:type_name -> google.cloud.recaptchaenterprise.v1.RelatedAccountGroupMembership
	9,  // 35: google.cloud.recaptchaenterprise.v1.WafSettings.waf_service:type_name -> google.cloud.recaptchaenterprise.v1.WafSettings.WafService
	8,  // 36: google.cloud.recaptchaenterprise.v1.WafSettings.waf_feature:type_name -> google.cloud.recaptchaenterprise.v1.WafSettings.WafFeature
	35, // 37: google.cloud.recaptchaenterprise.v1.ScoreMetrics.ActionMetricsEntry.value:type_name -> google.cloud.recaptchaenterprise.v1.ScoreDistribution
	10, // 38: google.cloud.recaptchaenterprise.v1.RecaptchaEnterpriseService.CreateAssessment:input_type -> google.cloud.recaptchaenterprise.v1.CreateAssessmentRequest
	11, // 39: google.cloud.recaptchaenterprise.v1.RecaptchaEnterpriseService.AnnotateAssessment:input_type -> google.cloud.recaptchaenterprise.v1.AnnotateAssessmentRequest
	19, // 40: google.cloud.recaptchaenterprise.v1.RecaptchaEnterpriseService.CreateKey:input_type -> google.cloud.recaptchaenterprise.v1.CreateKeyRequest
	20, // 41: google.cloud.recaptchaenterprise.v1.RecaptchaEnterpriseService.ListKeys:input_type -> google.cloud.recaptchaenterprise.v1.ListKeysRequest
	22, // 42: google.cloud.recaptchaenterprise.v1.RecaptchaEnterpriseService.RetrieveLegacySecretKey:input_type -> google.cloud.recaptchaenterprise.v1.RetrieveLegacySecretKeyRequest
	23, // 43: google.cloud.recaptchaenterprise.v1.RecaptchaEnterpriseService.GetKey:input_type -> google.cloud.recaptchaenterprise.v1.GetKeyRequest
	24, // 44: google.cloud.recaptchaenterprise.v1.RecaptchaEnterpriseService.UpdateKey:input_type -> google.cloud.recaptchaenterprise.v1.UpdateKeyRequest
	25, // 45: google.cloud.recaptchaenterprise.v1.RecaptchaEnterpriseService.DeleteKey:input_type -> google.cloud.recaptchaenterprise.v1.DeleteKeyRequest
	26, // 46: google.cloud.recaptchaenterprise.v1.RecaptchaEnterpriseService.MigrateKey:input_type -> google.cloud.recaptchaenterprise.v1.MigrateKeyRequest
	27, // 47: google.cloud.recaptchaenterprise.v1.RecaptchaEnterpriseService.GetMetrics:input_type -> google.cloud.recaptchaenterprise.v1.GetMetricsRequest
	40, // 48: google.cloud.recaptchaenterprise.v1.RecaptchaEnterpriseService.ListRelatedAccountGroups:input_type -> google.cloud.recaptchaenterprise.v1.ListRelatedAccountGroupsRequest
	38, // 49: google.cloud.recaptchaenterprise.v1.RecaptchaEnterpriseService.ListRelatedAccountGroupMemberships:input_type -> google.cloud.recaptchaenterprise.v1.ListRelatedAccountGroupMembershipsRequest
	42, // 50: google.cloud.recaptchaenterprise.v1.RecaptchaEnterpriseService.SearchRelatedAccountGroupMemberships:input_type -> google.cloud.recaptchaenterprise.v1.SearchRelatedAccountGroupMembershipsRequest
	14, // 51: google.cloud.recaptchaenterprise.v1.RecaptchaEnterpriseService.CreateAssessment:output_type -> google.cloud.recaptchaenterprise.v1.Assessment
	12, // 52: google.cloud.recaptchaenterprise.v1.RecaptchaEnterpriseService.AnnotateAssessment:output_type -> google.cloud.recaptchaenterprise.v1.AnnotateAssessmentResponse
	30, // 53: google.cloud.recaptchaenterprise.v1.RecaptchaEnterpriseService.CreateKey:output_type -> google.cloud.recaptchaenterprise.v1.Key
	21, // 54: google.cloud.recaptchaenterprise.v1.RecaptchaEnterpriseService.ListKeys:output_type -> google.cloud.recaptchaenterprise.v1.ListKeysResponse
	29, // 55: google.cloud.recaptchaenterprise.v1.RecaptchaEnterpriseService.RetrieveLegacySecretKey:output_type -> google.cloud.recaptchaenterprise.v1.RetrieveLegacySecretKeyResponse
	30, // 56: google.cloud.recaptchaenterprise.v1.RecaptchaEnterpriseService.GetKey:output_type -> google.cloud.recaptchaenterprise.v1.Key
	30, // 57: google.cloud.recaptchaenterprise.v1.RecaptchaEnterpriseService.UpdateKey:output_type -> google.cloud.recaptchaenterprise.v1.Key
	52, // 58: google.cloud.recaptchaenterprise.v1.RecaptchaEnterpriseService.DeleteKey:output_type -> google.protobuf.Empty
	30, // 59: google.cloud.recaptchaenterprise.v1.RecaptchaEnterpriseService.MigrateKey:output_type -> google.cloud.recaptchaenterprise.v1.Key
	28, // 60: google.cloud.recaptchaenterprise.v1.RecaptchaEnterpriseService.GetMetrics:output_type -> google.cloud.recaptchaenterprise.v1.Metrics
	41, // 61: google.cloud.recaptchaenterprise.v1.RecaptchaEnterpriseService.ListRelatedAccountGroups:output_type -> google.cloud.recaptchaenterprise.v1.ListRelatedAccountGroupsResponse
	39, // 62: google.cloud.recaptchaenterprise.v1.RecaptchaEnterpriseService.ListRelatedAccountGroupMemberships:output_type -> google.cloud.recaptchaenterprise.v1.ListRelatedAccountGroupMembershipsResponse
	43, // 63: google.cloud.recaptchaenterprise.v1.RecaptchaEnterpriseService.SearchRelatedAccountGroupMemberships:output_type -> google.cloud.recaptchaenterprise.v1.SearchRelatedAccountGroupMembershipsResponse
	51, // [51:64] is the sub-list for method output_type
	38, // [38:51] is the sub-list for method input_type
	38, // [38:38] is the sub-list for extension type_name
	38, // [38:38] is the sub-list for extension extendee
	0,  // [0:38] is the sub-list for field type_name
}

func init() { file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_init() }
func file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_init() {
	if File_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateAssessmentRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AnnotateAssessmentRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AnnotateAssessmentResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PrivatePasswordLeakVerification); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Assessment); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Event); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RiskAnalysis); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TokenProperties); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AccountDefenderAssessment); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateKeyRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListKeysRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListKeysResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RetrieveLegacySecretKeyRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetKeyRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateKeyRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteKeyRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MigrateKeyRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetMetricsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Metrics); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RetrieveLegacySecretKeyResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Key); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_msgTypes[21].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TestingOptions); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_msgTypes[22].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*WebKeySettings); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_msgTypes[23].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AndroidKeySettings); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_msgTypes[24].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*IOSKeySettings); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_msgTypes[25].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ScoreDistribution); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_msgTypes[26].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ScoreMetrics); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_msgTypes[27].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ChallengeMetrics); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_msgTypes[28].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListRelatedAccountGroupMembershipsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_msgTypes[29].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListRelatedAccountGroupMembershipsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_msgTypes[30].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListRelatedAccountGroupsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_msgTypes[31].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListRelatedAccountGroupsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_msgTypes[32].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SearchRelatedAccountGroupMembershipsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_msgTypes[33].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SearchRelatedAccountGroupMembershipsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_msgTypes[34].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RelatedAccountGroupMembership); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_msgTypes[35].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RelatedAccountGroup); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_msgTypes[36].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*WafSettings); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_msgTypes[20].OneofWrappers = []interface{}{
		(*Key_WebSettings)(nil),
		(*Key_AndroidSettings)(nil),
		(*Key_IosSettings)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_rawDesc,
			NumEnums:      10,
			NumMessages:   40,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_goTypes,
		DependencyIndexes: file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_depIdxs,
		EnumInfos:         file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_enumTypes,
		MessageInfos:      file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_msgTypes,
	}.Build()
	File_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto = out.File
	file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_rawDesc = nil
	file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_goTypes = nil
	file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// RecaptchaEnterpriseServiceClient is the client API for RecaptchaEnterpriseService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type RecaptchaEnterpriseServiceClient interface {
	// Creates an Assessment of the likelihood an event is legitimate.
	CreateAssessment(ctx context.Context, in *CreateAssessmentRequest, opts ...grpc.CallOption) (*Assessment, error)
	// Annotates a previously created Assessment to provide additional information
	// on whether the event turned out to be authentic or fraudulent.
	AnnotateAssessment(ctx context.Context, in *AnnotateAssessmentRequest, opts ...grpc.CallOption) (*AnnotateAssessmentResponse, error)
	// Creates a new reCAPTCHA Enterprise key.
	CreateKey(ctx context.Context, in *CreateKeyRequest, opts ...grpc.CallOption) (*Key, error)
	// Returns the list of all keys that belong to a project.
	ListKeys(ctx context.Context, in *ListKeysRequest, opts ...grpc.CallOption) (*ListKeysResponse, error)
	// Returns the secret key related to the specified public key.
	// You must use the legacy secret key only in a 3rd party integration with
	// legacy reCAPTCHA.
	RetrieveLegacySecretKey(ctx context.Context, in *RetrieveLegacySecretKeyRequest, opts ...grpc.CallOption) (*RetrieveLegacySecretKeyResponse, error)
	// Returns the specified key.
	GetKey(ctx context.Context, in *GetKeyRequest, opts ...grpc.CallOption) (*Key, error)
	// Updates the specified key.
	UpdateKey(ctx context.Context, in *UpdateKeyRequest, opts ...grpc.CallOption) (*Key, error)
	// Deletes the specified key.
	DeleteKey(ctx context.Context, in *DeleteKeyRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Migrates an existing key from reCAPTCHA to reCAPTCHA Enterprise.
	// Once a key is migrated, it can be used from either product. SiteVerify
	// requests are billed as CreateAssessment calls. You must be
	// authenticated as one of the current owners of the reCAPTCHA Site Key, and
	// your user must have the reCAPTCHA Enterprise Admin IAM role in the
	// destination project.
	MigrateKey(ctx context.Context, in *MigrateKeyRequest, opts ...grpc.CallOption) (*Key, error)
	// Get some aggregated metrics for a Key. This data can be used to build
	// dashboards.
	GetMetrics(ctx context.Context, in *GetMetricsRequest, opts ...grpc.CallOption) (*Metrics, error)
	// List groups of related accounts.
	ListRelatedAccountGroups(ctx context.Context, in *ListRelatedAccountGroupsRequest, opts ...grpc.CallOption) (*ListRelatedAccountGroupsResponse, error)
	// Get memberships in a group of related accounts.
	ListRelatedAccountGroupMemberships(ctx context.Context, in *ListRelatedAccountGroupMembershipsRequest, opts ...grpc.CallOption) (*ListRelatedAccountGroupMembershipsResponse, error)
	// Search group memberships related to a given account.
	SearchRelatedAccountGroupMemberships(ctx context.Context, in *SearchRelatedAccountGroupMembershipsRequest, opts ...grpc.CallOption) (*SearchRelatedAccountGroupMembershipsResponse, error)
}

type recaptchaEnterpriseServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewRecaptchaEnterpriseServiceClient(cc grpc.ClientConnInterface) RecaptchaEnterpriseServiceClient {
	return &recaptchaEnterpriseServiceClient{cc}
}

func (c *recaptchaEnterpriseServiceClient) CreateAssessment(ctx context.Context, in *CreateAssessmentRequest, opts ...grpc.CallOption) (*Assessment, error) {
	out := new(Assessment)
	err := c.cc.Invoke(ctx, "/google.cloud.recaptchaenterprise.v1.RecaptchaEnterpriseService/CreateAssessment", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *recaptchaEnterpriseServiceClient) AnnotateAssessment(ctx context.Context, in *AnnotateAssessmentRequest, opts ...grpc.CallOption) (*AnnotateAssessmentResponse, error) {
	out := new(AnnotateAssessmentResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.recaptchaenterprise.v1.RecaptchaEnterpriseService/AnnotateAssessment", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *recaptchaEnterpriseServiceClient) CreateKey(ctx context.Context, in *CreateKeyRequest, opts ...grpc.CallOption) (*Key, error) {
	out := new(Key)
	err := c.cc.Invoke(ctx, "/google.cloud.recaptchaenterprise.v1.RecaptchaEnterpriseService/CreateKey", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *recaptchaEnterpriseServiceClient) ListKeys(ctx context.Context, in *ListKeysRequest, opts ...grpc.CallOption) (*ListKeysResponse, error) {
	out := new(ListKeysResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.recaptchaenterprise.v1.RecaptchaEnterpriseService/ListKeys", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *recaptchaEnterpriseServiceClient) RetrieveLegacySecretKey(ctx context.Context, in *RetrieveLegacySecretKeyRequest, opts ...grpc.CallOption) (*RetrieveLegacySecretKeyResponse, error) {
	out := new(RetrieveLegacySecretKeyResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.recaptchaenterprise.v1.RecaptchaEnterpriseService/RetrieveLegacySecretKey", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *recaptchaEnterpriseServiceClient) GetKey(ctx context.Context, in *GetKeyRequest, opts ...grpc.CallOption) (*Key, error) {
	out := new(Key)
	err := c.cc.Invoke(ctx, "/google.cloud.recaptchaenterprise.v1.RecaptchaEnterpriseService/GetKey", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *recaptchaEnterpriseServiceClient) UpdateKey(ctx context.Context, in *UpdateKeyRequest, opts ...grpc.CallOption) (*Key, error) {
	out := new(Key)
	err := c.cc.Invoke(ctx, "/google.cloud.recaptchaenterprise.v1.RecaptchaEnterpriseService/UpdateKey", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *recaptchaEnterpriseServiceClient) DeleteKey(ctx context.Context, in *DeleteKeyRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.recaptchaenterprise.v1.RecaptchaEnterpriseService/DeleteKey", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *recaptchaEnterpriseServiceClient) MigrateKey(ctx context.Context, in *MigrateKeyRequest, opts ...grpc.CallOption) (*Key, error) {
	out := new(Key)
	err := c.cc.Invoke(ctx, "/google.cloud.recaptchaenterprise.v1.RecaptchaEnterpriseService/MigrateKey", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *recaptchaEnterpriseServiceClient) GetMetrics(ctx context.Context, in *GetMetricsRequest, opts ...grpc.CallOption) (*Metrics, error) {
	out := new(Metrics)
	err := c.cc.Invoke(ctx, "/google.cloud.recaptchaenterprise.v1.RecaptchaEnterpriseService/GetMetrics", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *recaptchaEnterpriseServiceClient) ListRelatedAccountGroups(ctx context.Context, in *ListRelatedAccountGroupsRequest, opts ...grpc.CallOption) (*ListRelatedAccountGroupsResponse, error) {
	out := new(ListRelatedAccountGroupsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.recaptchaenterprise.v1.RecaptchaEnterpriseService/ListRelatedAccountGroups", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *recaptchaEnterpriseServiceClient) ListRelatedAccountGroupMemberships(ctx context.Context, in *ListRelatedAccountGroupMembershipsRequest, opts ...grpc.CallOption) (*ListRelatedAccountGroupMembershipsResponse, error) {
	out := new(ListRelatedAccountGroupMembershipsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.recaptchaenterprise.v1.RecaptchaEnterpriseService/ListRelatedAccountGroupMemberships", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *recaptchaEnterpriseServiceClient) SearchRelatedAccountGroupMemberships(ctx context.Context, in *SearchRelatedAccountGroupMembershipsRequest, opts ...grpc.CallOption) (*SearchRelatedAccountGroupMembershipsResponse, error) {
	out := new(SearchRelatedAccountGroupMembershipsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.recaptchaenterprise.v1.RecaptchaEnterpriseService/SearchRelatedAccountGroupMemberships", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// RecaptchaEnterpriseServiceServer is the server API for RecaptchaEnterpriseService service.
type RecaptchaEnterpriseServiceServer interface {
	// Creates an Assessment of the likelihood an event is legitimate.
	CreateAssessment(context.Context, *CreateAssessmentRequest) (*Assessment, error)
	// Annotates a previously created Assessment to provide additional information
	// on whether the event turned out to be authentic or fraudulent.
	AnnotateAssessment(context.Context, *AnnotateAssessmentRequest) (*AnnotateAssessmentResponse, error)
	// Creates a new reCAPTCHA Enterprise key.
	CreateKey(context.Context, *CreateKeyRequest) (*Key, error)
	// Returns the list of all keys that belong to a project.
	ListKeys(context.Context, *ListKeysRequest) (*ListKeysResponse, error)
	// Returns the secret key related to the specified public key.
	// You must use the legacy secret key only in a 3rd party integration with
	// legacy reCAPTCHA.
	RetrieveLegacySecretKey(context.Context, *RetrieveLegacySecretKeyRequest) (*RetrieveLegacySecretKeyResponse, error)
	// Returns the specified key.
	GetKey(context.Context, *GetKeyRequest) (*Key, error)
	// Updates the specified key.
	UpdateKey(context.Context, *UpdateKeyRequest) (*Key, error)
	// Deletes the specified key.
	DeleteKey(context.Context, *DeleteKeyRequest) (*emptypb.Empty, error)
	// Migrates an existing key from reCAPTCHA to reCAPTCHA Enterprise.
	// Once a key is migrated, it can be used from either product. SiteVerify
	// requests are billed as CreateAssessment calls. You must be
	// authenticated as one of the current owners of the reCAPTCHA Site Key, and
	// your user must have the reCAPTCHA Enterprise Admin IAM role in the
	// destination project.
	MigrateKey(context.Context, *MigrateKeyRequest) (*Key, error)
	// Get some aggregated metrics for a Key. This data can be used to build
	// dashboards.
	GetMetrics(context.Context, *GetMetricsRequest) (*Metrics, error)
	// List groups of related accounts.
	ListRelatedAccountGroups(context.Context, *ListRelatedAccountGroupsRequest) (*ListRelatedAccountGroupsResponse, error)
	// Get memberships in a group of related accounts.
	ListRelatedAccountGroupMemberships(context.Context, *ListRelatedAccountGroupMembershipsRequest) (*ListRelatedAccountGroupMembershipsResponse, error)
	// Search group memberships related to a given account.
	SearchRelatedAccountGroupMemberships(context.Context, *SearchRelatedAccountGroupMembershipsRequest) (*SearchRelatedAccountGroupMembershipsResponse, error)
}

// UnimplementedRecaptchaEnterpriseServiceServer can be embedded to have forward compatible implementations.
type UnimplementedRecaptchaEnterpriseServiceServer struct {
}

func (*UnimplementedRecaptchaEnterpriseServiceServer) CreateAssessment(context.Context, *CreateAssessmentRequest) (*Assessment, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateAssessment not implemented")
}
func (*UnimplementedRecaptchaEnterpriseServiceServer) AnnotateAssessment(context.Context, *AnnotateAssessmentRequest) (*AnnotateAssessmentResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AnnotateAssessment not implemented")
}
func (*UnimplementedRecaptchaEnterpriseServiceServer) CreateKey(context.Context, *CreateKeyRequest) (*Key, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateKey not implemented")
}
func (*UnimplementedRecaptchaEnterpriseServiceServer) ListKeys(context.Context, *ListKeysRequest) (*ListKeysResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListKeys not implemented")
}
func (*UnimplementedRecaptchaEnterpriseServiceServer) RetrieveLegacySecretKey(context.Context, *RetrieveLegacySecretKeyRequest) (*RetrieveLegacySecretKeyResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RetrieveLegacySecretKey not implemented")
}
func (*UnimplementedRecaptchaEnterpriseServiceServer) GetKey(context.Context, *GetKeyRequest) (*Key, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetKey not implemented")
}
func (*UnimplementedRecaptchaEnterpriseServiceServer) UpdateKey(context.Context, *UpdateKeyRequest) (*Key, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateKey not implemented")
}
func (*UnimplementedRecaptchaEnterpriseServiceServer) DeleteKey(context.Context, *DeleteKeyRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteKey not implemented")
}
func (*UnimplementedRecaptchaEnterpriseServiceServer) MigrateKey(context.Context, *MigrateKeyRequest) (*Key, error) {
	return nil, status.Errorf(codes.Unimplemented, "method MigrateKey not implemented")
}
func (*UnimplementedRecaptchaEnterpriseServiceServer) GetMetrics(context.Context, *GetMetricsRequest) (*Metrics, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetMetrics not implemented")
}
func (*UnimplementedRecaptchaEnterpriseServiceServer) ListRelatedAccountGroups(context.Context, *ListRelatedAccountGroupsRequest) (*ListRelatedAccountGroupsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListRelatedAccountGroups not implemented")
}
func (*UnimplementedRecaptchaEnterpriseServiceServer) ListRelatedAccountGroupMemberships(context.Context, *ListRelatedAccountGroupMembershipsRequest) (*ListRelatedAccountGroupMembershipsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListRelatedAccountGroupMemberships not implemented")
}
func (*UnimplementedRecaptchaEnterpriseServiceServer) SearchRelatedAccountGroupMemberships(context.Context, *SearchRelatedAccountGroupMembershipsRequest) (*SearchRelatedAccountGroupMembershipsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SearchRelatedAccountGroupMemberships not implemented")
}

func RegisterRecaptchaEnterpriseServiceServer(s *grpc.Server, srv RecaptchaEnterpriseServiceServer) {
	s.RegisterService(&_RecaptchaEnterpriseService_serviceDesc, srv)
}

func _RecaptchaEnterpriseService_CreateAssessment_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateAssessmentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RecaptchaEnterpriseServiceServer).CreateAssessment(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.recaptchaenterprise.v1.RecaptchaEnterpriseService/CreateAssessment",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RecaptchaEnterpriseServiceServer).CreateAssessment(ctx, req.(*CreateAssessmentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RecaptchaEnterpriseService_AnnotateAssessment_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AnnotateAssessmentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RecaptchaEnterpriseServiceServer).AnnotateAssessment(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.recaptchaenterprise.v1.RecaptchaEnterpriseService/AnnotateAssessment",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RecaptchaEnterpriseServiceServer).AnnotateAssessment(ctx, req.(*AnnotateAssessmentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RecaptchaEnterpriseService_CreateKey_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateKeyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RecaptchaEnterpriseServiceServer).CreateKey(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.recaptchaenterprise.v1.RecaptchaEnterpriseService/CreateKey",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RecaptchaEnterpriseServiceServer).CreateKey(ctx, req.(*CreateKeyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RecaptchaEnterpriseService_ListKeys_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListKeysRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RecaptchaEnterpriseServiceServer).ListKeys(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.recaptchaenterprise.v1.RecaptchaEnterpriseService/ListKeys",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RecaptchaEnterpriseServiceServer).ListKeys(ctx, req.(*ListKeysRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RecaptchaEnterpriseService_RetrieveLegacySecretKey_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RetrieveLegacySecretKeyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RecaptchaEnterpriseServiceServer).RetrieveLegacySecretKey(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.recaptchaenterprise.v1.RecaptchaEnterpriseService/RetrieveLegacySecretKey",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RecaptchaEnterpriseServiceServer).RetrieveLegacySecretKey(ctx, req.(*RetrieveLegacySecretKeyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RecaptchaEnterpriseService_GetKey_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetKeyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RecaptchaEnterpriseServiceServer).GetKey(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.recaptchaenterprise.v1.RecaptchaEnterpriseService/GetKey",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RecaptchaEnterpriseServiceServer).GetKey(ctx, req.(*GetKeyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RecaptchaEnterpriseService_UpdateKey_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateKeyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RecaptchaEnterpriseServiceServer).UpdateKey(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.recaptchaenterprise.v1.RecaptchaEnterpriseService/UpdateKey",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RecaptchaEnterpriseServiceServer).UpdateKey(ctx, req.(*UpdateKeyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RecaptchaEnterpriseService_DeleteKey_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteKeyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RecaptchaEnterpriseServiceServer).DeleteKey(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.recaptchaenterprise.v1.RecaptchaEnterpriseService/DeleteKey",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RecaptchaEnterpriseServiceServer).DeleteKey(ctx, req.(*DeleteKeyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RecaptchaEnterpriseService_MigrateKey_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(MigrateKeyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RecaptchaEnterpriseServiceServer).MigrateKey(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.recaptchaenterprise.v1.RecaptchaEnterpriseService/MigrateKey",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RecaptchaEnterpriseServiceServer).MigrateKey(ctx, req.(*MigrateKeyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RecaptchaEnterpriseService_GetMetrics_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetMetricsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RecaptchaEnterpriseServiceServer).GetMetrics(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.recaptchaenterprise.v1.RecaptchaEnterpriseService/GetMetrics",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RecaptchaEnterpriseServiceServer).GetMetrics(ctx, req.(*GetMetricsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RecaptchaEnterpriseService_ListRelatedAccountGroups_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListRelatedAccountGroupsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RecaptchaEnterpriseServiceServer).ListRelatedAccountGroups(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.recaptchaenterprise.v1.RecaptchaEnterpriseService/ListRelatedAccountGroups",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RecaptchaEnterpriseServiceServer).ListRelatedAccountGroups(ctx, req.(*ListRelatedAccountGroupsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RecaptchaEnterpriseService_ListRelatedAccountGroupMemberships_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListRelatedAccountGroupMembershipsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RecaptchaEnterpriseServiceServer).ListRelatedAccountGroupMemberships(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.recaptchaenterprise.v1.RecaptchaEnterpriseService/ListRelatedAccountGroupMemberships",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RecaptchaEnterpriseServiceServer).ListRelatedAccountGroupMemberships(ctx, req.(*ListRelatedAccountGroupMembershipsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RecaptchaEnterpriseService_SearchRelatedAccountGroupMemberships_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SearchRelatedAccountGroupMembershipsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RecaptchaEnterpriseServiceServer).SearchRelatedAccountGroupMemberships(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.recaptchaenterprise.v1.RecaptchaEnterpriseService/SearchRelatedAccountGroupMemberships",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RecaptchaEnterpriseServiceServer).SearchRelatedAccountGroupMemberships(ctx, req.(*SearchRelatedAccountGroupMembershipsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _RecaptchaEnterpriseService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.recaptchaenterprise.v1.RecaptchaEnterpriseService",
	HandlerType: (*RecaptchaEnterpriseServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateAssessment",
			Handler:    _RecaptchaEnterpriseService_CreateAssessment_Handler,
		},
		{
			MethodName: "AnnotateAssessment",
			Handler:    _RecaptchaEnterpriseService_AnnotateAssessment_Handler,
		},
		{
			MethodName: "CreateKey",
			Handler:    _RecaptchaEnterpriseService_CreateKey_Handler,
		},
		{
			MethodName: "ListKeys",
			Handler:    _RecaptchaEnterpriseService_ListKeys_Handler,
		},
		{
			MethodName: "RetrieveLegacySecretKey",
			Handler:    _RecaptchaEnterpriseService_RetrieveLegacySecretKey_Handler,
		},
		{
			MethodName: "GetKey",
			Handler:    _RecaptchaEnterpriseService_GetKey_Handler,
		},
		{
			MethodName: "UpdateKey",
			Handler:    _RecaptchaEnterpriseService_UpdateKey_Handler,
		},
		{
			MethodName: "DeleteKey",
			Handler:    _RecaptchaEnterpriseService_DeleteKey_Handler,
		},
		{
			MethodName: "MigrateKey",
			Handler:    _RecaptchaEnterpriseService_MigrateKey_Handler,
		},
		{
			MethodName: "GetMetrics",
			Handler:    _RecaptchaEnterpriseService_GetMetrics_Handler,
		},
		{
			MethodName: "ListRelatedAccountGroups",
			Handler:    _RecaptchaEnterpriseService_ListRelatedAccountGroups_Handler,
		},
		{
			MethodName: "ListRelatedAccountGroupMemberships",
			Handler:    _RecaptchaEnterpriseService_ListRelatedAccountGroupMemberships_Handler,
		},
		{
			MethodName: "SearchRelatedAccountGroupMemberships",
			Handler:    _RecaptchaEnterpriseService_SearchRelatedAccountGroupMemberships_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/recaptchaenterprise/v1/recaptchaenterprise.proto",
}
