// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.21.5
// source: google/cloud/gkemulticloud/v1/azure_service.proto

package gkemulticloudpb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	longrunning "google.golang.org/genproto/googleapis/longrunning"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Request message for `AzureClusters.CreateAzureCluster` method.
type CreateAzureClusterRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent location where this [AzureCluster][google.cloud.gkemulticloud.v1.AzureCluster] resource
	// will be created.
	//
	// Location names are formatted as `projects/<project-id>/locations/<region>`.
	//
	// See [Resource Names](https://cloud.google.com/apis/design/resource_names)
	// for more details on Google Cloud resource names.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The specification of the [AzureCluster][google.cloud.gkemulticloud.v1.AzureCluster] to create.
	AzureCluster *AzureCluster `protobuf:"bytes,2,opt,name=azure_cluster,json=azureCluster,proto3" json:"azure_cluster,omitempty"`
	// Required. A client provided ID the resource. Must be unique within the parent
	// resource.
	//
	// The provided ID will be part of the [AzureCluster][google.cloud.gkemulticloud.v1.AzureCluster]
	// resource name formatted as
	// `projects/<project-id>/locations/<region>/azureClusters/<cluster-id>`.
	//
	// Valid characters are `/[a-z][0-9]-/`. Cannot be longer than 40 characters.
	AzureClusterId string `protobuf:"bytes,3,opt,name=azure_cluster_id,json=azureClusterId,proto3" json:"azure_cluster_id,omitempty"`
	// If set, only validate the request, but do not actually create the cluster.
	ValidateOnly bool `protobuf:"varint,4,opt,name=validate_only,json=validateOnly,proto3" json:"validate_only,omitempty"`
}

func (x *CreateAzureClusterRequest) Reset() {
	*x = CreateAzureClusterRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkemulticloud_v1_azure_service_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateAzureClusterRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateAzureClusterRequest) ProtoMessage() {}

func (x *CreateAzureClusterRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkemulticloud_v1_azure_service_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateAzureClusterRequest.ProtoReflect.Descriptor instead.
func (*CreateAzureClusterRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkemulticloud_v1_azure_service_proto_rawDescGZIP(), []int{0}
}

func (x *CreateAzureClusterRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateAzureClusterRequest) GetAzureCluster() *AzureCluster {
	if x != nil {
		return x.AzureCluster
	}
	return nil
}

func (x *CreateAzureClusterRequest) GetAzureClusterId() string {
	if x != nil {
		return x.AzureClusterId
	}
	return ""
}

func (x *CreateAzureClusterRequest) GetValidateOnly() bool {
	if x != nil {
		return x.ValidateOnly
	}
	return false
}

// Request message for `AzureClusters.UpdateAzureCluster` method.
type UpdateAzureClusterRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The [AzureCluster][google.cloud.gkemulticloud.v1.AzureCluster] resource to update.
	AzureCluster *AzureCluster `protobuf:"bytes,1,opt,name=azure_cluster,json=azureCluster,proto3" json:"azure_cluster,omitempty"`
	// If set, only validate the request, but do not actually update the cluster.
	ValidateOnly bool `protobuf:"varint,2,opt,name=validate_only,json=validateOnly,proto3" json:"validate_only,omitempty"`
	// Required. Mask of fields to update. At least one path must be supplied in
	// this field. The elements of the repeated paths field can only include these
	// fields from [AzureCluster][google.cloud.gkemulticloud.v1.AzureCluster]:
	//
	//   - `description`.
	//   - `annotations`.
	//   - `azureClient`.
	//   - `control_plane.version`.
	//   - `control_plane.vm_size`.
	//   - `authorization.admin_users`.
	//   - `control_plane.root_volume.size_gib`.
	//   - `logging_config`
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,4,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateAzureClusterRequest) Reset() {
	*x = UpdateAzureClusterRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkemulticloud_v1_azure_service_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateAzureClusterRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateAzureClusterRequest) ProtoMessage() {}

func (x *UpdateAzureClusterRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkemulticloud_v1_azure_service_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateAzureClusterRequest.ProtoReflect.Descriptor instead.
func (*UpdateAzureClusterRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkemulticloud_v1_azure_service_proto_rawDescGZIP(), []int{1}
}

func (x *UpdateAzureClusterRequest) GetAzureCluster() *AzureCluster {
	if x != nil {
		return x.AzureCluster
	}
	return nil
}

func (x *UpdateAzureClusterRequest) GetValidateOnly() bool {
	if x != nil {
		return x.ValidateOnly
	}
	return false
}

func (x *UpdateAzureClusterRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request message for `AzureClusters.GetAzureCluster` method.
type GetAzureClusterRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the [AzureCluster][google.cloud.gkemulticloud.v1.AzureCluster] resource to describe.
	//
	// `AzureCluster` names are formatted as
	// `projects/<project-id>/locations/<region>/azureClusters/<cluster-id>`.
	//
	// See [Resource Names](https://cloud.google.com/apis/design/resource_names)
	// for more details on GCP resource names.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetAzureClusterRequest) Reset() {
	*x = GetAzureClusterRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkemulticloud_v1_azure_service_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetAzureClusterRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetAzureClusterRequest) ProtoMessage() {}

func (x *GetAzureClusterRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkemulticloud_v1_azure_service_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetAzureClusterRequest.ProtoReflect.Descriptor instead.
func (*GetAzureClusterRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkemulticloud_v1_azure_service_proto_rawDescGZIP(), []int{2}
}

func (x *GetAzureClusterRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for `AzureClusters.ListAzureClusters` method.
type ListAzureClustersRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent location which owns this collection of
	// [AzureCluster][google.cloud.gkemulticloud.v1.AzureCluster] resources.
	//
	// Location names are formatted as `projects/<project-id>/locations/<region>`.
	//
	// See [Resource Names](https://cloud.google.com/apis/design/resource_names)
	// for more details on GCP resource names.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of items to return.
	//
	// If not specified, a default value of 50 will be used by the service.
	// Regardless of the pageSize value, the response can include a partial list
	// and a caller should only rely on response's
	// [nextPageToken][google.cloud.gkemulticloud.v1.ListAzureClustersResponse.next_page_token] to determine if
	// there are more instances left to be queried.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The `nextPageToken` value returned from a previous
	// [azureClusters.list][google.cloud.gkemulticloud.v1.AzureClusters.ListAzureClusters] request, if any.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListAzureClustersRequest) Reset() {
	*x = ListAzureClustersRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkemulticloud_v1_azure_service_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListAzureClustersRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListAzureClustersRequest) ProtoMessage() {}

func (x *ListAzureClustersRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkemulticloud_v1_azure_service_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListAzureClustersRequest.ProtoReflect.Descriptor instead.
func (*ListAzureClustersRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkemulticloud_v1_azure_service_proto_rawDescGZIP(), []int{3}
}

func (x *ListAzureClustersRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListAzureClustersRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListAzureClustersRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response message for `AzureClusters.ListAzureClusters` method.
type ListAzureClustersResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of [AzureCluster][google.cloud.gkemulticloud.v1.AzureCluster] resources in the specified GCP
	// project and region region.
	AzureClusters []*AzureCluster `protobuf:"bytes,1,rep,name=azure_clusters,json=azureClusters,proto3" json:"azure_clusters,omitempty"`
	// Token to retrieve the next page of results, or empty if there are no more
	// results in the list.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListAzureClustersResponse) Reset() {
	*x = ListAzureClustersResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkemulticloud_v1_azure_service_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListAzureClustersResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListAzureClustersResponse) ProtoMessage() {}

func (x *ListAzureClustersResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkemulticloud_v1_azure_service_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListAzureClustersResponse.ProtoReflect.Descriptor instead.
func (*ListAzureClustersResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkemulticloud_v1_azure_service_proto_rawDescGZIP(), []int{4}
}

func (x *ListAzureClustersResponse) GetAzureClusters() []*AzureCluster {
	if x != nil {
		return x.AzureClusters
	}
	return nil
}

func (x *ListAzureClustersResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for `Clusters.DeleteAzureCluster` method.
type DeleteAzureClusterRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name the [AzureCluster][google.cloud.gkemulticloud.v1.AzureCluster] to delete.
	//
	// `AzureCluster` names are formatted as
	// `projects/<project-id>/locations/<region>/azureClusters/<cluster-id>`.
	//
	// See [Resource Names](https://cloud.google.com/apis/design/resource_names)
	// for more details on GCP resource names.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// If set to true, and the [AzureCluster][google.cloud.gkemulticloud.v1.AzureCluster] resource is not found,
	// the request will succeed but no action will be taken on the server and a
	// completed [Operation][google.longrunning.Operation] will be returned.
	//
	// Useful for idempotent deletion.
	AllowMissing bool `protobuf:"varint,2,opt,name=allow_missing,json=allowMissing,proto3" json:"allow_missing,omitempty"`
	// If set, only validate the request, but do not actually delete the resource.
	ValidateOnly bool `protobuf:"varint,3,opt,name=validate_only,json=validateOnly,proto3" json:"validate_only,omitempty"`
	// The current etag of the [AzureCluster][google.cloud.gkemulticloud.v1.AzureCluster].
	//
	// Allows clients to perform deletions through optimistic concurrency control.
	//
	// If the provided etag does not match the current etag of the cluster,
	// the request will fail and an ABORTED error will be returned.
	Etag string `protobuf:"bytes,4,opt,name=etag,proto3" json:"etag,omitempty"`
}

func (x *DeleteAzureClusterRequest) Reset() {
	*x = DeleteAzureClusterRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkemulticloud_v1_azure_service_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteAzureClusterRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteAzureClusterRequest) ProtoMessage() {}

func (x *DeleteAzureClusterRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkemulticloud_v1_azure_service_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteAzureClusterRequest.ProtoReflect.Descriptor instead.
func (*DeleteAzureClusterRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkemulticloud_v1_azure_service_proto_rawDescGZIP(), []int{5}
}

func (x *DeleteAzureClusterRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeleteAzureClusterRequest) GetAllowMissing() bool {
	if x != nil {
		return x.AllowMissing
	}
	return false
}

func (x *DeleteAzureClusterRequest) GetValidateOnly() bool {
	if x != nil {
		return x.ValidateOnly
	}
	return false
}

func (x *DeleteAzureClusterRequest) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

// Response message for `AzureClusters.CreateAzureNodePool` method.
type CreateAzureNodePoolRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The [AzureCluster][google.cloud.gkemulticloud.v1.AzureCluster] resource where this node pool will be created.
	//
	// Location names are formatted as `projects/<project-id>/locations/<region>`.
	//
	// See [Resource Names](https://cloud.google.com/apis/design/resource_names)
	// for more details on Google Cloud resource names.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The specification of the [AzureNodePool][google.cloud.gkemulticloud.v1.AzureNodePool] to create.
	AzureNodePool *AzureNodePool `protobuf:"bytes,2,opt,name=azure_node_pool,json=azureNodePool,proto3" json:"azure_node_pool,omitempty"`
	// Required. A client provided ID the resource. Must be unique within the parent
	// resource.
	//
	// The provided ID will be part of the [AzureNodePool][google.cloud.gkemulticloud.v1.AzureNodePool]
	// resource name formatted as
	// `projects/<project-id>/locations/<region>/azureClusters/<cluster-id>/azureNodePools/<node-pool-id>`.
	//
	// Valid characters are `/[a-z][0-9]-/`. Cannot be longer than 40 characters.
	AzureNodePoolId string `protobuf:"bytes,3,opt,name=azure_node_pool_id,json=azureNodePoolId,proto3" json:"azure_node_pool_id,omitempty"`
	// If set, only validate the request, but do not actually create the node
	// pool.
	ValidateOnly bool `protobuf:"varint,4,opt,name=validate_only,json=validateOnly,proto3" json:"validate_only,omitempty"`
}

func (x *CreateAzureNodePoolRequest) Reset() {
	*x = CreateAzureNodePoolRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkemulticloud_v1_azure_service_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateAzureNodePoolRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateAzureNodePoolRequest) ProtoMessage() {}

func (x *CreateAzureNodePoolRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkemulticloud_v1_azure_service_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateAzureNodePoolRequest.ProtoReflect.Descriptor instead.
func (*CreateAzureNodePoolRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkemulticloud_v1_azure_service_proto_rawDescGZIP(), []int{6}
}

func (x *CreateAzureNodePoolRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateAzureNodePoolRequest) GetAzureNodePool() *AzureNodePool {
	if x != nil {
		return x.AzureNodePool
	}
	return nil
}

func (x *CreateAzureNodePoolRequest) GetAzureNodePoolId() string {
	if x != nil {
		return x.AzureNodePoolId
	}
	return ""
}

func (x *CreateAzureNodePoolRequest) GetValidateOnly() bool {
	if x != nil {
		return x.ValidateOnly
	}
	return false
}

// Request message for `AzureClusters.UpdateAzureNodePool` method.
type UpdateAzureNodePoolRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The [AzureNodePool][google.cloud.gkemulticloud.v1.AzureNodePool] resource to update.
	AzureNodePool *AzureNodePool `protobuf:"bytes,1,opt,name=azure_node_pool,json=azureNodePool,proto3" json:"azure_node_pool,omitempty"`
	// If set, only validate the request, but don't actually update the node pool.
	ValidateOnly bool `protobuf:"varint,2,opt,name=validate_only,json=validateOnly,proto3" json:"validate_only,omitempty"`
	// Required. Mask of fields to update. At least one path must be supplied in
	// this field. The elements of the repeated paths field can only include these
	// fields from [AzureNodePool][google.cloud.gkemulticloud.v1.AzureNodePool]:
	//
	//	*.  `annotations`.
	//	*   `version`.
	//	*   `autoscaling.min_node_count`.
	//	*   `autoscaling.max_node_count`.
	//	*   `config.vm_size`.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,3,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateAzureNodePoolRequest) Reset() {
	*x = UpdateAzureNodePoolRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkemulticloud_v1_azure_service_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateAzureNodePoolRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateAzureNodePoolRequest) ProtoMessage() {}

func (x *UpdateAzureNodePoolRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkemulticloud_v1_azure_service_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateAzureNodePoolRequest.ProtoReflect.Descriptor instead.
func (*UpdateAzureNodePoolRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkemulticloud_v1_azure_service_proto_rawDescGZIP(), []int{7}
}

func (x *UpdateAzureNodePoolRequest) GetAzureNodePool() *AzureNodePool {
	if x != nil {
		return x.AzureNodePool
	}
	return nil
}

func (x *UpdateAzureNodePoolRequest) GetValidateOnly() bool {
	if x != nil {
		return x.ValidateOnly
	}
	return false
}

func (x *UpdateAzureNodePoolRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request message for `AzureClusters.GetAzureNodePool` method.
type GetAzureNodePoolRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the [AzureNodePool][google.cloud.gkemulticloud.v1.AzureNodePool] resource to describe.
	//
	// `AzureNodePool` names are formatted as
	// `projects/<project-id>/locations/<region>/azureClusters/<cluster-id>/azureNodePools/<node-pool-id>`.
	//
	// See [Resource Names](https://cloud.google.com/apis/design/resource_names)
	// for more details on Google Cloud resource names.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetAzureNodePoolRequest) Reset() {
	*x = GetAzureNodePoolRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkemulticloud_v1_azure_service_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetAzureNodePoolRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetAzureNodePoolRequest) ProtoMessage() {}

func (x *GetAzureNodePoolRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkemulticloud_v1_azure_service_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetAzureNodePoolRequest.ProtoReflect.Descriptor instead.
func (*GetAzureNodePoolRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkemulticloud_v1_azure_service_proto_rawDescGZIP(), []int{8}
}

func (x *GetAzureNodePoolRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for `AzureClusters.ListAzureNodePools` method.
type ListAzureNodePoolsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent `AzureCluster` which owns this collection of
	// [AzureNodePool][google.cloud.gkemulticloud.v1.AzureNodePool] resources.
	//
	// `AzureCluster` names are formatted as
	// `projects/<project-id>/locations/<region>/azureClusters/<cluster-id>`.
	//
	// See [Resource Names](https://cloud.google.com/apis/design/resource_names)
	// for more details on Google Cloud resource names.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of items to return.
	//
	// If not specified, a default value of 50 will be used by the service.
	// Regardless of the pageSize value, the response can include a partial list
	// and a caller should only rely on response's
	// [nextPageToken][google.cloud.gkemulticloud.v1.ListAzureNodePoolsResponse.next_page_token] to determine if
	// there are more instances left to be queried.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The `nextPageToken` value returned from a previous
	// [azureNodePools.list][google.cloud.gkemulticloud.v1.AzureClusters.ListAzureNodePools] request, if any.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListAzureNodePoolsRequest) Reset() {
	*x = ListAzureNodePoolsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkemulticloud_v1_azure_service_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListAzureNodePoolsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListAzureNodePoolsRequest) ProtoMessage() {}

func (x *ListAzureNodePoolsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkemulticloud_v1_azure_service_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListAzureNodePoolsRequest.ProtoReflect.Descriptor instead.
func (*ListAzureNodePoolsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkemulticloud_v1_azure_service_proto_rawDescGZIP(), []int{9}
}

func (x *ListAzureNodePoolsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListAzureNodePoolsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListAzureNodePoolsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response message for `AzureClusters.ListAzureNodePools` method.
type ListAzureNodePoolsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of [AzureNodePool][google.cloud.gkemulticloud.v1.AzureNodePool] resources in the specified `AzureCluster`.
	AzureNodePools []*AzureNodePool `protobuf:"bytes,1,rep,name=azure_node_pools,json=azureNodePools,proto3" json:"azure_node_pools,omitempty"`
	// Token to retrieve the next page of results, or empty if there are no more
	// results in the list.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListAzureNodePoolsResponse) Reset() {
	*x = ListAzureNodePoolsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkemulticloud_v1_azure_service_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListAzureNodePoolsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListAzureNodePoolsResponse) ProtoMessage() {}

func (x *ListAzureNodePoolsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkemulticloud_v1_azure_service_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListAzureNodePoolsResponse.ProtoReflect.Descriptor instead.
func (*ListAzureNodePoolsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkemulticloud_v1_azure_service_proto_rawDescGZIP(), []int{10}
}

func (x *ListAzureNodePoolsResponse) GetAzureNodePools() []*AzureNodePool {
	if x != nil {
		return x.AzureNodePools
	}
	return nil
}

func (x *ListAzureNodePoolsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Delete message for `AzureClusters.DeleteNodePool` method.
type DeleteAzureNodePoolRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name the [AzureNodePool][google.cloud.gkemulticloud.v1.AzureNodePool] to delete.
	//
	// `AzureNodePool` names are formatted as
	// `projects/<project-id>/locations/<region>/azureClusters/<cluster-id>/azureNodePools/<node-pool-id>`.
	//
	// See [Resource Names](https://cloud.google.com/apis/design/resource_names)
	// for more details on Google Cloud resource names.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// If set, only validate the request, but do not actually delete the node
	// pool.
	ValidateOnly bool `protobuf:"varint,2,opt,name=validate_only,json=validateOnly,proto3" json:"validate_only,omitempty"`
	// If set to true, and the [AzureNodePool][google.cloud.gkemulticloud.v1.AzureNodePool] resource is not found,
	// the request will succeed but no action will be taken on the server and a
	// completed [Operation][google.longrunning.Operation] will be returned.
	//
	// Useful for idempotent deletion.
	AllowMissing bool `protobuf:"varint,3,opt,name=allow_missing,json=allowMissing,proto3" json:"allow_missing,omitempty"`
	// The current ETag of the [AzureNodePool][google.cloud.gkemulticloud.v1.AzureNodePool].
	//
	// Allows clients to perform deletions through optimistic concurrency control.
	//
	// If the provided ETag does not match the current etag of the node pool,
	// the request will fail and an ABORTED error will be returned.
	Etag string `protobuf:"bytes,4,opt,name=etag,proto3" json:"etag,omitempty"`
}

func (x *DeleteAzureNodePoolRequest) Reset() {
	*x = DeleteAzureNodePoolRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkemulticloud_v1_azure_service_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteAzureNodePoolRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteAzureNodePoolRequest) ProtoMessage() {}

func (x *DeleteAzureNodePoolRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkemulticloud_v1_azure_service_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteAzureNodePoolRequest.ProtoReflect.Descriptor instead.
func (*DeleteAzureNodePoolRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkemulticloud_v1_azure_service_proto_rawDescGZIP(), []int{11}
}

func (x *DeleteAzureNodePoolRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeleteAzureNodePoolRequest) GetValidateOnly() bool {
	if x != nil {
		return x.ValidateOnly
	}
	return false
}

func (x *DeleteAzureNodePoolRequest) GetAllowMissing() bool {
	if x != nil {
		return x.AllowMissing
	}
	return false
}

func (x *DeleteAzureNodePoolRequest) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

// GetAzureServerConfigRequest gets the server config of GKE cluster on Azure.
type GetAzureServerConfigRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the [AzureServerConfig][google.cloud.gkemulticloud.v1.AzureServerConfig] resource to describe.
	//
	// `AzureServerConfig` names are formatted as
	// `projects/<project-id>/locations/<region>/azureServerConfig`.
	//
	// See [Resource Names](https://cloud.google.com/apis/design/resource_names)
	// for more details on Google Cloud resource names.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetAzureServerConfigRequest) Reset() {
	*x = GetAzureServerConfigRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkemulticloud_v1_azure_service_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetAzureServerConfigRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetAzureServerConfigRequest) ProtoMessage() {}

func (x *GetAzureServerConfigRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkemulticloud_v1_azure_service_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetAzureServerConfigRequest.ProtoReflect.Descriptor instead.
func (*GetAzureServerConfigRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkemulticloud_v1_azure_service_proto_rawDescGZIP(), []int{12}
}

func (x *GetAzureServerConfigRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for `AzureClusters.CreateAzureClient` method.
type CreateAzureClientRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent location where this [AzureClient][google.cloud.gkemulticloud.v1.AzureClient] resource
	// will be created.
	//
	// Location names are formatted as `projects/<project-id>/locations/<region>`.
	//
	// See [Resource Names](https://cloud.google.com/apis/design/resource_names)
	// for more details on Google Cloud resource names.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The specification of the [AzureClient][google.cloud.gkemulticloud.v1.AzureClient] to create.
	AzureClient *AzureClient `protobuf:"bytes,2,opt,name=azure_client,json=azureClient,proto3" json:"azure_client,omitempty"`
	// Required. A client provided ID the resource. Must be unique within the parent
	// resource.
	//
	// The provided ID will be part of the [AzureClient][google.cloud.gkemulticloud.v1.AzureClient]
	// resource name formatted as
	// `projects/<project-id>/locations/<region>/azureClients/<client-id>`.
	//
	// Valid characters are `/[a-z][0-9]-/`. Cannot be longer than 40 characters.
	AzureClientId string `protobuf:"bytes,4,opt,name=azure_client_id,json=azureClientId,proto3" json:"azure_client_id,omitempty"`
	// If set, only validate the request, but do not actually create the client.
	ValidateOnly bool `protobuf:"varint,3,opt,name=validate_only,json=validateOnly,proto3" json:"validate_only,omitempty"`
}

func (x *CreateAzureClientRequest) Reset() {
	*x = CreateAzureClientRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkemulticloud_v1_azure_service_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateAzureClientRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateAzureClientRequest) ProtoMessage() {}

func (x *CreateAzureClientRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkemulticloud_v1_azure_service_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateAzureClientRequest.ProtoReflect.Descriptor instead.
func (*CreateAzureClientRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkemulticloud_v1_azure_service_proto_rawDescGZIP(), []int{13}
}

func (x *CreateAzureClientRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateAzureClientRequest) GetAzureClient() *AzureClient {
	if x != nil {
		return x.AzureClient
	}
	return nil
}

func (x *CreateAzureClientRequest) GetAzureClientId() string {
	if x != nil {
		return x.AzureClientId
	}
	return ""
}

func (x *CreateAzureClientRequest) GetValidateOnly() bool {
	if x != nil {
		return x.ValidateOnly
	}
	return false
}

// Request message for `AzureClusters.GetAzureClient` method.
type GetAzureClientRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the [AzureClient][google.cloud.gkemulticloud.v1.AzureClient] resource to describe.
	//
	// [AzureClient][google.cloud.gkemulticloud.v1.AzureClient] names are formatted as
	// `projects/<project-id>/locations/<region>/azureClients/<client-id>`.
	//
	// See [Resource Names](https://cloud.google.com/apis/design/resource_names)
	// for more details on Google Cloud resource names.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetAzureClientRequest) Reset() {
	*x = GetAzureClientRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkemulticloud_v1_azure_service_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetAzureClientRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetAzureClientRequest) ProtoMessage() {}

func (x *GetAzureClientRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkemulticloud_v1_azure_service_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetAzureClientRequest.ProtoReflect.Descriptor instead.
func (*GetAzureClientRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkemulticloud_v1_azure_service_proto_rawDescGZIP(), []int{14}
}

func (x *GetAzureClientRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for `AzureClusters.ListAzureClients` method.
type ListAzureClientsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent location which owns this collection of
	// [AzureClient][google.cloud.gkemulticloud.v1.AzureClient] resources.
	//
	// Location names are formatted as `projects/<project-id>/locations/<region>`.
	//
	// See [Resource Names](https://cloud.google.com/apis/design/resource_names)
	// for more details on GCP resource names.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of items to return.
	//
	// If not specified, a default value of 50 will be used by the service.
	// Regardless of the pageSize value, the response can include a partial list
	// and a caller should only rely on response's
	// [nextPageToken][google.cloud.gkemulticloud.v1.ListAzureClientsResponse.next_page_token] to determine if
	// there are more instances left to be queried.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The `nextPageToken` value returned from a previous
	// [azureClients.list][google.cloud.gkemulticloud.v1.AzureClusters.ListAzureClients] request, if any.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListAzureClientsRequest) Reset() {
	*x = ListAzureClientsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkemulticloud_v1_azure_service_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListAzureClientsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListAzureClientsRequest) ProtoMessage() {}

func (x *ListAzureClientsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkemulticloud_v1_azure_service_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListAzureClientsRequest.ProtoReflect.Descriptor instead.
func (*ListAzureClientsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkemulticloud_v1_azure_service_proto_rawDescGZIP(), []int{15}
}

func (x *ListAzureClientsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListAzureClientsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListAzureClientsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response message for `AzureClusters.ListAzureClients` method.
type ListAzureClientsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of [AzureClient][google.cloud.gkemulticloud.v1.AzureClient] resources in the specified Google Cloud
	// project and region region.
	AzureClients []*AzureClient `protobuf:"bytes,1,rep,name=azure_clients,json=azureClients,proto3" json:"azure_clients,omitempty"`
	// Token to retrieve the next page of results, or empty if there are no more
	// results in the list.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListAzureClientsResponse) Reset() {
	*x = ListAzureClientsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkemulticloud_v1_azure_service_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListAzureClientsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListAzureClientsResponse) ProtoMessage() {}

func (x *ListAzureClientsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkemulticloud_v1_azure_service_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListAzureClientsResponse.ProtoReflect.Descriptor instead.
func (*ListAzureClientsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkemulticloud_v1_azure_service_proto_rawDescGZIP(), []int{16}
}

func (x *ListAzureClientsResponse) GetAzureClients() []*AzureClient {
	if x != nil {
		return x.AzureClients
	}
	return nil
}

func (x *ListAzureClientsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for `AzureClusters.DeleteAzureClient` method.
type DeleteAzureClientRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name the [AzureClient][google.cloud.gkemulticloud.v1.AzureClient] to delete.
	//
	// [AzureClient][google.cloud.gkemulticloud.v1.AzureClient] names are formatted as
	// `projects/<project-id>/locations/<region>/azureClients/<client-id>`.
	//
	// See [Resource Names](https://cloud.google.com/apis/design/resource_names)
	// for more details on Google Cloud resource names.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// If set to true, and the [AzureClient][google.cloud.gkemulticloud.v1.AzureClient] resource is not found,
	// the request will succeed but no action will be taken on the server and a
	// completed [Operation][google.longrunning.Operation] will be returned.
	//
	// Useful for idempotent deletion.
	AllowMissing bool `protobuf:"varint,2,opt,name=allow_missing,json=allowMissing,proto3" json:"allow_missing,omitempty"`
	// If set, only validate the request, but do not actually delete the resource.
	ValidateOnly bool `protobuf:"varint,3,opt,name=validate_only,json=validateOnly,proto3" json:"validate_only,omitempty"`
}

func (x *DeleteAzureClientRequest) Reset() {
	*x = DeleteAzureClientRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkemulticloud_v1_azure_service_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteAzureClientRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteAzureClientRequest) ProtoMessage() {}

func (x *DeleteAzureClientRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkemulticloud_v1_azure_service_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteAzureClientRequest.ProtoReflect.Descriptor instead.
func (*DeleteAzureClientRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkemulticloud_v1_azure_service_proto_rawDescGZIP(), []int{17}
}

func (x *DeleteAzureClientRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeleteAzureClientRequest) GetAllowMissing() bool {
	if x != nil {
		return x.AllowMissing
	}
	return false
}

func (x *DeleteAzureClientRequest) GetValidateOnly() bool {
	if x != nil {
		return x.ValidateOnly
	}
	return false
}

// Request message for `AzureClusters.GenerateAzureAccessToken` method.
type GenerateAzureAccessTokenRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the [AzureCluster][google.cloud.gkemulticloud.v1.AzureCluster] resource to authenticate to.
	//
	// `AzureCluster` names are formatted as
	// `projects/<project-id>/locations/<region>/AzureClusters/<cluster-id>`.
	//
	// See [Resource Names](https://cloud.google.com/apis/design/resource_names)
	// for more details on Google Cloud resource names.
	AzureCluster string `protobuf:"bytes,1,opt,name=azure_cluster,json=azureCluster,proto3" json:"azure_cluster,omitempty"`
}

func (x *GenerateAzureAccessTokenRequest) Reset() {
	*x = GenerateAzureAccessTokenRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkemulticloud_v1_azure_service_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GenerateAzureAccessTokenRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GenerateAzureAccessTokenRequest) ProtoMessage() {}

func (x *GenerateAzureAccessTokenRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkemulticloud_v1_azure_service_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GenerateAzureAccessTokenRequest.ProtoReflect.Descriptor instead.
func (*GenerateAzureAccessTokenRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkemulticloud_v1_azure_service_proto_rawDescGZIP(), []int{18}
}

func (x *GenerateAzureAccessTokenRequest) GetAzureCluster() string {
	if x != nil {
		return x.AzureCluster
	}
	return ""
}

// Response message for `AzureClusters.GenerateAzureAccessToken` method.
type GenerateAzureAccessTokenResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Access token to authenticate to k8s api-server.
	AccessToken string `protobuf:"bytes,1,opt,name=access_token,json=accessToken,proto3" json:"access_token,omitempty"`
	// Output only. Timestamp at which the token will expire.
	ExpirationTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=expiration_time,json=expirationTime,proto3" json:"expiration_time,omitempty"`
}

func (x *GenerateAzureAccessTokenResponse) Reset() {
	*x = GenerateAzureAccessTokenResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkemulticloud_v1_azure_service_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GenerateAzureAccessTokenResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GenerateAzureAccessTokenResponse) ProtoMessage() {}

func (x *GenerateAzureAccessTokenResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkemulticloud_v1_azure_service_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GenerateAzureAccessTokenResponse.ProtoReflect.Descriptor instead.
func (*GenerateAzureAccessTokenResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkemulticloud_v1_azure_service_proto_rawDescGZIP(), []int{19}
}

func (x *GenerateAzureAccessTokenResponse) GetAccessToken() string {
	if x != nil {
		return x.AccessToken
	}
	return ""
}

func (x *GenerateAzureAccessTokenResponse) GetExpirationTime() *timestamppb.Timestamp {
	if x != nil {
		return x.ExpirationTime
	}
	return nil
}

var File_google_cloud_gkemulticloud_v1_azure_service_proto protoreflect.FileDescriptor

var file_google_cloud_gkemulticloud_v1_azure_service_proto_rawDesc = []byte{
	0x0a, 0x31, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x67,
	0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x76, 0x31, 0x2f,
	0x61, 0x7a, 0x75, 0x72, 0x65, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x12, 0x1d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x76, 0x31, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61,
	0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69,
	0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61,
	0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x33, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2f, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2f, 0x76, 0x31, 0x2f, 0x61, 0x7a, 0x75, 0x72, 0x65, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x23, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2f, 0x6f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x22, 0x91, 0x02, 0x0a, 0x19, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x41, 0x7a, 0x75,
	0x72, 0x65, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x49, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x31, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2b, 0x12, 0x29, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c,
	0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x7a, 0x75, 0x72, 0x65, 0x43, 0x6c, 0x75, 0x73,
	0x74, 0x65, 0x72, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x55, 0x0a, 0x0d, 0x61,
	0x7a, 0x75, 0x72, 0x65, 0x5f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x76, 0x31, 0x2e, 0x41, 0x7a, 0x75, 0x72, 0x65, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x0c, 0x61, 0x7a, 0x75, 0x72, 0x65, 0x43, 0x6c, 0x75, 0x73, 0x74,
	0x65, 0x72, 0x12, 0x2d, 0x0a, 0x10, 0x61, 0x7a, 0x75, 0x72, 0x65, 0x5f, 0x63, 0x6c, 0x75, 0x73,
	0x74, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x0e, 0x61, 0x7a, 0x75, 0x72, 0x65, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x49,
	0x64, 0x12, 0x23, 0x0a, 0x0d, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6f, 0x6e,
	0x6c, 0x79, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0c, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61,
	0x74, 0x65, 0x4f, 0x6e, 0x6c, 0x79, 0x22, 0xd9, 0x01, 0x0a, 0x19, 0x55, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x41, 0x7a, 0x75, 0x72, 0x65, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x55, 0x0a, 0x0d, 0x61, 0x7a, 0x75, 0x72, 0x65, 0x5f, 0x63, 0x6c,
	0x75, 0x73, 0x74, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x6d, 0x75,
	0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x7a, 0x75, 0x72,
	0x65, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0c, 0x61,
	0x7a, 0x75, 0x72, 0x65, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x12, 0x23, 0x0a, 0x0d, 0x76,
	0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6f, 0x6e, 0x6c, 0x79, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x08, 0x52, 0x0c, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x4f, 0x6e, 0x6c, 0x79,
	0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73,
	0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61,
	0x73, 0x6b, 0x22, 0x5f, 0x0a, 0x16, 0x47, 0x65, 0x74, 0x41, 0x7a, 0x75, 0x72, 0x65, 0x43, 0x6c,
	0x75, 0x73, 0x74, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x45, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x31, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x2b, 0x0a, 0x29, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x41, 0x7a, 0x75, 0x72, 0x65, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x22, 0xa1, 0x01, 0x0a, 0x18, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x7a, 0x75, 0x72,
	0x65, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x49, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x31, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2b, 0x12, 0x29, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c,
	0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x7a, 0x75, 0x72, 0x65, 0x43, 0x6c, 0x75, 0x73,
	0x74, 0x65, 0x72, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70,
	0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08,
	0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65,
	0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61,
	0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x97, 0x01, 0x0a, 0x19, 0x4c, 0x69, 0x73, 0x74,
	0x41, 0x7a, 0x75, 0x72, 0x65, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x52, 0x0a, 0x0e, 0x61, 0x7a, 0x75, 0x72, 0x65, 0x5f, 0x63,
	0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2b, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65,
	0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x7a,
	0x75, 0x72, 0x65, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x52, 0x0d, 0x61, 0x7a, 0x75, 0x72,
	0x65, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78,
	0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65,
	0x6e, 0x22, 0xc0, 0x01, 0x0a, 0x19, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x41, 0x7a, 0x75, 0x72,
	0x65, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x45, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x31, 0xe0,
	0x41, 0x02, 0xfa, 0x41, 0x2b, 0x0a, 0x29, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x7a, 0x75, 0x72, 0x65, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x23, 0x0a, 0x0d, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x5f,
	0x6d, 0x69, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0c, 0x61,
	0x6c, 0x6c, 0x6f, 0x77, 0x4d, 0x69, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x12, 0x23, 0x0a, 0x0d, 0x76,
	0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6f, 0x6e, 0x6c, 0x79, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x08, 0x52, 0x0c, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x4f, 0x6e, 0x6c, 0x79,
	0x12, 0x12, 0x0a, 0x04, 0x65, 0x74, 0x61, 0x67, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04,
	0x65, 0x74, 0x61, 0x67, 0x22, 0x9a, 0x02, 0x0a, 0x1a, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x41,
	0x7a, 0x75, 0x72, 0x65, 0x4e, 0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x4a, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x32, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2c, 0x12, 0x2a, 0x67, 0x6b, 0x65,
	0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x7a, 0x75, 0x72, 0x65, 0x4e,
	0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12,
	0x59, 0x0a, 0x0f, 0x61, 0x7a, 0x75, 0x72, 0x65, 0x5f, 0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x70, 0x6f,
	0x6f, 0x6c, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x7a, 0x75, 0x72, 0x65, 0x4e, 0x6f,
	0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0d, 0x61, 0x7a, 0x75,
	0x72, 0x65, 0x4e, 0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x12, 0x30, 0x0a, 0x12, 0x61, 0x7a,
	0x75, 0x72, 0x65, 0x5f, 0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x70, 0x6f, 0x6f, 0x6c, 0x5f, 0x69, 0x64,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0f, 0x61, 0x7a, 0x75,
	0x72, 0x65, 0x4e, 0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x49, 0x64, 0x12, 0x23, 0x0a, 0x0d,
	0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6f, 0x6e, 0x6c, 0x79, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x08, 0x52, 0x0c, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x4f, 0x6e, 0x6c,
	0x79, 0x22, 0xde, 0x01, 0x0a, 0x1a, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x41, 0x7a, 0x75, 0x72,
	0x65, 0x4e, 0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x59, 0x0a, 0x0f, 0x61, 0x7a, 0x75, 0x72, 0x65, 0x5f, 0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x70,
	0x6f, 0x6f, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74,
	0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x7a, 0x75, 0x72, 0x65, 0x4e,
	0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0d, 0x61, 0x7a,
	0x75, 0x72, 0x65, 0x4e, 0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x12, 0x23, 0x0a, 0x0d, 0x76,
	0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6f, 0x6e, 0x6c, 0x79, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x08, 0x52, 0x0c, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x4f, 0x6e, 0x6c, 0x79,
	0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73,
	0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61,
	0x73, 0x6b, 0x22, 0x61, 0x0a, 0x17, 0x47, 0x65, 0x74, 0x41, 0x7a, 0x75, 0x72, 0x65, 0x4e, 0x6f,
	0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x46, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x32, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x2c, 0x0a, 0x2a, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x41, 0x7a, 0x75, 0x72, 0x65, 0x4e, 0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xa3, 0x01, 0x0a, 0x19, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x7a,
	0x75, 0x72, 0x65, 0x4e, 0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x4a, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x32, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2c, 0x12, 0x2a, 0x67, 0x6b, 0x65,
	0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x7a, 0x75, 0x72, 0x65, 0x4e,
	0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12,
	0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a,
	0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x9c, 0x01, 0x0a, 0x1a,
	0x4c, 0x69, 0x73, 0x74, 0x41, 0x7a, 0x75, 0x72, 0x65, 0x4e, 0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f,
	0x6c, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x56, 0x0a, 0x10, 0x61, 0x7a,
	0x75, 0x72, 0x65, 0x5f, 0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x70, 0x6f, 0x6f, 0x6c, 0x73, 0x18, 0x01,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x7a, 0x75, 0x72, 0x65, 0x4e, 0x6f, 0x64, 0x65, 0x50, 0x6f,
	0x6f, 0x6c, 0x52, 0x0e, 0x61, 0x7a, 0x75, 0x72, 0x65, 0x4e, 0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f,
	0x6c, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f,
	0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78,
	0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xc2, 0x01, 0x0a, 0x1a, 0x44,
	0x65, 0x6c, 0x65, 0x74, 0x65, 0x41, 0x7a, 0x75, 0x72, 0x65, 0x4e, 0x6f, 0x64, 0x65, 0x50, 0x6f,
	0x6f, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x46, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x32, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2c, 0x0a,
	0x2a, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x7a,
	0x75, 0x72, 0x65, 0x4e, 0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x12, 0x23, 0x0a, 0x0d, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6f, 0x6e,
	0x6c, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0c, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61,
	0x74, 0x65, 0x4f, 0x6e, 0x6c, 0x79, 0x12, 0x23, 0x0a, 0x0d, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x5f,
	0x6d, 0x69, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0c, 0x61,
	0x6c, 0x6c, 0x6f, 0x77, 0x4d, 0x69, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x12, 0x12, 0x0a, 0x04, 0x65,
	0x74, 0x61, 0x67, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x65, 0x74, 0x61, 0x67, 0x22,
	0x69, 0x0a, 0x1b, 0x47, 0x65, 0x74, 0x41, 0x7a, 0x75, 0x72, 0x65, 0x53, 0x65, 0x72, 0x76, 0x65,
	0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4a,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x36, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x30, 0x0a, 0x2e, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x41, 0x7a, 0x75, 0x72, 0x65, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x8a, 0x02, 0x0a, 0x18, 0x43,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x41, 0x7a, 0x75, 0x72, 0x65, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x48, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x30, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2a, 0x12,
	0x28, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x7a,
	0x75, 0x72, 0x65, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x12, 0x52, 0x0a, 0x0c, 0x61, 0x7a, 0x75, 0x72, 0x65, 0x5f, 0x63, 0x6c, 0x69, 0x65, 0x6e,
	0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x7a, 0x75, 0x72, 0x65, 0x43, 0x6c, 0x69,
	0x65, 0x6e, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x61, 0x7a, 0x75, 0x72, 0x65, 0x43,
	0x6c, 0x69, 0x65, 0x6e, 0x74, 0x12, 0x2b, 0x0a, 0x0f, 0x61, 0x7a, 0x75, 0x72, 0x65, 0x5f, 0x63,
	0x6c, 0x69, 0x65, 0x6e, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x0d, 0x61, 0x7a, 0x75, 0x72, 0x65, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74,
	0x49, 0x64, 0x12, 0x23, 0x0a, 0x0d, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6f,
	0x6e, 0x6c, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0c, 0x76, 0x61, 0x6c, 0x69, 0x64,
	0x61, 0x74, 0x65, 0x4f, 0x6e, 0x6c, 0x79, 0x22, 0x5d, 0x0a, 0x15, 0x47, 0x65, 0x74, 0x41, 0x7a,
	0x75, 0x72, 0x65, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x44, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x30,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2a, 0x0a, 0x28, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x7a, 0x75, 0x72, 0x65, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x9f, 0x01, 0x0a, 0x17, 0x4c, 0x69, 0x73, 0x74, 0x41,
	0x7a, 0x75, 0x72, 0x65, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x48, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x30, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2a, 0x12, 0x28, 0x67, 0x6b, 0x65, 0x6d,
	0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x7a, 0x75, 0x72, 0x65, 0x43, 0x6c,
	0x69, 0x65, 0x6e, 0x74, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09,
	0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52,
	0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67,
	0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70,
	0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x93, 0x01, 0x0a, 0x18, 0x4c, 0x69, 0x73,
	0x74, 0x41, 0x7a, 0x75, 0x72, 0x65, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x4f, 0x0a, 0x0d, 0x61, 0x7a, 0x75, 0x72, 0x65, 0x5f, 0x63,
	0x6c, 0x69, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x6d,
	0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x7a, 0x75,
	0x72, 0x65, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x52, 0x0c, 0x61, 0x7a, 0x75, 0x72, 0x65, 0x43,
	0x6c, 0x69, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70,
	0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xaa,
	0x01, 0x0a, 0x18, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x41, 0x7a, 0x75, 0x72, 0x65, 0x43, 0x6c,
	0x69, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x44, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x30, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x2a, 0x0a, 0x28, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x41, 0x7a, 0x75, 0x72, 0x65, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x12, 0x23, 0x0a, 0x0d, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x5f, 0x6d, 0x69, 0x73, 0x73, 0x69,
	0x6e, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0c, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x4d,
	0x69, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x12, 0x23, 0x0a, 0x0d, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61,
	0x74, 0x65, 0x5f, 0x6f, 0x6e, 0x6c, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0c, 0x76,
	0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x4f, 0x6e, 0x6c, 0x79, 0x22, 0x79, 0x0a, 0x1f, 0x47,
	0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x41, 0x7a, 0x75, 0x72, 0x65, 0x41, 0x63, 0x63, 0x65,
	0x73, 0x73, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x56,
	0x0a, 0x0d, 0x61, 0x7a, 0x75, 0x72, 0x65, 0x5f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x31, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2b, 0x0a, 0x29, 0x67,
	0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x7a, 0x75, 0x72,
	0x65, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x52, 0x0c, 0x61, 0x7a, 0x75, 0x72, 0x65, 0x43,
	0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x22, 0x94, 0x01, 0x0a, 0x20, 0x47, 0x65, 0x6e, 0x65, 0x72,
	0x61, 0x74, 0x65, 0x41, 0x7a, 0x75, 0x72, 0x65, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x54, 0x6f,
	0x6b, 0x65, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x26, 0x0a, 0x0c, 0x61,
	0x63, 0x63, 0x65, 0x73, 0x73, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x54, 0x6f,
	0x6b, 0x65, 0x6e, 0x12, 0x48, 0x0a, 0x0f, 0x65, 0x78, 0x70, 0x69, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0e, 0x65,
	0x78, 0x70, 0x69, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x69, 0x6d, 0x65, 0x32, 0xdd, 0x1d,
	0x0a, 0x0d, 0x41, 0x7a, 0x75, 0x72, 0x65, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x12,
	0xfd, 0x01, 0x0a, 0x11, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x41, 0x7a, 0x75, 0x72, 0x65, 0x43,
	0x6c, 0x69, 0x65, 0x6e, 0x74, 0x12, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x41, 0x7a, 0x75, 0x72,
	0x65, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e,
	0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x8f, 0x01,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x40, 0x22, 0x30, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x61, 0x7a, 0x75, 0x72,
	0x65, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x73, 0x3a, 0x0c, 0x61, 0x7a, 0x75, 0x72, 0x65, 0x5f,
	0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0xda, 0x41, 0x23, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c,
	0x61, 0x7a, 0x75, 0x72, 0x65, 0x5f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2c, 0x61, 0x7a, 0x75,
	0x72, 0x65, 0x5f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x5f, 0x69, 0x64, 0xca, 0x41, 0x20, 0x0a,
	0x0b, 0x41, 0x7a, 0x75, 0x72, 0x65, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x12, 0x11, 0x4f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12,
	0xb3, 0x01, 0x0a, 0x0e, 0x47, 0x65, 0x74, 0x41, 0x7a, 0x75, 0x72, 0x65, 0x43, 0x6c, 0x69, 0x65,
	0x6e, 0x74, 0x12, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x41, 0x7a, 0x75, 0x72, 0x65, 0x43, 0x6c, 0x69, 0x65, 0x6e,
	0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x7a, 0x75, 0x72, 0x65, 0x43, 0x6c,
	0x69, 0x65, 0x6e, 0x74, 0x22, 0x3f, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x32, 0x12, 0x30, 0x2f, 0x76,
	0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x61,
	0x7a, 0x75, 0x72, 0x65, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0xc6, 0x01, 0x0a, 0x10, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x7a,
	0x75, 0x72, 0x65, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x36, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c,
	0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x41,
	0x7a, 0x75, 0x72, 0x65, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x7a, 0x75, 0x72, 0x65, 0x43, 0x6c, 0x69, 0x65,
	0x6e, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x41, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x32, 0x12, 0x30, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x61, 0x7a, 0x75, 0x72, 0x65, 0x43, 0x6c,
	0x69, 0x65, 0x6e, 0x74, 0x73, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0xd9,
	0x01, 0x0a, 0x11, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x41, 0x7a, 0x75, 0x72, 0x65, 0x43, 0x6c,
	0x69, 0x65, 0x6e, 0x74, 0x12, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x41, 0x7a, 0x75, 0x72, 0x65,
	0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69,
	0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x6c, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x32, 0x2a, 0x30, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x7a, 0x75, 0x72, 0x65, 0x43, 0x6c, 0x69, 0x65,
	0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0xca, 0x41, 0x2a,
	0x0a, 0x15, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x84, 0x02, 0x0a, 0x12, 0x43,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x41, 0x7a, 0x75, 0x72, 0x65, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65,
	0x72, 0x12, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76,
	0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x41, 0x7a, 0x75, 0x72, 0x65, 0x43, 0x6c, 0x75,
	0x73, 0x74, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67,
	0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x94, 0x01, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x42, 0x22, 0x31, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x61, 0x7a, 0x75, 0x72, 0x65, 0x43, 0x6c,
	0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x3a, 0x0d, 0x61, 0x7a, 0x75, 0x72, 0x65, 0x5f, 0x63, 0x6c,
	0x75, 0x73, 0x74, 0x65, 0x72, 0xda, 0x41, 0x25, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x61,
	0x7a, 0x75, 0x72, 0x65, 0x5f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x2c, 0x61, 0x7a, 0x75,
	0x72, 0x65, 0x5f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x69, 0x64, 0xca, 0x41, 0x21,
	0x0a, 0x0c, 0x41, 0x7a, 0x75, 0x72, 0x65, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x12, 0x11,
	0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x12, 0x86, 0x02, 0x0a, 0x12, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x41, 0x7a, 0x75, 0x72,
	0x65, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x12, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x41,
	0x7a, 0x75, 0x72, 0x65, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67,
	0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x22, 0x96, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x50, 0x32, 0x3f, 0x2f, 0x76, 0x31, 0x2f,
	0x7b, 0x61, 0x7a, 0x75, 0x72, 0x65, 0x5f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x2e, 0x6e,
	0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x7a, 0x75, 0x72, 0x65,
	0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x0d, 0x61, 0x7a, 0x75,
	0x72, 0x65, 0x5f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0xda, 0x41, 0x19, 0x61, 0x7a, 0x75,
	0x72, 0x65, 0x5f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0xca, 0x41, 0x21, 0x0a, 0x0c, 0x41, 0x7a, 0x75, 0x72, 0x65,
	0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0xb7, 0x01, 0x0a, 0x0f, 0x47,
	0x65, 0x74, 0x41, 0x7a, 0x75, 0x72, 0x65, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x12, 0x35,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b,
	0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x47,
	0x65, 0x74, 0x41, 0x7a, 0x75, 0x72, 0x65, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x7a, 0x75, 0x72, 0x65, 0x43, 0x6c, 0x75, 0x73, 0x74,
	0x65, 0x72, 0x22, 0x40, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x33, 0x12, 0x31, 0x2f, 0x76, 0x31, 0x2f,
	0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x7a, 0x75,
	0x72, 0x65, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x12, 0xca, 0x01, 0x0a, 0x11, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x7a, 0x75,
	0x72, 0x65, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x12, 0x37, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c,
	0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x41,
	0x7a, 0x75, 0x72, 0x65, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x7a, 0x75, 0x72, 0x65, 0x43, 0x6c, 0x75,
	0x73, 0x74, 0x65, 0x72, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x42, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x33, 0x12, 0x31, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x61, 0x7a, 0x75, 0x72, 0x65,
	0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x12, 0xdc, 0x01, 0x0a, 0x12, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x41, 0x7a, 0x75, 0x72,
	0x65, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x12, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x41,
	0x7a, 0x75, 0x72, 0x65, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67,
	0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x22, 0x6d, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x33, 0x2a, 0x31, 0x2f, 0x76, 0x31, 0x2f, 0x7b,
	0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x7a, 0x75, 0x72,
	0x65, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0xca, 0x41, 0x2a, 0x0a, 0x15, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x12, 0x11, 0x4f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x12, 0xf8, 0x01, 0x0a, 0x18, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x41, 0x7a, 0x75,
	0x72, 0x65, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x3e, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65,
	0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65,
	0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x41, 0x7a, 0x75, 0x72, 0x65, 0x41, 0x63, 0x63, 0x65, 0x73,
	0x73, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3f, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65,
	0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65,
	0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x41, 0x7a, 0x75, 0x72, 0x65, 0x41, 0x63, 0x63, 0x65, 0x73,
	0x73, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x5b,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x55, 0x12, 0x53, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x61, 0x7a, 0x75,
	0x72, 0x65, 0x5f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x2f, 0x61, 0x7a, 0x75, 0x72, 0x65, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x2f,
	0x2a, 0x7d, 0x3a, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x41, 0x7a, 0x75, 0x72, 0x65,
	0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x9e, 0x02, 0x0a, 0x13,
	0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x41, 0x7a, 0x75, 0x72, 0x65, 0x4e, 0x6f, 0x64, 0x65, 0x50,
	0x6f, 0x6f, 0x6c, 0x12, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x41, 0x7a, 0x75, 0x72, 0x65, 0x4e,
	0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e,
	0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xac, 0x01,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x55, 0x22, 0x42, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x7a, 0x75, 0x72, 0x65,
	0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x61, 0x7a, 0x75, 0x72,
	0x65, 0x4e, 0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x73, 0x3a, 0x0f, 0x61, 0x7a, 0x75, 0x72,
	0x65, 0x5f, 0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x70, 0x6f, 0x6f, 0x6c, 0xda, 0x41, 0x29, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x2c, 0x61, 0x7a, 0x75, 0x72, 0x65, 0x5f, 0x6e, 0x6f, 0x64, 0x65, 0x5f,
	0x70, 0x6f, 0x6f, 0x6c, 0x2c, 0x61, 0x7a, 0x75, 0x72, 0x65, 0x5f, 0x6e, 0x6f, 0x64, 0x65, 0x5f,
	0x70, 0x6f, 0x6f, 0x6c, 0x5f, 0x69, 0x64, 0xca, 0x41, 0x22, 0x0a, 0x0d, 0x41, 0x7a, 0x75, 0x72,
	0x65, 0x4e, 0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0xa0, 0x02, 0x0a,
	0x13, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x41, 0x7a, 0x75, 0x72, 0x65, 0x4e, 0x6f, 0x64, 0x65,
	0x50, 0x6f, 0x6f, 0x6c, 0x12, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x41, 0x7a, 0x75, 0x72, 0x65,
	0x4e, 0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e,
	0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xae,
	0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x65, 0x32, 0x52, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x61, 0x7a,
	0x75, 0x72, 0x65, 0x5f, 0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x70, 0x6f, 0x6f, 0x6c, 0x2e, 0x6e, 0x61,
	0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x7a, 0x75, 0x72, 0x65, 0x43,
	0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x7a, 0x75, 0x72, 0x65, 0x4e,
	0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x0f, 0x61, 0x7a, 0x75,
	0x72, 0x65, 0x5f, 0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x70, 0x6f, 0x6f, 0x6c, 0xda, 0x41, 0x1b, 0x61,
	0x7a, 0x75, 0x72, 0x65, 0x5f, 0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x70, 0x6f, 0x6f, 0x6c, 0x2c, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0xca, 0x41, 0x22, 0x0a, 0x0d, 0x41,
	0x7a, 0x75, 0x72, 0x65, 0x4e, 0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x12, 0x11, 0x4f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12,
	0xcb, 0x01, 0x0a, 0x10, 0x47, 0x65, 0x74, 0x41, 0x7a, 0x75, 0x72, 0x65, 0x4e, 0x6f, 0x64, 0x65,
	0x50, 0x6f, 0x6f, 0x6c, 0x12, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x41, 0x7a, 0x75, 0x72, 0x65, 0x4e, 0x6f, 0x64,
	0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2c, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x6d,
	0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x7a, 0x75,
	0x72, 0x65, 0x4e, 0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x22, 0x51, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x44, 0x12, 0x42, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x7a, 0x75, 0x72, 0x65, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65,
	0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x7a, 0x75, 0x72, 0x65, 0x4e, 0x6f, 0x64, 0x65, 0x50, 0x6f,
	0x6f, 0x6c, 0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0xde, 0x01,
	0x0a, 0x12, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x7a, 0x75, 0x72, 0x65, 0x4e, 0x6f, 0x64, 0x65, 0x50,
	0x6f, 0x6f, 0x6c, 0x73, 0x12, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x7a, 0x75, 0x72, 0x65, 0x4e, 0x6f,
	0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x39,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b,
	0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x4c,
	0x69, 0x73, 0x74, 0x41, 0x7a, 0x75, 0x72, 0x65, 0x4e, 0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c,
	0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x53, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x44, 0x12, 0x42, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x7a, 0x75, 0x72, 0x65, 0x43, 0x6c, 0x75, 0x73, 0x74,
	0x65, 0x72, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x61, 0x7a, 0x75, 0x72, 0x65, 0x4e, 0x6f, 0x64, 0x65,
	0x50, 0x6f, 0x6f, 0x6c, 0x73, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0xef,
	0x01, 0x0a, 0x13, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x41, 0x7a, 0x75, 0x72, 0x65, 0x4e, 0x6f,
	0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x12, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x41, 0x7a, 0x75,
	0x72, 0x65, 0x4e, 0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72,
	0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x22, 0x7e, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x44, 0x2a, 0x42, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e,
	0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x7a, 0x75, 0x72, 0x65,
	0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x7a, 0x75, 0x72, 0x65,
	0x4e, 0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0xca, 0x41, 0x2a, 0x0a, 0x15, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x12, 0x11, 0x4f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x12, 0xc8, 0x01, 0x0a, 0x14, 0x47, 0x65, 0x74, 0x41, 0x7a, 0x75, 0x72, 0x65, 0x53, 0x65, 0x72,
	0x76, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74,
	0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x41, 0x7a, 0x75,
	0x72, 0x65, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x7a, 0x75, 0x72, 0x65, 0x53, 0x65, 0x72, 0x76, 0x65,
	0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0x42, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x35, 0x12,
	0x33, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x2f, 0x61, 0x7a, 0x75, 0x72, 0x65, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x1a, 0x50, 0xca, 0x41, 0x1c,
	0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x2e, 0x68,
	0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x42, 0xe7, 0x01,
	0x0a, 0x21, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x76, 0x31, 0x42, 0x11, 0x41, 0x7a, 0x75, 0x72, 0x65, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x4a, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2f, 0x76, 0x31, 0x3b, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0xaa, 0x02, 0x1d, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x47, 0x6b, 0x65, 0x4d, 0x75, 0x6c, 0x74, 0x69, 0x43, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x56, 0x31, 0xca, 0x02, 0x1d, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c,
	0x6f, 0x75, 0x64, 0x5c, 0x47, 0x6b, 0x65, 0x4d, 0x75, 0x6c, 0x74, 0x69, 0x43, 0x6c, 0x6f, 0x75,
	0x64, 0x5c, 0x56, 0x31, 0xea, 0x02, 0x20, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43,
	0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x47, 0x6b, 0x65, 0x4d, 0x75, 0x6c, 0x74, 0x69, 0x43, 0x6c,
	0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_gkemulticloud_v1_azure_service_proto_rawDescOnce sync.Once
	file_google_cloud_gkemulticloud_v1_azure_service_proto_rawDescData = file_google_cloud_gkemulticloud_v1_azure_service_proto_rawDesc
)

func file_google_cloud_gkemulticloud_v1_azure_service_proto_rawDescGZIP() []byte {
	file_google_cloud_gkemulticloud_v1_azure_service_proto_rawDescOnce.Do(func() {
		file_google_cloud_gkemulticloud_v1_azure_service_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_gkemulticloud_v1_azure_service_proto_rawDescData)
	})
	return file_google_cloud_gkemulticloud_v1_azure_service_proto_rawDescData
}

var file_google_cloud_gkemulticloud_v1_azure_service_proto_msgTypes = make([]protoimpl.MessageInfo, 20)
var file_google_cloud_gkemulticloud_v1_azure_service_proto_goTypes = []interface{}{
	(*CreateAzureClusterRequest)(nil),        // 0: google.cloud.gkemulticloud.v1.CreateAzureClusterRequest
	(*UpdateAzureClusterRequest)(nil),        // 1: google.cloud.gkemulticloud.v1.UpdateAzureClusterRequest
	(*GetAzureClusterRequest)(nil),           // 2: google.cloud.gkemulticloud.v1.GetAzureClusterRequest
	(*ListAzureClustersRequest)(nil),         // 3: google.cloud.gkemulticloud.v1.ListAzureClustersRequest
	(*ListAzureClustersResponse)(nil),        // 4: google.cloud.gkemulticloud.v1.ListAzureClustersResponse
	(*DeleteAzureClusterRequest)(nil),        // 5: google.cloud.gkemulticloud.v1.DeleteAzureClusterRequest
	(*CreateAzureNodePoolRequest)(nil),       // 6: google.cloud.gkemulticloud.v1.CreateAzureNodePoolRequest
	(*UpdateAzureNodePoolRequest)(nil),       // 7: google.cloud.gkemulticloud.v1.UpdateAzureNodePoolRequest
	(*GetAzureNodePoolRequest)(nil),          // 8: google.cloud.gkemulticloud.v1.GetAzureNodePoolRequest
	(*ListAzureNodePoolsRequest)(nil),        // 9: google.cloud.gkemulticloud.v1.ListAzureNodePoolsRequest
	(*ListAzureNodePoolsResponse)(nil),       // 10: google.cloud.gkemulticloud.v1.ListAzureNodePoolsResponse
	(*DeleteAzureNodePoolRequest)(nil),       // 11: google.cloud.gkemulticloud.v1.DeleteAzureNodePoolRequest
	(*GetAzureServerConfigRequest)(nil),      // 12: google.cloud.gkemulticloud.v1.GetAzureServerConfigRequest
	(*CreateAzureClientRequest)(nil),         // 13: google.cloud.gkemulticloud.v1.CreateAzureClientRequest
	(*GetAzureClientRequest)(nil),            // 14: google.cloud.gkemulticloud.v1.GetAzureClientRequest
	(*ListAzureClientsRequest)(nil),          // 15: google.cloud.gkemulticloud.v1.ListAzureClientsRequest
	(*ListAzureClientsResponse)(nil),         // 16: google.cloud.gkemulticloud.v1.ListAzureClientsResponse
	(*DeleteAzureClientRequest)(nil),         // 17: google.cloud.gkemulticloud.v1.DeleteAzureClientRequest
	(*GenerateAzureAccessTokenRequest)(nil),  // 18: google.cloud.gkemulticloud.v1.GenerateAzureAccessTokenRequest
	(*GenerateAzureAccessTokenResponse)(nil), // 19: google.cloud.gkemulticloud.v1.GenerateAzureAccessTokenResponse
	(*AzureCluster)(nil),                     // 20: google.cloud.gkemulticloud.v1.AzureCluster
	(*fieldmaskpb.FieldMask)(nil),            // 21: google.protobuf.FieldMask
	(*AzureNodePool)(nil),                    // 22: google.cloud.gkemulticloud.v1.AzureNodePool
	(*AzureClient)(nil),                      // 23: google.cloud.gkemulticloud.v1.AzureClient
	(*timestamppb.Timestamp)(nil),            // 24: google.protobuf.Timestamp
	(*longrunning.Operation)(nil),            // 25: google.longrunning.Operation
	(*AzureServerConfig)(nil),                // 26: google.cloud.gkemulticloud.v1.AzureServerConfig
}
var file_google_cloud_gkemulticloud_v1_azure_service_proto_depIdxs = []int32{
	20, // 0: google.cloud.gkemulticloud.v1.CreateAzureClusterRequest.azure_cluster:type_name -> google.cloud.gkemulticloud.v1.AzureCluster
	20, // 1: google.cloud.gkemulticloud.v1.UpdateAzureClusterRequest.azure_cluster:type_name -> google.cloud.gkemulticloud.v1.AzureCluster
	21, // 2: google.cloud.gkemulticloud.v1.UpdateAzureClusterRequest.update_mask:type_name -> google.protobuf.FieldMask
	20, // 3: google.cloud.gkemulticloud.v1.ListAzureClustersResponse.azure_clusters:type_name -> google.cloud.gkemulticloud.v1.AzureCluster
	22, // 4: google.cloud.gkemulticloud.v1.CreateAzureNodePoolRequest.azure_node_pool:type_name -> google.cloud.gkemulticloud.v1.AzureNodePool
	22, // 5: google.cloud.gkemulticloud.v1.UpdateAzureNodePoolRequest.azure_node_pool:type_name -> google.cloud.gkemulticloud.v1.AzureNodePool
	21, // 6: google.cloud.gkemulticloud.v1.UpdateAzureNodePoolRequest.update_mask:type_name -> google.protobuf.FieldMask
	22, // 7: google.cloud.gkemulticloud.v1.ListAzureNodePoolsResponse.azure_node_pools:type_name -> google.cloud.gkemulticloud.v1.AzureNodePool
	23, // 8: google.cloud.gkemulticloud.v1.CreateAzureClientRequest.azure_client:type_name -> google.cloud.gkemulticloud.v1.AzureClient
	23, // 9: google.cloud.gkemulticloud.v1.ListAzureClientsResponse.azure_clients:type_name -> google.cloud.gkemulticloud.v1.AzureClient
	24, // 10: google.cloud.gkemulticloud.v1.GenerateAzureAccessTokenResponse.expiration_time:type_name -> google.protobuf.Timestamp
	13, // 11: google.cloud.gkemulticloud.v1.AzureClusters.CreateAzureClient:input_type -> google.cloud.gkemulticloud.v1.CreateAzureClientRequest
	14, // 12: google.cloud.gkemulticloud.v1.AzureClusters.GetAzureClient:input_type -> google.cloud.gkemulticloud.v1.GetAzureClientRequest
	15, // 13: google.cloud.gkemulticloud.v1.AzureClusters.ListAzureClients:input_type -> google.cloud.gkemulticloud.v1.ListAzureClientsRequest
	17, // 14: google.cloud.gkemulticloud.v1.AzureClusters.DeleteAzureClient:input_type -> google.cloud.gkemulticloud.v1.DeleteAzureClientRequest
	0,  // 15: google.cloud.gkemulticloud.v1.AzureClusters.CreateAzureCluster:input_type -> google.cloud.gkemulticloud.v1.CreateAzureClusterRequest
	1,  // 16: google.cloud.gkemulticloud.v1.AzureClusters.UpdateAzureCluster:input_type -> google.cloud.gkemulticloud.v1.UpdateAzureClusterRequest
	2,  // 17: google.cloud.gkemulticloud.v1.AzureClusters.GetAzureCluster:input_type -> google.cloud.gkemulticloud.v1.GetAzureClusterRequest
	3,  // 18: google.cloud.gkemulticloud.v1.AzureClusters.ListAzureClusters:input_type -> google.cloud.gkemulticloud.v1.ListAzureClustersRequest
	5,  // 19: google.cloud.gkemulticloud.v1.AzureClusters.DeleteAzureCluster:input_type -> google.cloud.gkemulticloud.v1.DeleteAzureClusterRequest
	18, // 20: google.cloud.gkemulticloud.v1.AzureClusters.GenerateAzureAccessToken:input_type -> google.cloud.gkemulticloud.v1.GenerateAzureAccessTokenRequest
	6,  // 21: google.cloud.gkemulticloud.v1.AzureClusters.CreateAzureNodePool:input_type -> google.cloud.gkemulticloud.v1.CreateAzureNodePoolRequest
	7,  // 22: google.cloud.gkemulticloud.v1.AzureClusters.UpdateAzureNodePool:input_type -> google.cloud.gkemulticloud.v1.UpdateAzureNodePoolRequest
	8,  // 23: google.cloud.gkemulticloud.v1.AzureClusters.GetAzureNodePool:input_type -> google.cloud.gkemulticloud.v1.GetAzureNodePoolRequest
	9,  // 24: google.cloud.gkemulticloud.v1.AzureClusters.ListAzureNodePools:input_type -> google.cloud.gkemulticloud.v1.ListAzureNodePoolsRequest
	11, // 25: google.cloud.gkemulticloud.v1.AzureClusters.DeleteAzureNodePool:input_type -> google.cloud.gkemulticloud.v1.DeleteAzureNodePoolRequest
	12, // 26: google.cloud.gkemulticloud.v1.AzureClusters.GetAzureServerConfig:input_type -> google.cloud.gkemulticloud.v1.GetAzureServerConfigRequest
	25, // 27: google.cloud.gkemulticloud.v1.AzureClusters.CreateAzureClient:output_type -> google.longrunning.Operation
	23, // 28: google.cloud.gkemulticloud.v1.AzureClusters.GetAzureClient:output_type -> google.cloud.gkemulticloud.v1.AzureClient
	16, // 29: google.cloud.gkemulticloud.v1.AzureClusters.ListAzureClients:output_type -> google.cloud.gkemulticloud.v1.ListAzureClientsResponse
	25, // 30: google.cloud.gkemulticloud.v1.AzureClusters.DeleteAzureClient:output_type -> google.longrunning.Operation
	25, // 31: google.cloud.gkemulticloud.v1.AzureClusters.CreateAzureCluster:output_type -> google.longrunning.Operation
	25, // 32: google.cloud.gkemulticloud.v1.AzureClusters.UpdateAzureCluster:output_type -> google.longrunning.Operation
	20, // 33: google.cloud.gkemulticloud.v1.AzureClusters.GetAzureCluster:output_type -> google.cloud.gkemulticloud.v1.AzureCluster
	4,  // 34: google.cloud.gkemulticloud.v1.AzureClusters.ListAzureClusters:output_type -> google.cloud.gkemulticloud.v1.ListAzureClustersResponse
	25, // 35: google.cloud.gkemulticloud.v1.AzureClusters.DeleteAzureCluster:output_type -> google.longrunning.Operation
	19, // 36: google.cloud.gkemulticloud.v1.AzureClusters.GenerateAzureAccessToken:output_type -> google.cloud.gkemulticloud.v1.GenerateAzureAccessTokenResponse
	25, // 37: google.cloud.gkemulticloud.v1.AzureClusters.CreateAzureNodePool:output_type -> google.longrunning.Operation
	25, // 38: google.cloud.gkemulticloud.v1.AzureClusters.UpdateAzureNodePool:output_type -> google.longrunning.Operation
	22, // 39: google.cloud.gkemulticloud.v1.AzureClusters.GetAzureNodePool:output_type -> google.cloud.gkemulticloud.v1.AzureNodePool
	10, // 40: google.cloud.gkemulticloud.v1.AzureClusters.ListAzureNodePools:output_type -> google.cloud.gkemulticloud.v1.ListAzureNodePoolsResponse
	25, // 41: google.cloud.gkemulticloud.v1.AzureClusters.DeleteAzureNodePool:output_type -> google.longrunning.Operation
	26, // 42: google.cloud.gkemulticloud.v1.AzureClusters.GetAzureServerConfig:output_type -> google.cloud.gkemulticloud.v1.AzureServerConfig
	27, // [27:43] is the sub-list for method output_type
	11, // [11:27] is the sub-list for method input_type
	11, // [11:11] is the sub-list for extension type_name
	11, // [11:11] is the sub-list for extension extendee
	0,  // [0:11] is the sub-list for field type_name
}

func init() { file_google_cloud_gkemulticloud_v1_azure_service_proto_init() }
func file_google_cloud_gkemulticloud_v1_azure_service_proto_init() {
	if File_google_cloud_gkemulticloud_v1_azure_service_proto != nil {
		return
	}
	file_google_cloud_gkemulticloud_v1_azure_resources_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_gkemulticloud_v1_azure_service_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateAzureClusterRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkemulticloud_v1_azure_service_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateAzureClusterRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkemulticloud_v1_azure_service_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetAzureClusterRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkemulticloud_v1_azure_service_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListAzureClustersRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkemulticloud_v1_azure_service_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListAzureClustersResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkemulticloud_v1_azure_service_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteAzureClusterRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkemulticloud_v1_azure_service_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateAzureNodePoolRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkemulticloud_v1_azure_service_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateAzureNodePoolRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkemulticloud_v1_azure_service_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetAzureNodePoolRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkemulticloud_v1_azure_service_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListAzureNodePoolsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkemulticloud_v1_azure_service_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListAzureNodePoolsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkemulticloud_v1_azure_service_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteAzureNodePoolRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkemulticloud_v1_azure_service_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetAzureServerConfigRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkemulticloud_v1_azure_service_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateAzureClientRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkemulticloud_v1_azure_service_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetAzureClientRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkemulticloud_v1_azure_service_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListAzureClientsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkemulticloud_v1_azure_service_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListAzureClientsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkemulticloud_v1_azure_service_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteAzureClientRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkemulticloud_v1_azure_service_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GenerateAzureAccessTokenRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkemulticloud_v1_azure_service_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GenerateAzureAccessTokenResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_gkemulticloud_v1_azure_service_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   20,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_gkemulticloud_v1_azure_service_proto_goTypes,
		DependencyIndexes: file_google_cloud_gkemulticloud_v1_azure_service_proto_depIdxs,
		MessageInfos:      file_google_cloud_gkemulticloud_v1_azure_service_proto_msgTypes,
	}.Build()
	File_google_cloud_gkemulticloud_v1_azure_service_proto = out.File
	file_google_cloud_gkemulticloud_v1_azure_service_proto_rawDesc = nil
	file_google_cloud_gkemulticloud_v1_azure_service_proto_goTypes = nil
	file_google_cloud_gkemulticloud_v1_azure_service_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// AzureClustersClient is the client API for AzureClusters service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type AzureClustersClient interface {
	// Creates a new [AzureClient][google.cloud.gkemulticloud.v1.AzureClient] resource on a given Google Cloud project
	// and region.
	//
	// `AzureClient` resources hold client authentication
	// information needed by the Anthos Multicloud API to manage Azure resources
	// on your Azure subscription on your behalf.
	//
	// If successful, the response contains a newly created
	// [Operation][google.longrunning.Operation] resource that can be
	// described to track the status of the operation.
	CreateAzureClient(ctx context.Context, in *CreateAzureClientRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Describes a specific [AzureClient][google.cloud.gkemulticloud.v1.AzureClient] resource.
	GetAzureClient(ctx context.Context, in *GetAzureClientRequest, opts ...grpc.CallOption) (*AzureClient, error)
	// Lists all [AzureClient][google.cloud.gkemulticloud.v1.AzureClient] resources on a given Google Cloud project and
	// region.
	ListAzureClients(ctx context.Context, in *ListAzureClientsRequest, opts ...grpc.CallOption) (*ListAzureClientsResponse, error)
	// Deletes a specific [AzureClient][google.cloud.gkemulticloud.v1.AzureClient] resource.
	//
	// If the client is used by one or more clusters, deletion will
	// fail and a `FAILED_PRECONDITION` error will be returned.
	//
	// If successful, the response contains a newly created
	// [Operation][google.longrunning.Operation] resource that can be
	// described to track the status of the operation.
	DeleteAzureClient(ctx context.Context, in *DeleteAzureClientRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Creates a new [AzureCluster][google.cloud.gkemulticloud.v1.AzureCluster] resource on a given GCP project and region.
	//
	// If successful, the response contains a newly created
	// [Operation][google.longrunning.Operation] resource that can be
	// described to track the status of the operation.
	CreateAzureCluster(ctx context.Context, in *CreateAzureClusterRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Updates an [AzureCluster][google.cloud.gkemulticloud.v1.AzureCluster].
	UpdateAzureCluster(ctx context.Context, in *UpdateAzureClusterRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Describes a specific [AzureCluster][google.cloud.gkemulticloud.v1.AzureCluster] resource.
	GetAzureCluster(ctx context.Context, in *GetAzureClusterRequest, opts ...grpc.CallOption) (*AzureCluster, error)
	// Lists all [AzureCluster][google.cloud.gkemulticloud.v1.AzureCluster] resources on a given Google Cloud project and
	// region.
	ListAzureClusters(ctx context.Context, in *ListAzureClustersRequest, opts ...grpc.CallOption) (*ListAzureClustersResponse, error)
	// Deletes a specific [AzureCluster][google.cloud.gkemulticloud.v1.AzureCluster] resource.
	//
	// Fails if the cluster has one or more associated [AzureNodePool][google.cloud.gkemulticloud.v1.AzureNodePool]
	// resources.
	//
	// If successful, the response contains a newly created
	// [Operation][google.longrunning.Operation] resource that can be
	// described to track the status of the operation.
	DeleteAzureCluster(ctx context.Context, in *DeleteAzureClusterRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Generates a short-lived access token to authenticate to a given
	// [AzureCluster][google.cloud.gkemulticloud.v1.AzureCluster] resource.
	GenerateAzureAccessToken(ctx context.Context, in *GenerateAzureAccessTokenRequest, opts ...grpc.CallOption) (*GenerateAzureAccessTokenResponse, error)
	// Creates a new [AzureNodePool][google.cloud.gkemulticloud.v1.AzureNodePool], attached to a given [AzureCluster][google.cloud.gkemulticloud.v1.AzureCluster].
	//
	// If successful, the response contains a newly created
	// [Operation][google.longrunning.Operation] resource that can be
	// described to track the status of the operation.
	CreateAzureNodePool(ctx context.Context, in *CreateAzureNodePoolRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Updates an [AzureNodePool][google.cloud.gkemulticloud.v1.AzureNodePool].
	UpdateAzureNodePool(ctx context.Context, in *UpdateAzureNodePoolRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Describes a specific [AzureNodePool][google.cloud.gkemulticloud.v1.AzureNodePool] resource.
	GetAzureNodePool(ctx context.Context, in *GetAzureNodePoolRequest, opts ...grpc.CallOption) (*AzureNodePool, error)
	// Lists all [AzureNodePool][google.cloud.gkemulticloud.v1.AzureNodePool] resources on a given [AzureCluster][google.cloud.gkemulticloud.v1.AzureCluster].
	ListAzureNodePools(ctx context.Context, in *ListAzureNodePoolsRequest, opts ...grpc.CallOption) (*ListAzureNodePoolsResponse, error)
	// Deletes a specific [AzureNodePool][google.cloud.gkemulticloud.v1.AzureNodePool] resource.
	//
	// If successful, the response contains a newly created
	// [Operation][google.longrunning.Operation] resource that can be
	// described to track the status of the operation.
	DeleteAzureNodePool(ctx context.Context, in *DeleteAzureNodePoolRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Returns information, such as supported Azure regions and Kubernetes
	// versions, on a given Google Cloud location.
	GetAzureServerConfig(ctx context.Context, in *GetAzureServerConfigRequest, opts ...grpc.CallOption) (*AzureServerConfig, error)
}

type azureClustersClient struct {
	cc grpc.ClientConnInterface
}

func NewAzureClustersClient(cc grpc.ClientConnInterface) AzureClustersClient {
	return &azureClustersClient{cc}
}

func (c *azureClustersClient) CreateAzureClient(ctx context.Context, in *CreateAzureClientRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.gkemulticloud.v1.AzureClusters/CreateAzureClient", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *azureClustersClient) GetAzureClient(ctx context.Context, in *GetAzureClientRequest, opts ...grpc.CallOption) (*AzureClient, error) {
	out := new(AzureClient)
	err := c.cc.Invoke(ctx, "/google.cloud.gkemulticloud.v1.AzureClusters/GetAzureClient", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *azureClustersClient) ListAzureClients(ctx context.Context, in *ListAzureClientsRequest, opts ...grpc.CallOption) (*ListAzureClientsResponse, error) {
	out := new(ListAzureClientsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.gkemulticloud.v1.AzureClusters/ListAzureClients", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *azureClustersClient) DeleteAzureClient(ctx context.Context, in *DeleteAzureClientRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.gkemulticloud.v1.AzureClusters/DeleteAzureClient", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *azureClustersClient) CreateAzureCluster(ctx context.Context, in *CreateAzureClusterRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.gkemulticloud.v1.AzureClusters/CreateAzureCluster", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *azureClustersClient) UpdateAzureCluster(ctx context.Context, in *UpdateAzureClusterRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.gkemulticloud.v1.AzureClusters/UpdateAzureCluster", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *azureClustersClient) GetAzureCluster(ctx context.Context, in *GetAzureClusterRequest, opts ...grpc.CallOption) (*AzureCluster, error) {
	out := new(AzureCluster)
	err := c.cc.Invoke(ctx, "/google.cloud.gkemulticloud.v1.AzureClusters/GetAzureCluster", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *azureClustersClient) ListAzureClusters(ctx context.Context, in *ListAzureClustersRequest, opts ...grpc.CallOption) (*ListAzureClustersResponse, error) {
	out := new(ListAzureClustersResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.gkemulticloud.v1.AzureClusters/ListAzureClusters", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *azureClustersClient) DeleteAzureCluster(ctx context.Context, in *DeleteAzureClusterRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.gkemulticloud.v1.AzureClusters/DeleteAzureCluster", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *azureClustersClient) GenerateAzureAccessToken(ctx context.Context, in *GenerateAzureAccessTokenRequest, opts ...grpc.CallOption) (*GenerateAzureAccessTokenResponse, error) {
	out := new(GenerateAzureAccessTokenResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.gkemulticloud.v1.AzureClusters/GenerateAzureAccessToken", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *azureClustersClient) CreateAzureNodePool(ctx context.Context, in *CreateAzureNodePoolRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.gkemulticloud.v1.AzureClusters/CreateAzureNodePool", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *azureClustersClient) UpdateAzureNodePool(ctx context.Context, in *UpdateAzureNodePoolRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.gkemulticloud.v1.AzureClusters/UpdateAzureNodePool", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *azureClustersClient) GetAzureNodePool(ctx context.Context, in *GetAzureNodePoolRequest, opts ...grpc.CallOption) (*AzureNodePool, error) {
	out := new(AzureNodePool)
	err := c.cc.Invoke(ctx, "/google.cloud.gkemulticloud.v1.AzureClusters/GetAzureNodePool", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *azureClustersClient) ListAzureNodePools(ctx context.Context, in *ListAzureNodePoolsRequest, opts ...grpc.CallOption) (*ListAzureNodePoolsResponse, error) {
	out := new(ListAzureNodePoolsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.gkemulticloud.v1.AzureClusters/ListAzureNodePools", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *azureClustersClient) DeleteAzureNodePool(ctx context.Context, in *DeleteAzureNodePoolRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.gkemulticloud.v1.AzureClusters/DeleteAzureNodePool", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *azureClustersClient) GetAzureServerConfig(ctx context.Context, in *GetAzureServerConfigRequest, opts ...grpc.CallOption) (*AzureServerConfig, error) {
	out := new(AzureServerConfig)
	err := c.cc.Invoke(ctx, "/google.cloud.gkemulticloud.v1.AzureClusters/GetAzureServerConfig", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// AzureClustersServer is the server API for AzureClusters service.
type AzureClustersServer interface {
	// Creates a new [AzureClient][google.cloud.gkemulticloud.v1.AzureClient] resource on a given Google Cloud project
	// and region.
	//
	// `AzureClient` resources hold client authentication
	// information needed by the Anthos Multicloud API to manage Azure resources
	// on your Azure subscription on your behalf.
	//
	// If successful, the response contains a newly created
	// [Operation][google.longrunning.Operation] resource that can be
	// described to track the status of the operation.
	CreateAzureClient(context.Context, *CreateAzureClientRequest) (*longrunning.Operation, error)
	// Describes a specific [AzureClient][google.cloud.gkemulticloud.v1.AzureClient] resource.
	GetAzureClient(context.Context, *GetAzureClientRequest) (*AzureClient, error)
	// Lists all [AzureClient][google.cloud.gkemulticloud.v1.AzureClient] resources on a given Google Cloud project and
	// region.
	ListAzureClients(context.Context, *ListAzureClientsRequest) (*ListAzureClientsResponse, error)
	// Deletes a specific [AzureClient][google.cloud.gkemulticloud.v1.AzureClient] resource.
	//
	// If the client is used by one or more clusters, deletion will
	// fail and a `FAILED_PRECONDITION` error will be returned.
	//
	// If successful, the response contains a newly created
	// [Operation][google.longrunning.Operation] resource that can be
	// described to track the status of the operation.
	DeleteAzureClient(context.Context, *DeleteAzureClientRequest) (*longrunning.Operation, error)
	// Creates a new [AzureCluster][google.cloud.gkemulticloud.v1.AzureCluster] resource on a given GCP project and region.
	//
	// If successful, the response contains a newly created
	// [Operation][google.longrunning.Operation] resource that can be
	// described to track the status of the operation.
	CreateAzureCluster(context.Context, *CreateAzureClusterRequest) (*longrunning.Operation, error)
	// Updates an [AzureCluster][google.cloud.gkemulticloud.v1.AzureCluster].
	UpdateAzureCluster(context.Context, *UpdateAzureClusterRequest) (*longrunning.Operation, error)
	// Describes a specific [AzureCluster][google.cloud.gkemulticloud.v1.AzureCluster] resource.
	GetAzureCluster(context.Context, *GetAzureClusterRequest) (*AzureCluster, error)
	// Lists all [AzureCluster][google.cloud.gkemulticloud.v1.AzureCluster] resources on a given Google Cloud project and
	// region.
	ListAzureClusters(context.Context, *ListAzureClustersRequest) (*ListAzureClustersResponse, error)
	// Deletes a specific [AzureCluster][google.cloud.gkemulticloud.v1.AzureCluster] resource.
	//
	// Fails if the cluster has one or more associated [AzureNodePool][google.cloud.gkemulticloud.v1.AzureNodePool]
	// resources.
	//
	// If successful, the response contains a newly created
	// [Operation][google.longrunning.Operation] resource that can be
	// described to track the status of the operation.
	DeleteAzureCluster(context.Context, *DeleteAzureClusterRequest) (*longrunning.Operation, error)
	// Generates a short-lived access token to authenticate to a given
	// [AzureCluster][google.cloud.gkemulticloud.v1.AzureCluster] resource.
	GenerateAzureAccessToken(context.Context, *GenerateAzureAccessTokenRequest) (*GenerateAzureAccessTokenResponse, error)
	// Creates a new [AzureNodePool][google.cloud.gkemulticloud.v1.AzureNodePool], attached to a given [AzureCluster][google.cloud.gkemulticloud.v1.AzureCluster].
	//
	// If successful, the response contains a newly created
	// [Operation][google.longrunning.Operation] resource that can be
	// described to track the status of the operation.
	CreateAzureNodePool(context.Context, *CreateAzureNodePoolRequest) (*longrunning.Operation, error)
	// Updates an [AzureNodePool][google.cloud.gkemulticloud.v1.AzureNodePool].
	UpdateAzureNodePool(context.Context, *UpdateAzureNodePoolRequest) (*longrunning.Operation, error)
	// Describes a specific [AzureNodePool][google.cloud.gkemulticloud.v1.AzureNodePool] resource.
	GetAzureNodePool(context.Context, *GetAzureNodePoolRequest) (*AzureNodePool, error)
	// Lists all [AzureNodePool][google.cloud.gkemulticloud.v1.AzureNodePool] resources on a given [AzureCluster][google.cloud.gkemulticloud.v1.AzureCluster].
	ListAzureNodePools(context.Context, *ListAzureNodePoolsRequest) (*ListAzureNodePoolsResponse, error)
	// Deletes a specific [AzureNodePool][google.cloud.gkemulticloud.v1.AzureNodePool] resource.
	//
	// If successful, the response contains a newly created
	// [Operation][google.longrunning.Operation] resource that can be
	// described to track the status of the operation.
	DeleteAzureNodePool(context.Context, *DeleteAzureNodePoolRequest) (*longrunning.Operation, error)
	// Returns information, such as supported Azure regions and Kubernetes
	// versions, on a given Google Cloud location.
	GetAzureServerConfig(context.Context, *GetAzureServerConfigRequest) (*AzureServerConfig, error)
}

// UnimplementedAzureClustersServer can be embedded to have forward compatible implementations.
type UnimplementedAzureClustersServer struct {
}

func (*UnimplementedAzureClustersServer) CreateAzureClient(context.Context, *CreateAzureClientRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateAzureClient not implemented")
}
func (*UnimplementedAzureClustersServer) GetAzureClient(context.Context, *GetAzureClientRequest) (*AzureClient, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetAzureClient not implemented")
}
func (*UnimplementedAzureClustersServer) ListAzureClients(context.Context, *ListAzureClientsRequest) (*ListAzureClientsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListAzureClients not implemented")
}
func (*UnimplementedAzureClustersServer) DeleteAzureClient(context.Context, *DeleteAzureClientRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteAzureClient not implemented")
}
func (*UnimplementedAzureClustersServer) CreateAzureCluster(context.Context, *CreateAzureClusterRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateAzureCluster not implemented")
}
func (*UnimplementedAzureClustersServer) UpdateAzureCluster(context.Context, *UpdateAzureClusterRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateAzureCluster not implemented")
}
func (*UnimplementedAzureClustersServer) GetAzureCluster(context.Context, *GetAzureClusterRequest) (*AzureCluster, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetAzureCluster not implemented")
}
func (*UnimplementedAzureClustersServer) ListAzureClusters(context.Context, *ListAzureClustersRequest) (*ListAzureClustersResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListAzureClusters not implemented")
}
func (*UnimplementedAzureClustersServer) DeleteAzureCluster(context.Context, *DeleteAzureClusterRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteAzureCluster not implemented")
}
func (*UnimplementedAzureClustersServer) GenerateAzureAccessToken(context.Context, *GenerateAzureAccessTokenRequest) (*GenerateAzureAccessTokenResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GenerateAzureAccessToken not implemented")
}
func (*UnimplementedAzureClustersServer) CreateAzureNodePool(context.Context, *CreateAzureNodePoolRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateAzureNodePool not implemented")
}
func (*UnimplementedAzureClustersServer) UpdateAzureNodePool(context.Context, *UpdateAzureNodePoolRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateAzureNodePool not implemented")
}
func (*UnimplementedAzureClustersServer) GetAzureNodePool(context.Context, *GetAzureNodePoolRequest) (*AzureNodePool, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetAzureNodePool not implemented")
}
func (*UnimplementedAzureClustersServer) ListAzureNodePools(context.Context, *ListAzureNodePoolsRequest) (*ListAzureNodePoolsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListAzureNodePools not implemented")
}
func (*UnimplementedAzureClustersServer) DeleteAzureNodePool(context.Context, *DeleteAzureNodePoolRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteAzureNodePool not implemented")
}
func (*UnimplementedAzureClustersServer) GetAzureServerConfig(context.Context, *GetAzureServerConfigRequest) (*AzureServerConfig, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetAzureServerConfig not implemented")
}

func RegisterAzureClustersServer(s *grpc.Server, srv AzureClustersServer) {
	s.RegisterService(&_AzureClusters_serviceDesc, srv)
}

func _AzureClusters_CreateAzureClient_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateAzureClientRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AzureClustersServer).CreateAzureClient(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.gkemulticloud.v1.AzureClusters/CreateAzureClient",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AzureClustersServer).CreateAzureClient(ctx, req.(*CreateAzureClientRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AzureClusters_GetAzureClient_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetAzureClientRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AzureClustersServer).GetAzureClient(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.gkemulticloud.v1.AzureClusters/GetAzureClient",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AzureClustersServer).GetAzureClient(ctx, req.(*GetAzureClientRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AzureClusters_ListAzureClients_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListAzureClientsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AzureClustersServer).ListAzureClients(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.gkemulticloud.v1.AzureClusters/ListAzureClients",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AzureClustersServer).ListAzureClients(ctx, req.(*ListAzureClientsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AzureClusters_DeleteAzureClient_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteAzureClientRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AzureClustersServer).DeleteAzureClient(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.gkemulticloud.v1.AzureClusters/DeleteAzureClient",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AzureClustersServer).DeleteAzureClient(ctx, req.(*DeleteAzureClientRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AzureClusters_CreateAzureCluster_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateAzureClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AzureClustersServer).CreateAzureCluster(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.gkemulticloud.v1.AzureClusters/CreateAzureCluster",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AzureClustersServer).CreateAzureCluster(ctx, req.(*CreateAzureClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AzureClusters_UpdateAzureCluster_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateAzureClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AzureClustersServer).UpdateAzureCluster(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.gkemulticloud.v1.AzureClusters/UpdateAzureCluster",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AzureClustersServer).UpdateAzureCluster(ctx, req.(*UpdateAzureClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AzureClusters_GetAzureCluster_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetAzureClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AzureClustersServer).GetAzureCluster(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.gkemulticloud.v1.AzureClusters/GetAzureCluster",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AzureClustersServer).GetAzureCluster(ctx, req.(*GetAzureClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AzureClusters_ListAzureClusters_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListAzureClustersRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AzureClustersServer).ListAzureClusters(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.gkemulticloud.v1.AzureClusters/ListAzureClusters",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AzureClustersServer).ListAzureClusters(ctx, req.(*ListAzureClustersRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AzureClusters_DeleteAzureCluster_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteAzureClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AzureClustersServer).DeleteAzureCluster(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.gkemulticloud.v1.AzureClusters/DeleteAzureCluster",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AzureClustersServer).DeleteAzureCluster(ctx, req.(*DeleteAzureClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AzureClusters_GenerateAzureAccessToken_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GenerateAzureAccessTokenRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AzureClustersServer).GenerateAzureAccessToken(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.gkemulticloud.v1.AzureClusters/GenerateAzureAccessToken",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AzureClustersServer).GenerateAzureAccessToken(ctx, req.(*GenerateAzureAccessTokenRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AzureClusters_CreateAzureNodePool_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateAzureNodePoolRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AzureClustersServer).CreateAzureNodePool(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.gkemulticloud.v1.AzureClusters/CreateAzureNodePool",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AzureClustersServer).CreateAzureNodePool(ctx, req.(*CreateAzureNodePoolRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AzureClusters_UpdateAzureNodePool_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateAzureNodePoolRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AzureClustersServer).UpdateAzureNodePool(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.gkemulticloud.v1.AzureClusters/UpdateAzureNodePool",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AzureClustersServer).UpdateAzureNodePool(ctx, req.(*UpdateAzureNodePoolRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AzureClusters_GetAzureNodePool_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetAzureNodePoolRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AzureClustersServer).GetAzureNodePool(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.gkemulticloud.v1.AzureClusters/GetAzureNodePool",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AzureClustersServer).GetAzureNodePool(ctx, req.(*GetAzureNodePoolRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AzureClusters_ListAzureNodePools_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListAzureNodePoolsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AzureClustersServer).ListAzureNodePools(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.gkemulticloud.v1.AzureClusters/ListAzureNodePools",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AzureClustersServer).ListAzureNodePools(ctx, req.(*ListAzureNodePoolsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AzureClusters_DeleteAzureNodePool_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteAzureNodePoolRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AzureClustersServer).DeleteAzureNodePool(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.gkemulticloud.v1.AzureClusters/DeleteAzureNodePool",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AzureClustersServer).DeleteAzureNodePool(ctx, req.(*DeleteAzureNodePoolRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AzureClusters_GetAzureServerConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetAzureServerConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AzureClustersServer).GetAzureServerConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.gkemulticloud.v1.AzureClusters/GetAzureServerConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AzureClustersServer).GetAzureServerConfig(ctx, req.(*GetAzureServerConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _AzureClusters_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.gkemulticloud.v1.AzureClusters",
	HandlerType: (*AzureClustersServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateAzureClient",
			Handler:    _AzureClusters_CreateAzureClient_Handler,
		},
		{
			MethodName: "GetAzureClient",
			Handler:    _AzureClusters_GetAzureClient_Handler,
		},
		{
			MethodName: "ListAzureClients",
			Handler:    _AzureClusters_ListAzureClients_Handler,
		},
		{
			MethodName: "DeleteAzureClient",
			Handler:    _AzureClusters_DeleteAzureClient_Handler,
		},
		{
			MethodName: "CreateAzureCluster",
			Handler:    _AzureClusters_CreateAzureCluster_Handler,
		},
		{
			MethodName: "UpdateAzureCluster",
			Handler:    _AzureClusters_UpdateAzureCluster_Handler,
		},
		{
			MethodName: "GetAzureCluster",
			Handler:    _AzureClusters_GetAzureCluster_Handler,
		},
		{
			MethodName: "ListAzureClusters",
			Handler:    _AzureClusters_ListAzureClusters_Handler,
		},
		{
			MethodName: "DeleteAzureCluster",
			Handler:    _AzureClusters_DeleteAzureCluster_Handler,
		},
		{
			MethodName: "GenerateAzureAccessToken",
			Handler:    _AzureClusters_GenerateAzureAccessToken_Handler,
		},
		{
			MethodName: "CreateAzureNodePool",
			Handler:    _AzureClusters_CreateAzureNodePool_Handler,
		},
		{
			MethodName: "UpdateAzureNodePool",
			Handler:    _AzureClusters_UpdateAzureNodePool_Handler,
		},
		{
			MethodName: "GetAzureNodePool",
			Handler:    _AzureClusters_GetAzureNodePool_Handler,
		},
		{
			MethodName: "ListAzureNodePools",
			Handler:    _AzureClusters_ListAzureNodePools_Handler,
		},
		{
			MethodName: "DeleteAzureNodePool",
			Handler:    _AzureClusters_DeleteAzureNodePool_Handler,
		},
		{
			MethodName: "GetAzureServerConfig",
			Handler:    _AzureClusters_GetAzureServerConfig_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/gkemulticloud/v1/azure_service.proto",
}
