// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.31.0
// 	protoc        v4.23.2
// source: google/cloud/gkebackup/v1/gkebackup.proto

package gkebackuppb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	_ "google.golang.org/protobuf/types/known/emptypb"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Represents the metadata of the long-running operation.
type OperationMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The time the operation was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The time the operation finished running.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// Output only. Server-defined resource path for the target of the operation.
	Target string `protobuf:"bytes,3,opt,name=target,proto3" json:"target,omitempty"`
	// Output only. Name of the verb executed by the operation.
	Verb string `protobuf:"bytes,4,opt,name=verb,proto3" json:"verb,omitempty"`
	// Output only. Human-readable status of the operation, if any.
	StatusMessage string `protobuf:"bytes,5,opt,name=status_message,json=statusMessage,proto3" json:"status_message,omitempty"`
	// Output only. Identifies whether the user has requested cancellation
	// of the operation. Operations that have successfully been cancelled
	// have [Operation.error][] value with a
	// [google.rpc.Status.code][google.rpc.Status.code] of 1, corresponding to
	// `Code.CANCELLED`.
	RequestedCancellation bool `protobuf:"varint,6,opt,name=requested_cancellation,json=requestedCancellation,proto3" json:"requested_cancellation,omitempty"`
	// Output only. API version used to start the operation.
	ApiVersion string `protobuf:"bytes,7,opt,name=api_version,json=apiVersion,proto3" json:"api_version,omitempty"`
}

func (x *OperationMetadata) Reset() {
	*x = OperationMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkebackup_v1_gkebackup_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OperationMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OperationMetadata) ProtoMessage() {}

func (x *OperationMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkebackup_v1_gkebackup_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OperationMetadata.ProtoReflect.Descriptor instead.
func (*OperationMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkebackup_v1_gkebackup_proto_rawDescGZIP(), []int{0}
}

func (x *OperationMetadata) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *OperationMetadata) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

func (x *OperationMetadata) GetTarget() string {
	if x != nil {
		return x.Target
	}
	return ""
}

func (x *OperationMetadata) GetVerb() string {
	if x != nil {
		return x.Verb
	}
	return ""
}

func (x *OperationMetadata) GetStatusMessage() string {
	if x != nil {
		return x.StatusMessage
	}
	return ""
}

func (x *OperationMetadata) GetRequestedCancellation() bool {
	if x != nil {
		return x.RequestedCancellation
	}
	return false
}

func (x *OperationMetadata) GetApiVersion() string {
	if x != nil {
		return x.ApiVersion
	}
	return ""
}

// Request message for CreateBackupPlan.
type CreateBackupPlanRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The location within which to create the BackupPlan.
	// Format: `projects/*/locations/*`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The BackupPlan resource object to create.
	BackupPlan *BackupPlan `protobuf:"bytes,2,opt,name=backup_plan,json=backupPlan,proto3" json:"backup_plan,omitempty"`
	// Required. The client-provided short name for the BackupPlan resource.
	// This name must:
	//
	// - be between 1 and 63 characters long (inclusive)
	// - consist of only lower-case ASCII letters, numbers, and dashes
	// - start with a lower-case letter
	// - end with a lower-case letter or number
	// - be unique within the set of BackupPlans in this location
	BackupPlanId string `protobuf:"bytes,3,opt,name=backup_plan_id,json=backupPlanId,proto3" json:"backup_plan_id,omitempty"`
}

func (x *CreateBackupPlanRequest) Reset() {
	*x = CreateBackupPlanRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkebackup_v1_gkebackup_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateBackupPlanRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateBackupPlanRequest) ProtoMessage() {}

func (x *CreateBackupPlanRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkebackup_v1_gkebackup_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateBackupPlanRequest.ProtoReflect.Descriptor instead.
func (*CreateBackupPlanRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkebackup_v1_gkebackup_proto_rawDescGZIP(), []int{1}
}

func (x *CreateBackupPlanRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateBackupPlanRequest) GetBackupPlan() *BackupPlan {
	if x != nil {
		return x.BackupPlan
	}
	return nil
}

func (x *CreateBackupPlanRequest) GetBackupPlanId() string {
	if x != nil {
		return x.BackupPlanId
	}
	return ""
}

// Request message for ListBackupPlans.
type ListBackupPlansRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The location that contains the BackupPlans to list.
	// Format: `projects/*/locations/*`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The target number of results to return in a single response.
	// If not specified, a default value will be chosen by the service.
	// Note that the response may inclue a partial list and a caller should
	// only rely on the response's
	// [next_page_token][google.cloud.gkebackup.v1.ListBackupPlansResponse.next_page_token]
	// to determine if there are more instances left to be queried.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The value of
	// [next_page_token][google.cloud.gkebackup.v1.ListBackupPlansResponse.next_page_token]
	// received from a previous `ListBackupPlans` call.
	// Provide this to retrieve the subsequent page in a multi-page list of
	// results. When paginating, all other parameters provided to
	// `ListBackupPlans` must match the call that provided the page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Field match expression used to filter the results.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// Field by which to sort the results.
	OrderBy string `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
}

func (x *ListBackupPlansRequest) Reset() {
	*x = ListBackupPlansRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkebackup_v1_gkebackup_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListBackupPlansRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListBackupPlansRequest) ProtoMessage() {}

func (x *ListBackupPlansRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkebackup_v1_gkebackup_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListBackupPlansRequest.ProtoReflect.Descriptor instead.
func (*ListBackupPlansRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkebackup_v1_gkebackup_proto_rawDescGZIP(), []int{2}
}

func (x *ListBackupPlansRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListBackupPlansRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListBackupPlansRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListBackupPlansRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListBackupPlansRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

// Response message for ListBackupPlans.
type ListBackupPlansResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of BackupPlans matching the given criteria.
	BackupPlans []*BackupPlan `protobuf:"bytes,1,rep,name=backup_plans,json=backupPlans,proto3" json:"backup_plans,omitempty"`
	// A token which may be sent as
	// [page_token][google.cloud.gkebackup.v1.ListBackupPlansRequest.page_token]
	// in a subsequent `ListBackupPlans` call to retrieve the next page of
	// results. If this field is omitted or empty, then there are no more results
	// to return.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Locations that could not be reached.
	Unreachable []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *ListBackupPlansResponse) Reset() {
	*x = ListBackupPlansResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkebackup_v1_gkebackup_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListBackupPlansResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListBackupPlansResponse) ProtoMessage() {}

func (x *ListBackupPlansResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkebackup_v1_gkebackup_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListBackupPlansResponse.ProtoReflect.Descriptor instead.
func (*ListBackupPlansResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkebackup_v1_gkebackup_proto_rawDescGZIP(), []int{3}
}

func (x *ListBackupPlansResponse) GetBackupPlans() []*BackupPlan {
	if x != nil {
		return x.BackupPlans
	}
	return nil
}

func (x *ListBackupPlansResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListBackupPlansResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// Request message for GetBackupPlan.
type GetBackupPlanRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Fully qualified BackupPlan name.
	// Format: `projects/*/locations/*/backupPlans/*`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetBackupPlanRequest) Reset() {
	*x = GetBackupPlanRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkebackup_v1_gkebackup_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetBackupPlanRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetBackupPlanRequest) ProtoMessage() {}

func (x *GetBackupPlanRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkebackup_v1_gkebackup_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetBackupPlanRequest.ProtoReflect.Descriptor instead.
func (*GetBackupPlanRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkebackup_v1_gkebackup_proto_rawDescGZIP(), []int{4}
}

func (x *GetBackupPlanRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for UpdateBackupPlan.
type UpdateBackupPlanRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. A new version of the BackupPlan resource that contains updated
	// fields. This may be sparsely populated if an `update_mask` is provided.
	BackupPlan *BackupPlan `protobuf:"bytes,1,opt,name=backup_plan,json=backupPlan,proto3" json:"backup_plan,omitempty"`
	// This is used to specify the fields to be overwritten in the
	// BackupPlan targeted for update. The values for each of these
	// updated fields will be taken from the `backup_plan` provided
	// with this request. Field names are relative to the root of the resource
	// (e.g., `description`, `backup_config.include_volume_data`, etc.)
	// If no `update_mask` is provided, all fields in `backup_plan` will be
	// written to the target BackupPlan resource.
	// Note that OUTPUT_ONLY and IMMUTABLE fields in `backup_plan` are ignored
	// and are not used to update the target BackupPlan.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateBackupPlanRequest) Reset() {
	*x = UpdateBackupPlanRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkebackup_v1_gkebackup_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateBackupPlanRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateBackupPlanRequest) ProtoMessage() {}

func (x *UpdateBackupPlanRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkebackup_v1_gkebackup_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateBackupPlanRequest.ProtoReflect.Descriptor instead.
func (*UpdateBackupPlanRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkebackup_v1_gkebackup_proto_rawDescGZIP(), []int{5}
}

func (x *UpdateBackupPlanRequest) GetBackupPlan() *BackupPlan {
	if x != nil {
		return x.BackupPlan
	}
	return nil
}

func (x *UpdateBackupPlanRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request message for DeleteBackupPlan.
type DeleteBackupPlanRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Fully qualified BackupPlan name.
	// Format: `projects/*/locations/*/backupPlans/*`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// If provided, this value must match the current value of the
	// target BackupPlan's [etag][google.cloud.gkebackup.v1.BackupPlan.etag] field
	// or the request is rejected.
	Etag string `protobuf:"bytes,2,opt,name=etag,proto3" json:"etag,omitempty"`
}

func (x *DeleteBackupPlanRequest) Reset() {
	*x = DeleteBackupPlanRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkebackup_v1_gkebackup_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteBackupPlanRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteBackupPlanRequest) ProtoMessage() {}

func (x *DeleteBackupPlanRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkebackup_v1_gkebackup_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteBackupPlanRequest.ProtoReflect.Descriptor instead.
func (*DeleteBackupPlanRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkebackup_v1_gkebackup_proto_rawDescGZIP(), []int{6}
}

func (x *DeleteBackupPlanRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeleteBackupPlanRequest) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

// Request message for CreateBackup.
type CreateBackupRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The BackupPlan within which to create the Backup.
	// Format: `projects/*/locations/*/backupPlans/*`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The Backup resource to create.
	Backup *Backup `protobuf:"bytes,2,opt,name=backup,proto3" json:"backup,omitempty"`
	// The client-provided short name for the Backup resource.
	// This name must:
	//
	// - be between 1 and 63 characters long (inclusive)
	// - consist of only lower-case ASCII letters, numbers, and dashes
	// - start with a lower-case letter
	// - end with a lower-case letter or number
	// - be unique within the set of Backups in this BackupPlan
	BackupId string `protobuf:"bytes,3,opt,name=backup_id,json=backupId,proto3" json:"backup_id,omitempty"`
}

func (x *CreateBackupRequest) Reset() {
	*x = CreateBackupRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkebackup_v1_gkebackup_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateBackupRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateBackupRequest) ProtoMessage() {}

func (x *CreateBackupRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkebackup_v1_gkebackup_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateBackupRequest.ProtoReflect.Descriptor instead.
func (*CreateBackupRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkebackup_v1_gkebackup_proto_rawDescGZIP(), []int{7}
}

func (x *CreateBackupRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateBackupRequest) GetBackup() *Backup {
	if x != nil {
		return x.Backup
	}
	return nil
}

func (x *CreateBackupRequest) GetBackupId() string {
	if x != nil {
		return x.BackupId
	}
	return ""
}

// Request message for ListBackups.
type ListBackupsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The BackupPlan that contains the Backups to list.
	// Format: `projects/*/locations/*/backupPlans/*`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The target number of results to return in a single response.
	// If not specified, a default value will be chosen by the service.
	// Note that the response may inclue a partial list and a caller should
	// only rely on the response's
	// [next_page_token][google.cloud.gkebackup.v1.ListBackupsResponse.next_page_token]
	// to determine if there are more instances left to be queried.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The value of
	// [next_page_token][google.cloud.gkebackup.v1.ListBackupsResponse.next_page_token]
	// received from a previous `ListBackups` call.
	// Provide this to retrieve the subsequent page in a multi-page list of
	// results. When paginating, all other parameters provided to
	// `ListBackups` must match the call that provided the page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Field match expression used to filter the results.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// Field by which to sort the results.
	OrderBy string `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
}

func (x *ListBackupsRequest) Reset() {
	*x = ListBackupsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkebackup_v1_gkebackup_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListBackupsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListBackupsRequest) ProtoMessage() {}

func (x *ListBackupsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkebackup_v1_gkebackup_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListBackupsRequest.ProtoReflect.Descriptor instead.
func (*ListBackupsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkebackup_v1_gkebackup_proto_rawDescGZIP(), []int{8}
}

func (x *ListBackupsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListBackupsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListBackupsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListBackupsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListBackupsRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

// Response message for ListBackups.
type ListBackupsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of Backups matching the given criteria.
	Backups []*Backup `protobuf:"bytes,1,rep,name=backups,proto3" json:"backups,omitempty"`
	// A token which may be sent as
	// [page_token][google.cloud.gkebackup.v1.ListBackupsRequest.page_token] in a
	// subsequent `ListBackups` call to retrieve the next page of results. If this
	// field is omitted or empty, then there are no more results to return.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListBackupsResponse) Reset() {
	*x = ListBackupsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkebackup_v1_gkebackup_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListBackupsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListBackupsResponse) ProtoMessage() {}

func (x *ListBackupsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkebackup_v1_gkebackup_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListBackupsResponse.ProtoReflect.Descriptor instead.
func (*ListBackupsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkebackup_v1_gkebackup_proto_rawDescGZIP(), []int{9}
}

func (x *ListBackupsResponse) GetBackups() []*Backup {
	if x != nil {
		return x.Backups
	}
	return nil
}

func (x *ListBackupsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for GetBackup.
type GetBackupRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Full name of the Backup resource.
	// Format: `projects/*/locations/*/backupPlans/*/backups/*`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetBackupRequest) Reset() {
	*x = GetBackupRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkebackup_v1_gkebackup_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetBackupRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetBackupRequest) ProtoMessage() {}

func (x *GetBackupRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkebackup_v1_gkebackup_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetBackupRequest.ProtoReflect.Descriptor instead.
func (*GetBackupRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkebackup_v1_gkebackup_proto_rawDescGZIP(), []int{10}
}

func (x *GetBackupRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for UpdateBackup.
type UpdateBackupRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. A new version of the Backup resource that contains updated
	// fields. This may be sparsely populated if an `update_mask` is provided.
	Backup *Backup `protobuf:"bytes,1,opt,name=backup,proto3" json:"backup,omitempty"`
	// This is used to specify the fields to be overwritten in the
	// Backup targeted for update. The values for each of these
	// updated fields will be taken from the `backup_plan` provided
	// with this request. Field names are relative to the root of the resource.
	// If no `update_mask` is provided, all fields in `backup` will be
	// written to the target Backup resource.
	// Note that OUTPUT_ONLY and IMMUTABLE fields in `backup` are ignored
	// and are not used to update the target Backup.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateBackupRequest) Reset() {
	*x = UpdateBackupRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkebackup_v1_gkebackup_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateBackupRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateBackupRequest) ProtoMessage() {}

func (x *UpdateBackupRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkebackup_v1_gkebackup_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateBackupRequest.ProtoReflect.Descriptor instead.
func (*UpdateBackupRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkebackup_v1_gkebackup_proto_rawDescGZIP(), []int{11}
}

func (x *UpdateBackupRequest) GetBackup() *Backup {
	if x != nil {
		return x.Backup
	}
	return nil
}

func (x *UpdateBackupRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request message for DeleteBackup.
type DeleteBackupRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the Backup resource.
	// Format: `projects/*/locations/*/backupPlans/*/backups/*`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// If provided, this value must match the current value of the
	// target Backup's [etag][google.cloud.gkebackup.v1.Backup.etag] field or the
	// request is rejected.
	Etag string `protobuf:"bytes,2,opt,name=etag,proto3" json:"etag,omitempty"`
	// If set to true, any VolumeBackups below this Backup will also be deleted.
	// Otherwise, the request will only succeed if the Backup has no
	// VolumeBackups.
	Force bool `protobuf:"varint,3,opt,name=force,proto3" json:"force,omitempty"`
}

func (x *DeleteBackupRequest) Reset() {
	*x = DeleteBackupRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkebackup_v1_gkebackup_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteBackupRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteBackupRequest) ProtoMessage() {}

func (x *DeleteBackupRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkebackup_v1_gkebackup_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteBackupRequest.ProtoReflect.Descriptor instead.
func (*DeleteBackupRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkebackup_v1_gkebackup_proto_rawDescGZIP(), []int{12}
}

func (x *DeleteBackupRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeleteBackupRequest) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

func (x *DeleteBackupRequest) GetForce() bool {
	if x != nil {
		return x.Force
	}
	return false
}

// Request message for ListVolumeBackups.
type ListVolumeBackupsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The Backup that contains the VolumeBackups to list.
	// Format: `projects/*/locations/*/backupPlans/*/backups/*`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The target number of results to return in a single response.
	// If not specified, a default value will be chosen by the service.
	// Note that the response may inclue a partial list and a caller should
	// only rely on the response's
	// [next_page_token][google.cloud.gkebackup.v1.ListVolumeBackupsResponse.next_page_token]
	// to determine if there are more instances left to be queried.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The value of
	// [next_page_token][google.cloud.gkebackup.v1.ListVolumeBackupsResponse.next_page_token]
	// received from a previous `ListVolumeBackups` call.
	// Provide this to retrieve the subsequent page in a multi-page list of
	// results. When paginating, all other parameters provided to
	// `ListVolumeBackups` must match the call that provided the page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Field match expression used to filter the results.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// Field by which to sort the results.
	OrderBy string `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
}

func (x *ListVolumeBackupsRequest) Reset() {
	*x = ListVolumeBackupsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkebackup_v1_gkebackup_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListVolumeBackupsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListVolumeBackupsRequest) ProtoMessage() {}

func (x *ListVolumeBackupsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkebackup_v1_gkebackup_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListVolumeBackupsRequest.ProtoReflect.Descriptor instead.
func (*ListVolumeBackupsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkebackup_v1_gkebackup_proto_rawDescGZIP(), []int{13}
}

func (x *ListVolumeBackupsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListVolumeBackupsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListVolumeBackupsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListVolumeBackupsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListVolumeBackupsRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

// Response message for ListVolumeBackups.
type ListVolumeBackupsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of VolumeBackups matching the given criteria.
	VolumeBackups []*VolumeBackup `protobuf:"bytes,1,rep,name=volume_backups,json=volumeBackups,proto3" json:"volume_backups,omitempty"`
	// A token which may be sent as
	// [page_token][google.cloud.gkebackup.v1.ListVolumeBackupsRequest.page_token]
	// in a subsequent `ListVolumeBackups` call to retrieve the next page of
	// results. If this field is omitted or empty, then there are no more results
	// to return.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListVolumeBackupsResponse) Reset() {
	*x = ListVolumeBackupsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkebackup_v1_gkebackup_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListVolumeBackupsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListVolumeBackupsResponse) ProtoMessage() {}

func (x *ListVolumeBackupsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkebackup_v1_gkebackup_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListVolumeBackupsResponse.ProtoReflect.Descriptor instead.
func (*ListVolumeBackupsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkebackup_v1_gkebackup_proto_rawDescGZIP(), []int{14}
}

func (x *ListVolumeBackupsResponse) GetVolumeBackups() []*VolumeBackup {
	if x != nil {
		return x.VolumeBackups
	}
	return nil
}

func (x *ListVolumeBackupsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for GetVolumeBackup.
type GetVolumeBackupRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Full name of the VolumeBackup resource.
	// Format: `projects/*/locations/*/backupPlans/*/backups/*/volumeBackups/*`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetVolumeBackupRequest) Reset() {
	*x = GetVolumeBackupRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkebackup_v1_gkebackup_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetVolumeBackupRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetVolumeBackupRequest) ProtoMessage() {}

func (x *GetVolumeBackupRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkebackup_v1_gkebackup_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetVolumeBackupRequest.ProtoReflect.Descriptor instead.
func (*GetVolumeBackupRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkebackup_v1_gkebackup_proto_rawDescGZIP(), []int{15}
}

func (x *GetVolumeBackupRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for CreateRestorePlan.
type CreateRestorePlanRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The location within which to create the RestorePlan.
	// Format: `projects/*/locations/*`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The RestorePlan resource object to create.
	RestorePlan *RestorePlan `protobuf:"bytes,2,opt,name=restore_plan,json=restorePlan,proto3" json:"restore_plan,omitempty"`
	// Required. The client-provided short name for the RestorePlan resource.
	// This name must:
	//
	// - be between 1 and 63 characters long (inclusive)
	// - consist of only lower-case ASCII letters, numbers, and dashes
	// - start with a lower-case letter
	// - end with a lower-case letter or number
	// - be unique within the set of RestorePlans in this location
	RestorePlanId string `protobuf:"bytes,3,opt,name=restore_plan_id,json=restorePlanId,proto3" json:"restore_plan_id,omitempty"`
}

func (x *CreateRestorePlanRequest) Reset() {
	*x = CreateRestorePlanRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkebackup_v1_gkebackup_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateRestorePlanRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateRestorePlanRequest) ProtoMessage() {}

func (x *CreateRestorePlanRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkebackup_v1_gkebackup_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateRestorePlanRequest.ProtoReflect.Descriptor instead.
func (*CreateRestorePlanRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkebackup_v1_gkebackup_proto_rawDescGZIP(), []int{16}
}

func (x *CreateRestorePlanRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateRestorePlanRequest) GetRestorePlan() *RestorePlan {
	if x != nil {
		return x.RestorePlan
	}
	return nil
}

func (x *CreateRestorePlanRequest) GetRestorePlanId() string {
	if x != nil {
		return x.RestorePlanId
	}
	return ""
}

// Request message for ListRestorePlans.
type ListRestorePlansRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The location that contains the RestorePlans to list.
	// Format: `projects/*/locations/*`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The target number of results to return in a single response.
	// If not specified, a default value will be chosen by the service.
	// Note that the response may inclue a partial list and a caller should
	// only rely on the response's
	// [next_page_token][google.cloud.gkebackup.v1.ListRestorePlansResponse.next_page_token]
	// to determine if there are more instances left to be queried.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The value of
	// [next_page_token][google.cloud.gkebackup.v1.ListRestorePlansResponse.next_page_token]
	// received from a previous `ListRestorePlans` call.
	// Provide this to retrieve the subsequent page in a multi-page list of
	// results. When paginating, all other parameters provided to
	// `ListRestorePlans` must match the call that provided the page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Field match expression used to filter the results.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// Field by which to sort the results.
	OrderBy string `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
}

func (x *ListRestorePlansRequest) Reset() {
	*x = ListRestorePlansRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkebackup_v1_gkebackup_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListRestorePlansRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListRestorePlansRequest) ProtoMessage() {}

func (x *ListRestorePlansRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkebackup_v1_gkebackup_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListRestorePlansRequest.ProtoReflect.Descriptor instead.
func (*ListRestorePlansRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkebackup_v1_gkebackup_proto_rawDescGZIP(), []int{17}
}

func (x *ListRestorePlansRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListRestorePlansRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListRestorePlansRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListRestorePlansRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListRestorePlansRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

// Response message for ListRestorePlans.
type ListRestorePlansResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of RestorePlans matching the given criteria.
	RestorePlans []*RestorePlan `protobuf:"bytes,1,rep,name=restore_plans,json=restorePlans,proto3" json:"restore_plans,omitempty"`
	// A token which may be sent as
	// [page_token][google.cloud.gkebackup.v1.ListRestorePlansRequest.page_token]
	// in a subsequent `ListRestorePlans` call to retrieve the next page of
	// results. If this field is omitted or empty, then there are no more results
	// to return.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Locations that could not be reached.
	Unreachable []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *ListRestorePlansResponse) Reset() {
	*x = ListRestorePlansResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkebackup_v1_gkebackup_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListRestorePlansResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListRestorePlansResponse) ProtoMessage() {}

func (x *ListRestorePlansResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkebackup_v1_gkebackup_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListRestorePlansResponse.ProtoReflect.Descriptor instead.
func (*ListRestorePlansResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkebackup_v1_gkebackup_proto_rawDescGZIP(), []int{18}
}

func (x *ListRestorePlansResponse) GetRestorePlans() []*RestorePlan {
	if x != nil {
		return x.RestorePlans
	}
	return nil
}

func (x *ListRestorePlansResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListRestorePlansResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// Request message for GetRestorePlan.
type GetRestorePlanRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Fully qualified RestorePlan name.
	// Format: `projects/*/locations/*/restorePlans/*`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetRestorePlanRequest) Reset() {
	*x = GetRestorePlanRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkebackup_v1_gkebackup_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetRestorePlanRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetRestorePlanRequest) ProtoMessage() {}

func (x *GetRestorePlanRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkebackup_v1_gkebackup_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetRestorePlanRequest.ProtoReflect.Descriptor instead.
func (*GetRestorePlanRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkebackup_v1_gkebackup_proto_rawDescGZIP(), []int{19}
}

func (x *GetRestorePlanRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for UpdateRestorePlan.
type UpdateRestorePlanRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. A new version of the RestorePlan resource that contains updated
	// fields. This may be sparsely populated if an `update_mask` is provided.
	RestorePlan *RestorePlan `protobuf:"bytes,1,opt,name=restore_plan,json=restorePlan,proto3" json:"restore_plan,omitempty"`
	// This is used to specify the fields to be overwritten in the
	// RestorePlan targeted for update. The values for each of these
	// updated fields will be taken from the `restore_plan` provided
	// with this request. Field names are relative to the root of the resource.
	// If no `update_mask` is provided, all fields in `restore_plan` will be
	// written to the target RestorePlan resource.
	// Note that OUTPUT_ONLY and IMMUTABLE fields in `restore_plan` are ignored
	// and are not used to update the target RestorePlan.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateRestorePlanRequest) Reset() {
	*x = UpdateRestorePlanRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkebackup_v1_gkebackup_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateRestorePlanRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateRestorePlanRequest) ProtoMessage() {}

func (x *UpdateRestorePlanRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkebackup_v1_gkebackup_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateRestorePlanRequest.ProtoReflect.Descriptor instead.
func (*UpdateRestorePlanRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkebackup_v1_gkebackup_proto_rawDescGZIP(), []int{20}
}

func (x *UpdateRestorePlanRequest) GetRestorePlan() *RestorePlan {
	if x != nil {
		return x.RestorePlan
	}
	return nil
}

func (x *UpdateRestorePlanRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request message for DeleteRestorePlan.
type DeleteRestorePlanRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Fully qualified RestorePlan name.
	// Format: `projects/*/locations/*/restorePlans/*`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// If provided, this value must match the current value of the
	// target RestorePlan's [etag][google.cloud.gkebackup.v1.RestorePlan.etag]
	// field or the request is rejected.
	Etag string `protobuf:"bytes,2,opt,name=etag,proto3" json:"etag,omitempty"`
	// If set to true, any Restores below this RestorePlan will also be deleted.
	// Otherwise, the request will only succeed if the RestorePlan has no
	// Restores.
	Force bool `protobuf:"varint,3,opt,name=force,proto3" json:"force,omitempty"`
}

func (x *DeleteRestorePlanRequest) Reset() {
	*x = DeleteRestorePlanRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkebackup_v1_gkebackup_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteRestorePlanRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteRestorePlanRequest) ProtoMessage() {}

func (x *DeleteRestorePlanRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkebackup_v1_gkebackup_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteRestorePlanRequest.ProtoReflect.Descriptor instead.
func (*DeleteRestorePlanRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkebackup_v1_gkebackup_proto_rawDescGZIP(), []int{21}
}

func (x *DeleteRestorePlanRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeleteRestorePlanRequest) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

func (x *DeleteRestorePlanRequest) GetForce() bool {
	if x != nil {
		return x.Force
	}
	return false
}

// Request message for CreateRestore.
type CreateRestoreRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The RestorePlan within which to create the Restore.
	// Format: `projects/*/locations/*/restorePlans/*`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The restore resource to create.
	Restore *Restore `protobuf:"bytes,2,opt,name=restore,proto3" json:"restore,omitempty"`
	// Required. The client-provided short name for the Restore resource.
	// This name must:
	//
	// - be between 1 and 63 characters long (inclusive)
	// - consist of only lower-case ASCII letters, numbers, and dashes
	// - start with a lower-case letter
	// - end with a lower-case letter or number
	// - be unique within the set of Restores in this RestorePlan.
	RestoreId string `protobuf:"bytes,3,opt,name=restore_id,json=restoreId,proto3" json:"restore_id,omitempty"`
}

func (x *CreateRestoreRequest) Reset() {
	*x = CreateRestoreRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkebackup_v1_gkebackup_proto_msgTypes[22]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateRestoreRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateRestoreRequest) ProtoMessage() {}

func (x *CreateRestoreRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkebackup_v1_gkebackup_proto_msgTypes[22]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateRestoreRequest.ProtoReflect.Descriptor instead.
func (*CreateRestoreRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkebackup_v1_gkebackup_proto_rawDescGZIP(), []int{22}
}

func (x *CreateRestoreRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateRestoreRequest) GetRestore() *Restore {
	if x != nil {
		return x.Restore
	}
	return nil
}

func (x *CreateRestoreRequest) GetRestoreId() string {
	if x != nil {
		return x.RestoreId
	}
	return ""
}

// Request message for ListRestores.
type ListRestoresRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The RestorePlan that contains the Restores to list.
	// Format: `projects/*/locations/*/restorePlans/*`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The target number of results to return in a single response.
	// If not specified, a default value will be chosen by the service.
	// Note that the response may inclue a partial list and a caller should
	// only rely on the response's
	// [next_page_token][google.cloud.gkebackup.v1.ListRestoresResponse.next_page_token]
	// to determine if there are more instances left to be queried.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The value of
	// [next_page_token][google.cloud.gkebackup.v1.ListRestoresResponse.next_page_token]
	// received from a previous `ListRestores` call.
	// Provide this to retrieve the subsequent page in a multi-page list of
	// results. When paginating, all other parameters provided to `ListRestores`
	// must match the call that provided the page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Field match expression used to filter the results.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// Field by which to sort the results.
	OrderBy string `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
}

func (x *ListRestoresRequest) Reset() {
	*x = ListRestoresRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkebackup_v1_gkebackup_proto_msgTypes[23]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListRestoresRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListRestoresRequest) ProtoMessage() {}

func (x *ListRestoresRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkebackup_v1_gkebackup_proto_msgTypes[23]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListRestoresRequest.ProtoReflect.Descriptor instead.
func (*ListRestoresRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkebackup_v1_gkebackup_proto_rawDescGZIP(), []int{23}
}

func (x *ListRestoresRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListRestoresRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListRestoresRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListRestoresRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListRestoresRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

// Response message for ListRestores.
type ListRestoresResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of Restores matching the given criteria.
	Restores []*Restore `protobuf:"bytes,1,rep,name=restores,proto3" json:"restores,omitempty"`
	// A token which may be sent as
	// [page_token][google.cloud.gkebackup.v1.ListRestoresRequest.page_token] in a
	// subsequent `ListRestores` call to retrieve the next page of results. If
	// this field is omitted or empty, then there are no more results to return.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Locations that could not be reached.
	Unreachable []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *ListRestoresResponse) Reset() {
	*x = ListRestoresResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkebackup_v1_gkebackup_proto_msgTypes[24]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListRestoresResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListRestoresResponse) ProtoMessage() {}

func (x *ListRestoresResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkebackup_v1_gkebackup_proto_msgTypes[24]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListRestoresResponse.ProtoReflect.Descriptor instead.
func (*ListRestoresResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkebackup_v1_gkebackup_proto_rawDescGZIP(), []int{24}
}

func (x *ListRestoresResponse) GetRestores() []*Restore {
	if x != nil {
		return x.Restores
	}
	return nil
}

func (x *ListRestoresResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListRestoresResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// Request message for GetRestore.
type GetRestoreRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the restore resource.
	// Format: `projects/*/locations/*/restorePlans/*/restores/*`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetRestoreRequest) Reset() {
	*x = GetRestoreRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkebackup_v1_gkebackup_proto_msgTypes[25]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetRestoreRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetRestoreRequest) ProtoMessage() {}

func (x *GetRestoreRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkebackup_v1_gkebackup_proto_msgTypes[25]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetRestoreRequest.ProtoReflect.Descriptor instead.
func (*GetRestoreRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkebackup_v1_gkebackup_proto_rawDescGZIP(), []int{25}
}

func (x *GetRestoreRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for UpdateRestore.
type UpdateRestoreRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. A new version of the Restore resource that contains updated
	// fields. This may be sparsely populated if an `update_mask` is provided.
	Restore *Restore `protobuf:"bytes,1,opt,name=restore,proto3" json:"restore,omitempty"`
	// This is used to specify the fields to be overwritten in the
	// Restore targeted for update. The values for each of these
	// updated fields will be taken from the `restore` provided
	// with this request. Field names are relative to the root of the resource.
	// If no `update_mask` is provided, all fields in `restore` will be
	// written to the target Restore resource.
	// Note that OUTPUT_ONLY and IMMUTABLE fields in `restore` are ignored
	// and are not used to update the target Restore.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateRestoreRequest) Reset() {
	*x = UpdateRestoreRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkebackup_v1_gkebackup_proto_msgTypes[26]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateRestoreRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateRestoreRequest) ProtoMessage() {}

func (x *UpdateRestoreRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkebackup_v1_gkebackup_proto_msgTypes[26]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateRestoreRequest.ProtoReflect.Descriptor instead.
func (*UpdateRestoreRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkebackup_v1_gkebackup_proto_rawDescGZIP(), []int{26}
}

func (x *UpdateRestoreRequest) GetRestore() *Restore {
	if x != nil {
		return x.Restore
	}
	return nil
}

func (x *UpdateRestoreRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request message for DeleteRestore.
type DeleteRestoreRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Full name of the Restore
	// Format: `projects/*/locations/*/restorePlans/*/restores/*`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// If provided, this value must match the current value of the
	// target Restore's [etag][google.cloud.gkebackup.v1.Restore.etag] field or
	// the request is rejected.
	Etag string `protobuf:"bytes,2,opt,name=etag,proto3" json:"etag,omitempty"`
	// If set to true, any VolumeRestores below this restore will also be deleted.
	// Otherwise, the request will only succeed if the restore has no
	// VolumeRestores.
	Force bool `protobuf:"varint,3,opt,name=force,proto3" json:"force,omitempty"`
}

func (x *DeleteRestoreRequest) Reset() {
	*x = DeleteRestoreRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkebackup_v1_gkebackup_proto_msgTypes[27]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteRestoreRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteRestoreRequest) ProtoMessage() {}

func (x *DeleteRestoreRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkebackup_v1_gkebackup_proto_msgTypes[27]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteRestoreRequest.ProtoReflect.Descriptor instead.
func (*DeleteRestoreRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkebackup_v1_gkebackup_proto_rawDescGZIP(), []int{27}
}

func (x *DeleteRestoreRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeleteRestoreRequest) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

func (x *DeleteRestoreRequest) GetForce() bool {
	if x != nil {
		return x.Force
	}
	return false
}

// Request message for ListVolumeRestores.
type ListVolumeRestoresRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The Restore that contains the VolumeRestores to list.
	// Format: `projects/*/locations/*/restorePlans/*/restores/*`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The target number of results to return in a single response.
	// If not specified, a default value will be chosen by the service.
	// Note that the response may inclue a partial list and a caller should
	// only rely on the response's
	// [next_page_token][google.cloud.gkebackup.v1.ListVolumeRestoresResponse.next_page_token]
	// to determine if there are more instances left to be queried.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The value of
	// [next_page_token][google.cloud.gkebackup.v1.ListVolumeRestoresResponse.next_page_token]
	// received from a previous `ListVolumeRestores` call.
	// Provide this to retrieve the subsequent page in a multi-page list of
	// results. When paginating, all other parameters provided to
	// `ListVolumeRestores` must match the call that provided the page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Field match expression used to filter the results.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// Field by which to sort the results.
	OrderBy string `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
}

func (x *ListVolumeRestoresRequest) Reset() {
	*x = ListVolumeRestoresRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkebackup_v1_gkebackup_proto_msgTypes[28]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListVolumeRestoresRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListVolumeRestoresRequest) ProtoMessage() {}

func (x *ListVolumeRestoresRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkebackup_v1_gkebackup_proto_msgTypes[28]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListVolumeRestoresRequest.ProtoReflect.Descriptor instead.
func (*ListVolumeRestoresRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkebackup_v1_gkebackup_proto_rawDescGZIP(), []int{28}
}

func (x *ListVolumeRestoresRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListVolumeRestoresRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListVolumeRestoresRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListVolumeRestoresRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListVolumeRestoresRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

// Response message for ListVolumeRestores.
type ListVolumeRestoresResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of VolumeRestores matching the given criteria.
	VolumeRestores []*VolumeRestore `protobuf:"bytes,1,rep,name=volume_restores,json=volumeRestores,proto3" json:"volume_restores,omitempty"`
	// A token which may be sent as
	// [page_token][google.cloud.gkebackup.v1.ListVolumeRestoresRequest.page_token]
	// in a subsequent `ListVolumeRestores` call to retrieve the next page of
	// results. If this field is omitted or empty, then there are no more results
	// to return.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListVolumeRestoresResponse) Reset() {
	*x = ListVolumeRestoresResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkebackup_v1_gkebackup_proto_msgTypes[29]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListVolumeRestoresResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListVolumeRestoresResponse) ProtoMessage() {}

func (x *ListVolumeRestoresResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkebackup_v1_gkebackup_proto_msgTypes[29]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListVolumeRestoresResponse.ProtoReflect.Descriptor instead.
func (*ListVolumeRestoresResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkebackup_v1_gkebackup_proto_rawDescGZIP(), []int{29}
}

func (x *ListVolumeRestoresResponse) GetVolumeRestores() []*VolumeRestore {
	if x != nil {
		return x.VolumeRestores
	}
	return nil
}

func (x *ListVolumeRestoresResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for GetVolumeRestore.
type GetVolumeRestoreRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Full name of the VolumeRestore resource.
	// Format: `projects/*/locations/*/restorePlans/*/restores/*/volumeRestores/*`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetVolumeRestoreRequest) Reset() {
	*x = GetVolumeRestoreRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkebackup_v1_gkebackup_proto_msgTypes[30]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetVolumeRestoreRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetVolumeRestoreRequest) ProtoMessage() {}

func (x *GetVolumeRestoreRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkebackup_v1_gkebackup_proto_msgTypes[30]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetVolumeRestoreRequest.ProtoReflect.Descriptor instead.
func (*GetVolumeRestoreRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkebackup_v1_gkebackup_proto_rawDescGZIP(), []int{30}
}

func (x *GetVolumeRestoreRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

var File_google_cloud_gkebackup_v1_gkebackup_proto protoreflect.FileDescriptor

var file_google_cloud_gkebackup_v1_gkebackup_proto_rawDesc = []byte{
	0x0a, 0x29, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x67,
	0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2f, 0x76, 0x31, 0x2f, 0x67, 0x6b, 0x65, 0x62,
	0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x19, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63,
	0x6b, 0x75, 0x70, 0x2e, 0x76, 0x31, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61,
	0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69,
	0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f,
	0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x26, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75,
	0x70, 0x2f, 0x76, 0x31, 0x2f, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x2b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f,
	0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2f, 0x76, 0x31, 0x2f, 0x62, 0x61, 0x63,
	0x6b, 0x75, 0x70, 0x5f, 0x70, 0x6c, 0x61, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x27,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x67, 0x6b, 0x65,
	0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2f, 0x76, 0x31, 0x2f, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2f,
	0x76, 0x31, 0x2f, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x5f, 0x70, 0x6c, 0x61, 0x6e, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x26, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2f, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2f, 0x76, 0x31,
	0x2f, 0x76, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x23, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e,
	0x67, 0x2f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2f, 0x65, 0x6d, 0x70, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x22, 0xd5, 0x02, 0x0a, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a,
	0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x3a, 0x0a, 0x08, 0x65, 0x6e,
	0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x07, 0x65,
	0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x1b, 0x0a, 0x06, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x06, 0x74, 0x61, 0x72,
	0x67, 0x65, 0x74, 0x12, 0x17, 0x0a, 0x04, 0x76, 0x65, 0x72, 0x62, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x76, 0x65, 0x72, 0x62, 0x12, 0x2a, 0x0a, 0x0e,
	0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0d, 0x73, 0x74, 0x61, 0x74, 0x75,
	0x73, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x3a, 0x0a, 0x16, 0x72, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x65, 0x64, 0x5f, 0x63, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x6c, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x15, 0x72,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x65, 0x64, 0x43, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x6c, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x24, 0x0a, 0x0b, 0x61, 0x70, 0x69, 0x5f, 0x76, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a,
	0x61, 0x70, 0x69, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0xd4, 0x01, 0x0a, 0x17, 0x43,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x50, 0x6c, 0x61, 0x6e, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x41, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x4b, 0x0a, 0x0b, 0x62, 0x61, 0x63,
	0x6b, 0x75, 0x70, 0x5f, 0x70, 0x6c, 0x61, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b,
	0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x61, 0x63, 0x6b, 0x75,
	0x70, 0x50, 0x6c, 0x61, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x62, 0x61, 0x63, 0x6b,
	0x75, 0x70, 0x50, 0x6c, 0x61, 0x6e, 0x12, 0x29, 0x0a, 0x0e, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70,
	0x5f, 0x70, 0x6c, 0x61, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x0c, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x50, 0x6c, 0x61, 0x6e, 0x49,
	0x64, 0x22, 0xca, 0x01, 0x0a, 0x16, 0x4c, 0x69, 0x73, 0x74, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70,
	0x50, 0x6c, 0x61, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x41, 0x0a, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12,
	0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a,
	0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x16, 0x0a, 0x06, 0x66,
	0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x66, 0x69, 0x6c,
	0x74, 0x65, 0x72, 0x12, 0x19, 0x0a, 0x08, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f, 0x62, 0x79, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x79, 0x22, 0xad,
	0x01, 0x0a, 0x17, 0x4c, 0x69, 0x73, 0x74, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x50, 0x6c, 0x61,
	0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x48, 0x0a, 0x0c, 0x62, 0x61,
	0x63, 0x6b, 0x75, 0x70, 0x5f, 0x70, 0x6c, 0x61, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x61, 0x63,
	0x6b, 0x75, 0x70, 0x50, 0x6c, 0x61, 0x6e, 0x52, 0x0b, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x50,
	0x6c, 0x61, 0x6e, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67,
	0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e,
	0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x20, 0x0a, 0x0b,
	0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x03, 0x28,
	0x09, 0x52, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x22, 0x57,
	0x0a, 0x14, 0x47, 0x65, 0x74, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x50, 0x6c, 0x61, 0x6e, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3f, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x2b, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x25, 0x0a, 0x23, 0x67, 0x6b,
	0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x50, 0x6c, 0x61,
	0x6e, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xa3, 0x01, 0x0a, 0x17, 0x55, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x50, 0x6c, 0x61, 0x6e, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x4b, 0x0a, 0x0b, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x5f, 0x70, 0x6c,
	0x61, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75,
	0x70, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x50, 0x6c, 0x61, 0x6e, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x50, 0x6c, 0x61, 0x6e,
	0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73,
	0x6b, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0x6e, 0x0a,
	0x17, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x50, 0x6c, 0x61,
	0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3f, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2b, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x25, 0x0a, 0x23,
	0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x50,
	0x6c, 0x61, 0x6e, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x65, 0x74, 0x61,
	0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x65, 0x74, 0x61, 0x67, 0x22, 0xb2, 0x01,
	0x0a, 0x13, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x43, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2b, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x25, 0x0a, 0x23, 0x67,
	0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x50, 0x6c,
	0x61, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x39, 0x0a, 0x06, 0x62, 0x61,
	0x63, 0x6b, 0x75, 0x70, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63,
	0x6b, 0x75, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x52, 0x06, 0x62,
	0x61, 0x63, 0x6b, 0x75, 0x70, 0x12, 0x1b, 0x0a, 0x09, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x5f,
	0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70,
	0x49, 0x64, 0x22, 0xc8, 0x01, 0x0a, 0x12, 0x4c, 0x69, 0x73, 0x74, 0x42, 0x61, 0x63, 0x6b, 0x75,
	0x70, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x43, 0x0a, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2b, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x25, 0x0a, 0x23, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x42, 0x61, 0x63, 0x6b,
	0x75, 0x70, 0x50, 0x6c, 0x61, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b,
	0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70,
	0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x16, 0x0a, 0x06, 0x66, 0x69,
	0x6c, 0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74,
	0x65, 0x72, 0x12, 0x19, 0x0a, 0x08, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f, 0x62, 0x79, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x79, 0x22, 0x7a, 0x0a,
	0x13, 0x4c, 0x69, 0x73, 0x74, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x73, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x12, 0x3b, 0x0a, 0x07, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x73, 0x18,
	0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x76,
	0x31, 0x2e, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x52, 0x07, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70,
	0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74,
	0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74,
	0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x4f, 0x0a, 0x10, 0x47, 0x65, 0x74,
	0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3b, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x27, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x21, 0x0a, 0x1f, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x42, 0x61,
	0x63, 0x6b, 0x75, 0x70, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x92, 0x01, 0x0a, 0x13, 0x55,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x3e, 0x0a, 0x06, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x21, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x42,
	0x61, 0x63, 0x6b, 0x75, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x62, 0x61, 0x63, 0x6b,
	0x75, 0x70, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73,
	0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d,
	0x61, 0x73, 0x6b, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22,
	0x7c, 0x0a, 0x13, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3b, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x27, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x21, 0x0a, 0x1f, 0x67, 0x6b,
	0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x65, 0x74, 0x61, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x04, 0x65, 0x74, 0x61, 0x67, 0x12, 0x14, 0x0a, 0x05, 0x66, 0x6f, 0x72, 0x63, 0x65,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x05, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x22, 0xca, 0x01,
	0x0a, 0x18, 0x4c, 0x69, 0x73, 0x74, 0x56, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x42, 0x61, 0x63, 0x6b,
	0x75, 0x70, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3f, 0x0a, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x27, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x21, 0x0a, 0x1f, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x42, 0x61, 0x63,
	0x6b, 0x75, 0x70, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70,
	0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08,
	0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65,
	0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61,
	0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x16, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65,
	0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12,
	0x19, 0x0a, 0x08, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f, 0x62, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x07, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x79, 0x22, 0x93, 0x01, 0x0a, 0x19, 0x4c,
	0x69, 0x73, 0x74, 0x56, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x73,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x4e, 0x0a, 0x0e, 0x76, 0x6f, 0x6c, 0x75,
	0x6d, 0x65, 0x5f, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x6f, 0x6c,
	0x75, 0x6d, 0x65, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x52, 0x0d, 0x76, 0x6f, 0x6c, 0x75, 0x6d,
	0x65, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74,
	0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e,
	0x22, 0x5b, 0x0a, 0x16, 0x47, 0x65, 0x74, 0x56, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x42, 0x61, 0x63,
	0x6b, 0x75, 0x70, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x41, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2d, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x27,
	0x0a, 0x25, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x56, 0x6f, 0x6c, 0x75, 0x6d,
	0x65, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xda, 0x01,
	0x0a, 0x18, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x50,
	0x6c, 0x61, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x41, 0x0a, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x23, 0x0a, 0x21, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x4e, 0x0a,
	0x0c, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x5f, 0x70, 0x6c, 0x61, 0x6e, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x76, 0x31, 0x2e,
	0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x50, 0x6c, 0x61, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x0b, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x50, 0x6c, 0x61, 0x6e, 0x12, 0x2b, 0x0a,
	0x0f, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x5f, 0x70, 0x6c, 0x61, 0x6e, 0x5f, 0x69, 0x64,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0d, 0x72, 0x65, 0x73,
	0x74, 0x6f, 0x72, 0x65, 0x50, 0x6c, 0x61, 0x6e, 0x49, 0x64, 0x22, 0xcb, 0x01, 0x0a, 0x17, 0x4c,
	0x69, 0x73, 0x74, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x50, 0x6c, 0x61, 0x6e, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x41, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67,
	0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61,
	0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74,
	0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65,
	0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x16, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x19, 0x0a,
	0x08, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f, 0x62, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x07, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x79, 0x22, 0xb1, 0x01, 0x0a, 0x18, 0x4c, 0x69, 0x73,
	0x74, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x50, 0x6c, 0x61, 0x6e, 0x73, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x4b, 0x0a, 0x0d, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65,
	0x5f, 0x70, 0x6c, 0x61, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x62,
	0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65,
	0x50, 0x6c, 0x61, 0x6e, 0x52, 0x0c, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x50, 0x6c, 0x61,
	0x6e, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f,
	0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78,
	0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x20, 0x0a, 0x0b, 0x75, 0x6e,
	0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52,
	0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x22, 0x59, 0x0a, 0x15,
	0x47, 0x65, 0x74, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x50, 0x6c, 0x61, 0x6e, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x40, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x2c, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x26, 0x0a, 0x24, 0x67, 0x6b, 0x65,
	0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x50, 0x6c, 0x61,
	0x6e, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xa7, 0x01, 0x0a, 0x18, 0x55, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x50, 0x6c, 0x61, 0x6e, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x4e, 0x0a, 0x0c, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x5f,
	0x70, 0x6c, 0x61, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63,
	0x6b, 0x75, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x50, 0x6c,
	0x61, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65,
	0x50, 0x6c, 0x61, 0x6e, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d,
	0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c,
	0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73,
	0x6b, 0x22, 0x86, 0x01, 0x0a, 0x18, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x52, 0x65, 0x73, 0x74,
	0x6f, 0x72, 0x65, 0x50, 0x6c, 0x61, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x40,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2c, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x26, 0x0a, 0x24, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52,
	0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x50, 0x6c, 0x61, 0x6e, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x12, 0x12, 0x0a, 0x04, 0x65, 0x74, 0x61, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04,
	0x65, 0x74, 0x61, 0x67, 0x12, 0x14, 0x0a, 0x05, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x08, 0x52, 0x05, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x22, 0xc3, 0x01, 0x0a, 0x14, 0x43,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x44, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x2c, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x26, 0x0a, 0x24, 0x67, 0x6b, 0x65,
	0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x50, 0x6c, 0x61,
	0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x41, 0x0a, 0x07, 0x72, 0x65, 0x73,
	0x74, 0x6f, 0x72, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63,
	0x6b, 0x75, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x07, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x12, 0x22, 0x0a, 0x0a,
	0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x49, 0x64,
	0x22, 0xca, 0x01, 0x0a, 0x13, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x44, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2c, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x26,
	0x0a, 0x24, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x65, 0x73, 0x74, 0x6f,
	0x72, 0x65, 0x50, 0x6c, 0x61, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b,
	0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70,
	0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x16, 0x0a, 0x06, 0x66, 0x69,
	0x6c, 0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74,
	0x65, 0x72, 0x12, 0x19, 0x0a, 0x08, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f, 0x62, 0x79, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x79, 0x22, 0xa0, 0x01,
	0x0a, 0x14, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x73, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x3e, 0x0a, 0x08, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72,
	0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75,
	0x70, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x52, 0x08, 0x72, 0x65,
	0x73, 0x74, 0x6f, 0x72, 0x65, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70,
	0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x20,
	0x0a, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x03, 0x20,
	0x03, 0x28, 0x09, 0x52, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65,
	0x22, 0x51, 0x0a, 0x11, 0x47, 0x65, 0x74, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3c, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x28, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x22, 0x0a, 0x20, 0x67, 0x6b, 0x65,
	0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x22, 0x96, 0x01, 0x0a, 0x14, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x52, 0x65,
	0x73, 0x74, 0x6f, 0x72, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x41, 0x0a, 0x07,
	0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65,
	0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72,
	0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x07, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x12,
	0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b,
	0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0x7e, 0x0a, 0x14,
	0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x3c, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x28, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x22, 0x0a, 0x20, 0x67, 0x6b, 0x65, 0x62,
	0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x65, 0x74, 0x61, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x04, 0x65, 0x74, 0x61, 0x67, 0x12, 0x14, 0x0a, 0x05, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x05, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x22, 0xcc, 0x01, 0x0a,
	0x19, 0x4c, 0x69, 0x73, 0x74, 0x56, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x52, 0x65, 0x73, 0x74, 0x6f,
	0x72, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x40, 0x0a, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x28, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x22, 0x0a, 0x20, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x65, 0x73,
	0x74, 0x6f, 0x72, 0x65, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09,
	0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52,
	0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67,
	0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70,
	0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x16, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74,
	0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72,
	0x12, 0x19, 0x0a, 0x08, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f, 0x62, 0x79, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x07, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x79, 0x22, 0x97, 0x01, 0x0a, 0x1a,
	0x4c, 0x69, 0x73, 0x74, 0x56, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72,
	0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x51, 0x0a, 0x0f, 0x76, 0x6f,
	0x6c, 0x75, 0x6d, 0x65, 0x5f, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x73, 0x18, 0x01, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x76, 0x31, 0x2e,
	0x56, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x52, 0x0e, 0x76,
	0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x73, 0x12, 0x26, 0x0a,
	0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65,
	0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x5d, 0x0a, 0x17, 0x47, 0x65, 0x74, 0x56, 0x6f, 0x6c, 0x75,
	0x6d, 0x65, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x42, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2e,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x28, 0x0a, 0x26, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75,
	0x70, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x56, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x52, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x32, 0xc5, 0x28, 0x0a, 0x0c, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x46,
	0x6f, 0x72, 0x47, 0x4b, 0x45, 0x12, 0xf2, 0x01, 0x0a, 0x10, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x50, 0x6c, 0x61, 0x6e, 0x12, 0x32, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63,
	0x6b, 0x75, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x42, 0x61, 0x63,
	0x6b, 0x75, 0x70, 0x50, 0x6c, 0x61, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e,
	0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x8a, 0x01,
	0xca, 0x41, 0x1f, 0x0a, 0x0a, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x50, 0x6c, 0x61, 0x6e, 0x12,
	0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0xda, 0x41, 0x21, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x62, 0x61, 0x63, 0x6b,
	0x75, 0x70, 0x5f, 0x70, 0x6c, 0x61, 0x6e, 0x2c, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x5f, 0x70,
	0x6c, 0x61, 0x6e, 0x5f, 0x69, 0x64, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3e, 0x3a, 0x0b, 0x62, 0x61,
	0x63, 0x6b, 0x75, 0x70, 0x5f, 0x70, 0x6c, 0x61, 0x6e, 0x22, 0x2f, 0x2f, 0x76, 0x31, 0x2f, 0x7b,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x62,
	0x61, 0x63, 0x6b, 0x75, 0x70, 0x50, 0x6c, 0x61, 0x6e, 0x73, 0x12, 0xba, 0x01, 0x0a, 0x0f, 0x4c,
	0x69, 0x73, 0x74, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x50, 0x6c, 0x61, 0x6e, 0x73, 0x12, 0x31,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b,
	0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x42,
	0x61, 0x63, 0x6b, 0x75, 0x70, 0x50, 0x6c, 0x61, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69,
	0x73, 0x74, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x50, 0x6c, 0x61, 0x6e, 0x73, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x40, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x31, 0x12, 0x2f, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x62, 0x61, 0x63, 0x6b,
	0x75, 0x70, 0x50, 0x6c, 0x61, 0x6e, 0x73, 0x12, 0xa7, 0x01, 0x0a, 0x0d, 0x47, 0x65, 0x74, 0x42,
	0x61, 0x63, 0x6b, 0x75, 0x70, 0x50, 0x6c, 0x61, 0x6e, 0x12, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b,
	0x75, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x50,
	0x6c, 0x61, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x25, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63,
	0x6b, 0x75, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x50, 0x6c, 0x61,
	0x6e, 0x22, 0x3e, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x31,
	0x12, 0x2f, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x2f, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x50, 0x6c, 0x61, 0x6e, 0x73, 0x2f, 0x2a,
	0x7d, 0x12, 0xf4, 0x01, 0x0a, 0x10, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x42, 0x61, 0x63, 0x6b,
	0x75, 0x70, 0x50, 0x6c, 0x61, 0x6e, 0x12, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e,
	0x76, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x50,
	0x6c, 0x61, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e,
	0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x8c, 0x01, 0xca, 0x41, 0x1f, 0x0a,
	0x0a, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x50, 0x6c, 0x61, 0x6e, 0x12, 0x11, 0x4f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41,
	0x17, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x5f, 0x70, 0x6c, 0x61, 0x6e, 0x2c, 0x75, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x4a, 0x3a, 0x0b,
	0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x5f, 0x70, 0x6c, 0x61, 0x6e, 0x32, 0x3b, 0x2f, 0x76, 0x31,
	0x2f, 0x7b, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x5f, 0x70, 0x6c, 0x61, 0x6e, 0x2e, 0x6e, 0x61,
	0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70,
	0x50, 0x6c, 0x61, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xd2, 0x01, 0x0a, 0x10, 0x44, 0x65, 0x6c,
	0x65, 0x74, 0x65, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x50, 0x6c, 0x61, 0x6e, 0x12, 0x32, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65,
	0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65,
	0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x50, 0x6c, 0x61, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72,
	0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x22, 0x6b, 0xca, 0x41, 0x2a, 0x0a, 0x15, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x12, 0x11, 0x4f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda,
	0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x31, 0x2a, 0x2f, 0x2f, 0x76,
	0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x62,
	0x61, 0x63, 0x6b, 0x75, 0x70, 0x50, 0x6c, 0x61, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xe1, 0x01,
	0x0a, 0x0c, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x12, 0x2e,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b,
	0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e,
	0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x81, 0x01,
	0xca, 0x41, 0x1b, 0x0a, 0x06, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x12, 0x11, 0x4f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41,
	0x17, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2c, 0x62,
	0x61, 0x63, 0x6b, 0x75, 0x70, 0x5f, 0x69, 0x64, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x43, 0x3a, 0x06,
	0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x22, 0x39, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x62, 0x61, 0x63, 0x6b, 0x75,
	0x70, 0x50, 0x6c, 0x61, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70,
	0x73, 0x12, 0xb8, 0x01, 0x0a, 0x0b, 0x4c, 0x69, 0x73, 0x74, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70,
	0x73, 0x12, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69,
	0x73, 0x74, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73,
	0x74, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x22, 0x4a, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x3b, 0x12, 0x39, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x50, 0x6c, 0x61, 0x6e,
	0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x73, 0x12, 0xa5, 0x01, 0x0a,
	0x09, 0x47, 0x65, 0x74, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x12, 0x2b, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63,
	0x6b, 0x75, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x21, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70,
	0x2e, 0x76, 0x31, 0x2e, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x22, 0x48, 0xda, 0x41, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3b, 0x12, 0x39, 0x2f, 0x76, 0x31, 0x2f, 0x7b,
	0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x62, 0x61, 0x63, 0x6b,
	0x75, 0x70, 0x50, 0x6c, 0x61, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70,
	0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xe3, 0x01, 0x0a, 0x0c, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x42,
	0x61, 0x63, 0x6b, 0x75, 0x70, 0x12, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x76,
	0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c,
	0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x22, 0x83, 0x01, 0xca, 0x41, 0x1b, 0x0a, 0x06, 0x42, 0x61, 0x63, 0x6b,
	0x75, 0x70, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x12, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2c, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x4a,
	0x3a, 0x06, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x32, 0x40, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x62,
	0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x2f, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x50, 0x6c, 0x61, 0x6e, 0x73, 0x2f, 0x2a, 0x2f,
	0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xd4, 0x01, 0x0a, 0x0c, 0x44,
	0x65, 0x6c, 0x65, 0x74, 0x65, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x12, 0x2e, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x62, 0x61,
	0x63, 0x6b, 0x75, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x42, 0x61,
	0x63, 0x6b, 0x75, 0x70, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67,
	0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x75, 0xca, 0x41, 0x2a, 0x0a,
	0x15, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3b, 0x2a, 0x39, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d,
	0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x50,
	0x6c, 0x61, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x73, 0x2f, 0x2a,
	0x7d, 0x12, 0xda, 0x01, 0x0a, 0x11, 0x4c, 0x69, 0x73, 0x74, 0x56, 0x6f, 0x6c, 0x75, 0x6d, 0x65,
	0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x73, 0x12, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70,
	0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x56, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x42, 0x61,
	0x63, 0x6b, 0x75, 0x70, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x34, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x62,
	0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x56, 0x6f, 0x6c,
	0x75, 0x6d, 0x65, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x22, 0x5a, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x4b, 0x12, 0x49, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x50, 0x6c,
	0x61, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x73, 0x2f, 0x2a, 0x7d,
	0x2f, 0x76, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x73, 0x12, 0xc7,
	0x01, 0x0a, 0x0f, 0x47, 0x65, 0x74, 0x56, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x42, 0x61, 0x63, 0x6b,
	0x75, 0x70, 0x12, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x47,
	0x65, 0x74, 0x56, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x76,
	0x31, 0x2e, 0x56, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x22, 0x58,
	0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x4b, 0x12, 0x49, 0x2f,
	0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f,
	0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x50, 0x6c, 0x61, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x62, 0x61,
	0x63, 0x6b, 0x75, 0x70, 0x73, 0x2f, 0x2a, 0x2f, 0x76, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x42, 0x61,
	0x63, 0x6b, 0x75, 0x70, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xf9, 0x01, 0x0a, 0x11, 0x43, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x50, 0x6c, 0x61, 0x6e, 0x12, 0x33,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b,
	0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x50, 0x6c, 0x61, 0x6e, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e,
	0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x22, 0x8f, 0x01, 0xca, 0x41, 0x20, 0x0a, 0x0b, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72,
	0x65, 0x50, 0x6c, 0x61, 0x6e, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x23, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x2c, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x5f, 0x70, 0x6c, 0x61, 0x6e, 0x2c, 0x72,
	0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x5f, 0x70, 0x6c, 0x61, 0x6e, 0x5f, 0x69, 0x64, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x40, 0x3a, 0x0c, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x5f, 0x70, 0x6c,
	0x61, 0x6e, 0x22, 0x30, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x50,
	0x6c, 0x61, 0x6e, 0x73, 0x12, 0xbe, 0x01, 0x0a, 0x10, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x73,
	0x74, 0x6f, 0x72, 0x65, 0x50, 0x6c, 0x61, 0x6e, 0x73, 0x12, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b,
	0x75, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72,
	0x65, 0x50, 0x6c, 0x61, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x33, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65,
	0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65,
	0x73, 0x74, 0x6f, 0x72, 0x65, 0x50, 0x6c, 0x61, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x22, 0x41, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x32, 0x12, 0x30, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65,
	0x50, 0x6c, 0x61, 0x6e, 0x73, 0x12, 0xab, 0x01, 0x0a, 0x0e, 0x47, 0x65, 0x74, 0x52, 0x65, 0x73,
	0x74, 0x6f, 0x72, 0x65, 0x50, 0x6c, 0x61, 0x6e, 0x12, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75,
	0x70, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x50,
	0x6c, 0x61, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x26, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63,
	0x6b, 0x75, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x50, 0x6c,
	0x61, 0x6e, 0x22, 0x3f, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x32, 0x12, 0x30, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x50, 0x6c, 0x61, 0x6e, 0x73,
	0x2f, 0x2a, 0x7d, 0x12, 0xfb, 0x01, 0x0a, 0x11, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x52, 0x65,
	0x73, 0x74, 0x6f, 0x72, 0x65, 0x50, 0x6c, 0x61, 0x6e, 0x12, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b,
	0x75, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x52, 0x65, 0x73, 0x74,
	0x6f, 0x72, 0x65, 0x50, 0x6c, 0x61, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e,
	0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x91, 0x01,
	0xca, 0x41, 0x20, 0x0a, 0x0b, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x50, 0x6c, 0x61, 0x6e,
	0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0xda, 0x41, 0x18, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x5f, 0x70, 0x6c,
	0x61, 0x6e, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x4d, 0x3a, 0x0c, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x5f, 0x70, 0x6c,
	0x61, 0x6e, 0x32, 0x3d, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65,
	0x5f, 0x70, 0x6c, 0x61, 0x6e, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x2f, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x50, 0x6c, 0x61, 0x6e, 0x73, 0x2f, 0x2a,
	0x7d, 0x12, 0xd5, 0x01, 0x0a, 0x11, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x52, 0x65, 0x73, 0x74,
	0x6f, 0x72, 0x65, 0x50, 0x6c, 0x61, 0x6e, 0x12, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70,
	0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72,
	0x65, 0x50, 0x6c, 0x61, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e,
	0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x6c, 0xca, 0x41, 0x2a,
	0x0a, 0x15, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x32, 0x2a, 0x30, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61,
	0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72,
	0x65, 0x50, 0x6c, 0x61, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xe9, 0x01, 0x0a, 0x0d, 0x43, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x12, 0x2f, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x62, 0x61,
	0x63, 0x6b, 0x75, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x52, 0x65,
	0x73, 0x74, 0x6f, 0x72, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e,
	0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x87, 0x01, 0xca, 0x41,
	0x1c, 0x0a, 0x07, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x19,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2c, 0x72,
	0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x5f, 0x69, 0x64, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x46, 0x3a,
	0x07, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x22, 0x3b, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x65, 0x73,
	0x74, 0x6f, 0x72, 0x65, 0x50, 0x6c, 0x61, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x72, 0x65, 0x73,
	0x74, 0x6f, 0x72, 0x65, 0x73, 0x12, 0xbd, 0x01, 0x0a, 0x0c, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65,
	0x73, 0x74, 0x6f, 0x72, 0x65, 0x73, 0x12, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e,
	0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e,
	0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x4c, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3d, 0x12, 0x3b, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x65, 0x73,
	0x74, 0x6f, 0x72, 0x65, 0x50, 0x6c, 0x61, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x72, 0x65, 0x73,
	0x74, 0x6f, 0x72, 0x65, 0x73, 0x12, 0xaa, 0x01, 0x0a, 0x0a, 0x47, 0x65, 0x74, 0x52, 0x65, 0x73,
	0x74, 0x6f, 0x72, 0x65, 0x12, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x76, 0x31,
	0x2e, 0x47, 0x65, 0x74, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x52,
	0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x22, 0x4a, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x3d, 0x12, 0x3b, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65,
	0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x50,
	0x6c, 0x61, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x73, 0x2f,
	0x2a, 0x7d, 0x12, 0xeb, 0x01, 0x0a, 0x0d, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x52, 0x65, 0x73,
	0x74, 0x6f, 0x72, 0x65, 0x12, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x76, 0x31,
	0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c,
	0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x22, 0x89, 0x01, 0xca, 0x41, 0x1c, 0x0a, 0x07, 0x52, 0x65, 0x73, 0x74,
	0x6f, 0x72, 0x65, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x13, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65,
	0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x4e, 0x3a, 0x07, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x32, 0x43, 0x2f, 0x76, 0x31,
	0x2f, 0x7b, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x50, 0x6c, 0x61,
	0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x73, 0x2f, 0x2a, 0x7d,
	0x12, 0xd8, 0x01, 0x0a, 0x0d, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x52, 0x65, 0x73, 0x74, 0x6f,
	0x72, 0x65, 0x12, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x44,
	0x65, 0x6c, 0x65, 0x74, 0x65, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e,
	0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x22, 0x77, 0xca, 0x41, 0x2a, 0x0a, 0x15, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x12, 0x11,
	0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3d, 0x2a, 0x3b,
	0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x2f, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x50, 0x6c, 0x61, 0x6e, 0x73, 0x2f, 0x2a, 0x2f,
	0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xe0, 0x01, 0x0a, 0x12,
	0x4c, 0x69, 0x73, 0x74, 0x56, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72,
	0x65, 0x73, 0x12, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x4c,
	0x69, 0x73, 0x74, 0x56, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75,
	0x70, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x56, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x52,
	0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22,
	0x5d, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x4e,
	0x12, 0x4c, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x50, 0x6c, 0x61, 0x6e,
	0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f,
	0x76, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x73, 0x12, 0xcd,
	0x01, 0x0a, 0x10, 0x47, 0x65, 0x74, 0x56, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x52, 0x65, 0x73, 0x74,
	0x6f, 0x72, 0x65, 0x12, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x76, 0x31, 0x2e,
	0x47, 0x65, 0x74, 0x56, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70,
	0x2e, 0x76, 0x31, 0x2e, 0x56, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72,
	0x65, 0x22, 0x5b, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x4e,
	0x12, 0x4c, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x2f, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x50, 0x6c, 0x61, 0x6e, 0x73, 0x2f,
	0x2a, 0x2f, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x76, 0x6f, 0x6c,
	0x75, 0x6d, 0x65, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x1a, 0x4c,
	0xca, 0x41, 0x18, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x2e, 0x68, 0x74,
	0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x42, 0xa1, 0x03, 0xea,
	0x41, 0x5e, 0x0a, 0x20, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6c, 0x75,
	0x73, 0x74, 0x65, 0x72, 0x12, 0x3a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x63, 0x6c,
	0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x2f, 0x7b, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x7d,
	0xea, 0x41, 0x78, 0x0a, 0x21, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x6b, 0x6d, 0x73, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x72, 0x79,
	0x70, 0x74, 0x6f, 0x4b, 0x65, 0x79, 0x12, 0x53, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f,
	0x6b, 0x65, 0x79, 0x52, 0x69, 0x6e, 0x67, 0x73, 0x2f, 0x7b, 0x6b, 0x65, 0x79, 0x5f, 0x72, 0x69,
	0x6e, 0x67, 0x7d, 0x2f, 0x63, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x4b, 0x65, 0x79, 0x73, 0x2f, 0x7b,
	0x63, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x5f, 0x6b, 0x65, 0x79, 0x7d, 0x0a, 0x1d, 0x63, 0x6f, 0x6d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b,
	0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x76, 0x31, 0x42, 0x0e, 0x47, 0x4b, 0x45, 0x42,
	0x61, 0x63, 0x6b, 0x75, 0x70, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x3b, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67,
	0x6f, 0x2f, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2f, 0x61, 0x70, 0x69, 0x76,
	0x31, 0x2f, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x70, 0x62, 0x3b, 0x67, 0x6b,
	0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x70, 0x62, 0xaa, 0x02, 0x19, 0x47, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x47, 0x6b, 0x65, 0x42, 0x61, 0x63, 0x6b,
	0x75, 0x70, 0x2e, 0x56, 0x31, 0xca, 0x02, 0x19, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43,
	0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x47, 0x6b, 0x65, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x5c, 0x56,
	0x31, 0xea, 0x02, 0x1c, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75,
	0x64, 0x3a, 0x3a, 0x47, 0x6b, 0x65, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x3a, 0x3a, 0x56, 0x31,
	0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_gkebackup_v1_gkebackup_proto_rawDescOnce sync.Once
	file_google_cloud_gkebackup_v1_gkebackup_proto_rawDescData = file_google_cloud_gkebackup_v1_gkebackup_proto_rawDesc
)

func file_google_cloud_gkebackup_v1_gkebackup_proto_rawDescGZIP() []byte {
	file_google_cloud_gkebackup_v1_gkebackup_proto_rawDescOnce.Do(func() {
		file_google_cloud_gkebackup_v1_gkebackup_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_gkebackup_v1_gkebackup_proto_rawDescData)
	})
	return file_google_cloud_gkebackup_v1_gkebackup_proto_rawDescData
}

var file_google_cloud_gkebackup_v1_gkebackup_proto_msgTypes = make([]protoimpl.MessageInfo, 31)
var file_google_cloud_gkebackup_v1_gkebackup_proto_goTypes = []interface{}{
	(*OperationMetadata)(nil),          // 0: google.cloud.gkebackup.v1.OperationMetadata
	(*CreateBackupPlanRequest)(nil),    // 1: google.cloud.gkebackup.v1.CreateBackupPlanRequest
	(*ListBackupPlansRequest)(nil),     // 2: google.cloud.gkebackup.v1.ListBackupPlansRequest
	(*ListBackupPlansResponse)(nil),    // 3: google.cloud.gkebackup.v1.ListBackupPlansResponse
	(*GetBackupPlanRequest)(nil),       // 4: google.cloud.gkebackup.v1.GetBackupPlanRequest
	(*UpdateBackupPlanRequest)(nil),    // 5: google.cloud.gkebackup.v1.UpdateBackupPlanRequest
	(*DeleteBackupPlanRequest)(nil),    // 6: google.cloud.gkebackup.v1.DeleteBackupPlanRequest
	(*CreateBackupRequest)(nil),        // 7: google.cloud.gkebackup.v1.CreateBackupRequest
	(*ListBackupsRequest)(nil),         // 8: google.cloud.gkebackup.v1.ListBackupsRequest
	(*ListBackupsResponse)(nil),        // 9: google.cloud.gkebackup.v1.ListBackupsResponse
	(*GetBackupRequest)(nil),           // 10: google.cloud.gkebackup.v1.GetBackupRequest
	(*UpdateBackupRequest)(nil),        // 11: google.cloud.gkebackup.v1.UpdateBackupRequest
	(*DeleteBackupRequest)(nil),        // 12: google.cloud.gkebackup.v1.DeleteBackupRequest
	(*ListVolumeBackupsRequest)(nil),   // 13: google.cloud.gkebackup.v1.ListVolumeBackupsRequest
	(*ListVolumeBackupsResponse)(nil),  // 14: google.cloud.gkebackup.v1.ListVolumeBackupsResponse
	(*GetVolumeBackupRequest)(nil),     // 15: google.cloud.gkebackup.v1.GetVolumeBackupRequest
	(*CreateRestorePlanRequest)(nil),   // 16: google.cloud.gkebackup.v1.CreateRestorePlanRequest
	(*ListRestorePlansRequest)(nil),    // 17: google.cloud.gkebackup.v1.ListRestorePlansRequest
	(*ListRestorePlansResponse)(nil),   // 18: google.cloud.gkebackup.v1.ListRestorePlansResponse
	(*GetRestorePlanRequest)(nil),      // 19: google.cloud.gkebackup.v1.GetRestorePlanRequest
	(*UpdateRestorePlanRequest)(nil),   // 20: google.cloud.gkebackup.v1.UpdateRestorePlanRequest
	(*DeleteRestorePlanRequest)(nil),   // 21: google.cloud.gkebackup.v1.DeleteRestorePlanRequest
	(*CreateRestoreRequest)(nil),       // 22: google.cloud.gkebackup.v1.CreateRestoreRequest
	(*ListRestoresRequest)(nil),        // 23: google.cloud.gkebackup.v1.ListRestoresRequest
	(*ListRestoresResponse)(nil),       // 24: google.cloud.gkebackup.v1.ListRestoresResponse
	(*GetRestoreRequest)(nil),          // 25: google.cloud.gkebackup.v1.GetRestoreRequest
	(*UpdateRestoreRequest)(nil),       // 26: google.cloud.gkebackup.v1.UpdateRestoreRequest
	(*DeleteRestoreRequest)(nil),       // 27: google.cloud.gkebackup.v1.DeleteRestoreRequest
	(*ListVolumeRestoresRequest)(nil),  // 28: google.cloud.gkebackup.v1.ListVolumeRestoresRequest
	(*ListVolumeRestoresResponse)(nil), // 29: google.cloud.gkebackup.v1.ListVolumeRestoresResponse
	(*GetVolumeRestoreRequest)(nil),    // 30: google.cloud.gkebackup.v1.GetVolumeRestoreRequest
	(*timestamppb.Timestamp)(nil),      // 31: google.protobuf.Timestamp
	(*BackupPlan)(nil),                 // 32: google.cloud.gkebackup.v1.BackupPlan
	(*fieldmaskpb.FieldMask)(nil),      // 33: google.protobuf.FieldMask
	(*Backup)(nil),                     // 34: google.cloud.gkebackup.v1.Backup
	(*VolumeBackup)(nil),               // 35: google.cloud.gkebackup.v1.VolumeBackup
	(*RestorePlan)(nil),                // 36: google.cloud.gkebackup.v1.RestorePlan
	(*Restore)(nil),                    // 37: google.cloud.gkebackup.v1.Restore
	(*VolumeRestore)(nil),              // 38: google.cloud.gkebackup.v1.VolumeRestore
	(*longrunningpb.Operation)(nil),    // 39: google.longrunning.Operation
}
var file_google_cloud_gkebackup_v1_gkebackup_proto_depIdxs = []int32{
	31, // 0: google.cloud.gkebackup.v1.OperationMetadata.create_time:type_name -> google.protobuf.Timestamp
	31, // 1: google.cloud.gkebackup.v1.OperationMetadata.end_time:type_name -> google.protobuf.Timestamp
	32, // 2: google.cloud.gkebackup.v1.CreateBackupPlanRequest.backup_plan:type_name -> google.cloud.gkebackup.v1.BackupPlan
	32, // 3: google.cloud.gkebackup.v1.ListBackupPlansResponse.backup_plans:type_name -> google.cloud.gkebackup.v1.BackupPlan
	32, // 4: google.cloud.gkebackup.v1.UpdateBackupPlanRequest.backup_plan:type_name -> google.cloud.gkebackup.v1.BackupPlan
	33, // 5: google.cloud.gkebackup.v1.UpdateBackupPlanRequest.update_mask:type_name -> google.protobuf.FieldMask
	34, // 6: google.cloud.gkebackup.v1.CreateBackupRequest.backup:type_name -> google.cloud.gkebackup.v1.Backup
	34, // 7: google.cloud.gkebackup.v1.ListBackupsResponse.backups:type_name -> google.cloud.gkebackup.v1.Backup
	34, // 8: google.cloud.gkebackup.v1.UpdateBackupRequest.backup:type_name -> google.cloud.gkebackup.v1.Backup
	33, // 9: google.cloud.gkebackup.v1.UpdateBackupRequest.update_mask:type_name -> google.protobuf.FieldMask
	35, // 10: google.cloud.gkebackup.v1.ListVolumeBackupsResponse.volume_backups:type_name -> google.cloud.gkebackup.v1.VolumeBackup
	36, // 11: google.cloud.gkebackup.v1.CreateRestorePlanRequest.restore_plan:type_name -> google.cloud.gkebackup.v1.RestorePlan
	36, // 12: google.cloud.gkebackup.v1.ListRestorePlansResponse.restore_plans:type_name -> google.cloud.gkebackup.v1.RestorePlan
	36, // 13: google.cloud.gkebackup.v1.UpdateRestorePlanRequest.restore_plan:type_name -> google.cloud.gkebackup.v1.RestorePlan
	33, // 14: google.cloud.gkebackup.v1.UpdateRestorePlanRequest.update_mask:type_name -> google.protobuf.FieldMask
	37, // 15: google.cloud.gkebackup.v1.CreateRestoreRequest.restore:type_name -> google.cloud.gkebackup.v1.Restore
	37, // 16: google.cloud.gkebackup.v1.ListRestoresResponse.restores:type_name -> google.cloud.gkebackup.v1.Restore
	37, // 17: google.cloud.gkebackup.v1.UpdateRestoreRequest.restore:type_name -> google.cloud.gkebackup.v1.Restore
	33, // 18: google.cloud.gkebackup.v1.UpdateRestoreRequest.update_mask:type_name -> google.protobuf.FieldMask
	38, // 19: google.cloud.gkebackup.v1.ListVolumeRestoresResponse.volume_restores:type_name -> google.cloud.gkebackup.v1.VolumeRestore
	1,  // 20: google.cloud.gkebackup.v1.BackupForGKE.CreateBackupPlan:input_type -> google.cloud.gkebackup.v1.CreateBackupPlanRequest
	2,  // 21: google.cloud.gkebackup.v1.BackupForGKE.ListBackupPlans:input_type -> google.cloud.gkebackup.v1.ListBackupPlansRequest
	4,  // 22: google.cloud.gkebackup.v1.BackupForGKE.GetBackupPlan:input_type -> google.cloud.gkebackup.v1.GetBackupPlanRequest
	5,  // 23: google.cloud.gkebackup.v1.BackupForGKE.UpdateBackupPlan:input_type -> google.cloud.gkebackup.v1.UpdateBackupPlanRequest
	6,  // 24: google.cloud.gkebackup.v1.BackupForGKE.DeleteBackupPlan:input_type -> google.cloud.gkebackup.v1.DeleteBackupPlanRequest
	7,  // 25: google.cloud.gkebackup.v1.BackupForGKE.CreateBackup:input_type -> google.cloud.gkebackup.v1.CreateBackupRequest
	8,  // 26: google.cloud.gkebackup.v1.BackupForGKE.ListBackups:input_type -> google.cloud.gkebackup.v1.ListBackupsRequest
	10, // 27: google.cloud.gkebackup.v1.BackupForGKE.GetBackup:input_type -> google.cloud.gkebackup.v1.GetBackupRequest
	11, // 28: google.cloud.gkebackup.v1.BackupForGKE.UpdateBackup:input_type -> google.cloud.gkebackup.v1.UpdateBackupRequest
	12, // 29: google.cloud.gkebackup.v1.BackupForGKE.DeleteBackup:input_type -> google.cloud.gkebackup.v1.DeleteBackupRequest
	13, // 30: google.cloud.gkebackup.v1.BackupForGKE.ListVolumeBackups:input_type -> google.cloud.gkebackup.v1.ListVolumeBackupsRequest
	15, // 31: google.cloud.gkebackup.v1.BackupForGKE.GetVolumeBackup:input_type -> google.cloud.gkebackup.v1.GetVolumeBackupRequest
	16, // 32: google.cloud.gkebackup.v1.BackupForGKE.CreateRestorePlan:input_type -> google.cloud.gkebackup.v1.CreateRestorePlanRequest
	17, // 33: google.cloud.gkebackup.v1.BackupForGKE.ListRestorePlans:input_type -> google.cloud.gkebackup.v1.ListRestorePlansRequest
	19, // 34: google.cloud.gkebackup.v1.BackupForGKE.GetRestorePlan:input_type -> google.cloud.gkebackup.v1.GetRestorePlanRequest
	20, // 35: google.cloud.gkebackup.v1.BackupForGKE.UpdateRestorePlan:input_type -> google.cloud.gkebackup.v1.UpdateRestorePlanRequest
	21, // 36: google.cloud.gkebackup.v1.BackupForGKE.DeleteRestorePlan:input_type -> google.cloud.gkebackup.v1.DeleteRestorePlanRequest
	22, // 37: google.cloud.gkebackup.v1.BackupForGKE.CreateRestore:input_type -> google.cloud.gkebackup.v1.CreateRestoreRequest
	23, // 38: google.cloud.gkebackup.v1.BackupForGKE.ListRestores:input_type -> google.cloud.gkebackup.v1.ListRestoresRequest
	25, // 39: google.cloud.gkebackup.v1.BackupForGKE.GetRestore:input_type -> google.cloud.gkebackup.v1.GetRestoreRequest
	26, // 40: google.cloud.gkebackup.v1.BackupForGKE.UpdateRestore:input_type -> google.cloud.gkebackup.v1.UpdateRestoreRequest
	27, // 41: google.cloud.gkebackup.v1.BackupForGKE.DeleteRestore:input_type -> google.cloud.gkebackup.v1.DeleteRestoreRequest
	28, // 42: google.cloud.gkebackup.v1.BackupForGKE.ListVolumeRestores:input_type -> google.cloud.gkebackup.v1.ListVolumeRestoresRequest
	30, // 43: google.cloud.gkebackup.v1.BackupForGKE.GetVolumeRestore:input_type -> google.cloud.gkebackup.v1.GetVolumeRestoreRequest
	39, // 44: google.cloud.gkebackup.v1.BackupForGKE.CreateBackupPlan:output_type -> google.longrunning.Operation
	3,  // 45: google.cloud.gkebackup.v1.BackupForGKE.ListBackupPlans:output_type -> google.cloud.gkebackup.v1.ListBackupPlansResponse
	32, // 46: google.cloud.gkebackup.v1.BackupForGKE.GetBackupPlan:output_type -> google.cloud.gkebackup.v1.BackupPlan
	39, // 47: google.cloud.gkebackup.v1.BackupForGKE.UpdateBackupPlan:output_type -> google.longrunning.Operation
	39, // 48: google.cloud.gkebackup.v1.BackupForGKE.DeleteBackupPlan:output_type -> google.longrunning.Operation
	39, // 49: google.cloud.gkebackup.v1.BackupForGKE.CreateBackup:output_type -> google.longrunning.Operation
	9,  // 50: google.cloud.gkebackup.v1.BackupForGKE.ListBackups:output_type -> google.cloud.gkebackup.v1.ListBackupsResponse
	34, // 51: google.cloud.gkebackup.v1.BackupForGKE.GetBackup:output_type -> google.cloud.gkebackup.v1.Backup
	39, // 52: google.cloud.gkebackup.v1.BackupForGKE.UpdateBackup:output_type -> google.longrunning.Operation
	39, // 53: google.cloud.gkebackup.v1.BackupForGKE.DeleteBackup:output_type -> google.longrunning.Operation
	14, // 54: google.cloud.gkebackup.v1.BackupForGKE.ListVolumeBackups:output_type -> google.cloud.gkebackup.v1.ListVolumeBackupsResponse
	35, // 55: google.cloud.gkebackup.v1.BackupForGKE.GetVolumeBackup:output_type -> google.cloud.gkebackup.v1.VolumeBackup
	39, // 56: google.cloud.gkebackup.v1.BackupForGKE.CreateRestorePlan:output_type -> google.longrunning.Operation
	18, // 57: google.cloud.gkebackup.v1.BackupForGKE.ListRestorePlans:output_type -> google.cloud.gkebackup.v1.ListRestorePlansResponse
	36, // 58: google.cloud.gkebackup.v1.BackupForGKE.GetRestorePlan:output_type -> google.cloud.gkebackup.v1.RestorePlan
	39, // 59: google.cloud.gkebackup.v1.BackupForGKE.UpdateRestorePlan:output_type -> google.longrunning.Operation
	39, // 60: google.cloud.gkebackup.v1.BackupForGKE.DeleteRestorePlan:output_type -> google.longrunning.Operation
	39, // 61: google.cloud.gkebackup.v1.BackupForGKE.CreateRestore:output_type -> google.longrunning.Operation
	24, // 62: google.cloud.gkebackup.v1.BackupForGKE.ListRestores:output_type -> google.cloud.gkebackup.v1.ListRestoresResponse
	37, // 63: google.cloud.gkebackup.v1.BackupForGKE.GetRestore:output_type -> google.cloud.gkebackup.v1.Restore
	39, // 64: google.cloud.gkebackup.v1.BackupForGKE.UpdateRestore:output_type -> google.longrunning.Operation
	39, // 65: google.cloud.gkebackup.v1.BackupForGKE.DeleteRestore:output_type -> google.longrunning.Operation
	29, // 66: google.cloud.gkebackup.v1.BackupForGKE.ListVolumeRestores:output_type -> google.cloud.gkebackup.v1.ListVolumeRestoresResponse
	38, // 67: google.cloud.gkebackup.v1.BackupForGKE.GetVolumeRestore:output_type -> google.cloud.gkebackup.v1.VolumeRestore
	44, // [44:68] is the sub-list for method output_type
	20, // [20:44] is the sub-list for method input_type
	20, // [20:20] is the sub-list for extension type_name
	20, // [20:20] is the sub-list for extension extendee
	0,  // [0:20] is the sub-list for field type_name
}

func init() { file_google_cloud_gkebackup_v1_gkebackup_proto_init() }
func file_google_cloud_gkebackup_v1_gkebackup_proto_init() {
	if File_google_cloud_gkebackup_v1_gkebackup_proto != nil {
		return
	}
	file_google_cloud_gkebackup_v1_backup_proto_init()
	file_google_cloud_gkebackup_v1_backup_plan_proto_init()
	file_google_cloud_gkebackup_v1_restore_proto_init()
	file_google_cloud_gkebackup_v1_restore_plan_proto_init()
	file_google_cloud_gkebackup_v1_volume_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_gkebackup_v1_gkebackup_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OperationMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkebackup_v1_gkebackup_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateBackupPlanRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkebackup_v1_gkebackup_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListBackupPlansRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkebackup_v1_gkebackup_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListBackupPlansResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkebackup_v1_gkebackup_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetBackupPlanRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkebackup_v1_gkebackup_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateBackupPlanRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkebackup_v1_gkebackup_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteBackupPlanRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkebackup_v1_gkebackup_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateBackupRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkebackup_v1_gkebackup_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListBackupsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkebackup_v1_gkebackup_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListBackupsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkebackup_v1_gkebackup_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetBackupRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkebackup_v1_gkebackup_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateBackupRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkebackup_v1_gkebackup_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteBackupRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkebackup_v1_gkebackup_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListVolumeBackupsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkebackup_v1_gkebackup_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListVolumeBackupsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkebackup_v1_gkebackup_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetVolumeBackupRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkebackup_v1_gkebackup_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateRestorePlanRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkebackup_v1_gkebackup_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListRestorePlansRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkebackup_v1_gkebackup_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListRestorePlansResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkebackup_v1_gkebackup_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetRestorePlanRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkebackup_v1_gkebackup_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateRestorePlanRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkebackup_v1_gkebackup_proto_msgTypes[21].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteRestorePlanRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkebackup_v1_gkebackup_proto_msgTypes[22].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateRestoreRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkebackup_v1_gkebackup_proto_msgTypes[23].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListRestoresRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkebackup_v1_gkebackup_proto_msgTypes[24].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListRestoresResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkebackup_v1_gkebackup_proto_msgTypes[25].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetRestoreRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkebackup_v1_gkebackup_proto_msgTypes[26].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateRestoreRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkebackup_v1_gkebackup_proto_msgTypes[27].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteRestoreRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkebackup_v1_gkebackup_proto_msgTypes[28].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListVolumeRestoresRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkebackup_v1_gkebackup_proto_msgTypes[29].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListVolumeRestoresResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkebackup_v1_gkebackup_proto_msgTypes[30].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetVolumeRestoreRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_gkebackup_v1_gkebackup_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   31,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_gkebackup_v1_gkebackup_proto_goTypes,
		DependencyIndexes: file_google_cloud_gkebackup_v1_gkebackup_proto_depIdxs,
		MessageInfos:      file_google_cloud_gkebackup_v1_gkebackup_proto_msgTypes,
	}.Build()
	File_google_cloud_gkebackup_v1_gkebackup_proto = out.File
	file_google_cloud_gkebackup_v1_gkebackup_proto_rawDesc = nil
	file_google_cloud_gkebackup_v1_gkebackup_proto_goTypes = nil
	file_google_cloud_gkebackup_v1_gkebackup_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// BackupForGKEClient is the client API for BackupForGKE service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type BackupForGKEClient interface {
	// Creates a new BackupPlan in a given location.
	CreateBackupPlan(ctx context.Context, in *CreateBackupPlanRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Lists BackupPlans in a given location.
	ListBackupPlans(ctx context.Context, in *ListBackupPlansRequest, opts ...grpc.CallOption) (*ListBackupPlansResponse, error)
	// Retrieve the details of a single BackupPlan.
	GetBackupPlan(ctx context.Context, in *GetBackupPlanRequest, opts ...grpc.CallOption) (*BackupPlan, error)
	// Update a BackupPlan.
	UpdateBackupPlan(ctx context.Context, in *UpdateBackupPlanRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes an existing BackupPlan.
	DeleteBackupPlan(ctx context.Context, in *DeleteBackupPlanRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Creates a Backup for the given BackupPlan.
	CreateBackup(ctx context.Context, in *CreateBackupRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Lists the Backups for a given BackupPlan.
	ListBackups(ctx context.Context, in *ListBackupsRequest, opts ...grpc.CallOption) (*ListBackupsResponse, error)
	// Retrieve the details of a single Backup.
	GetBackup(ctx context.Context, in *GetBackupRequest, opts ...grpc.CallOption) (*Backup, error)
	// Update a Backup.
	UpdateBackup(ctx context.Context, in *UpdateBackupRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes an existing Backup.
	DeleteBackup(ctx context.Context, in *DeleteBackupRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Lists the VolumeBackups for a given Backup.
	ListVolumeBackups(ctx context.Context, in *ListVolumeBackupsRequest, opts ...grpc.CallOption) (*ListVolumeBackupsResponse, error)
	// Retrieve the details of a single VolumeBackup.
	GetVolumeBackup(ctx context.Context, in *GetVolumeBackupRequest, opts ...grpc.CallOption) (*VolumeBackup, error)
	// Creates a new RestorePlan in a given location.
	CreateRestorePlan(ctx context.Context, in *CreateRestorePlanRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Lists RestorePlans in a given location.
	ListRestorePlans(ctx context.Context, in *ListRestorePlansRequest, opts ...grpc.CallOption) (*ListRestorePlansResponse, error)
	// Retrieve the details of a single RestorePlan.
	GetRestorePlan(ctx context.Context, in *GetRestorePlanRequest, opts ...grpc.CallOption) (*RestorePlan, error)
	// Update a RestorePlan.
	UpdateRestorePlan(ctx context.Context, in *UpdateRestorePlanRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes an existing RestorePlan.
	DeleteRestorePlan(ctx context.Context, in *DeleteRestorePlanRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Creates a new Restore for the given RestorePlan.
	CreateRestore(ctx context.Context, in *CreateRestoreRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Lists the Restores for a given RestorePlan.
	ListRestores(ctx context.Context, in *ListRestoresRequest, opts ...grpc.CallOption) (*ListRestoresResponse, error)
	// Retrieves the details of a single Restore.
	GetRestore(ctx context.Context, in *GetRestoreRequest, opts ...grpc.CallOption) (*Restore, error)
	// Update a Restore.
	UpdateRestore(ctx context.Context, in *UpdateRestoreRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes an existing Restore.
	DeleteRestore(ctx context.Context, in *DeleteRestoreRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Lists the VolumeRestores for a given Restore.
	ListVolumeRestores(ctx context.Context, in *ListVolumeRestoresRequest, opts ...grpc.CallOption) (*ListVolumeRestoresResponse, error)
	// Retrieve the details of a single VolumeRestore.
	GetVolumeRestore(ctx context.Context, in *GetVolumeRestoreRequest, opts ...grpc.CallOption) (*VolumeRestore, error)
}

type backupForGKEClient struct {
	cc grpc.ClientConnInterface
}

func NewBackupForGKEClient(cc grpc.ClientConnInterface) BackupForGKEClient {
	return &backupForGKEClient{cc}
}

func (c *backupForGKEClient) CreateBackupPlan(ctx context.Context, in *CreateBackupPlanRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.gkebackup.v1.BackupForGKE/CreateBackupPlan", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *backupForGKEClient) ListBackupPlans(ctx context.Context, in *ListBackupPlansRequest, opts ...grpc.CallOption) (*ListBackupPlansResponse, error) {
	out := new(ListBackupPlansResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.gkebackup.v1.BackupForGKE/ListBackupPlans", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *backupForGKEClient) GetBackupPlan(ctx context.Context, in *GetBackupPlanRequest, opts ...grpc.CallOption) (*BackupPlan, error) {
	out := new(BackupPlan)
	err := c.cc.Invoke(ctx, "/google.cloud.gkebackup.v1.BackupForGKE/GetBackupPlan", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *backupForGKEClient) UpdateBackupPlan(ctx context.Context, in *UpdateBackupPlanRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.gkebackup.v1.BackupForGKE/UpdateBackupPlan", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *backupForGKEClient) DeleteBackupPlan(ctx context.Context, in *DeleteBackupPlanRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.gkebackup.v1.BackupForGKE/DeleteBackupPlan", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *backupForGKEClient) CreateBackup(ctx context.Context, in *CreateBackupRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.gkebackup.v1.BackupForGKE/CreateBackup", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *backupForGKEClient) ListBackups(ctx context.Context, in *ListBackupsRequest, opts ...grpc.CallOption) (*ListBackupsResponse, error) {
	out := new(ListBackupsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.gkebackup.v1.BackupForGKE/ListBackups", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *backupForGKEClient) GetBackup(ctx context.Context, in *GetBackupRequest, opts ...grpc.CallOption) (*Backup, error) {
	out := new(Backup)
	err := c.cc.Invoke(ctx, "/google.cloud.gkebackup.v1.BackupForGKE/GetBackup", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *backupForGKEClient) UpdateBackup(ctx context.Context, in *UpdateBackupRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.gkebackup.v1.BackupForGKE/UpdateBackup", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *backupForGKEClient) DeleteBackup(ctx context.Context, in *DeleteBackupRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.gkebackup.v1.BackupForGKE/DeleteBackup", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *backupForGKEClient) ListVolumeBackups(ctx context.Context, in *ListVolumeBackupsRequest, opts ...grpc.CallOption) (*ListVolumeBackupsResponse, error) {
	out := new(ListVolumeBackupsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.gkebackup.v1.BackupForGKE/ListVolumeBackups", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *backupForGKEClient) GetVolumeBackup(ctx context.Context, in *GetVolumeBackupRequest, opts ...grpc.CallOption) (*VolumeBackup, error) {
	out := new(VolumeBackup)
	err := c.cc.Invoke(ctx, "/google.cloud.gkebackup.v1.BackupForGKE/GetVolumeBackup", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *backupForGKEClient) CreateRestorePlan(ctx context.Context, in *CreateRestorePlanRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.gkebackup.v1.BackupForGKE/CreateRestorePlan", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *backupForGKEClient) ListRestorePlans(ctx context.Context, in *ListRestorePlansRequest, opts ...grpc.CallOption) (*ListRestorePlansResponse, error) {
	out := new(ListRestorePlansResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.gkebackup.v1.BackupForGKE/ListRestorePlans", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *backupForGKEClient) GetRestorePlan(ctx context.Context, in *GetRestorePlanRequest, opts ...grpc.CallOption) (*RestorePlan, error) {
	out := new(RestorePlan)
	err := c.cc.Invoke(ctx, "/google.cloud.gkebackup.v1.BackupForGKE/GetRestorePlan", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *backupForGKEClient) UpdateRestorePlan(ctx context.Context, in *UpdateRestorePlanRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.gkebackup.v1.BackupForGKE/UpdateRestorePlan", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *backupForGKEClient) DeleteRestorePlan(ctx context.Context, in *DeleteRestorePlanRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.gkebackup.v1.BackupForGKE/DeleteRestorePlan", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *backupForGKEClient) CreateRestore(ctx context.Context, in *CreateRestoreRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.gkebackup.v1.BackupForGKE/CreateRestore", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *backupForGKEClient) ListRestores(ctx context.Context, in *ListRestoresRequest, opts ...grpc.CallOption) (*ListRestoresResponse, error) {
	out := new(ListRestoresResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.gkebackup.v1.BackupForGKE/ListRestores", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *backupForGKEClient) GetRestore(ctx context.Context, in *GetRestoreRequest, opts ...grpc.CallOption) (*Restore, error) {
	out := new(Restore)
	err := c.cc.Invoke(ctx, "/google.cloud.gkebackup.v1.BackupForGKE/GetRestore", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *backupForGKEClient) UpdateRestore(ctx context.Context, in *UpdateRestoreRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.gkebackup.v1.BackupForGKE/UpdateRestore", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *backupForGKEClient) DeleteRestore(ctx context.Context, in *DeleteRestoreRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.gkebackup.v1.BackupForGKE/DeleteRestore", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *backupForGKEClient) ListVolumeRestores(ctx context.Context, in *ListVolumeRestoresRequest, opts ...grpc.CallOption) (*ListVolumeRestoresResponse, error) {
	out := new(ListVolumeRestoresResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.gkebackup.v1.BackupForGKE/ListVolumeRestores", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *backupForGKEClient) GetVolumeRestore(ctx context.Context, in *GetVolumeRestoreRequest, opts ...grpc.CallOption) (*VolumeRestore, error) {
	out := new(VolumeRestore)
	err := c.cc.Invoke(ctx, "/google.cloud.gkebackup.v1.BackupForGKE/GetVolumeRestore", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// BackupForGKEServer is the server API for BackupForGKE service.
type BackupForGKEServer interface {
	// Creates a new BackupPlan in a given location.
	CreateBackupPlan(context.Context, *CreateBackupPlanRequest) (*longrunningpb.Operation, error)
	// Lists BackupPlans in a given location.
	ListBackupPlans(context.Context, *ListBackupPlansRequest) (*ListBackupPlansResponse, error)
	// Retrieve the details of a single BackupPlan.
	GetBackupPlan(context.Context, *GetBackupPlanRequest) (*BackupPlan, error)
	// Update a BackupPlan.
	UpdateBackupPlan(context.Context, *UpdateBackupPlanRequest) (*longrunningpb.Operation, error)
	// Deletes an existing BackupPlan.
	DeleteBackupPlan(context.Context, *DeleteBackupPlanRequest) (*longrunningpb.Operation, error)
	// Creates a Backup for the given BackupPlan.
	CreateBackup(context.Context, *CreateBackupRequest) (*longrunningpb.Operation, error)
	// Lists the Backups for a given BackupPlan.
	ListBackups(context.Context, *ListBackupsRequest) (*ListBackupsResponse, error)
	// Retrieve the details of a single Backup.
	GetBackup(context.Context, *GetBackupRequest) (*Backup, error)
	// Update a Backup.
	UpdateBackup(context.Context, *UpdateBackupRequest) (*longrunningpb.Operation, error)
	// Deletes an existing Backup.
	DeleteBackup(context.Context, *DeleteBackupRequest) (*longrunningpb.Operation, error)
	// Lists the VolumeBackups for a given Backup.
	ListVolumeBackups(context.Context, *ListVolumeBackupsRequest) (*ListVolumeBackupsResponse, error)
	// Retrieve the details of a single VolumeBackup.
	GetVolumeBackup(context.Context, *GetVolumeBackupRequest) (*VolumeBackup, error)
	// Creates a new RestorePlan in a given location.
	CreateRestorePlan(context.Context, *CreateRestorePlanRequest) (*longrunningpb.Operation, error)
	// Lists RestorePlans in a given location.
	ListRestorePlans(context.Context, *ListRestorePlansRequest) (*ListRestorePlansResponse, error)
	// Retrieve the details of a single RestorePlan.
	GetRestorePlan(context.Context, *GetRestorePlanRequest) (*RestorePlan, error)
	// Update a RestorePlan.
	UpdateRestorePlan(context.Context, *UpdateRestorePlanRequest) (*longrunningpb.Operation, error)
	// Deletes an existing RestorePlan.
	DeleteRestorePlan(context.Context, *DeleteRestorePlanRequest) (*longrunningpb.Operation, error)
	// Creates a new Restore for the given RestorePlan.
	CreateRestore(context.Context, *CreateRestoreRequest) (*longrunningpb.Operation, error)
	// Lists the Restores for a given RestorePlan.
	ListRestores(context.Context, *ListRestoresRequest) (*ListRestoresResponse, error)
	// Retrieves the details of a single Restore.
	GetRestore(context.Context, *GetRestoreRequest) (*Restore, error)
	// Update a Restore.
	UpdateRestore(context.Context, *UpdateRestoreRequest) (*longrunningpb.Operation, error)
	// Deletes an existing Restore.
	DeleteRestore(context.Context, *DeleteRestoreRequest) (*longrunningpb.Operation, error)
	// Lists the VolumeRestores for a given Restore.
	ListVolumeRestores(context.Context, *ListVolumeRestoresRequest) (*ListVolumeRestoresResponse, error)
	// Retrieve the details of a single VolumeRestore.
	GetVolumeRestore(context.Context, *GetVolumeRestoreRequest) (*VolumeRestore, error)
}

// UnimplementedBackupForGKEServer can be embedded to have forward compatible implementations.
type UnimplementedBackupForGKEServer struct {
}

func (*UnimplementedBackupForGKEServer) CreateBackupPlan(context.Context, *CreateBackupPlanRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateBackupPlan not implemented")
}
func (*UnimplementedBackupForGKEServer) ListBackupPlans(context.Context, *ListBackupPlansRequest) (*ListBackupPlansResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListBackupPlans not implemented")
}
func (*UnimplementedBackupForGKEServer) GetBackupPlan(context.Context, *GetBackupPlanRequest) (*BackupPlan, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetBackupPlan not implemented")
}
func (*UnimplementedBackupForGKEServer) UpdateBackupPlan(context.Context, *UpdateBackupPlanRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateBackupPlan not implemented")
}
func (*UnimplementedBackupForGKEServer) DeleteBackupPlan(context.Context, *DeleteBackupPlanRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteBackupPlan not implemented")
}
func (*UnimplementedBackupForGKEServer) CreateBackup(context.Context, *CreateBackupRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateBackup not implemented")
}
func (*UnimplementedBackupForGKEServer) ListBackups(context.Context, *ListBackupsRequest) (*ListBackupsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListBackups not implemented")
}
func (*UnimplementedBackupForGKEServer) GetBackup(context.Context, *GetBackupRequest) (*Backup, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetBackup not implemented")
}
func (*UnimplementedBackupForGKEServer) UpdateBackup(context.Context, *UpdateBackupRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateBackup not implemented")
}
func (*UnimplementedBackupForGKEServer) DeleteBackup(context.Context, *DeleteBackupRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteBackup not implemented")
}
func (*UnimplementedBackupForGKEServer) ListVolumeBackups(context.Context, *ListVolumeBackupsRequest) (*ListVolumeBackupsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListVolumeBackups not implemented")
}
func (*UnimplementedBackupForGKEServer) GetVolumeBackup(context.Context, *GetVolumeBackupRequest) (*VolumeBackup, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetVolumeBackup not implemented")
}
func (*UnimplementedBackupForGKEServer) CreateRestorePlan(context.Context, *CreateRestorePlanRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateRestorePlan not implemented")
}
func (*UnimplementedBackupForGKEServer) ListRestorePlans(context.Context, *ListRestorePlansRequest) (*ListRestorePlansResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListRestorePlans not implemented")
}
func (*UnimplementedBackupForGKEServer) GetRestorePlan(context.Context, *GetRestorePlanRequest) (*RestorePlan, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetRestorePlan not implemented")
}
func (*UnimplementedBackupForGKEServer) UpdateRestorePlan(context.Context, *UpdateRestorePlanRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateRestorePlan not implemented")
}
func (*UnimplementedBackupForGKEServer) DeleteRestorePlan(context.Context, *DeleteRestorePlanRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteRestorePlan not implemented")
}
func (*UnimplementedBackupForGKEServer) CreateRestore(context.Context, *CreateRestoreRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateRestore not implemented")
}
func (*UnimplementedBackupForGKEServer) ListRestores(context.Context, *ListRestoresRequest) (*ListRestoresResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListRestores not implemented")
}
func (*UnimplementedBackupForGKEServer) GetRestore(context.Context, *GetRestoreRequest) (*Restore, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetRestore not implemented")
}
func (*UnimplementedBackupForGKEServer) UpdateRestore(context.Context, *UpdateRestoreRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateRestore not implemented")
}
func (*UnimplementedBackupForGKEServer) DeleteRestore(context.Context, *DeleteRestoreRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteRestore not implemented")
}
func (*UnimplementedBackupForGKEServer) ListVolumeRestores(context.Context, *ListVolumeRestoresRequest) (*ListVolumeRestoresResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListVolumeRestores not implemented")
}
func (*UnimplementedBackupForGKEServer) GetVolumeRestore(context.Context, *GetVolumeRestoreRequest) (*VolumeRestore, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetVolumeRestore not implemented")
}

func RegisterBackupForGKEServer(s *grpc.Server, srv BackupForGKEServer) {
	s.RegisterService(&_BackupForGKE_serviceDesc, srv)
}

func _BackupForGKE_CreateBackupPlan_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateBackupPlanRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BackupForGKEServer).CreateBackupPlan(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.gkebackup.v1.BackupForGKE/CreateBackupPlan",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BackupForGKEServer).CreateBackupPlan(ctx, req.(*CreateBackupPlanRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BackupForGKE_ListBackupPlans_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListBackupPlansRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BackupForGKEServer).ListBackupPlans(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.gkebackup.v1.BackupForGKE/ListBackupPlans",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BackupForGKEServer).ListBackupPlans(ctx, req.(*ListBackupPlansRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BackupForGKE_GetBackupPlan_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetBackupPlanRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BackupForGKEServer).GetBackupPlan(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.gkebackup.v1.BackupForGKE/GetBackupPlan",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BackupForGKEServer).GetBackupPlan(ctx, req.(*GetBackupPlanRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BackupForGKE_UpdateBackupPlan_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateBackupPlanRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BackupForGKEServer).UpdateBackupPlan(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.gkebackup.v1.BackupForGKE/UpdateBackupPlan",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BackupForGKEServer).UpdateBackupPlan(ctx, req.(*UpdateBackupPlanRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BackupForGKE_DeleteBackupPlan_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteBackupPlanRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BackupForGKEServer).DeleteBackupPlan(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.gkebackup.v1.BackupForGKE/DeleteBackupPlan",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BackupForGKEServer).DeleteBackupPlan(ctx, req.(*DeleteBackupPlanRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BackupForGKE_CreateBackup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateBackupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BackupForGKEServer).CreateBackup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.gkebackup.v1.BackupForGKE/CreateBackup",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BackupForGKEServer).CreateBackup(ctx, req.(*CreateBackupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BackupForGKE_ListBackups_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListBackupsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BackupForGKEServer).ListBackups(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.gkebackup.v1.BackupForGKE/ListBackups",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BackupForGKEServer).ListBackups(ctx, req.(*ListBackupsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BackupForGKE_GetBackup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetBackupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BackupForGKEServer).GetBackup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.gkebackup.v1.BackupForGKE/GetBackup",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BackupForGKEServer).GetBackup(ctx, req.(*GetBackupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BackupForGKE_UpdateBackup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateBackupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BackupForGKEServer).UpdateBackup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.gkebackup.v1.BackupForGKE/UpdateBackup",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BackupForGKEServer).UpdateBackup(ctx, req.(*UpdateBackupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BackupForGKE_DeleteBackup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteBackupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BackupForGKEServer).DeleteBackup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.gkebackup.v1.BackupForGKE/DeleteBackup",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BackupForGKEServer).DeleteBackup(ctx, req.(*DeleteBackupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BackupForGKE_ListVolumeBackups_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListVolumeBackupsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BackupForGKEServer).ListVolumeBackups(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.gkebackup.v1.BackupForGKE/ListVolumeBackups",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BackupForGKEServer).ListVolumeBackups(ctx, req.(*ListVolumeBackupsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BackupForGKE_GetVolumeBackup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetVolumeBackupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BackupForGKEServer).GetVolumeBackup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.gkebackup.v1.BackupForGKE/GetVolumeBackup",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BackupForGKEServer).GetVolumeBackup(ctx, req.(*GetVolumeBackupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BackupForGKE_CreateRestorePlan_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateRestorePlanRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BackupForGKEServer).CreateRestorePlan(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.gkebackup.v1.BackupForGKE/CreateRestorePlan",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BackupForGKEServer).CreateRestorePlan(ctx, req.(*CreateRestorePlanRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BackupForGKE_ListRestorePlans_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListRestorePlansRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BackupForGKEServer).ListRestorePlans(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.gkebackup.v1.BackupForGKE/ListRestorePlans",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BackupForGKEServer).ListRestorePlans(ctx, req.(*ListRestorePlansRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BackupForGKE_GetRestorePlan_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetRestorePlanRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BackupForGKEServer).GetRestorePlan(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.gkebackup.v1.BackupForGKE/GetRestorePlan",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BackupForGKEServer).GetRestorePlan(ctx, req.(*GetRestorePlanRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BackupForGKE_UpdateRestorePlan_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateRestorePlanRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BackupForGKEServer).UpdateRestorePlan(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.gkebackup.v1.BackupForGKE/UpdateRestorePlan",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BackupForGKEServer).UpdateRestorePlan(ctx, req.(*UpdateRestorePlanRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BackupForGKE_DeleteRestorePlan_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteRestorePlanRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BackupForGKEServer).DeleteRestorePlan(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.gkebackup.v1.BackupForGKE/DeleteRestorePlan",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BackupForGKEServer).DeleteRestorePlan(ctx, req.(*DeleteRestorePlanRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BackupForGKE_CreateRestore_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateRestoreRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BackupForGKEServer).CreateRestore(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.gkebackup.v1.BackupForGKE/CreateRestore",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BackupForGKEServer).CreateRestore(ctx, req.(*CreateRestoreRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BackupForGKE_ListRestores_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListRestoresRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BackupForGKEServer).ListRestores(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.gkebackup.v1.BackupForGKE/ListRestores",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BackupForGKEServer).ListRestores(ctx, req.(*ListRestoresRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BackupForGKE_GetRestore_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetRestoreRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BackupForGKEServer).GetRestore(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.gkebackup.v1.BackupForGKE/GetRestore",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BackupForGKEServer).GetRestore(ctx, req.(*GetRestoreRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BackupForGKE_UpdateRestore_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateRestoreRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BackupForGKEServer).UpdateRestore(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.gkebackup.v1.BackupForGKE/UpdateRestore",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BackupForGKEServer).UpdateRestore(ctx, req.(*UpdateRestoreRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BackupForGKE_DeleteRestore_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteRestoreRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BackupForGKEServer).DeleteRestore(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.gkebackup.v1.BackupForGKE/DeleteRestore",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BackupForGKEServer).DeleteRestore(ctx, req.(*DeleteRestoreRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BackupForGKE_ListVolumeRestores_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListVolumeRestoresRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BackupForGKEServer).ListVolumeRestores(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.gkebackup.v1.BackupForGKE/ListVolumeRestores",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BackupForGKEServer).ListVolumeRestores(ctx, req.(*ListVolumeRestoresRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BackupForGKE_GetVolumeRestore_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetVolumeRestoreRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BackupForGKEServer).GetVolumeRestore(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.gkebackup.v1.BackupForGKE/GetVolumeRestore",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BackupForGKEServer).GetVolumeRestore(ctx, req.(*GetVolumeRestoreRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _BackupForGKE_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.gkebackup.v1.BackupForGKE",
	HandlerType: (*BackupForGKEServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateBackupPlan",
			Handler:    _BackupForGKE_CreateBackupPlan_Handler,
		},
		{
			MethodName: "ListBackupPlans",
			Handler:    _BackupForGKE_ListBackupPlans_Handler,
		},
		{
			MethodName: "GetBackupPlan",
			Handler:    _BackupForGKE_GetBackupPlan_Handler,
		},
		{
			MethodName: "UpdateBackupPlan",
			Handler:    _BackupForGKE_UpdateBackupPlan_Handler,
		},
		{
			MethodName: "DeleteBackupPlan",
			Handler:    _BackupForGKE_DeleteBackupPlan_Handler,
		},
		{
			MethodName: "CreateBackup",
			Handler:    _BackupForGKE_CreateBackup_Handler,
		},
		{
			MethodName: "ListBackups",
			Handler:    _BackupForGKE_ListBackups_Handler,
		},
		{
			MethodName: "GetBackup",
			Handler:    _BackupForGKE_GetBackup_Handler,
		},
		{
			MethodName: "UpdateBackup",
			Handler:    _BackupForGKE_UpdateBackup_Handler,
		},
		{
			MethodName: "DeleteBackup",
			Handler:    _BackupForGKE_DeleteBackup_Handler,
		},
		{
			MethodName: "ListVolumeBackups",
			Handler:    _BackupForGKE_ListVolumeBackups_Handler,
		},
		{
			MethodName: "GetVolumeBackup",
			Handler:    _BackupForGKE_GetVolumeBackup_Handler,
		},
		{
			MethodName: "CreateRestorePlan",
			Handler:    _BackupForGKE_CreateRestorePlan_Handler,
		},
		{
			MethodName: "ListRestorePlans",
			Handler:    _BackupForGKE_ListRestorePlans_Handler,
		},
		{
			MethodName: "GetRestorePlan",
			Handler:    _BackupForGKE_GetRestorePlan_Handler,
		},
		{
			MethodName: "UpdateRestorePlan",
			Handler:    _BackupForGKE_UpdateRestorePlan_Handler,
		},
		{
			MethodName: "DeleteRestorePlan",
			Handler:    _BackupForGKE_DeleteRestorePlan_Handler,
		},
		{
			MethodName: "CreateRestore",
			Handler:    _BackupForGKE_CreateRestore_Handler,
		},
		{
			MethodName: "ListRestores",
			Handler:    _BackupForGKE_ListRestores_Handler,
		},
		{
			MethodName: "GetRestore",
			Handler:    _BackupForGKE_GetRestore_Handler,
		},
		{
			MethodName: "UpdateRestore",
			Handler:    _BackupForGKE_UpdateRestore_Handler,
		},
		{
			MethodName: "DeleteRestore",
			Handler:    _BackupForGKE_DeleteRestore_Handler,
		},
		{
			MethodName: "ListVolumeRestores",
			Handler:    _BackupForGKE_ListVolumeRestores_Handler,
		},
		{
			MethodName: "GetVolumeRestore",
			Handler:    _BackupForGKE_GetVolumeRestore_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/gkebackup/v1/gkebackup.proto",
}
