// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.34.2
// 	protoc        v4.25.3
// source: google/analytics/admin/v1alpha/subproperty_event_filter.proto

package adminpb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// How the filter will be used to determine a match.
type SubpropertyEventFilterCondition_StringFilter_MatchType int32

const (
	// Match type unknown or not specified.
	SubpropertyEventFilterCondition_StringFilter_MATCH_TYPE_UNSPECIFIED SubpropertyEventFilterCondition_StringFilter_MatchType = 0
	// Exact match of the string value.
	SubpropertyEventFilterCondition_StringFilter_EXACT SubpropertyEventFilterCondition_StringFilter_MatchType = 1
	// Begins with the string value.
	SubpropertyEventFilterCondition_StringFilter_BEGINS_WITH SubpropertyEventFilterCondition_StringFilter_MatchType = 2
	// Ends with the string value.
	SubpropertyEventFilterCondition_StringFilter_ENDS_WITH SubpropertyEventFilterCondition_StringFilter_MatchType = 3
	// Contains the string value.
	SubpropertyEventFilterCondition_StringFilter_CONTAINS SubpropertyEventFilterCondition_StringFilter_MatchType = 4
	// Full regular expression matches with the string value.
	SubpropertyEventFilterCondition_StringFilter_FULL_REGEXP SubpropertyEventFilterCondition_StringFilter_MatchType = 5
	// Partial regular expression matches with the string value.
	SubpropertyEventFilterCondition_StringFilter_PARTIAL_REGEXP SubpropertyEventFilterCondition_StringFilter_MatchType = 6
)

// Enum value maps for SubpropertyEventFilterCondition_StringFilter_MatchType.
var (
	SubpropertyEventFilterCondition_StringFilter_MatchType_name = map[int32]string{
		0: "MATCH_TYPE_UNSPECIFIED",
		1: "EXACT",
		2: "BEGINS_WITH",
		3: "ENDS_WITH",
		4: "CONTAINS",
		5: "FULL_REGEXP",
		6: "PARTIAL_REGEXP",
	}
	SubpropertyEventFilterCondition_StringFilter_MatchType_value = map[string]int32{
		"MATCH_TYPE_UNSPECIFIED": 0,
		"EXACT":                  1,
		"BEGINS_WITH":            2,
		"ENDS_WITH":              3,
		"CONTAINS":               4,
		"FULL_REGEXP":            5,
		"PARTIAL_REGEXP":         6,
	}
)

func (x SubpropertyEventFilterCondition_StringFilter_MatchType) Enum() *SubpropertyEventFilterCondition_StringFilter_MatchType {
	p := new(SubpropertyEventFilterCondition_StringFilter_MatchType)
	*p = x
	return p
}

func (x SubpropertyEventFilterCondition_StringFilter_MatchType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SubpropertyEventFilterCondition_StringFilter_MatchType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_analytics_admin_v1alpha_subproperty_event_filter_proto_enumTypes[0].Descriptor()
}

func (SubpropertyEventFilterCondition_StringFilter_MatchType) Type() protoreflect.EnumType {
	return &file_google_analytics_admin_v1alpha_subproperty_event_filter_proto_enumTypes[0]
}

func (x SubpropertyEventFilterCondition_StringFilter_MatchType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SubpropertyEventFilterCondition_StringFilter_MatchType.Descriptor instead.
func (SubpropertyEventFilterCondition_StringFilter_MatchType) EnumDescriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_subproperty_event_filter_proto_rawDescGZIP(), []int{0, 0, 0}
}

// Specifies whether this is an include or exclude filter clause.
type SubpropertyEventFilterClause_FilterClauseType int32

const (
	// Filter clause type unknown or not specified.
	SubpropertyEventFilterClause_FILTER_CLAUSE_TYPE_UNSPECIFIED SubpropertyEventFilterClause_FilterClauseType = 0
	// Events will be included in the Sub property if the filter clause is met.
	SubpropertyEventFilterClause_INCLUDE SubpropertyEventFilterClause_FilterClauseType = 1
	// Events will be excluded from the Sub property if the filter clause is
	// met.
	SubpropertyEventFilterClause_EXCLUDE SubpropertyEventFilterClause_FilterClauseType = 2
)

// Enum value maps for SubpropertyEventFilterClause_FilterClauseType.
var (
	SubpropertyEventFilterClause_FilterClauseType_name = map[int32]string{
		0: "FILTER_CLAUSE_TYPE_UNSPECIFIED",
		1: "INCLUDE",
		2: "EXCLUDE",
	}
	SubpropertyEventFilterClause_FilterClauseType_value = map[string]int32{
		"FILTER_CLAUSE_TYPE_UNSPECIFIED": 0,
		"INCLUDE":                        1,
		"EXCLUDE":                        2,
	}
)

func (x SubpropertyEventFilterClause_FilterClauseType) Enum() *SubpropertyEventFilterClause_FilterClauseType {
	p := new(SubpropertyEventFilterClause_FilterClauseType)
	*p = x
	return p
}

func (x SubpropertyEventFilterClause_FilterClauseType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SubpropertyEventFilterClause_FilterClauseType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_analytics_admin_v1alpha_subproperty_event_filter_proto_enumTypes[1].Descriptor()
}

func (SubpropertyEventFilterClause_FilterClauseType) Type() protoreflect.EnumType {
	return &file_google_analytics_admin_v1alpha_subproperty_event_filter_proto_enumTypes[1]
}

func (x SubpropertyEventFilterClause_FilterClauseType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SubpropertyEventFilterClause_FilterClauseType.Descriptor instead.
func (SubpropertyEventFilterClause_FilterClauseType) EnumDescriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_subproperty_event_filter_proto_rawDescGZIP(), []int{3, 0}
}

// A specific filter expression
type SubpropertyEventFilterCondition struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to OneFilter:
	//
	//	*SubpropertyEventFilterCondition_NullFilter
	//	*SubpropertyEventFilterCondition_StringFilter_
	OneFilter isSubpropertyEventFilterCondition_OneFilter `protobuf_oneof:"one_filter"`
	// Required. The field that is being filtered.
	FieldName string `protobuf:"bytes,1,opt,name=field_name,json=fieldName,proto3" json:"field_name,omitempty"`
}

func (x *SubpropertyEventFilterCondition) Reset() {
	*x = SubpropertyEventFilterCondition{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_subproperty_event_filter_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SubpropertyEventFilterCondition) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SubpropertyEventFilterCondition) ProtoMessage() {}

func (x *SubpropertyEventFilterCondition) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_subproperty_event_filter_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SubpropertyEventFilterCondition.ProtoReflect.Descriptor instead.
func (*SubpropertyEventFilterCondition) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_subproperty_event_filter_proto_rawDescGZIP(), []int{0}
}

func (m *SubpropertyEventFilterCondition) GetOneFilter() isSubpropertyEventFilterCondition_OneFilter {
	if m != nil {
		return m.OneFilter
	}
	return nil
}

func (x *SubpropertyEventFilterCondition) GetNullFilter() bool {
	if x, ok := x.GetOneFilter().(*SubpropertyEventFilterCondition_NullFilter); ok {
		return x.NullFilter
	}
	return false
}

func (x *SubpropertyEventFilterCondition) GetStringFilter() *SubpropertyEventFilterCondition_StringFilter {
	if x, ok := x.GetOneFilter().(*SubpropertyEventFilterCondition_StringFilter_); ok {
		return x.StringFilter
	}
	return nil
}

func (x *SubpropertyEventFilterCondition) GetFieldName() string {
	if x != nil {
		return x.FieldName
	}
	return ""
}

type isSubpropertyEventFilterCondition_OneFilter interface {
	isSubpropertyEventFilterCondition_OneFilter()
}

type SubpropertyEventFilterCondition_NullFilter struct {
	// A filter for null values.
	NullFilter bool `protobuf:"varint,2,opt,name=null_filter,json=nullFilter,proto3,oneof"`
}

type SubpropertyEventFilterCondition_StringFilter_ struct {
	// A filter for a string-type dimension that matches a particular pattern.
	StringFilter *SubpropertyEventFilterCondition_StringFilter `protobuf:"bytes,3,opt,name=string_filter,json=stringFilter,proto3,oneof"`
}

func (*SubpropertyEventFilterCondition_NullFilter) isSubpropertyEventFilterCondition_OneFilter() {}

func (*SubpropertyEventFilterCondition_StringFilter_) isSubpropertyEventFilterCondition_OneFilter() {}

// A logical expression of Subproperty event filters.
type SubpropertyEventFilterExpression struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The expression applied to a filter.
	//
	// Types that are assignable to Expr:
	//
	//	*SubpropertyEventFilterExpression_OrGroup
	//	*SubpropertyEventFilterExpression_NotExpression
	//	*SubpropertyEventFilterExpression_FilterCondition
	Expr isSubpropertyEventFilterExpression_Expr `protobuf_oneof:"expr"`
}

func (x *SubpropertyEventFilterExpression) Reset() {
	*x = SubpropertyEventFilterExpression{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_subproperty_event_filter_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SubpropertyEventFilterExpression) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SubpropertyEventFilterExpression) ProtoMessage() {}

func (x *SubpropertyEventFilterExpression) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_subproperty_event_filter_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SubpropertyEventFilterExpression.ProtoReflect.Descriptor instead.
func (*SubpropertyEventFilterExpression) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_subproperty_event_filter_proto_rawDescGZIP(), []int{1}
}

func (m *SubpropertyEventFilterExpression) GetExpr() isSubpropertyEventFilterExpression_Expr {
	if m != nil {
		return m.Expr
	}
	return nil
}

func (x *SubpropertyEventFilterExpression) GetOrGroup() *SubpropertyEventFilterExpressionList {
	if x, ok := x.GetExpr().(*SubpropertyEventFilterExpression_OrGroup); ok {
		return x.OrGroup
	}
	return nil
}

func (x *SubpropertyEventFilterExpression) GetNotExpression() *SubpropertyEventFilterExpression {
	if x, ok := x.GetExpr().(*SubpropertyEventFilterExpression_NotExpression); ok {
		return x.NotExpression
	}
	return nil
}

func (x *SubpropertyEventFilterExpression) GetFilterCondition() *SubpropertyEventFilterCondition {
	if x, ok := x.GetExpr().(*SubpropertyEventFilterExpression_FilterCondition); ok {
		return x.FilterCondition
	}
	return nil
}

type isSubpropertyEventFilterExpression_Expr interface {
	isSubpropertyEventFilterExpression_Expr()
}

type SubpropertyEventFilterExpression_OrGroup struct {
	// A list of expressions to OR’ed together. Must only contain
	// not_expression or filter_condition expressions.
	OrGroup *SubpropertyEventFilterExpressionList `protobuf:"bytes,1,opt,name=or_group,json=orGroup,proto3,oneof"`
}

type SubpropertyEventFilterExpression_NotExpression struct {
	// A filter expression to be NOT'ed (inverted, complemented). It can only
	// include a filter. This cannot be set on the top level
	// SubpropertyEventFilterExpression.
	NotExpression *SubpropertyEventFilterExpression `protobuf:"bytes,2,opt,name=not_expression,json=notExpression,proto3,oneof"`
}

type SubpropertyEventFilterExpression_FilterCondition struct {
	// Creates a filter that matches a specific event. This cannot be set on the
	// top level SubpropertyEventFilterExpression.
	FilterCondition *SubpropertyEventFilterCondition `protobuf:"bytes,3,opt,name=filter_condition,json=filterCondition,proto3,oneof"`
}

func (*SubpropertyEventFilterExpression_OrGroup) isSubpropertyEventFilterExpression_Expr() {}

func (*SubpropertyEventFilterExpression_NotExpression) isSubpropertyEventFilterExpression_Expr() {}

func (*SubpropertyEventFilterExpression_FilterCondition) isSubpropertyEventFilterExpression_Expr() {}

// A list of Subproperty event filter expressions.
type SubpropertyEventFilterExpressionList struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Unordered list. A list of Subproperty event filter expressions
	FilterExpressions []*SubpropertyEventFilterExpression `protobuf:"bytes,1,rep,name=filter_expressions,json=filterExpressions,proto3" json:"filter_expressions,omitempty"`
}

func (x *SubpropertyEventFilterExpressionList) Reset() {
	*x = SubpropertyEventFilterExpressionList{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_subproperty_event_filter_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SubpropertyEventFilterExpressionList) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SubpropertyEventFilterExpressionList) ProtoMessage() {}

func (x *SubpropertyEventFilterExpressionList) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_subproperty_event_filter_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SubpropertyEventFilterExpressionList.ProtoReflect.Descriptor instead.
func (*SubpropertyEventFilterExpressionList) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_subproperty_event_filter_proto_rawDescGZIP(), []int{2}
}

func (x *SubpropertyEventFilterExpressionList) GetFilterExpressions() []*SubpropertyEventFilterExpression {
	if x != nil {
		return x.FilterExpressions
	}
	return nil
}

// A clause for defining a filter. A filter may be inclusive (events satisfying
// the filter clause are included in the subproperty's data) or exclusive
// (events satisfying the filter clause are excluded from the subproperty's
// data).
type SubpropertyEventFilterClause struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The type for the filter clause.
	FilterClauseType SubpropertyEventFilterClause_FilterClauseType `protobuf:"varint,1,opt,name=filter_clause_type,json=filterClauseType,proto3,enum=google.analytics.admin.v1alpha.SubpropertyEventFilterClause_FilterClauseType" json:"filter_clause_type,omitempty"`
	// Required. The logical expression for what events are sent to the
	// subproperty.
	FilterExpression *SubpropertyEventFilterExpression `protobuf:"bytes,2,opt,name=filter_expression,json=filterExpression,proto3" json:"filter_expression,omitempty"`
}

func (x *SubpropertyEventFilterClause) Reset() {
	*x = SubpropertyEventFilterClause{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_subproperty_event_filter_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SubpropertyEventFilterClause) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SubpropertyEventFilterClause) ProtoMessage() {}

func (x *SubpropertyEventFilterClause) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_subproperty_event_filter_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SubpropertyEventFilterClause.ProtoReflect.Descriptor instead.
func (*SubpropertyEventFilterClause) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_subproperty_event_filter_proto_rawDescGZIP(), []int{3}
}

func (x *SubpropertyEventFilterClause) GetFilterClauseType() SubpropertyEventFilterClause_FilterClauseType {
	if x != nil {
		return x.FilterClauseType
	}
	return SubpropertyEventFilterClause_FILTER_CLAUSE_TYPE_UNSPECIFIED
}

func (x *SubpropertyEventFilterClause) GetFilterExpression() *SubpropertyEventFilterExpression {
	if x != nil {
		return x.FilterExpression
	}
	return nil
}

// A resource message representing a GA4 Subproperty event filter.
type SubpropertyEventFilter struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Format:
	// properties/{ordinary_property_id}/subpropertyEventFilters/{sub_property_event_filter}
	// Example: properties/1234/subpropertyEventFilters/5678
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Immutable. Resource name of the Subproperty that uses this filter.
	ApplyToProperty *string `protobuf:"bytes,2,opt,name=apply_to_property,json=applyToProperty,proto3,oneof" json:"apply_to_property,omitempty"`
	// Required. Unordered list. Filter clauses that define the
	// SubpropertyEventFilter. All clauses are AND'ed together to determine what
	// data is sent to the subproperty.
	FilterClauses []*SubpropertyEventFilterClause `protobuf:"bytes,3,rep,name=filter_clauses,json=filterClauses,proto3" json:"filter_clauses,omitempty"`
}

func (x *SubpropertyEventFilter) Reset() {
	*x = SubpropertyEventFilter{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_subproperty_event_filter_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SubpropertyEventFilter) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SubpropertyEventFilter) ProtoMessage() {}

func (x *SubpropertyEventFilter) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_subproperty_event_filter_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SubpropertyEventFilter.ProtoReflect.Descriptor instead.
func (*SubpropertyEventFilter) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_subproperty_event_filter_proto_rawDescGZIP(), []int{4}
}

func (x *SubpropertyEventFilter) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *SubpropertyEventFilter) GetApplyToProperty() string {
	if x != nil && x.ApplyToProperty != nil {
		return *x.ApplyToProperty
	}
	return ""
}

func (x *SubpropertyEventFilter) GetFilterClauses() []*SubpropertyEventFilterClause {
	if x != nil {
		return x.FilterClauses
	}
	return nil
}

// A filter for a string-type dimension that matches a particular pattern.
type SubpropertyEventFilterCondition_StringFilter struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The match type for the string filter.
	MatchType SubpropertyEventFilterCondition_StringFilter_MatchType `protobuf:"varint,1,opt,name=match_type,json=matchType,proto3,enum=google.analytics.admin.v1alpha.SubpropertyEventFilterCondition_StringFilter_MatchType" json:"match_type,omitempty"`
	// Required. The string value used for the matching.
	Value string `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
	// Optional. If true, the string value is case sensitive. If false, the
	// match is case-insensitive.
	CaseSensitive bool `protobuf:"varint,3,opt,name=case_sensitive,json=caseSensitive,proto3" json:"case_sensitive,omitempty"`
}

func (x *SubpropertyEventFilterCondition_StringFilter) Reset() {
	*x = SubpropertyEventFilterCondition_StringFilter{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_subproperty_event_filter_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SubpropertyEventFilterCondition_StringFilter) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SubpropertyEventFilterCondition_StringFilter) ProtoMessage() {}

func (x *SubpropertyEventFilterCondition_StringFilter) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_subproperty_event_filter_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SubpropertyEventFilterCondition_StringFilter.ProtoReflect.Descriptor instead.
func (*SubpropertyEventFilterCondition_StringFilter) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_subproperty_event_filter_proto_rawDescGZIP(), []int{0, 0}
}

func (x *SubpropertyEventFilterCondition_StringFilter) GetMatchType() SubpropertyEventFilterCondition_StringFilter_MatchType {
	if x != nil {
		return x.MatchType
	}
	return SubpropertyEventFilterCondition_StringFilter_MATCH_TYPE_UNSPECIFIED
}

func (x *SubpropertyEventFilterCondition_StringFilter) GetValue() string {
	if x != nil {
		return x.Value
	}
	return ""
}

func (x *SubpropertyEventFilterCondition_StringFilter) GetCaseSensitive() bool {
	if x != nil {
		return x.CaseSensitive
	}
	return false
}

var File_google_analytics_admin_v1alpha_subproperty_event_filter_proto protoreflect.FileDescriptor

var file_google_analytics_admin_v1alpha_subproperty_event_filter_proto_rawDesc = []byte{
	0x0a, 0x3d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69,
	0x63, 0x73, 0x2f, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x2f, 0x73, 0x75, 0x62, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x5f, 0x65, 0x76, 0x65,
	0x6e, 0x74, 0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12,
	0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63,
	0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x1a,
	0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c,
	0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xc7, 0x04, 0x0a, 0x1f,
	0x53, 0x75, 0x62, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x45, 0x76, 0x65, 0x6e, 0x74,
	0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x21, 0x0a, 0x0b, 0x6e, 0x75, 0x6c, 0x6c, 0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x08, 0x48, 0x00, 0x52, 0x0a, 0x6e, 0x75, 0x6c, 0x6c, 0x46, 0x69, 0x6c, 0x74,
	0x65, 0x72, 0x12, 0x73, 0x0a, 0x0d, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x5f, 0x66, 0x69, 0x6c,
	0x74, 0x65, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x4c, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d,
	0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x53, 0x75, 0x62, 0x70, 0x72,
	0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x46, 0x69, 0x6c, 0x74, 0x65,
	0x72, 0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e,
	0x67, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x48, 0x00, 0x52, 0x0c, 0x73, 0x74, 0x72, 0x69, 0x6e,
	0x67, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x22, 0x0a, 0x0a, 0x66, 0x69, 0x65, 0x6c, 0x64,
	0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x09, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x4e, 0x61, 0x6d, 0x65, 0x1a, 0xd9, 0x02, 0x0a, 0x0c,
	0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x7a, 0x0a, 0x0a,
	0x6d, 0x61, 0x74, 0x63, 0x68, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x56, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74,
	0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2e, 0x53, 0x75, 0x62, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x45, 0x76, 0x65,
	0x6e, 0x74, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x2e, 0x4d,
	0x61, 0x74, 0x63, 0x68, 0x54, 0x79, 0x70, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x6d,
	0x61, 0x74, 0x63, 0x68, 0x54, 0x79, 0x70, 0x65, 0x12, 0x19, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x05, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x12, 0x2a, 0x0a, 0x0e, 0x63, 0x61, 0x73, 0x65, 0x5f, 0x73, 0x65, 0x6e, 0x73,
	0x69, 0x74, 0x69, 0x76, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x0d, 0x63, 0x61, 0x73, 0x65, 0x53, 0x65, 0x6e, 0x73, 0x69, 0x74, 0x69, 0x76, 0x65, 0x22,
	0x85, 0x01, 0x0a, 0x09, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1a, 0x0a,
	0x16, 0x4d, 0x41, 0x54, 0x43, 0x48, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50,
	0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x09, 0x0a, 0x05, 0x45, 0x58, 0x41,
	0x43, 0x54, 0x10, 0x01, 0x12, 0x0f, 0x0a, 0x0b, 0x42, 0x45, 0x47, 0x49, 0x4e, 0x53, 0x5f, 0x57,
	0x49, 0x54, 0x48, 0x10, 0x02, 0x12, 0x0d, 0x0a, 0x09, 0x45, 0x4e, 0x44, 0x53, 0x5f, 0x57, 0x49,
	0x54, 0x48, 0x10, 0x03, 0x12, 0x0c, 0x0a, 0x08, 0x43, 0x4f, 0x4e, 0x54, 0x41, 0x49, 0x4e, 0x53,
	0x10, 0x04, 0x12, 0x0f, 0x0a, 0x0b, 0x46, 0x55, 0x4c, 0x4c, 0x5f, 0x52, 0x45, 0x47, 0x45, 0x58,
	0x50, 0x10, 0x05, 0x12, 0x12, 0x0a, 0x0e, 0x50, 0x41, 0x52, 0x54, 0x49, 0x41, 0x4c, 0x5f, 0x52,
	0x45, 0x47, 0x45, 0x58, 0x50, 0x10, 0x06, 0x42, 0x0c, 0x0a, 0x0a, 0x6f, 0x6e, 0x65, 0x5f, 0x66,
	0x69, 0x6c, 0x74, 0x65, 0x72, 0x22, 0xe6, 0x02, 0x0a, 0x20, 0x53, 0x75, 0x62, 0x70, 0x72, 0x6f,
	0x70, 0x65, 0x72, 0x74, 0x79, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72,
	0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x61, 0x0a, 0x08, 0x6f, 0x72,
	0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x44, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e,
	0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x53, 0x75,
	0x62, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x46, 0x69,
	0x6c, 0x74, 0x65, 0x72, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x4c, 0x69,
	0x73, 0x74, 0x48, 0x00, 0x52, 0x07, 0x6f, 0x72, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x12, 0x69, 0x0a,
	0x0e, 0x6e, 0x6f, 0x74, 0x5f, 0x65, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x53, 0x75, 0x62, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72,
	0x74, 0x79, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x45, 0x78, 0x70,
	0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x0d, 0x6e, 0x6f, 0x74, 0x45, 0x78,
	0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x6c, 0x0a, 0x10, 0x66, 0x69, 0x6c, 0x74,
	0x65, 0x72, 0x5f, 0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c,
	0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x2e, 0x53, 0x75, 0x62, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x45,
	0x76, 0x65, 0x6e, 0x74, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74,
	0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x0f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x43, 0x6f, 0x6e,
	0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x06, 0x0a, 0x04, 0x65, 0x78, 0x70, 0x72, 0x22, 0x9f,
	0x01, 0x0a, 0x24, 0x53, 0x75, 0x62, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x45, 0x76,
	0x65, 0x6e, 0x74, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73,
	0x69, 0x6f, 0x6e, 0x4c, 0x69, 0x73, 0x74, 0x12, 0x77, 0x0a, 0x12, 0x66, 0x69, 0x6c, 0x74, 0x65,
	0x72, 0x5f, 0x65, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61,
	0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x2e, 0x53, 0x75, 0x62, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79,
	0x45, 0x76, 0x65, 0x6e, 0x74, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x45, 0x78, 0x70, 0x72, 0x65,
	0x73, 0x73, 0x69, 0x6f, 0x6e, 0x42, 0x06, 0xe0, 0x41, 0x02, 0xe0, 0x41, 0x06, 0x52, 0x11, 0x66,
	0x69, 0x6c, 0x74, 0x65, 0x72, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73,
	0x22, 0xe7, 0x02, 0x0a, 0x1c, 0x53, 0x75, 0x62, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79,
	0x45, 0x76, 0x65, 0x6e, 0x74, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x43, 0x6c, 0x61, 0x75, 0x73,
	0x65, 0x12, 0x80, 0x01, 0x0a, 0x12, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x5f, 0x63, 0x6c, 0x61,
	0x75, 0x73, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x4d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63,
	0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e,
	0x53, 0x75, 0x62, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x45, 0x76, 0x65, 0x6e, 0x74,
	0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x43, 0x6c, 0x61, 0x75, 0x73, 0x65, 0x2e, 0x46, 0x69, 0x6c,
	0x74, 0x65, 0x72, 0x43, 0x6c, 0x61, 0x75, 0x73, 0x65, 0x54, 0x79, 0x70, 0x65, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x10, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x43, 0x6c, 0x61, 0x75, 0x73, 0x65,
	0x54, 0x79, 0x70, 0x65, 0x12, 0x72, 0x0a, 0x11, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x5f, 0x65,
	0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69,
	0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x2e, 0x53, 0x75, 0x62, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x45, 0x76, 0x65, 0x6e,
	0x74, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f,
	0x6e, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x10, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x45, 0x78,
	0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0x50, 0x0a, 0x10, 0x46, 0x69, 0x6c, 0x74,
	0x65, 0x72, 0x43, 0x6c, 0x61, 0x75, 0x73, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x22, 0x0a, 0x1e,
	0x46, 0x49, 0x4c, 0x54, 0x45, 0x52, 0x5f, 0x43, 0x4c, 0x41, 0x55, 0x53, 0x45, 0x5f, 0x54, 0x59,
	0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00,
	0x12, 0x0b, 0x0a, 0x07, 0x49, 0x4e, 0x43, 0x4c, 0x55, 0x44, 0x45, 0x10, 0x01, 0x12, 0x0b, 0x0a,
	0x07, 0x45, 0x58, 0x43, 0x4c, 0x55, 0x44, 0x45, 0x10, 0x02, 0x22, 0xa3, 0x03, 0x0a, 0x16, 0x53,
	0x75, 0x62, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x46,
	0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x34,
	0x0a, 0x11, 0x61, 0x70, 0x70, 0x6c, 0x79, 0x5f, 0x74, 0x6f, 0x5f, 0x70, 0x72, 0x6f, 0x70, 0x65,
	0x72, 0x74, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x05, 0x48, 0x00,
	0x52, 0x0f, 0x61, 0x70, 0x70, 0x6c, 0x79, 0x54, 0x6f, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74,
	0x79, 0x88, 0x01, 0x01, 0x12, 0x6b, 0x0a, 0x0e, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x5f, 0x63,
	0x6c, 0x61, 0x75, 0x73, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3c, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e,
	0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x53, 0x75,
	0x62, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x46, 0x69,
	0x6c, 0x74, 0x65, 0x72, 0x43, 0x6c, 0x61, 0x75, 0x73, 0x65, 0x42, 0x06, 0xe0, 0x41, 0x02, 0xe0,
	0x41, 0x06, 0x52, 0x0d, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x43, 0x6c, 0x61, 0x75, 0x73, 0x65,
	0x73, 0x3a, 0xb6, 0x01, 0xea, 0x41, 0xb2, 0x01, 0x0a, 0x34, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74,
	0x69, 0x63, 0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x75, 0x62, 0x70, 0x72, 0x6f, 0x70, 0x65,
	0x72, 0x74, 0x79, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x49,
	0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x70,
	0x65, 0x72, 0x74, 0x79, 0x7d, 0x2f, 0x73, 0x75, 0x62, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74,
	0x79, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x73, 0x2f, 0x7b, 0x73,
	0x75, 0x62, 0x5f, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x5f, 0x65, 0x76, 0x65, 0x6e,
	0x74, 0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x7d, 0x2a, 0x17, 0x73, 0x75, 0x62, 0x70, 0x72,
	0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x46, 0x69, 0x6c, 0x74, 0x65,
	0x72, 0x73, 0x32, 0x16, 0x73, 0x75, 0x62, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x45,
	0x76, 0x65, 0x6e, 0x74, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x42, 0x14, 0x0a, 0x12, 0x5f, 0x61,
	0x70, 0x70, 0x6c, 0x79, 0x5f, 0x74, 0x6f, 0x5f, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79,
	0x42, 0x83, 0x01, 0x0a, 0x22, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x42, 0x1b, 0x53, 0x75, 0x62, 0x70, 0x72, 0x6f, 0x70,
	0x65, 0x72, 0x74, 0x79, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x50,
	0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x3e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x61, 0x6e, 0x61, 0x6c,
	0x79, 0x74, 0x69, 0x63, 0x73, 0x2f, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2f, 0x61, 0x70, 0x69, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x70, 0x62, 0x3b, 0x61,
	0x64, 0x6d, 0x69, 0x6e, 0x70, 0x62, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_analytics_admin_v1alpha_subproperty_event_filter_proto_rawDescOnce sync.Once
	file_google_analytics_admin_v1alpha_subproperty_event_filter_proto_rawDescData = file_google_analytics_admin_v1alpha_subproperty_event_filter_proto_rawDesc
)

func file_google_analytics_admin_v1alpha_subproperty_event_filter_proto_rawDescGZIP() []byte {
	file_google_analytics_admin_v1alpha_subproperty_event_filter_proto_rawDescOnce.Do(func() {
		file_google_analytics_admin_v1alpha_subproperty_event_filter_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_analytics_admin_v1alpha_subproperty_event_filter_proto_rawDescData)
	})
	return file_google_analytics_admin_v1alpha_subproperty_event_filter_proto_rawDescData
}

var file_google_analytics_admin_v1alpha_subproperty_event_filter_proto_enumTypes = make([]protoimpl.EnumInfo, 2)
var file_google_analytics_admin_v1alpha_subproperty_event_filter_proto_msgTypes = make([]protoimpl.MessageInfo, 6)
var file_google_analytics_admin_v1alpha_subproperty_event_filter_proto_goTypes = []any{
	(SubpropertyEventFilterCondition_StringFilter_MatchType)(0), // 0: google.analytics.admin.v1alpha.SubpropertyEventFilterCondition.StringFilter.MatchType
	(SubpropertyEventFilterClause_FilterClauseType)(0),          // 1: google.analytics.admin.v1alpha.SubpropertyEventFilterClause.FilterClauseType
	(*SubpropertyEventFilterCondition)(nil),                     // 2: google.analytics.admin.v1alpha.SubpropertyEventFilterCondition
	(*SubpropertyEventFilterExpression)(nil),                    // 3: google.analytics.admin.v1alpha.SubpropertyEventFilterExpression
	(*SubpropertyEventFilterExpressionList)(nil),                // 4: google.analytics.admin.v1alpha.SubpropertyEventFilterExpressionList
	(*SubpropertyEventFilterClause)(nil),                        // 5: google.analytics.admin.v1alpha.SubpropertyEventFilterClause
	(*SubpropertyEventFilter)(nil),                              // 6: google.analytics.admin.v1alpha.SubpropertyEventFilter
	(*SubpropertyEventFilterCondition_StringFilter)(nil),        // 7: google.analytics.admin.v1alpha.SubpropertyEventFilterCondition.StringFilter
}
var file_google_analytics_admin_v1alpha_subproperty_event_filter_proto_depIdxs = []int32{
	7, // 0: google.analytics.admin.v1alpha.SubpropertyEventFilterCondition.string_filter:type_name -> google.analytics.admin.v1alpha.SubpropertyEventFilterCondition.StringFilter
	4, // 1: google.analytics.admin.v1alpha.SubpropertyEventFilterExpression.or_group:type_name -> google.analytics.admin.v1alpha.SubpropertyEventFilterExpressionList
	3, // 2: google.analytics.admin.v1alpha.SubpropertyEventFilterExpression.not_expression:type_name -> google.analytics.admin.v1alpha.SubpropertyEventFilterExpression
	2, // 3: google.analytics.admin.v1alpha.SubpropertyEventFilterExpression.filter_condition:type_name -> google.analytics.admin.v1alpha.SubpropertyEventFilterCondition
	3, // 4: google.analytics.admin.v1alpha.SubpropertyEventFilterExpressionList.filter_expressions:type_name -> google.analytics.admin.v1alpha.SubpropertyEventFilterExpression
	1, // 5: google.analytics.admin.v1alpha.SubpropertyEventFilterClause.filter_clause_type:type_name -> google.analytics.admin.v1alpha.SubpropertyEventFilterClause.FilterClauseType
	3, // 6: google.analytics.admin.v1alpha.SubpropertyEventFilterClause.filter_expression:type_name -> google.analytics.admin.v1alpha.SubpropertyEventFilterExpression
	5, // 7: google.analytics.admin.v1alpha.SubpropertyEventFilter.filter_clauses:type_name -> google.analytics.admin.v1alpha.SubpropertyEventFilterClause
	0, // 8: google.analytics.admin.v1alpha.SubpropertyEventFilterCondition.StringFilter.match_type:type_name -> google.analytics.admin.v1alpha.SubpropertyEventFilterCondition.StringFilter.MatchType
	9, // [9:9] is the sub-list for method output_type
	9, // [9:9] is the sub-list for method input_type
	9, // [9:9] is the sub-list for extension type_name
	9, // [9:9] is the sub-list for extension extendee
	0, // [0:9] is the sub-list for field type_name
}

func init() { file_google_analytics_admin_v1alpha_subproperty_event_filter_proto_init() }
func file_google_analytics_admin_v1alpha_subproperty_event_filter_proto_init() {
	if File_google_analytics_admin_v1alpha_subproperty_event_filter_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_analytics_admin_v1alpha_subproperty_event_filter_proto_msgTypes[0].Exporter = func(v any, i int) any {
			switch v := v.(*SubpropertyEventFilterCondition); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_subproperty_event_filter_proto_msgTypes[1].Exporter = func(v any, i int) any {
			switch v := v.(*SubpropertyEventFilterExpression); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_subproperty_event_filter_proto_msgTypes[2].Exporter = func(v any, i int) any {
			switch v := v.(*SubpropertyEventFilterExpressionList); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_subproperty_event_filter_proto_msgTypes[3].Exporter = func(v any, i int) any {
			switch v := v.(*SubpropertyEventFilterClause); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_subproperty_event_filter_proto_msgTypes[4].Exporter = func(v any, i int) any {
			switch v := v.(*SubpropertyEventFilter); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_subproperty_event_filter_proto_msgTypes[5].Exporter = func(v any, i int) any {
			switch v := v.(*SubpropertyEventFilterCondition_StringFilter); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_analytics_admin_v1alpha_subproperty_event_filter_proto_msgTypes[0].OneofWrappers = []any{
		(*SubpropertyEventFilterCondition_NullFilter)(nil),
		(*SubpropertyEventFilterCondition_StringFilter_)(nil),
	}
	file_google_analytics_admin_v1alpha_subproperty_event_filter_proto_msgTypes[1].OneofWrappers = []any{
		(*SubpropertyEventFilterExpression_OrGroup)(nil),
		(*SubpropertyEventFilterExpression_NotExpression)(nil),
		(*SubpropertyEventFilterExpression_FilterCondition)(nil),
	}
	file_google_analytics_admin_v1alpha_subproperty_event_filter_proto_msgTypes[4].OneofWrappers = []any{}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_analytics_admin_v1alpha_subproperty_event_filter_proto_rawDesc,
			NumEnums:      2,
			NumMessages:   6,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_analytics_admin_v1alpha_subproperty_event_filter_proto_goTypes,
		DependencyIndexes: file_google_analytics_admin_v1alpha_subproperty_event_filter_proto_depIdxs,
		EnumInfos:         file_google_analytics_admin_v1alpha_subproperty_event_filter_proto_enumTypes,
		MessageInfos:      file_google_analytics_admin_v1alpha_subproperty_event_filter_proto_msgTypes,
	}.Build()
	File_google_analytics_admin_v1alpha_subproperty_event_filter_proto = out.File
	file_google_analytics_admin_v1alpha_subproperty_event_filter_proto_rawDesc = nil
	file_google_analytics_admin_v1alpha_subproperty_event_filter_proto_goTypes = nil
	file_google_analytics_admin_v1alpha_subproperty_event_filter_proto_depIdxs = nil
}
