/*
 *  Copyright (C) 1999,2001,2004,2005,2007  Anders Gavare.  All rights reserved.
 *
 *  Redistribution and use in source and binary forms, with or without
 *  modification, are permitted provided that the following conditions are met:
 *
 *  1. Redistributions of source code must retain the above copyright
 *     notice, this list of conditions and the following disclaimer.
 *  2. Redistributions in binary form must reproduce the above copyright
 *     notice, this list of conditions and the following disclaimer in the
 *     documentation and/or other materials provided with the distribution.
 *  3. The name of the author may not be used to endorse or promote products
 *     derived from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 *  ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 *  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 *  ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 *  FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 *  DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 *  OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 *  HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 *  LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 *  OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 *  SUCH DAMAGE.
 *
 *
 *  $Id: main.c,v 1.6 2005/02/18 08:43:46 debug Exp $
 */

#include <limits.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <dirent.h>
#include <ctype.h>
#include <sys/stat.h>
#include <sys/types.h>
#include "global.h"


extern int directory_depth;

char *progname;
int some_error = 0;

/*  html colors:  */
#define COLORLEN        6+1
char    body_textcolor[COLORLEN];
char    body_bgcolor[COLORLEN];
char    body_commentcolor[COLORLEN];
char    body_stringcolor[COLORLEN];
char    body_reservedcolor[COLORLEN];
char    body_preproccolor[COLORLEN];
char *ip_webbug = NULL;
char *header_filename = NULL;
char *footer_filename = NULL;


/*
 *  show_usage():
 *
 *  Show invokation syntax.
 */
void show_usage(void)
{
	fprintf(stderr, "usage: %s name [...]\n", progname);
	fprintf(stderr, "You may set the environment variable WEBBUG to an internet address to be used\n");
	fprintf(stderr, "for a webbug, ie WEBBUG=123.45.67.89  or WEBBUG=my.domain.com,\n");
	fprintf(stderr, "and HEADER_FILENAME and FOOTER_FILENAME are html files to prepend and append\n");
	fprintf(stderr, "to the output.\n");
}


/*
 *  scan_fileordir():
 */
void scan_fileordir(FILE *fout, char *name)
{
	struct stat s;
	int r;
	char *name2;
	DIR *dirp;
	int name2len;
	struct dirent *dp;

	r = stat(name, &s);
	if (r) {
		perror(name);
		some_error = 1;
		return;
	}

	if (S_ISDIR(s.st_mode)) {
		dirp = opendir(name);
		if (dirp != NULL) {
			directory_depth ++;
			name2len = strlen(name) + 1 + MAXNAMELEN + 1;
			name2 = (char *) malloc(name2len);
			if (name2 == NULL) {
				fprintf(stderr, "%s: out of memory\n", progname);
				exit(1);
			}
			while ((dp = readdir(dirp)) != NULL) {
				if (!ignore_name(dp->d_name)) {
					snprintf(name2, name2len, "%s/%s", name, dp->d_name);
					scan_fileordir(fout, name2);
				}
			}
			directory_depth --;
			closedir(dirp);
			free(name2);
		} else {
			perror(name);
			some_error = 1;
			return;
		}
	} else if (S_ISREG(s.st_mode)) {
		scanfile(fout, name);
	} else {
		fprintf(stderr, "scan_fileordir: %s is not a regular file or directory\n", name);
		some_error = 1;
		return;
	}
}


/*
 *  c2html_fileordir():
 */
void c2html_fileordir(char *name)
{
	struct stat s;
	int r;
	char *name2;
	DIR *dirp;
	int name2len;
	struct dirent *dp;
	unsigned char *buf;
	FILE *f, *fout;
	off_t filesize;

	r = stat(name, &s);
	if (r) {
		perror(name);
		some_error = 1;
		return;
	}

	if (S_ISDIR(s.st_mode)) {
		directory_depth ++;
		do_directory(name);
		dirp = opendir(name);
		if (dirp != NULL) {
			name2len = strlen(name) + 1 + MAXNAMELEN + 1;
			name2 = (char *) malloc(name2len);
			if (name2 == NULL) {
				fprintf(stderr, "%s: out of memory\n", progname);
				exit(1);
			}
			while ((dp = readdir(dirp)) != NULL) {
				if (!ignore_name(dp->d_name)) {
					snprintf(name2, name2len, "%s/%s", name, dp->d_name);
					c2html_fileordir(name2);
				}
			}
			closedir(dirp);
			free(name2);
		} else {
			perror(name);
			some_error = 1;
			directory_depth --;
			return;
		}
		directory_depth --;
	} else if ( S_ISREG(s.st_mode) && (strlen(name)<5 || strcmp(name+strlen(name)-5, ".html")!=0) ) {
		f = fopen(name, "r");
		if (f == NULL)
			fprintf(stderr, "%s: could not open %s for reading\n", progname, name);
		else {
			fseek(f, 0, SEEK_END);
			filesize = ftell(f);
			fseek(f, 0, SEEK_SET);
			buf = (unsigned char *) malloc(filesize);
			if (buf == NULL) {
				fprintf(stderr, "%s: out of memory\n",
				    progname);
				exit(1);
			}

			fread(buf, 1, filesize, f);
			name2 = (char *) malloc(strlen(name) + 10);
			if (name2 == NULL) {
				fprintf(stderr, "out of memory\n");
				exit(1);
			}
			sprintf(name2, "%s.html", name);
			if (name2 && (fout=fopen(name2, "w"))) {
				html_header(fout, name);
				if (!strncmp(name+strlen(name)-2, ".c", 2) ||
				    !strncmp(name+strlen(name)-2, ".h", 2) )
					send_buf_in_color(fout, (char *)buf,
					    filesize, name);
				else
					fwrite(buf, 1, filesize, fout);
				html_ending (fout, name);
				fclose(fout);
			} else
				fprintf(stderr, "%s: could not open output file '%s'\n", progname, name2);
			free(name2);
			free (buf);
			fclose(f);
		}
	}
}



char **strings = NULL;
int nr_of_strings = 0;


/*
 *  add_string():
 */
void add_string(char *string)
{
	if (string == NULL)
		return;

	/*  Realloc strings to allow for one more string:  */
	nr_of_strings++;
	if (strings == NULL)
		strings = (char **) malloc(sizeof(char *) * nr_of_strings);
	else
		strings = (char **) realloc(strings, sizeof(char *) * nr_of_strings);

	if (strings == NULL) {
		fprintf(stderr, "out of memory in add_string(): 1\n");
		exit(1);
	}

	strings[nr_of_strings-1] = (char *) malloc(strlen(string) + 1);
	if (strings[nr_of_strings-1] == NULL) {
		fprintf(stderr, "out of memory in add_string(): 2\n");
		exit(1);
	}

	strcpy(strings[nr_of_strings-1], string);
}


/*
 *  main():
 */
int main(int argc, char *argv[])
{
	char s[300];
	FILE *temp;
	int i;

	strcpy(body_textcolor, DEFAULT_FGCOLOR);
	strcpy(body_bgcolor, DEFAULT_BGCOLOR);
	strcpy(body_commentcolor, DEFAULT_COMMENTCOLOR);
	strcpy(body_stringcolor, DEFAULT_STRINGCOLOR);
	strcpy(body_reservedcolor, DEFAULT_RESERVEDCOLOR);
	strcpy(body_preproccolor, DEFAULT_PREPROCCOLOR);

	ip_webbug = getenv("WEBBUG");
	header_filename = getenv("HEADER_FILENAME");
	footer_filename = getenv("FOOTER_FILENAME");

	progname = argv[0];
	if (argc==1) {
		show_usage();
		exit(1);
	}

	printf("C2HTML  Copyright(C) 1999-2005  Anders Gavare\n");

	if ((temp = tmpfile()) == NULL) {
		fprintf(stderr, "%s: could not create temporary file\n",
		    progname);
		exit(1);
	}

	printf ("scanning files...\n");
	for (i=1; i<argc; i++)
		scan_fileordir(temp, argv[i]);

	fseek(temp, 0, SEEK_SET);
	while (!feof(temp)) {
		s[0]=0;
		fgets(s, sizeof(s), temp);
		if (isdigit(s[0]))
			add_string(s);
	}

	printf ("radixsort...\n");
	i = radixsort((const u_char **)strings, nr_of_strings, NULL, 0);
	if (i)
		printf("radixsort result = %i\n", i);

	/*  for (i=0; i<nr_of_strings; i++)
		printf("strings[%i]: %s", i, strings[i]);  */

	printf("build_ht...\n");
	build_ht(strings, nr_of_strings);

	printf("converting files...\n");
	for (i=1; i<argc; i++)
		c2html_fileordir(argv[i]);

	return (some_error)? 1 : 0;
}

