/*
 *  Copyright (C) 1999,2004,2005,2007  Anders Gavare.  All rights reserved.
 *
 *  Redistribution and use in source and binary forms, with or without
 *  modification, are permitted provided that the following conditions are met:
 *
 *  1. Redistributions of source code must retain the above copyright
 *     notice, this list of conditions and the following disclaimer.
 *  2. Redistributions in binary form must reproduce the above copyright
 *     notice, this list of conditions and the following disclaimer in the
 *     documentation and/or other materials provided with the distribution.
 *  3. The name of the author may not be used to endorse or promote products
 *     derived from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 *  ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 *  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 *  ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 *  FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 *  DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 *  OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 *  HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 *  LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 *  OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 *  SUCH DAMAGE.
 *
 *
 *  $Id: is_reserved.c,v 1.3 2005/02/11 22:41:38 debug Exp $
 *
 *  is_reserved() tells if a word is reserved in the C language.
 *  is_bufword_reserved() tells if the word at the specified
 *  position in a buffer is reserved.
 */

#include "global.h"
#include <stdio.h>
#include <string.h>
#include <ctype.h>


char *reserved_words[] = {
	"auto",		"enum",		"signed",	"unsigned",
	"sizeof",	"volatile",	"const",	"if",
	"else",		"goto",		"while",	"continue",
	"break",	"switch",	"case",		"default",
	"char",		"int",		"void",		"float",
	"double",	"short",	"long",		"static",
	"extern",	"register",	"struct",	"typedef",
	"union",	"for",		"do",		"return",
        NULL
        };


/*
 *  is_reserved():
 */
int is_reserved(char *word)
{
	int wnr = 0;

	while (reserved_words[wnr]) {
		if (strcmp(word, reserved_words[wnr]) == 0)
			return 1;
		wnr++;
	}

	return 0;
}


/*
 *  is_bufword_reserved():
 */
int is_bufword_reserved(char *buf, int pos)
{
	char tmpword[SHORTSTR];
	int t;

	if (buf == NULL)
		return 0;

	/*  Is the character to the left of the word okey?  */
	if (pos>0)
	if ( (isalnum(buf[pos-1])) || (buf[pos-1]=='_') )
		return 0;

	/*  Find the end of the word:  */
	t = pos;
	while ( (isalnum(buf[t])) || (buf[t]=='_') )
		t++;

	if (t-pos >= SHORTSTR-1)
		return 0;

	strncpy(tmpword, buf+pos, t-pos);
	tmpword[t-pos] = 0;
	return is_reserved(tmpword);
}

