;; NOTE: Assertions have been generated by update_lit_checks.py --all-items and should not be edited.
;; RUN: foreach %s %t wasm-opt -all --gufa -S -o - | filecheck %s

;; Two tags with different values.
(module
  ;; CHECK:      (type $0 (func (param i32)))

  ;; CHECK:      (type $1 (func (param f32)))

  ;; CHECK:      (type $2 (func))

  ;; CHECK:      (type $3 (func (result i32)))

  ;; CHECK:      (tag $tag$i32 (param i32))
  (tag $tag$i32 (param i32))
  ;; CHECK:      (tag $tag$f32 (param f32))
  (tag $tag$f32 (param f32))

  ;; CHECK:      (func $test (type $2)
  ;; CHECK-NEXT:  (local $0 i32)
  ;; CHECK-NEXT:  (local $1 f32)
  ;; CHECK-NEXT:  (try $try
  ;; CHECK-NEXT:   (do
  ;; CHECK-NEXT:    (throw $tag$i32
  ;; CHECK-NEXT:     (i32.const 42)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (catch $tag$i32
  ;; CHECK-NEXT:    (local.set $0
  ;; CHECK-NEXT:     (pop i32)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:    (drop
  ;; CHECK-NEXT:     (block (result i32)
  ;; CHECK-NEXT:      (drop
  ;; CHECK-NEXT:       (local.get $0)
  ;; CHECK-NEXT:      )
  ;; CHECK-NEXT:      (i32.const 42)
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (catch $tag$f32
  ;; CHECK-NEXT:    (local.set $1
  ;; CHECK-NEXT:     (pop f32)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:    (drop
  ;; CHECK-NEXT:     (block
  ;; CHECK-NEXT:      (drop
  ;; CHECK-NEXT:       (local.get $1)
  ;; CHECK-NEXT:      )
  ;; CHECK-NEXT:      (unreachable)
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $test
    (try
      (do
        (throw $tag$i32
          (i32.const 42)
        )
      )
      (catch $tag$i32
        ;; We always throw a 42 to this tag, so we can optimize this.
        (drop
          (pop i32)
        )
      )
      (catch $tag$f32
        ;; We never actually throw this, so it can be turned into an
        ;; unreachable.
        (drop
          (pop f32)
        )
      )
    )
  )

  ;; CHECK:      (func $bar (type $3) (result i32)
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (try $try (result i32)
  ;; CHECK-NEXT:    (do
  ;; CHECK-NEXT:     (i32.const 42)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:    (catch $tag$i32
  ;; CHECK-NEXT:     (drop
  ;; CHECK-NEXT:      (pop i32)
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:     (i32.const 42)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (i32.const 42)
  ;; CHECK-NEXT: )
  (func $bar (result i32)
    ;; Like the first case, we can optimize the pop here. The pop and the try
    ;; body agree on the value, 42, so we can replace the entire try in theory,
    ;; but we should not - removing the try would leave a pop without a proper
    ;; parent (that is a problem even though the try does not have a name). We
    ;; can still emit a 42 for the try, but must leave the try right before it,
    ;; dropped.
    (try (result i32)
      (do
        (i32.const 42)
      )
      (catch $tag$i32
        (pop i32)
      )
    )
  )
)
