#include "chkio.h"

FILE *
 chkfopen(char *path, char *mode)
{
    FILE *file;

    if ((file = fopen(path, mode)) == NULL) {
	printf("Couldn't open file.  Exiting.\n");
	exit(0);
    }
    return (file);
}


void chkfread(void *data, size_t type, size_t number, FILE * stream)
{
    if (fread(data, type, number, stream) != number) {
	printf("Error reading file.  Exiting.\n");
	exit(0);
    }
}


void chkfwrite(void *data, size_t type, size_t number, FILE * stream)
{
    if (fwrite(data, type, number, stream) != number) {
	printf("Error writing file.  Exiting.\n");
	exit(0);
    }
}


int chkfseek(FILE * stream, long offset, int whence)
{
    int val;

    if ((val = fseek(stream, offset, whence)) == -1) {
	printf("Error seeking file. Exiting.\n");
	exit(0);
    }
    return (val);
}


int chkfstat(int filedes, struct stat *buf)
{
    int val;

    if ((val = fstat(filedes, buf)) == -1) {
	perror("Error with fstat.  Exiting.\n");
	exit(0);
    }
    return (val);
}
