      SUBROUTINE MFFTRP(NN,RW)
*
*  THIS ROUTINE PREPARES THE PHASE FACTOR TABLES TO BE USED IN THE
*  POST-PROCESSING PHASE IN REAL TRANSFORMS, I.E. R2FFT AND R3FFT.
*
*  THE DEFINITION OF PHASE FACTORS WE USE IS THE FOLLOWING
*
*             RW(IV) = -I*EXP(-I*2*PI/NN*IV)
*
*  WHERE THE SYMBOLS ARE:
*
*  I: IMAGINARY UNIT
*  NN : NUMBER OF REAL ELEMENTS
*  IV: RUNNING INDEX FROM 0 TO NN-1
*
*
*
*
      COMPLEX RW(0:*)
*
*
      PI2=8*ATAN(1.)
      PHASE=PI2/NN
      RW(0)=(0.,-1.)
*
*
      DO 10 I=1,NN-1
      RW(I)=CMPLX(-SIN(I*PHASE),-COS(I*PHASE))
 10   CONTINUE
*
*
      END
