      SUBROUTINE MFFTP(N,W,ID,IERR)
*
*     THIS SUBROUTINE PREPARES TABLES FOR USE BY THE MFFT
*     ROUTINES. THE PARAMETERS ARE
*
*     N : IS THE ORDER OF THE TRANSFORM;
*
*     W : ARRAY OF LENGTH AT LEAST 4*N+14  WORDS IF ID=0,
*      AND 4*N*(ID+1)+14 IF ID > 0 ; THIS ARRAY IS FILLED
*      BY THE PRESENT ROUTINE, AND SHOULD NOT BE MODIFIED BY THE
*      USER; IT IS REQUIRED BY ALL THE OPERATING ROUTINES;
*      THE ROUTINES MFFTIS AND MFFTDS
*      REQUIRE THAT W HAS BEEN FILLED BY A CALL TO MFFTP WITH
*      ID .GT. 0 ; ALL THE ROUTINES DO NOT MODIFY THE CONTENTS
*      OF W ;
*      WARNING: DIFFERENT PORTIONS OF W ARE HANDLED AS COMPLEX OR
*               INTEGER VARIABLES BY DIFFERENT ROUTINES.
*
*     ID : IF ID .EQ. 0 THE TABLES ARE SET FOR A NORMAL
*      TRANSFORM; IF ID .GT. 0 THE TABLES ARE SET FOR BOTH
*      A NORMAL AND A "SPECIAL" TRANSFORM (I.E. OPTIMIZED FOR SMALL
*      FIRST DIMENSION DATA ARRAYS, SEE REF.[2]); IN THIS CASE IT
*      SHOULD BE EQUAL TO THE FIRST DIMENSION OF THE ARRAY TO BE
*      TRANSFORMED, AS DECLARED IN THE CALLING PROGRAM.
*
*     IERR : ERROR CODE : =0 : SUCCESSFUL
*                       : =2 : FACTORIZATION ERROR
*
*
*************************************************************
*
*      REFERENCE INFORMATION : LAYOUT OF W
*
*  IN ALL CASES
*
* WORD ADDRESS      TYPE    N. OF EL. WORD LENGTH   PURPOSE
*
*  0                INTEGER      14      14     FACTORIZATION OF N
*
*  14               COMPLEX     N       2*N     EXP(I*P/(2*N)*K),K=
*                                               0,N-1
*  3*N+14           INTEGER     N        N      PERMUTATION INDEX:KOFI
*  2*N+14           INTEGER     N        N      PERMUTATION INDEX:IOFK
*
*  ONLY IF ID .GT. 0
*
*  4*N+14           COMPLEX    N*ID     2*N*ID  TABLES FOR MFFTDS
*  4*N+2*N*ID+14    COMPLEX    N*ID     2*N*ID  TABLES FOR MFFTIS
*
*
*
*******************************************************************
      COMPLEX W(-7:*)
 
*...  FACTORIZATION OF N IN W(-7)..W(-1)
      CALL MFFTP1(W(-7),N,IERR)
      IF(IERR.NE.0)RETURN
*
*     PREPARATION OF PERMUTATION INDEXES IN W(N)..W(2*N-1)
*     WARNING : W(0)..W(N-1) USED AS A WORK SPACE
      CALL MFFTP2(W(N),W(0),W(-7),N)
*
*     PREPARATION OF PHASE FACTOR TABLE IN W(0)..W(N-1)
      W(0)=1.0
      PI2DN=ATAN(1.)*8./N
      DO 1  I=1,N-1
        W(I)=CMPLX(COS(PI2DN*I),SIN(PI2DN*I))
1     CONTINUE
*
*     IF TABLES FOR SPECIAL TRANSFORM ARE REQUESTED
      IF(ID.GT.0)THEN
        CALL MFFTP4(W(0),W(2*N),W(-7),N,ID)
      ENDIF
*
      END
