/* pda_f2c_dcffti.f -- translated by f2c (version 19941113).
   You must link the resulting object file with the libraries:
	-lf2c -lm   (in that order)
*/

#include <fftw.h>
typedef FFTW_REAL real;

/*
******************************************************************

subroutine dcffti(n,wsave)

******************************************************************

subroutine dcffti initializes the array wsave which is used in
both dcfftf and dcfftb. the prime factorization of n together with
a tabulation of the trigonometric functions are computed and
stored in wsave.

input parameter

n       the length of the sequence to be transformed

output parameter

wsave   a work array which must be dimensioned at least 4*n+15
        the same work array can be used for both dcfftf and dcfftb
        as long as n remains unchanged. different wsave arrays
        are required for different values of n. the contents of
        wsave must not be changed between calls of dcfftf or dcfftb.

******************************************************************
*/

/* Subroutine */ int pda_f2c_dcffti(int *n, real *wsave)
{
    extern /* Subroutine */ int pda_f2c_dcfti1(int *, real *, 
	    real *);
    static int iw1, iw2;

    /* Parameter adjustments */
    --wsave;

    /* Function Body */
    if (*n == 1) {
	return 0;
    }
    iw1 = *n + *n + 1;
    iw2 = iw1 + *n + *n;
    pda_f2c_dcfti1(n, &wsave[iw1], &wsave[iw2]);
    return 0;
} /* pda_f2c_dcffti */

