#include <stdlib.h>

#include "fxtaux.h"


void 
mat_transpose2(FFTW_REAL *x, int rw, int cl)
/*
//  matrix transpose
//  only for n*n or n*2n or 2n*n matrix !
*/
{
    int i,j;
    int i1,i2;
    FFTW_REAL *y, *z;

    if(rw==cl)
    {
        for(i=1; i<rw; ++i)
        {
            y=x+i*cl;
            z=x+i;
            for(j=0; j<i; ++j)
            {
                SWAP(*y,*z);
                y++;
                z+=cl;
            }
        }
    }
    else  
    {
        FFTW_REAL *wd;

	wd = malloc(sizeof(FFTW_REAL) * (MAX(rw,cl)));
        
	/* was: FFTW_REAL wd[MAX(rw,cl)]; */
    
        if(cl>rw)
        {
	    int clh=cl/2;
    
            for(i=0; i<rw; ++i)
            {
    
                i1=i*cl;
                i2=i1+1;                 
                for(j=0; j<clh; j++)
                {
                    wd[j]=  x[i1];
                    wd[clh+j]=x[i2];

                    i1+=2;
                    i2+=2;
                }
    
                i1=i*cl;
                for(j=0; j<cl; j++)
                {
                    x[i1]=wd[j];
                    i1++;
                }
            }
    
            for(i=0; i<rw; ++i)
            {
                i1=i*cl;
                i2=i;
                for(j=0; j<i; ++j)
                {
                    SWAP(x[i1],x[i2]);
                    i1++;
                    i2+=cl;
                }
            }
    
            for(i=0; i<rw; ++i)
            {
                i1=i*cl+clh;
                i2=i+clh;
                for(j=0; j<i; ++j)
                {
                    SWAP(x[i1],x[i2]);
                    i1++;
                    i2+=cl;
                }
            }
        }
        else  
        {
	    int rwh=rw/2;
    
            for(i=0; i<rwh; ++i)
            {
                i1=i*rwh;
                i2=i; 
                for(j=0; j<i; ++j)
                {
                    SWAP(x[i1],x[i2]);
                    i1++;
                    i2+=rwh;
                }
            }
    
            for(i=0; i<rwh; ++i)
            {
                i1=rwh*(rwh+i);
                i2=rwh*rwh+i;

                for(j=0; j<i; ++j)
                {
                    SWAP(x[i1],x[i2]);
                    i1++;
                    i2+=rwh;
                }
            }
    
            for(j=0; j<cl; ++j)
            {

                int i3=0; 
                i1=j;
                i2=j+rwh*rwh;

                for(i=0; i<rwh; ++i)
                {
                    wd[i3]=  x[i1];
                    wd[++i3]=x[i2];
                    i3++;
                    i1+=cl;
                    i2+=cl;

                }
    
                i1=j;
                for(i=0; i<rw; ++i)
                {
                    x[i1]=wd[i];
                    i1+=cl;
                }
            }
        }

	free(wd);
    }
}
