/*
 * Copyright (c)  2000
 * SWsoft  company
 *
 * This material is provided "as is", with absolutely no warranty expressed
 * or implied. Any use is at your own risk.
 *
 * Permission to use or copy this software for any purpose is hereby granted 
 * without fee, provided the above notices are retained on all copies.
 * Permission to modify the code and to distribute modified code is granted,
 * provided the above notices are retained, and a notice that the code was
 * modified is included with the above copyright notice.
 *
 */

#ifndef STACK_H
#define STACK_H

#include "ccom.h"

class CStackElem
{
	int m_refCount;
public:
	int AddRef() {return ++m_refCount;};
	void Release() {if (--m_refCount == 0) delete this;};
	CStackElem() {m_refCount = 0;};
	virtual char* ClassName() = 0;
	virtual ~CStackElem() {};
};

class Stack : public std::vector<CPtr<CStackElem> >
{
public:
	~Stack()
	{
		for (CPtr<CStackElem>* expr = begin(); expr < end(); expr++)
		{
			expr->~CPtr();
		}
	}

/*
	CStackElem* removeLast()
	{
		return *erase((CPtr<CStackElem>*)&back());
	}
*/
	void removeLast(CPtr<CStackElem>& elem)
	{
		elem = back();
		erase((CPtr<CStackElem>*)&back());
	}

	CStackElem* last()
	{
		return back();
	}

	void addLast_(CStackElem* elem)
	{
		insert(end(), elem);
	}
};
/*
class CBoolToken : public CStackElem
{
public:
	virtual BOOL Value() = 0;
};

class CFalse : public CBoolToken
{
public:
	virtual char* ClassName() {return "CFalse";};
	virtual BOOL Value() {return false;};

};

class CTrue : public CBoolToken
{
public:
	virtual char* ClassName() {return "CTrue";};
	virtual BOOL Value() {return true;};
};
*/
class CNumToken : public CStackElem
{
public:
	int m_value;

public:
	CNumToken(int value) {m_value = value;};
	virtual char* ClassName() {return "CNumToken";};
};

extern char* Empty;

class CToken : public CStackElem
{
public:
	char* m_token;

public:
	virtual char* ClassName() {return "CToken";};

public:
	CToken(char* p_token)
	{
		m_token = p_token;
	};
	virtual ~CToken()
	{
		if (m_token && (m_token != Empty))
		delete m_token;
	}
};

class CTokenArray : public CStackElem
{
public:
	Stack m_tokens;

public:
	virtual char* ClassName() {return "CTokenArray";};

public:
	CTokenArray() {};
	CTokenArray(Stack& p_stack, int p_iLast)
	{
		int iFirst = p_stack.size() - p_iLast;
		m_tokens.insert(m_tokens.end(), (CPtr<CStackElem>*)&p_stack[iFirst], p_stack.end());
		p_stack.resize(iFirst);
/*		for (int i = iFirst; i < p_stack.size(); i++)
		{
			m_tokens.insert(m_tokens.end(), p_stack[i]);
		}*/
//		p_stack.erase((CPtr<CStackElem>*)&p_stack[iFirst], p_stack.end());
	}
	~CTokenArray()
	{
/*		for (int i = 0; i < m_tokens.size(); i++)
		{
			m_tokens[i]->Release();
		}*/
	}
	int size() {return m_tokens.size();};
};

#endif