/* Copyright (C) 2000, 2001  SWsoft, Singapore                                  
 *                                                                              
 *  This program is free software; you can redistribute it and/or modify        
 *  it under the terms of the GNU General Public License as published by        
 *  the Free Software Foundation; either version 2 of the License, or           
 *  (at your option) any later version.                                         
 *                                                                              
 *  This program is distributed in the hope that it will be useful,             
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of              
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               
 *  GNU General Public License for more details.                                
 *                                                                              
 *  You should have received a copy of the GNU General Public License           
 *  along with this program; if not, write to the Free Software                 
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA   
 */



#ifdef SWSOFT

#include "myodbc.h"
#include "dialogs.h"
#ifndef _LIB
#include <stdio.h>
#include "odbcinst.h"					// ODBC installer prototypes
#endif

#ifdef SWSOFT_LIB
#include <libver.h>
#endif


#include <ctl3d.h>
#include <commctrl.h>
extern void INTFUNC CenterDialog (HWND   hdlg);

#define		SOFTWARE	"Software"
#define		BSLASH		"\\"
#define		SW			"SWsoft"
#ifndef _LIB
#define		COLIBRI		"Colibri"
#else
#define		COLIBRI		"Colibri.OLEDB for Btrieve"
#endif
#define		ENGINE		"Engine"
#define		BASEDIR		"BaseDir"
#define		KEY_ENGINE	SOFTWARE BSLASH SW BSLASH COLIBRI BSLASH ENGINE
#define		KEY_BASEDIR	SOFTWARE BSLASH SW BSLASH COLIBRI BSLASH BASEDIR
#define		MYSQLD_DLL	"mysqld.dll"

#define BTRV_MAX_PATH	80
#define TBL_NAME_MAX	64

static char g_szEngine[ MAX_PATH+1 ] = "", g_szBaseDir[ MAX_PATH+10 ] = "", g_szDataDir[ MAX_PATH+10 ] = "";
static char* g_ppszEngineParms[] = { g_szEngine, "--console", "--skip-grant-tables", "--default-table-type=BTRIEVE_DB", g_szBaseDir, g_szDataDir };
static HINSTANCE g_hLib = NULL;

extern int RegisterTables(BOOL ask, const char* path, HWND hwnd);
extern int UnRegisterTables(BOOL ask, const char* path, HWND hwnd, char* lpTableName);
extern void ShowHelp(HWND hdlg,const char * topic);

DWORD WINAPI MySqlLibMainThreadFunc(LPVOID lpParameter)
{
	int (*mysqld_main)(int, char **) = (int (*)(int argc, char **argv)) GetProcAddress( g_hLib, "mysqld_main" );
	return (*mysqld_main)(sizeof(g_ppszEngineParms)/sizeof(g_ppszEngineParms[0]), g_ppszEngineParms);
}

enum EngineTypes { NO_ENGINE, ENGINE_EXE, ENGINE_DLL } GetEngineInfo()
{
  long iLen1, iLen2;

  if( setupdlg_db_type() != SETUPDLG_BTRIEVE )
	  return NO_ENGINE;

  /* Query data stored in registry */
  iLen1 = iLen2 = sizeof(g_szEngine)/sizeof(g_szEngine[0]);
  if( RegQueryValue( HKEY_CURRENT_USER,  KEY_ENGINE, g_szEngine, &iLen1) != ERROR_SUCCESS &&
	  RegQueryValue( HKEY_LOCAL_MACHINE, KEY_ENGINE, g_szEngine, &iLen2) != ERROR_SUCCESS )
	  return NO_ENGINE;

  return strstr(g_szEngine, ".exe") ? ENGINE_EXE : ENGINE_DLL;
}

BOOL StartEngine( enum EngineTypes engineType, const char* sysdb, int port )
{
  char szBaseDir[ MAX_PATH + 1 ], szEngineThread[ 64 ];
  long iLen1, iLen2;
  static HANDLE g_hEngineMainThread = NULL;
  static HANDLE g_hEngineProcess = NULL;

  /* Try to load the engine */
  switch( engineType )
  {
  case ENGINE_EXE:
	  if( !g_hEngineProcess )
	  {
		  STARTUPINFO si;
		  PROCESS_INFORMATION pi;  
		  char szCmdLine[ 3*MAX_PATH + 1 ];

		  iLen1 = iLen2 = (sizeof(szBaseDir)/sizeof(szBaseDir[0]));
		  if( RegQueryValue( HKEY_CURRENT_USER,  KEY_BASEDIR, szBaseDir, &iLen1) != ERROR_SUCCESS &&
			  RegQueryValue( HKEY_LOCAL_MACHINE, KEY_BASEDIR, szBaseDir, &iLen2) != ERROR_SUCCESS )
				return FALSE;

#if defined (SWSOFT_LIB)
		  if( port )
			  mysql_applic_setport( port );
#endif

		  ZeroMemory( &si, sizeof(si) );
		  si.cb = sizeof(si);

		  sprintf( szCmdLine, "--standalone --skip-grant-tables --default-table-type=BTRIEVE_DB --basedir=\"%s\" --datadir=\"%s\"", szBaseDir, szBaseDir );
		  
		  if( !CreateProcess( g_szEngine, szCmdLine, NULL, NULL, FALSE, DETACHED_PROCESS, NULL, NULL, &si, &pi ) )
			  return FALSE;
		  
		  g_hEngineProcess = pi.hProcess;		  
	  }
	  return TRUE;
  
  case NO_ENGINE:
	  strcpy( g_szEngine, MYSQLD_DLL );
	  // fall through
  
  case ENGINE_DLL:
	  if( !g_hEngineMainThread ) 
	  {
		  DWORD dwDummy;

		  if( GetEnvironmentVariable( "EngineStarted", szEngineThread, sizeof(szEngineThread) ) )
  				return TRUE; // nothing to do

		  iLen1 = iLen2 = (sizeof(szBaseDir)/sizeof(szBaseDir[0]));
		  if( RegQueryValue( HKEY_CURRENT_USER,  KEY_BASEDIR, szBaseDir, &iLen1) != ERROR_SUCCESS &&
			  RegQueryValue( HKEY_LOCAL_MACHINE, KEY_BASEDIR, szBaseDir, &iLen2) != ERROR_SUCCESS )
				return FALSE;

#if defined (SWSOFT_LIB)		
		  if( port )
			  mysql_applic_setport( port );
		  else
			  mysql_applic_addref_instance();
#endif

		  if( g_hLib == NULL )
			  g_hLib = LoadLibrary( g_szEngine );	  
		  
		  if( g_hLib == NULL )
			  return FALSE;
			
		  sprintf( g_szBaseDir, "--basedir=%s", szBaseDir );
		  sprintf( g_szDataDir, "--datadir=%s", szBaseDir );

		  g_hEngineMainThread = CreateThread(NULL, 0, MySqlLibMainThreadFunc, NULL, 0, &dwDummy );
		  
		  return g_hEngineMainThread != NULL;		  
	  }
	  return TRUE;

  default:
	  return FALSE;
  }
}

MYSQL *		STDCALL mysql_real_connect2(MYSQL *mysql, const char *host,
					   const char *user,
					   const char *passwd,
#if MYSQL_VERSION_ID >= 32200
					   const char *db,
#endif
#ifdef SWSOFT
					   const char *sysdb,
#endif
					   unsigned int port,
					   const char *unix_socket,
					   unsigned int clientflag,
					   BOOL* bCritical
					   )
{
	char _db[ MAX_PATH + 1 ], _sysdb[ MAX_PATH + 1 ];
	MYSQL *ret = NULL;
	enum EngineTypes engineType = NO_ENGINE;
	const int max_timeout = 5; // 60; // slightly decreased
	time_t tstart;
//	HWND hWnd = NULL;
	

	*bCritical = FALSE;
	*_db = *_sysdb = 0;
//Lex	GetShortPathName( db, _db, MAX_PATH );
	if( !GetShortPathName( db, _db, MAX_PATH ) )
		strcpy(_db, db);
	if( !GetShortPathName( sysdb, _sysdb, MAX_PATH ) )
		strcpy(_sysdb, sysdb);

	engineType = GetEngineInfo();

	if( engineType == NO_ENGINE || engineType == ENGINE_EXE )
		ret = mysql_real_connect(mysql, host, user, passwd, _db, 
		setupdlg_db_type() == SETUPDLG_BTRIEVE ? _sysdb : NULL, 
		port, unix_socket, clientflag );


	// done || cannot be done if engine was not started before
	if( !ret && engineType != NO_ENGINE )
	{
		tstart = time(&tstart);
		
		if( !StartEngine( engineType, sysdb, port ) )
		{
			*bCritical = TRUE;
			return NULL;
		}

#if defined (SWSOFT_LIB)		
		port = mysql_applic_getport();
#endif


		while ( !(ret = mysql_real_connect(mysql, host, user, passwd, 
					_db, _sysdb, port, unix_socket, clientflag ) ) &&
				time(NULL) - tstart  < max_timeout )
		{
			_sleep( 100 );
		}
		
	}

	return ret;
}


//// ******************



int RefreshTableList(HWND hdlg)
{
	char dsn[1024];
//	char _path[ MAX_PATH + 1 ];
	SQLHENV henv;
	SQLHDBC hdbc;
	DBC FAR * dbc;
	char TableName[TBL_NAME_MAX],TablePath[BTRV_MAX_PATH];
	void* res = NULL;
	char path[ MAX_PATH ];
	int idx = 0;

	GetDlgItemText( GetParent(hdlg), IDC_SYSDB, path, sizeof(path) );

	if( SQLAllocEnv(&henv) != SQL_SUCCESS )
	{
		MessageBox( hdlg, "Cannot allocate resources", path, MB_ICONWARNING );
		return -1;
	}
	if( SQLAllocConnect(henv, &hdbc) != SQL_SUCCESS )
	{
		SQLFreeEnv( henv );
		MessageBox( hdlg, "Cannot allocate resources", path, MB_ICONWARNING );
		return -1;
	}
	strcpy( dsn, "DSN=temp;SYSDB=" );
	strcat( dsn, path );

	if( SQLDriverConnect( hdbc, hdlg, dsn, (SQLSMALLINT)strlen(dsn), (SQLCHAR*)NULL, (SQLSMALLINT)0, (SQLSMALLINT*)NULL, (SQLUSMALLINT)SQL_DRIVER_NOPROMPT ) != SQL_SUCCESS )
	{
		SQLFreeConnect( hdbc );
		SQLFreeEnv( henv );
		MessageBox( hdlg, "Cannot connect to driver", path, MB_ICONWARNING );
		return -1;
	}
	dbc = (DBC FAR*) hdbc;



	//ret = mysql_create_systable(&dbc->mysql, _path);

	ListView_DeleteAllItems(GetDlgItem(hdlg, IDC_TABLESINDB));

	res = mysql_enum_tables(&dbc->mysql,  NULL, TableName, TBL_NAME_MAX, TablePath, BTRV_MAX_PATH );

	while (res)
	{
		{
			LVITEM item;
			memset( &item, 0, sizeof(item) );
			item.pszText =TableName;
			item.iSubItem = 0;
			item.mask = LVIF_TEXT;
			item.iItem = idx; // desired idx

			idx = ListView_InsertItem( GetDlgItem(hdlg, IDC_TABLESINDB), &item );
			
			if( idx >= 0 )
			{
				ListView_SetItemText(GetDlgItem(hdlg, IDC_TABLESINDB), idx, 1, TablePath);
				idx++; // next idx
			}
			else
				idx = 0; // error; reset idx
		}
	
		res = mysql_enum_tables(&dbc->mysql,  res, TableName, TBL_NAME_MAX, TablePath, BTRV_MAX_PATH );
	}

	
	SQLDisconnect( hdbc );
	SQLFreeConnect( hdbc );
	SQLFreeEnv( henv );

	return TRUE;
}


int CheckDSN(HWND hdlg)
{
	

	char dsn[1024];
//	char _path[ MAX_PATH + 1 ];
	SQLHENV henv;
	SQLHDBC hdbc;
	DBC FAR * dbc;
//	char TableName[TBL_NAME_MAX],TablePath[BTRV_MAX_PATH];
	void* res = NULL;
	char dsnc[ MAX_PATH ];
	int idx = 0;
	BOOL checked = FALSE;

	GetDlgItemText( hdlg, IDC_SYSDB, dsnc, sizeof(dsnc) );

	if( SQLAllocEnv(&henv) != SQL_SUCCESS )
	{
		//MessageBox( hdlg, "Cannot allocate resources", path, MB_ICONWARNING );
		return FALSE;
	}
	if( SQLAllocConnect(henv, &hdbc) != SQL_SUCCESS )
	{
		SQLFreeEnv( henv );
		//MessageBox( hdlg, "Cannot allocate resources", path, MB_ICONWARNING );
		return FALSE;
	}
	strcpy( dsn, "DSN=temp;SYSDB=" );
	strcat( dsn, dsnc);

	if( SQLDriverConnect( hdbc, hdlg, dsn, (SQLSMALLINT)strlen(dsn), (SQLCHAR*)NULL, (SQLSMALLINT)0, (SQLSMALLINT*)NULL, (SQLUSMALLINT)SQL_DRIVER_NOPROMPT ) != SQL_SUCCESS )
	{
		SQLFreeConnect( hdbc );
		SQLFreeEnv( henv );
		//MessageBox( hdlg, "Cannot connect to driver", path, MB_ICONWARNING );
		return FALSE;
	}
	dbc = (DBC FAR*) hdbc;

/*
	res = mysql_enum_tables(&dbc->mysql,  NULL, TableName, TBL_NAME_MAX, TablePath, BTRV_MAX_PATH );
	
	if (!res)
		checked = FALSE;
	else
		checked = TRUE;
*/	
	SQLDisconnect( hdbc );
	SQLFreeConnect( hdbc );
	SQLFreeEnv( henv );

	return TRUE;
}


int CALLBACK AddRemoveTableDlg (HWND hdlg,WORD wMsg,WPARAM wParam,LPARAM lParam)
{
	LV_COLUMN	lvC;
	RECT rc;
	char szPath[ MAX_PATH ];	
	char szTableName[TBL_NAME_MAX];	
	HWND hList;
	int iSel;


	

 switch (wMsg) {
  case WM_INITDIALOG:
  {
//    Ctl3dRegister (s_hModule);
    SetWindowLong(hdlg, DWL_USER, lParam);
//    Ctl3dSubclassDlg(hdlg, CTL3D_ALL);
    CenterDialog(hdlg); 				// Center dialog
	ListView_SetExtendedListViewStyle(GetDlgItem(hdlg, IDC_TABLESINDB), LVS_EX_FULLROWSELECT );

    // Now initialize the columns you will need.
    // Initialize the LV_COLUMN structure.
    // The mask specifies that the fmt, cx, pszText, and iSubitem
    // members of the structure are valid.
	GetClientRect(GetDlgItem(hdlg, IDC_TABLESINDB),&rc);

    lvC.mask = LVCF_FMT | LVCF_WIDTH | LVCF_TEXT | LVCF_SUBITEM;
    lvC.fmt  = LVCFMT_LEFT;  // left-align the column
    lvC.cx       = (rc.right-rc.left)/3;            // width of column in pixels
    lvC.pszText  = "Table name";
    lvC.iSubItem = 0;
	ListView_InsertColumn(GetDlgItem(hdlg, IDC_TABLESINDB),0, &lvC);
	
	lvC.pszText  = "File name";
	lvC.iSubItem = 1;
	lvC.cx       = rc.right-rc.left - (rc.right-rc.left)/3;
	ListView_InsertColumn(GetDlgItem(hdlg, IDC_TABLESINDB),1, &lvC);

	RefreshTableList(hdlg);

	if (-1 == ListView_GetNextItem(GetDlgItem(hdlg,IDC_TABLESINDB),-1, LVNI_SELECTED))
		//if (-1 == ListView_GetSelectionMark(GetDlgItem(hdlg,IDC_TABLESINDB)))
	{
		//Hide table button if path to system table is empty
		EnableWindow(GetDlgItem(hdlg, IDC_REMOVE_TABLE),FALSE);
	}
	else
	{
		//Hide table button if path to system table is empty
		EnableWindow(GetDlgItem(hdlg, IDC_REMOVE_TABLE),TRUE);
	}
	

    return TRUE;				/* Focus was not set */
  }
/*
  case WM_CTLCOLORBTN:
  case WM_CTLCOLORDLG:
  case WM_CTLCOLOREDIT:
  case WM_CTLCOLORLISTBOX:
  case WM_CTLCOLORMSGBOX:
  case WM_CTLCOLORSCROLLBAR:
  case WM_CTLCOLORSTATIC:
    return (BOOL)Ctl3dCtlColorEx(wMsg, wParam, lParam);
*/
/*
  case WM_SETTEXT:
  case WM_NCPAINT:
  case WM_NCACTIVATE:
    SetWindowLong(hdlg, DWL_MSGRESULT,
		  Ctl3dDlgFramePaint(hdlg, wMsg, wParam, lParam));
    return TRUE;
*/

//  case WM_SYSCOLORCHANGE:
//    return Ctl3dColorChange();

	case WM_HELP:
	  {
			ShowHelp(hdlg,"Overview.htm");
		  return TRUE;
	  }

	  // Process buttons
	case WM_NOTIFY:
		{
			LPNMLISTVIEW pnmh = (LPNMLISTVIEW) lParam; 
			
			if (pnmh->hdr.idFrom == IDC_TABLESINDB)
			{
	
				if (pnmh->hdr.code == LVN_ITEMCHANGED)
				{
	
					if (-1 == ListView_GetNextItem(GetDlgItem(hdlg,IDC_TABLESINDB),-1, LVNI_SELECTED))
					//if (-1 == ListView_GetSelectionMark(GetDlgItem(hdlg,IDC_TABLESINDB)))
					{
						//Hide table button if path to system table is empty
						EnableWindow(GetDlgItem(hdlg, IDC_REMOVE_TABLE),FALSE);
					}
					else
					{
						//Hide table button if path to system table is empty
						EnableWindow(GetDlgItem(hdlg, IDC_REMOVE_TABLE),TRUE);
					}
					
					
					return TRUE;
				}
			}
				///////////////////
			break;
		}
	case WM_COMMAND:
    switch (GET_WM_COMMAND_ID(wParam, lParam)) 
	{
		// Accept results
		case IDOK:
		{
//		  LPSTR tname = (LPSTR)GetWindowLong(hdlg, DWL_USER);
//   		  GetDlgItemText(hdlg, IDC_BTRVTABLE_NAME, tname, 64 );

//		  Ctl3dUnregister (s_hModule);
		  EndDialog(hdlg, wParam);
		  return TRUE;
		}

		// Return to caller
		case IDCANCEL:
		case IDC_SKIP:
//		  Ctl3dUnregister (s_hModule);
		  EndDialog(hdlg, wParam);
		  return TRUE;
		case IDC_ADD_TABLE:
			GetDlgItemText( GetParent(hdlg), IDC_SYSDB, szPath, sizeof(szPath) );
			RegisterTables( FALSE, szPath, hdlg );
			RefreshTableList(hdlg);
			return TRUE;

		case IDC_TABLE_REFRESH:
			SetCursor( LoadCursor(NULL, IDC_WAIT) );			
			RefreshTableList(hdlg);
			SetCursor( LoadCursor(NULL, IDC_ARROW) );			
			return TRUE;
		
		case IDC_REMOVE_TABLE:

			GetDlgItemText( GetParent(hdlg), IDC_SYSDB, szPath, sizeof(szPath) );
			//Removing of the table
 
			hList = GetDlgItem(hdlg, IDC_TABLESINDB);

			iSel = ListView_GetSelectionMark(hList);
			if (iSel != -1)
			{
				ListView_GetItemText(hList, iSel ,0,szTableName,255);
				
				UnRegisterTables(TRUE, szPath,hdlg, szTableName);
				//end removing
				RefreshTableList(hdlg);
			}
			return TRUE;
	 case IDHELP:
	  {
			ShowHelp(hdlg,"Overview.htm");
		  return TRUE;
	  }
    }

	

    break;

  }

  // Message not processed
  return FALSE;
}


int AddRemoveTable( HWND hwnd )
{
	int ret;
	
	ret = DialogBoxParam(s_hModule,
					 MAKEINTRESOURCE(BTRV_TABLES),
					 hwnd,
					 (DLGPROC) AddRemoveTableDlg,
					 (LPARAM)NULL);
	return ret;
}

///////////// *-******************************************-*

#if defined(_LIB)

#define  VALUE_NOT_DEFINED		666 // not -2, -1, 0, 1, 2

int setupdlg_db_type()
{
	static int ret = VALUE_NOT_DEFINED;
	char buf[11];

	if( ret != VALUE_NOT_DEFINED )
		return ret;

	if( !GetEnvironmentVariable( "TargetDbType", buf, 10 ) )
		return ret = SETUPDLG_BTRIEVE;

	ret = stricmp( buf, "MySQL" ) ? SETUPDLG_BTRIEVE : SETUPDLG_MYSQL;

	return ret;
}


BOOL MySqlEngineAvailable()
{
	static BOOL ret = VALUE_NOT_DEFINED;
	enum EngineTypes engineType;
	
	DWORD dwAttrib;
	HINSTANCE hInst;
	HANDLE hEvent;

	if( ret != VALUE_NOT_DEFINED )
		return ret;

	switch( setupdlg_db_type() )
	{
	case SETUPDLG_BTRIEVE:
		engineType = GetEngineInfo();
		dwAttrib = GetFileAttributes( g_szEngine );

		if( engineType == NO_ENGINE || dwAttrib == -1 )
			return ret = 0;

		switch( engineType )
		{
		case ENGINE_DLL:
			return ret = 1;
		case ENGINE_EXE:
			{
				HANDLE hEvent = OpenEvent(EVENT_MODIFY_STATE, FALSE, "MySqlShutdown");
				if( hEvent )
				{
					CloseHandle( hEvent );
					return ret = -2; // EXE already run
				}
			}
			return ret = -1;
		}
		break;

	case SETUPDLG_MYSQL:
		{
		  // Service available ?
		  
		  BOOL bSuc = FALSE;
			
		  SC_HANDLE scm1 = OpenSCManager(0, 0, SC_MANAGER_CONNECT);
		  
		  if( scm1 )  // Install the new service
		  {  
			  SC_HANDLE scm2 = OpenService(scm1, "MySQL", GENERIC_READ);

			  if( scm2 )
			  {
				  SERVICE_STATUS pSTATUS;
      
				  bSuc = QueryServiceStatus(scm2, &pSTATUS) && pSTATUS.dwCurrentState  == SERVICE_RUNNING;

				  CloseServiceHandle( scm2 );
			  }

			  CloseServiceHandle( scm1 );
		  }

		  if( bSuc )
			  return ret = -2;		
		}		

		// DLL available?
		hInst = LoadLibrary( "mysqld.dll" );
		if( hInst )
		{
			FreeLibrary( hInst );
			return ret = 1;
		}

		// EXE already run?
		hEvent = OpenEvent(EVENT_MODIFY_STATE, FALSE, "MySqlShutdown");
		if( hEvent )
		{
			CloseHandle( hEvent );
			return ret = -2;
		}
		
		// EXE available?
		hInst = LoadLibrary( "mysqld.exe" );
		if( hInst )
		{
			FreeLibrary( hInst );
			return ret = -1;
		}

		break;
	}

	return ret = 0;
}

#else // !_LIB

int setupdlg_db_type() { return SETUPDLG_BTRIEVE; }

#endif // _LIB

//#endif //SWSOFT