/* Copyright Abandoned 1996 TCX DataKonsult AB & Monty Program KB & Detron HB
   This file is public domain and comes with NO WARRANTY of any kind */

#ifdef M_I286			/* Defined by MSC and __ZTC__ */
#define M_IC80286
#define MACHINE_TYPE "Intel 80286"
#else
#if defined(M_I386) || defined(WIN32)	/* Defined by MSC and __ZTC__ */
#define M_IC80386
#define MACHINE_TYPE "Intel 80386 or better"
#else
#define M_IC8086
#define MACHINE_TYPE "Intel 8086"
#endif
#endif

#define LONG_MIN	((long) 0x80000000)
#define LONG_MAX	((long) 0x7FFFFFFF)
#define ULONG_MAX	((ulong) 0xFFFFFFFF)
#ifdef M_IC80386
#define INT_MIN		0x80000000
#define INT_MAX		0x7FFFFFFF
#else
#define INT_MIN		0x8000
#define INT_MAX		32767
#endif

#define INT_MIN32	LONG_MIN
#define INT_MAX32	LONG_MAX
#define INT_MIN24	((long) 0xff800000L)
#define INT_MAX24	0x007fffffL
#define INT_MIN16	-32768
#define INT_MAX16	32767
#define INT_MIN8	((char) 0x80)
#define INT_MAX8	((char) 0x7F)

#if defined(__ZTC__)
#define DBL_MIN		2.2250738585072014e-308 /* min positive value */
#define DBL_MAX		0x1.FFFFFFFFFFFFFp1023
#define FLT_MIN		1.175494351e-38F	/* min positive value */
#define FLT_MAX		3.402823466e+38F	/* max value */
#else
#if defined(__WATCOMC__)
#define DBL_MIN		2.22507385850720160e-308
#define DBL_MAX		1.79769313486231560e+308
#define FLT_MIN		1.175494351e-38f
#define FLT_MAX		3.402823466e+38f
#else /* MSC */
#define DBL_MIN		2.2250738585072014e-308 /* min positive value */
#define DBL_MAX		1.7976931348623158e+308 /* max value */
#define FLT_MIN		1.175494351e-38F	/* min positive value */
#define FLT_MAX		3.402823466e+38F	/* max value */
#endif
#endif /* __ZTC__ */
#define NAN_TEST				/* must test for NAN-values */

#if defined(__ZTC__) || defined(__WATCOMC__) || defined(WIN32)
#ifndef M_IC80386
#define HUGE_PTR	_far		/* Compile with virtual or Z model */
#define FAR		_far		/* In far-segment */
#else
#define HUGE_PTR			/* Don't nead huge ptr on 386 */
#ifndef FAR
#define FAR
#endif
#define __huge
#endif /* M_IC80386 */
#else
#ifndef FAR
#define FAR		__far		/* In far-segment */
#endif
#define HUGE_PTR	__huge		/* HUGE is used in ansi */
#endif /* __ZTC__ */

#define ALIGN(A,L)	(((A) + (L) - 1) & ~((L) - 1))
#define ALIGN_SIZE(A)	(((A)+3) & ~3)	/* Size to make adressable obj. */
#define ALIGN_PTR(A, t) ((t*) (((ulong) (A) + 3) & ~3)) /* even is better */
#define OFFSET(t, f)	((size_t)(char *)&((t *)0)->f)
#ifdef __ZTC__
#include <hugeptr.h>
#define ADD_TO_PTR(ptr,size,type) (type) hugeptr_add((byte*) (ptr),(size))
#define PTR_BYTE_DIFF(A,B) hugeptr_diff((byte*) (A),(byte*) (B))
#else
#define FIX_PTR(ptr) (void FAR *)(((unsigned long) (ptr) & 0xFFFF0000) + \
      (((unsigned long) (ptr) & 0xFFF0) << 12) + ((unsigned) (ptr) & 15))
#define ADD_TO_PTR(ptr,size,type) (type) FIX_PTR((byte HUGE_PTR *) (ptr)+(size))
#define PTR_BYTE_DIFF(A,B) ((byte __huge *) (A) - (byte HUGE_PTR *) (B))
#endif

#define NullS		(char *) 0
#ifndef NEAR
#ifdef WIN32
#define NEAR
#else
#define NEAR		_near		/* In standar segment */
#endif
#endif

	/* Typdefs for easyier portability */
typedef char	tchar;		/* A character that shall be used for TEXT
				   -> may be more than one byte. Use tstrcpy
				   ... to copy ... */
typedef void		*gptr;	/* Generic pointer */
typedef unsigned char	uchar;	/* Short for unsigned char */
typedef char		int8;	/* Signed integer >= 8	bits */
typedef short		int16;	/* Signed integer >= 16 bits */
typedef long		int32;	/* Signed integer >= 32 bits */
typedef unsigned char	uint8;	/* Short for unsigned integer >= 8  bits */
typedef unsigned short	uint16; /* Short for unsigned integer >= 16 bits */
typedef unsigned long	uint32; /* Short for unsigned integer >= 32 bits */
typedef unsigned long	ulong;	/* Short for unsigned integer */
#if defined(WIN32)
typedef unsigned __int64	ulonglong;
typedef __int64		longlong;
#else
typedef unsigned long	ulonglong;	/* no long long */
typedef long		longlong;
#endif
typedef uint8		int7;	/* Effektivaste typ 0 <= x <= 127 */
typedef int		int15;	/* Effektivaste typ 0 <= x <= 32767 */
typedef char		*string;/* String of characters */
typedef char		*my_string;/* String of characters */
typedef unsigned int	size_s; /* Size of strings (argument to stringfunc) */
typedef int		myf;	/* Type of MyFlags in my_funcs */
#ifdef __ZTC__
typedef char		byte;	/* Smallest addresable unit */
#else
typedef unsigned char	byte;	/* Smallest addresable unit */
#endif
typedef unsigned int	uint;	/* Short for unsigned int */
typedef unsigned short	ushort;

	/* typedef:s that other programs may define */

typedef char		bool;	/* Ordinary boolean values 0 1 */
typedef char		my_bool;

	/* Macros for converting *constants* to the right type */
#define INT8(v)		(int8) (v)
#define INT16(v)	(int16) (v)
#define INT32(v)	(int32) (v)
#define MYF(v)		(myf) (v)

	/* Defines to make it possible to prioritize register assignments */
#define reg1 register
#define reg2 register
#define reg3
#define reg4
#define reg5
#define reg6
#define reg7
#define reg8
#define reg9
#define reg10
#define reg11
#define reg12
#define reg13
#define reg14
#define reg15
#define reg16

	/* defines for time and alarm functions */

#ifdef M_IC80386
#define MY_HOW_OFTEN_TO_WRITE	100	/* How often we want info on screen */
#else
#define MY_HOW_OFTEN_TO_WRITE	10	/* How often we want info on screen */
#endif
	/* define-functions for storing in machinge-independent format */

#define sint2korr(A)	(*((int16 *) (A)))
#define sint3korr(A)	((int32) ((((uchar) (A)[2]) & 128) ? \
				  (((uint32) 255L << 24) | \
				   (((uint32) (uchar) (A)[2]) << 16) |\
				   (((uint32) (uchar) (A)[1]) << 8) | \
				   ((uint32) (uchar) (A)[0])) : \
				  (((uint32) (uchar) (A)[2]) << 16) |\
				  (((uint32) (uchar) (A)[1]) << 8) | \
				  ((uint32) (uchar) (A)[0])))
#define sint4korr(A)	(*((long *) (A)))
#define uint2korr(A)	(*((uint16 *) (A)))
#define uint3korr(A)	(long) (*((unsigned long *) (A)) & 0xFFFFFF)
#define uint4korr(A)	(*((unsigned long *) (A)))
#define int2store(T,A)	*((uint16*) (T))= (uint16) (A)
#define int3store(T,A)		{ *(T)=  (uchar) ((A));\
				  *(T+1)=(uchar) (((uint) (A) >> 8));\
				  *(T+2)=(uchar) (((A) >> 16)); }
#define int4store(T,A)	*((long *) (T))= (long) (A)

	/* define-funktio ns for reading and storing in machine format */
	/* from/to short/long to/from some place in memory */
	/* V should be a (not register) variable, M is a pointer to byte */

#define ushortget(V,M)	{ V = uint2korr(M); }
#define shortget(V,M)	{ V = sint2korr(M); }
#define longget(V,M)	{ V = sint4korr(M); }
#define ulongget(V,M)	{ V = uint4korr(M); }
#define shortstore(T,V) int2store(T,V)
#define longstore(T,V)	int4store(T,V)
#define doubleget(V,M)	{ *((long *) &V) = *((long*) M); \
			  *(((long *) &V)+1) = *(((long*) M)+1); }
#define doublestore(T,V) { *((long *) T) = *((long*) &V); \
			   *(((long *) T)+1) = *(((long*) &V)+1); }

#define longlongget(V,M) longget(V,M)
#define longlongstore(T,M) longstore(T,M)
#define BYTE_ORDER	FALSE		/* TRUE if high-byte first */
