/* Copyright (C) 2000, 2001  SWsoft, Singapore                                  
 *                                                                              
 *  This program is free software; you can redistribute it and/or modify        
 *  it under the terms of the GNU General Public License as published by        
 *  the Free Software Foundation; either version 2 of the License, or           
 *  (at your option) any later version.                                         
 *                                                                              
 *  This program is distributed in the hope that it will be useful,             
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of              
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               
 *  GNU General Public License for more details.                                
 *                                                                              
 *  You should have received a copy of the GNU General Public License           
 *  along with this program; if not, write to the Free Software                 
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA   
 */

#ifndef _cache_openfile_h_
#define _cache_openfile_h_ 

#include    "cache_val.h"


/**
 * All parameters structure needed to open file
 */
class OpenFileParams {
	START_CLASS();
public:
    /** default constructor */
    OpenFileParams() { CLEAR_CONSTRUCT(OpenFileParams);  }

    /** constructor */
    OpenFileParams( CHAR *lpcaOwner, MT_WORD *lpdataLen, MT_CHAR *lppath_buffer, MT_WORD wOpenMode );

    /** are parameters specify the same file? */
    bool operator ==( const OpenFileParams& cmp ) const;

private:
    friend class OpenSwstFile;

	/** Owner name */
    CHAR       m_caOwner[SWST_OWNER_MAX_LENGTH+1];
	/** data buffer length declaration */
    MT_WORD   m_dataLen;
	/** Full name buffer */
	MT_CHAR   m_path_buffer[_MAX_PATH];
    /** File open name */
    MT_WORD   m_wOpenMode;

	FINISH_CLASS();
};



#endif //_cache_openfile_h_